/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.safehtml.client.HasSafeHtml;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Accessibility;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.UIObject;

public class MenuItem
extends UIObject
implements HasHTML,
HasEnabled,
HasSafeHtml {
    private static final String DEPENDENT_STYLENAME_SELECTED_ITEM = "selected";
    private static final String DEPENDENT_STYLENAME_DISABLED_ITEM = "disabled";
    private Command command;
    private MenuBar parentMenu;
    private MenuBar subMenu;
    private boolean enabled = true;

    public MenuItem(SafeHtml html) {
        this(html.asString(), true);
    }

    public MenuItem(SafeHtml html, Command cmd) {
        this(html.asString(), true, cmd);
    }

    public MenuItem(SafeHtml html, MenuBar subMenu) {
        this(html.asString(), true, subMenu);
    }

    public MenuItem(String text, boolean asHTML, Command cmd) {
        this(text, asHTML);
        this.setCommand(cmd);
    }

    public MenuItem(String text, boolean asHTML, MenuBar subMenu) {
        this(text, asHTML);
        this.setSubMenu(subMenu);
    }

    public MenuItem(String text, Command cmd) {
        this(text, false);
        this.setCommand(cmd);
    }

    public MenuItem(String text, MenuBar subMenu) {
        this(text, false);
        this.setSubMenu(subMenu);
    }

    MenuItem(String text, boolean asHTML) {
        this.setElement(DOM.createTD());
        this.setSelectionStyle(false);
        if (asHTML) {
            this.setHTML(text);
        } else {
            this.setText(text);
        }
        this.setStyleName("gwt-MenuItem");
        DOM.setElementAttribute(this.getElement(), "id", DOM.createUniqueId());
        Accessibility.setRole(this.getElement(), "menuitem");
    }

    public Command getCommand() {
        return this.command;
    }

    public String getHTML() {
        return DOM.getInnerHTML(this.getElement());
    }

    public MenuBar getParentMenu() {
        return this.parentMenu;
    }

    public MenuBar getSubMenu() {
        return this.subMenu;
    }

    public String getText() {
        return DOM.getInnerText(this.getElement());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCommand(Command cmd) {
        this.command = cmd;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.removeStyleDependentName(DEPENDENT_STYLENAME_DISABLED_ITEM);
        } else {
            this.addStyleDependentName(DEPENDENT_STYLENAME_DISABLED_ITEM);
        }
        this.enabled = enabled;
    }

    public void setHTML(SafeHtml html) {
        this.setHTML(html.asString());
    }

    public void setHTML(String html) {
        DOM.setInnerHTML(this.getElement(), html);
    }

    public void setSubMenu(MenuBar subMenu) {
        this.subMenu = subMenu;
        if (this.parentMenu != null) {
            this.parentMenu.updateSubmenuIcon(this);
        }
        if (subMenu != null) {
            FocusPanel.impl.setTabIndex(subMenu.getElement(), -1);
            Accessibility.setState(this.getElement(), "aria-haspopup", "true");
        } else {
            Accessibility.setState(this.getElement(), "aria-haspopup", "false");
        }
    }

    public void setText(String text) {
        DOM.setInnerText(this.getElement(), text);
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        if (this.subMenu != null) {
            this.subMenu.setMenuItemDebugIds(baseID);
        }
    }

    protected void setSelectionStyle(boolean selected) {
        if (selected) {
            this.addStyleDependentName(DEPENDENT_STYLENAME_SELECTED_ITEM);
        } else {
            this.removeStyleDependentName(DEPENDENT_STYLENAME_SELECTED_ITEM);
        }
    }

    void setParentMenu(MenuBar parentMenu) {
        this.parentMenu = parentMenu;
    }
}

