/**
 * SECTION:timestamp
 * @short_description: Convenience functions for dealing with timestamps and dates
 * 
 * <para>include: zeitgeist.h</para><para>A suite of convenience functions for dealing with timestamps and dates.</para><para>Zeitgeist timestamps are represented as <emphasis role="bold">gint64</emphasis>s with the number of milliseconds since the Unix Epoch.</para>
 */
/**
 * zeitgeist_timestamp_from_timeval:
 * @self: the (null) instance
 * @timeval: (in): &nbsp;.  time to convert 
 * 
 * Convert a <link linkend="GTimeVal"><type>GTimeVal</type></link> to an amount of milliseconds since the Unix Epoch
 * 
 * Returns: number of milliseconds since the Unix Epoch 
 */
/**
 * zeitgeist_timestamp_to_timeval:
 * @self: the (null) instance
 * @timestamp: (in): &nbsp;.  to convert 
 * 
 * Write a Zeitgeist timestamp to a <link linkend="GTimeVal"><type>GTimeVal</type></link> instance. Note that Zeitgeist uses only a millisecond resolution, whereas <link linkend="GTimeVal"><type>GTimeVal</type></link> has microsecond resolution. This means that the lower three digits of @tv.tv_usec will always be 0.
 * 
 * Returns: the equivalent <link linkend="GTimeVal"><type>GTimeVal</type></link> instance. 
 */
/**
 * zeitgeist_timestamp_from_now:
 * @self: the (null) instance
 * 
 * Return the current timestamp in milliseconds.
 * 
 * Returns: the timestamp for the current system time, in milliseconds since the Unix Epoch 
 */
/**
 * zeitgeist_timestamp_from_iso8601:
 * @self: the (null) instance
 * @datetime: (in): &nbsp;.  a string containing an ISO8601-conforming datetime 
 * 
 * Parse a timestamp from an ISO8601-encoded string.
 * 
 * Returns: the timestamp represented by the given string, or -1 if it can&apos;t be parsed 
 */
/**
 * zeitgeist_timestamp_to_iso8601:
 * @self: the (null) instance
 * @timestamp: (in): &nbsp;.  a timestamp in milliseconds since the Unix Epoch 
 * 
 * Convert a timestamp to a human-readable ISO8601 format
 * 
 * Returns: a newly allocated string containing the ISO8601 version of the given timestamp 
 */
/**
 * zeitgeist_timestamp_from_date:
 * @self: the (null) instance
 * @date: (in): &nbsp;.  the date to convert 
 * 
 * Convert a <emphasis role="bold">GDate</emphasis> to a Zeitgeist timestamp
 * 
 * Returns: the given date expressed as a timestamp in milliseconds since the Epoch. The timestamp is guaranteed to be roudned off to the midnight of the given date. 
 */
/**
 * zeitgeist_timestamp_from_dmy:
 * @self: the (null) instance
 * @day: (in): &nbsp;.  the day of the month 
 * @month: (in): &nbsp;.  the month of the year 
 * @year: (in): &nbsp;.  the year 
 * 
 * Convert a day, month, year tuple into a Zeitgeist timestamp
 * 
 * Returns: the given date (rounded off to the midnight), expressed as a timestamp in milliseconds since the Epoch, or -1 in case the provided parameters don&apos;t constitute a valid date. 
 */
/**
 * zeitgeist_timestamp_to_date:
 * @self: the (null) instance
 * @timestamp: (in): &nbsp;.  to convert 
 * 
 * Write a timestamp to a <link linkend="GDate"><type>GDate</type></link> structure
 * 
 * Returns: <link linkend="GDate"><type>GDate</type></link> initialized to the given timestamp 
 */
/**
 * zeitgeist_timestamp_next_midnight:
 * @self: the (null) instance
 * @timestamp: (in): &nbsp;.  the Zeitgeist timestamp to find the next midnight for 
 * 
 * Calculate the timestamp for the next midnight after the given timestamp.
 * 
 * <para>If is is already midnight (down to the millisecond), this method will return the value for the next midnight. In other words, you can call this method recursively in order to iterate, forwards in time, over midnights.</para>
 * 
 * Returns: the timestamp for the next midnight after the given timestamp 
 */
/**
 * zeitgeist_timestamp_prev_midnight:
 * @self: the (null) instance
 * @timestamp: (in): &nbsp;.  the Zeitgeist timestamp to find the previous midnight for 
 * 
 * Calculate the timestamp for the midnight just before the given timestamp.
 * 
 * <para>If is is already midnight (down to the millisecond), this method will return the value for the previous midnight. In other words, you can call this method recursively in order to iterate, backwards in time, over midnights.</para>
 * 
 * Returns: the timestamp for the midnight just before the given timestamp 
 */
/**
 * ZEITGEIST_TIMESTAMP_SECOND:
 * 
 * A second represented as a Zeitgeist timestamp (ie. 1000ms)
 */
/**
 * ZEITGEIST_TIMESTAMP_MINUTE:
 * 
 * A minute represented as a Zeitgeist timestamp (ie. 60000ms)
 */
/**
 * ZEITGEIST_TIMESTAMP_HOUR:
 * 
 * An hour represented as a Zeitgeist timestamp (ie. 3600000ms)
 */
/**
 * ZEITGEIST_TIMESTAMP_DAY:
 * 
 * A day represented as a Zeitgeist timestamp (ie. 86400000ms)
 */
/**
 * ZEITGEIST_TIMESTAMP_WEEK:
 * 
 * A week represented as a Zeitgeist timestamp (ie. 604800000ms)
 */
/**
 * ZEITGEIST_TIMESTAMP_YEAR:
 * 
 * A year represented as a Zeitgeist timestamp (ie. 31556952000ms). Be warned that a year is not 365 days, but in fact 365.2425 days, to account for leap years.
 */
