// File is generated by JavaScriptCore/inspector/scripts/CodeGeneratorInspector.py

// Copyright (c) 2013 Apple Inc. All Rights Reserved.
// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
#ifndef InspectorJSFrontendDispatchers_h
#define InspectorJSFrontendDispatchers_h

#include "InspectorJSTypeBuilders.h"
#include <inspector/InspectorFrontendChannel.h>
#include <inspector/InspectorValues.h>
#include <wtf/PassRefPtr.h>
#include <wtf/text/WTFString.h>

namespace Inspector {

#if ENABLE(INSPECTOR)

class JS_EXPORT_PRIVATE InspectorDebuggerFrontendDispatcher {
public:
    InspectorDebuggerFrontendDispatcher(InspectorFrontendChannel* inspectorFrontendChannel) : m_inspectorFrontendChannel(inspectorFrontendChannel) { }
    void globalObjectCleared();
    void scriptParsed(const Inspector::TypeBuilder::Debugger::ScriptId& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, const bool* const isContentScript, const String* const sourceMapURL, const bool* const hasSourceURL);
    void scriptFailedToParse(const String& url, const String& scriptSource, int startLine, int errorLine, const String& errorMessage);
    void breakpointResolved(const Inspector::TypeBuilder::Debugger::BreakpointId& breakpointId, PassRefPtr<Inspector::TypeBuilder::Debugger::Location> location);
        // Named after parameter 'reason' while generating command/event paused.
        struct Reason {
            enum Enum {
                XHR = 24,
                DOM = 25,
                EventListener = 26,
                Exception = 27,
                Assert = 28,
                CSPViolation = 29,
                Other = 30,
            };
        }; // struct Reason
    void paused(PassRefPtr<Inspector::TypeBuilder::Array<Inspector::TypeBuilder::Debugger::CallFrame> > callFrames, Reason::Enum reason, PassRefPtr<Inspector::InspectorObject> data);
    void resumed();
    void didSampleProbe(PassRefPtr<Inspector::TypeBuilder::Debugger::ProbeSample> sample);
private:
    InspectorFrontendChannel* m_inspectorFrontendChannel;
};

class JS_EXPORT_PRIVATE InspectorInspectorFrontendDispatcher {
public:
    InspectorInspectorFrontendDispatcher(InspectorFrontendChannel* inspectorFrontendChannel) : m_inspectorFrontendChannel(inspectorFrontendChannel) { }
    void evaluateForTestInFrontend(int testCallId, const String& script);
    void inspect(PassRefPtr<Inspector::TypeBuilder::Runtime::RemoteObject> object, PassRefPtr<Inspector::InspectorObject> hints);
    void detached(const String& reason);
    void targetCrashed();
private:
    InspectorFrontendChannel* m_inspectorFrontendChannel;
};

class JS_EXPORT_PRIVATE InspectorRuntimeFrontendDispatcher {
public:
    InspectorRuntimeFrontendDispatcher(InspectorFrontendChannel* inspectorFrontendChannel) : m_inspectorFrontendChannel(inspectorFrontendChannel) { }
    void executionContextCreated(PassRefPtr<Inspector::TypeBuilder::Runtime::ExecutionContextDescription> context);
private:
    InspectorFrontendChannel* m_inspectorFrontendChannel;
};



#endif // ENABLE(INSPECTOR)

} // namespace Inspector

#endif // !defined(InspectorJSFrontendDispatchers_h)
