/*
 * Copyright (C) 2006-2023 Apple Inc. All rights reserved.
 * Copyright (C) 2007-2009 Torch Mobile, Inc.
 * Copyright (C) 2010, 2011 Research In Motion Limited. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#ifndef WTF_PLATFORM_GUARD_AGAINST_INDIRECT_INCLUSION
#error "Please #include <wtf/Platform.h> instead of this file directly."
#endif


/* HAVE() - specific system features (headers, functions or similar) that are present or not */
#define HAVE(WTF_FEATURE) (defined HAVE_##WTF_FEATURE && HAVE_##WTF_FEATURE)


#if defined(HAVE_FEATURES_H) && HAVE_FEATURES_H
/* If the included features.h is glibc's one, __GLIBC__ is defined. */
#include <features.h>
#endif


#if CPU(ARM_NEON)
/* All NEON intrinsics usage can be disabled by this macro. */
#define HAVE_ARM_NEON_INTRINSICS 1
#endif

/* FIXME: This should be renamed to WTF_CPU_ARM_IDIV_INSTRUCTIONS and moved to CPU.h */
#if defined(__ARM_ARCH_EXT_IDIV__) || CPU(APPLE_ARMV7S)
#define HAVE_ARM_IDIV_INSTRUCTIONS 1
#endif

#if CPU(ADDRESS64)
#if OS(DARWIN) && !PLATFORM(IOS_FAMILY_SIMULATOR)
#define WTF_OS_CONSTANT_EFFECTIVE_ADDRESS_WIDTH (WTF::getMSBSetConstexpr(MACH_VM_MAX_ADDRESS) + 1)
#else
/* We strongly assume that effective address width is <= 48 in 64bit architectures (e.g. NaN boxing). */
#define WTF_OS_CONSTANT_EFFECTIVE_ADDRESS_WIDTH 48
#endif
#else
#define WTF_OS_CONSTANT_EFFECTIVE_ADDRESS_WIDTH 32
#endif

#if PLATFORM(COCOA)
#define HAVE_AUDIT_TOKEN 1
#endif

#if PLATFORM(COCOA)
#define HAVE_OUT_OF_PROCESS_LAYER_HOSTING 1
#endif

#if PLATFORM(COCOA)
#define HAVE_REMAP_JIT 1
#endif

#if PLATFORM(MAC)
#define HAVE_SEC_KEYCHAIN 1
#endif

#if PLATFORM(MAC)
#define HAVE_HISERVICES 1
#endif

#if PLATFORM(IOS_FAMILY)
#define HAVE_READLINE 1
#endif

#if PLATFORM(IOS_FAMILY) && CPU(ARM_NEON)
#undef HAVE_ARM_NEON_INTRINSICS
#define HAVE_ARM_NEON_INTRINSICS 0
#endif

#if !defined(HAVE_VISIBILITY_PROPAGATION_VIEW) && PLATFORM(IOS_FAMILY)
#define HAVE_VISIBILITY_PROPAGATION_VIEW 1
#endif

#if !defined(HAVE_TIMINGSAFE_BCMP) && (PLATFORM(COCOA) || OS(OPENBSD) || OS(FREEBSD))
#define HAVE_TIMINGSAFE_BCMP 1
#endif

#if !defined(HAVE_STD_FILESYSTEM)
#if __has_include(<filesystem>)
#define HAVE_STD_FILESYSTEM 1
#else
#define HAVE_STD_FILESYSTEM 0
#endif
#endif

#if !defined(HAVE_STD_EXPERIMENTAL_FILESYSTEM)
#if __has_include(<experimental/filesystem>)
#define STD_EXPERIMENTAL_FILESYSTEM 1
#else
#define STD_EXPERIMENTAL_FILESYSTEM 0
#endif
#endif

#if PLATFORM(PLAYSTATION)
#define HAVE_MISSING_STD_FILESYSTEM_PATH_CONSTRUCTOR 1
#endif

/* FIXME: Remove after CMake build enabled on Darwin */
#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_ERRNO_H 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_LANGINFO_H 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_LOCALTIME_R 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_MMAP 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_REGEX_H 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_SIGNAL_H 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_STAT_BIRTHTIME 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_STRNSTR 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_SYS_PARAM_H 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_SYS_TIME_H 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_TM_GMTOFF 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_TM_ZONE 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_TIMEGM 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_PTHREAD_MAIN_NP 1
#endif

#if OS(DARWIN) && (CPU(X86_64) || CPU(ARM64)) && CPU(ADDRESS64)
#define HAVE_INT128_T 1
#endif

#if OS(UNIX) && !OS(FUCHSIA)
#define HAVE_RESOURCE_H 1
#endif

#if OS(UNIX) && !OS(FUCHSIA)
#define HAVE_PTHREAD_SETSCHEDPARAM 1
#endif

#if OS(DARWIN)
#define HAVE_DISPATCH_H 1
#endif

#if OS(DARWIN)
#define HAVE_MADV_FREE 1
#endif

#if OS(DARWIN)
#define HAVE_MADV_FREE_REUSE 1
#endif

#if OS(DARWIN)
#define HAVE_MADV_DONTNEED 1
#endif

#if OS(DARWIN)
#define HAVE_PTHREAD_SETNAME_NP 1
#endif

#if OS(DARWIN)
#define HAVE_READLINE 1
#endif

#if OS(DARWIN) && !defined(BUILDING_WITH_CMAKE)
#define HAVE_SYS_TIMEB_H 1
#endif

#if OS(DARWIN) && __has_include(<mach/mach_exc.defs>) && !PLATFORM(GTK)
#define HAVE_MACH_EXCEPTIONS 1
#endif

#if OS(DARWIN) && __has_include(<mach/memory_entry.h>)
#define HAVE_MACH_MEMORY_ENTRY 1
#endif

#if PLATFORM(MAC)
#define HAVE_HOSTED_CORE_ANIMATION 1
#endif

#if OS(DARWIN) || OS(FUCHSIA) || ((OS(FREEBSD) || OS(NETBSD) || OS(OPENBSD) || OS(LINUX)) && (CPU(X86) || CPU(X86_64) || CPU(ARM) || CPU(ARM64) || CPU(MIPS) || CPU(RISCV64)))
#define HAVE_MACHINE_CONTEXT 1
#endif

#if OS(DARWIN) || (OS(LINUX) && defined(__GLIBC__) && !defined(__UCLIBC__) && !CPU(MIPS))
#define HAVE_BACKTRACE 1
#define HAVE_BACKTRACE_SYMBOLS 1
#endif

#if OS(DARWIN) || OS(LINUX)
#define HAVE_DLADDR 1
#endif

#if OS(WINDOWS)
#define HAVE_ISDEBUGGERPRESENT 1
#endif

#if __has_include(<System/pthread_machdep.h>)
#define HAVE_FAST_TLS 1

#if PLATFORM(MAC) \
    || ((PLATFORM(IOS) || PLATFORM(VISION)) && !PLATFORM(IOS_FAMILY_SIMULATOR) && !PLATFORM(MACCATALYST))
#define HAVE_SIMPLIFIED_FAST_TLS_BASE 1
#endif

#endif

#if COMPILER(GCC_COMPATIBLE)
#define HAVE_COMPUTED_GOTO 1
#endif

#if (CPU(ARM64E) && OS(DARWIN)) || (COMPILER(CLANG) && defined(__ARM_FEATURE_JCVT))
#define HAVE_FJCVTZS_INSTRUCTION 1
#endif

#if (CPU(ARM64E) && OS(DARWIN)) || (COMPILER(CLANG) && defined(__ARM_FEATURE_ATOMICS))
#define HAVE_LSE_INSTRUCTION 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV) && !PLATFORM(MACCATALYST)
#define HAVE_APP_LINKS 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
#define HAVE_CELESTIAL 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
#define HAVE_CORE_ANIMATION_RENDER_SERVER 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST) && !PLATFORM(APPLETV)
#define HAVE_PARENTAL_CONTROLS_WITH_UNBLOCK_HANDLER 1
#endif

// FIXME: Why not APPLETV?
#if PLATFORM(COCOA) && !PLATFORM(APPLETV)
#define HAVE_PARENTAL_CONTROLS 1
#endif

#if PLATFORM(COCOA)
#define HAVE_AVKIT 1
#endif

#if PLATFORM(COCOA)
#define HAVE_MEDIA_ACCESSIBILITY_FRAMEWORK 1
#endif

#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
#define HAVE_APPLE_GRAPHICS_CONTROL 1
#endif

#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
#define HAVE_NSCURSOR 1
#endif

#if !defined(HAVE_QOS_CLASSES) && PLATFORM(COCOA)
#define HAVE_QOS_CLASSES 1
#endif

#if !defined(HAVE_SCHEDULING_POLICIES) && PLATFORM(COCOA)
#define HAVE_SCHEDULING_POLICIES 1
#endif

#if !defined(HAVE_THREAD_TIME_CONSTRAINTS) && OS(DARWIN)
#define HAVE_THREAD_TIME_CONSTRAINTS 1
#endif

#if PLATFORM(COCOA)
#define HAVE_AVASSETREADER 1
#endif

#if PLATFORM(COCOA)
#define HAVE_IOSURFACE 1
#endif

#if PLATFORM(MAC) || PLATFORM(GTK) || PLATFORM(WPE)
#define HAVE_DISPLAY_LINK 1
#endif

#if PLATFORM(MAC)
#define HAVE_RUBBER_BANDING 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(IOS_FAMILY_SIMULATOR)
#define HAVE_IOSURFACE_COREIMAGE_SUPPORT 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(IOS_FAMILY_SIMULATOR) && !PLATFORM(MACCATALYST)
#define HAVE_IOSURFACE_ACCELERATOR 1
#endif

#if PLATFORM(MAC) && !PLATFORM(IOS_FAMILY_SIMULATOR)
#define HAVE_IOSURFACE_SET_OWNERSHIP 1
#endif

#if PLATFORM(MAC) \
    || (PLATFORM(IOS_FAMILY) && !PLATFORM(IOS_FAMILY_SIMULATOR))
// FIXME: Is this really unavailable in the iOS Simulator?
#define HAVE_IOSURFACE_SET_OWNERSHIP_IDENTITY 1
#endif

#if PLATFORM(COCOA)
#define HAVE_NETWORK_CONNECTION_PRIVACY_STANCE 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(IOS_FAMILY_SIMULATOR)
#define HAVE_TASK_IDENTITY_TOKEN 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || (PLATFORM(IOS_FAMILY) && !PLATFORM(IOS_FAMILY_SIMULATOR))
#define HAVE_CG_CONTEXT_SET_OWNER_IDENTITY 1
#endif

#if PLATFORM(MAC)
#define HAVE_NS_ACTIVITY 1
#endif

#if PLATFORM(MAC)
#define HAVE_TOUCH_BAR 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV)
#define HAVE_HSTS_STORAGE_PATH 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_URL_FORMATTING 1
#endif

#if !OS(WINDOWS)
#define HAVE_STACK_BOUNDS_FOR_NEW_THREAD 1
#endif

#if !OS(WINDOWS) && !PLATFORM(PLAYSTATION)
#define HAVE_MEMMEM 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION) || PLATFORM(APPLETV)
#define HAVE_AVCONTENTKEYSESSION 1
#endif

#if !PLATFORM(IOS_FAMILY_SIMULATOR)
#define HAVE_AVCONTENTKEYREPORTGROUP 1
#endif

#if PLATFORM(MAC) \
    || ((PLATFORM(IOS) || PLATFORM(VISION)) && !PLATFORM(IOS_FAMILY_SIMULATOR)) \
    || PLATFORM(MACCATALYST)
#define HAVE_AVCONTENTKEYSESSIONWILLOUTPUTBEOBSCURED 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(IOS_FAMILY_SIMULATOR)
#define HAVE_AVCONTENTKEYSPECIFIER 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_SEC_KEY_PROXY 1
#endif

/* FIXME: Should this be enabled for IOS_FAMILY, not just IOS? */
#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_FOUNDATION_WITH_SAME_SITE_COOKIE_SUPPORT 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION) || PLATFORM(GTK) || PLATFORM(WPE)
#define HAVE_OS_DARK_MODE_SUPPORT 1
#endif

#if PLATFORM(MAC)
#define HAVE_READ_ONLY_SYSTEM_VOLUME 1
#endif

#ifdef __APPLE__
#define HAVE_FUNC_USLEEP 1
#endif

#if PLATFORM(COCOA)
#define HAVE_SEC_ACCESS_CONTROL 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
/* FIXME: SafariServices.framework exists on macOS. It is only used by WebKit on iOS, so the behavior is correct, but the name is misleading. */
#define HAVE_SAFARI_SERVICES_FRAMEWORK 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(WATCHOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_SAFE_BROWSING 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_LINK_PREVIEW 1
#endif

#if PLATFORM(COCOA)
#define HAVE_CFNETWORK_OVERRIDE_SESSION_COOKIE_ACCEPT_POLICY 1
#define HAVE_CFNETWORK_NSURLSESSION_CONNECTION_CACHE_LIMITS 1
#define HAVE_CFNETWORK_METRICS_APIS_V4 1
#endif

#if PLATFORM(COCOA) || (defined(USE_CURL) && USE_CURL)
#define HAVE_ALTERNATIVE_SERVICE 1
#endif

#if PLATFORM(MAC)
#define HAVE_CSCHECKFIXDISABLE 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV)
#define HAVE_MDNS_FAST_REGISTRATION 1
#endif

#if PLATFORM(IOS)
#define HAVE_ARKIT 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_ARKIT_QUICK_LOOK_PREVIEW_ITEM 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST)
#define HAVE_UI_IMPACT_FEEDBACK_GENERATOR 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_UI_WK_DOCUMENT_CONTEXT 1
#define HAVE_UIDATEPICKER_STYLE 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_UI_POINTER_INTERACTION 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_UIKIT_WITH_MOUSE_SUPPORT 1
#define HAVE_UI_PARALLAX_TRANSITION_GESTURE_RECOGNIZER 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_UIKIT_BAR_BUTTON_LAYOUT_CUSTOMIZATION 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_MOUSE_DEVICE_OBSERVATION 1
#endif

#if PLATFORM(MACCATALYST)
#define HAVE_LOOKUP_GESTURE_RECOGNIZER 1
#endif

#if PLATFORM(COCOA)
#define HAVE_ALLOWS_SENSITIVE_LOGGING 1
#endif

#if PLATFORM(COCOA)
#define HAVE_FAIRPLAYSTREAMING_CENC_INITDATA 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
#define HAVE_APP_LINKS_WITH_ISENABLED 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_ROUTE_SHARING_POLICY_LONG_FORM_VIDEO 1
#endif

#if (PLATFORM(IOS) || PLATFORM(VISION)) && !PLATFORM(IOS_SIMULATOR)
#define HAVE_DEVICE_MANAGEMENT 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(MACCATALYST)
#define HAVE_AVPLAYER_RESOURCE_CONSERVATION_LEVEL 1
#endif

#if PLATFORM(COCOA)
#define HAVE_AVPLAYER_SUPRESSES_AUDIO_RENDERING 1
#endif

#if PLATFORM(IOS) || PLATFORM(MAC) || PLATFORM(VISION)
#define HAVE_APP_SSO 1
#endif

#if PLATFORM(COCOA)
#define HAVE_DESIGN_SYSTEM_UI_FONTS 1
#endif

#if PLATFORM(COCOA)
#define HAVE_COOKIE_CHANGE_LISTENER_API 1
#endif

#if PLATFORM(MAC) || (PLATFORM(IOS_FAMILY) && !PLATFORM(IOS_FAMILY_SIMULATOR))
#define HAVE_NEAR_FIELD 1
#endif

#if PLATFORM(COCOA)
#define HAVE_OS_SIGNPOST 1
#endif

#if PLATFORM(COCOA)
#define HAVE_AVASSETWRITERDELEGATE_API 1
#endif

#if PLATFORM(MAC)
#define HAVE_AVPLAYER_VIDEORANGEOVERRIDE 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV)
#define HAVE_CG_PATH_UNEVEN_CORNERS_ROUNDEDRECT 1
#endif

#if PLATFORM(WATCHOS) || PLATFORM(APPLETV) || (PLATFORM(IOS_FAMILY) && !(defined __has_include && __has_include(<CoreFoundation/CFPriv.h>)))
#define HAVE_NSPROGRESS_PUBLISHING_SPI 1
#endif

#if PLATFORM(COCOA)
#define HAVE_GCEXTENDEDGAMEPAD_BUTTONS_THUMBSTICK 1
#endif

#if PLATFORM(MAC)
#define HAVE_MULTIGAMEPADPROVIDER_SUPPORT 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000)
#define HAVE_WIDE_GAMECONTROLLER_SUPPORT 1
#endif

#if PLATFORM(COCOA)
#define HAVE_GCEXTENDEDGAMEPAD_HOME_BUTTON 1
#endif

#if PLATFORM(MAC)
#define HAVE_GCCONTROLLER_HID_DEVICE_CHECK 1
#endif

// Newer versions no longer square continuous haptics (rdar://110338126).
#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED < 140000)
#define HAVE_GCCONTROLLER_REQUIRING_HAPTICS_SQUARING 1
#endif

#if PLATFORM(MAC)
#define HAVE_INCREMENTAL_PDF_APIS 1
#endif

#if PLATFORM(MAC)
#define HAVE_ALTERNATE_ICONS 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_UICONTEXTMENU_LOCATION 1
#endif

#if PLATFORM(COCOA)
#define HAVE_SYSTEM_FEATURE_FLAGS 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_AVOBSERVATIONCONTROLLER 1
#endif

// FIXME: Should this be enabled on other iOS-family platforms?
#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_CANCEL_WEB_TOUCH_EVENTS_GESTURE 1
#endif

#if PLATFORM(MAC)
#define HAVE_DD_HIGHLIGHT_CREATE_WITH_SCALE 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_UISCENE_BASED_VIEW_SERVICE_STATE_NOTIFICATIONS 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(IOS_FAMILY_SIMULATOR) && !PLATFORM(MACCATALYST)
#define HAVE_IOS_JIT_RESTRICTIONS 1
#endif

#if (PLATFORM(MAC) || PLATFORM(MACCATALYST)) && CPU(ARM64)
#define HAVE_MAC_JIT_RESTRICTIONS 1
#endif

#if PLATFORM(MAC)
#define HAVE_AVAUDIO_ROUTING_ARBITER 1
#endif

#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
#define HAVE_MEDIA_USAGE_FRAMEWORK 1
#endif

#if PLATFORM(IOS) || PLATFORM(MAC) || PLATFORM(VISION)
#define HAVE_PASSKIT_INSTALLMENTS 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_PASSKIT_NEW_BUTTON_TYPES 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_PASSKIT_RECURRING_SUMMARY_ITEM 1
#define HAVE_PASSKIT_DEFERRED_SUMMARY_ITEM 1
#define HAVE_PASSKIT_SHIPPING_METHOD_DATE_COMPONENTS_RANGE 1
#define HAVE_PASSKIT_COUPON_CODE 1
#define HAVE_PASSKIT_SHIPPING_CONTACT_EDITING_MODE 1
#define HAVE_PASSKIT_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_SUMMARY_ITEMS 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) || PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_PASSKIT_MODULARIZATION 1
#define HAVE_PASSKIT_AUTOMATIC_RELOAD_SUMMARY_ITEM 1
#define HAVE_PASSKIT_RECURRING_PAYMENTS 1
#define HAVE_PASSKIT_AUTOMATIC_RELOAD_PAYMENTS 1
#define HAVE_PASSKIT_MULTI_MERCHANT_PAYMENTS 1
#define HAVE_PASSKIT_PAYMENT_ORDER_DETAILS 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130300) || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MAX_ALLOWED >= 160400) || PLATFORM(VISION)
#define HAVE_PASSKIT_DEFERRED_PAYMENTS 1
#endif

#if __has_include(<PassKitMacHelperTemp/PKPaymentAuthorizationViewController_Private.h>)
#define HAVE_PASSKIT_MAC_HELPER_TEMP 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_PASSKIT_DEFAULT_SHIPPING_METHOD 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) || PLATFORM(VISION)
#define HAVE_PASSKIT_APPLE_PAY_LATER_AVAILABILITY 1
#endif

#if PLATFORM(IOS) || PLATFORM(MAC) || PLATFORM(VISION)
#define HAVE_DISPLAY_LAYER_BIPLANAR_SUPPORT 1
#endif

#if PLATFORM(COCOA)
#define HAVE_LOGGING_PRIVACY_LEVEL 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
#define HAVE_FRONTBOARD_SYSTEM_APP_SERVICES 1
#endif

#if OS(DARWIN) && CPU(X86_64) && (PLATFORM(MAC) || PLATFORM(MACCATALYST))
#define HAVE_CPU_TRANSLATION_CAPABILITY 1
#endif

#if PLATFORM(MAC) || PLATFORM(GTK)
#define HAVE_APP_ACCENT_COLORS 1
#endif

#if PLATFORM(MAC)
#define HAVE_AVROUTEPICKERVIEW 1
#endif

#if PLATFORM(MAC)
#define HAVE_NSTABLEVIEWSTYLE 1
#endif

#if PLATFORM(MAC)
#define HAVE_AUDIO_OUTPUT_DEVICE_UNIQUE_ID 1
#endif

#if PLATFORM(COCOA)
#define HAVE_CF_PREFS_SET_READ_ONLY 1
#define HAVE_CGIMAGESOURCE_WITH_ACCURATE_LOOP_COUNT 1
#define HAVE_CGIMAGESOURCE_WITH_SET_ALLOWABLE_TYPES 1
#define HAVE_LSDATABASECONTEXT 1
#define HAVE_PRECONNECT_PING 1
#define HAVE_WEBP 1
#define HAVE_IMAGEIO_FIX_FOR_RADAR_59589723 1
#define HAVE_CGS_FIX_FOR_RADAR_97530095 0
#define HAVE_CORE_ANIMATION_FIX_FOR_RADAR_93560567 0
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_UI_EVENT_ATTRIBUTION 1
#define HAVE_UI_FOCUS_EFFECT 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS_FAMILY)
#define HAVE_NETWORK_LOADER 1
#define HAVE_OS_LAUNCHD_JOB 1
#define HAVE_NSURL_EMPTY_PUNYCODE_CHECK 1
#endif

#if PLATFORM(VISION)
#define HAVE_CORE_ANIMATION_SEPARATED_LAYERS 1
#define HAVE_CORE_ANIMATION_SEPARATED_PORTALS 1
#define HAVE_PIP_CONTROLLER 1
#endif

#if (PLATFORM(IOS) || PLATFORM(MAC) || PLATFORM(VISION)) && (defined __has_include && __has_include(<CoreFoundation/CFPriv.h>))
#define HAVE_PASSKIT_INSTALLMENTS_IN_SDK 1
#endif

#if !defined(HAVE_PRIVACY_PROXY_FAIL_CLOSED_FOR_UNREACHABLE_HOSTS) \
    && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MIN_REQUIRED >= 170000))
#define HAVE_PRIVACY_PROXY_FAIL_CLOSED_FOR_UNREACHABLE_HOSTS 1
#endif

#if !defined(HAVE_UI_TEXT_SELECTION_DISPLAY_INTERACTION) \
    && (((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION))
#define HAVE_UI_TEXT_SELECTION_DISPLAY_INTERACTION 1
#endif

#if !defined(HAVE_NETWORK_RESOLUTION_FAILURE_REPORT) \
    && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MIN_REQUIRED >= 170000))
#define HAVE_NETWORK_RESOLUTION_FAILURE_REPORT 1
#endif

#if PLATFORM(MACCATALYST)
#define HAVE_CATALYST_USER_INTERFACE_IDIOM_AND_SCALE_FACTOR 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_PENCILKIT_TEXT_INPUT 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_STYLUS_DEVICE_OBSERVATION 1
#endif

#if PLATFORM(IOS) || PLATFORM(MAC) || PLATFORM(VISION)
#if !defined(HAVE_APPLE_ATTESTATION)
#define HAVE_APPLE_ATTESTATION 1
#endif
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) || PLATFORM(VISION)
#if !defined(HAVE_AVSPEECHSYNTHESIS_SYSTEMVOICE)
#define HAVE_AVSPEECHSYNTHESIS_SYSTEMVOICE 1
#endif
#endif

#if PLATFORM(IOS) || PLATFORM(MAC) || PLATFORM(VISION) || PLATFORM(APPLETV)
#if !defined(HAVE_TCC_IOS_14_BIG_SUR_SPI)
#define HAVE_TCC_IOS_14_BIG_SUR_SPI 1
#endif
#endif

#if COMPILER(GCC_COMPATIBLE) && defined(__has_attribute)
#if __has_attribute(objc_direct)
#if !defined(HAVE_NS_DIRECT_SUPPORT)
#define HAVE_NS_DIRECT_SUPPORT 1
#endif
#endif
#endif

#if PLATFORM(COCOA)
#if !defined(HAVE_CG_CONTEXT_DRAW_PATH_DIRECT)
#define HAVE_CG_CONTEXT_DRAW_PATH_DIRECT 1
#endif
#endif

#if PLATFORM(COCOA) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV)
#define HAVE_CONTACTSUI 1
#define HAVE_CONTACTS 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV)
#define HAVE_CNCONTACTPICKERVIEWCONTROLLER 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV)
#define HAVE_SPEECHRECOGNIZER 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(MAC) || PLATFORM(VISION) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MIN_REQUIRED >= 170000)
#define HAVE_AVCAPTUREDEVICE 1
#endif

#if PLATFORM(MAC) && defined __has_include && __has_include(<CoreFoundation/CFPriv.h>)
#define HAVE_SANDBOX_MESSAGE_FILTERING 1
#endif

#if ((PLATFORM(IOS) || PLATFORM(VISION)) && !PLATFORM(IOS_FAMILY_SIMULATOR)) || PLATFORM(MAC)
#define HAVE_COREVIDEO_COMPRESSED_PIXEL_FORMAT_TYPES 1
#endif

#if PLATFORM(COCOA)
#define HAVE_APPLE_LOW_POWER_MODE_SUPPORT 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_ASC_AUTH_UI 1
#endif

#if PLATFORM(IOS) \
    || PLATFORM(MAC) \
    || PLATFORM(VISION)
#define HAVE_ASC_WEBKIT_SPI 1
#endif

#if PLATFORM(MAC)
#if !defined(HAVE_MT_PLUGIN_FORMAT_READER)
#define HAVE_MT_PLUGIN_FORMAT_READER 1
#endif
#endif

#if PLATFORM(MAC)
#if !defined(HAVE_MT_PLUGIN_SAMPLE_CURSOR_PLAYABLE_HORIZON)
#define HAVE_MT_PLUGIN_SAMPLE_CURSOR_PLAYABLE_HORIZON 1
#endif
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(VISION) || PLATFORM(APPLETV)
#define HAVE_AVCONTENTKEYREQUEST_PENDING_PROTECTION_STATUS 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MAX_ALLOWED >= 160100) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MAX_ALLOWED >= 160100) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MAX_ALLOWED >= 90100) \
    || PLATFORM(VISION)
#define HAVE_AVCONTENTKEYREQUEST_COMPATABILITIY_MODE 1
#endif

#if __has_include(<AVFoundation/AVPlayerInterstitialEventController.h>)
#if !defined(HAVE_AVFOUNDATION_INTERSTITIAL_EVENTS)
#define HAVE_AVFOUNDATION_INTERSTITIAL_EVENTS 1
#endif
#endif

#if PLATFORM(WATCHOS)
#define HAVE_PEPPER_UI_CORE 1
#endif

#if PLATFORM(WATCHOS)
#define HAVE_QUICKBOARD_COLLECTION_VIEWS 1
#define HAVE_QUICKBOARD_CONTROLLER 1
#define HAVE_PUIC_BUTTON_TYPE_PILL 1
#endif

#if PLATFORM(COCOA)
#define HAVE_CORE_GRAPHICS_CREATE_EXTENDED_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_EXTENDED_ADOBE_RGB_1998_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_EXTENDED_DISPLAY_P3_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_EXTENDED_ITUR_2020_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_EXTENDED_ROMMRGB_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_ADOBE_RGB_1998_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_DISPLAY_P3_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_EXTENDED_LINEAR_SRGB_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_EXTENDED_SRGB_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_ITUR_2020_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_LINEAR_SRGB_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_ROMMRGB_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_XYZ_COLOR_SPACE 1
#define HAVE_CORE_GRAPHICS_CONIC_GRADIENTS 1
#endif

#if PLATFORM(MAC)
#define HAVE_STATIC_FONT_REGISTRY 1
#define HAVE_DATA_DETECTORS_MAC_ACTION 1
#define HAVE_NSSCROLLVIEW_SEPARATOR_TRACKING_ADAPTER 1
#endif

#if PLATFORM(MAC) \
    || PLATFORM(IOS) \
    || PLATFORM(VISION)
// FIXME: Does this intend to exclude macCatalyst?
#define HAVE_RSA_BSSA 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV)
#define HAVE_PASTEBOARD_ITEM_PROVIDERS 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV) && !PLATFORM(MACCATALYST)
#define HAVE_PASTEBOARD_PRESENTATION_STYLE_AND_TEAM_DATA 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
#define HAVE_NSURL_TITLE 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_PDFKIT 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(WATCHOS)
#define HAVE_VISION 1
#endif

#if PLATFORM(COCOA)
#define HAVE_RSA_PSS_OID 1
#endif

#if PLATFORM(COCOA)
#define HAVE_VIDEO_RESTRICTED_DECODING 1
#endif

#if PLATFORM(MAC) \
    || PLATFORM(IOS_FAMILY)
#define HAVE_CFNETWORK_NSURLSESSION_ATTRIBUTED_BUNDLE_IDENTIFIER 1
#define HAVE_CFNETWORK_NSURLSESSION_HSTS_WITH_UNTRUSTED_ROOT 1
#define HAVE_NSURLSESSION_TASK_DELEGATE 1
#define HAVE_AUDIO_OBJECT_PROPERTY_ELEMENT_MAIN 1
#define HAVE_IOKIT_MAIN_PORT 1
#define HAVE_IMAGE_RESTRICTED_DECODING 1
#define HAVE_XPC_CONNECTION_COPY_INVALIDATION_REASON 1
#endif

#if ((PLATFORM(IOS) || PLATFORM(VISION)) && !PLATFORM(IOS_SIMULATOR)) \
    || PLATFORM(MACCATALYST) \
    || PLATFORM(MAC)
#define HAVE_ASV_INLINE_PREVIEW 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(MAC) || PLATFORM(VISION)
#define HAVE_NSURLPROTOCOL_WITH_SKIPAPPSSO 1
#endif

#if (PLATFORM(IOS) || PLATFORM(MACCATALYST)) \
    || PLATFORM(MAC) \
    || PLATFORM(VISION)
#define HAVE_UPDATE_WEB_ACCESSIBILITY_SETTINGS 1
#endif

#if PLATFORM(COCOA)
#define HAVE_CORE_TEXT_SBIX_IMAGE_SIZE_FUNCTIONS 1
#define HAVE_WOFF_SUPPORT 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#if !defined(HAVE_VK_IMAGE_ANALYSIS)
#define HAVE_VK_IMAGE_ANALYSIS 1
#endif
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#if !defined(HAVE_VK_IMAGE_ANALYSIS_FOR_MACHINE_READABLE_CODES)
#define HAVE_VK_IMAGE_ANALYSIS_FOR_MACHINE_READABLE_CODES 1
#endif
#endif

#if !defined(HAVE_VK_IMAGE_ANALYSIS_TYPE_IMAGE_SEGMENTATION) \
    && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MAX_ALLOWED >= 130000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MAX_ALLOWED >= 160400)) \
    || PLATFORM(VISION)
#define HAVE_VK_IMAGE_ANALYSIS_TYPE_IMAGE_SEGMENTATION 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_PER_APP_ACCESSIBILITY_PREFERENCES 1
#endif

#if (PLATFORM(IOS_FAMILY) && !PLATFORM(IOS_FAMILY_SIMULATOR)) || PLATFORM(MACCATALYST) || PLATFORM(MAC)
#define HAVE_PAC_SHARED_REGION_ID 1
#endif

#if !defined(HAVE_QUICKLOOK_PREVIEW_ITEM_DATA_PROVIDER) \
    && PLATFORM(MAC)
#define HAVE_QUICKLOOK_PREVIEW_ITEM_DATA_PROVIDER 1
#define HAVE_QUICKLOOK_ITEM_PREVIEW_OPTIONS 1
#define HAVE_QUICKLOOK_PREVIEW_ACTIVITY 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_UITOOLBAR_STANDARD_APPEARANCE 1
#endif

#if !PLATFORM(IOS_FAMILY_SIMULATOR) && !PLATFORM(WATCHOS)
#define HAVE_SYMPTOMS_FRAMEWORK 1
#endif

#if !defined(HAVE_GROUP_ACTIVITIES) && PLATFORM(MAC)
#define HAVE_GROUP_ACTIVITIES 1
#endif

#if PLATFORM(IOS_FAMILY) || PLATFORM(MAC)
#define HAVE_WEBGL_COMPATIBLE_METAL 1
#endif

#if PLATFORM(MAC)
#define HAVE_CMPHOTO_TILE_DECODER_AVAILABLE 1
#endif

#if (PLATFORM(IOS) || PLATFORM(VISION)) && !PLATFORM(IOS_FAMILY_SIMULATOR)
#define HAVE_SYSTEM_STATUS 1
#endif

#if PLATFORM(MAC) \
    || (PLATFORM(IOS_FAMILY) && !PLATFORM(IOS_FAMILY_SIMULATOR))
#define HAVE_CORE_ANIMATION_FIX_FOR_RADAR_78402035 1
#endif

#if PLATFORM(COCOA)
#if !defined(HAVE_CG_COLOR_SPACE_USES_EXTENDED_RANGE)
#define HAVE_CG_COLOR_SPACE_USES_EXTENDED_RANGE 1
#endif
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION) || PLATFORM(APPLETV)
#define HAVE_AVSAMPLEBUFFERVIDEOOUTPUT 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_PHOTOS_UI 1
// FIXME (102246762): Remove this have (and make it true everywhere) when possible.
#if __has_include(<PhotosUICore/PXActivityProgressController.h>)
#define HAVE_PX_ACTIVITY_PROGRESS_CONTROLLER 1
#endif
#endif

#if PLATFORM(MAC) \
    || (PLATFORM(IOS_FAMILY) && !PLATFORM(IOS_FAMILY_SIMULATOR))
#define HAVE_CVBUFFERCOPYATTACHMENTS 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
#define HAVE_AUDIOSESSION_PROCESSASSERTION 1
#endif

// FIXME: Why no catalyst?
#if PLATFORM(IOS) \
    || PLATFORM(WATCHOS) \
    || PLATFORM(APPLETV) \
    || PLATFORM(VISION)
#define HAVE_CORE_LOCATION_WEBSITE_IDENTIFIERS 1
#define HAVE_UIKIT_BAR_BUTTON_LAYOUT_CUSTOMIZATION 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#if !defined(HAVE_UI_EDIT_MENU_INTERACTION)
#define HAVE_UI_EDIT_MENU_INTERACTION 1
#endif
#endif

#if PLATFORM(COCOA)
#define HAVE_CORE_LOCATION 1
// kCLAuthorizationStatusAuthorizedWhenInUse is SPI on macOS until 14.0.
#if PLATFORM(IOS_FAMILY) || (defined __has_include && __has_include(<CoreFoundation/CFPriv.h>)) || __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000
#define HAVE_CORE_LOCATION_AUTHORIZED_WHEN_IN_USE 1
#endif
#endif

#if PLATFORM(MAC)
#define HAVE_SCENEKIT 1
#endif

#if PLATFORM(COCOA)
#define HAVE_WEBGPU_IMPLEMENTATION 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(WATCHOS)
#define HAVE_SHAPE_DETECTION_API_IMPLEMENTATION 1
#endif

#if HAVE(WEBGPU_IMPLEMENTATION) && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) || PLATFORM(IOS) || PLATFORM(VISION))
#define HAVE_COREVIDEO_METAL_SUPPORT COREVIDEO_SUPPORTS_METAL
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000)
#define HAVE_UNIFIED_SPEECHSYNTHESIS_FIX_FOR_81465164 1
#endif

#if PLATFORM(COCOA)
#define HAVE_UNIFORM_TYPE_IDENTIFIERS_FRAMEWORK 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000)
#define HAVE_SCREEN_CAPTURE_KIT 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000)
#define HAVE_SC_CONTENT_SHARING_PICKER 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MIN_REQUIRED >= 170000)
#define HAVE_SANDBOX_STATE_FLAGS 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_UIFINDINTERACTION 1
#endif

#if PLATFORM(MAC)
#define HAVE_NSSCREEN_SAFE_AREA 1
#endif

#if PLATFORM(COCOA)
#define HAVE_CFAUTORELEASE 1
#endif

#if PLATFORM(MAC)
#define HAVE_PLATFORM_SCROLL_MOMENTUM_INTERRUPTION_REASON 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_UIACTIVITYTYPE_SHAREPLAY 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) || PLATFORM(IOS) || PLATFORM(WATCHOS) || PLATFORM(VISION)
#define HAVE_SAFE_BROWSING_RESULT_DETAILS 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS_FAMILY)
#define HAVE_MEMORY_ATTRIBUTION_VM_SHARE_SUPPORT 1
#define HAVE_PROHIBIT_PRIVACY_PROXY 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS_FAMILY)
#define HAVE_MACH_MEMORY_ENTRY_OWNERSHIP_IDENTITY_TOKEN_SUPPORT 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_SKADNETWORK_v4 1
#endif

// FIXME: Why no catalyst?
#if PLATFORM(IOS) \
    || PLATFORM(WATCHOS) \
    || PLATFORM(APPLETV) \
    || PLATFORM(VISION)
#define HAVE_IMAGEIO_CREATE_UNPREMULTIPLIED_PNG 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS_FAMILY)
#define HAVE_CORE_TEXT_FIX_FOR_RADAR_93925620 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_DDRESULT_DISABLE_URL_SCHEME_CHECKING 1
#endif

#if ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS) \
    || PLATFORM(VISION))
#define HAVE_SYSTEM_CONTENT_LS_DATABASE 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#if !defined(HAVE_UIKIT_RESIZABLE_WINDOWS)
#define HAVE_UIKIT_RESIZABLE_WINDOWS 1
#endif
#if !defined(HAVE_UI_WINDOW_SCENE_GEOMETRY_PREFERENCES)
#define HAVE_UI_WINDOW_SCENE_GEOMETRY_PREFERENCES 1
#endif
#endif

#if !defined(HAVE_AUDIO_COMPONENT_SERVER_REGISTRATIONS) && PLATFORM(MAC)
#define HAVE_AUDIO_COMPONENT_SERVER_REGISTRATIONS 1
#endif

#if PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000
#define HAVE_SHARING_SERVICE_PICKER_POPOVER_SPI 1
#define HAVE_SHARING_SERVICE_PICKER_STANDARD_SHARE_MENU_ITEM 1
#endif

#if PLATFORM(MAC)
#define HAVE_ADDITIONAL_APPLE_CAMERA_SERVICE 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS) \
    || PLATFORM(VISION)
#define HAVE_APPLE_PUSH_SERVICE_URL_TOKEN_SUPPORT 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS_FAMILY)
#define HAVE_AVIF 1
#endif

#if PLATFORM(IOS_SIMULATOR)
#define HAVE_CG_IMAGE_SOURCE_AVIF_IMAGE_TYPES_BUG 1
#endif

#if !PLATFORM(IOS_FAMILY) || PLATFORM(VISION)
#define HAVE_MEDIA_VOLUME_PER_ELEMENT 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS_FAMILY)
#if !defined(HAVE_AVSAMPLEBUFFERDISPLAYLAYER_COPYDISPLAYEDPIXELBUFFER)
#define HAVE_AVSAMPLEBUFFERDISPLAYLAYER_COPYDISPLAYEDPIXELBUFFER 1
#endif
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000)
#define HAVE_POWERLOG_TASK_MODE_QUERY 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000)
#define HAVE_NSPREVIEWREPRESENTINGACTIVITYITEM 1
#endif

// FIXME: Surely if we don't have the compiler service on iOS,
// we must not have it on watchOS & tvOS & visionOS either?
#if PLATFORM(WATCHOS) \
    || PLATFORM(APPLETV) \
    || PLATFORM(VISION)
#define HAVE_AGX_COMPILER_SERVICE 1
#endif

#if PLATFORM(MAC)
#define HAVE_GPU_AVAILABILITY_CHECK 1
#endif

#if !defined(HAVE_LOCKDOWN_MODE_PDF_ADDITIONS) && \
    (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000 \
    || (PLATFORM(IOS) && !PLATFORM(IOS_SIMULATOR)) \
    || PLATFORM(VISION))
#define HAVE_LOCKDOWN_MODE_PDF_ADDITIONS 1
#endif

#if PLATFORM(COCOA)
#define HAVE_ACCESSIBILITY_FRAMEWORK 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS_FAMILY)
#define HAVE_DYLD_DLOPEN_IMAGE_HEADER_SPI 1
#endif

#if __has_include(<chirp/chirp.h>)
#define HAVE_CHIRP_SPI 1
#endif

#if __has_include(<mach/shared_region.h>)
#define HAVE_SHARED_REGION_SPI 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(MACCATALYST)
#define HAVE_MEDIAEXPERIENCE_AVSYSTEMCONTROLLER 1
#endif

#if PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_UISCROLLVIEW_ASYNCHRONOUS_SCROLL_EVENT_HANDLING 1
#endif

#if PLATFORM(IOS_FAMILY)
#define HAVE_UI_TEXT_SELECTION_RECT_CUSTOM_HANDLE_INFO 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS_FAMILY)
#define HAVE_CORE_GRAPHICS_GRADIENT_CREATE_WITH_OPTIONS 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS_FAMILY)
#define HAVE_CORE_GRAPHICS_PREMULTIPLIED_INTERPOLATION_GRADIENT 1
#endif

#if (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 160100) || PLATFORM(VISION)
#if !defined(HAVE_UI_WINDOW_SCENE_LIVE_RESIZE)
#define HAVE_UI_WINDOW_SCENE_LIVE_RESIZE 1
#endif
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_CONTINUITY_CAMERA 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION)
#define HAVE_VPIO_DUCKING_LEVEL_API 1
#endif

#if !defined(HAVE_CGSTYLE_CREATE_SHADOW2) \
    && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || PLATFORM(IOS_FAMILY))
#define HAVE_CGSTYLE_CREATE_SHADOW2 1
#endif

#if (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) || PLATFORM(VISION)
#define HAVE_NON_HOSTING_VISIBILITY_PROPAGATION_VIEW 1
#define HAVE_ASD_INSTALL_WEB_ATTRIBUTION_SERVICE 1
#endif

#if PLATFORM(COCOA) && !PLATFORM(IOS_SIMULATOR) && __has_include(<apfs/apfs_fsctl.h>)
#define HAVE_APFS_CACHEDELETE_PURGEABLE 1
#endif

#if (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(WATCHOS) \
    || PLATFORM(APPLETV) \
    || PLATFORM(VISION)
#define HAVE_MEDIAPLAYBACKD 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS_FAMILY)
#define HAVE_AVCAPTUREDEVICE_MINFOCUSLENGTH 1
#endif

#if (PLATFORM(GTK) || PLATFORM(WPE)) && defined(__has_include)
#if __has_include(<gio/gdesktopappinfo.h>)
#define HAVE_GDESKTOPAPPINFO 1
#endif
#endif

#if PLATFORM(IOS) || PLATFORM(VISION) || PLATFORM(MAC)
#define HAVE_TRANSLATION_UI_SERVICES 1
#endif

#if (PLATFORM(IOS) || PLATFORM(WATCHOS) || PLATFORM(APPLETV) || PLATFORM(VISION)) || (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000)
#define HAVE_MACH_BOOTSTRAP_EXTENSION 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000)
#define HAVE_STAGE_MANAGER_NS_WINDOW_COLLECTION_BEHAVIORS 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000)
#define HAVE_SHARING_SERVICE_PICKER_POPOVER_SPI 1
#endif

#if ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 160000) \
    || PLATFORM(VISION))
#if defined __has_include && __has_include(<CoreFoundation/CFPriv.h>)
#define ENABLE_SYSTEM_CONTENT_PATH_SANDBOX_RULES 1
#endif
#endif

#if PLATFORM(IOS) || PLATFORM(VISION)
#define HAVE_PICTUREINPICTUREPLAYERLAYERVIEW 1
#endif

#if ((PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 160100) || PLATFORM(VISION)) \
    && !PLATFORM(IOS_SIMULATOR)
#define HAVE_BCS_LIVE_CAMERA_ONLY_ACTION_SPI 1
#endif

#if ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION))
#define HAVE_SETUSEIOSURFACEFORTILES 1
#endif

#if ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MAX_ALLOWED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MAX_ALLOWED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MAX_ALLOWED >= 100000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MAX_ALLOWED >= 170000) \
    || PLATFORM(VISION))
#if __has_include(<Network/proxy_config.h>)
#define HAVE_NW_PROXY_CONFIG 1
#endif
#endif

#if (PLATFORM(COCOA) && !PLATFORM(WATCHOS))
#define HAVE_CFNETWORK_HOSTOVERRIDE 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) && !PLATFORM(VISION) && !PLATFORM(IOS_FAMILY_SIMULATOR)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(WATCHOS) && !PLATFORM(IOS_FAMILY_SIMULATOR) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000)
#if __has_include(<LockdownMode/LockdownMode.h>)
#define HAVE_LOCKDOWN_MODE_FRAMEWORK 1
#endif
#endif

#if ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000)) \
    || PLATFORM(VISION)
// Only used inside ENABLE(DATA_DETECTION)
#define HAVE_SECURE_ACTION_CONTEXT 1
#endif

#if ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION))
#define HAVE_CFNETWORK_SEPARATE_CREDENTIAL_STORAGE 1
#define HAVE_STRICT_DECODABLE_CNCONTACT 1
#define HAVE_STRICT_DECODABLE_PKCONTACT 1
#define HAVE_STRICT_DECODABLE_NSTEXTTABLE 1
#define HAVE_GB_18030_2022 1
#endif

#if ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(WATCHOS) || PLATFORM(APPLETV) || PLATFORM(VISION)))
#define HAVE_AVAUDIOSESSION 1
#endif

#if ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(IOS) || PLATFORM(WATCHOS) || PLATFORM(VISION)))
#define HAVE_AVAUDIOSESSION_SMARTROUTING 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000)
#define HAVE_NSCOLOR_FILL_COLOR_HIERARCHY 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000)
#define HAVE_APPLE_CAMERA_USER_CLIENT 1
#endif

#if ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION))
#define HAVE_MACH_RANGE_CREATE 1
#endif

#if !defined(HAVE_MACH_EVENTLINK) && (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000)
#define HAVE_MACH_EVENTLINK 1
#endif

#if !defined(HAVE_INLINE_PREDICTIONS) \
    && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION))
#define HAVE_INLINE_PREDICTIONS 1
#endif

#if !defined(HAVE_REDESIGNED_TEXT_CURSOR) \
    && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION))
#define HAVE_REDESIGNED_TEXT_CURSOR 1
#endif

#if !defined(HAVE_AUTOCORRECTION_ENHANCEMENTS) \
    && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION))
#define HAVE_AUTOCORRECTION_ENHANCEMENTS 1
#endif

#if !defined(HAVE_WEB_PRIVACY_FRAMEWORK) && __has_include(<WebPrivacy/WebPrivacy.h>)
#define HAVE_WEB_PRIVACY_FRAMEWORK 1
#endif

#if !defined(HAVE_SYSTEM_SUPPORT_FOR_ADVANCED_PRIVACY_PROTECTIONS) \
    && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION))
#define HAVE_SYSTEM_SUPPORT_FOR_ADVANCED_PRIVACY_PROTECTIONS 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MAX_ALLOWED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000)
#define HAVE_JPEGXL 1
#endif

#if PLATFORM(COCOA)
#define HAVE_HEIC 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 130000)
#define HAVE_LS_SERVER_CONNECTION_STATUS_RELEASE_NOTIFICATIONS_MASK 1
#endif

#if PLATFORM(MAC) && __MAC_OS_X_VERSION_MAX_ALLOWED >= 140000
#define HAVE_NSVIEW_CLIPSTOBOUNDS_API 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MAX_ALLOWED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || PLATFORM(VISION)
#define HAVE_CGIMAGESOURCE_DISABLE_HARDWARE_DECODING 1
#define HAVE_CGIMAGESOURCE_ENABLE_RESTRICTED_DECODING 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MAX_ALLOWED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || PLATFORM(VISION)
#define HAVE_AVURLASSET_ISPLAYABLEEXTENDEDMIMETYPEWITHOPTIONS 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MAX_ALLOWED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000)
#define HAVE_CTFONTCOPYCOLORGLYPHCOVERAGE 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000)
#define HAVE_NSWINDOW_SNAPSHOT_READINESS_HANDLER 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000)
#define HAVE_NSCOLORWELL_SUPPORTS_ALPHA 1
#endif

#if (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MAX_ALLOWED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || PLATFORM(VISION)
#define HAVE_UI_USER_INTERFACE_IDIOM_VISION 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MAX_ALLOWED >= 170000) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000)
#define HAVE_AVSPEECHSYNTHESIS_VOICES_CHANGE_NOTIFICATION 1
#endif

#if PLATFORM(VISION)
#define HAVE_APPLE_THERMAL_MITIGATION_SUPPORT 1
#endif

#if !PLATFORM(VISION)
#define HAVE_IDLE_SLEEP_STATE 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(IOS) \
    || PLATFORM(VISION) \
    || PLATFORM(WATCHOS) \
    || PLATFORM(APPLETV)
#define HAVE_MACH_PORT_CALAYER_CONTENTS 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MIN_REQUIRED >= 170000)
#define HAVE_CGSTYLE_COLORMATRIX_BLUR 1
#endif

#if !defined(HAVE_WEB_AUTHN_AS_MODERN) \
    && ((PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION))
#define HAVE_WEB_AUTHN_AS_MODERN 1
#endif

#if !defined(HAVE_UNIFIED_ASC_AUTH_UI) \
    && (PLATFORM(MAC) \
    || PLATFORM(IOS) \
    || PLATFORM(VISION))
#define HAVE_UNIFIED_ASC_AUTH_UI 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || (PLATFORM(MACCATALYST) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || (PLATFORM(IOS) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000)
#define HAVE_AUDIOFORMATPROPERTY_VARIABLEPACKET_SUPPORTED 1
#endif

#if PLATFORM(IOS) || PLATFORM(VISION) || PLATFORM(APPLETV)
#define HAVE_REPLAYKIT 1
#endif

#if HAVE(AVKIT) && !PLATFORM(APPLETV)
#define HAVE_AVPLAYERCONTROLLER 1
#endif

#if HAVE(AVKIT) && !PLATFORM(APPLETV)
#define HAVE_AVPLAYERLAYERVIEW 1
#endif

#if PLATFORM(MAC) || PLATFORM(IOS) || PLATFORM(MACCATALYST) || PLATFORM(VISION)
#define HAVE_CORE_TELEPHONY 1
#endif

#if PLATFORM(IOS_FAMILY) && !PLATFORM(WATCHOS) && !PLATFORM(APPLETV)
#define HAVE_UI_PASTE_CONFIGURATION 1
#endif

#if (PLATFORM(MAC) && __MAC_OS_X_VERSION_MIN_REQUIRED >= 140000) \
    || ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION) \
    || (PLATFORM(WATCHOS) && __WATCH_OS_VERSION_MIN_REQUIRED >= 100000) \
    || (PLATFORM(APPLETV) && __TV_OS_VERSION_MIN_REQUIRED >= 170000)
#define HAVE_NSURL_ENCODING_INVALID_CHARACTERS 1
#endif

#if ((PLATFORM(IOS) || PLATFORM(MACCATALYST)) && __IPHONE_OS_VERSION_MIN_REQUIRED >= 170000) \
    || PLATFORM(VISION)
#define HAVE_UISCROLLVIEW_ALLOWS_KEYBOARD_SCROLLING 1
#endif

#if !PLATFORM(APPLETV) && !PLATFORM(WATCHOS) && __has_include(<UIKit/_UIAsyncDragInteraction.h>)
#define HAVE_UI_ASYNC_DRAG_INTERACTION 1
#endif

#if !PLATFORM(WATCHOS) && __has_include(<UIKit/_UIContextMenuAsyncConfiguration.h>)
#define HAVE_UI_CONTEXT_MENU_ASYNC_CONFIGURATION 1
#endif

#if !PLATFORM(APPLETV) && !PLATFORM(WATCHOS) && __has_include(<UIKit/UITextCursorDropPositionAnimator.h>)
#define HAVE_UI_TEXT_CURSOR_DROP_POSITION_ANIMATOR 1
#endif

#if __has_include(<UIKit/UIAsyncTextInteraction.h>)
#define HAVE_UI_ASYNC_TEXT_INTERACTION 1
#endif

#if __has_include(<UIKit/UIAsyncTextInteractionDelegate.h>)
#define HAVE_UI_ASYNC_TEXT_INTERACTION_DELEGATE 1
#endif

#if CPU(ARM64)
#define HAVE_FP16_HALF_SUPPORT 1
#endif
