@uses.config.contract_token
Feature: Proxy configuration

    @slow
    @series.lts
    @uses.config.machine_type.lxd-container
    Scenario Outline: Attach command when proxy is configured for uaclient
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I run `pro config set http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://api.snapcraft.io.*
        """
        When I attach `contract_token` with sudo and options `--no-auto-enable`
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `pro status` with sudo
        Then the machine is attached
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set ua_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set ua_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT esm.ubuntu.com.*
        """
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy::esm.ubuntu.com \".*\";
        Acquire::https::Proxy::esm.ubuntu.com \".*\";
        """
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout does not match regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I run `pro config unset ua_apt_http_proxy` with sudo
        And I run `pro config unset ua_apt_https_proxy` with sudo
        And I run `pro refresh config` with sudo
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_http_proxy": "invalidurl",
          "ua_apt_https_proxy": "invalidurls"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"invalidurl\" is not a valid url. Not setting as proxy.
        """
        When I verify that running `pro config set http_proxy=http://host:port` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://host:port\" is not a valid url. Not setting as proxy
        """
        And I verify that running `pro config set ua_apt_https_proxy=https://localhost:12345` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
        When I run `pro config set ua_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set ua_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy::esm.ubuntu.com \".*\";
        Acquire::https::Proxy::esm.ubuntu.com \".*\";
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.xenial
    @series.bionic
    @uses.config.machine_type.lxd-vm
    Scenario Outline: Attach command when proxy is configured
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `pro config set http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I attach `contract_token` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        Then stdout matches regexp:
        """
        Setting Livepatch proxy
        """
        When I run `canonical-livepatch config check-interval=0` with sudo
        And I run `canonical-livepatch refresh` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        And stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io:443.*
        """
        When I run `sleep 120` as non-root
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT livepatch.canonical.com:443.*
        """
        When I run `pro refresh config` with sudo
        Then I will see the following on stdout:
            """
            Setting snap proxy
            Setting Livepatch proxy
            Successfully processed your pro configuration.
            """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "http_proxy": "",
          "https_proxy": ""
        }
        """
        And I run `pro refresh config` with sudo
        Then I will see the following on stdout:
        """
        No proxy set in config; however, proxy is configured for: snap, livepatch.
        See https://discourse.ubuntu.com/t/ubuntu-advantage-client/21788 for more information on pro proxy configuration.
    
        Successfully processed your pro configuration.
        """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "http_proxy": "invalidurl",
          "https_proxy": "invalidurls"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"invalidurl\" is not a valid url. Not setting as proxy.
        """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "https_proxy": "https://localhost:12345"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
    
        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |

    @slow
    @series.lts
    @uses.config.machine_type.lxd-container
    Scenario Outline: Attach command when authenticated proxy is configured for uaclient
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt update` `with sudo` on the `proxy` machine
        And I run `apt install squid apache2-utils -y` `with sudo` on the `proxy` machine
        And I run `htpasswd -bc /etc/squid/passwordfile someuser somepassword` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nauth_param basic program \/usr\/lib\/squid\/basic_ncsa_auth \/etc\/squid\/passwordfile\nacl topsecret proxy_auth REQUIRED\nhttp_access allow topsecret
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `pro config set https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I run `pro config set http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://api.snapcraft.io.*
        """
        When I attach `contract_token` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `pro config set ua_apt_http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set ua_apt_https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT esm.ubuntu.com.*
        """
        When I run `pro refresh config` with sudo
        And I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout does not match regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        And I verify that running `pro config set ua_apt_https_proxy=http://wronguser:wrongpassword@$behave_var{machine-ip proxy}:3128` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://wronguser:wrongpassword@.*:3128\" is not working. Not setting as proxy.
        """
    
        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.xenial
    @series.bionic
    @uses.config.machine_type.lxd-vm
    Scenario Outline: Attach command when authenticated proxy is configured
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt update` `with sudo` on the `proxy` machine
        And I run `apt install squid apache2-utils -y` `with sudo` on the `proxy` machine
        And I run `htpasswd -bc /etc/squid/passwordfile someuser somepassword` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nauth_param basic program \/usr\/lib\/squid\/basic_ncsa_auth \/etc\/squid\/passwordfile\nacl topsecret proxy_auth REQUIRED\nhttp_access allow topsecret
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        And I attach `contract_token` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        Then stdout matches regexp:
        """
        Setting Livepatch proxy
        """
        When I run `canonical-livepatch config check-interval=0` with sudo
        And I run `canonical-livepatch refresh` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io:443.*
        """
        When I run `sleep 120` as non-root
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT livepatch.canonical.com:443.*
        """
    
        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |

    @slow
    @series.lts
    @uses.config.machine_type.lxd-container
    Scenario Outline: Attach command when proxy is configured manually via conf file for uaclient
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "http_proxy": "http://$behave_var{machine-ip proxy}:3128",
          "https_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        # We need this for the route command
        And I attach `contract_token` with sudo and options `--no-auto-enable`
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `pro status` with sudo
        Then the machine is attached
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128",
          "ua_apt_https_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `pro refresh config` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy::esm.ubuntu.com \".*\";
        Acquire::https::Proxy::esm.ubuntu.com \".*\";
        """
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout does not match regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I run `pro config unset ua_apt_http_proxy` with sudo
        And I run `pro config unset ua_apt_https_proxy` with sudo
        And I run `pro refresh config` with sudo
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_http_proxy": "invalidurl",
          "ua_apt_https_proxy": "invalidurls"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"invalidurl\" is not a valid url. Not setting as proxy.
        """
        When I verify that running `pro config set http_proxy=http://host:port` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://host:port\" is not a valid url. Not setting as proxy
        """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_https_proxy": "https://localhost:12345"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
        When I run `pro config set ua_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set ua_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy::esm.ubuntu.com \".*\";
        Acquire::https::Proxy::esm.ubuntu.com \".*\";
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd-container
    Scenario Outline: Attach command when authenticated proxy is configured manually for uaclient
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt update` `with sudo` on the `proxy` machine
        And I run `apt install squid apache2-utils -y` `with sudo` on the `proxy` machine
        And I run `htpasswd -bc /etc/squid/passwordfile someuser somepassword` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nauth_param basic program \/usr\/lib\/squid\/basic_ncsa_auth \/etc\/squid\/passwordfile\nacl topsecret proxy_auth REQUIRED\nhttp_access allow topsecret
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "http_proxy": "http://someuser:somepassword@$behave_var{machine-ip proxy}:3128",
          "https_proxy": "http://someuser:somepassword@$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I attach `contract_token` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_http_proxy": "http://someuser:somepassword@$behave_var{machine-ip proxy}:3128",
          "ua_apt_https_proxy": "http://someuser:somepassword@$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro refresh config` with sudo
        And I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout does not match regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_https_proxy": "http://wronguser:wrongpassword@$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://wronguser:wrongpassword@.*:3128\" is not working. Not setting as proxy.
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd-container
    Scenario Outline: Attach command when proxy is configured globally
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I run `pro config set http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://api.snapcraft.io.*
        """
        # We need this for the route command
        When I run `apt-get install net-tools` with sudo
        # We will guarantee that the machine will only use the proxy when
        # running the pro commands
        And I run `route del default` with sudo
        And I attach `contract_token` with sudo and options `--no-auto-enable`
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `pro status` with sudo
        Then the machine is attached
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT esm.ubuntu.com.*
        """
        # TODO No longer empty, needs researching
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*\";
        Acquire::https::Proxy \".*\";
        """
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout matches regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout matches regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout matches regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I run `pro config unset global_apt_http_proxy` with sudo
        And I run `pro config unset global_apt_https_proxy` with sudo
        And I run `pro refresh config` with sudo
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "global_apt_http_proxy": "invalidurl",
          "global_https_proxy": "invalidurls"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"invalidurl\" is not a valid url. Not setting as proxy.
        """
        When I verify that running `pro config set http_proxy=http://host:port` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://host:port\" is not a valid url. Not setting as proxy
        """
        And I verify that running `pro config set global_apt_https_proxy=https://localhost:12345` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
        When I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*\";
        Acquire::https::Proxy \".*\";
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd-container
    Scenario Outline: Attach command when authenticated proxy is configured globally
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt update` `with sudo` on the `proxy` machine
        And I run `apt install squid apache2-utils -y` `with sudo` on the `proxy` machine
        And I run `htpasswd -bc /etc/squid/passwordfile someuser somepassword` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nauth_param basic program \/usr\/lib\/squid\/basic_ncsa_auth \/etc\/squid\/passwordfile\nacl topsecret proxy_auth REQUIRED\nhttp_access allow topsecret
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `pro config set https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I run `pro config set http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://api.snapcraft.io.*
        """
        When I run `apt-get install net-tools` with sudo
        # We will guarantee that the machine will only use the proxy when
        # running the pro commands
        And I run `route del default` with sudo
        And I attach `contract_token` with sudo and options `--no-auto-enable`
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `pro config set global_apt_http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set global_apt_https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT esm.ubuntu.com.*
        """
        When I run `pro refresh config` with sudo
        And I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout matches regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout matches regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout matches regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        And I verify that running `pro config set global_apt_https_proxy=http://wronguser:wrongpassword@$behave_var{machine-ip proxy}:3128` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://wronguser:wrongpassword@.*:3128\" is not working. Not setting as proxy.
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd-container
    Scenario Outline: Get warning when configuring global or uaclient proxy
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*\";
        Acquire::https::Proxy \".*\";
        """
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout matches regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout matches regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout matches regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I run `pro config set ua_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Warning: Setting the pro scoped apt proxy will overwrite the global apt
        proxy previously set via `pro config`.
        """
        When I run `pro config set ua_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout does not match regexp:
        """
        Warning: Setting the pro scoped apt proxy will overwrite the global apt
        proxy previously set via `pro config`.
        """
        When I run `pro config show` with sudo
        Then stdout matches regexp:
        """
        global_apt_http_proxy +None
        """
        Then stdout matches regexp:
        """
        global_apt_https_proxy +None
        """
        When I run `pro config unset ua_apt_http_proxy` with sudo
        And I run `pro config unset ua_apt_https_proxy` with sudo
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `0`
        Then stdout matches regexp:
        """
        Using deprecated "apt_http_proxy" config field.
        Please migrate to using "global_apt_http_proxy"
        """
        When I run `pro config show` with sudo
        Then stdout matches regexp:
        """
        global_apt_http_proxy +http://$behave_var{machine-ip proxy}:3128
        """
        Then stdout matches regexp:
        """
        apt_http_proxy +None
        """
        When I run `pro config unset global_apt_http_proxy` with sudo
        And I run `pro config unset global_apt_https_proxy` with sudo
        And I run `pro config unset ua_apt_http_proxy` with sudo
        And I run `pro config unset ua_apt_https_proxy` with sudo
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "global_apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128",
          "ua_apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        Error: Setting global apt proxy and pro scoped apt proxy
        at the same time is unsupported.
        Cancelling config process operation.
        """
        When I run `pro config show` with sudo
        Then stdout matches regexp:
        """
        global_apt_http_proxy +http://$behave_var{machine-ip proxy}:3128
        """
        Then stdout matches regexp:
        """
        ua_apt_http_proxy +http://$behave_var{machine-ip proxy}:3128
        """
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*\";
        Acquire::https::Proxy \".*\";
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd-container
    Scenario Outline: apt_http(s)_proxy still works
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
        """
        dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
        """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I attach `contract_token` with sudo
        Then the machine is attached
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Warning: apt_http_proxy has been renamed to global_apt_http_proxy.
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Warning: apt_https_proxy has been renamed to global_apt_https_proxy.
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com
        """
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*:3128\";
        Acquire::https::Proxy \".*:3128\";
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout matches regexp:
        """
        GET.*ubuntu.com/ubuntu/dists
        """
        Then stdout matches regexp:
        """
        GET.*archive.ubuntu.com
        """
        Then stdout matches regexp:
        """
        GET.*security.ubuntu.com
        """
        When I run `pro config unset apt_http_proxy` with sudo
        And I run `pro config unset apt_https_proxy` with sudo
        And I run `pro refresh config` with sudo
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128",
          "apt_https_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        When I run `pro refresh config` with sudo
        Then stdout matches regexp:
        """
        Using deprecated "apt_http_proxy" config field.
        Please migrate to using "global_apt_http_proxy"

        Using deprecated "apt_https_proxy" config field.
        Please migrate to using "global_apt_https_proxy"

        Setting global APT proxy
        Successfully processed your pro configuration.
        """
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*:3128\";
        Acquire::https::Proxy \".*:3128\";
        """
        And I verify that running `pro config set apt_https_proxy=https://localhost:12345` `with sudo` exits `1`
        Then stdout matches regexp:
        """
        Warning: apt_https_proxy has been renamed to global_apt_https_proxy.
        """
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.jammy
    @uses.config.machine_type.lxd-vm
    Scenario: Enable realtime kernel through proxy on a machine with no internet
        Given a `jammy` machine with ubuntu-advantage-tools installed
        When I disable any internet connection on the machine
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `pro config set https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I attach `contract_token` with sudo
        Then stdout matches regexp:
        """
        esm-apps     +yes      +enabled      +Expanded Security Maintenance for Applications
        esm-infra     +yes      +enabled      +Expanded Security Maintenance for Infrastructure
        """
        When I run `pro disable livepatch --assume-yes` with sudo
        When I run `pro enable realtime-kernel` `with sudo` and stdin `y`
        Then stdout matches regexp:
        """
        Installing Real-time kernel packages
        Real-time kernel enabled
        A reboot is required to complete install.
        """

    @series.lts
    @uses.config.machine_type.any
    @uses.config.machine_type.lxd-vm
    Scenario Outline: Support HTTPS-in-HTTPS proxies
        Given a `<release>` `<machine_type>` machine with ubuntu-advantage-tools installed

        # set up a HTTPS proxy
        Given a `jammy` `<machine_type>` machine named `proxy`
        When I run `apt update` `with sudo` on the `proxy` machine
        And I apt install `openssl libssl-dev ssl-cert squid-openssl apache2-utils` on the `proxy` machine
        And I run `openssl req -newkey rsa:4096 -x509 -sha256 -days 3650 -nodes -out ca.crt -keyout ca.key -subj "/C=CN/ST=BJ/O=STS/CN=CA"` `with sudo` on the `proxy` machine
        And I run `openssl genrsa -out $behave_var{machine-name proxy}.lxd.key` `with sudo` on the `proxy` machine
        And I run `openssl req -new -key $behave_var{machine-name proxy}.lxd.key -out $behave_var{machine-name proxy}.lxd.csr -subj "/C=CN/ST=BJ/O=STS/CN=$behave_var{machine-name proxy}.lxd"` `with sudo` on the `proxy` machine
        And I create the file `/home/ubuntu/data.ext` on the `proxy` machine with the following
        """
        authorityKeyIdentifier=keyid,issuer
        basicConstraints=CA:FALSE
        subjectAltName = @alt_names
        [alt_names]
        DNS.1 = $behave_var{machine-name proxy}.lxd
        """
        And I run `openssl x509 -req -in $behave_var{machine-name proxy}.lxd.csr -out $behave_var{machine-name proxy}.lxd.crt -sha256 -CA ca.crt -CAkey ca.key -CAcreateserial -days 3650 -extfile data.ext` `with sudo` on the `proxy` machine
        And I run `htpasswd -bc /etc/squid/passwordfile someuser somepassword` `with sudo` on the `proxy` machine
        And I create the file `/etc/squid/squid.conf` on the `proxy` machine with the following:
        """
        dns_v4_first on
        auth_param basic program /usr/lib/squid/basic_ncsa_auth /etc/squid/passwordfile
        acl topsecret proxy_auth REQUIRED
        acl all src 0.0.0.0/0
        http_access allow topsecret
        http_access deny all
        via off
        forwarded_for delete
        https_port 0.0.0.0:3129 cert=/home/ubuntu/$behave_var{machine-name proxy}.lxd.crt key=/home/ubuntu/$behave_var{machine-name proxy}.lxd.key
        """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine

        # Configure system-under-test to trust the HTTPS proxy
        When I move `proxy` `/home/ubuntu/ca.crt` to `system-under-test` `/usr/local/share/ca-certificates/ca.crt`
        And I run `update-ca-certificates` with sudo
        And I run `systemctl restart snapd.service` with sudo

        # error message to install pycurl
        When I verify that running `pro config set https_proxy=https://someuser:somepassword@$behave_var{machine-name proxy}.lxd:3129` `with sudo` exits `1`
        Then I will see the following on stderr
        """
        To use an HTTPS proxy for HTTPS connections, please install pycurl with `apt install python3-pycurl`
        """

        When I apt install `python3-pycurl`

        # error message on failed auth
        When I verify that running `pro config set https_proxy=https://someuser:wrongpassword@$behave_var{machine-name proxy}.lxd:3129` `with sudo` exits `1`
        Then I will see the following on stderr
        """
        Proxy authentication failed
        """

        When I run `apt remove ca-certificates -y` with sudo
        And I run `rm -f /etc/ssl/certs/ca-certificates.crt` with sudo
        And I verify that running `pro config set https_proxy=https://someuser:somepassword@$behave_var{machine-name proxy}.lxd:3129` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        Failed to access URL: https://.*
        Cannot verify certificate of server
        Please install "ca-certificates" and try again.
        """

        When I run `apt install ca-certificates -y` with sudo
        And I run `update-ca-certificates` with sudo
        And I run `pro config set https_proxy=https://someuser:somepassword@$behave_var{machine-name proxy}.lxd:3129` with sudo
        And I run `pro config set ua_apt_https_proxy=https://someuser:somepassword@$behave_var{machine-name proxy}.lxd:3129` with sudo

        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I attach `contract_token` with sudo and options `--no-auto-enable`
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout contains substring
        """
        CONNECT contracts.canonical.com:443 someuser
        """
        And stdout does not contain substring
        """
        error:transaction-end-before-headers
        """

        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I run `pro enable esm-infra` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout contains substring
        """
        CONNECT esm.ubuntu.com:443 someuser
        """
        And stdout does not contain substring
        """
        error:transaction-end-before-headers
        """

        # Pre-install canonical-livepatch to tell it to trust the cert
        When I run `apt install snapd -y` with sudo
        And I run `snap install canonical-livepatch` with sudo
        And I run shell command `canonical-livepatch config ca-certs=@stdin < /usr/local/share/ca-certificates/ca.crt` with sudo

        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I run `pro enable livepatch` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout contains substring
        """
        CONNECT api.snapcraft.io:443 someuser
        """
        And stdout does not contain substring
        """
        error:transaction-end-before-headers
        """

        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I run `apt-get install hello` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout contains substring
        """
        CONNECT esm.ubuntu.com:443 someuser
        """

        Examples: ubuntu release
           | release | machine_type |
           | bionic  | lxd-vm       |
           | focal   | lxd-vm       |
           | jammy   | lxd-vm       |
           | mantic  | lxd-vm       |
