# Contributing to Ubuntu Pro Client

## Developer Documentation

Developer documentation for the Ubuntu Pro Client project. The topics cover
from the architecture of the project to how you should test any code changes.

### How to Guides

* [How to build](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/howtoguides/building.md)
* [How to run the code formatting tools](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/howtoguides/code_formatting.md)
* [How to run the tests](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/howtoguides/testing.md)
* [How to release a new version](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/howtoguides/how_to_release_a_new_version_of_ua.md)
* [How to use the contract staging environment](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/howtoguides/use_staging_environment.md)
* [How to use the magic attach endpoints](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/howtoguides/how_to_use_magic_attach_endpoints.md)

### Reference

* [Terminology](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/references/terminology.md)
* [Architecture](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/references/architecture.md)
* [Early review sign-off](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/references/early_review_signoff.md)
* [What happens during attach](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/references/what_happens_during_attach.md)
* [Enabling a service](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/references/enabling_a_service.md)
* [Directory layout](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/references/directory_layout.md)
* [Daily Builds](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/references/daily_builds.md)
* [Version String Formatting](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/references/version_string_formatting.md)
* [PR review policy](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/references/pr_review_policy.md)

### Explanation

* [How auto-attach works](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/explanations/how_auto_attach_works.md)

### Documentation

* [Documentation guide](https://github.com/canonical/ubuntu-pro-client/blob/docs/dev-docs/devdocs_styleguide.md)
