@uses.config.contract_token
Feature: Proxy configuration

    @slow
    @series.lts
    @uses.config.machine_type.lxd.container
    Scenario Outline: Attach command when proxy is configured for uaclient
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I run `pro config set http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://api.snapcraft.io.*
        """
        When I attach `contract_token` with sudo and options `--no-auto-enable`
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `pro status` with sudo
        # Just to verify that the machine is attached
        Then stdout matches regexp:
        """
        esm-infra     +yes      +disabled      +Expanded Security Maintenance for Infrastructure
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set ua_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set ua_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT esm.ubuntu.com.*
        """
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy::esm.ubuntu.com \".*\";
        Acquire::https::Proxy::esm.ubuntu.com \".*\";
        """
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout does not match regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I run `pro config unset ua_apt_http_proxy` with sudo
        And I run `pro config unset ua_apt_https_proxy` with sudo
        And I run `pro refresh config` with sudo
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_http_proxy": "invalidurl",
          "ua_apt_https_proxy": "invalidurls"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"invalidurl\" is not a valid url. Not setting as proxy.
        """
        When I verify that running `pro config set http_proxy=http://host:port` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://host:port\" is not a valid url. Not setting as proxy
        """
        And I verify that running `pro config set ua_apt_https_proxy=https://localhost:12345` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
        When I run `pro config set ua_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set ua_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy::esm.ubuntu.com \".*\";
        Acquire::https::Proxy::esm.ubuntu.com \".*\";
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.xenial
    @series.bionic
    @uses.config.machine_type.lxd.vm
    Scenario Outline: Attach command when proxy is configured
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `pro config set http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I attach `contract_token` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        Then stdout matches regexp:
        """
        Setting Livepatch proxy
        """
        When I run `canonical-livepatch config check-interval=0` with sudo
        And I run `canonical-livepatch refresh` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        And stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io:443.*
        """
        When I run `sleep 120` as non-root
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT livepatch.canonical.com:443.*
        """
        When I run `pro refresh config` with sudo
        Then I will see the following on stdout:
            """
            Setting snap proxy
            Setting Livepatch proxy
            Successfully processed your pro configuration.
            """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "http_proxy": "",
          "https_proxy": ""
        }
        """
        And I run `pro refresh config` with sudo
        Then I will see the following on stdout:
        """
        No proxy set in config; however, proxy is configured for: snap, livepatch.
        See https://discourse.ubuntu.com/t/ubuntu-advantage-client/21788 for more information on pro proxy configuration.
    
        Successfully processed your pro configuration.
        """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "http_proxy": "invalidurl",
          "https_proxy": "invalidurls"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"invalidurl\" is not a valid url. Not setting as proxy.
        """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "https_proxy": "https://localhost:12345"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
    
        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |

    @slow
    @series.lts
    @uses.config.machine_type.lxd.container
    Scenario Outline: Attach command when authenticated proxy is configured for uaclient
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt update` `with sudo` on the `proxy` machine
        And I run `apt install squid apache2-utils -y` `with sudo` on the `proxy` machine
        And I run `htpasswd -bc /etc/squid/passwordfile someuser somepassword` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nauth_param basic program \/usr\/lib\/squid\/basic_ncsa_auth \/etc\/squid\/passwordfile\nacl topsecret proxy_auth REQUIRED\nhttp_access allow topsecret
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `pro config set https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I run `pro config set http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://api.snapcraft.io.*
        """
        When I attach `contract_token` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `pro config set ua_apt_http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set ua_apt_https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT esm.ubuntu.com.*
        """
        When I run `pro refresh config` with sudo
        And I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout does not match regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        And I verify that running `pro config set ua_apt_https_proxy=http://wronguser:wrongpassword@$behave_var{machine-ip proxy}:3128` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://wronguser:wrongpassword@.*:3128\" is not working. Not setting as proxy.
        """
    
        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.xenial
    @series.bionic
    @uses.config.machine_type.lxd.vm
    Scenario Outline: Attach command when authenticated proxy is configured
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt update` `with sudo` on the `proxy` machine
        And I run `apt install squid apache2-utils -y` `with sudo` on the `proxy` machine
        And I run `htpasswd -bc /etc/squid/passwordfile someuser somepassword` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nauth_param basic program \/usr\/lib\/squid\/basic_ncsa_auth \/etc\/squid\/passwordfile\nacl topsecret proxy_auth REQUIRED\nhttp_access allow topsecret
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        And I attach `contract_token` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        Then stdout matches regexp:
        """
        Setting Livepatch proxy
        """
        When I run `canonical-livepatch config check-interval=0` with sudo
        And I run `canonical-livepatch refresh` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io:443.*
        """
        When I run `sleep 120` as non-root
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT livepatch.canonical.com:443.*
        """
    
        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |

    @slow
    @series.lts
    @uses.config.machine_type.lxd.container
    Scenario Outline: Attach command when proxy is configured manually via conf file for uaclient
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "http_proxy": "http://$behave_var{machine-ip proxy}:3128",
          "https_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        # We need this for the route command
        And I attach `contract_token` with sudo and options `--no-auto-enable`
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `pro status` with sudo
        # Just to verify that the machine is attached
        Then stdout matches regexp:
        """
        esm-infra     +yes      +disabled      +Expanded Security Maintenance for Infrastructure
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128",
          "ua_apt_https_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `pro refresh config` with sudo
        Then stdout matches regexp:
        """
        Setting UA-scoped APT proxy
        """
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy::esm.ubuntu.com \".*\";
        Acquire::https::Proxy::esm.ubuntu.com \".*\";
        """
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout does not match regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I run `pro config unset ua_apt_http_proxy` with sudo
        And I run `pro config unset ua_apt_https_proxy` with sudo
        And I run `pro refresh config` with sudo
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_http_proxy": "invalidurl",
          "ua_apt_https_proxy": "invalidurls"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"invalidurl\" is not a valid url. Not setting as proxy.
        """
        When I verify that running `pro config set http_proxy=http://host:port` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://host:port\" is not a valid url. Not setting as proxy
        """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_https_proxy": "https://localhost:12345"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
        When I run `pro config set ua_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set ua_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy::esm.ubuntu.com \".*\";
        Acquire::https::Proxy::esm.ubuntu.com \".*\";
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd.container
    Scenario Outline: Attach command when authenticated proxy is configured manually for uaclient
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt update` `with sudo` on the `proxy` machine
        And I run `apt install squid apache2-utils -y` `with sudo` on the `proxy` machine
        And I run `htpasswd -bc /etc/squid/passwordfile someuser somepassword` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nauth_param basic program \/usr\/lib\/squid\/basic_ncsa_auth \/etc\/squid\/passwordfile\nacl topsecret proxy_auth REQUIRED\nhttp_access allow topsecret
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "http_proxy": "http://someuser:somepassword@$behave_var{machine-ip proxy}:3128",
          "https_proxy": "http://someuser:somepassword@$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I attach `contract_token` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_http_proxy": "http://someuser:somepassword@$behave_var{machine-ip proxy}:3128"
          "ua_apt_https_proxy": "http://someuser:somepassword@$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro refresh config` with sudo
        And I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout does not match regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout does not match regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "ua_apt_https_proxy": "http://wronguser:wrongpassword@$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://wronguser:wrongpassword@.*:3128\" is not working. Not setting as proxy.
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd.container
    Scenario Outline: Attach command when proxy is configured globally
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I run `pro config set http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://api.snapcraft.io.*
        """
        # We need this for the route command
        When I run `apt-get install net-tools` with sudo
        # We will guarantee that the machine will only use the proxy when
        # running the pro commands
        And I run `route del default` with sudo
        And I attach `contract_token` with sudo and options `--no-auto-enable`
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `pro status` with sudo
        # Just to verify that the machine is attached
        Then stdout matches regexp:
        """
        esm-infra     +yes      +disabled      +Expanded Security Maintenance for Infrastructure
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT esm.ubuntu.com.*
        """
        # TODO No longer empty, needs researching
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*\";
        Acquire::https::Proxy \".*\";
        """
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout matches regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout matches regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout matches regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I run `pro config unset global_apt_http_proxy` with sudo
        And I run `pro config unset global_apt_https_proxy` with sudo
        And I run `pro refresh config` with sudo
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "global_apt_http_proxy": "invalidurl",
          "global_https_proxy": "invalidurls"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"invalidurl\" is not a valid url. Not setting as proxy.
        """
        When I verify that running `pro config set http_proxy=http://host:port` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://host:port\" is not a valid url. Not setting as proxy
        """
        And I verify that running `pro config set global_apt_https_proxy=https://localhost:12345` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
        When I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*\";
        Acquire::https::Proxy \".*\";
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd.container
    Scenario Outline: Attach command when authenticated proxy is configured globally
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt update` `with sudo` on the `proxy` machine
        And I run `apt install squid apache2-utils -y` `with sudo` on the `proxy` machine
        And I run `htpasswd -bc /etc/squid/passwordfile someuser somepassword` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nauth_param basic program \/usr\/lib\/squid\/basic_ncsa_auth \/etc\/squid\/passwordfile\nacl topsecret proxy_auth REQUIRED\nhttp_access allow topsecret
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `pro config set https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT api.snapcraft.io.*
        """
        When I run `pro config set http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting snap proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://api.snapcraft.io.*
        """
        When I run `apt-get install net-tools` with sudo
        # We will guarantee that the machine will only use the proxy when
        # running the pro commands
        And I run `route del default` with sudo
        And I attach `contract_token` with sudo and options `--no-auto-enable`
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT contracts.canonical.com.*
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `pro config set global_apt_http_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set global_apt_https_proxy=http://someuser:somepassword@$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*CONNECT esm.ubuntu.com.*
        """
        When I run `pro refresh config` with sudo
        And I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout matches regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout matches regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout matches regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        And I verify that running `pro config set global_apt_https_proxy=http://wronguser:wrongpassword@$behave_var{machine-ip proxy}:3128` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        \"http://wronguser:wrongpassword@.*:3128\" is not working. Not setting as proxy.
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd.container
    Scenario Outline: Get warning when configuring global or uaclient proxy
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*\";
        Acquire::https::Proxy \".*\";
        """
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout matches regexp:
        """
        .*GET.*ubuntu.com/ubuntu/dists.*
        """
        Then stdout matches regexp:
        """
        .*GET.*archive.ubuntu.com.*
        """
        Then stdout matches regexp:
        """
        .*GET.*security.ubuntu.com.*
        """
        When I run `pro config set ua_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Warning: Setting the pro scoped apt proxy will overwrite the global apt
        proxy previously set via `pro config`.
        """
        When I run `pro config set ua_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout does not match regexp:
        """
        Warning: Setting the pro scoped apt proxy will overwrite the global apt
        proxy previously set via `pro config`.
        """
        When I run `pro config show` with sudo
        Then stdout matches regexp:
        """
        global_apt_http_proxy +None
        """
        Then stdout matches regexp:
        """
        global_apt_https_proxy +None
        """
        When I run `pro config unset ua_apt_http_proxy` with sudo
        And I run `pro config unset ua_apt_https_proxy` with sudo
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `0`
        Then stdout matches regexp:
        """
        Using deprecated "apt_http_proxy" config field.
        Please migrate to using "global_apt_http_proxy"
        """
        When I run `pro config show` with sudo
        Then stdout matches regexp:
        """
        global_apt_http_proxy +http://$behave_var{machine-ip proxy}:3128
        """
        Then stdout matches regexp:
        """
        apt_http_proxy +None
        """
        When I run `pro config unset global_apt_http_proxy` with sudo
        And I run `pro config unset global_apt_https_proxy` with sudo
        And I run `pro config unset ua_apt_http_proxy` with sudo
        And I run `pro config unset ua_apt_https_proxy` with sudo
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "global_apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128",
          "ua_apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        And I verify that running `pro refresh config` `with sudo` exits `1`
        Then stderr matches regexp:
        """
        Error: Setting global apt proxy and pro scoped apt proxy
        at the same time is unsupported.
        Cancelling config process operation.
        """
        When I run `pro config show` with sudo
        Then stdout matches regexp:
        """
        global_apt_http_proxy +http://$behave_var{machine-ip proxy}:3128
        """
        Then stdout matches regexp:
        """
        ua_apt_http_proxy +http://$behave_var{machine-ip proxy}:3128
        """
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*\";
        Acquire::https::Proxy \".*\";
        """

        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.lts
    @uses.config.machine_type.lxd.container
    Scenario Outline: apt_http(s)_proxy still works
        Given a `<release>` machine with ubuntu-advantage-tools installed
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
        """
        dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
        """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I attach `contract_token` with sudo
        When I run `pro status --format yaml` with sudo
        Then stdout matches regexp:
        """
        attached: true
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        And I run `pro config set apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Warning: apt_http_proxy has been renamed to global_apt_http_proxy.
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        .*HEAD http://archive.ubuntu.com.*
        """
        When I run `pro config set apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        Then stdout matches regexp:
        """
        Warning: apt_https_proxy has been renamed to global_apt_https_proxy.
        Setting global APT proxy
        """
        When I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com
        """
        Then I verify that files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*:3128\";
        Acquire::https::Proxy \".*:3128\";
        """
        When I run `truncate -s 0 /var/log/squid/access.log` `with sudo` on the `proxy` machine
        And I verify `/var/log/squid/access.log` is empty on `proxy` machine
        When I run `apt-get update` with sudo
        And I run `cat /var/log/squid/access.log` `with sudo` on the `proxy` machine
        Then stdout matches regexp:
        """
        CONNECT esm.ubuntu.com:443
        """
        Then stdout matches regexp:
        """
        GET.*ubuntu.com/ubuntu/dists
        """
        Then stdout matches regexp:
        """
        GET.*archive.ubuntu.com
        """
        Then stdout matches regexp:
        """
        GET.*security.ubuntu.com
        """
        When I run `pro config unset apt_http_proxy` with sudo
        And I run `pro config unset apt_https_proxy` with sudo
        And I run `pro refresh config` with sudo
        Then I verify that no files exist matching `/etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy`
        When I create the file `/var/lib/ubuntu-advantage/user-config.json` with the following:
        """
        {
          "apt_http_proxy": "http://$behave_var{machine-ip proxy}:3128"
          "apt_https_proxy": "http://$behave_var{machine-ip proxy}:3128"
        }
        """
        When I run `pro refresh config` with sudo
        Then stdout matches regexp:
        """
        Using deprecated "apt_http_proxy" config field.
        Please migrate to using "global_apt_http_proxy"

        Using deprecated "apt_https_proxy" config field.
        Please migrate to using "global_apt_https_proxy"

        Setting global APT proxy
        Successfully processed your pro configuration.
        """
        When I run `cat /etc/apt/apt.conf.d/90ubuntu-advantage-aptproxy` with sudo
        Then stdout matches regexp:
        """
        /\*
         \* Autogenerated by ubuntu-advantage-tools
         \* Do not edit this file directly
         \*
         \* To change what ubuntu-advantage-tools sets, use the `pro config set`
         \* or the `pro config unset` commands to set/unset either:
         \*      global_apt_http_proxy and global_apt_https_proxy
         \* for a global apt proxy
         \* or
         \*      ua_apt_http_proxy and ua_apt_https_proxy
         \* for an apt proxy that only applies to Ubuntu Pro related repos.
         \*/
        Acquire::http::Proxy \".*:3128\";
        Acquire::https::Proxy \".*:3128\";
        """
        And I verify that running `pro config set apt_https_proxy=https://localhost:12345` `with sudo` exits `1`
        Then stdout matches regexp:
        """
        Warning: apt_https_proxy has been renamed to global_apt_https_proxy.
        """
        Then stderr matches regexp:
        """
        \"https://localhost:12345\" is not working. Not setting as proxy.
        """
        Examples: ubuntu release
           | release |
           | xenial  |
           | bionic  |
           | focal   |
           | jammy   |

    @slow
    @series.jammy
    @uses.config.machine_type.lxd.vm
    Scenario: Enable realtime kernel through proxy on a machine with no internet
        Given a `jammy` machine with ubuntu-advantage-tools installed
        When I disable any internet connection on the machine
        Given a `focal` machine named `proxy`
        When I run `apt install squid -y` `with sudo` on the `proxy` machine
        And I add this text on `/etc/squid/squid.conf` on `proxy` above `http_access deny all`:
            """
            dns_v4_first on\nacl all src 0.0.0.0\/0\nhttp_access allow all
            """
        And I run `systemctl restart squid.service` `with sudo` on the `proxy` machine
        And I run `pro config set https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_http_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I run `pro config set global_apt_https_proxy=http://$behave_var{machine-ip proxy}:3128` with sudo
        And I attach `contract_token` with sudo
        Then stdout matches regexp:
        """
        esm-apps     +yes      +enabled      +Expanded Security Maintenance for Applications
        esm-infra     +yes      +enabled      +Expanded Security Maintenance for Infrastructure
        """
        When I run `pro enable realtime-kernel --beta` `with sudo` and stdin `y`
        Then stdout matches regexp:
        """
        Installing Real-time kernel packages
        Real-time kernel enabled
        A reboot is required to complete install.
        """
