#!/usr/bin/perl
#
# a small perl script to make pdf booklet using pdfLaTeX and pdfpages.
# written by Dohyun Kim.

sub Usage {
    die "Read infile PDF and make outfile PDF booklet.\n",
    "Usage: $0 infile[.pdf] outfile[.pdf]\n\n";
    " Copyright (C) 2005 Dohyun Kim\n";
}

@ARGV == 2 or Usage();
$infile = shift @ARGV;
$infile =~ s/\.pdf$//;
$outfile = shift @ARGV;
$outfile =~ s/\.pdf$//;
$infile eq $outfile and Usage();
$infile .= ".pdf";

# we need xpdf-utils package here!
for (`pdfinfo $infile`) {
    if(/^Pages:\s*(\d+)/) {
        $signature = $1 + (4 - $1 % 4) % 4;
        last;
    }
}
$signature or die "`pdfinfo' failed! Install xpdf utils properly.\n";

open OUT,">$outfile.tex" or die $!;
print OUT "\\documentclass[a4paper]{article}
\\usepackage[pdftex]{graphicx}
\\usepackage{pdfpages}
\\begin{document}
\\pagestyle{empty}
\\includepdf[pages=-,signature=$signature,landscape]{$infile}
\\end{document}
";
close OUT;

system("pdflatex $outfile");
$? >> 8 and die "`pdflatex' failed! Install PDFTeX properly.\n";
unlink("$outfile.aux","$outfile.log","$outfile.tex");
