#![allow(unused_assignments)]
// failure-status: 101

fn might_fail_assert(one_plus_one: u32) {
    println!("does 1 + 1 = {}?", one_plus_one);
    assert_eq!(1 + 1, one_plus_one, "the argument was wrong");
}

fn main() -> Result<(),u8> {
    let mut countdown = 10;
    while countdown > 0 {
        if countdown == 1 {
            might_fail_assert(3);
        } else if countdown < 5 {
            might_fail_assert(2);
        }
        countdown -= 1;
    }
    Ok(())
}

// Notes:
//   1. Compare this program and its coverage results to those of the very similar test
//      `panic_unwind.rs`, and similar tests `abort.rs` and `try_error_result.rs`.
//   2. This test confirms the coverage generated when a program passes or fails an `assert!()` or
//      related `assert_*!()` macro.
//   3. Notably, the `assert` macros *do not* generate `TerminatorKind::Assert`. The macros produce
//      conditional expressions, `TerminatorKind::SwitchInt` branches, and a possible call to
//      `begin_panic_fmt()` (that begins a panic unwind, if the assertion test fails).
//   4. `TerminatoKind::Assert` is, however, also present in the MIR generated for this test
//      (and in many other coverage tests). The `Assert` terminator is typically generated by the
//      Rust compiler to check for runtime failures, such as numeric overflows.
