RabbitMQ `3.9.28` is a maintenance release in the `3.9.x` release series.

This series [**reaches end of general support** on Jan 31st, 2023](https://rabbitmq.com/versions.html).

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0)
if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 24.3, and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 support has reached its [end of support](https://www.rabbitmq.com/which-erlang.html).

Starting with this release, RabbitMQ requires Erlang 24.3 or later versions. Nodes **will fail to start** on older Erlang releases.

## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).

### Core Server

#### Enhancements

 * Preserve additional information in the log message when heartbeat frame cannot
   be sent due to a TCP timeout.

   GitHub issue: [#6708](https://github.com/rabbitmq/rabbitmq-server/pull/6708)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl add_vhost` now coerces a single string value of `--tags` into an array.

   GitHub issue: [#6877](https://github.com/rabbitmq/rabbitmq-server/pull/6877)


### Management Plugin

#### Bug Fixes

 * User filtering combined with pagination in the management UI did not work as expected.

   GitHub issue: [#4908](https://github.com/rabbitmq/rabbitmq-server/issues/4908)

 * Correctly format JSON field value in channel detail API response.

   Contributed @Syuparn.

   GitHub issue: [#2684](https://github.com/rabbitmq/rabbitmq-server/issues/2684)


### AMQP 1.0 Plugin

#### Bug Fixes

 * AMQP 1.0 connection churn resulted in a memory leak.

   GitHub issue: [#6969](https://github.com/rabbitmq/rabbitmq-server/issues/6969)


### Web STOMP Plugin

#### Bug Fixes

 * `ERROR` frames delivery is now correctly delivered w.r.t. TCP connection closure for clients that run into
   certain types of exceptions.

   Contributed by @csicar.

   GitHub issue: [#6789](https://github.com/rabbitmq/rabbitmq-server/pull/6789)

## Dependency Upgrades

 * `ra` was upgraded [from `2.4.5` to `2.4.6`](https://github.com/rabbitmq/ra/releases)
 * `prometheus.erl` was upgraded [from `4.9.1` to `4.10.0`](https://github.com/deadtrickster/prometheus.erl/tags)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.28.tar.xz`
instead of the source tarball produced by GitHub.
