# SPDX-License-Identifier: BSD-3-Clause
# Copyright 2017, Intel Corporation
#
# These macros are defined for the m4 preprocessor and are controlled by
# the FREEBSD, WIN32 and WEB variables. These MUST be explicitly defined or
# undefined on the m4 command line.
#
# This solution allows the maintenance of Windows, Linux and FreeBSD
# documentation in the same file.
#
# The macros are:
#
#	_BSDWX(FreeBSD,WinLinux):
#		Choose text based on FREEBSD. Both arguments are optional
#		(although the comma must be present if FreeBSD is omitted).
#		Bracket string with (=q=, =e=) if it contains commas.
#	_DEBUGLIBPATH()
#		Inserts pathnames for debug libraries depending on WIN32 and
#		FREEBSD.
#	_LDLIBPATH()
#		Inserts suggested pathnames for LD_LIBRARY_PATH depending on
#		WIN32 and FREEBSD.
#	_MP(man_page_name, section):
#		Include the man page section number if not building for WEB.
#	_UNICODE():
#		Inserts a standard note regarding UNICODE support if WIN32.
#	_U(func_name):
#		Append "U" to func_name if WIN32.
# 	_UW(func_name):
#		Emit **func_nameU**()/**func_nameW**() if WIN32.
#	_UWFUNC(func_name, args):
#		Define U and W prototypes of char/wchar_t *func_name if WIN32.
#		Bracket args string with (=q=, =e=) if it is a comma-separated
#		list.
#	_UWFUNCR(ret_type, func_name, char_arg):
#		Define U and W prototypes of ret_type func_name if WIN32.
#		Single char/wchar_t argument is char_arg.
#	_UWFUNCRUW(ret_type, func_name, args):
#		Define U and W prototypes of ret_type[U/W] func_name if WIN32.
#		Bracket args string with (=q=, =e=) if it is a comma-separated
#		list.
#	_UWFUNCR1(ret_type, func_name, char_arg, rest_of_args, comment):
#		Define U and W prototypes of ret_type func_name if WIN32.
#		First char/wchar_t argument is char_arg. Bracket rest_of_args
#		string with (=q=, =e=) if it is a comma-separated list.
#		Comment is added after prototype definition if present.
#	_UWFUNCR12(ret_type, func_name, char_arg1, char_arg2, rest_of_args,
#		   comment):
#		Define U and W prototypes of ret_type func_name if WIN32.
#		Two char/wchar_t arguments are char_arg1-2. Bracket
#		rest_of_args string with (=q=, =e=) if it is a comma-separated
#		list. Comment is added after prototype definition if present.
#	_UWFUNCR1UW(ret_type, func_name, arg1_type, arg1, rest_of_args):
#		Define U and W prototypes of ret_type func_name, append [U/W]
#		to arg1_type arg1. Bracket rest_of_args string with (=q=, =e=)
#		if it is a comma-separated list.
#	_UWFUNCR20(ret_type, func_name, arg1, char_arg):
#		Define U and W prototypes of ret_type func_name if WIN32.
#		Second char/wchar_t argument is char_arg.
#	_UWFUNCR2(ret_type, func_name, arg1, char_arg, rest_of_args, comment):
#		Define U and W prototypes of ret_type func_name if WIN32.
#		Second char/wchar_t argument is char_arg. Bracket rest_of_args
#		string with (=q=, =e=) if it is a comma-separated list.
#		Comment is added after prototype definition if present.
#	_UWS(struct_name):
#		Emit *struct struct_nameU*/*struct struct_nameW* if WIN32.
#	_WINUX(Windows,UX):
#		Choose text based on WIN32. Both arguments are optional
#		(although the comma must be present if Windows is omitted).
#		Bracket string with (=q=, =e=) if it contains commas.

changequote(=q=,=e=)
changecom()
define(_BSDWX, ifdef(=q=FREEBSD=e=,$1,$2))
define(_DEBUGLIBPATH, ifdef(=q=WIN32=e=,**/pmdk/src/x64/Debug**,
ifdef(=q=FREEBSD=e=,**/usr/local/lib/pmdk_debug**, **/usr/lib/pmdk_debug**)))
define(_LDLIBPATH, ifdef(=q=WIN32=e=,**/pmdk/src/x64/Debug**,
ifdef(=q=FREEBSD=e=,**/usr/local/lib/pmdk_debug**,
=q==q==q=**/usr/lib/pmdk_debug** or **/usr/lib64/pmdk_debug**, as appropriate=e==e==e=)))
define(_MP, ifdef(=q=WEB=e=,$1,$1($2)))
define(_UNICODE, ifdef(=q=WIN32=e=,=q==q=
>NOTE: The PMDK API supports UNICODE. If the **PMDK_UTF8_API** macro is
defined, basic API functions are expanded to the UTF-8 API with postfix *U*.
Otherwise they are expanded to the UNICODE API with postfix *W*.=e==e=))
define(_U, ifdef(=q=WIN32=e=,$1U,$1))
define(_UW, ifdef(=q=WIN32=e=,**$1U**()/**$1W**(),**$1**()))
define(_UWFUNC, ifdef(=q=WIN32=e=,
const char *$1U($2);
const wchar_t *$1W($2);,
const char *$1($2);))
define(_UWFUNCR, ifdef(=q=WIN32=e=,
$1 $2U(const char $3);
$1 $2W(const wchar_t $3);,
$1 $2(const char $3);))
define(_UWFUNCRUW, ifdef(=q=WIN32=e=,
$1U $2U($3);
$1W $2W($3);,
$1 $2($3);))
define(_UWFUNCR1, ifdef(=q=WIN32=e=,
$1 $2U(const char $3, $4);$5
$1 $2W(const wchar_t $3, $4);$5,
$1 $2(const char $3, $4);$5))
define(_UWFUNCR12, ifdef(=q=WIN32=e=,
$1 $2U(const char $3,
	const char $4, $5);$6
$1 $2W(const wchar_t $3,
	const wchar_t $4, $5);$6,
$1 $2(const char $3,
	const char $4, $5);$6))
define(_UWFUNCR1UW, ifdef(=q=WIN32=e=,
$1 $2U($3U $4, $5);
$1 $2W($3W $4, $5);,
$1 $2($3 $4, $5);))
define(_UWFUNCR20, ifdef(=q=WIN32=e=,
$1 $2U($3, const char $4);
$1 $2W($3, const wchar_t $4);,
$1 $2($3, const char $4);))
define(_UWFUNCR2, ifdef(=q=WIN32=e=,
$1 $2U($3, const char $4, $5);$6
$1 $2W($3, const wchar_t $4, $5);$6,
$1 $2($3, const char $4, $5);$6))
define(_UWS, ifdef(=q=WIN32=e=,*struct $1U*/*struct $1W*,*struct $1*))
define(_WINUX, ifdef(=q=WIN32=e=,$1,$2))
