//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

// <string>

// basic_string<charT,traits,Allocator>& operator+=(const charT* s);

#include <string>
#include <cassert>

#include "min_allocator.h"

template <class S>
void
test(S s, const typename S::value_type* str, S expected)
{
    s += str;
    assert(s.__invariants());
    assert(s == expected);
}

int main()
{
    {
    typedef std::string S;
    test(S(), "", S());
    test(S(), "12345", S("12345"));
    test(S(), "1234567890", S("1234567890"));
    test(S(), "12345678901234567890", S("12345678901234567890"));

    test(S("12345"), "", S("12345"));
    test(S("12345"), "12345", S("1234512345"));
    test(S("12345"), "1234567890", S("123451234567890"));
    test(S("12345"), "12345678901234567890", S("1234512345678901234567890"));

    test(S("1234567890"), "", S("1234567890"));
    test(S("1234567890"), "12345", S("123456789012345"));
    test(S("1234567890"), "1234567890", S("12345678901234567890"));
    test(S("1234567890"), "12345678901234567890", S("123456789012345678901234567890"));

    test(S("12345678901234567890"), "", S("12345678901234567890"));
    test(S("12345678901234567890"), "12345", S("1234567890123456789012345"));
    test(S("12345678901234567890"), "1234567890", S("123456789012345678901234567890"));
    test(S("12345678901234567890"), "12345678901234567890",
         S("1234567890123456789012345678901234567890"));
    }
#if __cplusplus >= 201103L
    {
    typedef std::basic_string<char, std::char_traits<char>, min_allocator<char>> S;
    test(S(), "", S());
    test(S(), "12345", S("12345"));
    test(S(), "1234567890", S("1234567890"));
    test(S(), "12345678901234567890", S("12345678901234567890"));

    test(S("12345"), "", S("12345"));
    test(S("12345"), "12345", S("1234512345"));
    test(S("12345"), "1234567890", S("123451234567890"));
    test(S("12345"), "12345678901234567890", S("1234512345678901234567890"));

    test(S("1234567890"), "", S("1234567890"));
    test(S("1234567890"), "12345", S("123456789012345"));
    test(S("1234567890"), "1234567890", S("12345678901234567890"));
    test(S("1234567890"), "12345678901234567890", S("123456789012345678901234567890"));

    test(S("12345678901234567890"), "", S("12345678901234567890"));
    test(S("12345678901234567890"), "12345", S("1234567890123456789012345"));
    test(S("12345678901234567890"), "1234567890", S("123456789012345678901234567890"));
    test(S("12345678901234567890"), "12345678901234567890",
         S("1234567890123456789012345678901234567890"));
    }
#endif
}
