// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Author: dsites@google.com (Dick Sites)
//
//  Compile with -Davoid_utf8_string_constants if your compiler cannot
//  handle UTF-8 string constants


#ifndef I18N_ENCODINGS_COMPACT_LANG_DET_UNITTEST_DATA_H_
#define I18N_ENCODINGS_COMPACT_LANG_DET_UNITTEST_DATA_H_


#ifndef avoid_utf8_string_constants

const char* kTeststr_aa_Latn = " nagay tanito nagay tanto nagayna naharsi nahrur nake nala nammay nammay haytu nanu narig ne ni num numu o obare obe obe obisse oggole ogli olloyta ongorowe orbise othoga r rabe rade ra e rage rakub rasitte rasu reyta rog ruddi ruga s sa al bada sa ala";
const char* kTeststr_ab_Cyrl = " а зуа абзиара дақәшәоит ан лыбзиабара ахә амаӡам ауаҩы игәы иҭоу ихы иҿы ианубаалоит аҧҳәыс ҧшӡа ахацәа лышьҭоуп аҿаасҭа лара дрышьҭоуп";
const char* kTeststr_af_Latn = " aam skukuza die naam beteken hy wat skoonvee of hy wat alles onderstebo keer wysig bosveldkampe boskampe is kleiner afgeleë ruskampe wat oor min fasiliteite beskik daar is geen restaurante of winkels nie en slegs oornagbesoekers word toegelaat bateleur";
const char* kTeststr_ak_Latn = "Wɔwoo Hilla Limann Mumu-Ɔpɛnimba 12 afe 1934. Wɔwoo no wɔ Gwollu wɔ Sisala Mantaw mu Nna ne maame yɛ Mma Hayawah. Ne papa so nna ɔyɛ Babini Yomu. Ɔwarr Fulera Limann ? Ne mba yɛ esuon-- Lariba Montia [wɔwoo no Limann]; Baba Limann; Sibi Andan [wɔwoo no Limann]; Lida Limann; Danni Limann; Zilla Limann na Salma Limann. Ɔtenaa ase kɔpemm Sanda-Kwakwa da ɛtɔ so 23 wɔ afe 1998 wɔ ?.";
const char* kTeststr_am_Ethi = " ለመጠይቅ ወደ እስክንድርያ ላኩዋቸውና የእስክንድርያ ጳጳስ አቴናስዮስ ፍሬምንጦስን እራሳቸውን ሾመው ልከዋል ከዚያ እስከ ዓ ም ድረስ የኢትዮጵያ አቡነ";
const char* kTeststr_ar_Arab = "احتيالية بيع أي حساب";
const char* kTeststr_as_Beng = "অঞ্চল নতুন সদস্যবৃন্দ সকলোৱে ভৰ্তি হব পাৰে মুল পৃষ্ঠা জন লেখক গুগ ল দল সাৰাংশ ই পত্ৰ টা বাৰ্তা এজন";
const char* kTeststr_ay_Latn = " aru wijar aru ispañula ukaran aru witanam aru kurti aru kalis aru warani aru malta aru yatiyawi niya jakitanaka isluwiñ aru lmir phuran aru masirunan aru purtukal aru kruwat aru jakira urtu aru inklisa pirsan aru suyku aru malay aru jisk aptayma thaya";
const char* kTeststr_az_Arab = " آذربایجان دا انسان حاقلاری ائوی آچیلاجاق ب م ت ائلچيسي برمه موخاليفتي نين ليدئري ايله گؤروشه بيليب ترس شوونيسم فارس از آزادي ملتهاي تورکمن";
const char* kTeststr_az_Latn = " a az qalıb breyn rinq intellektual oyunu üzrə yarışın zona mərhələləri keçirilib miq un qalıqlarının dənizdən çıxarılması davam edir məhəmməd peyğəmbərin karikaturalarını çap edən qəzetin baş redaktoru iş otağında ölüb";
const char* kTeststr_ba_Cyrl = " арналђан бындай ђилми эш тіркињлњ тњјге тапєыр нњшер ителњ ғинуар бєхет именлектє етешлектє ауыл ўќмерџєре хеџмєт юлын ћайлаѓанда";
const char* kTeststr_be_Cyrl = " а друкаваць іх не было тэхнічна магчыма бліжэй за вільню тым самым часам нямецкае кіраўніцтва прапаноўвала апроч ўвядзення лацінкі яе";
const char* kTeststr_bg_Cyrl = " а дума попада в състояние на изпитание ключовите думи с предсказана малко под то изискване на страниците за търсене в";
//const char* kTeststr_bh_Deva = " विकिपीडिया इंटरनेट आधारित एक मुक्त ज्ञानकोष परियोजना ह ई विकि के रुप मेँ बा यानी एगो अईसन जाल पृष्ठ जे सभन के संपादन करे के छूट देवेला विकिपीडिया शब्द विकि अउर इनसाइक्लोपीडिया ज्ञानकोष शब्दन के मिला के बनल बा विकिपीडिया एक बहुभाषीय प्रकल्प ह अउर स्वयंसेवकन के सहकार से निर्मित बा जेहु के भी इंटरनेट तक पहुँच बा ऊ विकिपीडिया पर लिख सकत बा अउर लेखन के संपादन कर सकत बा";
// From 10% testing part of new lang=bh scrape
const char* kTeststr_bh_Deva = "काल में उनका हमला से बचे खाती एहिजा भाग के अइले आ भोजपुर नाम से नगर बसवले. एकरा बारे में विस्तार से जानकारी नीचे दीहल गइल बा. बाकिर आश्चर्यजनक रूप से मालवा के राजा भोज के बिहार आवे आ भोजपुर नगर बसावे आ चाहे भोजपुरी के साथे उनकर कवनो संबंध होखे के कवनो जानकारी भोपाल के भोज संस्थान आ चाहे मध्य प्रदेश के इतिहासकार लोगन के तनिको नइखे. हालांकि ऊ सब लोग एह बात के मानत बा कि एकरा बारे में अबहीं तकले मूर्ति बनवइलें. राजा भोज के जवना जगहा पऽ वाग्देवी के दर्शन भइल रहे, ओही स्थान पऽ एह मूर्ति के स्थापना कइल गइल. अब अगर एह मंदिर के एह शिलालेख के तस्वीर (पृष्ठ संख्या 33 पऽ प्रकाशित) रउआ धेयान से देखीं तऽ एकरा पऽ कैथी लिपि में -सीताराम- लिखल साफ लउकत बा. कैथी भोजपुरी के बहुत प्रचलित लिपि रहल बिया. एकरा बारे में कवनो शंका संदेह बिहार-यूपी के जानकार लोगन में नइखे. एल. एस. एस. वो माले के लिखल पढ़ीं ";

const char* kTeststr_bi_Latn = " king wantaem nomo hem i sakem setan mo ol rabis enjel blong hem oli aot long heven oli kamdaon long wol taswe ol samting oli kam nogud olgeta long wol ya stat long revelesen ol faet kakae i sot ol sik mo fasin blong brekem loa oli kam antap olgeta samting";
const char* kTeststr_blu_Latn = " Kuv hlub koj txawm lub ntuj yuav si ntshi nphaus los kuv tsis ua siab nkaug txawm ntiab teb yuav si ntshi nphaus los kuv tseem ua lon tsaug vim kuv hlub koj tag lub siab";
const char* kTeststr_blu_Latn2 = "Kuv hnov Txhiaj Xeeb Vaj, co-owner of Hmong Village Shopping Center, hais ua hnub ua hmo tias kom Hmoob yuav tsum txhawb Hmoob thiab listed cov mini-shops uas nyob rau hauv nws lub MALL txhua txhua kom sawv daws mus txhawb, tiam sis uas cas zaum twg twb pom nws mus kav kiav hauv taj laj qhabmeem (Sun Foods) xwb tiag. Nag hmo kuv pom nws mus shopping nrog nws poj niam hauv Sun Foods. Thaum tawm mus txog nraum parking lot kuv thiaj txhob txwm mus ze ze seb ua li nws mus yuav dab tsi tiag, thiab seb tej uas nws yuav ntawd puas muaj nyob ntawm tej kiab khw Hmoob. Surprised!!! Vuag.... txhua yam nws yuav hauv Sun Foods peb Hmoob cov khw yeej muaj tag nrho. Peb niaj hnub nqua hu kom Hmoob yuav tsum pab Hmoob yog pab li no lod?";
//const char* kTeststr_bn_Beng = " ংখ্যা নমুনায়ন বিন্যাস পরিসংখ্যানিক মডেল পরিসংখ্যানিক সিদ্ধান্ত ফাংশন পরিসংখ্যানিক";
// From 10% testing part of new lang=bn scrape
const char* kTeststr_bn_Beng = "গ্যালারির ৩৮ বছর পূর্তিতে মূল্যছাড় অর্থনীতি বিএনপির ওয়াক আউট তপন চৌধুরী হারবাল অ্যাসোসিয়েশনের সভাপতি আন্তর্জাতিক পরামর্শক বোর্ড দিয়ে শরিয়াহ্ ইনন্ডেক্স করবে সিএসই মালিকপক্ষের কান্না, শ্রমিকের অনিশ্চয়তা মতিঝিলে সমাবেশ নিষিদ্ধ: এফবিসিসিআইয়ের ধন্যবাদ বিনোদন বিশেষ প্রতিবেদন বাংলালিংকের গ্র্যান্ডমাস্টার সিজন-৩ ব্রাজিলে বিশ্বকাপ ফুটবল আয়োজনবিরোধী বিক্ষোভ দেশের নিরাপত্তার  চেয়ে অনেক বেশি সচেতন । প্রার্থীদের দক্ষতা  ও যোগ্যতার পাশাপাশি তারা জাতীয় ইস্যুগুলোতে প্রাধান্য দিয়েছেন । ” পাঁচটি সিটিতে ২০ লাখ ভোটারদের দিয়ে জাতীয় নির্বাচনে ৮ কোটি ভোটারদের সঙ্গে তুলনা করা যাবে কি একজন দর্শকের এমন প্রশ্নে জবাবে আব্দুল্লাহ আল নোমান বলেন , “ এই পাঁচটি সিটি কর্পোরেশন নির্বাচন দেশের পাঁচটি বড় বিভাগের প্রতিনিধিত্ব করছে । এছাড়া এখানকার ভোটার রা সবাই সচেতন । তারা";

//const char* kTeststr_bo_Tibt = " གང ནི ཀུན ལ སྦྱར པ དང ཅན ལྡན བདག པོའི སྒྲ ག ད བ ས ན མ པ ང འ ར ལ མཐའ མེད པ བདག པོའི སྒྲ ལ པ ཉིད དོ མ མི མིན";
// From 10% testing part of new lang=bo scrape
const char* kTeststr_bo_Tibt = " ་གྱིས་ཁ་ཆེའི་ཕྱག་འཚལ་ཁང་ཞིག་བཤིག་སྲིད་པ། ཡར་ཀླུང་གཙང་པོར་ཆ ུ་མཛོང་བརྒྱག་རྒྱུའི་ལས་འཆར་ལ་རྒྱ་གར་གྱི་སེམས་ཚབས། རྒྱ་གརགྱི་མཚོ་འོག་དམག་གྲུར་སྦར་གས་བྱུང་བ། པ་ཀི་སི་ཏན་གྱིས་རྒྱ་གར་ལ་མི་སེར་བསད་པའི་སྐྱོན་འཛུགས་བྱས་པ། རྩོམ་ཡིག་མང་བ། འབྲེལ་མཐུད་བརྒྱུད་ལམ། ཐོན་སྐྱེད་དང་སྲི་ཞུ། ་ཐོག་དེབ་བཞི་ དཔར་འགྲེམས་གནང་ཡོད་པ་དང་བོད་ཡིག་དྲ་ཚིགས་ཁག་ནང་ལ་ཡང་རྩོམ་ཡང་ཡང་བྲིས་གནང་མཁན་རེད། ལེ་ཚན་ཁག ལེ་ཚན་ཁག འབྲེལ་ཡོད། འགྲེམ་སྟོན། རྒྱུད་ལམ་སྣ་མང་ཡིག་མཛོད། བཀོལ་སྤྱོད་པའི་འཇོག་ཡུལ་དྲ་ངོས། སྔོན་མ། རྗེས་མ། བསྟན་འཛིན་བདེ་སྐྱིད། ཚེ་རིང་རྣམ་རྒྱལ། བསྟན་འཛིན་ངག་དབང་། ཡོལ་གདོང་ཚེ་རིང་ལྷག་པ།  ་དབང་ ཕྱུག་གཉིས་ཀྱིས་བརྗོད་གཞི་བྱེ་བྲག་པ་ཞིག་ལ་བགྲོ་གླེང་གཏིང་ཟབ་བྱེད་པའི་གཟའ་ འཁོར་གཉིས་རེའི་མཚམས་ཀྱི་ལེ་ཚན་ཞིག་ཡིན། དཔྱད་ཞིབ་ཀྱིས་རྒྱ་ནག་ནང་ཁུལ་གྱི་འགྱུར་ལྡོག་དང༌། རྒྱ་ནག་དང་རྒྱལ་སྤྱིའི་འབྲེལ་བར་དམིགས་སུ་བཀར་ནས་བགྲོ་གླེང་བྱེད་ཀྱི་ཡོད།། རྒྱང་སྲིང་དུས་ཚོད།";

const char* kTeststr_br_Latn = " a chom met leuskel a ra e blas da jack irons dilabour hag aet kuit eus what is this dibab a reont da c houde michael beinhorn evit produiñ an trede pladenn kavet e vez ar ganaouennoù buhan ha buhan ganto setu stummet ar bladenn adkavet e vez enni funk";
const char* kTeststr_bs_Cyrl = "историја босне књ историја босне књ историја босне књ историја босне књ ";
//const char* kTeststr_bs_Latn = " a radi bržeg rada pošto rom radi sporije nego ram izvorni rom se isključuje a dio ram a se rezerviše te se u njega ne ploča procesor ram memorija grafička kartica zvučna kartica modem mrežna kartica napojna jedinica uređaji za pohranjivanje";
// From 10% testing part of new lang=bs scrape
const char* kTeststr_bs_Latn = "Novi predsjednik Mešihata Islamske zajednice u Srbiji (IZuS) i muftija dr. Mevlud ef. Dudić izjavio je u intervjuu za Anadolu Agency (AA) kako je uvjeren da će doći do vraćanja jedinstva među muslimanima i unutar Islamske zajednice na prostoru Sandžaka, te da je njegova ruka pružena za povratak svih u okrilje Islamske zajednice u Srbiji nakon skoro sedam godina podjela u tom dijelu Srbije. Dudić je za predsjednika Mešihata IZ u Srbiji izabran 4. januara, a zvanična inauguracija će biti obavljena u prvoj polovini februara. Kako se očekuje, prisustvovat će joj i reisu-l-ulema Islamske zajednice u Srbiji Husein ef. Kavazović koji će i zvanično promovirati Dudića u novog prvog čovjeka IZ u Srbiji. Dudić će danas boraviti u prvoj zvaničnoj posjeti reisu Kavazoviću, što je njegov privi simbolični potez nakon imenovanja. ";

const char* kTeststr_ca_Latn = "al final en un únic lloc nhorabona l correu electrònic està concebut com a eina de productivitat aleshores per què perdre el temps arxivant missatges per després intentar recordar on els veu desar i per què heu d eliminar missatges importants per l";
const char* kTeststr_ceb_Latn = "Ang Sugbo usa sa mga labing ugmad nga lalawigan sa nasod. Kini ang sentro sa komersyo, edukasyon ug industriya sa sentral ug habagatang dapit sa kapupod-an. Ang mipadayag sa Sugbo isip ikapito nga labing nindot nga pulo sa , ang nag-inusarang pulo sa Pilipinas nga napasidunggan sa maong magasin sukad pa sa tuig";
const char* kTeststr_ceb_Latn2 = "Ang mga komyun sa Pransiya duol-duol sa inkorporadong mga lungsod ug mga dakbayan sa Estados Unidos. Wala kini susamang istruktura sa Hiniusang Gingharian (UK) tungod kay ang estado niini taliwala sa di-metropolitan nga distrito ug sa sibil nga parokya. Wala usab kini susamang istruktura sa Pilipinas.";
const char* kTeststr_chr_Cher = "ᎠᎢᏍᎩ ᎠᏟᎶᏍᏗ ᏥᏄᏍᏛᎩ ᎦᎫᏍᏛᏅᎯ ᎾᎥᎢ";
const char* kTeststr_co_Latn = " a prupusitu di risultati for utilizà a scatula per ricercà ind issi risultati servore errore u servore ha incuntratu una errore pruvisoria é ùn ha pussutu compie a vostra dumanda per piacè acimenta dinò ind una minuta tuttu listessu ligami truvà i";
const char*  kTeststr_crs_Latn = "Sesel ou menm nou sel patri. Kot nou viv dan larmoni. Lazwa, lanmour ek lape. Nou remersye Bondye. Preserv labote nou pei. Larises nou losean. En leritaz byen presye. Pour boner nou zanfan. Reste touzour dan linite. Fer monte nou paviyon. Ansanm pou tou leternite. Koste Seselwa!";
const char* kTeststr_cs_Latn = " a akci opakujte film uložen vykreslit gmail tokio smazat obsah adresáře nelze načíst systémový profil jednotky smoot okud používáte pro určení polokoule značky z západ nebo v východ používejte nezáporné hodnoty zeměpisné délky nelze";
const char* kTeststr_cy_Latn = " a chofrestru eich cyfrif ymwelwch a unwaith i chi greu eich cyfrif mi fydd yn cael ei hysbysu o ch cyfeiriad ebost newydd fel eich bod yn gallu cadw mewn cysylltiad drwy gmail os nad ydych chi wedi clywed yn barod am gmail mae n gwasanaeth gwebost";
const char* kTeststr_da_Latn = " a z tallene og punktummer der er tilladte log ud angiv den ønskede adgangskode igen november gem personlige oplysninger kontrolspørgsmål det sidste tegn i dit brugernavn skal være et bogstav a z eller tal skriv de tegn du kan se i billedet nedenfor";
const char* kTeststr_de_Latn = " abschnitt ordner aktivieren werden die ordnereinstellungen im farbabschnitt deaktiviert öchten sie wirklich fortfahren eldtypen angeben optional n diesem schritt geben sie für jedesfeld aus dem datenset den typ an ieser schritt ist optional eldtypen";
const char* kTeststr_dv_Thaa = " ހިންދީ ބަހުން ވާހަކަ ދައްކާއިރު ދެވަނަ ބަހެއްގެ ގޮތުގައާއި އެނޫން ގޮތްގޮތުން ހިންދީ ބަހުން ވާހަކަ ދައްކާ މީހުންގެ އަދަދު މިލިއަނަށް";
const char* kTeststr_dz_Tibt = " རྩིས བརྐྱབ ཚུལ ལྡན དང ངེས བདེན སྦ སྟོན ནིའི དོན ལུ ཁྱོད གུག ཤད ལག ལེན འཐབ དགོ ག དང ཨིན པུཊི གྲལ ཐིག གུ";
const char* kTeststr_ee_Latn = "Yi (Di tanya sia) tatia akɔ wò ayi axa yeye dzi kple tanya si sɔ kple esi wòŋlɔ ɖe goa me, negbe axaa ɖe li kpakple tanya mawo xoxo ko. Teƒe le axa yeye sia dzi si wòateŋu atia na kpekpeɖeŋu kple nuwoŋlɔŋlɔ ne anɔ hahiãm na wò. Mehiã be na gbugbɔ ava afii na axa yeye gɔmedzedze o. Woateŋu adze wo gɔme kple nuŋɔŋlɔ dzẽwo tatia. Megavɔ̃ na nuyeyewo gɔmedzedze kroa o.";
const char* kTeststr_el_Grek = " ή αρνητική αναζήτηση λέξης κλειδιού καταστήστε τις μεμονωμένες λέξεις κλειδιά περισσότερο στοχοθετημένες με τη μετατροπή τους σε";
const char* kTeststr_en_Latn = " a backup credit card by visiting your billing preferences page or visit the adwords help centre for more details https adwords google com support bin answer py answer hl en we were unable to process the payment of for your outstanding google adwords";
const char* kTeststr_eo_Latn = " a jarcento refoje per enmetado de koncerna pastro tiam de reformita konfesio ekde refoje ekzistis luteranaj komunumanoj tamen tiuj fondis propran komunumon nur en ambaŭ apartenis ekde al la evangela eklezio en prusio resp ties rejnlanda provinceklezio en";
const char* kTeststr_es_Latn = " a continuación haz clic en el botón obtener ruta también puedes desplazarte hasta el final de la página para cambiar tus opciones de búsqueda gráfico y detalles ésta es una lista de los vídeos que te recomendamos nuestras recomendaciones se basan";
const char* kTeststr_et_Latn = " a niipea kui sinu maksimaalne igakuine krediidi limiit on meie poolt heaks kiidetud on sinu kohustuseks see krediidilimiit";
const char* kTeststr_eu_Latn = " a den eraso bat honen kontra hortaz eragiketa bakarrik behar dituen eraso batek aes apurtuko luke nahiz eta oraingoz eraso bideraezina izan gaur egungo teknologiaren mugak direla eta oraingoz kezka hauek alde batera utzi daitezke orain arteko indar";
const char* kTeststr_fa_Arab = " آب خوردن عجله می کردند به جای باز ی کتک کاری می کردند و همه چيز مثل قبل بود فقط من ماندم و يک دنيا حرف و انتظار تا عاقبت رسيد احضاريه ی ای با";
const char* kTeststr_fi_Latn = " a joilla olet käynyt tämä kerro meille kuka ä olet ei tunnistettavia käyttötietoja kuten virheraportteja käytetään google desktopin parantamiseen etsi näyttää mukautettuja uutisia google desktop keskivaihto leikkaa voit kaksoisnapsauttaa";
const char* kTeststr_fj_Latn = " i kina na i iri ka duatani na matana main a meke wesi se meke mada na meke ni yaqona oqo na meke ka dau vakayagataki ena yaqona vakaturaga e dau caka toka ga kina na vucu ka dau lagati tiko kina na ka e yaco tiko na talo ni wai ni yaqona na lewai ni wai";
const char* kTeststr_fo_Latn = " at verða átaluverdar óhóskandi ella áloypandi vit kunnu ikki garanterða at google leitanin ikki finnur naka sum er áloypandi óhóskandi ella átaluvert og google tekur onga ábyrgd yvir tær síður sum koma við í okkara leitiskipan fá tær ein";
const char* kTeststr_fr_Latn = " a accès aux collections et aux frontaux qui lui ont été attribués il peut consulter et modifier ses collections et exporter des configurations de collection toutefois il ne peut pas créer ni supprimer des collections enfin il a accès aux fonctions";
const char* kTeststr_fy_Latn = " adfertinsjes gewoan lytse adfertinsjes mei besibbe siden dy t fan belang binne foar de ynhâld fan jo berjochten wolle jo mear witte fan gmail foardat jo jo oanmelde gean dan nei wy wurkje eltse dei om gmail te ferbetterjen dêrta sille wy jo sa út en";
const char* kTeststr_ga_Latn = " a bhfuil na focail go léir i do cheist le fáil orthu ní gá ach focail breise a chur leis na cinn a cuardaíodh cheana chun an cuardach a bheachtú nó a chúngú má chuirtear focal breise isteach aimseofar fo aicme ar leith de na torthaí a fuarthas";
const char* kTeststr_gaa_Latn = "Akε mlawookpeehe kε Maŋhiεnyiεlכ oshikifככ lε eba naagbee ni maŋ lε nitsumכ ni kwεכ oshikifככ nכ lε etsככ mכ ni ye kunim ni akε lε eta esεŋ nכ. Dani nomεi baaba nכ lε, maŋ nכkwεmכ kui wuji enyכ ni yככ wכ maŋ lε mli, NPP kε NDC mli bii fכfכi wiemכi kεmaje majee amεhe. Ekomεi kwraa po yafee hiεkwεmכi ni ha ni gidigidi, pilamכ kε la shishwiemכ aaba yε heikomεi. ";
const char* kTeststr_gd_Latn = " air son is gum bi casg air a h uile briosgaid no gum faigh thu brath nuair a tha briosgaid a tighinn gad rannsachadh ghoogle gu ceart mura bheil briosgaidean ceadaichte cuiridh google briosgaid dha do neach cleachdaidh fa leth tha google a cleachdadh";
const char* kTeststr_gl_Latn = "  debe ser como mínimo taranto tendas de venda polo miúdo cociñas servizos bordado canadá viaxes parques de vehículos de recreo hotel oriental habitación recibir unha postal no enderezo indicado anteriormente";
const char* kTeststr_gn_Latn = " aháta añe ë ne mbo ehára ndive ajeruréta chupe oporandujey haĝua peëme mba épa pekaru ha áĝa oporandúvo nde eréta avei re paraguaýpe kachíke he i leúpe ndépa re úma kure tatakuápe ha leu ombohovái héë ha ujepéma kachíke he ijey";
const char* kTeststr_gu_Gujr = " આના પરિણામ પ્રમાણસર ફોન્ટ અવતરણ ચિન્હવાળા પાઠને છુપાવો બધા સમૂહો શોધાયા હાલનો જ સંદેશ વિષયની";
const char* kTeststr_gv_Latn = " and not ripe as i thought yn assyl yn shynnagh as yn lion the ass the fox and the lion va assyl as shynnagh ayns commee son nyn vendeilys as sauchys hie ad magh ayns y cheyll dy shelg cha row ad er gholl feer foddey tra veeit ad rish lion yn shynnagh";
const char* kTeststr_ha_Latn = " a cikin a kan sakamako daga sakwannin a kan sakamako daga sakwannin daga ranar zuwa a kan sakamako daga guda daga ranar zuwa a kan sakamako daga shafukan daga ranar zuwa a kan sakamako daga guda a cikin last hour a kan sakamako daga guda daga kafar";
const char* kTeststr_haw_Latn = "He puke noiʻi kūʻikena kūnoa ʻo Wikipikia. E ʻoluʻolu nō, e hāʻawi mai i kāu ʻike, kāu manaʻo, a me kou leo no ke kūkulu ʻana a me ke kākoʻo ʻana mai i ka Wikipikia Hawaiʻi. He kahua pūnaewele Hawaiʻi kēia no ka hoʻoulu ʻana i ka ʻike Hawaiʻi. Inā hiki iā ʻoe ke ʻōlelo Hawaiʻi, e ʻoluʻolu nō, e kōkua mai a e hoʻololi i nā ʻatikala ma ʻaneʻi, a pono e haʻi aku i kou mau hoa aloha e pili ana i ka Wikipikia Hawaiʻi. E ola mau nō ka ʻōlelo Hawaiʻi a mau loa aku.";
const char* kTeststr_hi_Deva = " ं ऐडवर्ड्स विज्ञापनों के अनुभव पर आधारित हैं और इनकी मदद से आपको अपने विज्ञापनों का अधिकतम लाभ";
const char* kTeststr_hr_Latn = "Posljednja dva vladara su Kijaksar (Κυαξαρης; 625-585 prije Krista), fraortov sin koji će proširiti teritorij Medije i Astijag. Kijaksar je imao kćer ili unuku koja se zvala Amitis a postala je ženom Nabukodonosora II. kojoj je ovaj izgradio Viseće vrtove Babilona. Kijaksar je modernizirao svoju vojsku i uništio Ninivu 612. prije Krista. Naslijedio ga je njegov sin, posljednji medijski kralj, Astijag, kojega je detronizirao (srušio sa vlasti) njegov unuk Kir Veliki. Zemljom su zavladali Perzijanci.";
const char* kTeststr_ht_Latn = " ak pitit tout sosyete a chita se pou sa leta dwe pwoteje yo nimewo leta fèt pou li pwoteje tout paran ak pitit nan peyi a menm jan kit paran yo marye kit yo pa marye tout manman ki fè pitit leta fèt pou ba yo konkoul menm jan tou pou timoun piti ak pou";
const char* kTeststr_hu_Latn = " a felhasználóim a google azonosító szöveget ikor látják a felhasználóim a google azonosító szöveget felhasználók a google azonosító szöveget fogják látni minden tranzakció után ha a vásárlását regisztrációját oldalunk";
const char* kTeststr_hy_Armn = " ա յ եվ նա հիացած աչքերով նայում է հինգհարկանի շենքի տարօրինակ փոքրիկ քառակուսի պատուհաններին դեռ մենք շատ ենք հետամնաց ասում է նա այսպես է";
const char* kTeststr_ia_Latn = " super le sitos que tu visita isto es necessari pro render disponibile alcun functionalitates del barra de utensiles a fin que nos pote monstrar informationes ulterior super un sito le barra de utensiles debe dicer a nos le";
//const char* kTeststr_id_Latn = "Geng: Pengembaraan Bermula adalah film animasi 3D CGI pertama yang diproduksi di Malaysia. Film ini dibuat oleh Les' Copaque Production (LCP) dan dirilis di bioskop-bioskop seluruh Malaysia pada 12 Februari 2009. Film Geng pertama kali diluncurkan dalam sebuah acara peluncuran pada 11 September 2007 bersama dengan serial animasi pendek Upin & Ipin yang berhubungan dengan film tersebut. Pembuatan film ini didukung oleh berbagai pihak seperti Kementerian Sains, Teknologi dan Inovasi Malaysia (MOSTI) dengan memberi bantuan berupa dana sebesar RM1 juta.";
// From 10% testing part of new lang=id scrape
const char* kTeststr_id_Latn = "berdiri setelah pengurusnya yang berusia 83 tahun, Fayzrahman Satarov, mendeklarasikan diri sebagai nabi dan rumahnya sebagai negara Islam Satarov digambarkan sebagai mantan ulama Islam  tahun 1970-an. Pengikutnya didorong membaca manuskripnya dan kebanyakan dilarang meninggalkan tempat persembunyian bawah tanah di dasar gedung delapan lantai mereka. Jaksa membuka penyelidikan kasus kriminal pada kelompok itu dan menyatakan akan membubarkan kelompok kalau tetap melakukan kegiatan ilegal seperti mencegah anggotanya mencari bantuan medis atau pendidikan. Sampai sekarang pihak berwajib belum melakukan penangkapan meskipun polisi mencurigai adanya tindak kekerasan pada anak. Pengadilan selanjutnya akan memutuskan apakah anak-anak diizinkan tetap tinggal dengan orang tua mereka. Kazan yang berada sekitar 800 kilometer di timur Moskow merupakan wilayah Tatarstan yang";

const char* kTeststr_ie_Latn = " abhorre exceptiones in li derivation plu cardinal por un l i es li regularità del flexion conjugation ples comparar latino sine flexione e li antiqui projectes naturalistic queles have quasi null regules de derivation ma si on nu examina li enunciationes";
const char* kTeststr_ig_Latn = "Chineke bụ aha ọzọ ndï omenala Igbo kpọro Chukwu. Mgbe ndị bekee bịara, ha mee ya nke ndi Christian. N'echiche ndi ekpere chi Omenala Ndi Igbo, Christianity, Judaism, ma Islam, Chineke nwere ọtụtụ utu aha, ma nwee nanị otu aha. Ụzọ abụọ e si akpọ aha ahụ bụ Jehovah ma Ọ bụ Yahweh. Na ọtụtụ Akwụkwọ Nsọ, e wepụla aha Chineke ma jiri utu aha bụ Onyenwe Anyị ma ọ bụ Chineke dochie ya. Ma mgbe e dere akwụkwọ nsọ, aha ahụ bụ Jehova pụtara n’ime ya, ihe dị ka ugboro pụkụ asaa(7,000).";
//const char* kTeststr_ik_Latn = " kuubuuraqabniqsuq ataruamik colville mi aasii tavrani siku kilaabman sulukpaukkat makua niksisugrufagivut tavrani sunaimña atifa quaqqat ii quaqqat aasii ukiabmagu utiqhuta tamaufa utqiabvifñun aasiiñ tatpaaffaqapta tuvaaqatinifarufa aasiiñ";
// From 10% testing part of new lang=ik scrape
const char* kTeststr_ik_Latn = "sabvaqjuktuq sabvaba atiqaqpa atiqaqpa ibiq iebiq ixafich niuqtulgiññatif uvani natural gas tatpikka ufasiksigiruaq maaffa savaannafarufa mi tatkivani navy qanuqjugugguuq taaptuma inna uqsrunik ivaqjiqhutik       taktuk allualiuqtuq sigukun nanuq puuvraatuq taktuum amugaa kalumnitigun nanuq agliruq allualiuqtuq";

const char* kTeststr_is_Latn = " a afköst leitarorða þinna leitarorð neikvæð leitarorð auglýsingahópa byggja upp aðallista yfir ný leitarorð fyrir auglýsingahópana og skoða ítarleg gögn um árangur leitarorða eins og samkeppni auglýsenda og leitarmagn er krafist notkun";
const char* kTeststr_it_Latn = " a causa di un intervento di manutenzione del sistema fino alle ore circa ora legale costa del pacifico del novembre le campagne esistenti continueranno a essere pubblicate come di consueto anche durante questo breve periodo di inattività ci scusiamo per";
const char* kTeststr_iu_Cans = "ᐃᑯᒪᒻᒪᑦ ᕿᓈᖏᓐᓇᓲᖑᒻᒪᑦ ᑎᑎᖅᑕᓕᒫᖅᓃᕕᑦ ᑎᑦᕆᐊᑐᓐᖏᑦᑕᑎᑦ ᑎᑎᖅᑕᑉᐱᑦ ᓯᕗᓂᖓᓂ ᑎᑎᖅᖃᖅ ᑎᑎᕆᐊᑐᓐᖏᑕᐃᑦ ᕿᓂᓲᖑᔪᒍᑦ ᑎᑎᖅᑕᓕᒫᖅᓃᕕᑦ";
const char* kTeststr_iw_Hebr = " או לערוך את העדפות ההפצה אנא עקוב אחרי השלבים הבאים כנס לחשבון האישי שלך ב";
const char* kTeststr_ja_Hani = " このペ ジでは アカウントに指定された予算の履歴を一覧にしています それぞれの項目には 予算額と特定期間のステ タスが表示されます 現在または今後の予算を設定するには";
const char* kTeststr_jw_Latn = " account ten server niki kalian username meniko tanpo judul cacahe account nggonanmu wes pol pesen mu wes diguwak pesenan mu wes di simpen sante wae pesenan mu wes ke kirim mbuh tekan ora pesenan e ke kethok pesenan mu wes ke kirim mbuh tekan ora pesenan";
const char* kTeststr_ka_Geor = " ა ბირთვიდან მიღებული ელემენტი მენდელეევის პერიოდულ სიტემაში გადაინაცვლებს ორი უჯრით";
const char* kTeststr_kha_Latn = " kaba jem jai sa sngap thuh ia ki bynta ba sharum naka sohbuin jong phi nangta sa pynhiar ia ka kti kadiang jong phi sha ka krung jong phi bad da kaba pyndonkam kumjuh ia ki shympriahti jong phi sa sngap thuh shapoh ka tohtit jong phi pyndonkam ia kajuh ka";
const char* kTeststr_kk_Arab = " ﺎ ﻗﻴﺎﻧﺎﺕ ﺑﻮﻟﻤﺎﻳﺪﻯ ﺑﯘﻝ ﭘﺮﻭﺗﺴﻪﺳﯩﻦ ﻳﺎﻋﻨﻲ ﻗﺎﻻ ﻭﻣﯩﺮﯨﻨﺪﻩ ﻗﺎﺯﺍﻕ ء ﺗﯩﻠﯩﻨﯩﯔ ﻗﻮﻟﺪﺍﻧﯩﻠﻤﺎﯞﻯ ﻗﺎﺯﺍﻕ ﺟﻪﺭﯨﻨﺪﻩ";
const char* kTeststr_kk_Cyrl = " а билердің өзіне рұқсат берілмеген егер халық талап етсе ғана хан келісім берген өздеріңіз білесіздер қр қыл мыс тық кодексінде жазаның";
const char* kTeststr_kk_Latn = " bolsa da otanyna qaityp keledi al oralmandar basqa elderde diasporasy ote az bolghandyqtan bir birine komektesip bauyrmal bolady birde men poezben oralmandardyng qazaqstangha keluin kordim monghol qazaqtary poezdan tuse sala jerdi suip jylap keletin biraq";
const char* kTeststr_kl_Latn = " at nittartakkalli uani toqqarsimasatta akornanni nittartakkanut allanut ingerlaqqittoqarsinnaavoq kanukoka tassaavoq kommuneqarfiit kattuffiat nuna tamakkerlugu kommunit nittartagaannut ingerlaqqiffiusinnaasoq kisitsiserpassuit nunatsinnut tunngasut";
const char* kTeststr_km_Khmr = " ក ខ គ ឃ ង ច ឆ ជ ឈ ញ ដ ឋ ឌ ឍ ណ ត ថ ទ ធ ន ប ផ ព ភ ម យ រ ល វ ស ហ ឡ អ ឥ ឦ ឧ ឪ ឫ ឬ ឯ ឱ ទាំងអស់";
const char* kTeststr_kn_Knda = " ಂಠಯ್ಯನವರು ತುಮಕೂರು ಜಿಲ್ಲೆಯ ಚಿಕ್ಕನಾಯಕನಹಳ್ಳಿ ತಾಲ್ಲೂಕಿನ ತೀರ್ಥಪುರ ವೆಂಬ ಸಾಧಾರಣ ಹಳ್ಳಿಯ ಶ್ಯಾನುಭೋಗರ";
const char* kTeststr_ko_Hani = " 개별적으로 리포트 액세스 권한을 부여할 수 있습니다 액세스 권한 부여사용자에게 프로필 리포트에 액세스할 수 있는 권한을 부여하시려면 가용 프로필 상자에서 프로필 이름을 선택한 다음";
//const char* kTeststr_ks_Arab = "پیٹھ سٮ۪اگت! آکھ آزاد گیانکوشٖٔ ہۄ کٲنٛسِہ تِہ ہٮ۪کُن اٮ۪ڑِٹ۔ تور چھک ٢٢٨ مَضموٗنن منز کٲشُر ویکیپیٖڈیا چھُ آکھ مَنصوٗبہٕ خٲطرٕ بنَاوُن آکھ گیانکوشٖٔ سۭتۍ آزاد منز 280 زَبانَن تٔمِس یۄسہٕ ژٕ سۭتۍ تُہُنٛد گیان ہُرٮ۪ر کَرُن ہٮ۪کُن";
// From 10% testing part of new lang=ks scrape
const char* kTeststr_ks_Arab = " ژماں سرابن منز  گرٲن چھِہ خابٕک کھلونہٕ ؤڈراواں   تُلتِھ نِیَس تہٕ گوشہِ گوشہِ مندچھاوى۪س   دِلس چھُہ وون٘ت وُچھان از ستم قلم  صبوٝرٕ وول مسٲفر لیۆکھُن بێتابن منز   ورل سوال چھُہ تراواں جوابن منز    کالہٕ پھۯستہٕ پھن٘ب پگَہہ پہ   پۆت نظر دِژ نہٕ ژھالہٕ مٔت آرن     مٲنز مسول متھان چھےٚ مس والن  وۅن چھےٚ غارن تہِ نارٕ ژھٹھ ژاپان  رێش تۅرگ تراوٕہن تہٕ ون رٹہٕ ہن  ہوشہِ ہێۆچھ نہٕ پوشنوٝلس نِش  مۅہرٕ دی دی زٕلاں چھِ زى۪و حرفن  لۆدرٕ پھٔل ہى۪تھ ملر عازمؔ  سۆدرٕ کھۅنہِ منز منگاں چھُہ ندرى۪ن پن   ژے تھى۪کی یہِ مسٲفر پنن وُڈو تہٕ پڑاو   گٕتَو گٕتَو چھےٚ یہِ کۅل بُتھ تہٕ بانہٕ سٕہہ گۅردٕ چھہِ سپداں دمہٕ پُھٹ  چھِٹہ پونپر پکھہٕ داران سُہ یتى۪ن تۯاوِ  کم نظر دۯاکھ تہٕ باسیوے سُہ مۆہ ہیو یێران  مےٚ ژى۪تُرمُت چھُہ سُلی تس چھےٚ کتى۪ن تھپھ  شاد مس کراں وُچھ مےٚ خون  ژٕ خبر کیازِ کراں دۯاکھ تمِس پى۪ٹھ ماتم  أز کہِ شبہٕ آو مےٚ بێیہِ پیش سفر زانہِ خدا  دارِ پى۪ٹھ ژٲنگ ہنا تھو زِ ژے چھےٚ مێون  أنہٕ کپٹاں چھُہ زٕژن سون مظفّر عازمؔ  پوشہ برگن چھُہ سُواں چاکھ سُہ الماس قلم   لوِ کٔ ڈ نوِ سرٕ سونتس کل   پروِ بۆر بێیہ از بانبرِ ہۆت  یمبرزلہِ ٹارى۪ن منز نار   وزملہِ کۅسہٕ کتھ کٔر اظہار  کچھہِ منزٕ ؤن رووُم اچھہِ  چشمو ژوپُم کٔنڈ انبار   تماشہِ چھہِ تگاں";

const char* kTeststr_ks_Deva = "नमस्ते शारदे देवि काश्मिरपुर्वासिनि त्वामहम प्रार्थये देवि विद्य दानम च देहि मे कॉशुर लेख॒नुक सारिव॒य खॊत॒ आसान तरीक॒ छु यि देवनागरी टाइपराइटर इस्तिमाल करुन. अथ मंज़ छि कॉशुर लेख॒न॒चि सारॆय मात्रायि. अमि अलाव॒ हॆकिव तॊह्य् यिम॒ यूनिकोड एडिटर ति वरतॉविथ मगर कॉशिरि मात्रायि लेख॒नस गछ़ि हना दिकथ: अक्षरमालाछु अख मुफ़्त त॒ सॅहॅल सोफ्टवेर यॆमि स॒त्य् युनिकोड देवनागरी मंज़ ITRANS scheme स॒त्य् छु यिवान लेख॒न॒. वुछिव: सहायता. अथ स॒त्य् जुडिथ जालपृष्ठ (वेबपेज) (सॉरी अँग्रीज़ी पॉठ्य)";
const char* kTeststr_ku_Arab = " بۆ به ڕێوه بردنی نامه ی که دێتن ڕاسته وخۆ ڕه وان بکه نامه کانی گ مایل بۆ حسابی پۆستێکی تر هێنانی په یوه ندکاره کان له";
const char* kTeststr_ku_Latn = " be zmaneki ter le inglis werdegeretewe em srvise heshta le cor beta daye wate hest a taqi dekrete u bashtr dekret tewawwzmanekan wernegrawnetewe u ne hemu laperakn ke eme pshtiwan dekayn be teaweti wergerawete nermwalley wergeran teksti new wene nasnatewe";
const char* kTeststr_ky_Arab = " جانا انى تانۇۇ ۇلۇتۇن تانۇۇ قىرعىزدى بئلۉۉ دەگەندىك اچىق ايتساق ماناستى تاانىعاندىق ۅزۉڭدۉ تاانىعاندىق بۉگۉن تەما جۉكتۅمۅ ق ى رع ى ز ت ى ل ى";
const char* kTeststr_ky_Cyrl = " агай эле оболу мен садыбакас аганын өзү менен эмес эмгектери менен тааныштым жылдары ташкенде өзбекстан илимдер академиясынын баяны";
const char* kTeststr_la_Latn = " a deo qui enim nocendi causa mentiri solet si iam consulendi causa mentiatur multum profecit sed aliud est quod per se ipsum laudabile proponitur aliud quod in deterioris comparatione praeponitur aliter enim gratulamur cum sanus est homo aliter cum melius";
const char* kTeststr_lb_Latn = " a gewerkschaften och hei gefuerdert dir dammen an dir häre vun de gewerkschaften denkt un déi aarm wann der äer fuerderunge formuléiert d sechst congés woch an aarbechtszäitverkierzung hëllefen hinnen net d unhiewe vun de steigerungssäz bei de";
const char* kTeststr_lg_Latn = " abaana ba bani lukaaga mu ana mu babiri abaana ba bebayi lukaaga mu abiri mu basatu abaana ba azugaadi lukumi mu ebikumi bibiri mu abiri mu babiri abaana ba adonikamu lukaaga mu nltaaga mu mukaaga abaana ba biguvaayi enkumi bbiri mu ataano mu mukaaga";
const char* kTeststr_lif_Limb = "ᤁᤡᤖᤠᤳ ᤕᤠᤰᤌᤢᤱ ᤆᤢᤶᤗᤢᤱᤖᤧ ᤛᤥᤎᤢᤱᤃᤧᤴ ᤀᤡᤔᤠᤴᤛᤡᤱ ᤆᤧᤶᤈᤱᤗᤧ ᤁᤢᤔᤡᤱᤅᤥ ᤏᤠᤈᤡᤖᤡ ᤋᤱᤒᤣ ᥈᥆᥆᥉ ᤒᤠ ᤈᤏᤘᤖᤡ ᤗᤠᤏᤢᤀᤠᤱ ᤁ᤹ᤏᤠ ᤋᤱᤒᤣ ᤁᤠᤰ ᤏᤠ᤺ᤳᤋᤢ ᤕᤢᤖᤢᤒᤠ ᤀᤡᤔᤠᤴᤛᤡᤱ ᤋᤱᤃᤡᤵᤛᤡᤱ ᤌᤡᤶᤒᤣᤴ ᤂᤠᤃᤴ ᤛᤡᤛᤣ᤺ᤰᤗᤠ ᥇᥍ ᤂᤧᤴ ᤀᤡᤛᤡᤰ ᥇ ᤈᤏᤘᤖᤡ ᥈᥆᥆᥊ ᤀᤥ ᤏᤠᤛᤢᤵ ᤆᤥ᤺ᤰᤔᤠ ᤌᤡᤶᤒᤣ ᤋᤱᤃᤠᤶᤛᤡᤱᤗ ᤐᤳᤐᤠ ᤀᤡᤱᤄᤱ ᤘᤠ᤹";
const char* kTeststr_ln_Latn = " abakisamaki ndenge esengeli moyebami abongisamaki solo mpenza kombo ya moyebami elonguamaki kombo ya bayebami elonguamaki kombo eleki molayi po na esika epesameli limbisa esika ya kotia ba kombo esuki boye esengeli olimbola ndako na yo ya mikanda kombo";
const char* kTeststr_lo_Laoo = " ກຫາທົ່ວທັງເວັບ ແລະໃນເວັບໄຮ້ສາຍ ທຳອິດໃຫ້ທຳການຊອກຫາກ່ອນ ຈາກນັ້ນ ໃຫ້ກົດປຸ່ມເມນູ ໃນໜ້າຜົນໄດ້";
const char* kTeststr_lt_Latn = " a išsijungia mano idėja dėl geriausio laiko po pastarųjų savo santykių pasimokiau penki dalykai be kurių negaliu gyventi mano miegamajame tu surasi ideali pora išsilavinimas aukštoji mokykla koledžas universitetas pagrindinis laipsnis metai";
const char* kTeststr_lv_Latn = " a gadskārtējā izpārdošana slēpošana jāņi atlaide izmaiņas trafikā kas saistītas ar sezonas izpārdošanu speciālajām atlaidēm u c ir parastas un atslēgvārdi kas ir populāri noteiktos laika posmos šajā laikā saņems lielāku klikšķu";
const char* kTeststr_mfe_Latn = "Anz dir mwa, Sa bann delo ki to trouve la, kot fam prostitie asize, samem bann pep, bann lafoul dimoun, bann nasion ek bann langaz. Sa dis korn ki to finn trouve, ansam avek bebet la, zot pou ena laenn pou prostitie la; zot pou pran tou seki li ena e met li touni, zot pou manz so laser e bril seki reste dan dife. Parski Bondie finn met dan zot leker proze pou realiz so plan. Zot pou met zot dakor pou sed zot pouvwar bebet la ziska ki parol Bondie fini realize.";
const char* kTeststr_mg_Latn = " amporisihin i ianao mba hijery ny dika teksta ranofotsiny an ity lahatsoratra ity tsy ilaina ny opérateur efa karohina daholo ny teny rehetra nosoratanao ampiasao anaovana dokambarotra i google telugu datin ny takelaka fikarohana sary renitakelak i";
const char* kTeststr_mi_Latn = " haere ki te kainga o o haere ki te kainga o o haere ki te kainga o te rapunga ahua o haere ki te kainga o ka tangohia he ki to rapunga kaore au mohio te tikanga whakatiki o te ra he whakaharuru te pai rapunga a te rapunga ahua a e kainga o nga awhina o te";
const char* kTeststr_mk_Cyrl = " гласовите коалицијата на вмро дпмне како партија со најмногу освоени гласови ќе добие евра а на сметката на коализијата за македонија";
const char* kTeststr_ml_Mlym = " ം അങ്ങനെ ഞങ്ങള് അവരുടെ മുമ്പില് നിന്നു ഔടും ഉടനെ നിങ്ങള് പതിയിരിപ്പില് നിന്നു എഴുന്നേറ്റു";
const char* kTeststr_mn_Cyrl = " а боловсронгуй болгох орон нутгийн ажил үйлсийг уялдуулж зохицуулах дүрэм журам боловсруулах орон нутгийн өмч хөрөнгө санхүүгийн";
const char* kTeststr_mn_Mong = "ᠦᠭᠡ ᠵᠢᠨ ᠴᠢᠨᠭ᠎ᠠ ᠬᠦᠨᠳᠡᠢ ᠵᠢ ᠢᠯᠭᠠᠬᠣ";
const char* kTeststr_mr_Deva = "हैदराबाद  उच्चार ऐका (सहाय्य·माहिती)तेलुगू: హైదరాబాదు , उर्दू: حیدر آباد हे भारतातील आंध्र प्रदेश राज्याच्या राजधानीचे शहर आहे. हैदराबादची लोकसंख्या ७७ लाख ४० हजार ३३४ आहे. मोत्यांचे शहर अशी एकेकाळी ओळख असलेल्या या शहराला ऐतिहासिक, सांस्कृतिक आणि स्थापत्यशास्त्रीय वारसा लाभला आहे. १९९० नंतर शिक्षण आणि माहिती तंत्रज्ञान त्याचप्रमाणे औषधनिर्मिती आणि जैवतंत्रज्ञान क्षेत्रातील उद्योगधंद्यांची वाढ शहरात झाली. दक्षिण मध्य भारतातील पर्यटन आणि तेलुगू चित्रपटनिर्मितीचे हैदराबाद हे केंद्र आहे";
//const char* kTeststr_ms_Latn = "daripada dirinya hirako shinji seorang pemuda merujuk diri mereka sebagai vizard shinji telah cuba untuk menyakinkan ichigo untuk menyertai kumpulan mereka mengatakan bahawa hanya dia sahaja yang mampu mengajar ichigo teknik untuk mengawal hollow";
// From 10% testing part of new lang=ms scrape
const char* kTeststr_ms_Latn = "pengampunan beramai-ramai supaya mereka pulang ke rumah masing-masing. Orang-orang besarnya enggan mengiktiraf sultan yang dilantik oleh Belanda sebagai Yang DiPertuan Selangor. Orang ramai pula tidak mahu menjalankan perniagaan bijih timah dengan Belanda, selagi raja yang berhak tidak ditabalkan. Perdagang yang lain dibekukan terus kerana untuk membalas jasa beliau yang membantu Belanda menentang Riau, Johor dan Selangor. Di antara tiga orang Sultan juga dipandang oleh rakyat sebagai seorang sultan yang paling gigih. 1 | 2 SULTAN Sebagai ganti Sultan Ibrahim ditabalkan Raja Muhammad iaitu Raja Muda. Walaupun baginda bukan anak isteri pertama bergelar Sultan Muhammad bersemayam di Kuala Selangor juga. Pentadbiran baginda yang lemah itu menyebabkan Kuala Selangor menjadi sarang ioleh Cina di Lukut tidak diambil tindakan, sedangkan baginda sendiri banyak berhutang kepada 1";

const char* kTeststr_ms_Latn2 = "bilik sebelah berkata julai pada pm ladymariah hmm sume ni terpulang kepada individu mungkin anda bernasib baik selama ini dalam membeli hp yang bagus deli berkata julai pada pm walaupun bukan bahsa baku tp tetap bahasa melayu kan perubahan boleh dibuat";
const char* kTeststr_mt_Latn = " ata ikteb messaġġ lil indirizzi differenti billi tagħżilhom u tagħfas il buttuna ikteb żid numri tfittxijja tal kotba mur print home kotba minn pagni ghal pagna minn ghall ktieb ta aċċessa stieden habib iehor grazzi it tim tal gruppi google";
const char* kTeststr_my_Latn = " jyk ef oif gawgodcsifayvdrfhrnf bmawgrsm topf dsvj g mail tamumif avhvm atmif txjwgif yxrqhk avhvm efae m pwifavhvm ef ufkyfwdky help center odkyvmyg drsm ar avh dswjhar cgef rsm udkawdkifygw f tajzawgudk smedkifygw f jyd awmh g mail cool features rsm";
const char* kTeststr_my_Mymr = " တက္ကသုိလ္ မ္ဟ ပ္ရန္ လာ္ရပီးေနာက္ န္ဟစ္ အရ္ဝယ္ ဦးသန္ ့သည္ ပန္ းတနော္ အမ္ယုိးသား ေက္ယာင္ း";
const char* kTeststr_na_Latn = " arcol obabakaen riringa itorere ibibokiei ababaro min kuduwa airumena baoin tokin rowiowet itiket keram damadamit eigirow etoreiy row keitsito boney ibingo itsiw dorerin naoerodelaporte s nauruan dictionary a c a c d g h o p s t y aiquen ion eins aiquen";
const char* kTeststr_ne_Deva = "अरू ठाऊँबाटपनि खुलेको छ यो खाता अर अरू ठाऊँबाटपनि खुलेको छ यो खाता अर ू";
const char* kTeststr_nl_Latn = " a als volgt te werk om een configuratiebestand te maken sitemap gen py ebruik filters om de s op te geven die moeten worden toegevoegd of uitgesloten op basis van de opmaaktaal elke sitemap mag alleen de s bevatten voor een bepaalde opmaaktaal dit";
const char* kTeststr_nn_Latn = " a for verktylina til å hjelpa deg å nå oss merk at pagerank syninga ikkje automatisk kjem til å henta inn informasjon frå sider med argument dvs frå sider med eit i en dersom datamaskina di er plassert bak ein mellomtenar for vevsider kan det verka";
const char* kTeststr_no_Latn = " a er obligatorisk tidsforskyvning plassering av katalogsøk planinformasjon loggfilbane gruppenavn kontoinformasjon passord domene gruppeinformasjon alle kampanjesporing alternativ bruker grupper oppgaveplanlegger oppgavehistorikk kontosammendrag antall";
const char* kTeststr_nr_Latn = "ikomiti elawulako yegatja  emhlanganweni walo ]imithetho mgomo ye anc ibekwa malunga wayo begodu ubudosiphambili kugandelela lokho okutjhiwo yi  lokha nayithi abantu ngibo  ";

const char* kTeststr_nso_Latn = "Bophara bja Asia ekaba 8.6% bja lefase goba 29.4% bja naga ya lefase (ntle le mawatle). Asia enale badudu bao bakabago dimillione millione tše nne (4 billion) yeo e bago 60% ya badudi ba lefase ka bophara. A bapolelwa rena sefapanong mehleng ya Pontius Pilatus. A hlokofatšwa, A bolokwa, A tsoga ka letšatši la boraro, ka mo mangwalo a bolelago ka gona, a rotogela magodimong, ";
const char* kTeststr_ny_Latn = "Boma ndi gawo la dziko lomwe linapangidwa ndi cholinga chothandiza ntchito yolamulira. Kuŵalako kulikuunikabe mandita, Edipo nyima unalephera kugonjetsa kuŵalako.";
const char* kTeststr_oc_Latn = "  Pasmens, la classificacion pus admesa uei (segon Juli Ronjat e Pèire Bèc) agropa lei parlars deis Aups dins l'occitan vivaroaupenc e non dins lo dialècte provençau.";
const char* kTeststr_om_Latn = " afaan katalaa bork bork bork hiikaa jira hin argamne gareen barbaadame hin argamne gargarsa qube en gar bayee jira garee walitti firooman gareewwan walitti firooman fuula web akka tartiiba qubeetiin agarsiisi akka tartiiba qubeetiin agarsiisaa jira akka";
const char* kTeststr_or_Orya = "ଅକ୍ଟୋବର ଡିସେମ୍ବର";
const char* kTeststr_pa_Guru = " ਂ ਦਿਨਾਂ ਵਿਚ ਭਾਈ ਸਾਹਿਬ ਦੀ ਬੁੱਚੜ ਗੋਬਿੰਦ ਰਾਮ ਨਾਲ ਅੜਫਸ ਚੱਲ ਰਹੀ ਸੀ ਗੋਬਿੰਦ ਰਾਮ ਨੇ ਭਾਈ ਸਾਹਿਬ ਦੀਆਂ ਭੈਣਾ";
const char* kTeststr_pl_Latn = " a australii będzie widział inne reklamy niż użytkownik z kanady kierowanie geograficzne sprawia że reklamy są lepiej dopasowane do użytkownika twojej strony oznacza to także że możesz nie zobaczyć wszystkich reklam które są wyświetlane na";
const char* kTeststr_ps_Arab = " اتو مستقل رياست جوړ شو او د پخواني ادبي انجمن څانګې ددې رياست جز شوی او ددې انجمن د ژبې مديريت د پښتو ټولنې په لوی مديريت واوښت لوی مدير يې د";
const char* kTeststr_pt_Latn = " a abit prevê que a entrada desses produtos estrangeiros no mercado têxtil e vestuário do brasil possa reduzir os preços em cerca de a partir de má notícia para os empresários que terão que lutar para garantir suas margens de lucro mas boa notícia";
const char* kTeststr_qu_Latn = " is t ipanakunatapis rikuchinankupaq qanpa simiykipi noqaykoqpa uya jllanakunamanta kunan jamoq simikunaman qelqan tiyan watukuy qpa uyata qanpa llaqtaykipi llank anakuna simimanta yanapakuna simimanta mayqen llaqtallapis kay simimanta t ijray qpa qelqa";
const char* kTeststr_rm_Latn = " Cur ch’il chantun Turitg ha dà il dretg da votar a las dunnas (1970) è ella vegnida elegida en il cussegl da vischnanca da Zumikon per la Partida liberaldemocratica svizra (PLD). Da 1974 enfin 1982 è ella stada presidenta da vischnanca da Zumikon. L’onn 1979 è Elisabeth Kopp vegnida elegida en il Cussegl naziunal e reelegida quatter onns pli tard cun in resultat da sur 100 000 vuschs. L’onn 1984 è ella daventada vicepresidenta da la PLD.";
const char* kTeststr_rn_Latn = " ishaka mu ndero y abana bawe ganira n abigisha nimba hari ingorane izo ari zo zose ushobora gusaba kubonana n umwigisha canke kuvugana nawe kuri terefone inyuma y uko babarungikira urutonde rw amanota i muhira mu bisanzwe amashure aratumira abavyeyi";
const char* kTeststr_ro_Latn = " a anunţurilor reţineţi nu plătiţi pentru clicuri sau impresii ci numai atunci când pe site ul dvs survine o acţiune dorită site urile negative nu pot avea uri de destinaţie daţi instrucţiuni societăţii dvs bancare sau constructoare să";
const char* kTeststr_ro_Cyrl = "оперативэ а органелор ши институциилор екзекутиве ши а органелор жудичиаре але путерий де стат фиекэруй орган ал путерий де стат и се";
const char* kTeststr_ru_Cyrl = " а неправильный формат идентификатора дн назад";
const char* kTeststr_rw_Latn = " dore ibyo ukeneye kumenya ukwo watubona ibibazo byinshi abandi babaza ububonero byibibina google onjela ho izina dyikyibina kyawe onjela ho yawe mulugo kulaho ibyandiko byawe shyilaho tegula yawe tulubaka tukongeraho iyanya mishya buliko tulambula";
const char* kTeststr_sa_Deva = " ं क र्मणस् त स्य य त्कि ङ्चेह करो त्यय ं त स्माल् लोका त्पु नरै ति अस्मै लोका य क र्मण इ ति नु काम";
const char* kTeststr_sa_Latn = " brahmā tatraivāntaradhīyata tataḥ saśiṣyo vālmīkir munir vismayam āyayau tasya śiṣyās tataḥ sarve jaguḥ ślokam imaṃ punaḥ muhur muhuḥ prīyamāṇāḥ prāhuś ca bhṛśavismitāḥ samākṣaraiś caturbhir yaḥ pādair gīto";
const char* kTeststr_sco_Latn = " a gless an geordie runciman ower a gless an tamson their man preached a hale hoor aboot the glorious memories o forty three an backsliders an profane persons like esau an aboot jeroboam the son o nebat that gaed stravagin to anither kirk an made aa israel";
const char* kTeststr_sd_Arab = " اضافو ٿي ٿيو پر اها خبر عثمان کي بعد پيئي ته سگريٽ ڇڪيندڙ مسلمان نه هو بلڪ هندو هو دڪان تي پهچي عثمان ڪسبت کولي گراهڪن جي سيرب لاهڻ شروع ڪئي پر";
const char* kTeststr_sg_Latn = " atâa na âkotta zo me lâkwê angbâ gï tarrango nî âkotta zo tî koddoro nî âde agbû tenne nî na kate töngana mbênî kotta kpalle tî nzönî dutï tî halëzo pëpe atâa sô âla lü gbâ tî ândya tî mâi na sahngo asâra gbâ tî";
const char* kTeststr_si_Sinh = " අනුරාධ මිහිඳුකුල නමින් සකුරා ට ලිපියක් තැපෑලෙන් එවා තිබුණා කි ් රස්ටි ෂෙල්ටන් ප ් රනාන්දු ද";
const char* kTeststr_sit_NP = " dialekten in de roerstreek pierre bakkes oet roerstreek blz bewirk waordebook zónjig oktoeaber is t ieëste mofers waordebook oetgekaome dit waordebook is samegestèldj";
const char* kTeststr_sk_Latn = " a aktivovať reklamnú kampaň ak chcete kampaň pred spustením ešte prispôsobiť uložte ju ako šablónu a pokračujte v úprave vyberte si jednu z možností nižšie a kliknite na tlačidlo uložiť kampaň nastavenia kampane môžete ľubovoľne";
const char* kTeststr_sl_Latn = " adsense stanje prijave za google adsense google adsense račun je bil začasno zamrznjen pozdravljeni hvala za vaše zanimanje v google adsense po pregledu vaše prijavnice so naši strokovnjaki ugotovili da spletna stran ki je trenutno povezana z vašim";
const char* kTeststr_sm_Latn = " autu mea o lo totonu le e le minaomia matou te tuu i totonu i le faamatalaina o le suesuega i taimi uma mea o lo totonu fuafua i mea e tatau fa afoi tala mai le newsgroup mataupu fa afoi mai tala e ai le mataupu e ai totonu tusitala o le itu o faamatalaga";
const char* kTeststr_sn_Latn = " chete vanyori vanotevera vakabatsira kunyora zvikamu zvino kumba home tinyorere tsamba chikamu chakumbirwa hachina kuwanikwa chikamu ichi cheninge chakayiswa kuimwe nzvimbo mudhairekitori rino chimwe chikamu chopadhuze pane chinhu chatadza kushanda bad";
const char* kTeststr_so_Latn = " a oo maanta bogga koobaad ugu qoran yahey beesha caalamka laakiin si kata oo beesha caalamku ula guntato soomaaliya waxa aan shaki ku jirin in aakhirataanka dadka soomaalida oo kaliya ay yihiin ku soomaaliya ka saari kara dhibka ay ku jirto";
const char* kTeststr_sq_Latn = " a do të kërkoni nga beogradi që të njohë pavarësinë e kosovës zoti thaçi prishtina është gati ta njoh pavarësinë e serbisë ndërsa natyrisht se do të kërkohet një gjë e tillë që edhe beogradi ta njoh shtetin e pavarur dhe sovran të";
const char* kTeststr_sr_Cyrl = "балчак балчак на мапи србије уреди демографија у насељу балчак живи пунолетна становника а просечна старост становништва износи година";
//const char* kTeststr_sr_Latn = " autonomnih pokrajina saveznim zakonom može se propisati poseban sastav organizacija i delokrug saveta za poslove narodne odbrane članove saveta federacije bira na predlog predsedništva savezna skupština iz reda društveno političkih i drugih javnih";
const char* kTeststr_sr_Latn = "Društvo | četvrtak 1.08.2013 | 13:43 Krade se i izvorska voda Izvor:  Gornji Milanovac -- U gružanskom selu Belo Polje prošle noći ukradeno je više od 10.000 litara kojima je obijen bazen. Bazen je bio zaključan i propisno obezbeđen.";

const char* kTeststr_sr_ME_Latn = "savjet pobjeda a radi bržeg rada pošto rom radi sporije nego ram izvorni rom se isključuje a dio ram a se rezerviše te se u njega ne ploča procesor ram memorija grafička kartica zvučna kartica modem mrežna kartica napojna jedinica uređaji za pohranjivanje";
const char* kTeststr_ss_Latn = " bakhokhintsela yesikhashana bafake imininingwane ye akhawunti leliciniso kulelifomu nangabe akukafakwa imininingwane leliciniso imali lekhokhiwe angeke ifakwe kumkhokhintsela lofanele imininingwane ye akhawunti ime ngalendlela lelandzelako inombolo";
const char* kTeststr_st_Latn = " bang ba nang le thahasello matshwao a sehlooho thuto e thehilweng hodima diphetho ke tsela ya ho ruta le ho ithuta e totobatsang hantle seo baithuti ba lokelang ho se fihlella ntlhatheo eo e sebetsang ka yona ke ya hore titjhere o hlakisa pele seo";
const char* kTeststr_su_Latn =  "Nu ngatur kahirupan warga, keur kapentingan pamarentahan diatur ku RT, RW jeung Kepala Dusun, sedengkeun urusan adat dipupuhuan ku Kuncen jeung kepala adat. Sanajan Kampung Kuta teu pati anggang jeung lembur sejenna nu aya di wewengkon Desa Pasir Angin, tapi boh wangunan imah atawa tradisi kahirupan masarakatna nenggang ti nu lian.";
const char* kTeststr_sv_Latn = " a bort objekt från google desktop post äldst meny öretag dress etaljer alternativ för vad är inne yaste google skrivbord plugin program för nyheter google visa nyheter som är anpassade efter de artiklar som du läser om du till exempel läser";
const char* kTeststr_sw_Latn = " a ujumbe mpya jumla unda tafuta na angalia vikundi vya kujadiliana na kushiriki mawazo iliyopangwa kwa tarehe watumiaji wapya futa orodha hizi lugha hoja vishikanisho vilivyo dhaminiwa ujumbe sanaa na tamasha toka udhibitisho wa neno kwa haraka fikia";
const char* kTeststr_syr_Syrc = "ܐܕܪܝܣ ܓܛܘ ܫܘܪܝܐ ܡܢ ܦܪܢܣܐ ܡܢ ܐܣܦܢܝܐ ܚܐܪܘܬܐ ܒܐܕܪ ܒܢܝܣܢ ܫܛܝܚܘܬܐ ܟܠܢܝܐ ܡܝ̈ܐ ܒܥܠܡܐ";
const char* kTeststr_ta_Taml = " அங்கு ராஜேந்திர சோழனால் கட்டப்பட்ட பிரம்மாண்டமான சிவன் கோவில் ஒன்றும் உள்ளது தொகு";
const char* kTeststr_te_Telu = " ఁ దనర జయించిన తత్వ మరసి చూడఁ దాన యగును రాజయోగి యిట్లు తేజరిల్లుచు నుండు విశ్వదాభిరామ వినర వేమ";
const char* kTeststr_tg_Arab = "رادیو فردا راديوى آزادى";
const char* kTeststr_tg_Cyrl = " адолат ва инсондӯстиро бар фашизм нажодпарастӣ ва адоват тарҷеҳ додааст чоп кунед ба дигарон фиристед чоп кунед ба дигарон фиристед";
const char* kTeststr_th_Thai = " กฏในการค้นหา หรือหน้าเนื้อหา หากท่านเลือกลงโฆษณา ท่านอาจจะปรับต้องเพิ่มงบประมาณรายวันตา";
const char* kTeststr_ti_Ethi = " ሃገር ተረፎም ዘለዉ ኢትዮጵያውያን ኣብቲ ምስ ኢትዮጵያ ዝዳውብ ኣውራጃ ደቡብ ንኽነብሩ ኣይፍቀደሎምን እዩ ካብ ሃገር ንኽትወጽእ ዜጋ ኹን ወጻእተኛ ናይ";
const char* kTeststr_tk_Cyrl = " айдянларына ынанярмыка эхли боз мейданлары сурулип гутарылан тебигы ота гарып гумлукларда миллиондан да артыкмач ири шахлы малы миллиона";
const char* kTeststr_tk_Latn = " akyllylyk çyn söýgi üçin böwet däl de tebigylykdyr duýgularyň gödeňsiligi aç açanlygy bahyllygy söýgini betnyşanlyk derejesine düşürýändir söýeni söý söýmedige süýkenme özüni söýmeýändigini görmek ýigit üçin uly";
const char* kTeststr_tl_Latn = " a na ugma sa google ay nakaka bantog sa gitna nang kliks na nangyayari sa pamamagitan nang ordinaryong paggagamit at sa kliks na likha nang pandaraya o hindi tunay na paggamit bunga nito nasasala namin ang mga kliks na hindi kailangan o hindi gusto nang";
const char* kTeststr_tl_Tglg = " ᜋᜇ᜔ ᜐᜓᜎᜆ᜔ ᜃ ᜈᜅ᜔ ᜊᜌ᜔ᜊᜌᜒᜈ᜔ ᜂᜉᜅ᜔᜔ ᜋᜐᜈᜌ᜔ ᜎᜅ᜔ ᜁᜐ ᜉᜅ᜔ ᜀᜃ᜔ᜎᜆ᜔ ᜆᜓᜅ᜔ᜃᜓᜎ᜔ ᜐ ᜊᜌ᜔ᜊᜌᜒᜈ᜔ ᜐ ᜆᜒᜅᜒᜈ᜔ ᜃᜓ";
const char* kTeststr_tlh_Latn = " a ghuv bid soh naq jih lodni yisov chich wo vamvo qeylis lunge pu chah povpu vodleh a dah ghah cho ej dah wo che pujwi bommu tlhegh darinmohlahchu pu majqa horey so lom qa ip quv law may vad suvtahbogh wa sanid utlh quv pus datu pu a vitu chu pu johwi tar";
const char* kTeststr_tn_Latn = " go etela batla ditsebe tsa web tse di nang le le batla ditsebe tse di golaganya le tswang mo leka go batla web yotlhe batla mo web yotlhe go bona home page ya google batla mo a o ne o batla gore a o ne o batla ditsebe tsa bihari batla mo re maswabi ga go";
const char* kTeststr_to_Latn = " a ke kumi oku ikai ke ma u vakai ki hono hokohoko faka alafapeti api pe ko e uluaki peesi a ho o fekumi faka malatihi fekumi ki he lea oku fakaha atu pe ko ha fonua fekumi ki he fekumi ki he peesi oku ngaahi me a oku sai imisi alu ki he ki he ulu aki";
const char* kTeststr_tr_Latn = " a ayarlarınızı görmeniz ve yönetmeniz içindir eğer kampanyanız için günlük bütçenizi gözden geçirebileceğiniz yeri arıyorsanız kampanya yönetimi ne gidin kampanyanızı seçin ve kampanya ayarlarını düzenle yi tıklayın sunumu";
const char* kTeststr_ts_Latn = " a ku na timhaka leti nga ta vulavuriwa na google google yi hlonipha yi tlhela yi sirheleta vanhu hinkwavo lava tirhisaka google toolbar ku dyondza hi vusireleli eka system ya hina hi kombela u hlaya vusireleli bya hina eka toolbar mbulavulo wu tshikiwile";
const char* kTeststr_tt_Cyrl = "ачарга да бирмәде чәт чәт килеп тора безнең абыйнымы олы абыйнымы эштән";
const char* kTeststr_tt_Latn = " alarnı eşkärtü proğramnarın eşläwen däwam itü tatar söylämen buldıru wä sizep alu sistemnarın eşläwen däwat itü häm başqalar yılnıñ mayında tatar internetı ictimağıy oyışması milli ts isemle berençe däräcäle häm tat";
const char* kTeststr_tw_Latn = " amammui tumidifo no bɛtow ahyɛ atoro som so mpofirim na wɔasɛe no pasaa ma ayɛ nwonwa dɛn na ɛbɛka wɔn ma wɔayɛ saa bible no ma ho mmuae wɔ adiyisɛm nhoma no mu sɛ onyankopɔn na ɔde hyɛɛ wɔn komam sɛ wɔmma ne nsusuwii mmra mu";
const char* kTeststr_ug_Arab = " ئالەملەرنىڭ پەرۋەردىگارىدىن تىلەيمەن سىلەر بۇ يەرلەردە باغچىلاردىن بۇلاقلاردىن زىرائەتلەردىن يۇمشاق پىشقان خورمىلاردىن بەھرىمەن بولۇپ";
const char* kTeststr_ug_Cyrl = " а башлиди әмма бу қетимқи канада мәтбуатлириниң хәвәрлиридә илгирикидәк хитай һөкүмәт мәтбуатлиридин нәқил алидиған вә уни көчүрүп";
const char* kTeststr_ug_Latn = " adawet bolghachqa hazir musherrepmu bu ikki partiyining birleshme hökümet qurushta pikir birliki hasil qilalmasliqini kütüwatqan iken wehalenki pakistan xelq partiyisining rehbiri asif eli zerdari pakistandiki bashqa ushshaq partiyilerning rehberliri";
const char* kTeststr_uk_Cyrl = " а більший бюджет щоб забезпечити собі максимум прибутків від переходів відстежуйте свої об яви за датою географічним розташуванням";
const char* kTeststr_ur_Arab = " آپ کو کم سے کم ممکنہ رقم چارج کرتا ہے اس کی مثال کے طور پر فرض کریں اگر آپ کی زیادہ سے زیادہ قیمت فی کلِک امریکی ڈالر اور کلِک کرنے کی شرح ہو تو";
const char* kTeststr_uz_Arab = " آرقلی بوتون سیاسی حزب و گروه لرفعالیتیگه رخصت بیرگن اخبارات واسطه لری شو ییل مدتیده مثال سیز ترقی تاپکن و اهالی نینگ اقتصادی وضعیتی اوتمیش";
const char* kTeststr_uz_Cyrl = " а гапирадиган бўлсак бунинг иккита йўли бор биринчиси мана шу қуриган сатҳини қумликларни тўхтатиш учун экотизимни мустаҳкамлаш қумга";
const char* kTeststr_uz_Latn = " abadiylashtirildi aqsh ayol prezidentga tayyormi markaziy osiyo afg onistonga qanday yordam berishi mumkin ukrainada o zbekistonlik muhojirlar tazyiqdan shikoyat qilmoqda gruziya va ukraina hozircha natoga qabul qilinmaydi afg oniston o zbekistonni g";
const char* kTeststr_ve_Latn = "Vho ṱanganedzwa kha Wikipedia nga tshiVenḓa. Vhadivhi vha manwalo a TshiVenda vha talusa divhazwakale na vhubvo ha Vhavenda ngau fhambana. Vha tikedza mbuno dzavho uya nga mawanwa a thoduluso dze vha ita. Vhanwe vha vhatodulusi vhari Vhavenda vho tumbuka Afrika vhukati vha tshimbila vha tshiya Tshipembe ha Afrika, Rhodesia hune ha vho vhidzwa Zimbagwe namusi.";
const char* kTeststr_vi_Latn = " adsense cho nội dung nhà cung cấp dịch vụ di động xác minh tín dụng thay đổi nhãn kg các ô xem chi phí cho từ chối các đơn đặt hàng dạng cấp dữ liệu ác minh trang web của bạn để xem";
const char* kTeststr_vo_Latn = " brefik se volapükavol nüm balid äpubon ün dü lif lölik okas redakans älaipübons gasedi at nomöfiko äd ai mu kuratiko pläo timü koup nedäna fa ns deutän kü päproibon fa koupanef me gased at ästeifülom ad propagidön volapüki as sam ün";
const char* kTeststr_war_Latn = "Amo ini an balay han Winaray o Binisaya nga Lineyte-Samarnon nga Wikipedia, an libre ngan gawasnon nga ensayklopedya nga bisan hin-o puyde magliwat o mag-edit. An Wikipedia syahan gintikang ha Iningles nga yinaknan han tuig 2001. Ini nga bersyon Winaray gintikang han ika-25 han Septyembre 2005 ngan ha yana mayda 514,613 nga artikulo. Kon karuyag niyo magsari o magprobar, pakadto ha . An Gastrotheca pulchra[2] in uska species han Anura nga ginhulagway ni Ulisses Caramaschi ngan Rodrigues hadton 2007. An Gastrotheca pulchra in nahilalakip ha genus nga Gastrotheca, ngan familia nga Hemiphractidae.[3][4] Ginklasipika han IUCN an species komo kulang hin datos.[1] Waray hini subspecies nga nakalista.[3]";
const char* kTeststr_wo_Latn = " am ak dëgg dëggam ak gëm aji bind ji te gëstu ko te jëfandikoo tegtalu xel ci saxal ko sokraat nag jëfandikoo woon na xeltu ngir tas jikko yu rafet ci biir nit ñi ak dëggu ak soppante sokraat nag ñëw na mook aflaton platon sukkandiku ci ñaari";
const char* kTeststr_xh_Latn = " a naynga zonke futhi libhengezwa kwiwebsite yebond yasemzantsi afrika izinga elisebenzayo xa usenza olu tyalo mali liya kusebenza de liphele ixesha lotyalo mali lwakho inzala ihlawulwa rhoqo emva kweenyanga ezintandathu ngomhla wamashumi amathathu ananye";
const char* kTeststr_xx_Bugi = "ᨄᨛᨑᨊᨒ ᨑᨗ ᨔᨒᨗᨓᨛ ᨕᨗᨋᨗᨔᨗ ᨒᨛᨄ ᨑᨛᨔᨛᨆᨗᨊ";
const char* kTeststr_xx_Goth = "𐌰 𐌰𐌱𐍂𐌰𐌷𐌰𐌼 𐌰𐌲𐌲𐌹𐌻𐌹𐍃𐌺𐍃 𐌸𐌹𐌿𐌳𐌹𐍃𐌺𐍃 𐍆𐍂𐌰𐌲𐌺𐌹𐍃𐌺𐍃";
const char* kTeststr_yi_Hebr = "און פאנטאזיע ער איז באקאנט צים מערסטן פאר זיינע באַלאַדעס ער האָט געוווינט אין ווארשע יעס פאריס ליווערפול און לאנדאן סוף כל סוף איז ער";
const char* kTeststr_yo_Latn = " abinibi han ikawe alantakun le ni opolopo ede abinibi ti a to lesese bi eniyan to fe lo se fe lati se atunse jowo mo pe awon oju iwe itakunagbaye miran ti ako ni oniruru ede abinibi le faragba nipa atunse ninu se iwadi blogs ni ori itakun agbaye ti e ba";
const char* kTeststr_za_Hani = " 两个宾语的字数较少时 只带一个动词 否则就带两个动词 三句子类 从句子方面去谈汉 壮语结构格式相异的类型的 叫句子类 汉 壮语中 句子类结构格式有差别的自然不少";
const char* kTeststr_za_Latn = " dih yinzminz ndaej daengz bujbienq youjyau dih cingzyin caeuq cinhingz diuz daihit boux boux ma daengz lajmbwn couh miz cwyouz cinhyenz caeuq genzli bouxboux bingzdaengj gyoengq vunz miz lijsing caeuq liengzsim wngdang daih gyoengq de lumj beixnuengx";
const char* kTeststr_zh_Hans = "产品的简报和公告 提交该申请后无法进行更改 请确认您的选择是正确的 对于要提交的图书 我确认 我是版权所有者或已得到版权所有者的授权 要更改您的国家 地区 请在此表的最上端更改您的";
const char* kTeststr_zh_Hant = " 之前為 帳單交易作業區 已變更 廣告內容 之前為 銷售代表 之前為 張貼日期為 百分比之前為 合約 為 目標對象條件已刪除 結束日期之前為";
const char* kTeststr_zu_Latn = " ana engu uma inkinga iqhubeka siza ubike kwi isexwayiso ngenxa yephutha lomlekeleli sikwazi ukubuyisela emuva kuphela imiphumela engaqediwe ukuthola imiphumela eqediwe zama ukulayisha kabusha leli khasi emizuzwini engu uma inkinga iqhubeka siza uthumele";
const char* kTeststr_zzb_Latn = "becoose a ve a leemit qooereees tu vurds um gesh dee bork bork nu peges vere a fuoond cunteeening is a fery cummun vurd und ves nut inclooded in yuoor seerch zee ooperetur is unnecessery ve a incloode a ell seerch terms by deffoolt um de hur de hur de hur";
const char* kTeststr_zze_Latn = " a diffewent type of seawch send feedback about google wiwewess seawch to wap google com wesuwts found on de entiwe web fow wesuwts found on de mobiwe web fow de functionawity of de toolbar up button has been expanded swightwy it now considews fow exampwe";
const char* kTeststr_zzh_Latn = " b x z un b e t und rs n a dr ss p as ry an th r a dr ss ry us n a l ss mb gu us c ti n l ke a z p c d n a dr ss nt r d pl as en r n a dr ss y ur s ar h f r n ar d d n t m tch ny l c ti n w th n m l s nd m r r at d p g s th l c ti ns b l w w r ut m t ca y";
const char* kTeststr_zzp_Latn = " away ackupbay editcray ardcay ybay isitingvay ouryay illingbay eferencespray agepay orway isitvay ethay adwordsway elphay entrecay orfay oremay etailsday adwordsway ooglegay omcay upportsay";

// Two very close Wikipedia page beginnings
const char* kTeststr_ms_close = "sukiyaki wikipedia bahasa melayu ensiklopedia bebas sukiyaki dari wikipedia bahasa melayu ensiklopedia bebas lompat ke navigasi gelintar sukiyaki sukiyaki  hirisan tipis daging lembu sayur sayuran dan tauhu di dalam periuk besi yang dimasak di atas meja makan dengan cara rebusan sukiyaki dimakan dengan mence";
const char* kTeststr_id_close = "sukiyaki wikipedia indonesia ensiklopedia bebas berbahasa bebas berbahasa indonesia langsung ke navigasi cari untuk pengertian lain dari sukiyaki lihat sukiyaki irisan tipis daging sapi sayur sayuran dan tahu di dalam panci besi yang dimasak di atas meja makan dengan cara direbus sukiyaki dimakan dengan mence";

// Simple intermixed French/English text
const char* kTeststr_fr_en_Latn =
                                  "France is the largest country in Western Europe and the third-largest in Europe as a whole. "
                                  "A accès aux chiens et aux frontaux qui lui ont été il peut consulter et modifier ses collections et exporter "
                                  "Cet article concerne le pays européen aujourd’hui appelé République française. Pour d’autres usages du nom France, "
                                  "Pour une aide rapide et effective, veuiller trouver votre aide dans le menu ci-dessus."
                                  "Motoring events began soon after the construction of the first successful gasoline-fueled automobiles. The quick brown fox jumped over the lazy dog";

// This can be used to cross-check the build date of the main quadgram table
const char* kTeststr_version = "qpdbmrmxyzptlkuuddlrlrbas las les qpdbmrmxyzptlkuuddlrlrbas el la qpdbmrmxyzptlkuuddlrlrbas";


#else


const char* kTeststr_aa_Latn = " nagay tanito nagay tanto nagayna naharsi nahrur nake nala nammay nammay haytu nanu narig ne ni num numu o obare obe obe obisse oggole ogli olloyta ongorowe orbise othoga r rabe rade ra e rage rakub rasitte rasu reyta rog ruddi ruga s sa al bada sa ala";
const char* kTeststr_ab_Cyrl = " \xD0\xB0 \xD0\xB7\xD1\x83\xD0\xB0 \xD0\xB0\xD0\xB1\xD0\xB7\xD0\xB8\xD0\xB0\xD1\x80\xD0\xB0 \xD0\xB4\xD0\xB0\xD2\x9B\xD3\x99\xD1\x88\xD3\x99\xD0\xBE\xD0\xB8\xD1\x82 \xD0\xB0\xD0\xBD \xD0\xBB\xD1\x8B\xD0\xB1\xD0\xB7\xD0\xB8\xD0\xB0\xD0\xB1\xD0\xB0\xD1\x80\xD0\xB0 \xD0\xB0\xD1\x85\xD3\x99 \xD0\xB0\xD0\xBC\xD0\xB0\xD3\xA1\xD0\xB0\xD0\xBC \xD0\xB0\xD1\x83\xD0\xB0\xD2\xA9\xD1\x8B \xD0\xB8\xD0\xB3\xD3\x99\xD1\x8B \xD0\xB8\xD2\xAD\xD0\xBE\xD1\x83 \xD0\xB8\xD1\x85\xD1\x8B \xD0\xB8\xD2\xBF\xD1\x8B \xD0\xB8\xD0\xB0\xD0\xBD\xD1\x83\xD0\xB1\xD0\xB0\xD0\xB0\xD0\xBB\xD0\xBE\xD0\xB8\xD1\x82 \xD0\xB0\xD2\xA7\xD2\xB3\xD3\x99\xD1\x8B\xD1\x81 \xD2\xA7\xD1\x88\xD3\xA1\xD0\xB0 \xD0\xB0\xD1\x85\xD0\xB0\xD1\x86\xD3\x99\xD0\xB0 \xD0\xBB\xD1\x8B\xD1\x88\xD1\x8C\xD2\xAD\xD0\xBE\xD1\x83\xD0\xBF \xD0\xB0\xD2\xBF\xD0\xB0\xD0\xB0\xD1\x81\xD2\xAD\xD0\xB0 \xD0\xBB\xD0\xB0\xD1\x80\xD0\xB0 \xD0\xB4\xD1\x80\xD1\x8B\xD1\x88\xD1\x8C\xD2\xAD\xD0\xBE\xD1\x83\xD0\xBF";
const char* kTeststr_af_Latn = " aam skukuza die naam beteken hy wat skoonvee of hy wat alles onderstebo keer wysig bosveldkampe boskampe is kleiner afgele\xC3\xAB ruskampe wat oor min fasiliteite beskik daar is geen restaurante of winkels nie en slegs oornagbesoekers word toegelaat bateleur";
const char* kTeststr_ak_Latn = "W\xC9\x94woo Hilla Limann Mumu-\xC6\x86p\xC9\x9Bnimba 12 afe 1934. W\xC9\x94woo no w\xC9\x94 Gwollu w\xC9\x94 Sisala Mantaw mu Nna ne maame y\xC9\x9B Mma Hayawah. Ne papa so nna \xC9\x94y\xC9\x9B Babini Yomu. \xC6\x86warr Fulera Limann ? Ne mba y\xC9\x9B esuon-- Lariba Montia [w\xC9\x94woo no Limann]; Baba Limann; Sibi Andan [w\xC9\x94woo no Limann]; Lida Limann; Danni Limann; Zilla Limann na Salma Limann. \xC6\x86tenaa ase k\xC9\x94pemm Sanda-Kwakwa da \xC9\x9Bt\xC9\x94 so 23 w\xC9\x94 afe 1998 w\xC9\x94 ?.";
const char* kTeststr_am_Ethi = " \xE1\x88\x88\xE1\x88\x98\xE1\x8C\xA0\xE1\x8B\xAD\xE1\x89\x85 \xE1\x8B\x88\xE1\x8B\xB0 \xE1\x8A\xA5\xE1\x88\xB5\xE1\x8A\xAD\xE1\x8A\x95\xE1\x8B\xB5\xE1\x88\xAD\xE1\x8B\xAB \xE1\x88\x8B\xE1\x8A\xA9\xE1\x8B\x8B\xE1\x89\xB8\xE1\x8B\x8D\xE1\x8A\x93 \xE1\x8B\xA8\xE1\x8A\xA5\xE1\x88\xB5\xE1\x8A\xAD\xE1\x8A\x95\xE1\x8B\xB5\xE1\x88\xAD\xE1\x8B\xAB \xE1\x8C\xB3\xE1\x8C\xB3\xE1\x88\xB5 \xE1\x8A\xA0\xE1\x89\xB4\xE1\x8A\x93\xE1\x88\xB5\xE1\x8B\xAE\xE1\x88\xB5 \xE1\x8D\x8D\xE1\x88\xAC\xE1\x88\x9D\xE1\x8A\x95\xE1\x8C\xA6\xE1\x88\xB5\xE1\x8A\x95 \xE1\x8A\xA5\xE1\x88\xAB\xE1\x88\xB3\xE1\x89\xB8\xE1\x8B\x8D\xE1\x8A\x95 \xE1\x88\xBE\xE1\x88\x98\xE1\x8B\x8D \xE1\x88\x8D\xE1\x8A\xA8\xE1\x8B\x8B\xE1\x88\x8D \xE1\x8A\xA8\xE1\x8B\x9A\xE1\x8B\xAB \xE1\x8A\xA5\xE1\x88\xB5\xE1\x8A\xA8 \xE1\x8B\x93 \xE1\x88\x9D \xE1\x8B\xB5\xE1\x88\xA8\xE1\x88\xB5 \xE1\x8B\xA8\xE1\x8A\xA2\xE1\x89\xB5\xE1\x8B\xAE\xE1\x8C\xB5\xE1\x8B\xAB \xE1\x8A\xA0\xE1\x89\xA1\xE1\x8A\x90";
const char* kTeststr_ar_Arab = "\xD8\xA7\xD8\xAD\xD8\xAA\xD9\x8A\xD8\xA7\xD9\x84\xD9\x8A\xD8\xA9 \xD8\xA8\xD9\x8A\xD8\xB9 \xD8\xA3\xD9\x8A \xD8\xAD\xD8\xB3\xD8\xA7\xD8\xA8";
const char* kTeststr_as_Beng = "\xE0\xA6\x85\xE0\xA6\x9E\xE0\xA7\x8D\xE0\xA6\x9A\xE0\xA6\xB2 \xE0\xA6\xA8\xE0\xA6\xA4\xE0\xA7\x81\xE0\xA6\xA8 \xE0\xA6\xB8\xE0\xA6\xA6\xE0\xA6\xB8\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xAC\xE0\xA7\x83\xE0\xA6\xA8\xE0\xA7\x8D\xE0\xA6\xA6 \xE0\xA6\xB8\xE0\xA6\x95\xE0\xA6\xB2\xE0\xA7\x8B\xE0\xA7\xB1\xE0\xA7\x87 \xE0\xA6\xAD\xE0\xA7\xB0\xE0\xA7\x8D\xE0\xA6\xA4\xE0\xA6\xBF \xE0\xA6\xB9\xE0\xA6\xAC \xE0\xA6\xAA\xE0\xA6\xBE\xE0\xA7\xB0\xE0\xA7\x87 \xE0\xA6\xAE\xE0\xA7\x81\xE0\xA6\xB2 \xE0\xA6\xAA\xE0\xA7\x83\xE0\xA6\xB7\xE0\xA7\x8D\xE0\xA6\xA0\xE0\xA6\xBE \xE0\xA6\x9C\xE0\xA6\xA8 \xE0\xA6\xB2\xE0\xA7\x87\xE0\xA6\x96\xE0\xA6\x95 \xE0\xA6\x97\xE0\xA7\x81\xE0\xA6\x97 \xE0\xA6\xB2 \xE0\xA6\xA6\xE0\xA6\xB2 \xE0\xA6\xB8\xE0\xA6\xBE\xE0\xA7\xB0\xE0\xA6\xBE\xE0\xA6\x82\xE0\xA6\xB6 \xE0\xA6\x87 \xE0\xA6\xAA\xE0\xA6\xA4\xE0\xA7\x8D\xE0\xA7\xB0 \xE0\xA6\x9F\xE0\xA6\xBE \xE0\xA6\xAC\xE0\xA6\xBE\xE0\xA7\xB0\xE0\xA7\x8D\xE0\xA6\xA4\xE0\xA6\xBE \xE0\xA6\x8F\xE0\xA6\x9C\xE0\xA6\xA8";
const char* kTeststr_ay_Latn = " aru wijar aru ispa\xC3\xB1ula ukaran aru witanam aru kurti aru kalis aru warani aru malta aru yatiyawi niya jakitanaka isluwi\xC3\xB1 aru lmir phuran aru masirunan aru purtukal aru kruwat aru jakira urtu aru inklisa pirsan aru suyku aru malay aru jisk aptayma thaya";
const char* kTeststr_az_Arab = " \xD8\xA2\xD8\xB0\xD8\xB1\xD8\xA8\xD8\xA7\xDB\x8C\xD8\xAC\xD8\xA7\xD9\x86 \xD8\xAF\xD8\xA7 \xD8\xA7\xD9\x86\xD8\xB3\xD8\xA7\xD9\x86 \xD8\xAD\xD8\xA7\xD9\x82\xD9\x84\xD8\xA7\xD8\xB1\xDB\x8C \xD8\xA7\xD8\xA6\xD9\x88\xDB\x8C \xD8\xA2\xDA\x86\xDB\x8C\xD9\x84\xD8\xA7\xD8\xAC\xD8\xA7\xD9\x82 \xD8\xA8 \xD9\x85 \xD8\xAA \xD8\xA7\xD8\xA6\xD9\x84\xDA\x86\xD9\x8A\xD8\xB3\xD9\x8A \xD8\xA8\xD8\xB1\xD9\x85\xD9\x87 \xD9\x85\xD9\x88\xD8\xAE\xD8\xA7\xD9\x84\xD9\x8A\xD9\x81\xD8\xAA\xD9\x8A \xD9\x86\xD9\x8A\xD9\x86 \xD9\x84\xD9\x8A\xD8\xAF\xD8\xA6\xD8\xB1\xD9\x8A \xD8\xA7\xD9\x8A\xD9\x84\xD9\x87 \xDA\xAF\xD8\xA4\xD8\xB1\xD9\x88\xD8\xB4\xD9\x87 \xD8\xA8\xD9\x8A\xD9\x84\xD9\x8A\xD8\xA8 \xD8\xAA\xD8\xB1\xD8\xB3 \xD8\xB4\xD9\x88\xD9\x88\xD9\x86\xD9\x8A\xD8\xB3\xD9\x85 \xD9\x81\xD8\xA7\xD8\xB1\xD8\xB3 \xD8\xA7\xD8\xB2 \xD8\xA2\xD8\xB2\xD8\xA7\xD8\xAF\xD9\x8A \xD9\x85\xD9\x84\xD8\xAA\xD9\x87\xD8\xA7\xD9\x8A \xD8\xAA\xD9\x88\xD8\xB1\xDA\xA9\xD9\x85\xD9\x86";
const char* kTeststr_az_Latn = " a az qal\xC4\xB1\x62 breyn rinq intellektual oyunu \xC3\xBCzr\xC9\x99 yar\xC4\xB1\xC5\x9F\xC4\xB1n zona m\xC9\x99rh\xC9\x99l\xC9\x99l\xC9\x99ri ke\xC3\xA7irilib miq un qal\xC4\xB1qlar\xC4\xB1n\xC4\xB1n d\xC9\x99nizd\xC9\x99n \xC3\xA7\xC4\xB1xar\xC4\xB1lmas\xC4\xB1 davam edir m\xC9\x99h\xC9\x99mm\xC9\x99\x64 pey\xC4\x9F\xC9\x99mb\xC9\x99rin karikaturalar\xC4\xB1n\xC4\xB1 \xC3\xA7\x61p ed\xC9\x99n q\xC9\x99zetin ba\xC5\x9F redaktoru i\xC5\x9F ota\xC4\x9F\xC4\xB1nda \xC3\xB6l\xC3\xBC\x62";
const char* kTeststr_ba_Cyrl = " \xD0\xB0\xD1\x80\xD0\xBD\xD0\xB0\xD0\xBB\xD1\x92\xD0\xB0\xD0\xBD \xD0\xB1\xD1\x8B\xD0\xBD\xD0\xB4\xD0\xB0\xD0\xB9 \xD1\x92\xD0\xB8\xD0\xBB\xD0\xBC\xD0\xB8 \xD1\x8D\xD1\x88 \xD1\x82\xD1\x96\xD1\x80\xD0\xBA\xD0\xB8\xD1\x9A\xD0\xBB\xD1\x9A \xD1\x82\xD1\x9A\xD1\x98\xD0\xB3\xD0\xB5 \xD1\x82\xD0\xB0\xD0\xBF\xD1\x94\xD1\x8B\xD1\x80 \xD0\xBD\xD1\x9A\xD1\x88\xD0\xB5\xD1\x80 \xD0\xB8\xD1\x82\xD0\xB5\xD0\xBB\xD1\x9A \xD2\x93\xD0\xB8\xD0\xBD\xD1\x83\xD0\xB0\xD1\x80 \xD0\xB1\xD1\x94\xD1\x85\xD0\xB5\xD1\x82 \xD0\xB8\xD0\xBC\xD0\xB5\xD0\xBD\xD0\xBB\xD0\xB5\xD0\xBA\xD1\x82\xD1\x94 \xD0\xB5\xD1\x82\xD0\xB5\xD1\x88\xD0\xBB\xD0\xB5\xD0\xBA\xD1\x82\xD1\x94 \xD0\xB0\xD1\x83\xD1\x8B\xD0\xBB \xD1\x9E\xD1\x9C\xD0\xBC\xD0\xB5\xD1\x80\xD1\x9F\xD1\x94\xD1\x80\xD0\xB5 \xD1\x85\xD0\xB5\xD1\x9F\xD0\xBC\xD1\x94\xD1\x82 \xD1\x8E\xD0\xBB\xD1\x8B\xD0\xBD \xD1\x9B\xD0\xB0\xD0\xB9\xD0\xBB\xD0\xB0\xD1\x93\xD0\xB0\xD0\xBD\xD0\xB4\xD0\xB0";
const char* kTeststr_be_Cyrl = " \xD0\xB0 \xD0\xB4\xD1\x80\xD1\x83\xD0\xBA\xD0\xB0\xD0\xB2\xD0\xB0\xD1\x86\xD1\x8C \xD1\x96\xD1\x85 \xD0\xBD\xD0\xB5 \xD0\xB1\xD1\x8B\xD0\xBB\xD0\xBE \xD1\x82\xD1\x8D\xD1\x85\xD0\xBD\xD1\x96\xD1\x87\xD0\xBD\xD0\xB0 \xD0\xBC\xD0\xB0\xD0\xB3\xD1\x87\xD1\x8B\xD0\xBC\xD0\xB0 \xD0\xB1\xD0\xBB\xD1\x96\xD0\xB6\xD1\x8D\xD0\xB9 \xD0\xB7\xD0\xB0 \xD0\xB2\xD1\x96\xD0\xBB\xD1\x8C\xD0\xBD\xD1\x8E \xD1\x82\xD1\x8B\xD0\xBC \xD1\x81\xD0\xB0\xD0\xBC\xD1\x8B\xD0\xBC \xD1\x87\xD0\xB0\xD1\x81\xD0\xB0\xD0\xBC \xD0\xBD\xD1\x8F\xD0\xBC\xD0\xB5\xD1\x86\xD0\xBA\xD0\xB0\xD0\xB5 \xD0\xBA\xD1\x96\xD1\x80\xD0\xB0\xD1\x9E\xD0\xBD\xD1\x96\xD1\x86\xD1\x82\xD0\xB2\xD0\xB0 \xD0\xBF\xD1\x80\xD0\xB0\xD0\xBF\xD0\xB0\xD0\xBD\xD0\xBE\xD1\x9E\xD0\xB2\xD0\xB0\xD0\xBB\xD0\xB0 \xD0\xB0\xD0\xBF\xD1\x80\xD0\xBE\xD1\x87 \xD1\x9E\xD0\xB2\xD1\x8F\xD0\xB4\xD0\xB7\xD0\xB5\xD0\xBD\xD0\xBD\xD1\x8F \xD0\xBB\xD0\xB0\xD1\x86\xD1\x96\xD0\xBD\xD0\xBA\xD1\x96 \xD1\x8F\xD0\xB5";
const char* kTeststr_bg_Cyrl = " \xD0\xB0 \xD0\xB4\xD1\x83\xD0\xBC\xD0\xB0 \xD0\xBF\xD0\xBE\xD0\xBF\xD0\xB0\xD0\xB4\xD0\xB0 \xD0\xB2 \xD1\x81\xD1\x8A\xD1\x81\xD1\x82\xD0\xBE\xD1\x8F\xD0\xBD\xD0\xB8\xD0\xB5 \xD0\xBD\xD0\xB0 \xD0\xB8\xD0\xB7\xD0\xBF\xD0\xB8\xD1\x82\xD0\xB0\xD0\xBD\xD0\xB8\xD0\xB5 \xD0\xBA\xD0\xBB\xD1\x8E\xD1\x87\xD0\xBE\xD0\xB2\xD0\xB8\xD1\x82\xD0\xB5 \xD0\xB4\xD1\x83\xD0\xBC\xD0\xB8 \xD1\x81 \xD0\xBF\xD1\x80\xD0\xB5\xD0\xB4\xD1\x81\xD0\xBA\xD0\xB0\xD0\xB7\xD0\xB0\xD0\xBD\xD0\xB0 \xD0\xBC\xD0\xB0\xD0\xBB\xD0\xBA\xD0\xBE \xD0\xBF\xD0\xBE\xD0\xB4 \xD1\x82\xD0\xBE \xD0\xB8\xD0\xB7\xD0\xB8\xD1\x81\xD0\xBA\xD0\xB2\xD0\xB0\xD0\xBD\xD0\xB5 \xD0\xBD\xD0\xB0 \xD1\x81\xD1\x82\xD1\x80\xD0\xB0\xD0\xBD\xD0\xB8\xD1\x86\xD0\xB8\xD1\x82\xD0\xB5 \xD0\xB7\xD0\xB0 \xD1\x82\xD1\x8A\xD1\x80\xD1\x81\xD0\xB5\xD0\xBD\xD0\xB5 \xD0\xB2";
//const char* kTeststr_bh_Deva = " \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA4\xBF\xE0\xA4\xAA\xE0\xA5\x80\xE0\xA4\xA1\xE0\xA4\xBF\xE0\xA4\xAF\xE0\xA4\xBE \xE0\xA4\x87\xE0\xA4\x82\xE0\xA4\x9F\xE0\xA4\xB0\xE0\xA4\xA8\xE0\xA5\x87\xE0\xA4\x9F \xE0\xA4\x86\xE0\xA4\xA7\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA4\xBF\xE0\xA4\xA4 \xE0\xA4\x8F\xE0\xA4\x95 \xE0\xA4\xAE\xE0\xA5\x81\xE0\xA4\x95\xE0\xA5\x8D\xE0\xA4\xA4 \xE0\xA4\x9C\xE0\xA5\x8D\xE0\xA4\x9E\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA4\x95\xE0\xA5\x8B\xE0\xA4\xB7 \xE0\xA4\xAA\xE0\xA4\xB0\xE0\xA4\xBF\xE0\xA4\xAF\xE0\xA5\x8B\xE0\xA4\x9C\xE0\xA4\xA8\xE0\xA4\xBE \xE0\xA4\xB9 \xE0\xA4\x88 \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA4\xBF \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xB0\xE0\xA5\x81\xE0\xA4\xAA \xE0\xA4\xAE\xE0\xA5\x87\xE0\xA4\x81 \xE0\xA4\xAC\xE0\xA4\xBE \xE0\xA4\xAF\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA5\x80 \xE0\xA4\x8F\xE0\xA4\x97\xE0\xA5\x8B \xE0\xA4\x85\xE0\xA4\x88\xE0\xA4\xB8\xE0\xA4\xA8 \xE0\xA4\x9C\xE0\xA4\xBE\xE0\xA4\xB2 \xE0\xA4\xAA\xE0\xA5\x83\xE0\xA4\xB7\xE0\xA5\x8D\xE0\xA4\xA0 \xE0\xA4\x9C\xE0\xA5\x87 \xE0\xA4\xB8\xE0\xA4\xAD\xE0\xA4\xA8 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xB8\xE0\xA4\x82\xE0\xA4\xAA\xE0\xA4\xBE\xE0\xA4\xA6\xE0\xA4\xA8 \xE0\xA4\x95\xE0\xA4\xB0\xE0\xA5\x87 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\x9B\xE0\xA5\x82\xE0\xA4\x9F \xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB5\xE0\xA5\x87\xE0\xA4\xB2\xE0\xA4\xBE \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA4\xBF\xE0\xA4\xAA\xE0\xA5\x80\xE0\xA4\xA1\xE0\xA4\xBF\xE0\xA4\xAF\xE0\xA4\xBE \xE0\xA4\xB6\xE0\xA4\xAC\xE0\xA5\x8D\xE0\xA4\xA6 \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA4\xBF \xE0\xA4\x85\xE0\xA4\x89\xE0\xA4\xB0 \xE0\xA4\x87\xE0\xA4\xA8\xE0\xA4\xB8\xE0\xA4\xBE\xE0\xA4\x87\xE0\xA4\x95\xE0\xA5\x8D\xE0\xA4\xB2\xE0\xA5\x8B\xE0\xA4\xAA\xE0\xA5\x80\xE0\xA4\xA1\xE0\xA4\xBF\xE0\xA4\xAF\xE0\xA4\xBE \xE0\xA4\x9C\xE0\xA5\x8D\xE0\xA4\x9E\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA4\x95\xE0\xA5\x8B\xE0\xA4\xB7 \xE0\xA4\xB6\xE0\xA4\xAC\xE0\xA5\x8D\xE0\xA4\xA6\xE0\xA4\xA8 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xAE\xE0\xA4\xBF\xE0\xA4\xB2\xE0\xA4\xBE \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xAC\xE0\xA4\xA8\xE0\xA4\xB2 \xE0\xA4\xAC\xE0\xA4\xBE \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA4\xBF\xE0\xA4\xAA\xE0\xA5\x80\xE0\xA4\xA1\xE0\xA4\xBF\xE0\xA4\xAF\xE0\xA4\xBE \xE0\xA4\x8F\xE0\xA4\x95 \xE0\xA4\xAC\xE0\xA4\xB9\xE0\xA5\x81\xE0\xA4\xAD\xE0\xA4\xBE\xE0\xA4\xB7\xE0\xA5\x80\xE0\xA4\xAF \xE0\xA4\xAA\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\x95\xE0\xA4\xB2\xE0\xA5\x8D\xE0\xA4\xAA \xE0\xA4\xB9 \xE0\xA4\x85\xE0\xA4\x89\xE0\xA4\xB0 \xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xB5\xE0\xA4\xAF\xE0\xA4\x82\xE0\xA4\xB8\xE0\xA5\x87\xE0\xA4\xB5\xE0\xA4\x95\xE0\xA4\xA8 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xB8\xE0\xA4\xB9\xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xB0 \xE0\xA4\xB8\xE0\xA5\x87 \xE0\xA4\xA8\xE0\xA4\xBF\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xAE\xE0\xA4\xBF\xE0\xA4\xA4 \xE0\xA4\xAC\xE0\xA4\xBE \xE0\xA4\x9C\xE0\xA5\x87\xE0\xA4\xB9\xE0\xA5\x81 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xAD\xE0\xA5\x80 \xE0\xA4\x87\xE0\xA4\x82\xE0\xA4\x9F\xE0\xA4\xB0\xE0\xA4\xA8\xE0\xA5\x87\xE0\xA4\x9F \xE0\xA4\xA4\xE0\xA4\x95 \xE0\xA4\xAA\xE0\xA4\xB9\xE0\xA5\x81\xE0\xA4\x81\xE0\xA4\x9A \xE0\xA4\xAC\xE0\xA4\xBE \xE0\xA4\x8A \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA4\xBF\xE0\xA4\xAA\xE0\xA5\x80\xE0\xA4\xA1\xE0\xA4\xBF\xE0\xA4\xAF\xE0\xA4\xBE \xE0\xA4\xAA\xE0\xA4\xB0 \xE0\xA4\xB2\xE0\xA4\xBF\xE0\xA4\x96 \xE0\xA4\xB8\xE0\xA4\x95\xE0\xA4\xA4 \xE0\xA4\xAC\xE0\xA4\xBE \xE0\xA4\x85\xE0\xA4\x89\xE0\xA4\xB0 \xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\x96\xE0\xA4\xA8 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xB8\xE0\xA4\x82\xE0\xA4\xAA\xE0\xA4\xBE\xE0\xA4\xA6\xE0\xA4\xA8 \xE0\xA4\x95\xE0\xA4\xB0 \xE0\xA4\xB8\xE0\xA4\x95\xE0\xA4\xA4 \xE0\xA4\xAC\xE0\xA4\xBE";
// From 10% testing part of new lang=bh scrape
const char* kTeststr_bh_Deva = "\xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xB2 \xE0\xA4\xAE\xE0\xA5\x87\xE0\xA4\x82 \xE0\xA4\x89\xE0\xA4\xA8\xE0\xA4\x95\xE0\xA4\xBE \xE0\xA4\xB9\xE0\xA4\xAE\xE0\xA4\xB2\xE0\xA4\xBE \xE0\xA4\xB8\xE0\xA5\x87 \xE0\xA4\xAC\xE0\xA4\x9A\xE0\xA5\x87 \xE0\xA4\x96\xE0\xA4\xBE\xE0\xA4\xA4\xE0\xA5\x80 \xE0\xA4\x8F\xE0\xA4\xB9\xE0\xA4\xBF\xE0\xA4\x9C\xE0\xA4\xBE \xE0\xA4\xAD\xE0\xA4\xBE\xE0\xA4\x97 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\x85\xE0\xA4\x87\xE0\xA4\xB2\xE0\xA5\x87 \xE0\xA4\x86 \xE0\xA4\xAD\xE0\xA5\x8B\xE0\xA4\x9C\xE0\xA4\xAA\xE0\xA5\x81\xE0\xA4\xB0 \xE0\xA4\xA8\xE0\xA4\xBE\xE0\xA4\xAE \xE0\xA4\xB8\xE0\xA5\x87 \xE0\xA4\xA8\xE0\xA4\x97\xE0\xA4\xB0 \xE0\xA4\xAC\xE0\xA4\xB8\xE0\xA4\xB5\xE0\xA4\xB2\xE0\xA5\x87. \xE0\xA4\x8F\xE0\xA4\x95\xE0\xA4\xB0\xE0\xA4\xBE \xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA5\x87 \xE0\xA4\xAE\xE0\xA5\x87\xE0\xA4\x82 \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xA4\xE0\xA4\xBE\xE0\xA4\xB0 \xE0\xA4\xB8\xE0\xA5\x87 \xE0\xA4\x9C\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA5\x80 \xE0\xA4\xA8\xE0\xA5\x80\xE0\xA4\x9A\xE0\xA5\x87 \xE0\xA4\xA6\xE0\xA5\x80\xE0\xA4\xB9\xE0\xA4\xB2 \xE0\xA4\x97\xE0\xA4\x87\xE0\xA4\xB2 \xE0\xA4\xAC\xE0\xA4\xBE. \xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\x95\xE0\xA4\xBF\xE0\xA4\xB0 \xE0\xA4\x86\xE0\xA4\xB6\xE0\xA5\x8D\xE0\xA4\x9A\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\x9C\xE0\xA4\xA8\xE0\xA4\x95 \xE0\xA4\xB0\xE0\xA5\x82\xE0\xA4\xAA \xE0\xA4\xB8\xE0\xA5\x87 \xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xB2\xE0\xA4\xB5\xE0\xA4\xBE \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\x9C\xE0\xA4\xBE \xE0\xA4\xAD\xE0\xA5\x8B\xE0\xA4\x9C \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xAC\xE0\xA4\xBF\xE0\xA4\xB9\xE0\xA4\xBE\xE0\xA4\xB0 \xE0\xA4\x86\xE0\xA4\xB5\xE0\xA5\x87 \xE0\xA4\x86 \xE0\xA4\xAD\xE0\xA5\x8B\xE0\xA4\x9C\xE0\xA4\xAA\xE0\xA5\x81\xE0\xA4\xB0 \xE0\xA4\xA8\xE0\xA4\x97\xE0\xA4\xB0 \xE0\xA4\xAC\xE0\xA4\xB8\xE0\xA4\xBE\xE0\xA4\xB5\xE0\xA5\x87 \xE0\xA4\x86 \xE0\xA4\x9A\xE0\xA4\xBE\xE0\xA4\xB9\xE0\xA5\x87 \xE0\xA4\xAD\xE0\xA5\x8B\xE0\xA4\x9C\xE0\xA4\xAA\xE0\xA5\x81\xE0\xA4\xB0\xE0\xA5\x80 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xB8\xE0\xA4\xBE\xE0\xA4\xA5\xE0\xA5\x87 \xE0\xA4\x89\xE0\xA4\xA8\xE0\xA4\x95\xE0\xA4\xB0 \xE0\xA4\x95\xE0\xA4\xB5\xE0\xA4\xA8\xE0\xA5\x8B \xE0\xA4\xB8\xE0\xA4\x82\xE0\xA4\xAC\xE0\xA4\x82\xE0\xA4\xA7 \xE0\xA4\xB9\xE0\xA5\x8B\xE0\xA4\x96\xE0\xA5\x87 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\x95\xE0\xA4\xB5\xE0\xA4\xA8\xE0\xA5\x8B \xE0\xA4\x9C\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA5\x80 \xE0\xA4\xAD\xE0\xA5\x8B\xE0\xA4\xAA\xE0\xA4\xBE\xE0\xA4\xB2 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xAD\xE0\xA5\x8B\xE0\xA4\x9C \xE0\xA4\xB8\xE0\xA4\x82\xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xA5\xE0\xA4\xBE\xE0\xA4\xA8 \xE0\xA4\x86 \xE0\xA4\x9A\xE0\xA4\xBE\xE0\xA4\xB9\xE0\xA5\x87 \xE0\xA4\xAE\xE0\xA4\xA7\xE0\xA5\x8D\xE0\xA4\xAF \xE0\xA4\xAA\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB6 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\x87\xE0\xA4\xA4\xE0\xA4\xBF\xE0\xA4\xB9\xE0\xA4\xBE\xE0\xA4\xB8\xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xB0 \xE0\xA4\xB2\xE0\xA5\x8B\xE0\xA4\x97\xE0\xA4\xA8 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xA4\xE0\xA4\xA8\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA5\x8B \xE0\xA4\xA8\xE0\xA4\x87\xE0\xA4\x96\xE0\xA5\x87. \xE0\xA4\xB9\xE0\xA4\xBE\xE0\xA4\xB2\xE0\xA4\xBE\xE0\xA4\x82\xE0\xA4\x95\xE0\xA4\xBF \xE0\xA4\x8A \xE0\xA4\xB8\xE0\xA4\xAC \xE0\xA4\xB2\xE0\xA5\x8B\xE0\xA4\x97 \xE0\xA4\x8F\xE0\xA4\xB9 \xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\xA4 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA4\xA4 \xE0\xA4\xAC\xE0\xA4\xBE \xE0\xA4\x95\xE0\xA4\xBF \xE0\xA4\x8F\xE0\xA4\x95\xE0\xA4\xB0\xE0\xA4\xBE \xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA5\x87 \xE0\xA4\xAE\xE0\xA5\x87\xE0\xA4\x82 \xE0\xA4\x85\xE0\xA4\xAC\xE0\xA4\xB9\xE0\xA5\x80\xE0\xA4\x82 \xE0\xA4\xA4\xE0\xA4\x95\xE0\xA4\xB2\xE0\xA5\x87 \xE0\xA4\xAE\xE0\xA5\x82\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xA4\xE0\xA4\xBF \xE0\xA4\xAC\xE0\xA4\xA8\xE0\xA4\xB5\xE0\xA4\x87\xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\x82. \xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\x9C\xE0\xA4\xBE \xE0\xA4\xAD\xE0\xA5\x8B\xE0\xA4\x9C \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\x9C\xE0\xA4\xB5\xE0\xA4\xA8\xE0\xA4\xBE \xE0\xA4\x9C\xE0\xA4\x97\xE0\xA4\xB9\xE0\xA4\xBE \xE0\xA4\xAA\xE0\xA4\xBD \xE0\xA4\xB5\xE0\xA4\xBE\xE0\xA4\x97\xE0\xA5\x8D\xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB5\xE0\xA5\x80 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xA6\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xB6\xE0\xA4\xA8 \xE0\xA4\xAD\xE0\xA4\x87\xE0\xA4\xB2 \xE0\xA4\xB0\xE0\xA4\xB9\xE0\xA5\x87, \xE0\xA4\x93\xE0\xA4\xB9\xE0\xA5\x80 \xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xA5\xE0\xA4\xBE\xE0\xA4\xA8 \xE0\xA4\xAA\xE0\xA4\xBD \xE0\xA4\x8F\xE0\xA4\xB9 \xE0\xA4\xAE\xE0\xA5\x82\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xA4\xE0\xA4\xBF \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xA5\xE0\xA4\xBE\xE0\xA4\xAA\xE0\xA4\xA8\xE0\xA4\xBE \xE0\xA4\x95\xE0\xA4\x87\xE0\xA4\xB2 \xE0\xA4\x97\xE0\xA4\x87\xE0\xA4\xB2. \xE0\xA4\x85\xE0\xA4\xAC \xE0\xA4\x85\xE0\xA4\x97\xE0\xA4\xB0 \xE0\xA4\x8F\xE0\xA4\xB9 \xE0\xA4\xAE\xE0\xA4\x82\xE0\xA4\xA6\xE0\xA4\xBF\xE0\xA4\xB0 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\x8F\xE0\xA4\xB9 \xE0\xA4\xB6\xE0\xA4\xBF\xE0\xA4\xB2\xE0\xA4\xBE\xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\x96 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xA4\xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xB5\xE0\xA5\x80\xE0\xA4\xB0 (\xE0\xA4\xAA\xE0\xA5\x83\xE0\xA4\xB7\xE0\xA5\x8D\xE0\xA4\xA0 \xE0\xA4\xB8\xE0\xA4\x82\xE0\xA4\x96\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xBE 33 \xE0\xA4\xAA\xE0\xA4\xBD \xE0\xA4\xAA\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xB6\xE0\xA4\xBF\xE0\xA4\xA4) \xE0\xA4\xB0\xE0\xA4\x89\xE0\xA4\x86 \xE0\xA4\xA7\xE0\xA5\x87\xE0\xA4\xAF\xE0\xA4\xBE\xE0\xA4\xA8 \xE0\xA4\xB8\xE0\xA5\x87 \xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\x96\xE0\xA5\x80\xE0\xA4\x82 \xE0\xA4\xA4\xE0\xA4\xBD \xE0\xA4\x8F\xE0\xA4\x95\xE0\xA4\xB0\xE0\xA4\xBE \xE0\xA4\xAA\xE0\xA4\xBD \xE0\xA4\x95\xE0\xA5\x88\xE0\xA4\xA5\xE0\xA5\x80 \xE0\xA4\xB2\xE0\xA4\xBF\xE0\xA4\xAA\xE0\xA4\xBF \xE0\xA4\xAE\xE0\xA5\x87\xE0\xA4\x82 -\xE0\xA4\xB8\xE0\xA5\x80\xE0\xA4\xA4\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xAE- \xE0\xA4\xB2\xE0\xA4\xBF\xE0\xA4\x96\xE0\xA4\xB2 \xE0\xA4\xB8\xE0\xA4\xBE\xE0\xA4\xAB \xE0\xA4\xB2\xE0\xA4\x89\xE0\xA4\x95\xE0\xA4\xA4 \xE0\xA4\xAC\xE0\xA4\xBE. \xE0\xA4\x95\xE0\xA5\x88\xE0\xA4\xA5\xE0\xA5\x80 \xE0\xA4\xAD\xE0\xA5\x8B\xE0\xA4\x9C\xE0\xA4\xAA\xE0\xA5\x81\xE0\xA4\xB0\xE0\xA5\x80 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xAC\xE0\xA4\xB9\xE0\xA5\x81\xE0\xA4\xA4 \xE0\xA4\xAA\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\x9A\xE0\xA4\xB2\xE0\xA4\xBF\xE0\xA4\xA4 \xE0\xA4\xB2\xE0\xA4\xBF\xE0\xA4\xAA\xE0\xA4\xBF \xE0\xA4\xB0\xE0\xA4\xB9\xE0\xA4\xB2 \xE0\xA4\xAC\xE0\xA4\xBF\xE0\xA4\xAF\xE0\xA4\xBE. \xE0\xA4\x8F\xE0\xA4\x95\xE0\xA4\xB0\xE0\xA4\xBE \xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA5\x87 \xE0\xA4\xAE\xE0\xA5\x87\xE0\xA4\x82 \xE0\xA4\x95\xE0\xA4\xB5\xE0\xA4\xA8\xE0\xA5\x8B \xE0\xA4\xB6\xE0\xA4\x82\xE0\xA4\x95\xE0\xA4\xBE \xE0\xA4\xB8\xE0\xA4\x82\xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB9 \xE0\xA4\xAC\xE0\xA4\xBF\xE0\xA4\xB9\xE0\xA4\xBE\xE0\xA4\xB0-\xE0\xA4\xAF\xE0\xA5\x82\xE0\xA4\xAA\xE0\xA5\x80 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\x9C\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xB0 \xE0\xA4\xB2\xE0\xA5\x8B\xE0\xA4\x97\xE0\xA4\xA8 \xE0\xA4\xAE\xE0\xA5\x87\xE0\xA4\x82 \xE0\xA4\xA8\xE0\xA4\x87\xE0\xA4\x96\xE0\xA5\x87. \xE0\xA4\x8F\xE0\xA4\xB2. \xE0\xA4\x8F\xE0\xA4\xB8. \xE0\xA4\x8F\xE0\xA4\xB8. \xE0\xA4\xB5\xE0\xA5\x8B \xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xB2\xE0\xA5\x87 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\xB2\xE0\xA4\xBF\xE0\xA4\x96\xE0\xA4\xB2 \xE0\xA4\xAA\xE0\xA4\xA2\xE0\xA4\xBC\xE0\xA5\x80\xE0\xA4\x82 ";

const char* kTeststr_bi_Latn = " king wantaem nomo hem i sakem setan mo ol rabis enjel blong hem oli aot long heven oli kamdaon long wol taswe ol samting oli kam nogud olgeta long wol ya stat long revelesen ol faet kakae i sot ol sik mo fasin blong brekem loa oli kam antap olgeta samting";
const char* kTeststr_blu_Latn = " Kuv hlub koj txawm lub ntuj yuav si ntshi nphaus los kuv tsis ua siab nkaug txawm ntiab teb yuav si ntshi nphaus los kuv tseem ua lon tsaug vim kuv hlub koj tag lub siab";
const char* kTeststr_blu_Latn2 = "Kuv hnov Txhiaj Xeeb Vaj, co-owner of Hmong Village Shopping Center, hais ua hnub ua hmo tias kom Hmoob yuav tsum txhawb Hmoob thiab listed cov mini-shops uas nyob rau hauv nws lub MALL txhua txhua kom sawv daws mus txhawb, tiam sis uas cas zaum twg twb pom nws mus kav kiav hauv taj laj qhabmeem (Sun Foods) xwb tiag. Nag hmo kuv pom nws mus shopping nrog nws poj niam hauv Sun Foods. Thaum tawm mus txog nraum parking lot kuv thiaj txhob txwm mus ze ze seb ua li nws mus yuav dab tsi tiag, thiab seb tej uas nws yuav ntawd puas muaj nyob ntawm tej kiab khw Hmoob. Surprised!!! Vuag.... txhua yam nws yuav hauv Sun Foods peb Hmoob cov khw yeej muaj tag nrho. Peb niaj hnub nqua hu kom Hmoob yuav tsum pab Hmoob yog pab li no lod?";
//const char* kTeststr_bn_Beng = " \xE0\xA6\x82\xE0\xA6\x96\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xBE \xE0\xA6\xA8\xE0\xA6\xAE\xE0\xA7\x81\xE0\xA6\xA8\xE0\xA6\xBE\xE0\xA6\xAF\xE0\xA6\xBC\xE0\xA6\xA8 \xE0\xA6\xAC\xE0\xA6\xBF\xE0\xA6\xA8\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xBE\xE0\xA6\xB8 \xE0\xA6\xAA\xE0\xA6\xB0\xE0\xA6\xBF\xE0\xA6\xB8\xE0\xA6\x82\xE0\xA6\x96\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xBE\xE0\xA6\xA8\xE0\xA6\xBF\xE0\xA6\x95 \xE0\xA6\xAE\xE0\xA6\xA1\xE0\xA7\x87\xE0\xA6\xB2 \xE0\xA6\xAA\xE0\xA6\xB0\xE0\xA6\xBF\xE0\xA6\xB8\xE0\xA6\x82\xE0\xA6\x96\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xBE\xE0\xA6\xA8\xE0\xA6\xBF\xE0\xA6\x95 \xE0\xA6\xB8\xE0\xA6\xBF\xE0\xA6\xA6\xE0\xA7\x8D\xE0\xA6\xA7\xE0\xA6\xBE\xE0\xA6\xA8\xE0\xA7\x8D\xE0\xA6\xA4 \xE0\xA6\xAB\xE0\xA6\xBE\xE0\xA6\x82\xE0\xA6\xB6\xE0\xA6\xA8 \xE0\xA6\xAA\xE0\xA6\xB0\xE0\xA6\xBF\xE0\xA6\xB8\xE0\xA6\x82\xE0\xA6\x96\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xBE\xE0\xA6\xA8\xE0\xA6\xBF\xE0\xA6\x95";
// From 10% testing part of new lang=bn scrape
const char* kTeststr_bn_Beng = "\xE0\xA6\x97\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xBE\xE0\xA6\xB2\xE0\xA6\xBE\xE0\xA6\xB0\xE0\xA6\xBF\xE0\xA6\xB0 \xE0\xA7\xA9\xE0\xA7\xAE \xE0\xA6\xAC\xE0\xA6\x9B\xE0\xA6\xB0 \xE0\xA6\xAA\xE0\xA7\x82\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xA4\xE0\xA6\xBF\xE0\xA6\xA4\xE0\xA7\x87 \xE0\xA6\xAE\xE0\xA7\x82\xE0\xA6\xB2\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\x9B\xE0\xA6\xBE\xE0\xA7\x9C \xE0\xA6\x85\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xA5\xE0\xA6\xA8\xE0\xA7\x80\xE0\xA6\xA4\xE0\xA6\xBF \xE0\xA6\xAC\xE0\xA6\xBF\xE0\xA6\x8F\xE0\xA6\xA8\xE0\xA6\xAA\xE0\xA6\xBF\xE0\xA6\xB0 \xE0\xA6\x93\xE0\xA7\x9F\xE0\xA6\xBE\xE0\xA6\x95 \xE0\xA6\x86\xE0\xA6\x89\xE0\xA6\x9F \xE0\xA6\xA4\xE0\xA6\xAA\xE0\xA6\xA8 \xE0\xA6\x9A\xE0\xA7\x8C\xE0\xA6\xA7\xE0\xA7\x81\xE0\xA6\xB0\xE0\xA7\x80 \xE0\xA6\xB9\xE0\xA6\xBE\xE0\xA6\xB0\xE0\xA6\xAC\xE0\xA6\xBE\xE0\xA6\xB2 \xE0\xA6\x85\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xBE\xE0\xA6\xB8\xE0\xA7\x8B\xE0\xA6\xB8\xE0\xA6\xBF\xE0\xA7\x9F\xE0\xA7\x87\xE0\xA6\xB6\xE0\xA6\xA8\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\xB8\xE0\xA6\xAD\xE0\xA6\xBE\xE0\xA6\xAA\xE0\xA6\xA4\xE0\xA6\xBF \xE0\xA6\x86\xE0\xA6\xA8\xE0\xA7\x8D\xE0\xA6\xA4\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\x9C\xE0\xA6\xBE\xE0\xA6\xA4\xE0\xA6\xBF\xE0\xA6\x95 \xE0\xA6\xAA\xE0\xA6\xB0\xE0\xA6\xBE\xE0\xA6\xAE\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xB6\xE0\xA6\x95 \xE0\xA6\xAC\xE0\xA7\x8B\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xA1 \xE0\xA6\xA6\xE0\xA6\xBF\xE0\xA7\x9F\xE0\xA7\x87 \xE0\xA6\xB6\xE0\xA6\xB0\xE0\xA6\xBF\xE0\xA7\x9F\xE0\xA6\xBE\xE0\xA6\xB9\xE0\xA7\x8D \xE0\xA6\x87\xE0\xA6\xA8\xE0\xA6\xA8\xE0\xA7\x8D\xE0\xA6\xA1\xE0\xA7\x87\xE0\xA6\x95\xE0\xA7\x8D\xE0\xA6\xB8 \xE0\xA6\x95\xE0\xA6\xB0\xE0\xA6\xAC\xE0\xA7\x87 \xE0\xA6\xB8\xE0\xA6\xBF\xE0\xA6\x8F\xE0\xA6\xB8\xE0\xA6\x87 \xE0\xA6\xAE\xE0\xA6\xBE\xE0\xA6\xB2\xE0\xA6\xBF\xE0\xA6\x95\xE0\xA6\xAA\xE0\xA6\x95\xE0\xA7\x8D\xE0\xA6\xB7\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\x95\xE0\xA6\xBE\xE0\xA6\xA8\xE0\xA7\x8D\xE0\xA6\xA8\xE0\xA6\xBE, \xE0\xA6\xB6\xE0\xA7\x8D\xE0\xA6\xB0\xE0\xA6\xAE\xE0\xA6\xBF\xE0\xA6\x95\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\x85\xE0\xA6\xA8\xE0\xA6\xBF\xE0\xA6\xB6\xE0\xA7\x8D\xE0\xA6\x9A\xE0\xA7\x9F\xE0\xA6\xA4\xE0\xA6\xBE \xE0\xA6\xAE\xE0\xA6\xA4\xE0\xA6\xBF\xE0\xA6\x9D\xE0\xA6\xBF\xE0\xA6\xB2\xE0\xA7\x87 \xE0\xA6\xB8\xE0\xA6\xAE\xE0\xA6\xBE\xE0\xA6\xAC\xE0\xA7\x87\xE0\xA6\xB6 \xE0\xA6\xA8\xE0\xA6\xBF\xE0\xA6\xB7\xE0\xA6\xBF\xE0\xA6\xA6\xE0\xA7\x8D\xE0\xA6\xA7: \xE0\xA6\x8F\xE0\xA6\xAB\xE0\xA6\xAC\xE0\xA6\xBF\xE0\xA6\xB8\xE0\xA6\xBF\xE0\xA6\xB8\xE0\xA6\xBF\xE0\xA6\x86\xE0\xA6\x87\xE0\xA7\x9F\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\xA7\xE0\xA6\xA8\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xAC\xE0\xA6\xBE\xE0\xA6\xA6 \xE0\xA6\xAC\xE0\xA6\xBF\xE0\xA6\xA8\xE0\xA7\x8B\xE0\xA6\xA6\xE0\xA6\xA8 \xE0\xA6\xAC\xE0\xA6\xBF\xE0\xA6\xB6\xE0\xA7\x87\xE0\xA6\xB7 \xE0\xA6\xAA\xE0\xA7\x8D\xE0\xA6\xB0\xE0\xA6\xA4\xE0\xA6\xBF\xE0\xA6\xAC\xE0\xA7\x87\xE0\xA6\xA6\xE0\xA6\xA8 \xE0\xA6\xAC\xE0\xA6\xBE\xE0\xA6\x82\xE0\xA6\xB2\xE0\xA6\xBE\xE0\xA6\xB2\xE0\xA6\xBF\xE0\xA6\x82\xE0\xA6\x95\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\x97\xE0\xA7\x8D\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xBE\xE0\xA6\xA8\xE0\xA7\x8D\xE0\xA6\xA1\xE0\xA6\xAE\xE0\xA6\xBE\xE0\xA6\xB8\xE0\xA7\x8D\xE0\xA6\x9F\xE0\xA6\xBE\xE0\xA6\xB0 \xE0\xA6\xB8\xE0\xA6\xBF\xE0\xA6\x9C\xE0\xA6\xA8-\xE0\xA7\xA9 \xE0\xA6\xAC\xE0\xA7\x8D\xE0\xA6\xB0\xE0\xA6\xBE\xE0\xA6\x9C\xE0\xA6\xBF\xE0\xA6\xB2\xE0\xA7\x87 \xE0\xA6\xAC\xE0\xA6\xBF\xE0\xA6\xB6\xE0\xA7\x8D\xE0\xA6\xAC\xE0\xA6\x95\xE0\xA6\xBE\xE0\xA6\xAA \xE0\xA6\xAB\xE0\xA7\x81\xE0\xA6\x9F\xE0\xA6\xAC\xE0\xA6\xB2 \xE0\xA6\x86\xE0\xA7\x9F\xE0\xA7\x8B\xE0\xA6\x9C\xE0\xA6\xA8\xE0\xA6\xAC\xE0\xA6\xBF\xE0\xA6\xB0\xE0\xA7\x8B\xE0\xA6\xA7\xE0\xA7\x80 \xE0\xA6\xAC\xE0\xA6\xBF\xE0\xA6\x95\xE0\xA7\x8D\xE0\xA6\xB7\xE0\xA7\x8B\xE0\xA6\xAD \xE0\xA6\xA6\xE0\xA7\x87\xE0\xA6\xB6\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\xA8\xE0\xA6\xBF\xE0\xA6\xB0\xE0\xA6\xBE\xE0\xA6\xAA\xE0\xA6\xA4\xE0\xA7\x8D\xE0\xA6\xA4\xE0\xA6\xBE\xE0\xA6\xB0  \xE0\xA6\x9A\xE0\xA7\x87\xE0\xA7\x9F\xE0\xA7\x87 \xE0\xA6\x85\xE0\xA6\xA8\xE0\xA7\x87\xE0\xA6\x95 \xE0\xA6\xAC\xE0\xA7\x87\xE0\xA6\xB6\xE0\xA6\xBF \xE0\xA6\xB8\xE0\xA6\x9A\xE0\xA7\x87\xE0\xA6\xA4\xE0\xA6\xA8 \xE0\xA5\xA4 \xE0\xA6\xAA\xE0\xA7\x8D\xE0\xA6\xB0\xE0\xA6\xBE\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xA5\xE0\xA7\x80\xE0\xA6\xA6\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\xA6\xE0\xA6\x95\xE0\xA7\x8D\xE0\xA6\xB7\xE0\xA6\xA4\xE0\xA6\xBE  \xE0\xA6\x93 \xE0\xA6\xAF\xE0\xA7\x87\xE0\xA6\xBE\xE0\xA6\x97\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA6\xA4\xE0\xA6\xBE\xE0\xA6\xB0 \xE0\xA6\xAA\xE0\xA6\xBE\xE0\xA6\xB6\xE0\xA6\xBE\xE0\xA6\xAA\xE0\xA6\xBE\xE0\xA6\xB6\xE0\xA6\xBF \xE0\xA6\xA4\xE0\xA6\xBE\xE0\xA6\xB0\xE0\xA6\xBE \xE0\xA6\x9C\xE0\xA6\xBE\xE0\xA6\xA4\xE0\xA7\x80\xE0\xA7\x9F \xE0\xA6\x87\xE0\xA6\xB8\xE0\xA7\x8D\xE0\xA6\xAF\xE0\xA7\x81\xE0\xA6\x97\xE0\xA7\x81\xE0\xA6\xB2\xE0\xA7\x8B\xE0\xA6\xA4\xE0\xA7\x87 \xE0\xA6\xAA\xE0\xA7\x8D\xE0\xA6\xB0\xE0\xA6\xBE\xE0\xA6\xA7\xE0\xA6\xBE\xE0\xA6\xA8\xE0\xA7\x8D\xE0\xA6\xAF \xE0\xA6\xA6\xE0\xA6\xBF\xE0\xA7\x9F\xE0\xA7\x87\xE0\xA6\x9B\xE0\xA7\x87\xE0\xA6\xA8 \xE0\xA5\xA4 \xE2\x80\x9D \xE0\xA6\xAA\xE0\xA6\xBE\xE0\xA6\x81\xE0\xA6\x9A\xE0\xA6\x9F\xE0\xA6\xBF \xE0\xA6\xB8\xE0\xA6\xBF\xE0\xA6\x9F\xE0\xA6\xBF\xE0\xA6\xA4\xE0\xA7\x87 \xE0\xA7\xA8\xE0\xA7\xA6 \xE0\xA6\xB2\xE0\xA6\xBE\xE0\xA6\x96 \xE0\xA6\xAD\xE0\xA7\x8B\xE0\xA6\x9F\xE0\xA6\xBE\xE0\xA6\xB0\xE0\xA6\xA6\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\xA6\xE0\xA6\xBF\xE0\xA7\x9F\xE0\xA7\x87 \xE0\xA6\x9C\xE0\xA6\xBE\xE0\xA6\xA4\xE0\xA7\x80\xE0\xA7\x9F \xE0\xA6\xA8\xE0\xA6\xBF\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xAC\xE0\xA6\xBE\xE0\xA6\x9A\xE0\xA6\xA8\xE0\xA7\x87 \xE0\xA7\xAE \xE0\xA6\x95\xE0\xA7\x8B\xE0\xA6\x9F\xE0\xA6\xBF \xE0\xA6\xAD\xE0\xA7\x8B\xE0\xA6\x9F\xE0\xA6\xBE\xE0\xA6\xB0\xE0\xA6\xA6\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\xB8\xE0\xA6\x99\xE0\xA7\x8D\xE0\xA6\x97\xE0\xA7\x87 \xE0\xA6\xA4\xE0\xA7\x81\xE0\xA6\xB2\xE0\xA6\xA8\xE0\xA6\xBE \xE0\xA6\x95\xE0\xA6\xB0\xE0\xA6\xBE \xE0\xA6\xAF\xE0\xA6\xBE\xE0\xA6\xAC\xE0\xA7\x87 \xE0\xA6\x95\xE0\xA6\xBF \xE0\xA6\x8F\xE0\xA6\x95\xE0\xA6\x9C\xE0\xA6\xA8 \xE0\xA6\xA6\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xB6\xE0\xA6\x95\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\x8F\xE0\xA6\xAE\xE0\xA6\xA8 \xE0\xA6\xAA\xE0\xA7\x8D\xE0\xA6\xB0\xE0\xA6\xB6\xE0\xA7\x8D\xE0\xA6\xA8\xE0\xA7\x87 \xE0\xA6\x9C\xE0\xA6\xAC\xE0\xA6\xBE\xE0\xA6\xAC\xE0\xA7\x87 \xE0\xA6\x86\xE0\xA6\xAC\xE0\xA7\x8D\xE0\xA6\xA6\xE0\xA7\x81\xE0\xA6\xB2\xE0\xA7\x8D\xE0\xA6\xB2\xE0\xA6\xBE\xE0\xA6\xB9 \xE0\xA6\x86\xE0\xA6\xB2 \xE0\xA6\xA8\xE0\xA7\x87\xE0\xA6\xBE\xE0\xA6\xAE\xE0\xA6\xBE\xE0\xA6\xA8 \xE0\xA6\xAC\xE0\xA6\xB2\xE0\xA7\x87\xE0\xA6\xA8 , \xE2\x80\x9C \xE0\xA6\x8F\xE0\xA6\x87 \xE0\xA6\xAA\xE0\xA6\xBE\xE0\xA6\x81\xE0\xA6\x9A\xE0\xA6\x9F\xE0\xA6\xBF \xE0\xA6\xB8\xE0\xA6\xBF\xE0\xA6\x9F\xE0\xA6\xBF \xE0\xA6\x95\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xAA\xE0\xA7\x8B\xE0\xA6\xB0\xE0\xA7\x87\xE0\xA6\xB6\xE0\xA6\xA8 \xE0\xA6\xA8\xE0\xA6\xBF\xE0\xA6\xB0\xE0\xA7\x8D\xE0\xA6\xAC\xE0\xA6\xBE\xE0\xA6\x9A\xE0\xA6\xA8 \xE0\xA6\xA6\xE0\xA7\x87\xE0\xA6\xB6\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\xAA\xE0\xA6\xBE\xE0\xA6\x81\xE0\xA6\x9A\xE0\xA6\x9F\xE0\xA6\xBF \xE0\xA6\xAC\xE0\xA7\x9C \xE0\xA6\xAC\xE0\xA6\xBF\xE0\xA6\xAD\xE0\xA6\xBE\xE0\xA6\x97\xE0\xA7\x87\xE0\xA6\xB0 \xE0\xA6\xAA\xE0\xA7\x8D\xE0\xA6\xB0\xE0\xA6\xA4\xE0\xA6\xBF\xE0\xA6\xA8\xE0\xA6\xBF\xE0\xA6\xA7\xE0\xA6\xBF\xE0\xA6\xA4\xE0\xA7\x8D\xE0\xA6\xAC \xE0\xA6\x95\xE0\xA6\xB0\xE0\xA6\x9B\xE0\xA7\x87 \xE0\xA5\xA4 \xE0\xA6\x8F\xE0\xA6\x9B\xE0\xA6\xBE\xE0\xA7\x9C\xE0\xA6\xBE \xE0\xA6\x8F\xE0\xA6\x96\xE0\xA6\xBE\xE0\xA6\xA8\xE0\xA6\x95\xE0\xA6\xBE\xE0\xA6\xB0 \xE0\xA6\xAD\xE0\xA7\x8B\xE0\xA6\x9F\xE0\xA6\xBE\xE0\xA6\xB0 \xE0\xA6\xB0\xE0\xA6\xBE \xE0\xA6\xB8\xE0\xA6\xAC\xE0\xA6\xBE\xE0\xA6\x87 \xE0\xA6\xB8\xE0\xA6\x9A\xE0\xA7\x87\xE0\xA6\xA4\xE0\xA6\xA8 \xE0\xA5\xA4 \xE0\xA6\xA4\xE0\xA6\xBE\xE0\xA6\xB0\xE0\xA6\xBE";

//const char* kTeststr_bo_Tibt = " \xE0\xBD\x82\xE0\xBD\x84 \xE0\xBD\x93\xE0\xBD\xB2 \xE0\xBD\x80\xE0\xBD\xB4\xE0\xBD\x93 \xE0\xBD\xA3 \xE0\xBD\xA6\xE0\xBE\xA6\xE0\xBE\xB1\xE0\xBD\xA2 \xE0\xBD\x94 \xE0\xBD\x91\xE0\xBD\x84 \xE0\xBD\x85\xE0\xBD\x93 \xE0\xBD\xA3\xE0\xBE\xA1\xE0\xBD\x93 \xE0\xBD\x96\xE0\xBD\x91\xE0\xBD\x82 \xE0\xBD\x94\xE0\xBD\xBC\xE0\xBD\xA0\xE0\xBD\xB2 \xE0\xBD\xA6\xE0\xBE\x92\xE0\xBE\xB2 \xE0\xBD\x82 \xE0\xBD\x91 \xE0\xBD\x96 \xE0\xBD\xA6 \xE0\xBD\x93 \xE0\xBD\x98 \xE0\xBD\x94 \xE0\xBD\x84 \xE0\xBD\xA0 \xE0\xBD\xA2 \xE0\xBD\xA3 \xE0\xBD\x98\xE0\xBD\x90\xE0\xBD\xA0 \xE0\xBD\x98\xE0\xBD\xBA\xE0\xBD\x91 \xE0\xBD\x94 \xE0\xBD\x96\xE0\xBD\x91\xE0\xBD\x82 \xE0\xBD\x94\xE0\xBD\xBC\xE0\xBD\xA0\xE0\xBD\xB2 \xE0\xBD\xA6\xE0\xBE\x92\xE0\xBE\xB2 \xE0\xBD\xA3 \xE0\xBD\x94 \xE0\xBD\x89\xE0\xBD\xB2\xE0\xBD\x91 \xE0\xBD\x91\xE0\xBD\xBC \xE0\xBD\x98 \xE0\xBD\x98\xE0\xBD\xB2 \xE0\xBD\x98\xE0\xBD\xB2\xE0\xBD\x93";
// From 10% testing part of new lang=bo scrape
const char* kTeststr_bo_Tibt = " \xE0\xBC\x8B\xE0\xBD\x82\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x81\xE0\xBC\x8B\xE0\xBD\x86\xE0\xBD\xBA\xE0\xBD\xA0\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\x95\xE0\xBE\xB1\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\x9A\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\x81\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x9E\xE0\xBD\xB2\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\xA4\xE0\xBD\xB2\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\xB2\xE0\xBD\xB2\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x94\xE0\xBC\x8D \xE0\xBD\xA1\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\x80\xE0\xBE\xB3\xE0\xBD\xB4\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\x99\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x94\xE0\xBD\xBC\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\x86 \xE0\xBD\xB4\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBD\x9B\xE0\xBD\xBC\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBD\xB4\xE0\xBD\xA0\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\x86\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBD\xBA\xE0\xBD\x98\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x9A\xE0\xBD\x96\xE0\xBD\xA6\xE0\xBC\x8D \xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\xA2\xE0\xBD\x82\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBD\x9A\xE0\xBD\xBC\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\xBC\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\x98\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBE\xB2\xE0\xBD\xB4\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\xA6\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBE\xB1\xE0\xBD\xB4\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBC\x8D \xE0\xBD\x94\xE0\xBC\x8B\xE0\xBD\x80\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\x8F\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBD\xBA\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\xA6\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x94\xE0\xBD\xA0\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\x90\xE0\xBE\xB1\xE0\xBD\xBC\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\x9B\xE0\xBD\xB4\xE0\xBD\x82\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBE\xB1\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x94\xE0\xBC\x8D \xE0\xBD\xA2\xE0\xBE\xA9\xE0\xBD\xBC\xE0\xBD\x98\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\xB2\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBC\x8D \xE0\xBD\xA0\xE0\xBD\x96\xE0\xBE\xB2\xE0\xBD\xBA\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBD\x90\xE0\xBD\xB4\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBD\xB4\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBD\x98\xE0\xBC\x8D \xE0\xBD\x90\xE0\xBD\xBC\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\x90\xE0\xBE\xB1\xE0\xBD\xBA\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\xB2\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\x9E\xE0\xBD\xB4\xE0\xBC\x8D \xE0\xBC\x8B\xE0\xBD\x90\xE0\xBD\xBC\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\xBA\xE0\xBD\x96\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\x9E\xE0\xBD\xB2\xE0\xBC\x8B \xE0\xBD\x91\xE0\xBD\x94\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\x82\xE0\xBE\xB2\xE0\xBD\xBA\xE0\xBD\x98\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\x93\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\xBC\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x94\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\xBC\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\xB2\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBE\xB2\xE0\xBC\x8B\xE0\xBD\x9A\xE0\xBD\xB2\xE0\xBD\x82\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x81\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x93\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBE\xA9\xE0\xBD\xBC\xE0\xBD\x98\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBE\xB2\xE0\xBD\xB2\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\x93\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBD\x81\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBD\xBA\xE0\xBD\x91\xE0\xBC\x8D \xE0\xBD\xA3\xE0\xBD\xBA\xE0\xBC\x8B\xE0\xBD\x9A\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\x81\xE0\xBD\x82 \xE0\xBD\xA3\xE0\xBD\xBA\xE0\xBC\x8B\xE0\xBD\x9A\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\x81\xE0\xBD\x82 \xE0\xBD\xA0\xE0\xBD\x96\xE0\xBE\xB2\xE0\xBD\xBA\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\xBC\xE0\xBD\x91\xE0\xBC\x8D \xE0\xBD\xA0\xE0\xBD\x82\xE0\xBE\xB2\xE0\xBD\xBA\xE0\xBD\x98\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\x9F\xE0\xBD\xBC\xE0\xBD\x93\xE0\xBC\x8D \xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBD\xB4\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBD\x98\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\xA3\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\xB2\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBD\x9B\xE0\xBD\xBC\xE0\xBD\x91\xE0\xBC\x8D \xE0\xBD\x96\xE0\xBD\x80\xE0\xBD\xBC\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\xA4\xE0\xBE\xB1\xE0\xBD\xBC\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x94\xE0\xBD\xA0\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\x87\xE0\xBD\xBC\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\xB4\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBE\xB2\xE0\xBC\x8B\xE0\xBD\x84\xE0\xBD\xBC\xE0\xBD\xA6\xE0\xBC\x8D \xE0\xBD\xA6\xE0\xBE\x94\xE0\xBD\xBC\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBC\x8D \xE0\xBD\xA2\xE0\xBE\x97\xE0\xBD\xBA\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBC\x8D \xE0\xBD\x96\xE0\xBD\xA6\xE0\xBE\x9F\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\x9B\xE0\xBD\xB2\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\x91\xE0\xBD\xBA\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\x90\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBD\x91\xE0\xBC\x8D \xE0\xBD\x9A\xE0\xBD\xBA\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBD\xB2\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBE\xA3\xE0\xBD\x98\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBD\xA3\xE0\xBC\x8D \xE0\xBD\x96\xE0\xBD\xA6\xE0\xBE\x9F\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\x9B\xE0\xBD\xB2\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\x84\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\x96\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBC\x8D \xE0\xBD\xA1\xE0\xBD\xBC\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\x91\xE0\xBD\xBC\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x9A\xE0\xBD\xBA\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBD\xB2\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBE\xB7\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x94\xE0\xBC\x8D  \xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\x96\xE0\xBD\x84\xE0\xBC\x8B \xE0\xBD\x95\xE0\xBE\xB1\xE0\xBD\xB4\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\x89\xE0\xBD\xB2\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x80\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\xA2\xE0\xBE\x97\xE0\xBD\xBC\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\x9E\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBE\xB1\xE0\xBD\xBA\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBE\xB2\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x94\xE0\xBC\x8B\xE0\xBD\x9E\xE0\xBD\xB2\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\x82\xE0\xBE\xB2\xE0\xBD\xBC\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBE\xB3\xE0\xBD\xBA\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\x8F\xE0\xBD\xB2\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x9F\xE0\xBD\x96\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBE\xB1\xE0\xBD\xBA\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x94\xE0\xBD\xA0\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\x9F\xE0\xBD\xA0\xE0\xBC\x8B \xE0\xBD\xA0\xE0\xBD\x81\xE0\xBD\xBC\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBD\x89\xE0\xBD\xB2\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBD\xBA\xE0\xBD\xA0\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\x98\xE0\xBD\x9A\xE0\xBD\x98\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x80\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBD\xBA\xE0\xBC\x8B\xE0\xBD\x9A\xE0\xBD\x93\xE0\xBC\x8B\xE0\xBD\x9E\xE0\xBD\xB2\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\xB2\xE0\xBD\x93\xE0\xBC\x8D \xE0\xBD\x91\xE0\xBD\x94\xE0\xBE\xB1\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x9E\xE0\xBD\xB2\xE0\xBD\x96\xE0\xBC\x8B\xE0\xBD\x80\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBC\x8B\xE0\xBD\x93\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x93\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x81\xE0\xBD\xB4\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\x82\xE0\xBE\xB1\xE0\xBD\xB4\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\xA3\xE0\xBE\xA1\xE0\xBD\xBC\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\x84\xE0\xBC\x8C\xE0\xBC\x8D \xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBC\x8B\xE0\xBD\x93\xE0\xBD\x82\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\xA4\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBD\xA0\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA0\xE0\xBD\x96\xE0\xBE\xB2\xE0\xBD\xBA\xE0\xBD\xA3\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\x98\xE0\xBD\xB2\xE0\xBD\x82\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBD\xB4\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\x80\xE0\xBD\xA2\xE0\xBC\x8B\xE0\xBD\x93\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBD\x82\xE0\xBE\xB2\xE0\xBD\xBC\xE0\xBC\x8B\xE0\xBD\x82\xE0\xBE\xB3\xE0\xBD\xBA\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x96\xE0\xBE\xB1\xE0\xBD\xBA\xE0\xBD\x91\xE0\xBC\x8B\xE0\xBD\x80\xE0\xBE\xB1\xE0\xBD\xB2\xE0\xBC\x8B\xE0\xBD\xA1\xE0\xBD\xBC\xE0\xBD\x91\xE0\xBC\x8D\xE0\xBC\x8D \xE0\xBD\xA2\xE0\xBE\x92\xE0\xBE\xB1\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\xA6\xE0\xBE\xB2\xE0\xBD\xB2\xE0\xBD\x84\xE0\xBC\x8B\xE0\xBD\x91\xE0\xBD\xB4\xE0\xBD\xA6\xE0\xBC\x8B\xE0\xBD\x9A\xE0\xBD\xBC\xE0\xBD\x91\xE0\xBC\x8D";

const char* kTeststr_br_Latn = " a chom met leuskel a ra e blas da jack irons dilabour hag aet kuit eus what is this dibab a reont da c houde michael beinhorn evit produi\xC3\xB1 an trede pladenn kavet e vez ar ganaouenno\xC3\xB9 buhan ha buhan ganto setu stummet ar bladenn adkavet e vez enni funk";
const char* kTeststr_bs_Cyrl = "\xD0\xB8\xD1\x81\xD1\x82\xD0\xBE\xD1\x80\xD0\xB8\xD1\x98\xD0\xB0 \xD0\xB1\xD0\xBE\xD1\x81\xD0\xBD\xD0\xB5 \xD0\xBA\xD1\x9A \xD0\xB8\xD1\x81\xD1\x82\xD0\xBE\xD1\x80\xD0\xB8\xD1\x98\xD0\xB0 \xD0\xB1\xD0\xBE\xD1\x81\xD0\xBD\xD0\xB5 \xD0\xBA\xD1\x9A \xD0\xB8\xD1\x81\xD1\x82\xD0\xBE\xD1\x80\xD0\xB8\xD1\x98\xD0\xB0 \xD0\xB1\xD0\xBE\xD1\x81\xD0\xBD\xD0\xB5 \xD0\xBA\xD1\x9A \xD0\xB8\xD1\x81\xD1\x82\xD0\xBE\xD1\x80\xD0\xB8\xD1\x98\xD0\xB0 \xD0\xB1\xD0\xBE\xD1\x81\xD0\xBD\xD0\xB5 \xD0\xBA\xD1\x9A ";
//const char* kTeststr_bs_Latn = " a radi br\xC5\xBE\x65g rada po\xC5\xA1to rom radi sporije nego ram izvorni rom se isklju\xC4\x8Duje a dio ram a se rezervi\xC5\xA1\x65 te se u njega ne plo\xC4\x8D\x61 procesor ram memorija grafi\xC4\x8Dka kartica zvu\xC4\x8Dna kartica modem mre\xC5\xBEna kartica napojna jedinica ure\xC4\x91\x61ji za pohranjivanje";
// From 10% testing part of new lang=bs scrape
const char* kTeststr_bs_Latn = "Novi predsjednik Me\xC5\xA1ihata Islamske zajednice u Srbiji (IZuS) i muftija dr. Mevlud ef. Dudi\xC4\x87 izjavio je u intervjuu za Anadolu Agency (AA) kako je uvjeren da \xC4\x87\x65 do\xC4\x87i do vra\xC4\x87\x61nja jedinstva me\xC4\x91u muslimanima i unutar Islamske zajednice na prostoru Sand\xC5\xBE\x61ka, te da je njegova ruka pru\xC5\xBE\x65na za povratak svih u okrilje Islamske zajednice u Srbiji nakon skoro sedam godina podjela u tom dijelu Srbije. Dudi\xC4\x87 je za predsjednika Me\xC5\xA1ihata IZ u Srbiji izabran 4. januara, a zvani\xC4\x8Dna inauguracija \xC4\x87\x65 biti obavljena u prvoj polovini februara. Kako se o\xC4\x8D\x65kuje, prisustvovat \xC4\x87\x65 joj i reisu-l-ulema Islamske zajednice u Srbiji Husein ef. Kavazovi\xC4\x87 koji \xC4\x87\x65 i zvani\xC4\x8Dno promovirati Dudi\xC4\x87\x61 u novog prvog \xC4\x8Dovjeka IZ u Srbiji. Dudi\xC4\x87 \xC4\x87\x65 danas boraviti u prvoj zvani\xC4\x8Dnoj posjeti reisu Kavazovi\xC4\x87u, \xC5\xA1to je njegov privi simboli\xC4\x8Dni potez nakon imenovanja. ";

const char* kTeststr_ca_Latn = "al final en un \xC3\xBAnic lloc nhorabona l correu electr\xC3\xB2nic est\xC3\xA0 concebut com a eina de productivitat aleshores per qu\xC3\xA8 perdre el temps arxivant missatges per despr\xC3\xA9s intentar recordar on els veu desar i per qu\xC3\xA8 heu d eliminar missatges importants per l";
const char* kTeststr_ceb_Latn = "Ang Sugbo usa sa mga labing ugmad nga lalawigan sa nasod. Kini ang sentro sa komersyo, edukasyon ug industriya sa sentral ug habagatang dapit sa kapupod-an. Ang mipadayag sa Sugbo isip ikapito nga labing nindot nga pulo sa , ang nag-inusarang pulo sa Pilipinas nga napasidunggan sa maong magasin sukad pa sa tuig";
const char* kTeststr_ceb_Latn2 = "Ang mga komyun sa Pransiya duol-duol sa inkorporadong mga lungsod ug mga dakbayan sa Estados Unidos. Wala kini susamang istruktura sa Hiniusang Gingharian (UK) tungod kay ang estado niini taliwala sa di-metropolitan nga distrito ug sa sibil nga parokya. Wala usab kini susamang istruktura sa Pilipinas.";
const char* kTeststr_chr_Cher = "\xE1\x8E\xA0\xE1\x8E\xA2\xE1\x8F\x8D\xE1\x8E\xA9 \xE1\x8E\xA0\xE1\x8F\x9F\xE1\x8E\xB6\xE1\x8F\x8D\xE1\x8F\x97 \xE1\x8F\xA5\xE1\x8F\x84\xE1\x8F\x8D\xE1\x8F\x9B\xE1\x8E\xA9 \xE1\x8E\xA6\xE1\x8E\xAB\xE1\x8F\x8D\xE1\x8F\x9B\xE1\x8F\x85\xE1\x8E\xAF \xE1\x8E\xBE\xE1\x8E\xA5\xE1\x8E\xA2";
const char* kTeststr_co_Latn = " a prupusitu di risultati for utiliz\xC3\xA0 a scatula per ricerc\xC3\xA0 ind issi risultati servore errore u servore ha incuntratu una errore pruvisoria \xC3\xA9 \xC3\xB9n ha pussutu compie a vostra dumanda per piac\xC3\xA8 acimenta din\xC3\xB2 ind una minuta tuttu listessu ligami truv\xC3\xA0 i";
const char*  kTeststr_crs_Latn = "Sesel ou menm nou sel patri. Kot nou viv dan larmoni. Lazwa, lanmour ek lape. Nou remersye Bondye. Preserv labote nou pei. Larises nou losean. En leritaz byen presye. Pour boner nou zanfan. Reste touzour dan linite. Fer monte nou paviyon. Ansanm pou tou leternite. Koste Seselwa!";
const char* kTeststr_cs_Latn = " a akci opakujte film ulo\xC5\xBE\x65n vykreslit gmail tokio smazat obsah adres\xC3\xA1\xC5\x99\x65 nelze na\xC4\x8D\xC3\xADst syst\xC3\xA9mov\xC3\xBD profil jednotky smoot okud pou\xC5\xBE\xC3\xADv\xC3\xA1te pro ur\xC4\x8D\x65n\xC3\xAD polokoule zna\xC4\x8Dky z z\xC3\xA1pad nebo v v\xC3\xBD\x63hod pou\xC5\xBE\xC3\xADvejte nez\xC3\xA1porn\xC3\xA9 hodnoty zem\xC4\x9Bpisn\xC3\xA9 d\xC3\xA9lky nelze";
const char* kTeststr_cy_Latn = " a chofrestru eich cyfrif ymwelwch a unwaith i chi greu eich cyfrif mi fydd yn cael ei hysbysu o ch cyfeiriad ebost newydd fel eich bod yn gallu cadw mewn cysylltiad drwy gmail os nad ydych chi wedi clywed yn barod am gmail mae n gwasanaeth gwebost";
const char* kTeststr_da_Latn = " a z tallene og punktummer der er tilladte log ud angiv den \xC3\xB8nskede adgangskode igen november gem personlige oplysninger kontrolsp\xC3\xB8rgsm\xC3\xA5l det sidste tegn i dit brugernavn skal v\xC3\xA6re et bogstav a z eller tal skriv de tegn du kan se i billedet nedenfor";
const char* kTeststr_de_Latn = " abschnitt ordner aktivieren werden die ordnereinstellungen im farbabschnitt deaktiviert \xC3\xB6\x63hten sie wirklich fortfahren eldtypen angeben optional n diesem schritt geben sie f\xC3\xBCr jedesfeld aus dem datenset den typ an ieser schritt ist optional eldtypen";
const char* kTeststr_dv_Thaa = " \xDE\x80\xDE\xA8\xDE\x82\xDE\xB0\xDE\x8B\xDE\xA9 \xDE\x84\xDE\xA6\xDE\x80\xDE\xAA\xDE\x82\xDE\xB0 \xDE\x88\xDE\xA7\xDE\x80\xDE\xA6\xDE\x86\xDE\xA6 \xDE\x8B\xDE\xA6\xDE\x87\xDE\xB0\xDE\x86\xDE\xA7\xDE\x87\xDE\xA8\xDE\x83\xDE\xAA \xDE\x8B\xDE\xAC\xDE\x88\xDE\xA6\xDE\x82\xDE\xA6 \xDE\x84\xDE\xA6\xDE\x80\xDE\xAC\xDE\x87\xDE\xB0\xDE\x8E\xDE\xAC \xDE\x8E\xDE\xAE\xDE\x8C\xDE\xAA\xDE\x8E\xDE\xA6\xDE\x87\xDE\xA7\xDE\x87\xDE\xA8 \xDE\x87\xDE\xAC\xDE\x82\xDE\xAB\xDE\x82\xDE\xB0 \xDE\x8E\xDE\xAE\xDE\x8C\xDE\xB0\xDE\x8E\xDE\xAE\xDE\x8C\xDE\xAA\xDE\x82\xDE\xB0 \xDE\x80\xDE\xA8\xDE\x82\xDE\xB0\xDE\x8B\xDE\xA9 \xDE\x84\xDE\xA6\xDE\x80\xDE\xAA\xDE\x82\xDE\xB0 \xDE\x88\xDE\xA7\xDE\x80\xDE\xA6\xDE\x86\xDE\xA6 \xDE\x8B\xDE\xA6\xDE\x87\xDE\xB0\xDE\x86\xDE\xA7 \xDE\x89\xDE\xA9\xDE\x80\xDE\xAA\xDE\x82\xDE\xB0\xDE\x8E\xDE\xAC \xDE\x87\xDE\xA6\xDE\x8B\xDE\xA6\xDE\x8B\xDE\xAA \xDE\x89\xDE\xA8\xDE\x8D\xDE\xA8\xDE\x87\xDE\xA6\xDE\x82\xDE\xA6\xDE\x81\xDE\xB0";
const char* kTeststr_dz_Tibt = " \xE0\xBD\xA2\xE0\xBE\xA9\xE0\xBD\xB2\xE0\xBD\xA6 \xE0\xBD\x96\xE0\xBD\xA2\xE0\xBE\x90\xE0\xBE\xB1\xE0\xBD\x96 \xE0\xBD\x9A\xE0\xBD\xB4\xE0\xBD\xA3 \xE0\xBD\xA3\xE0\xBE\xA1\xE0\xBD\x93 \xE0\xBD\x91\xE0\xBD\x84 \xE0\xBD\x84\xE0\xBD\xBA\xE0\xBD\xA6 \xE0\xBD\x96\xE0\xBD\x91\xE0\xBD\xBA\xE0\xBD\x93 \xE0\xBD\xA6\xE0\xBE\xA6 \xE0\xBD\xA6\xE0\xBE\x9F\xE0\xBD\xBC\xE0\xBD\x93 \xE0\xBD\x93\xE0\xBD\xB2\xE0\xBD\xA0\xE0\xBD\xB2 \xE0\xBD\x91\xE0\xBD\xBC\xE0\xBD\x93 \xE0\xBD\xA3\xE0\xBD\xB4 \xE0\xBD\x81\xE0\xBE\xB1\xE0\xBD\xBC\xE0\xBD\x91 \xE0\xBD\x82\xE0\xBD\xB4\xE0\xBD\x82 \xE0\xBD\xA4\xE0\xBD\x91 \xE0\xBD\xA3\xE0\xBD\x82 \xE0\xBD\xA3\xE0\xBD\xBA\xE0\xBD\x93 \xE0\xBD\xA0\xE0\xBD\x90\xE0\xBD\x96 \xE0\xBD\x91\xE0\xBD\x82\xE0\xBD\xBC \xE0\xBD\x82 \xE0\xBD\x91\xE0\xBD\x84 \xE0\xBD\xA8\xE0\xBD\xB2\xE0\xBD\x93 \xE0\xBD\x94\xE0\xBD\xB4\xE0\xBD\x8A\xE0\xBD\xB2 \xE0\xBD\x82\xE0\xBE\xB2\xE0\xBD\xA3 \xE0\xBD\x90\xE0\xBD\xB2\xE0\xBD\x82 \xE0\xBD\x82\xE0\xBD\xB4";
const char* kTeststr_ee_Latn = "Yi (Di tanya sia) tatia ak\xC9\x94 w\xC3\xB2 ayi axa yeye dzi kple tanya si s\xC9\x94 kple esi w\xC3\xB2\xC5\x8Bl\xC9\x94 \xC9\x96\x65 goa me, negbe axaa \xC9\x96\x65 li kpakple tanya mawo xoxo ko. Te\xC6\x92\x65 le axa yeye sia dzi si w\xC3\xB2\x61te\xC5\x8Bu atia na kpekpe\xC9\x96\x65\xC5\x8Bu kple nuwo\xC5\x8Bl\xC9\x94\xC5\x8Bl\xC9\x94 ne an\xC9\x94 hahi\xC3\xA3m na w\xC3\xB2. Mehi\xC3\xA3 be na gbugb\xC9\x94 ava afii na axa yeye g\xC9\x94medzedze o. Woate\xC5\x8Bu adze wo g\xC9\x94me kple nu\xC5\x8B\xC9\x94\xC5\x8Bl\xC9\x94 dz\xE1\xBA\xBDwo tatia. Megav\xC9\x94\xCC\x83 na nuyeyewo g\xC9\x94medzedze kroa o.";
const char* kTeststr_el_Grek = " \xCE\xAE \xCE\xB1\xCF\x81\xCE\xBD\xCE\xB7\xCF\x84\xCE\xB9\xCE\xBA\xCE\xAE \xCE\xB1\xCE\xBD\xCE\xB1\xCE\xB6\xCE\xAE\xCF\x84\xCE\xB7\xCF\x83\xCE\xB7 \xCE\xBB\xCE\xAD\xCE\xBE\xCE\xB7\xCF\x82 \xCE\xBA\xCE\xBB\xCE\xB5\xCE\xB9\xCE\xB4\xCE\xB9\xCE\xBF\xCF\x8D \xCE\xBA\xCE\xB1\xCF\x84\xCE\xB1\xCF\x83\xCF\x84\xCE\xAE\xCF\x83\xCF\x84\xCE\xB5 \xCF\x84\xCE\xB9\xCF\x82 \xCE\xBC\xCE\xB5\xCE\xBC\xCE\xBF\xCE\xBD\xCF\x89\xCE\xBC\xCE\xAD\xCE\xBD\xCE\xB5\xCF\x82 \xCE\xBB\xCE\xAD\xCE\xBE\xCE\xB5\xCE\xB9\xCF\x82 \xCE\xBA\xCE\xBB\xCE\xB5\xCE\xB9\xCE\xB4\xCE\xB9\xCE\xAC \xCF\x80\xCE\xB5\xCF\x81\xCE\xB9\xCF\x83\xCF\x83\xCF\x8C\xCF\x84\xCE\xB5\xCF\x81\xCE\xBF \xCF\x83\xCF\x84\xCE\xBF\xCF\x87\xCE\xBF\xCE\xB8\xCE\xB5\xCF\x84\xCE\xB7\xCE\xBC\xCE\xAD\xCE\xBD\xCE\xB5\xCF\x82 \xCE\xBC\xCE\xB5 \xCF\x84\xCE\xB7 \xCE\xBC\xCE\xB5\xCF\x84\xCE\xB1\xCF\x84\xCF\x81\xCE\xBF\xCF\x80\xCE\xAE \xCF\x84\xCE\xBF\xCF\x85\xCF\x82 \xCF\x83\xCE\xB5";
const char* kTeststr_en_Latn = " a backup credit card by visiting your billing preferences page or visit the adwords help centre for more details https adwords google com support bin answer py answer hl en we were unable to process the payment of for your outstanding google adwords";
const char* kTeststr_eo_Latn = " a jarcento refoje per enmetado de koncerna pastro tiam de reformita konfesio ekde refoje ekzistis luteranaj komunumanoj tamen tiuj fondis propran komunumon nur en amba\xC5\xAD apartenis ekde al la evangela eklezio en prusio resp ties rejnlanda provinceklezio en";
const char* kTeststr_es_Latn = " a continuaci\xC3\xB3n haz clic en el bot\xC3\xB3n obtener ruta tambi\xC3\xA9n puedes desplazarte hasta el final de la p\xC3\xA1gina para cambiar tus opciones de b\xC3\xBAsqueda gr\xC3\xA1\x66ico y detalles \xC3\xA9sta es una lista de los v\xC3\xAD\x64\x65os que te recomendamos nuestras recomendaciones se basan";
const char* kTeststr_et_Latn = " a niipea kui sinu maksimaalne igakuine krediidi limiit on meie poolt heaks kiidetud on sinu kohustuseks see krediidilimiit";
const char* kTeststr_eu_Latn = " a den eraso bat honen kontra hortaz eragiketa bakarrik behar dituen eraso batek aes apurtuko luke nahiz eta oraingoz eraso bideraezina izan gaur egungo teknologiaren mugak direla eta oraingoz kezka hauek alde batera utzi daitezke orain arteko indar";
const char* kTeststr_fa_Arab = " \xD8\xA2\xD8\xA8 \xD8\xAE\xD9\x88\xD8\xB1\xD8\xAF\xD9\x86 \xD8\xB9\xD8\xAC\xD9\x84\xD9\x87 \xD9\x85\xDB\x8C \xDA\xA9\xD8\xB1\xD8\xAF\xD9\x86\xD8\xAF \xD8\xA8\xD9\x87 \xD8\xAC\xD8\xA7\xDB\x8C \xD8\xA8\xD8\xA7\xD8\xB2 \xDB\x8C \xDA\xA9\xD8\xAA\xDA\xA9 \xDA\xA9\xD8\xA7\xD8\xB1\xDB\x8C \xD9\x85\xDB\x8C \xDA\xA9\xD8\xB1\xD8\xAF\xD9\x86\xD8\xAF \xD9\x88 \xD9\x87\xD9\x85\xD9\x87 \xDA\x86\xD9\x8A\xD8\xB2 \xD9\x85\xD8\xAB\xD9\x84 \xD9\x82\xD8\xA8\xD9\x84 \xD8\xA8\xD9\x88\xD8\xAF \xD9\x81\xD9\x82\xD8\xB7 \xD9\x85\xD9\x86 \xD9\x85\xD8\xA7\xD9\x86\xD8\xAF\xD9\x85 \xD9\x88 \xD9\x8A\xDA\xA9 \xD8\xAF\xD9\x86\xD9\x8A\xD8\xA7 \xD8\xAD\xD8\xB1\xD9\x81 \xD9\x88 \xD8\xA7\xD9\x86\xD8\xAA\xD8\xB8\xD8\xA7\xD8\xB1 \xD8\xAA\xD8\xA7 \xD8\xB9\xD8\xA7\xD9\x82\xD8\xA8\xD8\xAA \xD8\xB1\xD8\xB3\xD9\x8A\xD8\xAF \xD8\xA7\xD8\xAD\xD8\xB6\xD8\xA7\xD8\xB1\xD9\x8A\xD9\x87 \xDB\x8C \xD8\xA7\xDB\x8C \xD8\xA8\xD8\xA7";
const char* kTeststr_fi_Latn = " a joilla olet k\xC3\xA4ynyt t\xC3\xA4m\xC3\xA4 kerro meille kuka \xC3\xA4 olet ei tunnistettavia k\xC3\xA4ytt\xC3\xB6tietoja kuten virheraportteja k\xC3\xA4ytet\xC3\xA4\xC3\xA4n google desktopin parantamiseen etsi n\xC3\xA4ytt\xC3\xA4\xC3\xA4 mukautettuja uutisia google desktop keskivaihto leikkaa voit kaksoisnapsauttaa";
const char* kTeststr_fj_Latn = " i kina na i iri ka duatani na matana main a meke wesi se meke mada na meke ni yaqona oqo na meke ka dau vakayagataki ena yaqona vakaturaga e dau caka toka ga kina na vucu ka dau lagati tiko kina na ka e yaco tiko na talo ni wai ni yaqona na lewai ni wai";
const char* kTeststr_fo_Latn = " at ver\xC3\xB0\x61 \xC3\xA1taluverdar \xC3\xB3h\xC3\xB3skandi ella \xC3\xA1loypandi vit kunnu ikki garanter\xC3\xB0\x61 at google leitanin ikki finnur naka sum er \xC3\xA1loypandi \xC3\xB3h\xC3\xB3skandi ella \xC3\xA1taluvert og google tekur onga \xC3\xA1\x62yrgd yvir t\xC3\xA6r s\xC3\xAD\xC3\xB0ur sum koma vi\xC3\xB0 \xC3\xAD okkara leitiskipan f\xC3\xA1 t\xC3\xA6r ein";
const char* kTeststr_fr_Latn = " a acc\xC3\xA8s aux collections et aux frontaux qui lui ont \xC3\xA9t\xC3\xA9 attribu\xC3\xA9s il peut consulter et modifier ses collections et exporter des configurations de collection toutefois il ne peut pas cr\xC3\xA9\x65r ni supprimer des collections enfin il a acc\xC3\xA8s aux fonctions";
const char* kTeststr_fy_Latn = " adfertinsjes gewoan lytse adfertinsjes mei besibbe siden dy t fan belang binne foar de ynh\xC3\xA2ld fan jo berjochten wolle jo mear witte fan gmail foardat jo jo oanmelde gean dan nei wy wurkje eltse dei om gmail te ferbetterjen d\xC3\xAArta sille wy jo sa \xC3\xBAt en";
const char* kTeststr_ga_Latn = " a bhfuil na focail go l\xC3\xA9ir i do cheist le f\xC3\xA1il orthu n\xC3\xAD g\xC3\xA1 ach focail breise a chur leis na cinn a cuarda\xC3\xADodh cheana chun an cuardach a bheacht\xC3\xBA n\xC3\xB3 a ch\xC3\xBAng\xC3\xBA m\xC3\xA1 chuirtear focal breise isteach aimseofar fo aicme ar leith de na tortha\xC3\xAD a fuarthas";
const char* kTeststr_gaa_Latn = "Ak\xCE\xB5 mlawookpeehe k\xCE\xB5 Ma\xC5\x8Bhi\xCE\xB5nyi\xCE\xB5l\xD7\x9B oshikif\xD7\x9B\xD7\x9B l\xCE\xB5 eba naagbee ni ma\xC5\x8B l\xCE\xB5 nitsum\xD7\x9B ni kw\xCE\xB5\xD7\x9B oshikif\xD7\x9B\xD7\x9B n\xD7\x9B l\xCE\xB5 ets\xD7\x9B\xD7\x9B m\xD7\x9B ni ye kunim ni ak\xCE\xB5 l\xCE\xB5 eta es\xCE\xB5\xC5\x8B n\xD7\x9B. Dani nom\xCE\xB5i baaba n\xD7\x9B l\xCE\xB5, ma\xC5\x8B n\xD7\x9Bkw\xCE\xB5m\xD7\x9B kui wuji eny\xD7\x9B ni y\xD7\x9B\xD7\x9B w\xD7\x9B ma\xC5\x8B l\xCE\xB5 mli, NPP k\xCE\xB5 NDC mli bii f\xD7\x9B\x66\xD7\x9Bi wiem\xD7\x9Bi k\xCE\xB5maje majee am\xCE\xB5he. Ekom\xCE\xB5i kwraa po yafee hi\xCE\xB5kw\xCE\xB5m\xD7\x9Bi ni ha ni gidigidi, pilam\xD7\x9B k\xCE\xB5 la shishwiem\xD7\x9B aaba y\xCE\xB5 heikom\xCE\xB5i. ";
const char* kTeststr_gd_Latn = " air son is gum bi casg air a h uile briosgaid no gum faigh thu brath nuair a tha briosgaid a tighinn gad rannsachadh ghoogle gu ceart mura bheil briosgaidean ceadaichte cuiridh google briosgaid dha do neach cleachdaidh fa leth tha google a cleachdadh";
const char* kTeststr_gl_Latn = "  debe ser como m\xC3\xADnimo taranto tendas de venda polo mi\xC3\xBA\x64o coci\xC3\xB1\x61s servizos bordado canad\xC3\xA1 viaxes parques de veh\xC3\xAD\x63ulos de recreo hotel oriental habitaci\xC3\xB3n recibir unha postal no enderezo indicado anteriormente";
const char* kTeststr_gn_Latn = " ah\xC3\xA1ta a\xC3\xB1\x65 \xC3\xAB ne mbo eh\xC3\xA1ra ndive ajerur\xC3\xA9ta chupe oporandujey ha\xC4\x9Dua pe\xC3\xABme mba \xC3\xA9pa pekaru ha \xC3\xA1\xC4\x9D\x61 oporand\xC3\xBAvo nde er\xC3\xA9ta avei re paragua\xC3\xBDpe kach\xC3\xADke he i le\xC3\xBApe nd\xC3\xA9pa re \xC3\xBAma kure tataku\xC3\xA1pe ha leu ombohov\xC3\xA1i h\xC3\xA9\xC3\xAB ha ujep\xC3\xA9ma kach\xC3\xADke he ijey";
const char* kTeststr_gu_Gujr = " \xE0\xAA\x86\xE0\xAA\xA8\xE0\xAA\xBE \xE0\xAA\xAA\xE0\xAA\xB0\xE0\xAA\xBF\xE0\xAA\xA3\xE0\xAA\xBE\xE0\xAA\xAE \xE0\xAA\xAA\xE0\xAB\x8D\xE0\xAA\xB0\xE0\xAA\xAE\xE0\xAA\xBE\xE0\xAA\xA3\xE0\xAA\xB8\xE0\xAA\xB0 \xE0\xAA\xAB\xE0\xAB\x8B\xE0\xAA\xA8\xE0\xAB\x8D\xE0\xAA\x9F \xE0\xAA\x85\xE0\xAA\xB5\xE0\xAA\xA4\xE0\xAA\xB0\xE0\xAA\xA3 \xE0\xAA\x9A\xE0\xAA\xBF\xE0\xAA\xA8\xE0\xAB\x8D\xE0\xAA\xB9\xE0\xAA\xB5\xE0\xAA\xBE\xE0\xAA\xB3\xE0\xAA\xBE \xE0\xAA\xAA\xE0\xAA\xBE\xE0\xAA\xA0\xE0\xAA\xA8\xE0\xAB\x87 \xE0\xAA\x9B\xE0\xAB\x81\xE0\xAA\xAA\xE0\xAA\xBE\xE0\xAA\xB5\xE0\xAB\x8B \xE0\xAA\xAC\xE0\xAA\xA7\xE0\xAA\xBE \xE0\xAA\xB8\xE0\xAA\xAE\xE0\xAB\x82\xE0\xAA\xB9\xE0\xAB\x8B \xE0\xAA\xB6\xE0\xAB\x8B\xE0\xAA\xA7\xE0\xAA\xBE\xE0\xAA\xAF\xE0\xAA\xBE \xE0\xAA\xB9\xE0\xAA\xBE\xE0\xAA\xB2\xE0\xAA\xA8\xE0\xAB\x8B \xE0\xAA\x9C \xE0\xAA\xB8\xE0\xAA\x82\xE0\xAA\xA6\xE0\xAB\x87\xE0\xAA\xB6 \xE0\xAA\xB5\xE0\xAA\xBF\xE0\xAA\xB7\xE0\xAA\xAF\xE0\xAA\xA8\xE0\xAB\x80";
const char* kTeststr_gv_Latn = " and not ripe as i thought yn assyl yn shynnagh as yn lion the ass the fox and the lion va assyl as shynnagh ayns commee son nyn vendeilys as sauchys hie ad magh ayns y cheyll dy shelg cha row ad er gholl feer foddey tra veeit ad rish lion yn shynnagh";
const char* kTeststr_ha_Latn = " a cikin a kan sakamako daga sakwannin a kan sakamako daga sakwannin daga ranar zuwa a kan sakamako daga guda daga ranar zuwa a kan sakamako daga shafukan daga ranar zuwa a kan sakamako daga guda a cikin last hour a kan sakamako daga guda daga kafar";
const char* kTeststr_haw_Latn = "He puke noi\xCA\xBBi k\xC5\xAB\xCA\xBBikena k\xC5\xABnoa \xCA\xBBo Wikipikia. E \xCA\xBBolu\xCA\xBBolu n\xC5\x8D, e h\xC4\x81\xCA\xBB\x61wi mai i k\xC4\x81u \xCA\xBBike, k\xC4\x81u mana\xCA\xBBo, a me kou leo no ke k\xC5\xABkulu \xCA\xBB\x61na a me ke k\xC4\x81ko\xCA\xBBo \xCA\xBB\x61na mai i ka Wikipikia Hawai\xCA\xBBi. He kahua p\xC5\xABnaewele Hawai\xCA\xBBi k\xC4\x93ia no ka ho\xCA\xBBoulu \xCA\xBB\x61na i ka \xCA\xBBike Hawai\xCA\xBBi. In\xC4\x81 hiki i\xC4\x81 \xCA\xBBoe ke \xCA\xBB\xC5\x8Dlelo Hawai\xCA\xBBi, e \xCA\xBBolu\xCA\xBBolu n\xC5\x8D, e k\xC5\x8Dkua mai a e ho\xCA\xBBololi i n\xC4\x81 \xCA\xBB\x61tikala ma \xCA\xBB\x61ne\xCA\xBBi, a pono e ha\xCA\xBBi aku i kou mau hoa aloha e pili ana i ka Wikipikia Hawai\xCA\xBBi. E ola mau n\xC5\x8D ka \xCA\xBB\xC5\x8Dlelo Hawai\xCA\xBBi a mau loa aku.";
const char* kTeststr_hi_Deva = " \xE0\xA4\x82 \xE0\xA4\x90\xE0\xA4\xA1\xE0\xA4\xB5\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xA1\xE0\xA5\x8D\xE0\xA4\xB8 \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\x9C\xE0\xA5\x8D\xE0\xA4\x9E\xE0\xA4\xBE\xE0\xA4\xAA\xE0\xA4\xA8\xE0\xA5\x8B\xE0\xA4\x82 \xE0\xA4\x95\xE0\xA5\x87 \xE0\xA4\x85\xE0\xA4\xA8\xE0\xA5\x81\xE0\xA4\xAD\xE0\xA4\xB5 \xE0\xA4\xAA\xE0\xA4\xB0 \xE0\xA4\x86\xE0\xA4\xA7\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA4\xBF\xE0\xA4\xA4 \xE0\xA4\xB9\xE0\xA5\x88\xE0\xA4\x82 \xE0\xA4\x94\xE0\xA4\xB0 \xE0\xA4\x87\xE0\xA4\xA8\xE0\xA4\x95\xE0\xA5\x80 \xE0\xA4\xAE\xE0\xA4\xA6\xE0\xA4\xA6 \xE0\xA4\xB8\xE0\xA5\x87 \xE0\xA4\x86\xE0\xA4\xAA\xE0\xA4\x95\xE0\xA5\x8B \xE0\xA4\x85\xE0\xA4\xAA\xE0\xA4\xA8\xE0\xA5\x87 \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\x9C\xE0\xA5\x8D\xE0\xA4\x9E\xE0\xA4\xBE\xE0\xA4\xAA\xE0\xA4\xA8\xE0\xA5\x8B\xE0\xA4\x82 \xE0\xA4\x95\xE0\xA4\xBE \xE0\xA4\x85\xE0\xA4\xA7\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA4\xA4\xE0\xA4\xAE \xE0\xA4\xB2\xE0\xA4\xBE\xE0\xA4\xAD";
const char* kTeststr_hr_Latn = "Posljednja dva vladara su Kijaksar (\xCE\x9A\xCF\x85\xCE\xB1\xCE\xBE\xCE\xB1\xCF\x81\xCE\xB7\xCF\x82; 625-585 prije Krista), fraortov sin koji \xC4\x87\x65 pro\xC5\xA1iriti teritorij Medije i Astijag. Kijaksar je imao k\xC4\x87\x65r ili unuku koja se zvala Amitis a postala je \xC5\xBE\x65nom Nabukodonosora II. kojoj je ovaj izgradio Vise\xC4\x87\x65 vrtove Babilona. Kijaksar je modernizirao svoju vojsku i uni\xC5\xA1tio Ninivu 612. prije Krista. Naslijedio ga je njegov sin, posljednji medijski kralj, Astijag, kojega je detronizirao (sru\xC5\xA1io sa vlasti) njegov unuk Kir Veliki. Zemljom su zavladali Perzijanci.";
const char* kTeststr_ht_Latn = " ak pitit tout sosyete a chita se pou sa leta dwe pwoteje yo nimewo leta f\xC3\xA8t pou li pwoteje tout paran ak pitit nan peyi a menm jan kit paran yo marye kit yo pa marye tout manman ki f\xC3\xA8 pitit leta f\xC3\xA8t pou ba yo konkoul menm jan tou pou timoun piti ak pou";
const char* kTeststr_hu_Latn = " a felhaszn\xC3\xA1l\xC3\xB3im a google azonos\xC3\xADt\xC3\xB3 sz\xC3\xB6veget ikor l\xC3\xA1tj\xC3\xA1k a felhaszn\xC3\xA1l\xC3\xB3im a google azonos\xC3\xADt\xC3\xB3 sz\xC3\xB6veget felhaszn\xC3\xA1l\xC3\xB3k a google azonos\xC3\xADt\xC3\xB3 sz\xC3\xB6veget fogj\xC3\xA1k l\xC3\xA1tni minden tranzakci\xC3\xB3 ut\xC3\xA1n ha a v\xC3\xA1s\xC3\xA1rl\xC3\xA1s\xC3\xA1t regisztr\xC3\xA1\x63i\xC3\xB3j\xC3\xA1t oldalunk";
const char* kTeststr_hy_Armn = " \xD5\xA1 \xD5\xB5 \xD5\xA5\xD5\xBE \xD5\xB6\xD5\xA1 \xD5\xB0\xD5\xAB\xD5\xA1\xD6\x81\xD5\xA1\xD5\xAE \xD5\xA1\xD5\xB9\xD6\x84\xD5\xA5\xD6\x80\xD5\xB8\xD5\xBE \xD5\xB6\xD5\xA1\xD5\xB5\xD5\xB8\xD6\x82\xD5\xB4 \xD5\xA7 \xD5\xB0\xD5\xAB\xD5\xB6\xD5\xA3\xD5\xB0\xD5\xA1\xD6\x80\xD5\xAF\xD5\xA1\xD5\xB6\xD5\xAB \xD5\xB7\xD5\xA5\xD5\xB6\xD6\x84\xD5\xAB \xD5\xBF\xD5\xA1\xD6\x80\xD6\x85\xD6\x80\xD5\xAB\xD5\xB6\xD5\xA1\xD5\xAF \xD6\x83\xD5\xB8\xD6\x84\xD6\x80\xD5\xAB\xD5\xAF \xD6\x84\xD5\xA1\xD5\xBC\xD5\xA1\xD5\xAF\xD5\xB8\xD6\x82\xD5\xBD\xD5\xAB \xD5\xBA\xD5\xA1\xD5\xBF\xD5\xB8\xD6\x82\xD5\xB0\xD5\xA1\xD5\xB6\xD5\xB6\xD5\xA5\xD6\x80\xD5\xAB\xD5\xB6 \xD5\xA4\xD5\xA5\xD5\xBC \xD5\xB4\xD5\xA5\xD5\xB6\xD6\x84 \xD5\xB7\xD5\xA1\xD5\xBF \xD5\xA5\xD5\xB6\xD6\x84 \xD5\xB0\xD5\xA5\xD5\xBF\xD5\xA1\xD5\xB4\xD5\xB6\xD5\xA1\xD6\x81 \xD5\xA1\xD5\xBD\xD5\xB8\xD6\x82\xD5\xB4 \xD5\xA7 \xD5\xB6\xD5\xA1 \xD5\xA1\xD5\xB5\xD5\xBD\xD5\xBA\xD5\xA5\xD5\xBD \xD5\xA7";
const char* kTeststr_ia_Latn = " super le sitos que tu visita isto es necessari pro render disponibile alcun functionalitates del barra de utensiles a fin que nos pote monstrar informationes ulterior super un sito le barra de utensiles debe dicer a nos le";
//const char* kTeststr_id_Latn = "Geng: Pengembaraan Bermula adalah film animasi 3D CGI pertama yang diproduksi di Malaysia. Film ini dibuat oleh Les' Copaque Production (LCP) dan dirilis di bioskop-bioskop seluruh Malaysia pada 12 Februari 2009. Film Geng pertama kali diluncurkan dalam sebuah acara peluncuran pada 11 September 2007 bersama dengan serial animasi pendek Upin & Ipin yang berhubungan dengan film tersebut. Pembuatan film ini didukung oleh berbagai pihak seperti Kementerian Sains, Teknologi dan Inovasi Malaysia (MOSTI) dengan memberi bantuan berupa dana sebesar RM1 juta.";
// From 10% testing part of new lang=id scrape
const char* kTeststr_id_Latn = "berdiri setelah pengurusnya yang berusia 83 tahun, Fayzrahman Satarov, mendeklarasikan diri sebagai nabi dan rumahnya sebagai negara Islam Satarov digambarkan sebagai mantan ulama Islam  tahun 1970-an. Pengikutnya didorong membaca manuskripnya dan kebanyakan dilarang meninggalkan tempat persembunyian bawah tanah di dasar gedung delapan lantai mereka. Jaksa membuka penyelidikan kasus kriminal pada kelompok itu dan menyatakan akan membubarkan kelompok kalau tetap melakukan kegiatan ilegal seperti mencegah anggotanya mencari bantuan medis atau pendidikan. Sampai sekarang pihak berwajib belum melakukan penangkapan meskipun polisi mencurigai adanya tindak kekerasan pada anak. Pengadilan selanjutnya akan memutuskan apakah anak-anak diizinkan tetap tinggal dengan orang tua mereka. Kazan yang berada sekitar 800 kilometer di timur Moskow merupakan wilayah Tatarstan yang";

const char* kTeststr_ie_Latn = " abhorre exceptiones in li derivation plu cardinal por un l i es li regularit\xC3\xA0 del flexion conjugation ples comparar latino sine flexione e li antiqui projectes naturalistic queles have quasi null regules de derivation ma si on nu examina li enunciationes";
const char* kTeststr_ig_Latn = "Chineke b\xE1\xBB\xA5 aha \xE1\xBB\x8Dz\xE1\xBB\x8D nd\xC3\xAF omenala Igbo kp\xE1\xBB\x8Dro Chukwu. Mgbe nd\xE1\xBB\x8B bekee b\xE1\xBB\x8B\x61ra, ha mee ya nke ndi Christian. N'echiche ndi ekpere chi Omenala Ndi Igbo, Christianity, Judaism, ma Islam, Chineke nwere \xE1\xBB\x8Dt\xE1\xBB\xA5t\xE1\xBB\xA5 utu aha, ma nwee nan\xE1\xBB\x8B otu aha. \xE1\xBB\xA4z\xE1\xBB\x8D ab\xE1\xBB\xA5\xE1\xBB\x8D e si akp\xE1\xBB\x8D aha ah\xE1\xBB\xA5 b\xE1\xBB\xA5 Jehovah ma \xE1\xBB\x8C b\xE1\xBB\xA5 Yahweh. Na \xE1\xBB\x8Dt\xE1\xBB\xA5t\xE1\xBB\xA5 Akw\xE1\xBB\xA5kw\xE1\xBB\x8D Ns\xE1\xBB\x8D, e wep\xE1\xBB\xA5la aha Chineke ma jiri utu aha b\xE1\xBB\xA5 Onyenwe Any\xE1\xBB\x8B ma \xE1\xBB\x8D b\xE1\xBB\xA5 Chineke dochie ya. Ma mgbe e dere akw\xE1\xBB\xA5kw\xE1\xBB\x8D ns\xE1\xBB\x8D, aha ah\xE1\xBB\xA5 b\xE1\xBB\xA5 Jehova p\xE1\xBB\xA5tara n\xE2\x80\x99ime ya, ihe d\xE1\xBB\x8B ka ugboro p\xE1\xBB\xA5k\xE1\xBB\xA5 asaa(7,000).";
//const char* kTeststr_ik_Latn = " kuubuuraqabniqsuq ataruamik colville mi aasii tavrani siku kilaabman sulukpaukkat makua niksisugrufagivut tavrani sunaim\xC3\xB1\x61 atifa quaqqat ii quaqqat aasii ukiabmagu utiqhuta tamaufa utqiabvif\xC3\xB1un aasii\xC3\xB1 tatpaaffaqapta tuvaaqatinifarufa aasii\xC3\xB1";
// From 10% testing part of new lang=ik scrape
const char* kTeststr_ik_Latn = "sabvaqjuktuq sabvaba atiqaqpa atiqaqpa ibiq iebiq ixafich niuqtulgi\xC3\xB1\xC3\xB1\x61tif uvani natural gas tatpikka ufasiksigiruaq maaffa savaannafarufa mi tatkivani navy qanuqjugugguuq taaptuma inna uqsrunik ivaqjiqhutik       taktuk allualiuqtuq sigukun nanuq puuvraatuq taktuum amugaa kalumnitigun nanuq agliruq allualiuqtuq";

const char* kTeststr_is_Latn = " a afk\xC3\xB6st leitaror\xC3\xB0\x61 \xC3\xBEinna leitaror\xC3\xB0 neikv\xC3\xA6\xC3\xB0 leitaror\xC3\xB0 augl\xC3\xBDsingah\xC3\xB3pa byggja upp a\xC3\xB0\x61llista yfir n\xC3\xBD leitaror\xC3\xB0 fyrir augl\xC3\xBDsingah\xC3\xB3pana og sko\xC3\xB0\x61 \xC3\xADtarleg g\xC3\xB6gn um \xC3\xA1rangur leitaror\xC3\xB0\x61 eins og samkeppni augl\xC3\xBDsenda og leitarmagn er krafist notkun";
const char* kTeststr_it_Latn = " a causa di un intervento di manutenzione del sistema fino alle ore circa ora legale costa del pacifico del novembre le campagne esistenti continueranno a essere pubblicate come di consueto anche durante questo breve periodo di inattivit\xC3\xA0 ci scusiamo per";
const char* kTeststr_iu_Cans = "\xE1\x90\x83\xE1\x91\xAF\xE1\x92\xAA\xE1\x92\xBB\xE1\x92\xAA\xE1\x91\xA6 \xE1\x95\xBF\xE1\x93\x88\xE1\x96\x8F\xE1\x93\x90\xE1\x93\x87\xE1\x93\xB2\xE1\x96\x91\xE1\x92\xBB\xE1\x92\xAA\xE1\x91\xA6 \xE1\x91\x8E\xE1\x91\x8E\xE1\x96\x85\xE1\x91\x95\xE1\x93\x95\xE1\x92\xAB\xE1\x96\x85\xE1\x93\x83\xE1\x95\x95\xE1\x91\xA6 \xE1\x91\x8E\xE1\x91\xA6\xE1\x95\x86\xE1\x90\x8A\xE1\x91\x90\xE1\x93\x90\xE1\x96\x8F\xE1\x91\xA6\xE1\x91\x95\xE1\x91\x8E\xE1\x91\xA6 \xE1\x91\x8E\xE1\x91\x8E\xE1\x96\x85\xE1\x91\x95\xE1\x91\x89\xE1\x90\xB1\xE1\x91\xA6 \xE1\x93\xAF\xE1\x95\x97\xE1\x93\x82\xE1\x96\x93\xE1\x93\x82 \xE1\x91\x8E\xE1\x91\x8E\xE1\x96\x85\xE1\x96\x83\xE1\x96\x85 \xE1\x91\x8E\xE1\x91\x8E\xE1\x95\x86\xE1\x90\x8A\xE1\x91\x90\xE1\x93\x90\xE1\x96\x8F\xE1\x91\x95\xE1\x90\x83\xE1\x91\xA6 \xE1\x95\xBF\xE1\x93\x82\xE1\x93\xB2\xE1\x96\x91\xE1\x94\xAA\xE1\x92\x8D\xE1\x91\xA6 \xE1\x91\x8E\xE1\x91\x8E\xE1\x96\x85\xE1\x91\x95\xE1\x93\x95\xE1\x92\xAB\xE1\x96\x85\xE1\x93\x83\xE1\x95\x95\xE1\x91\xA6";
const char* kTeststr_iw_Hebr = " \xD7\x90\xD7\x95 \xD7\x9C\xD7\xA2\xD7\xA8\xD7\x95\xD7\x9A \xD7\x90\xD7\xAA \xD7\x94\xD7\xA2\xD7\x93\xD7\xA4\xD7\x95\xD7\xAA \xD7\x94\xD7\x94\xD7\xA4\xD7\xA6\xD7\x94 \xD7\x90\xD7\xA0\xD7\x90 \xD7\xA2\xD7\xA7\xD7\x95\xD7\x91 \xD7\x90\xD7\x97\xD7\xA8\xD7\x99 \xD7\x94\xD7\xA9\xD7\x9C\xD7\x91\xD7\x99\xD7\x9D \xD7\x94\xD7\x91\xD7\x90\xD7\x99\xD7\x9D \xD7\x9B\xD7\xA0\xD7\xA1 \xD7\x9C\xD7\x97\xD7\xA9\xD7\x91\xD7\x95\xD7\x9F \xD7\x94\xD7\x90\xD7\x99\xD7\xA9\xD7\x99 \xD7\xA9\xD7\x9C\xD7\x9A \xD7\x91";
const char* kTeststr_ja_Hani = " \xE3\x81\x93\xE3\x81\xAE\xE3\x83\x9A \xE3\x82\xB8\xE3\x81\xA7\xE3\x81\xAF \xE3\x82\xA2\xE3\x82\xAB\xE3\x82\xA6\xE3\x83\xB3\xE3\x83\x88\xE3\x81\xAB\xE6\x8C\x87\xE5\xAE\x9A\xE3\x81\x95\xE3\x82\x8C\xE3\x81\x9F\xE4\xBA\x88\xE7\xAE\x97\xE3\x81\xAE\xE5\xB1\xA5\xE6\xAD\xB4\xE3\x82\x92\xE4\xB8\x80\xE8\xA6\xA7\xE3\x81\xAB\xE3\x81\x97\xE3\x81\xA6\xE3\x81\x84\xE3\x81\xBE\xE3\x81\x99 \xE3\x81\x9D\xE3\x82\x8C\xE3\x81\x9E\xE3\x82\x8C\xE3\x81\xAE\xE9\xA0\x85\xE7\x9B\xAE\xE3\x81\xAB\xE3\x81\xAF \xE4\xBA\x88\xE7\xAE\x97\xE9\xA1\x8D\xE3\x81\xA8\xE7\x89\xB9\xE5\xAE\x9A\xE6\x9C\x9F\xE9\x96\x93\xE3\x81\xAE\xE3\x82\xB9\xE3\x83\x86 \xE3\x82\xBF\xE3\x82\xB9\xE3\x81\x8C\xE8\xA1\xA8\xE7\xA4\xBA\xE3\x81\x95\xE3\x82\x8C\xE3\x81\xBE\xE3\x81\x99 \xE7\x8F\xBE\xE5\x9C\xA8\xE3\x81\xBE\xE3\x81\x9F\xE3\x81\xAF\xE4\xBB\x8A\xE5\xBE\x8C\xE3\x81\xAE\xE4\xBA\x88\xE7\xAE\x97\xE3\x82\x92\xE8\xA8\xAD\xE5\xAE\x9A\xE3\x81\x99\xE3\x82\x8B\xE3\x81\xAB\xE3\x81\xAF";
const char* kTeststr_jw_Latn = " account ten server niki kalian username meniko tanpo judul cacahe account nggonanmu wes pol pesen mu wes diguwak pesenan mu wes di simpen sante wae pesenan mu wes ke kirim mbuh tekan ora pesenan e ke kethok pesenan mu wes ke kirim mbuh tekan ora pesenan";
const char* kTeststr_ka_Geor = " \xE1\x83\x90 \xE1\x83\x91\xE1\x83\x98\xE1\x83\xA0\xE1\x83\x97\xE1\x83\x95\xE1\x83\x98\xE1\x83\x93\xE1\x83\x90\xE1\x83\x9C \xE1\x83\x9B\xE1\x83\x98\xE1\x83\xA6\xE1\x83\x94\xE1\x83\x91\xE1\x83\xA3\xE1\x83\x9A\xE1\x83\x98 \xE1\x83\x94\xE1\x83\x9A\xE1\x83\x94\xE1\x83\x9B\xE1\x83\x94\xE1\x83\x9C\xE1\x83\xA2\xE1\x83\x98 \xE1\x83\x9B\xE1\x83\x94\xE1\x83\x9C\xE1\x83\x93\xE1\x83\x94\xE1\x83\x9A\xE1\x83\x94\xE1\x83\x94\xE1\x83\x95\xE1\x83\x98\xE1\x83\xA1 \xE1\x83\x9E\xE1\x83\x94\xE1\x83\xA0\xE1\x83\x98\xE1\x83\x9D\xE1\x83\x93\xE1\x83\xA3\xE1\x83\x9A \xE1\x83\xA1\xE1\x83\x98\xE1\x83\xA2\xE1\x83\x94\xE1\x83\x9B\xE1\x83\x90\xE1\x83\xA8\xE1\x83\x98 \xE1\x83\x92\xE1\x83\x90\xE1\x83\x93\xE1\x83\x90\xE1\x83\x98\xE1\x83\x9C\xE1\x83\x90\xE1\x83\xAA\xE1\x83\x95\xE1\x83\x9A\xE1\x83\x94\xE1\x83\x91\xE1\x83\xA1 \xE1\x83\x9D\xE1\x83\xA0\xE1\x83\x98 \xE1\x83\xA3\xE1\x83\xAF\xE1\x83\xA0\xE1\x83\x98\xE1\x83\x97";
const char* kTeststr_kha_Latn = " kaba jem jai sa sngap thuh ia ki bynta ba sharum naka sohbuin jong phi nangta sa pynhiar ia ka kti kadiang jong phi sha ka krung jong phi bad da kaba pyndonkam kumjuh ia ki shympriahti jong phi sa sngap thuh shapoh ka tohtit jong phi pyndonkam ia kajuh ka";
const char* kTeststr_kk_Arab = " \xEF\xBA\x8E \xEF\xBB\x97\xEF\xBB\xB4\xEF\xBA\x8E\xEF\xBB\xA7\xEF\xBA\x8E\xEF\xBA\x95 \xEF\xBA\x91\xEF\xBB\xAE\xEF\xBB\x9F\xEF\xBB\xA4\xEF\xBA\x8E\xEF\xBB\xB3\xEF\xBA\xAA\xEF\xBB\xAF \xEF\xBA\x91\xEF\xAF\x98\xEF\xBB\x9D \xEF\xAD\x98\xEF\xBA\xAE\xEF\xBB\xAD\xEF\xBA\x97\xEF\xBA\xB4\xEF\xBB\xAA\xEF\xBA\xB3\xEF\xAF\xA9\xEF\xBB\xA6 \xEF\xBB\xB3\xEF\xBA\x8E\xEF\xBB\x8B\xEF\xBB\xA8\xEF\xBB\xB2 \xEF\xBB\x97\xEF\xBA\x8E\xEF\xBB\xBB \xEF\xBB\xAD\xEF\xBB\xA3\xEF\xAF\xA9\xEF\xBA\xAE\xEF\xAF\xA8\xEF\xBB\xA8\xEF\xBA\xAA\xEF\xBB\xA9 \xEF\xBB\x97\xEF\xBA\x8E\xEF\xBA\xAF\xEF\xBA\x8D\xEF\xBB\x95 \xD8\xA1 \xEF\xBA\x97\xEF\xAF\xA9\xEF\xBB\xA0\xEF\xAF\xA9\xEF\xBB\xA8\xEF\xAF\xA9\xEF\xAF\x94 \xEF\xBB\x97\xEF\xBB\xAE\xEF\xBB\x9F\xEF\xBA\xAA\xEF\xBA\x8D\xEF\xBB\xA7\xEF\xAF\xA9\xEF\xBB\xA0\xEF\xBB\xA4\xEF\xBA\x8E\xEF\xAF\x9E\xEF\xBB\xAF \xEF\xBB\x97\xEF\xBA\x8E\xEF\xBA\xAF\xEF\xBA\x8D\xEF\xBB\x95 \xEF\xBA\x9F\xEF\xBB\xAA\xEF\xBA\xAD\xEF\xAF\xA8\xEF\xBB\xA8\xEF\xBA\xAA\xEF\xBB\xA9";
const char* kTeststr_kk_Cyrl = " \xD0\xB0 \xD0\xB1\xD0\xB8\xD0\xBB\xD0\xB5\xD1\x80\xD0\xB4\xD1\x96\xD2\xA3 \xD3\xA9\xD0\xB7\xD1\x96\xD0\xBD\xD0\xB5 \xD1\x80\xD2\xB1\xD2\x9B\xD1\x81\xD0\xB0\xD1\x82 \xD0\xB1\xD0\xB5\xD1\x80\xD1\x96\xD0\xBB\xD0\xBC\xD0\xB5\xD0\xB3\xD0\xB5\xD0\xBD \xD0\xB5\xD0\xB3\xD0\xB5\xD1\x80 \xD1\x85\xD0\xB0\xD0\xBB\xD1\x8B\xD2\x9B \xD1\x82\xD0\xB0\xD0\xBB\xD0\xB0\xD0\xBF \xD0\xB5\xD1\x82\xD1\x81\xD0\xB5 \xD2\x93\xD0\xB0\xD0\xBD\xD0\xB0 \xD1\x85\xD0\xB0\xD0\xBD \xD0\xBA\xD0\xB5\xD0\xBB\xD1\x96\xD1\x81\xD1\x96\xD0\xBC \xD0\xB1\xD0\xB5\xD1\x80\xD0\xB3\xD0\xB5\xD0\xBD \xD3\xA9\xD0\xB7\xD0\xB4\xD0\xB5\xD1\x80\xD1\x96\xD2\xA3\xD1\x96\xD0\xB7 \xD0\xB1\xD1\x96\xD0\xBB\xD0\xB5\xD1\x81\xD1\x96\xD0\xB7\xD0\xB4\xD0\xB5\xD1\x80 \xD2\x9B\xD1\x80 \xD2\x9B\xD1\x8B\xD0\xBB \xD0\xBC\xD1\x8B\xD1\x81 \xD1\x82\xD1\x8B\xD2\x9B \xD0\xBA\xD0\xBE\xD0\xB4\xD0\xB5\xD0\xBA\xD1\x81\xD1\x96\xD0\xBD\xD0\xB4\xD0\xB5 \xD0\xB6\xD0\xB0\xD0\xB7\xD0\xB0\xD0\xBD\xD1\x8B\xD2\xA3";
const char* kTeststr_kk_Latn = " bolsa da otanyna qaityp keledi al oralmandar basqa elderde diasporasy ote az bolghandyqtan bir birine komektesip bauyrmal bolady birde men poezben oralmandardyng qazaqstangha keluin kordim monghol qazaqtary poezdan tuse sala jerdi suip jylap keletin biraq";
const char* kTeststr_kl_Latn = " at nittartakkalli uani toqqarsimasatta akornanni nittartakkanut allanut ingerlaqqittoqarsinnaavoq kanukoka tassaavoq kommuneqarfiit kattuffiat nuna tamakkerlugu kommunit nittartagaannut ingerlaqqiffiusinnaasoq kisitsiserpassuit nunatsinnut tunngasut";
const char* kTeststr_km_Khmr = " \xE1\x9E\x80 \xE1\x9E\x81 \xE1\x9E\x82 \xE1\x9E\x83 \xE1\x9E\x84 \xE1\x9E\x85 \xE1\x9E\x86 \xE1\x9E\x87 \xE1\x9E\x88 \xE1\x9E\x89 \xE1\x9E\x8A \xE1\x9E\x8B \xE1\x9E\x8C \xE1\x9E\x8D \xE1\x9E\x8E \xE1\x9E\x8F \xE1\x9E\x90 \xE1\x9E\x91 \xE1\x9E\x92 \xE1\x9E\x93 \xE1\x9E\x94 \xE1\x9E\x95 \xE1\x9E\x96 \xE1\x9E\x97 \xE1\x9E\x98 \xE1\x9E\x99 \xE1\x9E\x9A \xE1\x9E\x9B \xE1\x9E\x9C \xE1\x9E\x9F \xE1\x9E\xA0 \xE1\x9E\xA1 \xE1\x9E\xA2 \xE1\x9E\xA5 \xE1\x9E\xA6 \xE1\x9E\xA7 \xE1\x9E\xAA \xE1\x9E\xAB \xE1\x9E\xAC \xE1\x9E\xAF \xE1\x9E\xB1 \xE1\x9E\x91\xE1\x9E\xB6\xE1\x9F\x86\xE1\x9E\x84\xE1\x9E\xA2\xE1\x9E\x9F\xE1\x9F\x8B";
const char* kTeststr_kn_Knda = " \xE0\xB2\x82\xE0\xB2\xA0\xE0\xB2\xAF\xE0\xB3\x8D\xE0\xB2\xAF\xE0\xB2\xA8\xE0\xB2\xB5\xE0\xB2\xB0\xE0\xB3\x81 \xE0\xB2\xA4\xE0\xB3\x81\xE0\xB2\xAE\xE0\xB2\x95\xE0\xB3\x82\xE0\xB2\xB0\xE0\xB3\x81 \xE0\xB2\x9C\xE0\xB2\xBF\xE0\xB2\xB2\xE0\xB3\x8D\xE0\xB2\xB2\xE0\xB3\x86\xE0\xB2\xAF \xE0\xB2\x9A\xE0\xB2\xBF\xE0\xB2\x95\xE0\xB3\x8D\xE0\xB2\x95\xE0\xB2\xA8\xE0\xB2\xBE\xE0\xB2\xAF\xE0\xB2\x95\xE0\xB2\xA8\xE0\xB2\xB9\xE0\xB2\xB3\xE0\xB3\x8D\xE0\xB2\xB3\xE0\xB2\xBF \xE0\xB2\xA4\xE0\xB2\xBE\xE0\xB2\xB2\xE0\xB3\x8D\xE0\xB2\xB2\xE0\xB3\x82\xE0\xB2\x95\xE0\xB2\xBF\xE0\xB2\xA8 \xE0\xB2\xA4\xE0\xB3\x80\xE0\xB2\xB0\xE0\xB3\x8D\xE0\xB2\xA5\xE0\xB2\xAA\xE0\xB3\x81\xE0\xB2\xB0 \xE0\xB2\xB5\xE0\xB3\x86\xE0\xB2\x82\xE0\xB2\xAC \xE0\xB2\xB8\xE0\xB2\xBE\xE0\xB2\xA7\xE0\xB2\xBE\xE0\xB2\xB0\xE0\xB2\xA3 \xE0\xB2\xB9\xE0\xB2\xB3\xE0\xB3\x8D\xE0\xB2\xB3\xE0\xB2\xBF\xE0\xB2\xAF \xE0\xB2\xB6\xE0\xB3\x8D\xE0\xB2\xAF\xE0\xB2\xBE\xE0\xB2\xA8\xE0\xB3\x81\xE0\xB2\xAD\xE0\xB3\x8B\xE0\xB2\x97\xE0\xB2\xB0";
const char* kTeststr_ko_Hani = " \xEA\xB0\x9C\xEB\xB3\x84\xEC\xA0\x81\xEC\x9C\xBC\xEB\xA1\x9C \xEB\xA6\xAC\xED\x8F\xAC\xED\x8A\xB8 \xEC\x95\xA1\xEC\x84\xB8\xEC\x8A\xA4 \xEA\xB6\x8C\xED\x95\x9C\xEC\x9D\x84 \xEB\xB6\x80\xEC\x97\xAC\xED\x95\xA0 \xEC\x88\x98 \xEC\x9E\x88\xEC\x8A\xB5\xEB\x8B\x88\xEB\x8B\xA4 \xEC\x95\xA1\xEC\x84\xB8\xEC\x8A\xA4 \xEA\xB6\x8C\xED\x95\x9C \xEB\xB6\x80\xEC\x97\xAC\xEC\x82\xAC\xEC\x9A\xA9\xEC\x9E\x90\xEC\x97\x90\xEA\xB2\x8C \xED\x94\x84\xEB\xA1\x9C\xED\x95\x84 \xEB\xA6\xAC\xED\x8F\xAC\xED\x8A\xB8\xEC\x97\x90 \xEC\x95\xA1\xEC\x84\xB8\xEC\x8A\xA4\xED\x95\xA0 \xEC\x88\x98 \xEC\x9E\x88\xEB\x8A\x94 \xEA\xB6\x8C\xED\x95\x9C\xEC\x9D\x84 \xEB\xB6\x80\xEC\x97\xAC\xED\x95\x98\xEC\x8B\x9C\xEB\xA0\xA4\xEB\xA9\xB4 \xEA\xB0\x80\xEC\x9A\xA9 \xED\x94\x84\xEB\xA1\x9C\xED\x95\x84 \xEC\x83\x81\xEC\x9E\x90\xEC\x97\x90\xEC\x84\x9C \xED\x94\x84\xEB\xA1\x9C\xED\x95\x84 \xEC\x9D\xB4\xEB\xA6\x84\xEC\x9D\x84 \xEC\x84\xA0\xED\x83\x9D\xED\x95\x9C \xEB\x8B\xA4\xEC\x9D\x8C";
//const char* kTeststr_ks_Arab = "\xD9\xBE\xDB\x8C\xD9\xB9\xDA\xBE \xD8\xB3\xD9\xAE\xDB\xAA\xD8\xA7\xDA\xAF\xD8\xAA! \xD8\xA2\xDA\xA9\xDA\xBE \xD8\xA2\xD8\xB2\xD8\xA7\xD8\xAF \xDA\xAF\xDB\x8C\xD8\xA7\xD9\x86\xDA\xA9\xD9\x88\xD8\xB4\xD9\x96\xD9\x94 \xDB\x81\xDB\x84 \xDA\xA9\xD9\xB2\xD9\x86\xD9\x9B\xD8\xB3\xD9\x90\xDB\x81 \xD8\xAA\xD9\x90\xDB\x81 \xDB\x81\xD9\xAE\xDB\xAA\xDA\xA9\xD9\x8F\xD9\x86 \xD8\xA7\xD9\xAE\xDB\xAA\xDA\x91\xD9\x90\xD9\xB9\xDB\x94 \xD8\xAA\xD9\x88\xD8\xB1 \xDA\x86\xDA\xBE\xDA\xA9 \xD9\xA2\xD9\xA2\xD9\xA8 \xD9\x85\xD9\x8E\xD8\xB6\xD9\x85\xD9\x88\xD9\x97\xD9\x86\xD9\x86 \xD9\x85\xD9\x86\xD8\xB2 \xDA\xA9\xD9\xB2\xD8\xB4\xD9\x8F\xD8\xB1 \xD9\x88\xDB\x8C\xDA\xA9\xDB\x8C\xD9\xBE\xDB\x8C\xD9\x96\xDA\x88\xDB\x8C\xD8\xA7 \xDA\x86\xDA\xBE\xD9\x8F \xD8\xA2\xDA\xA9\xDA\xBE \xD9\x85\xD9\x8E\xD9\x86\xD8\xB5\xD9\x88\xD9\x97\xD8\xA8\xDB\x81\xD9\x95 \xD8\xAE\xD9\xB2\xD8\xB7\xD8\xB1\xD9\x95 \xD8\xA8\xD9\x86\xD9\x8E\xD8\xA7\xD9\x88\xD9\x8F\xD9\x86 \xD8\xA2\xDA\xA9\xDA\xBE \xDA\xAF\xDB\x8C\xD8\xA7\xD9\x86\xDA\xA9\xD9\x88\xD8\xB4\xD9\x96\xD9\x94 \xD8\xB3\xDB\xAD\xD8\xAA\xDB\x8D \xD8\xA2\xD8\xB2\xD8\xA7\xD8\xAF \xD9\x85\xD9\x86\xD8\xB2 280 \xD8\xB2\xD9\x8E\xD8\xA8\xD8\xA7\xD9\x86\xD9\x8E\xD9\x86 \xD8\xAA\xD9\x94\xD9\x85\xD9\x90\xD8\xB3 \xDB\x8C\xDB\x84\xD8\xB3\xDB\x81\xD9\x95 \xDA\x98\xD9\x95 \xD8\xB3\xDB\xAD\xD8\xAA\xDB\x8D \xD8\xAA\xD9\x8F\xDB\x81\xD9\x8F\xD9\x86\xD9\x9B\xD8\xAF \xDA\xAF\xDB\x8C\xD8\xA7\xD9\x86 \xDB\x81\xD9\x8F\xD8\xB1\xD9\xAE\xDB\xAA\xD8\xB1 \xDA\xA9\xD9\x8E\xD8\xB1\xD9\x8F\xD9\x86 \xDB\x81\xD9\xAE\xDB\xAA\xDA\xA9\xD9\x8F\xD9\x86";
// From 10% testing part of new lang=ks scrape
const char* kTeststr_ks_Arab = " \xDA\x98\xD9\x85\xD8\xA7\xDA\xBA \xD8\xB3\xD8\xB1\xD8\xA7\xD8\xA8\xD9\x86 \xD9\x85\xD9\x86\xD8\xB2  \xDA\xAF\xD8\xB1\xD9\xB2\xD9\x86 \xDA\x86\xDA\xBE\xD9\x90\xDB\x81 \xD8\xAE\xD8\xA7\xD8\xA8\xD9\x95\xDA\xA9 \xDA\xA9\xDA\xBE\xD9\x84\xD9\x88\xD9\x86\xDB\x81\xD9\x95 \xD9\x88\xD9\x94\xDA\x88\xD8\xB1\xD8\xA7\xD9\x88\xD8\xA7\xDA\xBA   \xD8\xAA\xD9\x8F\xD9\x84\xD8\xAA\xD9\x90\xDA\xBE \xD9\x86\xD9\x90\xDB\x8C\xD9\x8E\xD8\xB3 \xD8\xAA\xDB\x81\xD9\x95 \xDA\xAF\xD9\x88\xD8\xB4\xDB\x81\xD9\x90 \xDA\xAF\xD9\x88\xD8\xB4\xDB\x81\xD9\x90 \xD9\x85\xD9\x86\xD8\xAF\xDA\x86\xDA\xBE\xD8\xA7\xD9\x88\xD9\x89\xDB\xAA\xD8\xB3   \xD8\xAF\xD9\x90\xD9\x84\xD8\xB3 \xDA\x86\xDA\xBE\xD9\x8F\xDB\x81 \xD9\x88\xD9\x88\xD9\x86\xD9\x98\xD8\xAA \xD9\x88\xD9\x8F\xDA\x86\xDA\xBE\xD8\xA7\xD9\x86 \xD8\xA7\xD8\xB2 \xD8\xB3\xD8\xAA\xD9\x85 \xD9\x82\xD9\x84\xD9\x85  \xD8\xB5\xD8\xA8\xD9\x88\xD9\x9D\xD8\xB1\xD9\x95 \xD9\x88\xD9\x88\xD9\x84 \xD9\x85\xD8\xB3\xD9\xB2\xD9\x81\xD8\xB1 \xD9\x84\xDB\x8C\xDB\x86\xDA\xA9\xDA\xBE\xD9\x8F\xD9\x86 \xD8\xA8\xDB\x8E\xD8\xAA\xD8\xA7\xD8\xA8\xD9\x86 \xD9\x85\xD9\x86\xD8\xB2   \xD9\x88\xD8\xB1\xD9\x84 \xD8\xB3\xD9\x88\xD8\xA7\xD9\x84 \xDA\x86\xDA\xBE\xD9\x8F\xDB\x81 \xD8\xAA\xD8\xB1\xD8\xA7\xD9\x88\xD8\xA7\xDA\xBA \xD8\xAC\xD9\x88\xD8\xA7\xD8\xA8\xD9\x86 \xD9\x85\xD9\x86\xD8\xB2    \xDA\xA9\xD8\xA7\xD9\x84\xDB\x81\xD9\x95 \xD9\xBE\xDA\xBE\xDB\xAF\xD8\xB3\xD8\xAA\xDB\x81\xD9\x95 \xD9\xBE\xDA\xBE\xD9\x86\xD9\x98\xD8\xA8 \xD9\xBE\xDA\xAF\xD9\x8E\xDB\x81\xDB\x81 \xD9\xBE\xDB\x81   \xD9\xBE\xDB\x86\xD8\xAA \xD9\x86\xD8\xB8\xD8\xB1 \xD8\xAF\xD9\x90\xDA\x98 \xD9\x86\xDB\x81\xD9\x95 \xDA\x98\xDA\xBE\xD8\xA7\xD9\x84\xDB\x81\xD9\x95 \xD9\x85\xD9\x94\xD8\xAA \xD8\xA2\xD8\xB1\xD9\x86     \xD9\x85\xD9\xB2\xD9\x86\xD8\xB2 \xD9\x85\xD8\xB3\xD9\x88\xD9\x84 \xD9\x85\xD8\xAA\xDA\xBE\xD8\xA7\xD9\x86 \xDA\x86\xDA\xBE\xDB\x92\xD9\x9A \xD9\x85\xD8\xB3 \xD9\x88\xD8\xA7\xD9\x84\xD9\x86  \xD9\x88\xDB\x85\xD9\x86 \xDA\x86\xDA\xBE\xDB\x92\xD9\x9A \xD8\xBA\xD8\xA7\xD8\xB1\xD9\x86 \xD8\xAA\xDB\x81\xD9\x90 \xD9\x86\xD8\xA7\xD8\xB1\xD9\x95 \xDA\x98\xDA\xBE\xD9\xB9\xDA\xBE \xDA\x98\xD8\xA7\xD9\xBE\xD8\xA7\xD9\x86  \xD8\xB1\xDB\x8E\xD8\xB4 \xD8\xAA\xDB\x85\xD8\xB1\xDA\xAF \xD8\xAA\xD8\xB1\xD8\xA7\xD9\x88\xD9\x95\xDB\x81\xD9\x86 \xD8\xAA\xDB\x81\xD9\x95 \xD9\x88\xD9\x86 \xD8\xB1\xD9\xB9\xDB\x81\xD9\x95 \xDB\x81\xD9\x86  \xDB\x81\xD9\x88\xD8\xB4\xDB\x81\xD9\x90 \xDB\x81\xDB\x8E\xDB\x86\xDA\x86\xDA\xBE \xD9\x86\xDB\x81\xD9\x95 \xD9\xBE\xD9\x88\xD8\xB4\xD9\x86\xD9\x88\xD9\x9D\xD9\x84\xD8\xB3 \xD9\x86\xD9\x90\xD8\xB4  \xD9\x85\xDB\x85\xDB\x81\xD8\xB1\xD9\x95 \xD8\xAF\xDB\x8C \xD8\xAF\xDB\x8C \xD8\xB2\xD9\x95\xD9\x84\xD8\xA7\xDA\xBA \xDA\x86\xDA\xBE\xD9\x90 \xD8\xB2\xD9\x89\xDB\xAA\xD9\x88 \xD8\xAD\xD8\xB1\xD9\x81\xD9\x86  \xD9\x84\xDB\x86\xD8\xAF\xD8\xB1\xD9\x95 \xD9\xBE\xDA\xBE\xD9\x94\xD9\x84 \xDB\x81\xD9\x89\xDB\xAA\xD8\xAA\xDA\xBE \xD9\x85\xD9\x84\xD8\xB1 \xD8\xB9\xD8\xA7\xD8\xB2\xD9\x85\xD8\x94  \xD8\xB3\xDB\x86\xD8\xAF\xD8\xB1\xD9\x95 \xDA\xA9\xDA\xBE\xDB\x85\xD9\x86\xDB\x81\xD9\x90 \xD9\x85\xD9\x86\xD8\xB2 \xD9\x85\xD9\x86\xDA\xAF\xD8\xA7\xDA\xBA \xDA\x86\xDA\xBE\xD9\x8F\xDB\x81 \xD9\x86\xD8\xAF\xD8\xB1\xD9\x89\xDB\xAA\xD9\x86 \xD9\xBE\xD9\x86   \xDA\x98\xDB\x92 \xD8\xAA\xDA\xBE\xD9\x89\xDB\xAA\xDA\xA9\xDB\x8C \xDB\x8C\xDB\x81\xD9\x90 \xD9\x85\xD8\xB3\xD9\xB2\xD9\x81\xD8\xB1 \xD9\xBE\xD9\x86\xD9\x86 \xD9\x88\xD9\x8F\xDA\x88\xD9\x88 \xD8\xAA\xDB\x81\xD9\x95 \xD9\xBE\xDA\x91\xD8\xA7\xD9\x88   \xDA\xAF\xD9\x95\xD8\xAA\xD9\x8E\xD9\x88 \xDA\xAF\xD9\x95\xD8\xAA\xD9\x8E\xD9\x88 \xDA\x86\xDA\xBE\xDB\x92\xD9\x9A \xDB\x8C\xDB\x81\xD9\x90 \xDA\xA9\xDB\x85\xD9\x84 \xD8\xA8\xD9\x8F\xD8\xAA\xDA\xBE \xD8\xAA\xDB\x81\xD9\x95 \xD8\xA8\xD8\xA7\xD9\x86\xDB\x81\xD9\x95 \xD8\xB3\xD9\x95\xDB\x81\xDB\x81 \xDA\xAF\xDB\x85\xD8\xB1\xD8\xAF\xD9\x95 \xDA\x86\xDA\xBE\xDB\x81\xD9\x90 \xD8\xB3\xD9\xBE\xD8\xAF\xD8\xA7\xDA\xBA \xD8\xAF\xD9\x85\xDB\x81\xD9\x95 \xD9\xBE\xD9\x8F\xDA\xBE\xD9\xB9  \xDA\x86\xDA\xBE\xD9\x90\xD9\xB9\xDB\x81 \xD9\xBE\xD9\x88\xD9\x86\xD9\xBE\xD8\xB1 \xD9\xBE\xDA\xA9\xDA\xBE\xDB\x81\xD9\x95 \xD8\xAF\xD8\xA7\xD8\xB1\xD8\xA7\xD9\x86 \xD8\xB3\xD9\x8F\xDB\x81 \xDB\x8C\xD8\xAA\xD9\x89\xDB\xAA\xD9\x86 \xD8\xAA\xDB\xAF\xD8\xA7\xD9\x88\xD9\x90  \xDA\xA9\xD9\x85 \xD9\x86\xD8\xB8\xD8\xB1 \xD8\xAF\xDB\xAF\xD8\xA7\xDA\xA9\xDA\xBE \xD8\xAA\xDB\x81\xD9\x95 \xD8\xA8\xD8\xA7\xD8\xB3\xDB\x8C\xD9\x88\xDB\x92 \xD8\xB3\xD9\x8F\xDB\x81 \xD9\x85\xDB\x86\xDB\x81 \xDB\x81\xDB\x8C\xD9\x88 \xDB\x8C\xDB\x8E\xD8\xB1\xD8\xA7\xD9\x86  \xD9\x85\xDB\x92\xD9\x9A \xDA\x98\xD9\x89\xDB\xAA\xD8\xAA\xD9\x8F\xD8\xB1\xD9\x85\xD9\x8F\xD8\xAA \xDA\x86\xDA\xBE\xD9\x8F\xDB\x81 \xD8\xB3\xD9\x8F\xD9\x84\xDB\x8C \xD8\xAA\xD8\xB3 \xDA\x86\xDA\xBE\xDB\x92\xD9\x9A \xDA\xA9\xD8\xAA\xD9\x89\xDB\xAA\xD9\x86 \xD8\xAA\xDA\xBE\xD9\xBE\xDA\xBE  \xD8\xB4\xD8\xA7\xD8\xAF \xD9\x85\xD8\xB3 \xDA\xA9\xD8\xB1\xD8\xA7\xDA\xBA \xD9\x88\xD9\x8F\xDA\x86\xDA\xBE \xD9\x85\xDB\x92\xD9\x9A \xD8\xAE\xD9\x88\xD9\x86  \xDA\x98\xD9\x95 \xD8\xAE\xD8\xA8\xD8\xB1 \xDA\xA9\xDB\x8C\xD8\xA7\xD8\xB2\xD9\x90 \xDA\xA9\xD8\xB1\xD8\xA7\xDA\xBA \xD8\xAF\xDB\xAF\xD8\xA7\xDA\xA9\xDA\xBE \xD8\xAA\xD9\x85\xD9\x90\xD8\xB3 \xD9\xBE\xD9\x89\xDB\xAA\xD9\xB9\xDA\xBE \xD9\x85\xD8\xA7\xD8\xAA\xD9\x85  \xD8\xA7\xD9\x94\xD8\xB2 \xDA\xA9\xDB\x81\xD9\x90 \xD8\xB4\xD8\xA8\xDB\x81\xD9\x95 \xD8\xA2\xD9\x88 \xD9\x85\xDB\x92\xD9\x9A \xD8\xA8\xDB\x8E\xDB\x8C\xDB\x81\xD9\x90 \xD9\xBE\xDB\x8C\xD8\xB4 \xD8\xB3\xD9\x81\xD8\xB1 \xD8\xB2\xD8\xA7\xD9\x86\xDB\x81\xD9\x90 \xD8\xAE\xD8\xAF\xD8\xA7  \xD8\xAF\xD8\xA7\xD8\xB1\xD9\x90 \xD9\xBE\xD9\x89\xDB\xAA\xD9\xB9\xDA\xBE \xDA\x98\xD9\xB2\xD9\x86\xDA\xAF \xDB\x81\xD9\x86\xD8\xA7 \xD8\xAA\xDA\xBE\xD9\x88 \xD8\xB2\xD9\x90 \xDA\x98\xDB\x92 \xDA\x86\xDA\xBE\xDB\x92\xD9\x9A \xD9\x85\xDB\x8E\xD9\x88\xD9\x86  \xD8\xA7\xD9\x94\xD9\x86\xDB\x81\xD9\x95 \xDA\xA9\xD9\xBE\xD9\xB9\xD8\xA7\xDA\xBA \xDA\x86\xDA\xBE\xD9\x8F\xDB\x81 \xD8\xB2\xD9\x95\xDA\x98\xD9\x86 \xD8\xB3\xD9\x88\xD9\x86 \xD9\x85\xD8\xB8\xD9\x81\xD9\x91\xD8\xB1 \xD8\xB9\xD8\xA7\xD8\xB2\xD9\x85\xD8\x94  \xD9\xBE\xD9\x88\xD8\xB4\xDB\x81 \xD8\xA8\xD8\xB1\xDA\xAF\xD9\x86 \xDA\x86\xDA\xBE\xD9\x8F\xDB\x81 \xD8\xB3\xD9\x8F\xD9\x88\xD8\xA7\xDA\xBA \xDA\x86\xD8\xA7\xDA\xA9\xDA\xBE \xD8\xB3\xD9\x8F\xDB\x81 \xD8\xA7\xD9\x84\xD9\x85\xD8\xA7\xD8\xB3 \xD9\x82\xD9\x84\xD9\x85   \xD9\x84\xD9\x88\xD9\x90 \xDA\xA9\xD9\x94 \xDA\x88 \xD9\x86\xD9\x88\xD9\x90 \xD8\xB3\xD8\xB1\xD9\x95 \xD8\xB3\xD9\x88\xD9\x86\xD8\xAA\xD8\xB3 \xDA\xA9\xD9\x84   \xD9\xBE\xD8\xB1\xD9\x88\xD9\x90 \xD8\xA8\xDB\x86\xD8\xB1 \xD8\xA8\xDB\x8E\xDB\x8C\xDB\x81 \xD8\xA7\xD8\xB2 \xD8\xA8\xD8\xA7\xD9\x86\xD8\xA8\xD8\xB1\xD9\x90 \xDB\x81\xDB\x86\xD8\xAA  \xDB\x8C\xD9\x85\xD8\xA8\xD8\xB1\xD8\xB2\xD9\x84\xDB\x81\xD9\x90 \xD9\xB9\xD8\xA7\xD8\xB1\xD9\x89\xDB\xAA\xD9\x86 \xD9\x85\xD9\x86\xD8\xB2 \xD9\x86\xD8\xA7\xD8\xB1   \xD9\x88\xD8\xB2\xD9\x85\xD9\x84\xDB\x81\xD9\x90 \xDA\xA9\xDB\x85\xD8\xB3\xDB\x81\xD9\x95 \xDA\xA9\xD8\xAA\xDA\xBE \xDA\xA9\xD9\x94\xD8\xB1 \xD8\xA7\xD8\xB8\xDB\x81\xD8\xA7\xD8\xB1  \xDA\xA9\xDA\x86\xDA\xBE\xDB\x81\xD9\x90 \xD9\x85\xD9\x86\xD8\xB2\xD9\x95 \xD9\x88\xD9\x94\xD9\x86 \xD8\xB1\xD9\x88\xD9\x88\xD9\x8F\xD9\x85 \xD8\xA7\xDA\x86\xDA\xBE\xDB\x81\xD9\x90  \xDA\x86\xD8\xB4\xD9\x85\xD9\x88 \xDA\x98\xD9\x88\xD9\xBE\xD9\x8F\xD9\x85 \xDA\xA9\xD9\x94\xD9\x86\xDA\x88 \xD8\xA7\xD9\x86\xD8\xA8\xD8\xA7\xD8\xB1   \xD8\xAA\xD9\x85\xD8\xA7\xD8\xB4\xDB\x81\xD9\x90 \xDA\x86\xDA\xBE\xDB\x81\xD9\x90 \xD8\xAA\xDA\xAF\xD8\xA7\xDA\xBA";

const char* kTeststr_ks_Deva =
"\xE0\xA4\xA8\xE0\xA4\xAE\xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xA4\xE0\xA5\x87 \xE0\xA4\xB6\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA4\xA6\xE0\xA5\x87 \xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB5\xE0\xA4\xBF \xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xB6\xE0\xA5\x8D\xE0\xA4\xAE\xE0\xA4\xBF\xE0\xA4\xB0\xE0\xA4\xAA\xE0\xA5\x81\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xB5\xE0\xA4\xBE\xE0\xA4\xB8\xE0\xA4\xBF\xE0\xA4\xA8\xE0\xA4\xBF \xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xB5\xE0\xA4\xBE\xE0\xA4\xAE\xE0\xA4\xB9\xE0\xA4\xAE \xE0\xA4\xAA\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xA5\xE0\xA4\xAF\xE0\xA5\x87 \xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB5\xE0\xA4\xBF \xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\xA6\xE0\xA5\x8D\xE0\xA4\xAF \xE0\xA4\xA6\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA4\xAE \xE0\xA4\x9A \xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB9\xE0\xA4\xBF \xE0\xA4\xAE\xE0\xA5\x87 \xE0\xA4\x95\xE0\xA5\x89\xE0\xA4\xB6\xE0\xA5\x81\xE0\xA4\xB0 \xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\x96\xE0\xA5\x92\xE0\xA4\xA8\xE0\xA5\x81\xE0\xA4\x95 \xE0\xA4\xB8\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA4\xBF\xE0\xA4\xB5\xE0\xA5\x92\xE0\xA4\xAF \xE0\xA4\x96\xE0\xA5\x8A\xE0\xA4\xA4\xE0\xA5\x92 \xE0\xA4\x86\xE0\xA4\xB8\xE0\xA4\xBE\xE0\xA4\xA8 \xE0\xA4\xA4\xE0\xA4\xB0\xE0\xA5\x80\xE0\xA4\x95\xE0\xA5\x92 \xE0\xA4\x9B\xE0\xA5\x81 \xE0\xA4\xAF\xE0\xA4\xBF \xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB5\xE0\xA4\xA8\xE0\xA4\xBE\xE0\xA4\x97\xE0\xA4\xB0\xE0\xA5\x80 \xE0\xA4\x9F\xE0\xA4\xBE\xE0\xA4\x87\xE0\xA4\xAA\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\x87\xE0\xA4\x9F\xE0\xA4\xB0 \xE0\xA4\x87\xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xA4\xE0\xA4\xBF\xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xB2 \xE0\xA4\x95\xE0\xA4\xB0\xE0\xA5\x81\xE0\xA4\xA8. \xE0\xA4\x85\xE0\xA4\xA5 \xE0\xA4\xAE\xE0\xA4\x82\xE0\xA4\x9C\xE0\xA4\xBC \xE0\xA4\x9B\xE0\xA4\xBF \xE0\xA4\x95\xE0\xA5\x89\xE0\xA4\xB6\xE0\xA5\x81\xE0\xA4\xB0 \xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\x96\xE0\xA5\x92\xE0\xA4\xA8\xE0\xA5\x92\xE0\xA4\x9A\xE0\xA4\xBF \xE0\xA4\xB8\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA5\x86\xE0\xA4\xAF \xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xAF\xE0\xA4\xBF. \xE0\xA4\x85\xE0\xA4\xAE\xE0\xA4\xBF \xE0\xA4\x85\xE0\xA4\xB2\xE0\xA4\xBE\xE0\xA4\xB5\xE0\xA5\x92 \xE0\xA4\xB9\xE0\xA5\x86\xE0\xA4\x95\xE0\xA4\xBF\xE0\xA4\xB5 \xE0\xA4\xA4\xE0\xA5\x8A\xE0\xA4\xB9\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA5\x8D \xE0\xA4\xAF\xE0\xA4\xBF\xE0\xA4\xAE\xE0\xA5\x92 \xE0\xA4\xAF\xE0\xA5\x82\xE0\xA4\xA8\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA5\x8B\xE0\xA4\xA1 \xE0\xA4\x8F\xE0\xA4\xA1\xE0\xA4\xBF\xE0\xA4\x9F\xE0\xA4\xB0 \xE0\xA4\xA4\xE0\xA4\xBF \xE0\xA4\xB5\xE0\xA4\xB0\xE0\xA4\xA4\xE0\xA5\x89\xE0\xA4\xB5\xE0\xA4\xBF\xE0\xA4\xA5 \xE0\xA4\xAE\xE0\xA4\x97\xE0\xA4\xB0 \xE0\xA4\x95\xE0\xA5\x89\xE0\xA4\xB6\xE0\xA4\xBF\xE0\xA4\xB0\xE0\xA4\xBF \xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xAF\xE0\xA4\xBF \xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\x96\xE0\xA5\x92\xE0\xA4\xA8\xE0\xA4\xB8 \xE0\xA4\x97\xE0\xA4\x9B\xE0\xA4\xBC\xE0\xA4\xBF \xE0\xA4\xB9\xE0\xA4\xA8\xE0\xA4\xBE \xE0\xA4\xA6\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA4\xA5: \xE0\xA4\x85\xE0\xA4\x95\xE0\xA5\x8D\xE0\xA4\xB7\xE0\xA4\xB0\xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xB2\xE0\xA4\xBE\xE0\xA4\x9B\xE0\xA5\x81 \xE0\xA4\x85\xE0\xA4\x96 \xE0\xA4\xAE\xE0\xA5\x81\xE0\xA4\xAB\xE0\xA4\xBC\xE0\xA5\x8D\xE0\xA4\xA4 \xE0\xA4\xA4\xE0\xA5\x92 \xE0\xA4\xB8\xE0\xA5\x85\xE0\xA4\xB9\xE0\xA5\x85\xE0\xA4\xB2 \xE0\xA4\xB8\xE0\xA5\x8B\xE0\xA4\xAB\xE0\xA5\x8D\xE0\xA4\x9F\xE0\xA4\xB5\xE0\xA5\x87\xE0\xA4\xB0 \xE0\xA4\xAF\xE0\xA5\x86\xE0\xA4\xAE\xE0\xA4\xBF \xE0\xA4\xB8\xE0\xA5\x92\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA5\x8D \xE0\xA4\xAF\xE0\xA5\x81\xE0\xA4\xA8\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA5\x8B\xE0\xA4\xA1 \xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB5\xE0\xA4\xA8\xE0\xA4\xBE\xE0\xA4\x97\xE0\xA4\xB0\xE0\xA5\x80 \xE0\xA4\xAE\xE0\xA4\x82\xE0\xA4\x9C\xE0\xA4\xBC ITRANS scheme \xE0\xA4\xB8\xE0\xA5\x92\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA5\x8D \xE0\xA4\x9B\xE0\xA5\x81 \xE0\xA4\xAF\xE0\xA4\xBF\xE0\xA4\xB5\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\x96\xE0\xA5\x92\xE0\xA4\xA8\xE0\xA5\x92. \xE0\xA4\xB5\xE0\xA5\x81\xE0\xA4\x9B\xE0\xA4\xBF\xE0\xA4\xB5: \xE0\xA4\xB8\xE0\xA4\xB9\xE0\xA4\xBE\xE0\xA4\xAF\xE0\xA4\xA4\xE0\xA4\xBE. \xE0\xA4\x85\xE0\xA4\xA5 \xE0\xA4\xB8\xE0\xA5\x92\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA5\x8D \xE0\xA4\x9C\xE0\xA5\x81\xE0\xA4\xA1\xE0\xA4\xBF\xE0\xA4\xA5 \xE0\xA4\x9C\xE0\xA4\xBE\xE0\xA4\xB2\xE0\xA4\xAA\xE0\xA5\x83\xE0\xA4\xB7\xE0\xA5\x8D\xE0\xA4\xA0 (\xE0\xA4\xB5\xE0\xA5\x87\xE0\xA4\xAC\xE0\xA4\xAA\xE0\xA5\x87\xE0\xA4\x9C) (\xE0\xA4\xB8\xE0\xA5\x89\xE0\xA4\xB0\xE0\xA5\x80 \xE0\xA4\x85\xE0\xA4\x81\xE0\xA4\x97\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA5\x80\xE0\xA4\x9C\xE0\xA4\xBC\xE0\xA5\x80 \xE0\xA4\xAA\xE0\xA5\x89\xE0\xA4\xA0\xE0\xA5\x8D\xE0\xA4\xAF)";
const char* kTeststr_ku_Arab = " \xD8\xA8\xDB\x86 \xD8\xA8\xD9\x87 \xDA\x95\xDB\x8E\xD9\x88\xD9\x87 \xD8\xA8\xD8\xB1\xD8\xAF\xD9\x86\xDB\x8C \xD9\x86\xD8\xA7\xD9\x85\xD9\x87 \xDB\x8C \xDA\xA9\xD9\x87 \xD8\xAF\xDB\x8E\xD8\xAA\xD9\x86 \xDA\x95\xD8\xA7\xD8\xB3\xD8\xAA\xD9\x87 \xD9\x88\xD8\xAE\xDB\x86 \xDA\x95\xD9\x87 \xD9\x88\xD8\xA7\xD9\x86 \xD8\xA8\xDA\xA9\xD9\x87 \xD9\x86\xD8\xA7\xD9\x85\xD9\x87 \xDA\xA9\xD8\xA7\xD9\x86\xDB\x8C \xDA\xAF \xD9\x85\xD8\xA7\xDB\x8C\xD9\x84 \xD8\xA8\xDB\x86 \xD8\xAD\xD8\xB3\xD8\xA7\xD8\xA8\xDB\x8C \xD9\xBE\xDB\x86\xD8\xB3\xD8\xAA\xDB\x8E\xDA\xA9\xDB\x8C \xD8\xAA\xD8\xB1 \xD9\x87\xDB\x8E\xD9\x86\xD8\xA7\xD9\x86\xDB\x8C \xD9\xBE\xD9\x87 \xDB\x8C\xD9\x88\xD9\x87 \xD9\x86\xD8\xAF\xDA\xA9\xD8\xA7\xD8\xB1\xD9\x87 \xDA\xA9\xD8\xA7\xD9\x86 \xD9\x84\xD9\x87";
const char* kTeststr_ku_Latn = " be zmaneki ter le inglis werdegeretewe em srvise heshta le cor beta daye wate hest a taqi dekrete u bashtr dekret tewawwzmanekan wernegrawnetewe u ne hemu laperakn ke eme pshtiwan dekayn be teaweti wergerawete nermwalley wergeran teksti new wene nasnatewe";
const char* kTeststr_ky_Arab = " \xD8\xAC\xD8\xA7\xD9\x86\xD8\xA7 \xD8\xA7\xD9\x86\xD9\x89 \xD8\xAA\xD8\xA7\xD9\x86\xDB\x87\xDB\x87 \xDB\x87\xD9\x84\xDB\x87\xD8\xAA\xDB\x87\xD9\x86 \xD8\xAA\xD8\xA7\xD9\x86\xDB\x87\xDB\x87 \xD9\x82\xD9\x89\xD8\xB1\xD8\xB9\xD9\x89\xD8\xB2\xD8\xAF\xD9\x89 \xD8\xA8\xD8\xA6\xD9\x84\xDB\x89\xDB\x89 \xD8\xAF\xDB\x95\xDA\xAF\xDB\x95\xD9\x86\xD8\xAF\xD9\x89\xD9\x83 \xD8\xA7\xDA\x86\xD9\x89\xD9\x82 \xD8\xA7\xD9\x8A\xD8\xAA\xD8\xB3\xD8\xA7\xD9\x82 \xD9\x85\xD8\xA7\xD9\x86\xD8\xA7\xD8\xB3\xD8\xAA\xD9\x89 \xD8\xAA\xD8\xA7\xD8\xA7\xD9\x86\xD9\x89\xD8\xB9\xD8\xA7\xD9\x86\xD8\xAF\xD9\x89\xD9\x82 \xDB\x85\xD8\xB2\xDB\x89\xDA\xAD\xD8\xAF\xDB\x89 \xD8\xAA\xD8\xA7\xD8\xA7\xD9\x86\xD9\x89\xD8\xB9\xD8\xA7\xD9\x86\xD8\xAF\xD9\x89\xD9\x82 \xD8\xA8\xDB\x89\xDA\xAF\xDB\x89\xD9\x86 \xD8\xAA\xDB\x95\xD9\x85\xD8\xA7 \xD8\xAC\xDB\x89\xD9\x83\xD8\xAA\xDB\x85\xD9\x85\xDB\x85 \xD9\x82 \xD9\x89 \xD8\xB1\xD8\xB9 \xD9\x89 \xD8\xB2 \xD8\xAA \xD9\x89 \xD9\x84 \xD9\x89";
const char* kTeststr_ky_Cyrl = " \xD0\xB0\xD0\xB3\xD0\xB0\xD0\xB9 \xD1\x8D\xD0\xBB\xD0\xB5 \xD0\xBE\xD0\xB1\xD0\xBE\xD0\xBB\xD1\x83 \xD0\xBC\xD0\xB5\xD0\xBD \xD1\x81\xD0\xB0\xD0\xB4\xD1\x8B\xD0\xB1\xD0\xB0\xD0\xBA\xD0\xB0\xD1\x81 \xD0\xB0\xD0\xB3\xD0\xB0\xD0\xBD\xD1\x8B\xD0\xBD \xD3\xA9\xD0\xB7\xD2\xAF \xD0\xBC\xD0\xB5\xD0\xBD\xD0\xB5\xD0\xBD \xD1\x8D\xD0\xBC\xD0\xB5\xD1\x81 \xD1\x8D\xD0\xBC\xD0\xB3\xD0\xB5\xD0\xBA\xD1\x82\xD0\xB5\xD1\x80\xD0\xB8 \xD0\xBC\xD0\xB5\xD0\xBD\xD0\xB5\xD0\xBD \xD1\x82\xD0\xB0\xD0\xB0\xD0\xBD\xD1\x8B\xD1\x88\xD1\x82\xD1\x8B\xD0\xBC \xD0\xB6\xD1\x8B\xD0\xBB\xD0\xB4\xD0\xB0\xD1\x80\xD1\x8B \xD1\x82\xD0\xB0\xD1\x88\xD0\xBA\xD0\xB5\xD0\xBD\xD0\xB4\xD0\xB5 \xD3\xA9\xD0\xB7\xD0\xB1\xD0\xB5\xD0\xBA\xD1\x81\xD1\x82\xD0\xB0\xD0\xBD \xD0\xB8\xD0\xBB\xD0\xB8\xD0\xBC\xD0\xB4\xD0\xB5\xD1\x80 \xD0\xB0\xD0\xBA\xD0\xB0\xD0\xB4\xD0\xB5\xD0\xBC\xD0\xB8\xD1\x8F\xD1\x81\xD1\x8B\xD0\xBD\xD1\x8B\xD0\xBD \xD0\xB1\xD0\xB0\xD1\x8F\xD0\xBD\xD1\x8B";
const char* kTeststr_la_Latn = " a deo qui enim nocendi causa mentiri solet si iam consulendi causa mentiatur multum profecit sed aliud est quod per se ipsum laudabile proponitur aliud quod in deterioris comparatione praeponitur aliter enim gratulamur cum sanus est homo aliter cum melius";
const char* kTeststr_lb_Latn = " a gewerkschaften och hei gefuerdert dir dammen an dir h\xC3\xA4re vun de gewerkschaften denkt un d\xC3\xA9i aarm wann der \xC3\xA4\x65r fuerderunge formul\xC3\xA9iert d sechst cong\xC3\xA9s woch an aarbechtsz\xC3\xA4itverkierzung h\xC3\xABllefen hinnen net d unhiewe vun de steigerungss\xC3\xA4z bei de";
const char* kTeststr_lg_Latn = " abaana ba bani lukaaga mu ana mu babiri abaana ba bebayi lukaaga mu abiri mu basatu abaana ba azugaadi lukumi mu ebikumi bibiri mu abiri mu babiri abaana ba adonikamu lukaaga mu nltaaga mu mukaaga abaana ba biguvaayi enkumi bbiri mu ataano mu mukaaga";
const char* kTeststr_lif_Limb = "\xE1\xA4\x81\xE1\xA4\xA1\xE1\xA4\x96\xE1\xA4\xA0\xE1\xA4\xB3 \xE1\xA4\x95\xE1\xA4\xA0\xE1\xA4\xB0\xE1\xA4\x8C\xE1\xA4\xA2\xE1\xA4\xB1 \xE1\xA4\x86\xE1\xA4\xA2\xE1\xA4\xB6\xE1\xA4\x97\xE1\xA4\xA2\xE1\xA4\xB1\xE1\xA4\x96\xE1\xA4\xA7 \xE1\xA4\x9B\xE1\xA4\xA5\xE1\xA4\x8E\xE1\xA4\xA2\xE1\xA4\xB1\xE1\xA4\x83\xE1\xA4\xA7\xE1\xA4\xB4 \xE1\xA4\x80\xE1\xA4\xA1\xE1\xA4\x94\xE1\xA4\xA0\xE1\xA4\xB4\xE1\xA4\x9B\xE1\xA4\xA1\xE1\xA4\xB1 \xE1\xA4\x86\xE1\xA4\xA7\xE1\xA4\xB6\xE1\xA4\x88\xE1\xA4\xB1\xE1\xA4\x97\xE1\xA4\xA7 \xE1\xA4\x81\xE1\xA4\xA2\xE1\xA4\x94\xE1\xA4\xA1\xE1\xA4\xB1\xE1\xA4\x85\xE1\xA4\xA5 \xE1\xA4\x8F\xE1\xA4\xA0\xE1\xA4\x88\xE1\xA4\xA1\xE1\xA4\x96\xE1\xA4\xA1 \xE1\xA4\x8B\xE1\xA4\xB1\xE1\xA4\x92\xE1\xA4\xA3 \xE1\xA5\x88\xE1\xA5\x86\xE1\xA5\x86\xE1\xA5\x89 \xE1\xA4\x92\xE1\xA4\xA0 \xE1\xA4\x88\xE1\xA4\x8F\xE1\xA4\x98\xE1\xA4\x96\xE1\xA4\xA1 \xE1\xA4\x97\xE1\xA4\xA0\xE1\xA4\x8F\xE1\xA4\xA2\xE1\xA4\x80\xE1\xA4\xA0\xE1\xA4\xB1 \xE1\xA4\x81\xE1\xA4\xB9\xE1\xA4\x8F\xE1\xA4\xA0 \xE1\xA4\x8B\xE1\xA4\xB1\xE1\xA4\x92\xE1\xA4\xA3 \xE1\xA4\x81\xE1\xA4\xA0\xE1\xA4\xB0 \xE1\xA4\x8F\xE1\xA4\xA0\xE1\xA4\xBA\xE1\xA4\xB3\xE1\xA4\x8B\xE1\xA4\xA2 \xE1\xA4\x95\xE1\xA4\xA2\xE1\xA4\x96\xE1\xA4\xA2\xE1\xA4\x92\xE1\xA4\xA0 \xE1\xA4\x80\xE1\xA4\xA1\xE1\xA4\x94\xE1\xA4\xA0\xE1\xA4\xB4\xE1\xA4\x9B\xE1\xA4\xA1\xE1\xA4\xB1 \xE1\xA4\x8B\xE1\xA4\xB1\xE1\xA4\x83\xE1\xA4\xA1\xE1\xA4\xB5\xE1\xA4\x9B\xE1\xA4\xA1\xE1\xA4\xB1 \xE1\xA4\x8C\xE1\xA4\xA1\xE1\xA4\xB6\xE1\xA4\x92\xE1\xA4\xA3\xE1\xA4\xB4 \xE1\xA4\x82\xE1\xA4\xA0\xE1\xA4\x83\xE1\xA4\xB4 \xE1\xA4\x9B\xE1\xA4\xA1\xE1\xA4\x9B\xE1\xA4\xA3\xE1\xA4\xBA\xE1\xA4\xB0\xE1\xA4\x97\xE1\xA4\xA0 \xE1\xA5\x87\xE1\xA5\x8D \xE1\xA4\x82\xE1\xA4\xA7\xE1\xA4\xB4 \xE1\xA4\x80\xE1\xA4\xA1\xE1\xA4\x9B\xE1\xA4\xA1\xE1\xA4\xB0 \xE1\xA5\x87 \xE1\xA4\x88\xE1\xA4\x8F\xE1\xA4\x98\xE1\xA4\x96\xE1\xA4\xA1 \xE1\xA5\x88\xE1\xA5\x86\xE1\xA5\x86\xE1\xA5\x8A \xE1\xA4\x80\xE1\xA4\xA5 \xE1\xA4\x8F\xE1\xA4\xA0\xE1\xA4\x9B\xE1\xA4\xA2\xE1\xA4\xB5 \xE1\xA4\x86\xE1\xA4\xA5\xE1\xA4\xBA\xE1\xA4\xB0\xE1\xA4\x94\xE1\xA4\xA0 \xE1\xA4\x8C\xE1\xA4\xA1\xE1\xA4\xB6\xE1\xA4\x92\xE1\xA4\xA3 \xE1\xA4\x8B\xE1\xA4\xB1\xE1\xA4\x83\xE1\xA4\xA0\xE1\xA4\xB6\xE1\xA4\x9B\xE1\xA4\xA1\xE1\xA4\xB1\xE1\xA4\x97 \xE1\xA4\x90\xE1\xA4\xB3\xE1\xA4\x90\xE1\xA4\xA0 \xE1\xA4\x80\xE1\xA4\xA1\xE1\xA4\xB1\xE1\xA4\x84\xE1\xA4\xB1 \xE1\xA4\x98\xE1\xA4\xA0\xE1\xA4\xB9";
const char* kTeststr_ln_Latn = " abakisamaki ndenge esengeli moyebami abongisamaki solo mpenza kombo ya moyebami elonguamaki kombo ya bayebami elonguamaki kombo eleki molayi po na esika epesameli limbisa esika ya kotia ba kombo esuki boye esengeli olimbola ndako na yo ya mikanda kombo";
const char* kTeststr_lo_Laoo = " \xE0\xBA\x81\xE0\xBA\xAB\xE0\xBA\xB2\xE0\xBA\x97\xE0\xBA\xBB\xE0\xBB\x88\xE0\xBA\xA7\xE0\xBA\x97\xE0\xBA\xB1\xE0\xBA\x87\xE0\xBB\x80\xE0\xBA\xA7\xE0\xBA\xB1\xE0\xBA\x9A \xE0\xBB\x81\xE0\xBA\xA5\xE0\xBA\xB0\xE0\xBB\x83\xE0\xBA\x99\xE0\xBB\x80\xE0\xBA\xA7\xE0\xBA\xB1\xE0\xBA\x9A\xE0\xBB\x84\xE0\xBA\xAE\xE0\xBB\x89\xE0\xBA\xAA\xE0\xBA\xB2\xE0\xBA\x8D \xE0\xBA\x97\xE0\xBA\xB3\xE0\xBA\xAD\xE0\xBA\xB4\xE0\xBA\x94\xE0\xBB\x83\xE0\xBA\xAB\xE0\xBB\x89\xE0\xBA\x97\xE0\xBA\xB3\xE0\xBA\x81\xE0\xBA\xB2\xE0\xBA\x99\xE0\xBA\x8A\xE0\xBA\xAD\xE0\xBA\x81\xE0\xBA\xAB\xE0\xBA\xB2\xE0\xBA\x81\xE0\xBB\x88\xE0\xBA\xAD\xE0\xBA\x99 \xE0\xBA\x88\xE0\xBA\xB2\xE0\xBA\x81\xE0\xBA\x99\xE0\xBA\xB1\xE0\xBB\x89\xE0\xBA\x99 \xE0\xBB\x83\xE0\xBA\xAB\xE0\xBB\x89\xE0\xBA\x81\xE0\xBA\xBB\xE0\xBA\x94\xE0\xBA\x9B\xE0\xBA\xB8\xE0\xBB\x88\xE0\xBA\xA1\xE0\xBB\x80\xE0\xBA\xA1\xE0\xBA\x99\xE0\xBA\xB9 \xE0\xBB\x83\xE0\xBA\x99\xE0\xBB\x9C\xE0\xBB\x89\xE0\xBA\xB2\xE0\xBA\x9C\xE0\xBA\xBB\xE0\xBA\x99\xE0\xBB\x84\xE0\xBA\x94\xE0\xBB\x89";
const char* kTeststr_lt_Latn = " a i\xC5\xA1sijungia mano id\xC4\x97ja d\xC4\x97l geriausio laiko po pastar\xC5\xB3j\xC5\xB3 savo santyki\xC5\xB3 pasimokiau penki dalykai be kuri\xC5\xB3 negaliu gyventi mano miegamajame tu surasi ideali pora i\xC5\xA1silavinimas auk\xC5\xA1toji mokykla koled\xC5\xBE\x61s universitetas pagrindinis laipsnis metai";
const char* kTeststr_lv_Latn = " a gadsk\xC4\x81rt\xC4\x93j\xC4\x81 izp\xC4\x81rdo\xC5\xA1\x61na sl\xC4\x93po\xC5\xA1\x61na j\xC4\x81\xC5\x86i atlaide izmai\xC5\x86\x61s trafik\xC4\x81 kas saist\xC4\xABtas ar sezonas izp\xC4\x81rdo\xC5\xA1\x61nu speci\xC4\x81laj\xC4\x81m atlaid\xC4\x93m u c ir parastas un atsl\xC4\x93gv\xC4\x81rdi kas ir popul\xC4\x81ri noteiktos laika posmos \xC5\xA1\x61j\xC4\x81 laik\xC4\x81 sa\xC5\x86\x65ms liel\xC4\x81ku klik\xC5\xA1\xC4\xB7u";
const char* kTeststr_mfe_Latn = "Anz dir mwa, Sa bann delo ki to trouve la, kot fam prostitie asize, samem bann pep, bann lafoul dimoun, bann nasion ek bann langaz. Sa dis korn ki to finn trouve, ansam avek bebet la, zot pou ena laenn pou prostitie la; zot pou pran tou seki li ena e met li touni, zot pou manz so laser e bril seki reste dan dife. Parski Bondie finn met dan zot leker proze pou realiz so plan. Zot pou met zot dakor pou sed zot pouvwar bebet la ziska ki parol Bondie fini realize.";
const char* kTeststr_mg_Latn = " amporisihin i ianao mba hijery ny dika teksta ranofotsiny an ity lahatsoratra ity tsy ilaina ny op\xC3\xA9rateur efa karohina daholo ny teny rehetra nosoratanao ampiasao anaovana dokambarotra i google telugu datin ny takelaka fikarohana sary renitakelak i";
const char* kTeststr_mi_Latn = " haere ki te kainga o o haere ki te kainga o o haere ki te kainga o te rapunga ahua o haere ki te kainga o ka tangohia he ki to rapunga kaore au mohio te tikanga whakatiki o te ra he whakaharuru te pai rapunga a te rapunga ahua a e kainga o nga awhina o te";
const char* kTeststr_mk_Cyrl = " \xD0\xB3\xD0\xBB\xD0\xB0\xD1\x81\xD0\xBE\xD0\xB2\xD0\xB8\xD1\x82\xD0\xB5 \xD0\xBA\xD0\xBE\xD0\xB0\xD0\xBB\xD0\xB8\xD1\x86\xD0\xB8\xD1\x98\xD0\xB0\xD1\x82\xD0\xB0 \xD0\xBD\xD0\xB0 \xD0\xB2\xD0\xBC\xD1\x80\xD0\xBE \xD0\xB4\xD0\xBF\xD0\xBC\xD0\xBD\xD0\xB5 \xD0\xBA\xD0\xB0\xD0\xBA\xD0\xBE \xD0\xBF\xD0\xB0\xD1\x80\xD1\x82\xD0\xB8\xD1\x98\xD0\xB0 \xD1\x81\xD0\xBE \xD0\xBD\xD0\xB0\xD1\x98\xD0\xBC\xD0\xBD\xD0\xBE\xD0\xB3\xD1\x83 \xD0\xBE\xD1\x81\xD0\xB2\xD0\xBE\xD0\xB5\xD0\xBD\xD0\xB8 \xD0\xB3\xD0\xBB\xD0\xB0\xD1\x81\xD0\xBE\xD0\xB2\xD0\xB8 \xD1\x9C\xD0\xB5 \xD0\xB4\xD0\xBE\xD0\xB1\xD0\xB8\xD0\xB5 \xD0\xB5\xD0\xB2\xD1\x80\xD0\xB0 \xD0\xB0 \xD0\xBD\xD0\xB0 \xD1\x81\xD0\xBC\xD0\xB5\xD1\x82\xD0\xBA\xD0\xB0\xD1\x82\xD0\xB0 \xD0\xBD\xD0\xB0 \xD0\xBA\xD0\xBE\xD0\xB0\xD0\xBB\xD0\xB8\xD0\xB7\xD0\xB8\xD1\x98\xD0\xB0\xD1\x82\xD0\xB0 \xD0\xB7\xD0\xB0 \xD0\xBC\xD0\xB0\xD0\xBA\xD0\xB5\xD0\xB4\xD0\xBE\xD0\xBD\xD0\xB8\xD1\x98\xD0\xB0";
const char* kTeststr_ml_Mlym = " \xE0\xB4\x82 \xE0\xB4\x85\xE0\xB4\x99\xE0\xB5\x8D\xE0\xB4\x99\xE0\xB4\xA8\xE0\xB5\x86 \xE0\xB4\x9E\xE0\xB4\x99\xE0\xB5\x8D\xE0\xB4\x99\xE0\xB4\xB3\xE0\xB5\x8D \xE0\xB4\x85\xE0\xB4\xB5\xE0\xB4\xB0\xE0\xB5\x81\xE0\xB4\x9F\xE0\xB5\x86 \xE0\xB4\xAE\xE0\xB5\x81\xE0\xB4\xAE\xE0\xB5\x8D\xE0\xB4\xAA\xE0\xB4\xBF\xE0\xB4\xB2\xE0\xB5\x8D \xE0\xB4\xA8\xE0\xB4\xBF\xE0\xB4\xA8\xE0\xB5\x8D\xE0\xB4\xA8\xE0\xB5\x81 \xE0\xB4\x94\xE0\xB4\x9F\xE0\xB5\x81\xE0\xB4\x82 \xE0\xB4\x89\xE0\xB4\x9F\xE0\xB4\xA8\xE0\xB5\x86 \xE0\xB4\xA8\xE0\xB4\xBF\xE0\xB4\x99\xE0\xB5\x8D\xE0\xB4\x99\xE0\xB4\xB3\xE0\xB5\x8D \xE0\xB4\xAA\xE0\xB4\xA4\xE0\xB4\xBF\xE0\xB4\xAF\xE0\xB4\xBF\xE0\xB4\xB0\xE0\xB4\xBF\xE0\xB4\xAA\xE0\xB5\x8D\xE0\xB4\xAA\xE0\xB4\xBF\xE0\xB4\xB2\xE0\xB5\x8D \xE0\xB4\xA8\xE0\xB4\xBF\xE0\xB4\xA8\xE0\xB5\x8D\xE0\xB4\xA8\xE0\xB5\x81 \xE0\xB4\x8E\xE0\xB4\xB4\xE0\xB5\x81\xE0\xB4\xA8\xE0\xB5\x8D\xE0\xB4\xA8\xE0\xB5\x87\xE0\xB4\xB1\xE0\xB5\x8D\xE0\xB4\xB1\xE0\xB5\x81";
const char* kTeststr_mn_Cyrl = " \xD0\xB0 \xD0\xB1\xD0\xBE\xD0\xBB\xD0\xBE\xD0\xB2\xD1\x81\xD1\x80\xD0\xBE\xD0\xBD\xD0\xB3\xD1\x83\xD0\xB9 \xD0\xB1\xD0\xBE\xD0\xBB\xD0\xB3\xD0\xBE\xD1\x85 \xD0\xBE\xD1\x80\xD0\xBE\xD0\xBD \xD0\xBD\xD1\x83\xD1\x82\xD0\xB3\xD0\xB8\xD0\xB9\xD0\xBD \xD0\xB0\xD0\xB6\xD0\xB8\xD0\xBB \xD2\xAF\xD0\xB9\xD0\xBB\xD1\x81\xD0\xB8\xD0\xB9\xD0\xB3 \xD1\x83\xD1\x8F\xD0\xBB\xD0\xB4\xD1\x83\xD1\x83\xD0\xBB\xD0\xB6 \xD0\xB7\xD0\xBE\xD1\x85\xD0\xB8\xD1\x86\xD1\x83\xD1\x83\xD0\xBB\xD0\xB0\xD1\x85 \xD0\xB4\xD2\xAF\xD1\x80\xD1\x8D\xD0\xBC \xD0\xB6\xD1\x83\xD1\x80\xD0\xB0\xD0\xBC \xD0\xB1\xD0\xBE\xD0\xBB\xD0\xBE\xD0\xB2\xD1\x81\xD1\x80\xD1\x83\xD1\x83\xD0\xBB\xD0\xB0\xD1\x85 \xD0\xBE\xD1\x80\xD0\xBE\xD0\xBD \xD0\xBD\xD1\x83\xD1\x82\xD0\xB3\xD0\xB8\xD0\xB9\xD0\xBD \xD3\xA9\xD0\xBC\xD1\x87 \xD1\x85\xD3\xA9\xD1\x80\xD3\xA9\xD0\xBD\xD0\xB3\xD3\xA9 \xD1\x81\xD0\xB0\xD0\xBD\xD1\x85\xD2\xAF\xD2\xAF\xD0\xB3\xD0\xB8\xD0\xB9\xD0\xBD";
const char* kTeststr_mn_Mong = "\xE1\xA0\xA6\xE1\xA0\xAD\xE1\xA0\xA1\xE2\x80\xAF\xE1\xA0\xB5\xE1\xA0\xA2\xE1\xA0\xA8 \xE1\xA0\xB4\xE1\xA0\xA2\xE1\xA0\xA8\xE1\xA0\xAD\xE1\xA0\x8E\xE1\xA0\xA0 \xE1\xA0\xAC\xE1\xA0\xA6\xE1\xA0\xA8\xE1\xA0\xB3\xE1\xA0\xA1\xE1\xA0\xA2\xE2\x80\xAF\xE1\xA0\xB5\xE1\xA0\xA2 \xE1\xA0\xA2\xE1\xA0\xAF\xE1\xA0\xAD\xE1\xA0\xA0\xE1\xA0\xAC\xE1\xA0\xA3";
const char* kTeststr_mr_Deva = "\xE0\xA4\xB9\xE0\xA5\x88\xE0\xA4\xA6\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\xA6  \xE0\xA4\x89\xE0\xA4\x9A\xE0\xA5\x8D\xE0\xA4\x9A\xE0\xA4\xBE\xE0\xA4\xB0 \xE0\xA4\x90\xE0\xA4\x95\xE0\xA4\xBE (\xE0\xA4\xB8\xE0\xA4\xB9\xE0\xA4\xBE\xE0\xA4\xAF\xE0\xA5\x8D\xE0\xA4\xAF\xC2\xB7\xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xB9\xE0\xA4\xBF\xE0\xA4\xA4\xE0\xA5\x80)\xE0\xA4\xA4\xE0\xA5\x87\xE0\xA4\xB2\xE0\xA5\x81\xE0\xA4\x97\xE0\xA5\x82: \xE0\xB0\xB9\xE0\xB1\x88\xE0\xB0\xA6\xE0\xB0\xB0\xE0\xB0\xBE\xE0\xB0\xAC\xE0\xB0\xBE\xE0\xB0\xA6\xE0\xB1\x81 , \xE0\xA4\x89\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xA6\xE0\xA5\x82: \xD8\xAD\xDB\x8C\xD8\xAF\xD8\xB1 \xD8\xA2\xD8\xA8\xD8\xA7\xD8\xAF \xE0\xA4\xB9\xE0\xA5\x87 \xE0\xA4\xAD\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA4\xA4\xE0\xA4\xBE\xE0\xA4\xA4\xE0\xA5\x80\xE0\xA4\xB2 \xE0\xA4\x86\xE0\xA4\x82\xE0\xA4\xA7\xE0\xA5\x8D\xE0\xA4\xB0 \xE0\xA4\xAA\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\xA6\xE0\xA5\x87\xE0\xA4\xB6 \xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\x9C\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xBE\xE0\xA4\x9A\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xBE \xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\x9C\xE0\xA4\xA7\xE0\xA4\xBE\xE0\xA4\xA8\xE0\xA5\x80\xE0\xA4\x9A\xE0\xA5\x87 \xE0\xA4\xB6\xE0\xA4\xB9\xE0\xA4\xB0 \xE0\xA4\x86\xE0\xA4\xB9\xE0\xA5\x87. \xE0\xA4\xB9\xE0\xA5\x88\xE0\xA4\xA6\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\xA6\xE0\xA4\x9A\xE0\xA5\x80 \xE0\xA4\xB2\xE0\xA5\x8B\xE0\xA4\x95\xE0\xA4\xB8\xE0\xA4\x82\xE0\xA4\x96\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xBE \xE0\xA5\xAD\xE0\xA5\xAD \xE0\xA4\xB2\xE0\xA4\xBE\xE0\xA4\x96 \xE0\xA5\xAA\xE0\xA5\xA6 \xE0\xA4\xB9\xE0\xA4\x9C\xE0\xA4\xBE\xE0\xA4\xB0 \xE0\xA5\xA9\xE0\xA5\xA9\xE0\xA5\xAA \xE0\xA4\x86\xE0\xA4\xB9\xE0\xA5\x87. \xE0\xA4\xAE\xE0\xA5\x8B\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xBE\xE0\xA4\x82\xE0\xA4\x9A\xE0\xA5\x87 \xE0\xA4\xB6\xE0\xA4\xB9\xE0\xA4\xB0 \xE0\xA4\x85\xE0\xA4\xB6\xE0\xA5\x80 \xE0\xA4\x8F\xE0\xA4\x95\xE0\xA5\x87\xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xB3\xE0\xA5\x80 \xE0\xA4\x93\xE0\xA4\xB3\xE0\xA4\x96 \xE0\xA4\x85\xE0\xA4\xB8\xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\xB2\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xBE \xE0\xA4\xAF\xE0\xA4\xBE \xE0\xA4\xB6\xE0\xA4\xB9\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xB2\xE0\xA4\xBE \xE0\xA4\x90\xE0\xA4\xA4\xE0\xA4\xBF\xE0\xA4\xB9\xE0\xA4\xBE\xE0\xA4\xB8\xE0\xA4\xBF\xE0\xA4\x95, \xE0\xA4\xB8\xE0\xA4\xBE\xE0\xA4\x82\xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\x95\xE0\xA5\x83\xE0\xA4\xA4\xE0\xA4\xBF\xE0\xA4\x95 \xE0\xA4\x86\xE0\xA4\xA3\xE0\xA4\xBF \xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xA5\xE0\xA4\xBE\xE0\xA4\xAA\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xB6\xE0\xA4\xBE\xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA5\x80\xE0\xA4\xAF \xE0\xA4\xB5\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA4\xB8\xE0\xA4\xBE \xE0\xA4\xB2\xE0\xA4\xBE\xE0\xA4\xAD\xE0\xA4\xB2\xE0\xA4\xBE \xE0\xA4\x86\xE0\xA4\xB9\xE0\xA5\x87. \xE0\xA5\xA7\xE0\xA5\xAF\xE0\xA5\xAF\xE0\xA5\xA6 \xE0\xA4\xA8\xE0\xA4\x82\xE0\xA4\xA4\xE0\xA4\xB0 \xE0\xA4\xB6\xE0\xA4\xBF\xE0\xA4\x95\xE0\xA5\x8D\xE0\xA4\xB7\xE0\xA4\xA3 \xE0\xA4\x86\xE0\xA4\xA3\xE0\xA4\xBF \xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xB9\xE0\xA4\xBF\xE0\xA4\xA4\xE0\xA5\x80 \xE0\xA4\xA4\xE0\xA4\x82\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\x9C\xE0\xA5\x8D\xE0\xA4\x9E\xE0\xA4\xBE\xE0\xA4\xA8 \xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xBE\xE0\xA4\x9A\xE0\xA4\xAA\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xA3\xE0\xA5\x87 \xE0\xA4\x94\xE0\xA4\xB7\xE0\xA4\xA7\xE0\xA4\xA8\xE0\xA4\xBF\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xAE\xE0\xA4\xBF\xE0\xA4\xA4\xE0\xA5\x80 \xE0\xA4\x86\xE0\xA4\xA3\xE0\xA4\xBF \xE0\xA4\x9C\xE0\xA5\x88\xE0\xA4\xB5\xE0\xA4\xA4\xE0\xA4\x82\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\x9C\xE0\xA5\x8D\xE0\xA4\x9E\xE0\xA4\xBE\xE0\xA4\xA8 \xE0\xA4\x95\xE0\xA5\x8D\xE0\xA4\xB7\xE0\xA5\x87\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xA4\xE0\xA5\x80\xE0\xA4\xB2 \xE0\xA4\x89\xE0\xA4\xA6\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA5\x8B\xE0\xA4\x97\xE0\xA4\xA7\xE0\xA4\x82\xE0\xA4\xA6\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xBE\xE0\xA4\x82\xE0\xA4\x9A\xE0\xA5\x80 \xE0\xA4\xB5\xE0\xA4\xBE\xE0\xA4\xA2 \xE0\xA4\xB6\xE0\xA4\xB9\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xA4 \xE0\xA4\x9D\xE0\xA4\xBE\xE0\xA4\xB2\xE0\xA5\x80. \xE0\xA4\xA6\xE0\xA4\x95\xE0\xA5\x8D\xE0\xA4\xB7\xE0\xA4\xBF\xE0\xA4\xA3 \xE0\xA4\xAE\xE0\xA4\xA7\xE0\xA5\x8D\xE0\xA4\xAF \xE0\xA4\xAD\xE0\xA4\xBE\xE0\xA4\xB0\xE0\xA4\xA4\xE0\xA4\xBE\xE0\xA4\xA4\xE0\xA5\x80\xE0\xA4\xB2 \xE0\xA4\xAA\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\x9F\xE0\xA4\xA8 \xE0\xA4\x86\xE0\xA4\xA3\xE0\xA4\xBF \xE0\xA4\xA4\xE0\xA5\x87\xE0\xA4\xB2\xE0\xA5\x81\xE0\xA4\x97\xE0\xA5\x82 \xE0\xA4\x9A\xE0\xA4\xBF\xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xB0\xE0\xA4\xAA\xE0\xA4\x9F\xE0\xA4\xA8\xE0\xA4\xBF\xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xAE\xE0\xA4\xBF\xE0\xA4\xA4\xE0\xA5\x80\xE0\xA4\x9A\xE0\xA5\x87 \xE0\xA4\xB9\xE0\xA5\x88\xE0\xA4\xA6\xE0\xA4\xB0\xE0\xA4\xBE\xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\xA6 \xE0\xA4\xB9\xE0\xA5\x87 \xE0\xA4\x95\xE0\xA5\x87\xE0\xA4\x82\xE0\xA4\xA6\xE0\xA5\x8D\xE0\xA4\xB0 \xE0\xA4\x86\xE0\xA4\xB9\xE0\xA5\x87";
//const char* kTeststr_ms_Latn = "daripada dirinya hirako shinji seorang pemuda merujuk diri mereka sebagai vizard shinji telah cuba untuk menyakinkan ichigo untuk menyertai kumpulan mereka mengatakan bahawa hanya dia sahaja yang mampu mengajar ichigo teknik untuk mengawal hollow";
// From 10% testing part of new lang=ms scrape
const char* kTeststr_ms_Latn = "pengampunan beramai-ramai supaya mereka pulang ke rumah masing-masing. Orang-orang besarnya enggan mengiktiraf sultan yang dilantik oleh Belanda sebagai Yang DiPertuan Selangor. Orang ramai pula tidak mahu menjalankan perniagaan bijih timah dengan Belanda, selagi raja yang berhak tidak ditabalkan. Perdagang yang lain dibekukan terus kerana untuk membalas jasa beliau yang membantu Belanda menentang Riau, Johor dan Selangor. Di antara tiga orang Sultan juga dipandang oleh rakyat sebagai seorang sultan yang paling gigih. 1 | 2 SULTAN Sebagai ganti Sultan Ibrahim ditabalkan Raja Muhammad iaitu Raja Muda. Walaupun baginda bukan anak isteri pertama bergelar Sultan Muhammad bersemayam di Kuala Selangor juga. Pentadbiran baginda yang lemah itu menyebabkan Kuala Selangor menjadi sarang ioleh Cina di Lukut tidak diambil tindakan, sedangkan baginda sendiri banyak berhutang kepada 1";

const char* kTeststr_ms_Latn2 = "bilik sebelah berkata julai pada pm ladymariah hmm sume ni terpulang kepada individu mungkin anda bernasib baik selama ini dalam membeli hp yang bagus deli berkata julai pada pm walaupun bukan bahsa baku tp tetap bahasa melayu kan perubahan boleh dibuat";
const char* kTeststr_mt_Latn = " ata ikteb messa\xC4\xA1\xC4\xA1 lil indirizzi differenti billi tag\xC4\xA7\xC5\xBCilhom u tag\xC4\xA7\x66\x61s il buttuna ikteb \xC5\xBCid numri tfittxijja tal kotba mur print home kotba minn pagni ghal pagna minn ghall ktieb ta a\xC4\x8B\xC4\x8B\x65ssa stieden habib iehor grazzi it tim tal gruppi google";
const char* kTeststr_my_Latn = " jyk ef oif gawgodcsifayvdrfhrnf bmawgrsm topf dsvj g mail tamumif avhvm atmif txjwgif yxrqhk avhvm efae m pwifavhvm ef ufkyfwdky help center odkyvmyg drsm ar avh dswjhar cgef rsm udkawdkifygw f tajzawgudk smedkifygw f jyd awmh g mail cool features rsm";
const char* kTeststr_my_Mymr = " \xE1\x80\x90\xE1\x80\x80\xE1\x80\xB9\xE1\x80\x80\xE1\x80\x9E\xE1\x80\xAF\xE1\x80\xAD\xE1\x80\x9C\xE1\x80\xB9 \xE1\x80\x99\xE1\x80\xB9\xE1\x80\x9F \xE1\x80\x95\xE1\x80\xB9\xE1\x80\x9B\xE1\x80\x94\xE1\x80\xB9 \xE1\x80\x9C\xE1\x80\xAC\xE1\x80\xB9\xE1\x80\x9B\xE1\x80\x95\xE1\x80\xAE\xE1\x80\xB8\xE1\x80\xB1\xE1\x80\x94\xE1\x80\xAC\xE1\x80\x80\xE1\x80\xB9 \xE1\x80\x94\xE1\x80\xB9\xE1\x80\x9F\xE1\x80\x85\xE1\x80\xB9 \xE1\x80\xA1\xE1\x80\x9B\xE1\x80\xB9\xE1\x80\x9D\xE1\x80\x9A\xE1\x80\xB9 \xE1\x80\xA6\xE1\x80\xB8\xE1\x80\x9E\xE1\x80\x94\xE1\x80\xB9 \xE1\x80\xB7\xE1\x80\x9E\xE1\x80\x8A\xE1\x80\xB9 \xE1\x80\x95\xE1\x80\x94\xE1\x80\xB9 \xE1\x80\xB8\xE1\x80\x90\xE1\x80\x94\xE1\x80\xB1\xE1\x80\xAC\xE1\x80\xB9 \xE1\x80\xA1\xE1\x80\x99\xE1\x80\xB9\xE1\x80\x9A\xE1\x80\xAF\xE1\x80\xAD\xE1\x80\xB8\xE1\x80\x9E\xE1\x80\xAC\xE1\x80\xB8 \xE1\x80\xB1\xE1\x80\x80\xE1\x80\xB9\xE1\x80\x9A\xE1\x80\xAC\xE1\x80\x84\xE1\x80\xB9 \xE1\x80\xB8";
const char* kTeststr_na_Latn = " arcol obabakaen riringa itorere ibibokiei ababaro min kuduwa airumena baoin tokin rowiowet itiket keram damadamit eigirow etoreiy row keitsito boney ibingo itsiw dorerin naoerodelaporte s nauruan dictionary a c a c d g h o p s t y aiquen ion eins aiquen";
const char* kTeststr_ne_Deva = "\xE0\xA4\x85\xE0\xA4\xB0\xE0\xA5\x82 \xE0\xA4\xA0\xE0\xA4\xBE\xE0\xA4\x8A\xE0\xA4\x81\xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\x9F\xE0\xA4\xAA\xE0\xA4\xA8\xE0\xA4\xBF \xE0\xA4\x96\xE0\xA5\x81\xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\x95\xE0\xA5\x8B \xE0\xA4\x9B \xE0\xA4\xAF\xE0\xA5\x8B \xE0\xA4\x96\xE0\xA4\xBE\xE0\xA4\xA4\xE0\xA4\xBE \xE0\xA4\x85\xE0\xA4\xB0 \xE0\xA4\x85\xE0\xA4\xB0\xE0\xA5\x82 \xE0\xA4\xA0\xE0\xA4\xBE\xE0\xA4\x8A\xE0\xA4\x81\xE0\xA4\xAC\xE0\xA4\xBE\xE0\xA4\x9F\xE0\xA4\xAA\xE0\xA4\xA8\xE0\xA4\xBF \xE0\xA4\x96\xE0\xA5\x81\xE0\xA4\xB2\xE0\xA5\x87\xE0\xA4\x95\xE0\xA5\x8B \xE0\xA4\x9B \xE0\xA4\xAF\xE0\xA5\x8B \xE0\xA4\x96\xE0\xA4\xBE\xE0\xA4\xA4\xE0\xA4\xBE \xE0\xA4\x85\xE0\xA4\xB0 \xE0\xA5\x82";
const char* kTeststr_nl_Latn = " a als volgt te werk om een configuratiebestand te maken sitemap gen py ebruik filters om de s op te geven die moeten worden toegevoegd of uitgesloten op basis van de opmaaktaal elke sitemap mag alleen de s bevatten voor een bepaalde opmaaktaal dit";
const char* kTeststr_nn_Latn = " a for verktylina til \xC3\xA5 hjelpa deg \xC3\xA5 n\xC3\xA5 oss merk at pagerank syninga ikkje automatisk kjem til \xC3\xA5 henta inn informasjon fr\xC3\xA5 sider med argument dvs fr\xC3\xA5 sider med eit i en dersom datamaskina di er plassert bak ein mellomtenar for vevsider kan det verka";
const char* kTeststr_no_Latn = " a er obligatorisk tidsforskyvning plassering av katalogs\xC3\xB8k planinformasjon loggfilbane gruppenavn kontoinformasjon passord domene gruppeinformasjon alle kampanjesporing alternativ bruker grupper oppgaveplanlegger oppgavehistorikk kontosammendrag antall";
const char* kTeststr_nr_Latn = "ikomiti elawulako yegatja  emhlanganweni walo ]imithetho mgomo ye anc ibekwa malunga wayo begodu ubudosiphambili kugandelela lokho okutjhiwo yi  lokha nayithi abantu ngibo  ";

const char* kTeststr_nso_Latn = "Bophara bja Asia ekaba 8.6% bja lefase goba 29.4% bja naga ya lefase (ntle le mawatle). Asia enale badudu bao bakabago dimillione millione t\xC5\xA1\x65 nne (4 billion) yeo e bago 60% ya badudi ba lefase ka bophara. A bapolelwa rena sefapanong mehleng ya Pontius Pilatus. A hlokofat\xC5\xA1wa, A bolokwa, A tsoga ka let\xC5\xA1\x61t\xC5\xA1i la boraro, ka mo mangwalo a bolelago ka gona, a rotogela magodimong, ";
const char* kTeststr_ny_Latn = "Boma ndi gawo la dziko lomwe linapangidwa ndi cholinga chothandiza ntchito yolamulira. Ku\xC5\xB5\x61lako kulikuunikabe mandita, Edipo nyima unalephera kugonjetsa ku\xC5\xB5\x61lako.";
const char* kTeststr_oc_Latn = "  Pasmens, la classificacion pus admesa uei (segon Juli Ronjat e P\xC3\xA8ire B\xC3\xA8\x63) agropa lei parlars deis Aups dins l'occitan vivaroaupenc e non dins lo dial\xC3\xA8\x63te proven\xC3\xA7\x61u.";
const char* kTeststr_om_Latn = " afaan katalaa bork bork bork hiikaa jira hin argamne gareen barbaadame hin argamne gargarsa qube en gar bayee jira garee walitti firooman gareewwan walitti firooman fuula web akka tartiiba qubeetiin agarsiisi akka tartiiba qubeetiin agarsiisaa jira akka";
const char* kTeststr_or_Orya = "\xE0\xAC\x85\xE0\xAC\x95\xE0\xAD\x8D\xE0\xAC\x9F\xE0\xAD\x8B\xE0\xAC\xAC\xE0\xAC\xB0 \xE0\xAC\xA1\xE0\xAC\xBF\xE0\xAC\xB8\xE0\xAD\x87\xE0\xAC\xAE\xE0\xAD\x8D\xE0\xAC\xAC\xE0\xAC\xB0";
const char* kTeststr_pa_Guru = " \xE0\xA8\x82 \xE0\xA8\xA6\xE0\xA8\xBF\xE0\xA8\xA8\xE0\xA8\xBE\xE0\xA8\x82 \xE0\xA8\xB5\xE0\xA8\xBF\xE0\xA8\x9A \xE0\xA8\xAD\xE0\xA8\xBE\xE0\xA8\x88 \xE0\xA8\xB8\xE0\xA8\xBE\xE0\xA8\xB9\xE0\xA8\xBF\xE0\xA8\xAC \xE0\xA8\xA6\xE0\xA9\x80 \xE0\xA8\xAC\xE0\xA9\x81\xE0\xA9\xB1\xE0\xA8\x9A\xE0\xA9\x9C \xE0\xA8\x97\xE0\xA9\x8B\xE0\xA8\xAC\xE0\xA8\xBF\xE0\xA9\xB0\xE0\xA8\xA6 \xE0\xA8\xB0\xE0\xA8\xBE\xE0\xA8\xAE \xE0\xA8\xA8\xE0\xA8\xBE\xE0\xA8\xB2 \xE0\xA8\x85\xE0\xA9\x9C\xE0\xA8\xAB\xE0\xA8\xB8 \xE0\xA8\x9A\xE0\xA9\xB1\xE0\xA8\xB2 \xE0\xA8\xB0\xE0\xA8\xB9\xE0\xA9\x80 \xE0\xA8\xB8\xE0\xA9\x80 \xE0\xA8\x97\xE0\xA9\x8B\xE0\xA8\xAC\xE0\xA8\xBF\xE0\xA9\xB0\xE0\xA8\xA6 \xE0\xA8\xB0\xE0\xA8\xBE\xE0\xA8\xAE \xE0\xA8\xA8\xE0\xA9\x87 \xE0\xA8\xAD\xE0\xA8\xBE\xE0\xA8\x88 \xE0\xA8\xB8\xE0\xA8\xBE\xE0\xA8\xB9\xE0\xA8\xBF\xE0\xA8\xAC \xE0\xA8\xA6\xE0\xA9\x80\xE0\xA8\x86\xE0\xA8\x82 \xE0\xA8\xAD\xE0\xA9\x88\xE0\xA8\xA3\xE0\xA8\xBE";
const char* kTeststr_pl_Latn = " a australii b\xC4\x99\x64zie widzia\xC5\x82 inne reklamy ni\xC5\xBC u\xC5\xBCytkownik z kanady kierowanie geograficzne sprawia \xC5\xBC\x65 reklamy s\xC4\x85 lepiej dopasowane do u\xC5\xBCytkownika twojej strony oznacza to tak\xC5\xBC\x65 \xC5\xBC\x65 mo\xC5\xBC\x65sz nie zobaczy\xC4\x87 wszystkich reklam kt\xC3\xB3re s\xC4\x85 wy\xC5\x9Bwietlane na";
const char* kTeststr_ps_Arab = " \xD8\xA7\xD8\xAA\xD9\x88 \xD9\x85\xD8\xB3\xD8\xAA\xD9\x82\xD9\x84 \xD8\xB1\xD9\x8A\xD8\xA7\xD8\xB3\xD8\xAA \xD8\xAC\xD9\x88\xDA\x93 \xD8\xB4\xD9\x88 \xD8\xA7\xD9\x88 \xD8\xAF \xD9\xBE\xD8\xAE\xD9\x88\xD8\xA7\xD9\x86\xD9\x8A \xD8\xA7\xD8\xAF\xD8\xA8\xD9\x8A \xD8\xA7\xD9\x86\xD8\xAC\xD9\x85\xD9\x86 \xDA\x85\xD8\xA7\xD9\x86\xDA\xAB\xDB\x90 \xD8\xAF\xD8\xAF\xDB\x90 \xD8\xB1\xD9\x8A\xD8\xA7\xD8\xB3\xD8\xAA \xD8\xAC\xD8\xB2 \xD8\xB4\xD9\x88\xDB\x8C \xD8\xA7\xD9\x88 \xD8\xAF\xD8\xAF\xDB\x90 \xD8\xA7\xD9\x86\xD8\xAC\xD9\x85\xD9\x86 \xD8\xAF \xDA\x98\xD8\xA8\xDB\x90 \xD9\x85\xD8\xAF\xD9\x8A\xD8\xB1\xD9\x8A\xD8\xAA \xD8\xAF \xD9\xBE\xDA\x9A\xD8\xAA\xD9\x88 \xD9\xBC\xD9\x88\xD9\x84\xD9\x86\xDB\x90 \xD9\xBE\xD9\x87 \xD9\x84\xD9\x88\xDB\x8C \xD9\x85\xD8\xAF\xD9\x8A\xD8\xB1\xD9\x8A\xD8\xAA \xD9\x88\xD8\xA7\xD9\x88\xDA\x9A\xD8\xAA \xD9\x84\xD9\x88\xDB\x8C \xD9\x85\xD8\xAF\xD9\x8A\xD8\xB1 \xD9\x8A\xDB\x90 \xD8\xAF";
const char* kTeststr_pt_Latn = " a abit prev\xC3\xAA que a entrada desses produtos estrangeiros no mercado t\xC3\xAAxtil e vestu\xC3\xA1rio do brasil possa reduzir os pre\xC3\xA7os em cerca de a partir de m\xC3\xA1 not\xC3\xAD\x63ia para os empres\xC3\xA1rios que ter\xC3\xA3o que lutar para garantir suas margens de lucro mas boa not\xC3\xAD\x63ia";
const char* kTeststr_qu_Latn = " is t ipanakunatapis rikuchinankupaq qanpa simiykipi noqaykoqpa uya jllanakunamanta kunan jamoq simikunaman qelqan tiyan watukuy qpa uyata qanpa llaqtaykipi llank anakuna simimanta yanapakuna simimanta mayqen llaqtallapis kay simimanta t ijray qpa qelqa";
const char* kTeststr_rm_Latn = " Cur ch\xE2\x80\x99il chantun Turitg ha d\xC3\xA0 il dretg da votar a las dunnas (1970) \xC3\xA8 ella vegnida elegida en il cussegl da vischnanca da Zumikon per la Partida liberaldemocratica svizra (PLD). Da 1974 enfin 1982 \xC3\xA8 ella stada presidenta da vischnanca da Zumikon. L\xE2\x80\x99onn 1979 \xC3\xA8 Elisabeth Kopp vegnida elegida en il Cussegl naziunal e reelegida quatter onns pli tard cun in resultat da sur 100 000 vuschs. L\xE2\x80\x99onn 1984 \xC3\xA8 ella daventada vicepresidenta da la PLD.";
const char* kTeststr_rn_Latn = " ishaka mu ndero y abana bawe ganira n abigisha nimba hari ingorane izo ari zo zose ushobora gusaba kubonana n umwigisha canke kuvugana nawe kuri terefone inyuma y uko babarungikira urutonde rw amanota i muhira mu bisanzwe amashure aratumira abavyeyi";
const char* kTeststr_ro_Latn = " a anun\xC5\xA3urilor re\xC5\xA3ine\xC5\xA3i nu pl\xC4\x83ti\xC5\xA3i pentru clicuri sau impresii ci numai atunci c\xC3\xA2nd pe site ul dvs survine o ac\xC5\xA3iune dorit\xC4\x83 site urile negative nu pot avea uri de destina\xC5\xA3ie da\xC5\xA3i instruc\xC5\xA3iuni societ\xC4\x83\xC5\xA3ii dvs bancare sau constructoare s\xC4\x83";
const char* kTeststr_ro_Cyrl = "\xD0\xBE\xD0\xBF\xD0\xB5\xD1\x80\xD0\xB0\xD1\x82\xD0\xB8\xD0\xB2\xD1\x8D \xD0\xB0 \xD0\xBE\xD1\x80\xD0\xB3\xD0\xB0\xD0\xBD\xD0\xB5\xD0\xBB\xD0\xBE\xD1\x80 \xD1\x88\xD0\xB8 \xD0\xB8\xD0\xBD\xD1\x81\xD1\x82\xD0\xB8\xD1\x82\xD1\x83\xD1\x86\xD0\xB8\xD0\xB8\xD0\xBB\xD0\xBE\xD1\x80 \xD0\xB5\xD0\xBA\xD0\xB7\xD0\xB5\xD0\xBA\xD1\x83\xD1\x82\xD0\xB8\xD0\xB2\xD0\xB5 \xD1\x88\xD0\xB8 \xD0\xB0 \xD0\xBE\xD1\x80\xD0\xB3\xD0\xB0\xD0\xBD\xD0\xB5\xD0\xBB\xD0\xBE\xD1\x80 \xD0\xB6\xD1\x83\xD0\xB4\xD0\xB8\xD1\x87\xD0\xB8\xD0\xB0\xD1\x80\xD0\xB5 \xD0\xB0\xD0\xBB\xD0\xB5 \xD0\xBF\xD1\x83\xD1\x82\xD0\xB5\xD1\x80\xD0\xB8\xD0\xB9 \xD0\xB4\xD0\xB5 \xD1\x81\xD1\x82\xD0\xB0\xD1\x82 \xD1\x84\xD0\xB8\xD0\xB5\xD0\xBA\xD1\x8D\xD1\x80\xD1\x83\xD0\xB9 \xD0\xBE\xD1\x80\xD0\xB3\xD0\xB0\xD0\xBD \xD0\xB0\xD0\xBB \xD0\xBF\xD1\x83\xD1\x82\xD0\xB5\xD1\x80\xD0\xB8\xD0\xB9 \xD0\xB4\xD0\xB5 \xD1\x81\xD1\x82\xD0\xB0\xD1\x82 \xD0\xB8 \xD1\x81\xD0\xB5";
const char* kTeststr_ru_Cyrl = " \xD0\xB0 \xD0\xBD\xD0\xB5\xD0\xBF\xD1\x80\xD0\xB0\xD0\xB2\xD0\xB8\xD0\xBB\xD1\x8C\xD0\xBD\xD1\x8B\xD0\xB9 \xD1\x84\xD0\xBE\xD1\x80\xD0\xBC\xD0\xB0\xD1\x82 \xD0\xB8\xD0\xB4\xD0\xB5\xD0\xBD\xD1\x82\xD0\xB8\xD1\x84\xD0\xB8\xD0\xBA\xD0\xB0\xD1\x82\xD0\xBE\xD1\x80\xD0\xB0 \xD0\xB4\xD0\xBD \xD0\xBD\xD0\xB0\xD0\xB7\xD0\xB0\xD0\xB4";
const char* kTeststr_rw_Latn = " dore ibyo ukeneye kumenya ukwo watubona ibibazo byinshi abandi babaza ububonero byibibina google onjela ho izina dyikyibina kyawe onjela ho yawe mulugo kulaho ibyandiko byawe shyilaho tegula yawe tulubaka tukongeraho iyanya mishya buliko tulambula";
const char* kTeststr_sa_Deva = " \xE0\xA4\x82 \xE0\xA4\x95 \xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xAE\xE0\xA4\xA3\xE0\xA4\xB8\xE0\xA5\x8D \xE0\xA4\xA4 \xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xAF \xE0\xA4\xAF \xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\x95\xE0\xA4\xBF \xE0\xA4\x99\xE0\xA5\x8D\xE0\xA4\x9A\xE0\xA5\x87\xE0\xA4\xB9 \xE0\xA4\x95\xE0\xA4\xB0\xE0\xA5\x8B \xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xAF\xE0\xA4\xAF \xE0\xA4\x82 \xE0\xA4\xA4 \xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xAE\xE0\xA4\xBE\xE0\xA4\xB2\xE0\xA5\x8D \xE0\xA4\xB2\xE0\xA5\x8B\xE0\xA4\x95\xE0\xA4\xBE \xE0\xA4\xA4\xE0\xA5\x8D\xE0\xA4\xAA\xE0\xA5\x81 \xE0\xA4\xA8\xE0\xA4\xB0\xE0\xA5\x88 \xE0\xA4\xA4\xE0\xA4\xBF \xE0\xA4\x85\xE0\xA4\xB8\xE0\xA5\x8D\xE0\xA4\xAE\xE0\xA5\x88 \xE0\xA4\xB2\xE0\xA5\x8B\xE0\xA4\x95\xE0\xA4\xBE \xE0\xA4\xAF \xE0\xA4\x95 \xE0\xA4\xB0\xE0\xA5\x8D\xE0\xA4\xAE\xE0\xA4\xA3 \xE0\xA4\x87 \xE0\xA4\xA4\xE0\xA4\xBF \xE0\xA4\xA8\xE0\xA5\x81 \xE0\xA4\x95\xE0\xA4\xBE\xE0\xA4\xAE";
const char* kTeststr_sa_Latn = " brahm\xC4\x81 tatraiv\xC4\x81ntaradh\xC4\xAByata tata\xE1\xB8\xA5 sa\xC5\x9Bi\xE1\xB9\xA3yo v\xC4\x81lm\xC4\xABkir munir vismayam \xC4\x81yayau tasya \xC5\x9Bi\xE1\xB9\xA3y\xC4\x81s tata\xE1\xB8\xA5 sarve jagu\xE1\xB8\xA5 \xC5\x9Blokam ima\xE1\xB9\x83 puna\xE1\xB8\xA5 muhur muhu\xE1\xB8\xA5 pr\xC4\xAByam\xC4\x81\xE1\xB9\x87\xC4\x81\xE1\xB8\xA5 pr\xC4\x81hu\xC5\x9B ca bh\xE1\xB9\x9B\xC5\x9B\x61vismit\xC4\x81\xE1\xB8\xA5 sam\xC4\x81k\xE1\xB9\xA3\x61rai\xC5\x9B caturbhir ya\xE1\xB8\xA5 p\xC4\x81\x64\x61ir g\xC4\xABto";
const char* kTeststr_sco_Latn = " a gless an geordie runciman ower a gless an tamson their man preached a hale hoor aboot the glorious memories o forty three an backsliders an profane persons like esau an aboot jeroboam the son o nebat that gaed stravagin to anither kirk an made aa israel";
const char* kTeststr_sd_Arab = " \xD8\xA7\xD8\xB6\xD8\xA7\xD9\x81\xD9\x88 \xD9\xBF\xD9\x8A \xD9\xBF\xD9\x8A\xD9\x88 \xD9\xBE\xD8\xB1 \xD8\xA7\xD9\x87\xD8\xA7 \xD8\xAE\xD8\xA8\xD8\xB1 \xD8\xB9\xD8\xAB\xD9\x85\xD8\xA7\xD9\x86 \xDA\xA9\xD9\x8A \xD8\xA8\xD8\xB9\xD8\xAF \xD9\xBE\xD9\x8A\xD8\xA6\xD9\x8A \xD8\xAA\xD9\x87 \xD8\xB3\xDA\xAF\xD8\xB1\xD9\x8A\xD9\xBD \xDA\x87\xDA\xAA\xD9\x8A\xD9\x86\xD8\xAF\xDA\x99 \xD9\x85\xD8\xB3\xD9\x84\xD9\x85\xD8\xA7\xD9\x86 \xD9\x86\xD9\x87 \xD9\x87\xD9\x88 \xD8\xA8\xD9\x84\xDA\xAA \xD9\x87\xD9\x86\xD8\xAF\xD9\x88 \xD9\x87\xD9\x88 \xD8\xAF\xDA\xAA\xD8\xA7\xD9\x86 \xD8\xAA\xD9\x8A \xD9\xBE\xD9\x87\xDA\x86\xD9\x8A \xD8\xB9\xD8\xAB\xD9\x85\xD8\xA7\xD9\x86 \xDA\xAA\xD8\xB3\xD8\xA8\xD8\xAA \xDA\xA9\xD9\x88\xD9\x84\xD9\x8A \xDA\xAF\xD8\xB1\xD8\xA7\xD9\x87\xDA\xAA\xD9\x86 \xD8\xAC\xD9\x8A \xD8\xB3\xD9\x8A\xD8\xB1\xD8\xA8 \xD9\x84\xD8\xA7\xD9\x87\xDA\xBB \xD8\xB4\xD8\xB1\xD9\x88\xD8\xB9 \xDA\xAA\xD8\xA6\xD9\x8A \xD9\xBE\xD8\xB1";
const char* kTeststr_sg_Latn = " at\xC3\xA2\x61 na \xC3\xA2kotta zo me l\xC3\xA2kw\xC3\xAA angb\xC3\xA2 g\xC3\xAF tarrango n\xC3\xAE \xC3\xA2kotta zo t\xC3\xAE koddoro n\xC3\xAE \xC3\xA2\x64\x65 agb\xC3\xBB tenne n\xC3\xAE na kate t\xC3\xB6ngana mb\xC3\xAAn\xC3\xAE kotta kpalle t\xC3\xAE nz\xC3\xB6n\xC3\xAE dut\xC3\xAF t\xC3\xAE hal\xC3\xABzo p\xC3\xABpe at\xC3\xA2\x61 s\xC3\xB4 \xC3\xA2la l\xC3\xBC gb\xC3\xA2 t\xC3\xAE \xC3\xA2ndya t\xC3\xAE m\xC3\xA2i na sahngo as\xC3\xA2ra gb\xC3\xA2 t\xC3\xAE";
const char* kTeststr_si_Sinh = " \xE0\xB6\x85\xE0\xB6\xB1\xE0\xB7\x94\xE0\xB6\xBB\xE0\xB7\x8F\xE0\xB6\xB0 \xE0\xB6\xB8\xE0\xB7\x92\xE0\xB7\x84\xE0\xB7\x92\xE0\xB6\xB3\xE0\xB7\x94\xE0\xB6\x9A\xE0\xB7\x94\xE0\xB6\xBD \xE0\xB6\xB1\xE0\xB6\xB8\xE0\xB7\x92\xE0\xB6\xB1\xE0\xB7\x8A \xE0\xB7\x83\xE0\xB6\x9A\xE0\xB7\x94\xE0\xB6\xBB\xE0\xB7\x8F \xE0\xB6\xA7 \xE0\xB6\xBD\xE0\xB7\x92\xE0\xB6\xB4\xE0\xB7\x92\xE0\xB6\xBA\xE0\xB6\x9A\xE0\xB7\x8A \xE0\xB6\xAD\xE0\xB7\x90\xE0\xB6\xB4\xE0\xB7\x91\xE0\xB6\xBD\xE0\xB7\x99\xE0\xB6\xB1\xE0\xB7\x8A \xE0\xB6\x91\xE0\xB7\x80\xE0\xB7\x8F \xE0\xB6\xAD\xE0\xB7\x92\xE0\xB6\xB6\xE0\xB7\x94\xE0\xB6\xAB\xE0\xB7\x8F \xE0\xB6\x9A\xE0\xB7\x92 \xE0\xB7\x8A \xE0\xB6\xBB\xE0\xB7\x83\xE0\xB7\x8A\xE0\xB6\xA7\xE0\xB7\x92 \xE0\xB7\x82\xE0\xB7\x99\xE0\xB6\xBD\xE0\xB7\x8A\xE0\xB6\xA7\xE0\xB6\xB1\xE0\xB7\x8A \xE0\xB6\xB4 \xE0\xB7\x8A \xE0\xB6\xBB\xE0\xB6\xB1\xE0\xB7\x8F\xE0\xB6\xB1\xE0\xB7\x8A\xE0\xB6\xAF\xE0\xB7\x94 \xE0\xB6\xAF";
const char* kTeststr_sit_NP = " dialekten in de roerstreek pierre bakkes oet roerstreek blz bewirk waordebook z\xC3\xB3njig oktoeaber is t ie\xC3\xABste mofers waordebook oetgekaome dit waordebook is samegest\xC3\xA8ldj";
const char* kTeststr_sk_Latn = " a aktivova\xC5\xA5 reklamn\xC3\xBA kampa\xC5\x88 ak chcete kampa\xC5\x88 pred spusten\xC3\xADm e\xC5\xA1te prisp\xC3\xB4sobi\xC5\xA5 ulo\xC5\xBEte ju ako \xC5\xA1\x61\x62l\xC3\xB3nu a pokra\xC4\x8Dujte v \xC3\xBAprave vyberte si jednu z mo\xC5\xBEnost\xC3\xAD ni\xC5\xBE\xC5\xA1ie a kliknite na tla\xC4\x8Didlo ulo\xC5\xBEi\xC5\xA5 kampa\xC5\x88 nastavenia kampane m\xC3\xB4\xC5\xBE\x65te \xC4\xBEubovo\xC4\xBEne";
const char* kTeststr_sl_Latn = " adsense stanje prijave za google adsense google adsense ra\xC4\x8Dun je bil za\xC4\x8D\x61sno zamrznjen pozdravljeni hvala za va\xC5\xA1\x65 zanimanje v google adsense po pregledu va\xC5\xA1\x65 prijavnice so na\xC5\xA1i strokovnjaki ugotovili da spletna stran ki je trenutno povezana z va\xC5\xA1im";
const char* kTeststr_sm_Latn = " autu mea o lo totonu le e le minaomia matou te tuu i totonu i le faamatalaina o le suesuega i taimi uma mea o lo totonu fuafua i mea e tatau fa afoi tala mai le newsgroup mataupu fa afoi mai tala e ai le mataupu e ai totonu tusitala o le itu o faamatalaga";
const char* kTeststr_sn_Latn = " chete vanyori vanotevera vakabatsira kunyora zvikamu zvino kumba home tinyorere tsamba chikamu chakumbirwa hachina kuwanikwa chikamu ichi cheninge chakayiswa kuimwe nzvimbo mudhairekitori rino chimwe chikamu chopadhuze pane chinhu chatadza kushanda bad";
const char* kTeststr_so_Latn = " a oo maanta bogga koobaad ugu qoran yahey beesha caalamka laakiin si kata oo beesha caalamku ula guntato soomaaliya waxa aan shaki ku jirin in aakhirataanka dadka soomaalida oo kaliya ay yihiin ku soomaaliya ka saari kara dhibka ay ku jirto";
const char* kTeststr_sq_Latn = " a do t\xC3\xAB k\xC3\xABrkoni nga beogradi q\xC3\xAB t\xC3\xAB njoh\xC3\xAB pavar\xC3\xABsin\xC3\xAB e kosov\xC3\xABs zoti tha\xC3\xA7i prishtina \xC3\xABsht\xC3\xAB gati ta njoh pavar\xC3\xABsin\xC3\xAB e serbis\xC3\xAB nd\xC3\xABrsa natyrisht se do t\xC3\xAB k\xC3\xABrkohet nj\xC3\xAB gj\xC3\xAB e till\xC3\xAB q\xC3\xAB edhe beogradi ta njoh shtetin e pavarur dhe sovran t\xC3\xAB";
const char* kTeststr_sr_Cyrl = "\xD0\xB1\xD0\xB0\xD0\xBB\xD1\x87\xD0\xB0\xD0\xBA \xD0\xB1\xD0\xB0\xD0\xBB\xD1\x87\xD0\xB0\xD0\xBA \xD0\xBD\xD0\xB0 \xD0\xBC\xD0\xB0\xD0\xBF\xD0\xB8 \xD1\x81\xD1\x80\xD0\xB1\xD0\xB8\xD1\x98\xD0\xB5 \xD1\x83\xD1\x80\xD0\xB5\xD0\xB4\xD0\xB8 \xD0\xB4\xD0\xB5\xD0\xBC\xD0\xBE\xD0\xB3\xD1\x80\xD0\xB0\xD1\x84\xD0\xB8\xD1\x98\xD0\xB0 \xD1\x83 \xD0\xBD\xD0\xB0\xD1\x81\xD0\xB5\xD1\x99\xD1\x83 \xD0\xB1\xD0\xB0\xD0\xBB\xD1\x87\xD0\xB0\xD0\xBA \xD0\xB6\xD0\xB8\xD0\xB2\xD0\xB8 \xD0\xBF\xD1\x83\xD0\xBD\xD0\xBE\xD0\xBB\xD0\xB5\xD1\x82\xD0\xBD\xD0\xB0 \xD1\x81\xD1\x82\xD0\xB0\xD0\xBD\xD0\xBE\xD0\xB2\xD0\xBD\xD0\xB8\xD0\xBA\xD0\xB0 \xD0\xB0 \xD0\xBF\xD1\x80\xD0\xBE\xD1\x81\xD0\xB5\xD1\x87\xD0\xBD\xD0\xB0 \xD1\x81\xD1\x82\xD0\xB0\xD1\x80\xD0\xBE\xD1\x81\xD1\x82 \xD1\x81\xD1\x82\xD0\xB0\xD0\xBD\xD0\xBE\xD0\xB2\xD0\xBD\xD0\xB8\xD1\x88\xD1\x82\xD0\xB2\xD0\xB0 \xD0\xB8\xD0\xB7\xD0\xBD\xD0\xBE\xD1\x81\xD0\xB8 \xD0\xB3\xD0\xBE\xD0\xB4\xD0\xB8\xD0\xBD\xD0\xB0";
//const char* kTeststr_sr_Latn = " autonomnih pokrajina saveznim zakonom mo\xC5\xBE\x65 se propisati poseban sastav organizacija i delokrug saveta za poslove narodne odbrane \xC4\x8Dlanove saveta federacije bira na predlog predsedni\xC5\xA1tva savezna skup\xC5\xA1tina iz reda dru\xC5\xA1tveno politi\xC4\x8Dkih i drugih javnih";
const char* kTeststr_sr_Latn = "Dru\xC5\xA1tvo | \xC4\x8D\x65tvrtak 1.08.2013 | 13:43 Krade se i izvorska voda Izvor:  Gornji Milanovac -- U gru\xC5\xBE\x61nskom selu Belo Polje pro\xC5\xA1le no\xC4\x87i ukradeno je vi\xC5\xA1\x65 od 10.000 litara kojima je obijen bazen. Bazen je bio zaklju\xC4\x8D\x61n i propisno obezbe\xC4\x91\x65n.";

const char* kTeststr_sr_ME_Latn = "savjet pobjeda a radi br\xC5\xBE\x65g rada po\xC5\xA1to rom radi sporije nego ram izvorni rom se isklju\xC4\x8Duje a dio ram a se rezervi\xC5\xA1\x65 te se u njega ne plo\xC4\x8D\x61 procesor ram memorija grafi\xC4\x8Dka kartica zvu\xC4\x8Dna kartica modem mre\xC5\xBEna kartica napojna jedinica ure\xC4\x91\x61ji za pohranjivanje";
const char* kTeststr_ss_Latn = " bakhokhintsela yesikhashana bafake imininingwane ye akhawunti leliciniso kulelifomu nangabe akukafakwa imininingwane leliciniso imali lekhokhiwe angeke ifakwe kumkhokhintsela lofanele imininingwane ye akhawunti ime ngalendlela lelandzelako inombolo";
const char* kTeststr_st_Latn = " bang ba nang le thahasello matshwao a sehlooho thuto e thehilweng hodima diphetho ke tsela ya ho ruta le ho ithuta e totobatsang hantle seo baithuti ba lokelang ho se fihlella ntlhatheo eo e sebetsang ka yona ke ya hore titjhere o hlakisa pele seo";
const char* kTeststr_su_Latn =  "Nu ngatur kahirupan warga, keur kapentingan pamarentahan diatur ku RT, RW jeung Kepala Dusun, sedengkeun urusan adat dipupuhuan ku Kuncen jeung kepala adat. Sanajan Kampung Kuta teu pati anggang jeung lembur sejenna nu aya di wewengkon Desa Pasir Angin, tapi boh wangunan imah atawa tradisi kahirupan masarakatna nenggang ti nu lian.";
const char* kTeststr_sv_Latn = " a bort objekt fr\xC3\xA5n google desktop post \xC3\xA4ldst meny \xC3\xB6retag dress etaljer alternativ f\xC3\xB6r vad \xC3\xA4r inne yaste google skrivbord plugin program f\xC3\xB6r nyheter google visa nyheter som \xC3\xA4r anpassade efter de artiklar som du l\xC3\xA4ser om du till exempel l\xC3\xA4ser";
const char* kTeststr_sw_Latn = " a ujumbe mpya jumla unda tafuta na angalia vikundi vya kujadiliana na kushiriki mawazo iliyopangwa kwa tarehe watumiaji wapya futa orodha hizi lugha hoja vishikanisho vilivyo dhaminiwa ujumbe sanaa na tamasha toka udhibitisho wa neno kwa haraka fikia";
const char* kTeststr_syr_Syrc = "\xDC\x90\xDC\x95\xDC\xAA\xDC\x9D\xDC\xA3 \xDC\x93\xDC\x9B\xDC\x98 \xDC\xAB\xDC\x98\xDC\xAA\xDC\x9D\xDC\x90 \xDC\xA1\xDC\xA2 \xDC\xA6\xDC\xAA\xDC\xA2\xDC\xA3\xDC\x90 \xDC\xA1\xDC\xA2 \xDC\x90\xDC\xA3\xDC\xA6\xDC\xA2\xDC\x9D\xDC\x90 \xDC\x9A\xDC\x90\xDC\xAA\xDC\x98\xDC\xAC\xDC\x90 \xDC\x92\xDC\x90\xDC\x95\xDC\xAA \xDC\x92\xDC\xA2\xDC\x9D\xDC\xA3\xDC\xA2 \xDC\xAB\xDC\x9B\xDC\x9D\xDC\x9A\xDC\x98\xDC\xAC\xDC\x90 \xDC\x9F\xDC\xA0\xDC\xA2\xDC\x9D\xDC\x90 \xDC\xA1\xDC\x9D\xCC\x88\xDC\x90 \xDC\x92\xDC\xA5\xDC\xA0\xDC\xA1\xDC\x90";
const char* kTeststr_ta_Taml = " \xE0\xAE\x85\xE0\xAE\x99\xE0\xAF\x8D\xE0\xAE\x95\xE0\xAF\x81 \xE0\xAE\xB0\xE0\xAE\xBE\xE0\xAE\x9C\xE0\xAF\x87\xE0\xAE\xA8\xE0\xAF\x8D\xE0\xAE\xA4\xE0\xAE\xBF\xE0\xAE\xB0 \xE0\xAE\x9A\xE0\xAF\x8B\xE0\xAE\xB4\xE0\xAE\xA9\xE0\xAE\xBE\xE0\xAE\xB2\xE0\xAF\x8D \xE0\xAE\x95\xE0\xAE\x9F\xE0\xAF\x8D\xE0\xAE\x9F\xE0\xAE\xAA\xE0\xAF\x8D\xE0\xAE\xAA\xE0\xAE\x9F\xE0\xAF\x8D\xE0\xAE\x9F \xE0\xAE\xAA\xE0\xAE\xBF\xE0\xAE\xB0\xE0\xAE\xAE\xE0\xAF\x8D\xE0\xAE\xAE\xE0\xAE\xBE\xE0\xAE\xA3\xE0\xAF\x8D\xE0\xAE\x9F\xE0\xAE\xAE\xE0\xAE\xBE\xE0\xAE\xA9 \xE0\xAE\x9A\xE0\xAE\xBF\xE0\xAE\xB5\xE0\xAE\xA9\xE0\xAF\x8D \xE0\xAE\x95\xE0\xAF\x8B\xE0\xAE\xB5\xE0\xAE\xBF\xE0\xAE\xB2\xE0\xAF\x8D \xE0\xAE\x92\xE0\xAE\xA9\xE0\xAF\x8D\xE0\xAE\xB1\xE0\xAF\x81\xE0\xAE\xAE\xE0\xAF\x8D \xE0\xAE\x89\xE0\xAE\xB3\xE0\xAF\x8D\xE0\xAE\xB3\xE0\xAE\xA4\xE0\xAF\x81 \xE0\xAE\xA4\xE0\xAF\x8A\xE0\xAE\x95\xE0\xAF\x81";
const char* kTeststr_te_Telu = " \xE0\xB0\x81 \xE0\xB0\xA6\xE0\xB0\xA8\xE0\xB0\xB0 \xE0\xB0\x9C\xE0\xB0\xAF\xE0\xB0\xBF\xE0\xB0\x82\xE0\xB0\x9A\xE0\xB0\xBF\xE0\xB0\xA8 \xE0\xB0\xA4\xE0\xB0\xA4\xE0\xB1\x8D\xE0\xB0\xB5 \xE0\xB0\xAE\xE0\xB0\xB0\xE0\xB0\xB8\xE0\xB0\xBF \xE0\xB0\x9A\xE0\xB1\x82\xE0\xB0\xA1\xE0\xB0\x81 \xE0\xB0\xA6\xE0\xB0\xBE\xE0\xB0\xA8 \xE0\xB0\xAF\xE0\xB0\x97\xE0\xB1\x81\xE0\xB0\xA8\xE0\xB1\x81 \xE0\xB0\xB0\xE0\xB0\xBE\xE0\xB0\x9C\xE0\xB0\xAF\xE0\xB1\x8B\xE0\xB0\x97\xE0\xB0\xBF \xE0\xB0\xAF\xE0\xB0\xBF\xE0\xB0\x9F\xE0\xB1\x8D\xE0\xB0\xB2\xE0\xB1\x81 \xE0\xB0\xA4\xE0\xB1\x87\xE0\xB0\x9C\xE0\xB0\xB0\xE0\xB0\xBF\xE0\xB0\xB2\xE0\xB1\x8D\xE0\xB0\xB2\xE0\xB1\x81\xE0\xB0\x9A\xE0\xB1\x81 \xE0\xB0\xA8\xE0\xB1\x81\xE0\xB0\x82\xE0\xB0\xA1\xE0\xB1\x81 \xE0\xB0\xB5\xE0\xB0\xBF\xE0\xB0\xB6\xE0\xB1\x8D\xE0\xB0\xB5\xE0\xB0\xA6\xE0\xB0\xBE\xE0\xB0\xAD\xE0\xB0\xBF\xE0\xB0\xB0\xE0\xB0\xBE\xE0\xB0\xAE \xE0\xB0\xB5\xE0\xB0\xBF\xE0\xB0\xA8\xE0\xB0\xB0 \xE0\xB0\xB5\xE0\xB1\x87\xE0\xB0\xAE";
const char* kTeststr_tg_Arab = "\xD8\xB1\xD8\xA7\xD8\xAF\xDB\x8C\xD9\x88 \xD9\x81\xD8\xB1\xD8\xAF\xD8\xA7 \xD8\xB1\xD8\xA7\xD8\xAF\xD9\x8A\xD9\x88\xD9\x89 \xD8\xA2\xD8\xB2\xD8\xA7\xD8\xAF\xD9\x89";
const char* kTeststr_tg_Cyrl = " \xD0\xB0\xD0\xB4\xD0\xBE\xD0\xBB\xD0\xB0\xD1\x82 \xD0\xB2\xD0\xB0 \xD0\xB8\xD0\xBD\xD1\x81\xD0\xBE\xD0\xBD\xD0\xB4\xD3\xAF\xD1\x81\xD1\x82\xD0\xB8\xD1\x80\xD0\xBE \xD0\xB1\xD0\xB0\xD1\x80 \xD1\x84\xD0\xB0\xD1\x88\xD0\xB8\xD0\xB7\xD0\xBC \xD0\xBD\xD0\xB0\xD0\xB6\xD0\xBE\xD0\xB4\xD0\xBF\xD0\xB0\xD1\x80\xD0\xB0\xD1\x81\xD1\x82\xD3\xA3 \xD0\xB2\xD0\xB0 \xD0\xB0\xD0\xB4\xD0\xBE\xD0\xB2\xD0\xB0\xD1\x82 \xD1\x82\xD0\xB0\xD1\x80\xD2\xB7\xD0\xB5\xD2\xB3 \xD0\xB4\xD0\xBE\xD0\xB4\xD0\xB0\xD0\xB0\xD1\x81\xD1\x82 \xD1\x87\xD0\xBE\xD0\xBF \xD0\xBA\xD1\x83\xD0\xBD\xD0\xB5\xD0\xB4 \xD0\xB1\xD0\xB0 \xD0\xB4\xD0\xB8\xD0\xB3\xD0\xB0\xD1\x80\xD0\xBE\xD0\xBD \xD1\x84\xD0\xB8\xD1\x80\xD0\xB8\xD1\x81\xD1\x82\xD0\xB5\xD0\xB4 \xD1\x87\xD0\xBE\xD0\xBF \xD0\xBA\xD1\x83\xD0\xBD\xD0\xB5\xD0\xB4 \xD0\xB1\xD0\xB0 \xD0\xB4\xD0\xB8\xD0\xB3\xD0\xB0\xD1\x80\xD0\xBE\xD0\xBD \xD1\x84\xD0\xB8\xD1\x80\xD0\xB8\xD1\x81\xD1\x82\xD0\xB5\xD0\xB4";
const char* kTeststr_th_Thai = " \xE0\xB8\x81\xE0\xB8\x8F\xE0\xB9\x83\xE0\xB8\x99\xE0\xB8\x81\xE0\xB8\xB2\xE0\xB8\xA3\xE0\xB8\x84\xE0\xB9\x89\xE0\xB8\x99\xE0\xB8\xAB\xE0\xB8\xB2 \xE0\xB8\xAB\xE0\xB8\xA3\xE0\xB8\xB7\xE0\xB8\xAD\xE0\xB8\xAB\xE0\xB8\x99\xE0\xB9\x89\xE0\xB8\xB2\xE0\xB9\x80\xE0\xB8\x99\xE0\xB8\xB7\xE0\xB9\x89\xE0\xB8\xAD\xE0\xB8\xAB\xE0\xB8\xB2 \xE0\xB8\xAB\xE0\xB8\xB2\xE0\xB8\x81\xE0\xB8\x97\xE0\xB9\x88\xE0\xB8\xB2\xE0\xB8\x99\xE0\xB9\x80\xE0\xB8\xA5\xE0\xB8\xB7\xE0\xB8\xAD\xE0\xB8\x81\xE0\xB8\xA5\xE0\xB8\x87\xE0\xB9\x82\xE0\xB8\x86\xE0\xB8\xA9\xE0\xB8\x93\xE0\xB8\xB2 \xE0\xB8\x97\xE0\xB9\x88\xE0\xB8\xB2\xE0\xB8\x99\xE0\xB8\xAD\xE0\xB8\xB2\xE0\xB8\x88\xE0\xB8\x88\xE0\xB8\xB0\xE0\xB8\x9B\xE0\xB8\xA3\xE0\xB8\xB1\xE0\xB8\x9A\xE0\xB8\x95\xE0\xB9\x89\xE0\xB8\xAD\xE0\xB8\x87\xE0\xB9\x80\xE0\xB8\x9E\xE0\xB8\xB4\xE0\xB9\x88\xE0\xB8\xA1\xE0\xB8\x87\xE0\xB8\x9A\xE0\xB8\x9B\xE0\xB8\xA3\xE0\xB8\xB0\xE0\xB8\xA1\xE0\xB8\xB2\xE0\xB8\x93\xE0\xB8\xA3\xE0\xB8\xB2\xE0\xB8\xA2\xE0\xB8\xA7\xE0\xB8\xB1\xE0\xB8\x99\xE0\xB8\x95\xE0\xB8\xB2";
const char* kTeststr_ti_Ethi = " \xE1\x88\x83\xE1\x8C\x88\xE1\x88\xAD \xE1\x89\xB0\xE1\x88\xA8\xE1\x8D\x8E\xE1\x88\x9D \xE1\x8B\x98\xE1\x88\x88\xE1\x8B\x89 \xE1\x8A\xA2\xE1\x89\xB5\xE1\x8B\xAE\xE1\x8C\xB5\xE1\x8B\xAB\xE1\x8B\x8D\xE1\x8B\xAB\xE1\x8A\x95 \xE1\x8A\xA3\xE1\x89\xA5\xE1\x89\xB2 \xE1\x88\x9D\xE1\x88\xB5 \xE1\x8A\xA2\xE1\x89\xB5\xE1\x8B\xAE\xE1\x8C\xB5\xE1\x8B\xAB \xE1\x8B\x9D\xE1\x8B\xB3\xE1\x8B\x8D\xE1\x89\xA5 \xE1\x8A\xA3\xE1\x8B\x8D\xE1\x88\xAB\xE1\x8C\x83 \xE1\x8B\xB0\xE1\x89\xA1\xE1\x89\xA5 \xE1\x8A\x95\xE1\x8A\xBD\xE1\x8A\x90\xE1\x89\xA5\xE1\x88\xA9 \xE1\x8A\xA3\xE1\x8B\xAD\xE1\x8D\x8D\xE1\x89\x80\xE1\x8B\xB0\xE1\x88\x8E\xE1\x88\x9D\xE1\x8A\x95 \xE1\x8A\xA5\xE1\x8B\xA9 \xE1\x8A\xAB\xE1\x89\xA5 \xE1\x88\x83\xE1\x8C\x88\xE1\x88\xAD \xE1\x8A\x95\xE1\x8A\xBD\xE1\x89\xB5\xE1\x8B\x88\xE1\x8C\xBD\xE1\x8A\xA5 \xE1\x8B\x9C\xE1\x8C\x8B \xE1\x8A\xB9\xE1\x8A\x95 \xE1\x8B\x88\xE1\x8C\xBB\xE1\x8A\xA5\xE1\x89\xB0\xE1\x8A\x9B \xE1\x8A\x93\xE1\x8B\xAD";
const char* kTeststr_tk_Cyrl = " \xD0\xB0\xD0\xB9\xD0\xB4\xD1\x8F\xD0\xBD\xD0\xBB\xD0\xB0\xD1\x80\xD1\x8B\xD0\xBD\xD0\xB0 \xD1\x8B\xD0\xBD\xD0\xB0\xD0\xBD\xD1\x8F\xD1\x80\xD0\xBC\xD1\x8B\xD0\xBA\xD0\xB0 \xD1\x8D\xD1\x85\xD0\xBB\xD0\xB8 \xD0\xB1\xD0\xBE\xD0\xB7 \xD0\xBC\xD0\xB5\xD0\xB9\xD0\xB4\xD0\xB0\xD0\xBD\xD0\xBB\xD0\xB0\xD1\x80\xD1\x8B \xD1\x81\xD1\x83\xD1\x80\xD1\x83\xD0\xBB\xD0\xB8\xD0\xBF \xD0\xB3\xD1\x83\xD1\x82\xD0\xB0\xD1\x80\xD1\x8B\xD0\xBB\xD0\xB0\xD0\xBD \xD1\x82\xD0\xB5\xD0\xB1\xD0\xB8\xD0\xB3\xD1\x8B \xD0\xBE\xD1\x82\xD0\xB0 \xD0\xB3\xD0\xB0\xD1\x80\xD1\x8B\xD0\xBF \xD0\xB3\xD1\x83\xD0\xBC\xD0\xBB\xD1\x83\xD0\xBA\xD0\xBB\xD0\xB0\xD1\x80\xD0\xB4\xD0\xB0 \xD0\xBC\xD0\xB8\xD0\xBB\xD0\xBB\xD0\xB8\xD0\xBE\xD0\xBD\xD0\xB4\xD0\xB0\xD0\xBD \xD0\xB4\xD0\xB0 \xD0\xB0\xD1\x80\xD1\x82\xD1\x8B\xD0\xBA\xD0\xBC\xD0\xB0\xD1\x87 \xD0\xB8\xD1\x80\xD0\xB8 \xD1\x88\xD0\xB0\xD1\x85\xD0\xBB\xD1\x8B \xD0\xBC\xD0\xB0\xD0\xBB\xD1\x8B \xD0\xBC\xD0\xB8\xD0\xBB\xD0\xBB\xD0\xB8\xD0\xBE\xD0\xBD\xD0\xB0";
const char* kTeststr_tk_Latn = " akyllylyk \xC3\xA7yn s\xC3\xB6\xC3\xBDgi \xC3\xBC\xC3\xA7in b\xC3\xB6wet d\xC3\xA4l de tebigylykdyr du\xC3\xBDgulary\xC5\x88 g\xC3\xB6\x64\x65\xC5\x88siligi a\xC3\xA7 a\xC3\xA7\x61nlygy bahyllygy s\xC3\xB6\xC3\xBDgini betny\xC5\x9F\x61nlyk derejesine d\xC3\xBC\xC5\x9F\xC3\xBCr\xC3\xBD\xC3\xA4ndir s\xC3\xB6\xC3\xBD\x65ni s\xC3\xB6\xC3\xBD s\xC3\xB6\xC3\xBDmedige s\xC3\xBC\xC3\xBDkenme \xC3\xB6z\xC3\xBCni s\xC3\xB6\xC3\xBDme\xC3\xBD\xC3\xA4ndigini g\xC3\xB6rmek \xC3\xBDigit \xC3\xBC\xC3\xA7in uly";
const char* kTeststr_tl_Latn = " a na ugma sa google ay nakaka bantog sa gitna nang kliks na nangyayari sa pamamagitan nang ordinaryong paggagamit at sa kliks na likha nang pandaraya o hindi tunay na paggamit bunga nito nasasala namin ang mga kliks na hindi kailangan o hindi gusto nang";
const char* kTeststr_tl_Tglg = " \xE1\x9C\x8B\xE1\x9C\x87\xE1\x9C\x94 \xE1\x9C\x90\xE1\x9C\x93\xE1\x9C\x8E\xE1\x9C\x86\xE1\x9C\x94 \xE1\x9C\x83 \xE1\x9C\x88\xE1\x9C\x85\xE1\x9C\x94 \xE1\x9C\x8A\xE1\x9C\x8C\xE1\x9C\x94\xE1\x9C\x8A\xE1\x9C\x8C\xE1\x9C\x92\xE1\x9C\x88\xE1\x9C\x94 \xE1\x9C\x82\xE1\x9C\x89\xE1\x9C\x85\xE1\x9C\x94\xE1\x9C\x94 \xE1\x9C\x8B\xE1\x9C\x90\xE1\x9C\x88\xE1\x9C\x8C\xE1\x9C\x94 \xE1\x9C\x8E\xE1\x9C\x85\xE1\x9C\x94 \xE1\x9C\x81\xE1\x9C\x90 \xE1\x9C\x89\xE1\x9C\x85\xE1\x9C\x94 \xE1\x9C\x80\xE1\x9C\x83\xE1\x9C\x94\xE1\x9C\x8E\xE1\x9C\x86\xE1\x9C\x94 \xE1\x9C\x86\xE1\x9C\x93\xE1\x9C\x85\xE1\x9C\x94\xE1\x9C\x83\xE1\x9C\x93\xE1\x9C\x8E\xE1\x9C\x94 \xE1\x9C\x90 \xE1\x9C\x8A\xE1\x9C\x8C\xE1\x9C\x94\xE1\x9C\x8A\xE1\x9C\x8C\xE1\x9C\x92\xE1\x9C\x88\xE1\x9C\x94 \xE1\x9C\x90 \xE1\x9C\x86\xE1\x9C\x92\xE1\x9C\x85\xE1\x9C\x92\xE1\x9C\x88\xE1\x9C\x94 \xE1\x9C\x83\xE1\x9C\x93";
const char* kTeststr_tlh_Latn = " a ghuv bid soh naq jih lodni yisov chich wo vamvo qeylis lunge pu chah povpu vodleh a dah ghah cho ej dah wo che pujwi bommu tlhegh darinmohlahchu pu majqa horey so lom qa ip quv law may vad suvtahbogh wa sanid utlh quv pus datu pu a vitu chu pu johwi tar";
const char* kTeststr_tn_Latn = " go etela batla ditsebe tsa web tse di nang le le batla ditsebe tse di golaganya le tswang mo leka go batla web yotlhe batla mo web yotlhe go bona home page ya google batla mo a o ne o batla gore a o ne o batla ditsebe tsa bihari batla mo re maswabi ga go";
const char* kTeststr_to_Latn = " a ke kumi oku ikai ke ma u vakai ki hono hokohoko faka alafapeti api pe ko e uluaki peesi a ho o fekumi faka malatihi fekumi ki he lea oku fakaha atu pe ko ha fonua fekumi ki he fekumi ki he peesi oku ngaahi me a oku sai imisi alu ki he ki he ulu aki";
const char* kTeststr_tr_Latn = " a ayarlar\xC4\xB1n\xC4\xB1z\xC4\xB1 g\xC3\xB6rmeniz ve y\xC3\xB6netmeniz i\xC3\xA7indir e\xC4\x9F\x65r kampanyan\xC4\xB1z i\xC3\xA7in g\xC3\xBCnl\xC3\xBCk b\xC3\xBCt\xC3\xA7\x65nizi g\xC3\xB6zden ge\xC3\xA7irebilece\xC4\x9Finiz yeri ar\xC4\xB1yorsan\xC4\xB1z kampanya y\xC3\xB6netimi ne gidin kampanyan\xC4\xB1z\xC4\xB1 se\xC3\xA7in ve kampanya ayarlar\xC4\xB1n\xC4\xB1 d\xC3\xBCzenle yi t\xC4\xB1klay\xC4\xB1n sunumu";
const char* kTeststr_ts_Latn = " a ku na timhaka leti nga ta vulavuriwa na google google yi hlonipha yi tlhela yi sirheleta vanhu hinkwavo lava tirhisaka google toolbar ku dyondza hi vusireleli eka system ya hina hi kombela u hlaya vusireleli bya hina eka toolbar mbulavulo wu tshikiwile";
const char* kTeststr_tt_Cyrl = "\xD0\xB0\xD1\x87\xD0\xB0\xD1\x80\xD0\xB3\xD0\xB0 \xD0\xB4\xD0\xB0 \xD0\xB1\xD0\xB8\xD1\x80\xD0\xBC\xD3\x99\xD0\xB4\xD0\xB5 \xD1\x87\xD3\x99\xD1\x82 \xD1\x87\xD3\x99\xD1\x82 \xD0\xBA\xD0\xB8\xD0\xBB\xD0\xB5\xD0\xBF \xD1\x82\xD0\xBE\xD1\x80\xD0\xB0 \xD0\xB1\xD0\xB5\xD0\xB7\xD0\xBD\xD0\xB5\xD2\xA3 \xD0\xB0\xD0\xB1\xD1\x8B\xD0\xB9\xD0\xBD\xD1\x8B\xD0\xBC\xD1\x8B \xD0\xBE\xD0\xBB\xD1\x8B \xD0\xB0\xD0\xB1\xD1\x8B\xD0\xB9\xD0\xBD\xD1\x8B\xD0\xBC\xD1\x8B \xD1\x8D\xD1\x88\xD1\x82\xD3\x99\xD0\xBD";
const char* kTeststr_tt_Latn = " alarn\xC4\xB1 e\xC5\x9Fk\xC3\xA4rt\xC3\xBC pro\xC4\x9Framnar\xC4\xB1n e\xC5\x9Fl\xC3\xA4wen d\xC3\xA4wam it\xC3\xBC tatar s\xC3\xB6yl\xC3\xA4men buld\xC4\xB1ru w\xC3\xA4 sizep alu sistemnar\xC4\xB1n e\xC5\x9Fl\xC3\xA4wen d\xC3\xA4wat it\xC3\xBC h\xC3\xA4m ba\xC5\x9Fqalar y\xC4\xB1ln\xC4\xB1\xC3\xB1 may\xC4\xB1nda tatar internet\xC4\xB1 ictima\xC4\x9F\xC4\xB1y oy\xC4\xB1\xC5\x9Fmas\xC4\xB1 milli ts isemle beren\xC3\xA7\x65 d\xC3\xA4r\xC3\xA4\x63\xC3\xA4le h\xC3\xA4m tat";
const char* kTeststr_tw_Latn = " amammui tumidifo no b\xC9\x9Btow ahy\xC9\x9B atoro som so mpofirim na w\xC9\x94\x61s\xC9\x9B\x65 no pasaa ma ay\xC9\x9B nwonwa d\xC9\x9Bn na \xC9\x9B\x62\xC9\x9Bka w\xC9\x94n ma w\xC9\x94\x61y\xC9\x9B saa bible no ma ho mmuae w\xC9\x94 adiyis\xC9\x9Bm nhoma no mu s\xC9\x9B onyankop\xC9\x94n na \xC9\x94\x64\x65 hy\xC9\x9B\xC9\x9B w\xC9\x94n komam s\xC9\x9B w\xC9\x94mma ne nsusuwii mmra mu";
const char* kTeststr_ug_Arab = " \xD8\xA6\xD8\xA7\xD9\x84\xDB\x95\xD9\x85\xD9\x84\xDB\x95\xD8\xB1\xD9\x86\xD9\x89\xDA\xAD \xD9\xBE\xDB\x95\xD8\xB1\xDB\x8B\xDB\x95\xD8\xB1\xD8\xAF\xD9\x89\xDA\xAF\xD8\xA7\xD8\xB1\xD9\x89\xD8\xAF\xD9\x89\xD9\x86 \xD8\xAA\xD9\x89\xD9\x84\xDB\x95\xD9\x8A\xD9\x85\xDB\x95\xD9\x86 \xD8\xB3\xD9\x89\xD9\x84\xDB\x95\xD8\xB1 \xD8\xA8\xDB\x87 \xD9\x8A\xDB\x95\xD8\xB1\xD9\x84\xDB\x95\xD8\xB1\xD8\xAF\xDB\x95 \xD8\xA8\xD8\xA7\xD8\xBA\xDA\x86\xD9\x89\xD9\x84\xD8\xA7\xD8\xB1\xD8\xAF\xD9\x89\xD9\x86 \xD8\xA8\xDB\x87\xD9\x84\xD8\xA7\xD9\x82\xD9\x84\xD8\xA7\xD8\xB1\xD8\xAF\xD9\x89\xD9\x86 \xD8\xB2\xD9\x89\xD8\xB1\xD8\xA7\xD8\xA6\xDB\x95\xD8\xAA\xD9\x84\xDB\x95\xD8\xB1\xD8\xAF\xD9\x89\xD9\x86 \xD9\x8A\xDB\x87\xD9\x85\xD8\xB4\xD8\xA7\xD9\x82 \xD9\xBE\xD9\x89\xD8\xB4\xD9\x82\xD8\xA7\xD9\x86 \xD8\xAE\xD9\x88\xD8\xB1\xD9\x85\xD9\x89\xD9\x84\xD8\xA7\xD8\xB1\xD8\xAF\xD9\x89\xD9\x86 \xD8\xA8\xDB\x95\xDA\xBE\xD8\xB1\xD9\x89\xD9\x85\xDB\x95\xD9\x86 \xD8\xA8\xD9\x88\xD9\x84\xDB\x87\xD9\xBE";
const char* kTeststr_ug_Cyrl = " \xD0\xB0 \xD0\xB1\xD0\xB0\xD1\x88\xD0\xBB\xD0\xB8\xD0\xB4\xD0\xB8 \xD3\x99\xD0\xBC\xD0\xBC\xD0\xB0 \xD0\xB1\xD1\x83 \xD2\x9B\xD0\xB5\xD1\x82\xD0\xB8\xD0\xBC\xD2\x9B\xD0\xB8 \xD0\xBA\xD0\xB0\xD0\xBD\xD0\xB0\xD0\xB4\xD0\xB0 \xD0\xBC\xD3\x99\xD1\x82\xD0\xB1\xD1\x83\xD0\xB0\xD1\x82\xD0\xBB\xD0\xB8\xD1\x80\xD0\xB8\xD0\xBD\xD0\xB8\xD2\xA3 \xD1\x85\xD3\x99\xD0\xB2\xD3\x99\xD1\x80\xD0\xBB\xD0\xB8\xD1\x80\xD0\xB8\xD0\xB4\xD3\x99 \xD0\xB8\xD0\xBB\xD0\xB3\xD0\xB8\xD1\x80\xD0\xB8\xD0\xBA\xD0\xB8\xD0\xB4\xD3\x99\xD0\xBA \xD1\x85\xD0\xB8\xD1\x82\xD0\xB0\xD0\xB9 \xD2\xBB\xD3\xA9\xD0\xBA\xD2\xAF\xD0\xBC\xD3\x99\xD1\x82 \xD0\xBC\xD3\x99\xD1\x82\xD0\xB1\xD1\x83\xD0\xB0\xD1\x82\xD0\xBB\xD0\xB8\xD1\x80\xD0\xB8\xD0\xB4\xD0\xB8\xD0\xBD \xD0\xBD\xD3\x99\xD2\x9B\xD0\xB8\xD0\xBB \xD0\xB0\xD0\xBB\xD0\xB8\xD0\xB4\xD0\xB8\xD2\x93\xD0\xB0\xD0\xBD \xD0\xB2\xD3\x99 \xD1\x83\xD0\xBD\xD0\xB8 \xD0\xBA\xD3\xA9\xD1\x87\xD2\xAF\xD1\x80\xD2\xAF\xD0\xBF";
const char* kTeststr_ug_Latn = " adawet bolghachqa hazir musherrepmu bu ikki partiyining birleshme h\xC3\xB6k\xC3\xBCmet qurushta pikir birliki hasil qilalmasliqini k\xC3\xBCt\xC3\xBCwatqan iken wehalenki pakistan xelq partiyisining rehbiri asif eli zerdari pakistandiki bashqa ushshaq partiyilerning rehberliri";
const char* kTeststr_uk_Cyrl = " \xD0\xB0 \xD0\xB1\xD1\x96\xD0\xBB\xD1\x8C\xD1\x88\xD0\xB8\xD0\xB9 \xD0\xB1\xD1\x8E\xD0\xB4\xD0\xB6\xD0\xB5\xD1\x82 \xD1\x89\xD0\xBE\xD0\xB1 \xD0\xB7\xD0\xB0\xD0\xB1\xD0\xB5\xD0\xB7\xD0\xBF\xD0\xB5\xD1\x87\xD0\xB8\xD1\x82\xD0\xB8 \xD1\x81\xD0\xBE\xD0\xB1\xD1\x96 \xD0\xBC\xD0\xB0\xD0\xBA\xD1\x81\xD0\xB8\xD0\xBC\xD1\x83\xD0\xBC \xD0\xBF\xD1\x80\xD0\xB8\xD0\xB1\xD1\x83\xD1\x82\xD0\xBA\xD1\x96\xD0\xB2 \xD0\xB2\xD1\x96\xD0\xB4 \xD0\xBF\xD0\xB5\xD1\x80\xD0\xB5\xD1\x85\xD0\xBE\xD0\xB4\xD1\x96\xD0\xB2 \xD0\xB2\xD1\x96\xD0\xB4\xD1\x81\xD1\x82\xD0\xB5\xD0\xB6\xD1\x83\xD0\xB9\xD1\x82\xD0\xB5 \xD1\x81\xD0\xB2\xD0\xBE\xD1\x97 \xD0\xBE\xD0\xB1 \xD1\x8F\xD0\xB2\xD0\xB8 \xD0\xB7\xD0\xB0 \xD0\xB4\xD0\xB0\xD1\x82\xD0\xBE\xD1\x8E \xD0\xB3\xD0\xB5\xD0\xBE\xD0\xB3\xD1\x80\xD0\xB0\xD1\x84\xD1\x96\xD1\x87\xD0\xBD\xD0\xB8\xD0\xBC \xD1\x80\xD0\xBE\xD0\xB7\xD1\x82\xD0\xB0\xD1\x88\xD1\x83\xD0\xB2\xD0\xB0\xD0\xBD\xD0\xBD\xD1\x8F\xD0\xBC";
const char* kTeststr_ur_Arab = " \xD8\xA2\xD9\xBE \xDA\xA9\xD9\x88 \xDA\xA9\xD9\x85 \xD8\xB3\xDB\x92 \xDA\xA9\xD9\x85 \xD9\x85\xD9\x85\xDA\xA9\xD9\x86\xDB\x81 \xD8\xB1\xD9\x82\xD9\x85 \xDA\x86\xD8\xA7\xD8\xB1\xD8\xAC \xDA\xA9\xD8\xB1\xD8\xAA\xD8\xA7 \xDB\x81\xDB\x92 \xD8\xA7\xD8\xB3 \xDA\xA9\xDB\x8C \xD9\x85\xD8\xAB\xD8\xA7\xD9\x84 \xDA\xA9\xDB\x92 \xD8\xB7\xD9\x88\xD8\xB1 \xD9\xBE\xD8\xB1 \xD9\x81\xD8\xB1\xD8\xB6 \xDA\xA9\xD8\xB1\xDB\x8C\xDA\xBA \xD8\xA7\xDA\xAF\xD8\xB1 \xD8\xA2\xD9\xBE \xDA\xA9\xDB\x8C \xD8\xB2\xDB\x8C\xD8\xA7\xD8\xAF\xDB\x81 \xD8\xB3\xDB\x92 \xD8\xB2\xDB\x8C\xD8\xA7\xD8\xAF\xDB\x81 \xD9\x82\xDB\x8C\xD9\x85\xD8\xAA \xD9\x81\xDB\x8C \xDA\xA9\xD9\x84\xD9\x90\xDA\xA9 \xD8\xA7\xD9\x85\xD8\xB1\xDB\x8C\xDA\xA9\xDB\x8C \xDA\x88\xD8\xA7\xD9\x84\xD8\xB1 \xD8\xA7\xD9\x88\xD8\xB1 \xDA\xA9\xD9\x84\xD9\x90\xDA\xA9 \xDA\xA9\xD8\xB1\xD9\x86\xDB\x92 \xDA\xA9\xDB\x8C \xD8\xB4\xD8\xB1\xD8\xAD \xDB\x81\xD9\x88 \xD8\xAA\xD9\x88";
const char* kTeststr_uz_Arab = " \xD8\xA2\xD8\xB1\xD9\x82\xD9\x84\xDB\x8C \xD8\xA8\xD9\x88\xD8\xAA\xD9\x88\xD9\x86 \xD8\xB3\xDB\x8C\xD8\xA7\xD8\xB3\xDB\x8C \xD8\xAD\xD8\xB2\xD8\xA8 \xD9\x88 \xDA\xAF\xD8\xB1\xD9\x88\xD9\x87 \xD9\x84\xD8\xB1\xD9\x81\xD8\xB9\xD8\xA7\xD9\x84\xDB\x8C\xD8\xAA\xDB\x8C\xDA\xAF\xD9\x87 \xD8\xB1\xD8\xAE\xD8\xB5\xD8\xAA \xD8\xA8\xDB\x8C\xD8\xB1\xDA\xAF\xD9\x86 \xD8\xA7\xD8\xAE\xD8\xA8\xD8\xA7\xD8\xB1\xD8\xA7\xD8\xAA \xD9\x88\xD8\xA7\xD8\xB3\xD8\xB7\xD9\x87 \xD9\x84\xD8\xB1\xDB\x8C \xD8\xB4\xD9\x88 \xDB\x8C\xDB\x8C\xD9\x84 \xD9\x85\xD8\xAF\xD8\xAA\xDB\x8C\xD8\xAF\xD9\x87 \xD9\x85\xD8\xAB\xD8\xA7\xD9\x84 \xD8\xB3\xDB\x8C\xD8\xB2 \xD8\xAA\xD8\xB1\xD9\x82\xDB\x8C \xD8\xAA\xD8\xA7\xD9\xBE\xDA\xA9\xD9\x86 \xD9\x88 \xD8\xA7\xD9\x87\xD8\xA7\xD9\x84\xDB\x8C \xD9\x86\xDB\x8C\xD9\x86\xDA\xAF \xD8\xA7\xD9\x82\xD8\xAA\xD8\xB5\xD8\xA7\xD8\xAF\xDB\x8C \xD9\x88\xD8\xB6\xD8\xB9\xDB\x8C\xD8\xAA\xDB\x8C \xD8\xA7\xD9\x88\xD8\xAA\xD9\x85\xDB\x8C\xD8\xB4";
const char* kTeststr_uz_Cyrl = " \xD0\xB0 \xD0\xB3\xD0\xB0\xD0\xBF\xD0\xB8\xD1\x80\xD0\xB0\xD0\xB4\xD0\xB8\xD0\xB3\xD0\xB0\xD0\xBD \xD0\xB1\xD1\x9E\xD0\xBB\xD1\x81\xD0\xB0\xD0\xBA \xD0\xB1\xD1\x83\xD0\xBD\xD0\xB8\xD0\xBD\xD0\xB3 \xD0\xB8\xD0\xBA\xD0\xBA\xD0\xB8\xD1\x82\xD0\xB0 \xD0\xB9\xD1\x9E\xD0\xBB\xD0\xB8 \xD0\xB1\xD0\xBE\xD1\x80 \xD0\xB1\xD0\xB8\xD1\x80\xD0\xB8\xD0\xBD\xD1\x87\xD0\xB8\xD1\x81\xD0\xB8 \xD0\xBC\xD0\xB0\xD0\xBD\xD0\xB0 \xD1\x88\xD1\x83 \xD2\x9B\xD1\x83\xD1\x80\xD0\xB8\xD0\xB3\xD0\xB0\xD0\xBD \xD1\x81\xD0\xB0\xD1\x82\xD2\xB3\xD0\xB8\xD0\xBD\xD0\xB8 \xD2\x9B\xD1\x83\xD0\xBC\xD0\xBB\xD0\xB8\xD0\xBA\xD0\xBB\xD0\xB0\xD1\x80\xD0\xBD\xD0\xB8 \xD1\x82\xD1\x9E\xD1\x85\xD1\x82\xD0\xB0\xD1\x82\xD0\xB8\xD1\x88 \xD1\x83\xD1\x87\xD1\x83\xD0\xBD \xD1\x8D\xD0\xBA\xD0\xBE\xD1\x82\xD0\xB8\xD0\xB7\xD0\xB8\xD0\xBC\xD0\xBD\xD0\xB8 \xD0\xBC\xD1\x83\xD1\x81\xD1\x82\xD0\xB0\xD2\xB3\xD0\xBA\xD0\xB0\xD0\xBC\xD0\xBB\xD0\xB0\xD1\x88 \xD2\x9B\xD1\x83\xD0\xBC\xD0\xB3\xD0\xB0";
const char* kTeststr_uz_Latn = " abadiylashtirildi aqsh ayol prezidentga tayyormi markaziy osiyo afg onistonga qanday yordam berishi mumkin ukrainada o zbekistonlik muhojirlar tazyiqdan shikoyat qilmoqda gruziya va ukraina hozircha natoga qabul qilinmaydi afg oniston o zbekistonni g";
const char* kTeststr_ve_Latn = "Vho \xE1\xB9\xB1\x61nganedzwa kha Wikipedia nga tshiVen\xE1\xB8\x93\x61. Vhadivhi vha manwalo a TshiVenda vha talusa divhazwakale na vhubvo ha Vhavenda ngau fhambana. Vha tikedza mbuno dzavho uya nga mawanwa a thoduluso dze vha ita. Vhanwe vha vhatodulusi vhari Vhavenda vho tumbuka Afrika vhukati vha tshimbila vha tshiya Tshipembe ha Afrika, Rhodesia hune ha vho vhidzwa Zimbagwe namusi.";
const char* kTeststr_vi_Latn = " adsense cho n\xC3\xB4\xCC\xA3i dung nha\xCC\x80 cung c\xC3\xA2\xCC\x81p di\xCC\xA3\x63h vu\xCC\xA3 di \xC4\x91\xC3\xB4\xCC\xA3ng xa\xCC\x81\x63 minh ti\xCC\x81n du\xCC\xA3ng thay \xC4\x91\xC3\xB4\xCC\x89i nha\xCC\x83n kg ca\xCC\x81\x63 \xC3\xB4 xem chi phi\xCC\x81 cho t\xC6\xB0\xCC\x80 ch\xC3\xB4\xCC\x81i ca\xCC\x81\x63 \xC4\x91\xC6\xA1n \xC4\x91\xC4\x83\xCC\xA3t ha\xCC\x80ng da\xCC\xA3ng c\xC3\xA2\xCC\x81p d\xC6\xB0\xCC\x83 li\xC3\xAA\xCC\xA3u a\xCC\x81\x63 minh trang web cu\xCC\x89\x61 ba\xCC\xA3n \xC4\x91\xC3\xAA\xCC\x89 xem";
const char* kTeststr_vo_Latn = " brefik se volap\xC3\xBCkavol n\xC3\xBCm balid \xC3\xA4pubon \xC3\xBCn d\xC3\xBC lif l\xC3\xB6lik okas redakans \xC3\xA4laip\xC3\xBC\x62ons gasedi at nom\xC3\xB6\x66iko \xC3\xA4\x64 ai mu kuratiko pl\xC3\xA4o tim\xC3\xBC koup ned\xC3\xA4na fa ns deut\xC3\xA4n k\xC3\xBC p\xC3\xA4proibon fa koupanef me gased at \xC3\xA4steif\xC3\xBClom ad propagid\xC3\xB6n volap\xC3\xBCki as sam \xC3\xBCn";
const char* kTeststr_war_Latn = "Amo ini an balay han Winaray o Binisaya nga Lineyte-Samarnon nga Wikipedia, an libre ngan gawasnon nga ensayklopedya nga bisan hin-o puyde magliwat o mag-edit. An Wikipedia syahan gintikang ha Iningles nga yinaknan han tuig 2001. Ini nga bersyon Winaray gintikang han ika-25 han Septyembre 2005 ngan ha yana mayda 514,613 nga artikulo. Kon karuyag niyo magsari o magprobar, pakadto ha . An Gastrotheca pulchra[2] in uska species han Anura nga ginhulagway ni Ulisses Caramaschi ngan Rodrigues hadton 2007. An Gastrotheca pulchra in nahilalakip ha genus nga Gastrotheca, ngan familia nga Hemiphractidae.[3][4] Ginklasipika han IUCN an species komo kulang hin datos.[1] Waray hini subspecies nga nakalista.[3]";
const char* kTeststr_wo_Latn = " am ak d\xC3\xABgg d\xC3\xABggam ak g\xC3\xABm aji bind ji te g\xC3\xABstu ko te j\xC3\xAB\x66\x61ndikoo tegtalu xel ci saxal ko sokraat nag j\xC3\xAB\x66\x61ndikoo woon na xeltu ngir tas jikko yu rafet ci biir nit \xC3\xB1i ak d\xC3\xABggu ak soppante sokraat nag \xC3\xB1\xC3\xABw na mook aflaton platon sukkandiku ci \xC3\xB1\x61\x61ri";
const char* kTeststr_xh_Latn = " a naynga zonke futhi libhengezwa kwiwebsite yebond yasemzantsi afrika izinga elisebenzayo xa usenza olu tyalo mali liya kusebenza de liphele ixesha lotyalo mali lwakho inzala ihlawulwa rhoqo emva kweenyanga ezintandathu ngomhla wamashumi amathathu ananye";
const char* kTeststr_xx_Bugi = "\xE1\xA8\x84\xE1\xA8\x9B\xE1\xA8\x91\xE1\xA8\x8A\xE1\xA8\x92 \xE1\xA8\x91\xE1\xA8\x97 \xE1\xA8\x94\xE1\xA8\x92\xE1\xA8\x97\xE1\xA8\x93\xE1\xA8\x9B \xE1\xA8\x95\xE1\xA8\x97\xE1\xA8\x8B\xE1\xA8\x97\xE1\xA8\x94\xE1\xA8\x97 \xE1\xA8\x92\xE1\xA8\x9B\xE1\xA8\x84 \xE1\xA8\x91\xE1\xA8\x9B\xE1\xA8\x94\xE1\xA8\x9B\xE1\xA8\x86\xE1\xA8\x97\xE1\xA8\x8A";
const char* kTeststr_xx_Goth = "\xF0\x90\x8C\xB0 \xF0\x90\x8C\xB0\xF0\x90\x8C\xB1\xF0\x90\x8D\x82\xF0\x90\x8C\xB0\xF0\x90\x8C\xB7\xF0\x90\x8C\xB0\xF0\x90\x8C\xBC \xF0\x90\x8C\xB0\xF0\x90\x8C\xB2\xF0\x90\x8C\xB2\xF0\x90\x8C\xB9\xF0\x90\x8C\xBB\xF0\x90\x8C\xB9\xF0\x90\x8D\x83\xF0\x90\x8C\xBA\xF0\x90\x8D\x83 \xF0\x90\x8C\xB8\xF0\x90\x8C\xB9\xF0\x90\x8C\xBF\xF0\x90\x8C\xB3\xF0\x90\x8C\xB9\xF0\x90\x8D\x83\xF0\x90\x8C\xBA\xF0\x90\x8D\x83 \xF0\x90\x8D\x86\xF0\x90\x8D\x82\xF0\x90\x8C\xB0\xF0\x90\x8C\xB2\xF0\x90\x8C\xBA\xF0\x90\x8C\xB9\xF0\x90\x8D\x83\xF0\x90\x8C\xBA\xF0\x90\x8D\x83";
const char* kTeststr_yi_Hebr = "\xD7\x90\xD7\x95\xD7\x9F \xD7\xA4\xD7\x90\xD7\xA0\xD7\x98\xD7\x90\xD7\x96\xD7\x99\xD7\xA2 \xD7\xA2\xD7\xA8 \xD7\x90\xD7\x99\xD7\x96 \xD7\x91\xD7\x90\xD7\xA7\xD7\x90\xD7\xA0\xD7\x98 \xD7\xA6\xD7\x99\xD7\x9D \xD7\x9E\xD7\xA2\xD7\xA8\xD7\xA1\xD7\x98\xD7\x9F \xD7\xA4\xD7\x90\xD7\xA8 \xD7\x96\xD7\x99\xD7\x99\xD7\xA0\xD7\xA2 \xD7\x91\xD7\x90\xD6\xB7\xD7\x9C\xD7\x90\xD6\xB7\xD7\x93\xD7\xA2\xD7\xA1 \xD7\xA2\xD7\xA8 \xD7\x94\xD7\x90\xD6\xB8\xD7\x98 \xD7\x92\xD7\xA2\xD7\x95\xD7\x95\xD7\x95\xD7\x99\xD7\xA0\xD7\x98 \xD7\x90\xD7\x99\xD7\x9F \xD7\x95\xD7\x95\xD7\x90\xD7\xA8\xD7\xA9\xD7\xA2 \xD7\x99\xD7\xA2\xD7\xA1 \xD7\xA4\xD7\x90\xD7\xA8\xD7\x99\xD7\xA1 \xD7\x9C\xD7\x99\xD7\x95\xD7\x95\xD7\xA2\xD7\xA8\xD7\xA4\xD7\x95\xD7\x9C \xD7\x90\xD7\x95\xD7\x9F \xD7\x9C\xD7\x90\xD7\xA0\xD7\x93\xD7\x90\xD7\x9F \xD7\xA1\xD7\x95\xD7\xA3 \xD7\x9B\xD7\x9C \xD7\xA1\xD7\x95\xD7\xA3 \xD7\x90\xD7\x99\xD7\x96 \xD7\xA2\xD7\xA8";
const char* kTeststr_yo_Latn = " abinibi han ikawe alantakun le ni opolopo ede abinibi ti a to lesese bi eniyan to fe lo se fe lati se atunse jowo mo pe awon oju iwe itakunagbaye miran ti ako ni oniruru ede abinibi le faragba nipa atunse ninu se iwadi blogs ni ori itakun agbaye ti e ba";
const char* kTeststr_za_Hani = " \xE4\xB8\xA4\xE4\xB8\xAA\xE5\xAE\xBE\xE8\xAF\xAD\xE7\x9A\x84\xE5\xAD\x97\xE6\x95\xB0\xE8\xBE\x83\xE5\xB0\x91\xE6\x97\xB6 \xE5\x8F\xAA\xE5\xB8\xA6\xE4\xB8\x80\xE4\xB8\xAA\xE5\x8A\xA8\xE8\xAF\x8D \xE5\x90\xA6\xE5\x88\x99\xE5\xB0\xB1\xE5\xB8\xA6\xE4\xB8\xA4\xE4\xB8\xAA\xE5\x8A\xA8\xE8\xAF\x8D \xE4\xB8\x89\xE5\x8F\xA5\xE5\xAD\x90\xE7\xB1\xBB \xE4\xBB\x8E\xE5\x8F\xA5\xE5\xAD\x90\xE6\x96\xB9\xE9\x9D\xA2\xE5\x8E\xBB\xE8\xB0\x88\xE6\xB1\x89 \xE5\xA3\xAE\xE8\xAF\xAD\xE7\xBB\x93\xE6\x9E\x84\xE6\xA0\xBC\xE5\xBC\x8F\xE7\x9B\xB8\xE5\xBC\x82\xE7\x9A\x84\xE7\xB1\xBB\xE5\x9E\x8B\xE7\x9A\x84 \xE5\x8F\xAB\xE5\x8F\xA5\xE5\xAD\x90\xE7\xB1\xBB \xE6\xB1\x89 \xE5\xA3\xAE\xE8\xAF\xAD\xE4\xB8\xAD \xE5\x8F\xA5\xE5\xAD\x90\xE7\xB1\xBB\xE7\xBB\x93\xE6\x9E\x84\xE6\xA0\xBC\xE5\xBC\x8F\xE6\x9C\x89\xE5\xB7\xAE\xE5\x88\xAB\xE7\x9A\x84\xE8\x87\xAA\xE7\x84\xB6\xE4\xB8\x8D\xE5\xB0\x91";
const char* kTeststr_za_Latn = " dih yinzminz ndaej daengz bujbienq youjyau dih cingzyin caeuq cinhingz diuz daihit boux boux ma daengz lajmbwn couh miz cwyouz cinhyenz caeuq genzli bouxboux bingzdaengj gyoengq vunz miz lijsing caeuq liengzsim wngdang daih gyoengq de lumj beixnuengx";
const char* kTeststr_zh_Hans = "\xE4\xBA\xA7\xE5\x93\x81\xE7\x9A\x84\xE7\xAE\x80\xE6\x8A\xA5\xE5\x92\x8C\xE5\x85\xAC\xE5\x91\x8A \xE6\x8F\x90\xE4\xBA\xA4\xE8\xAF\xA5\xE7\x94\xB3\xE8\xAF\xB7\xE5\x90\x8E\xE6\x97\xA0\xE6\xB3\x95\xE8\xBF\x9B\xE8\xA1\x8C\xE6\x9B\xB4\xE6\x94\xB9 \xE8\xAF\xB7\xE7\xA1\xAE\xE8\xAE\xA4\xE6\x82\xA8\xE7\x9A\x84\xE9\x80\x89\xE6\x8B\xA9\xE6\x98\xAF\xE6\xAD\xA3\xE7\xA1\xAE\xE7\x9A\x84 \xE5\xAF\xB9\xE4\xBA\x8E\xE8\xA6\x81\xE6\x8F\x90\xE4\xBA\xA4\xE7\x9A\x84\xE5\x9B\xBE\xE4\xB9\xA6 \xE6\x88\x91\xE7\xA1\xAE\xE8\xAE\xA4 \xE6\x88\x91\xE6\x98\xAF\xE7\x89\x88\xE6\x9D\x83\xE6\x89\x80\xE6\x9C\x89\xE8\x80\x85\xE6\x88\x96\xE5\xB7\xB2\xE5\xBE\x97\xE5\x88\xB0\xE7\x89\x88\xE6\x9D\x83\xE6\x89\x80\xE6\x9C\x89\xE8\x80\x85\xE7\x9A\x84\xE6\x8E\x88\xE6\x9D\x83 \xE8\xA6\x81\xE6\x9B\xB4\xE6\x94\xB9\xE6\x82\xA8\xE7\x9A\x84\xE5\x9B\xBD\xE5\xAE\xB6 \xE5\x9C\xB0\xE5\x8C\xBA \xE8\xAF\xB7\xE5\x9C\xA8\xE6\xAD\xA4\xE8\xA1\xA8\xE7\x9A\x84\xE6\x9C\x80\xE4\xB8\x8A\xE7\xAB\xAF\xE6\x9B\xB4\xE6\x94\xB9\xE6\x82\xA8\xE7\x9A\x84";
const char* kTeststr_zh_Hant = " \xE4\xB9\x8B\xE5\x89\x8D\xE7\x82\xBA \xE5\xB8\xB3\xE5\x96\xAE\xE4\xBA\xA4\xE6\x98\x93\xE4\xBD\x9C\xE6\xA5\xAD\xE5\x8D\x80 \xE5\xB7\xB2\xE8\xAE\x8A\xE6\x9B\xB4 \xE5\xBB\xA3\xE5\x91\x8A\xE5\x85\xA7\xE5\xAE\xB9 \xE4\xB9\x8B\xE5\x89\x8D\xE7\x82\xBA \xE9\x8A\xB7\xE5\x94\xAE\xE4\xBB\xA3\xE8\xA1\xA8 \xE4\xB9\x8B\xE5\x89\x8D\xE7\x82\xBA \xE5\xBC\xB5\xE8\xB2\xBC\xE6\x97\xA5\xE6\x9C\x9F\xE7\x82\xBA \xE7\x99\xBE\xE5\x88\x86\xE6\xAF\x94\xE4\xB9\x8B\xE5\x89\x8D\xE7\x82\xBA \xE5\x90\x88\xE7\xB4\x84 \xE7\x82\xBA \xE7\x9B\xAE\xE6\xA8\x99\xE5\xB0\x8D\xE8\xB1\xA1\xE6\xA2\x9D\xE4\xBB\xB6\xE5\xB7\xB2\xE5\x88\xAA\xE9\x99\xA4 \xE7\xB5\x90\xE6\x9D\x9F\xE6\x97\xA5\xE6\x9C\x9F\xE4\xB9\x8B\xE5\x89\x8D\xE7\x82\xBA";
const char* kTeststr_zu_Latn = " ana engu uma inkinga iqhubeka siza ubike kwi isexwayiso ngenxa yephutha lomlekeleli sikwazi ukubuyisela emuva kuphela imiphumela engaqediwe ukuthola imiphumela eqediwe zama ukulayisha kabusha leli khasi emizuzwini engu uma inkinga iqhubeka siza uthumele";
const char* kTeststr_zzb_Latn = "becoose a ve a leemit qooereees tu vurds um gesh dee bork bork nu peges vere a fuoond cunteeening is a fery cummun vurd und ves nut inclooded in yuoor seerch zee ooperetur is unnecessery ve a incloode a ell seerch terms by deffoolt um de hur de hur de hur";
const char* kTeststr_zze_Latn = " a diffewent type of seawch send feedback about google wiwewess seawch to wap google com wesuwts found on de entiwe web fow wesuwts found on de mobiwe web fow de functionawity of de toolbar up button has been expanded swightwy it now considews fow exampwe";
const char* kTeststr_zzh_Latn = " b x z un b e t und rs n a dr ss p as ry an th r a dr ss ry us n a l ss mb gu us c ti n l ke a z p c d n a dr ss nt r d pl as en r n a dr ss y ur s ar h f r n ar d d n t m tch ny l c ti n w th n m l s nd m r r at d p g s th l c ti ns b l w w r ut m t ca y";
const char* kTeststr_zzp_Latn = " away ackupbay editcray ardcay ybay isitingvay ouryay illingbay eferencespray agepay orway isitvay ethay adwordsway elphay entrecay orfay oremay etailsday adwordsway ooglegay omcay upportsay";

// Two very close Wikipedia page beginnings
const char* kTeststr_ms_close = "sukiyaki wikipedia bahasa melayu ensiklopedia bebas sukiyaki dari wikipedia bahasa melayu ensiklopedia bebas lompat ke navigasi gelintar sukiyaki sukiyaki  hirisan tipis daging lembu sayur sayuran dan tauhu di dalam periuk besi yang dimasak di atas meja makan dengan cara rebusan sukiyaki dimakan dengan mence";
const char* kTeststr_id_close = "sukiyaki wikipedia indonesia ensiklopedia bebas berbahasa bebas berbahasa indonesia langsung ke navigasi cari untuk pengertian lain dari sukiyaki lihat sukiyaki irisan tipis daging sapi sayur sayuran dan tahu di dalam panci besi yang dimasak di atas meja makan dengan cara direbus sukiyaki dimakan dengan mence";

// Simple intermixed French/English text
const char* kTeststr_fr_en_Latn =
                                  "France is the largest country in Western Europe and the third-largest in Europe as a whole. "
                                  "A acc\xC3\xA8s aux chiens et aux frontaux qui lui ont \xC3\xA9t\xC3\xA9 il peut consulter et modifier ses collections et exporter "
                                  "Cet article concerne le pays europ\xC3\xA9\x65n aujourd\xE2\x80\x99hui appel\xC3\xA9 R\xC3\xA9publique fran\xC3\xA7\x61ise. Pour d\xE2\x80\x99\x61utres usages du nom France, "
                                  "Pour une aide rapide et effective, veuiller trouver votre aide dans le menu ci-dessus."
                                  "Motoring events began soon after the construction of the first successful gasoline-fueled automobiles. The quick brown fox jumped over the lazy dog";

// This can be used to cross-check the build date of the main quadgram table
const char* kTeststr_version = "qpdbmrmxyzptlkuuddlrlrbas las les qpdbmrmxyzptlkuuddlrlrbas el la qpdbmrmxyzptlkuuddlrlrbas";

#endif


#endif  // I18N_ENCODINGS_COMPACT_LANG_DET_UNITTEST_DATA_H_
