// |reftest| skip-if(release_or_beta) -- numeric-separator-literal is not released yet
// Copyright (C) 2017 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: prod-NumericLiteralSeparator
description: NumericLiteralSeparator is not valid on string conversions for ToNumber operations
info: |
  `0b` | `0B` BinaryDigits NumericLiteralSeparator BinaryDigit

  NumericLiteralSeparator ::
    _

  BinaryIntegerLiteral ::
    0b BinaryDigits
    0B BinaryDigits

  BinaryDigits ::
    BinaryDigit
    BinaryDigits BinaryDigit
    BinaryDigits NumericLiteralSeparator BinaryDigit

  BinaryDigit :: one of
    0 1

features: [numeric-separator-literal]
---*/

assert.sameValue(Number("0b01_00"), NaN, "0b01_00");
assert.sameValue(Number("0B01_00"), NaN, "0B01_00");

reportCompare(0, 0);
