/*
 * unity-webapps-url-index.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib.h>
#include <gio/gio.h>

#include "unity-webapps-url-index.h"

#include "../unity-webapps-debug.h"

struct _UnityWebappsUrlIndexPrivate {
  gpointer fill;
};


G_DEFINE_ABSTRACT_TYPE(UnityWebappsUrlIndex, unity_webapps_url_index, G_TYPE_OBJECT)

#define UNITY_WEBAPPS_URL_INDEX_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_URL_INDEX, UnityWebappsUrlIndexPrivate))

static void
unity_webapps_url_index_class_init (UnityWebappsUrlIndexClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  
  g_type_class_add_private (object_class, sizeof(UnityWebappsUrlIndexPrivate));
}

static void
unity_webapps_url_index_init (UnityWebappsUrlIndex *index)
{
  index->priv = UNITY_WEBAPPS_URL_INDEX_GET_PRIVATE (index);
}

GList *
unity_webapps_url_index_lookup_url (UnityWebappsUrlIndex *index,
				    const gchar *url)
{
  return UNITY_WEBAPPS_URL_INDEX_GET_CLASS (index)->lookup_url (index, url);
}
