/*
 * Copyright 2016 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#include "tools/skiaserve/urlhandlers/UrlHandler.h"

#include "microhttpd.h"
#include "tools/skiaserve/Request.h"
#include "tools/skiaserve/Response.h"

using namespace Response;

bool ImgHandler::canHandle(const char* method, const char* url) {
    static const char* kBasePath = "/img";
    return 0 == strcmp(method, MHD_HTTP_METHOD_GET) &&
           0 == strncmp(url, kBasePath, strlen(kBasePath));
}

int ImgHandler::handle(Request* request, MHD_Connection* connection,
                       const char* url, const char* method,
                       const char* upload_data, size_t* upload_data_size) {
    SkTArray<SkString> commands;
    SkStrSplit(url, "/", &commands);

    if (!request->hasPicture() || commands.size() > 3) {
        return MHD_NO;
    }

    int n, m = -1;
    // /img or /img/N
    if (commands.size() == 1) {
        n = request->fDebugCanvas->getSize() - 1;
    } else if (commands.size() == 2) {
        sscanf(commands[1].c_str(), "%d", &n);
    } else {
        sscanf(commands[1].c_str(), "%d", &n);
        sscanf(commands[2].c_str(), "%d", &m);
    }

    sk_sp<SkData> data(request->drawToPng(n, m));
    return SendData(connection, data.get(), "image/png");
}
