; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -mergeicmps -verify-dom-info | FileCheck %s
target triple = "x86_64"

; First check that we try to from a memcmp.
define void @form_memcmp([2 x i64]* dereferenceable(16) %a, [2 x i64]* dereferenceable(16) %b) {
; CHECK-LABEL: @form_memcmp(
; CHECK-NEXT:  bb0:
; CHECK-NEXT:    [[PTR_A0:%.*]] = getelementptr inbounds [2 x i64], [2 x i64]* [[A:%.*]], i64 0, i64 0
; CHECK-NEXT:    [[PTR_A1:%.*]] = getelementptr inbounds [2 x i64], [2 x i64]* [[A]], i64 0, i64 1
; CHECK-NEXT:    [[PTR_B0:%.*]] = getelementptr inbounds [2 x i64], [2 x i64]* [[B:%.*]], i64 0, i64 0
; CHECK-NEXT:    [[PTR_B1:%.*]] = getelementptr inbounds [2 x i64], [2 x i64]* [[B]], i64 0, i64 1
; CHECK-NEXT:    br label %"bb1+bb2"
; CHECK:       "bb1+bb2":
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [2 x i64], [2 x i64]* [[A]], i64 0, i64 0
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [2 x i64], [2 x i64]* [[B]], i64 0, i64 0
; CHECK-NEXT:    [[CSTR:%.*]] = bitcast i64* [[TMP0]] to i8*
; CHECK-NEXT:    [[CSTR1:%.*]] = bitcast i64* [[TMP1]] to i8*
; CHECK-NEXT:    [[MEMCMP:%.*]] = call i32 @memcmp(i8* [[CSTR]], i8* [[CSTR1]], i64 16)
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i32 [[MEMCMP]], 0
; CHECK-NEXT:    br label [[BB3:%.*]]
; CHECK:       bb3:
; CHECK-NEXT:    ret void
;
bb0:
  %ptr_a0 = getelementptr inbounds [2 x i64], [2 x i64]* %a, i64 0, i64 0
  %ptr_a1 = getelementptr inbounds [2 x i64], [2 x i64]* %a, i64 0, i64 1
  %ptr_b0 = getelementptr inbounds [2 x i64], [2 x i64]* %b, i64 0, i64 0
  %ptr_b1 = getelementptr inbounds [2 x i64], [2 x i64]* %b, i64 0, i64 1
  br label %bb1

bb1:                                              ; preds = %bb0
  %a0 = load i64, i64* %ptr_a0
  %b0 = load i64, i64* %ptr_b0
  %cond0 = icmp eq i64 %a0, %b0
  br i1 %cond0, label %bb2, label %bb3

bb2:                                              ; preds = %bb1
  %a1 = load i64, i64* %ptr_a1
  %b1 = load i64, i64* %ptr_b1
  %cond1 = icmp eq i64 %a1, %b1
  br label %bb3

bb3:                                              ; preds = %bb2, %bb1
  %necessary = phi i1 [ %cond1, %bb2 ], [ false, %bb1 ]
  ret void
}

; We can't use memcmp between arbitrary addressesspaces
define void @no_memcmp([2 x i64] addrspace(11)* dereferenceable(16) %a, [2 x i64] addrspace(11)* dereferenceable(16) %b) {
; CHECK-LABEL: @no_memcmp(
; CHECK-NEXT:  bb0:
; CHECK-NEXT:    [[PTR_A0:%.*]] = getelementptr inbounds [2 x i64], [2 x i64] addrspace(11)* [[A:%.*]], i64 0, i64 0
; CHECK-NEXT:    [[PTR_A1:%.*]] = getelementptr inbounds [2 x i64], [2 x i64] addrspace(11)* [[A]], i64 0, i64 1
; CHECK-NEXT:    [[PTR_B0:%.*]] = getelementptr inbounds [2 x i64], [2 x i64] addrspace(11)* [[B:%.*]], i64 0, i64 0
; CHECK-NEXT:    [[PTR_B1:%.*]] = getelementptr inbounds [2 x i64], [2 x i64] addrspace(11)* [[B]], i64 0, i64 1
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[A0:%.*]] = load i64, i64 addrspace(11)* [[PTR_A0]], align 4
; CHECK-NEXT:    [[B0:%.*]] = load i64, i64 addrspace(11)* [[PTR_B0]], align 4
; CHECK-NEXT:    [[COND0:%.*]] = icmp eq i64 [[A0]], [[B0]]
; CHECK-NEXT:    br i1 [[COND0]], label [[BB2:%.*]], label [[BB3:%.*]]
; CHECK:       bb2:
; CHECK-NEXT:    [[A1:%.*]] = load i64, i64 addrspace(11)* [[PTR_A1]], align 4
; CHECK-NEXT:    [[B1:%.*]] = load i64, i64 addrspace(11)* [[PTR_B1]], align 4
; CHECK-NEXT:    [[COND1:%.*]] = icmp eq i64 [[A1]], [[B1]]
; CHECK-NEXT:    br label [[BB3]]
; CHECK:       bb3:
; CHECK-NEXT:    [[NECESSARY:%.*]] = phi i1 [ [[COND1]], [[BB2]] ], [ false, [[BB1]] ]
; CHECK-NEXT:    ret void
;
bb0:
  %ptr_a0 = getelementptr inbounds [2 x i64], [2 x i64] addrspace(11)* %a, i64 0, i64 0
  %ptr_a1 = getelementptr inbounds [2 x i64], [2 x i64] addrspace(11)* %a, i64 0, i64 1
  %ptr_b0 = getelementptr inbounds [2 x i64], [2 x i64] addrspace(11)* %b, i64 0, i64 0
  %ptr_b1 = getelementptr inbounds [2 x i64], [2 x i64] addrspace(11)* %b, i64 0, i64 1
  br label %bb1

bb1:                                              ; preds = %bb0
  %a0 = load i64, i64 addrspace(11)* %ptr_a0
  %b0 = load i64, i64 addrspace(11)* %ptr_b0
  %cond0 = icmp eq i64 %a0, %b0
  br i1 %cond0, label %bb2, label %bb3

bb2:                                              ; preds = %bb1
  %a1 = load i64, i64 addrspace(11)* %ptr_a1
  %b1 = load i64, i64 addrspace(11)* %ptr_b1
  %cond1 = icmp eq i64 %a1, %b1
  br label %bb3

bb3:                                              ; preds = %bb2, %bb1
  %necessary = phi i1 [ %cond1, %bb2 ], [ false, %bb1 ]
  ret void
}
