; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:   FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s | \
; RUN:   FileCheck %s

; These test cases aim to test the vector string isolate builtins on Power10.

declare <16 x i8> @llvm.ppc.altivec.vclrlb(<16 x i8>, i32)
declare <16 x i8> @llvm.ppc.altivec.vclrrb(<16 x i8>, i32)

define <16 x i8> @test_vclrlb(<16 x i8> %a, i32 %n) {
; CHECK-LABEL: test_vclrlb:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vclrlb v2, v2, r5
; CHECK-NEXT:    blr
entry:
  %tmp = tail call <16 x i8> @llvm.ppc.altivec.vclrlb(<16 x i8> %a, i32 %n)
  ret <16 x i8> %tmp
}

define <16 x i8> @test_vclrrb(<16 x i8> %a, i32 %n) {
; CHECK-LABEL: test_vclrrb:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vclrrb v2, v2, r5
; CHECK-NEXT:    blr
entry:
  %tmp = tail call <16 x i8> @llvm.ppc.altivec.vclrrb(<16 x i8> %a, i32 %n)
  ret <16 x i8> %tmp
}

declare <16 x i8> @llvm.ppc.altivec.vstribr(<16 x i8>)
declare <16 x i8> @llvm.ppc.altivec.vstribl(<16 x i8>)
declare <8 x i16> @llvm.ppc.altivec.vstrihr(<8 x i16>)
declare <8 x i16> @llvm.ppc.altivec.vstrihl(<8 x i16>)

declare i32 @llvm.ppc.altivec.vstribr.p(i32, <16 x i8>)
declare i32 @llvm.ppc.altivec.vstribl.p(i32, <16 x i8>)
declare i32 @llvm.ppc.altivec.vstrihr.p(i32, <8 x i16>)
declare i32 @llvm.ppc.altivec.vstrihl.p(i32, <8 x i16>)

define <16 x i8> @test_vstribr(<16 x i8> %a) {
; CHECK-LABEL: test_vstribr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vstribr v2, v2
; CHECK-NEXT:    blr
entry:
  %tmp = tail call <16 x i8> @llvm.ppc.altivec.vstribr(<16 x i8> %a)
  ret <16 x i8> %tmp
}

define <16 x i8> @test_vstribl(<16 x i8> %a) {
; CHECK-LABEL: test_vstribl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vstribl v2, v2
; CHECK-NEXT:    blr
entry:
  %tmp = tail call <16 x i8> @llvm.ppc.altivec.vstribl(<16 x i8>%a)
  ret <16 x i8> %tmp
}

define <8 x i16> @test_vstrihr(<8 x i16> %a) {
; CHECK-LABEL: test_vstrihr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vstrihr v2, v2
; CHECK-NEXT:    blr
entry:
  %tmp = tail call <8 x i16> @llvm.ppc.altivec.vstrihr(<8 x i16> %a)
  ret <8 x i16> %tmp
}

define <8 x i16> @test_vstrihl(<8 x i16> %a) {
; CHECK-LABEL: test_vstrihl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vstrihl v2, v2
; CHECK-NEXT:    blr
entry:
  %tmp = tail call <8 x i16> @llvm.ppc.altivec.vstrihl(<8 x i16> %a)
  ret <8 x i16> %tmp
}

define i32 @test_vstribr_p(<16 x i8> %a) {
; CHECK-LABEL: test_vstribr_p:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vstribr. v2, v2
; CHECK-NEXT:    setbc r3, 4*cr6+eq
; CHECK-NEXT:    blr
entry:
  %tmp = tail call i32 @llvm.ppc.altivec.vstribr.p(i32 1, <16 x i8> %a)
  ret i32 %tmp
}

define i32 @test_vstribl_p(<16 x i8> %a) {
; CHECK-LABEL: test_vstribl_p:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vstribl. v2, v2
; CHECK-NEXT:    setbc r3, 4*cr6+eq
; CHECK-NEXT:    blr
entry:
  %tmp = tail call i32 @llvm.ppc.altivec.vstribl.p(i32 1, <16 x i8> %a)
  ret i32 %tmp
}

define i32 @test_vstrihr_p(<8 x i16> %a) {
; CHECK-LABEL: test_vstrihr_p:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vstrihr. v2, v2
; CHECK-NEXT:    setbc r3, 4*cr6+eq
; CHECK-NEXT:    blr
entry:
  %tmp = tail call i32 @llvm.ppc.altivec.vstrihr.p(i32 1, <8 x i16> %a)
  ret i32 %tmp
}

define i32 @test_vstrihl_p(<8 x i16> %a) {
; CHECK-LABEL: test_vstrihl_p:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vstrihl. v2, v2
; CHECK-NEXT:    setbc r3, 4*cr6+eq
; CHECK-NEXT:    blr
entry:
  %tmp = tail call i32 @llvm.ppc.altivec.vstrihl.p(i32 1, <8 x i16> %a)
  ret i32 %tmp
}
