// generated by go run gen.go; DO NOT EDIT

package publicsuffix

const version = "publicsuffix.org's public_suffix_list.dat, git revision 0de6f8e (2015-07-15)"

const (
	nodesBitsChildren   = 9
	nodesBitsICANN      = 1
	nodesBitsTextOffset = 15
	nodesBitsTextLength = 6

	childrenBitsWildcard = 1
	childrenBitsNodeType = 2
	childrenBitsHi       = 14
	childrenBitsLo       = 14
)

const (
	nodeTypeNormal     = 0
	nodeTypeException  = 1
	nodeTypeParentOnly = 2
)

// numTLD is the number of top level domains.
const numTLD = 1337

// Text is the combined text of all labels.
const text = "biomutashinainfoggiabirdartdecodynaliascoli-picenord-frontierbir" +
	"kenesoddtangenovaravennagatorockartuzyunsakakinokiabirthplacevje" +
	"-og-hornnesangostrodawarabjarkoyurihonjournalistjordalshalsenfsh" +
	"ostre-totenkawabjerkreimmobilienhsanjotatsunostrolekaniepcexpose" +
	"dogawarabikomaezakirunortonsbergminakamichigangwonikonantananger" +
	"bjugninohelpaleostrowiecasertairabloombergbauernuorokunohealthca" +
	"reerschmidtre-gauldalottokashikinuyamanouchikuhokuryugasakitaura" +
	"yasudabluedatsunanjogaszkolahppiacenzachpomorskieninomiyakonojos" +
	"oyrovnostrowwlkpmgmodalenirasakinvestmentsannanishiazais-a-candi" +
	"datexasiabmsannohelsinkitakamiizumisanofieldyndns-freemasonryusu" +
	"harabmweirbnpparibaselburgmxboxeroxjaworznobomloanswatch-and-clo" +
	"ckerbondyndns-homednsanokasumigaurawa-mazowszexeterbonnishigotvs" +
	"antabarbarabootsantacruzsantafedjelenia-goraboschlesischesanukis" +
	"-a-catererbostikasuyakutiabostonakijinsekikogentingretajimakaneg" +
	"asakitagawabotanicalgardenishiharabotanicgardenishiizunazukis-a-" +
	"celticsfanishikatakayamatta-varjjatattoolsztynsettlersaotomelbou" +
	"rnextraspace-to-rentalsapodhalebotanynysadoesntexistanbullensake" +
	"rboutiquebecasinore-og-uvdalouvrepair-traffic-controlleyusuisser" +
	"vegame-serverdalovenneslaskerrylogisticsapporobozentsujiiebrades" +
	"corporationishikatsuragivingrimstadyndns-ip6brandywinevalleyuulm" +
	"inamibosogndalowiczest-le-patrondheimperiabrasiljan-mayenishikaw" +
	"azukaneyamaxunjargabresciabrindisiciliabristolgalsacebritishcolu" +
	"mbialowiezagannakadomari-elasticbeanstalkaszubyuzawabroadcastleb" +
	"timnetzgorabroadwayuzhno-sakhalinskatowicebroke-itaxihuanishimer" +
	"abrokerrypropertiesaratovalleaostavropolicebronnoysundyndns-mail" +
	"ubindalucaniabrothermesaverdealstahaugesundyndns-office-on-the-w" +
	"ebcambridgestonewportlligatewaybrumunddaluccapetownishinomiyashi" +
	"ronobrunelblagdenesnaaseralingenkainanaejrietiendaburyatiabrusse" +
	"lsardegnamsosnowiecastresistancebruxellesardiniabryanskleppalerm" +
	"omasvuotnakatsugawabryneuesarlucernebuyshousesarpsborgripebuzeni" +
	"shinoomotegovtgorybuzzgorzeleccollegersundyndns-picsarufutsunomi" +
	"yawakasaikaitakoelnishinoshimabwfarmequipmentjeldsundyndns-remot" +
	"egildeskalmykiabzhitomirkutskodjeffersonishiokoppegardyndns-serv" +
	"erbaniacntoyonezawacolognewjerseycolonialwilliamsburgrpanamacolo" +
	"radoplateaudiocolumbusantiquest-a-la-masioncommunitydaluxembourg" +
	"ruecomobaracompanycompute-1computerhistoryofscience-fictioncomse" +
	"curitysfjordcondoshichikashukujitawaraconferenceconstructioncons" +
	"uladollsatxn--0trq7p7nnconsultanthropologyconsultingvolluxurycon" +
	"tactoyonocontemporaryartgallerybnikahokutogitsuldaluzerncontract" +
	"orskenconventureshinodesashibetsuikindleikangercookingchannelver" +
	"uminamiechizencoolbia-tempio-olbiatempioolbialystokkecoopocznori" +
	"lskypescaravantaarparachutinguidellogliastradercopenhagencyclope" +
	"dicdn77-sslattuminamidaitomangotsukisosakitagatakamoriokamikitay" +
	"amatotakadacorsicamerakershus-east-1corvettelemarkazunocosenzako" +
	"panerairguardcostumedio-campidano-mediocampidanomediocouncilviva" +
	"no-frankivskchristiansburguitarsaudacouponsauheradcoursesavannah" +
	"gacqhachinoheguris-a-democratoyookarasjohkamiokaminokawanishiaiz" +
	"ubangecranbrookuwanalyticsaves-the-whalessandria-trani-barletta-" +
	"andriatranibarlettaandriacreditcardcreditunioncremonashorokanaie" +
	"crewiiheyaizuwakamatsubushikusakadogawacricketrzyncrimeacrotonew" +
	"mexicoldwarmiamiastarnbergujolstercrowncrsavonamsskoganeis-a-des" +
	"ignercruisesaxocuisinellancasterculturalcentertainmentoyosatomsk" +
	"ddielddanuorrikuzentakatajirissafetysnesayokkaichirurgiens-denti" +
	"stesbscholarshipschoolcuneocupcakecxn--11b4c3dcyouthdfcbankfhskh" +
	"abarovskhakassiafinlandfinnoyfirebaseappspotenzamamicrolightingu" +
	"nmaritimodellinguovdageaidnulsanfranciscotlandfirenzefirestonewy" +
	"orkshireggio-calabriafirmdaleirfjordfishingoldpointelligencefitj" +
	"arfitnessettlementoyotsukaidovre-eikerfjalerflesbergushikamifura" +
	"noshiroomuraflickragerotikamchatkameokameyamashinatsukigatakahar" +
	"ussiaflightschweizippodlasiellakasamatsudoosandnessjoenfloguchik" +
	"uzenfloraflorencefloridafloristanohatakahashimamakirkenesciencec" +
	"entersciencehistoryfloromskogxn--1ck2e1balestrandabergamoarekepn" +
	"ordlandivtasvuodnakaiwamizawaugustowadaejeonbukarlsoyokote12flow" +
	"erscientistor-elvdalflsmidthruhereggio-emilia-romagnakanotoddenf" +
	"lynnhubalsanagochihayaakasakawagoebinagisoccertificationaturalsc" +
	"iencesnaturelles3-sa-east-1fndfolldalfoodnetworkangerfor-better-" +
	"thandafor-ourfor-somedizinhistorischescrapper-sitefor-theatreefo" +
	"rexrothachiojiyahikobeatscrappingzjcbnlforgotdnservicesettsuppor" +
	"toyouraforli-cesena-forlicesenaforliguriaforsaleirvikharkivalled" +
	"-aostakinoueforsandasuolodingenfortmissoulan-udefenseljordfortwo" +
	"rthachirogatakanabeauxartsandcraftsevastopoleforuminamiizukamito" +
	"ndabayashiogamagoriziafosnesewildlifestylefotoystre-slidrettozaw" +
	"afredrikstadtveronakamuratakahamaniwakuratelevisionfreiburgfreig" +
	"htcmwilliamhillfribourgfriuli-v-giuliafriuli-ve-giuliafriuli-veg" +
	"iuliafriuli-venezia-giuliafriuli-veneziagiuliafriuli-vgiuliafriu" +
	"liv-giuliafriulive-giuliafriulivegiuliafriulivenezia-giuliafriul" +
	"iveneziagiuliafriulivgiuliafrlfroganshakotankharkovalledaostakko" +
	"fuelfrognfrolandfrom-akrehamnfrom-alfrom-arfrom-azlgfrom-capebre" +
	"tonamiasakuchinotsuchiurakawassamukawataricohdavvesiidazaifudaig" +
	"odoharuhrfrom-collectionfrom-ctozsdeltajimibungotakadavvenjargam" +
	"vikhersonfrom-dcheltenham-radio-operaunitelefonicagliaridagawars" +
	"zawashingtondclkatsushikabelaudiblebesbyglandyndns-weberlincolni" +
	"shitosashimizunaminamiashigarafrom-degreefrom-flandersharis-a-ge" +
	"ekhmelnitskiyamashikiyosatohoboleslawiechelyabinskydivingriwatar" +
	"ailwayfrom-gausdalfrom-higashiagatsumagoizumizakirovogradoyfrom-" +
	"iafrom-idfrom-ilfrom-in-the-bandaiwafunexusdecorativeartsharpara" +
	"glidingfrom-kshawaiijimarylandfrom-kyknetnedalfrom-langevagrarbo" +
	"retumbriafrom-mannosegawafrom-mdfrom-meereshellaspeziafrom-micro" +
	"softbankhmelnytskyivallee-aosteroyfrom-mnfrom-mochizukiryuohkura" +
	"from-msherbrookegawafrom-mtnfrom-nchernigovernmentjomeloyalistoc" +
	"kholmestrandyndns-wikirafrom-ndfrom-nefrom-nhktranaritakurashiki" +
	"s-a-greenfrom-njcparisor-fronfrom-nminamimakis-a-gurulvikhvallee" +
	"aosteigenfrom-nvanylvenicefrom-nyfrom-ohtawaramotoineppugliafrom" +
	"-oketogolfashionfrom-orfrom-paderbornfrom-praxis-a-anarchistoire" +
	"ggiocalabriafrom-rittogurafrom-schokoladenfrom-sdnipropetrovskla" +
	"businessebykleclerchernihivgucciprianiigataishinomakikugawatchan" +
	"dclockatsuyamashikefrom-tnfrom-txn--1ctwolominamatamayukis-a-har" +
	"d-workerfrom-utazuerichardlikes-piedmontblancashireggioemiliarom" +
	"agnakasatsunairlinebraskaunbieidsvollfrom-vadsochildrensgardenfr" +
	"om-vtranbyfrom-wafrom-wielunnerfrom-wvaofrom-wyfrosinonefrostalo" +
	"wa-wolawafroyahabaghdadfstcgrouparliamentrani-andria-barletta-tr" +
	"ani-andriafujiiderafujikawaguchikonefujiminohadanotaireshimojis-" +
	"a-hunterfujinomiyadafujiokayamansionshimokawafujisatoshonairport" +
	"land-4-salernogiessengerdalaskanittedallasalleaseeklogeshimokita" +
	"yamafujisawafujishiroishidakabiratorideliveryggeelvinckmpspbalsf" +
	"jordivttasvuotnakamagayachts3-us-gov-west-1fujiyoshidafukayabear" +
	"dubaiduckdnsdojoetsurutaharaumakeupowiatmallorcafederationfukuch" +
	"iyamadafukudominichernivtsicilyfukuis-a-knightraniandriabarletta" +
	"traniandriafukumitsukefukuokazakisarazure-mobileitungsenfukurois" +
	"higakishiwadafukusakisofukushimanxn--1lqs03nfukuyamagatakahataka" +
	"ishimogosenfunabashiriuchinadafunagatakamatsukawafunahashikamiam" +
	"akusatsumasendaisennangonohejis-a-landscaperugiafundaciofuoiskuj" +
	"ukuriyamaoris-a-lawyerfuosskoczowinbaltimore-og-romsdalillesandi" +
	"egotembaixadaukraanghkemerovodkagoshimagnitkakamigaharaholtaleni" +
	"waizumiotsukumiyamazonawsaarlandgcampobassociates3-eu-west-1furn" +
	"iturehabikinokawairtelecityeatshimonitayanagis-a-liberalfurubira" +
	"quarelleasingleshimonosekikawafurudonostiafurukawaharafusodegaur" +
	"afussagaeroclubmedecincinnativeamericanantiquesquarendalenugfuta" +
	"bayamaguchinomigawafutboldlygoingnowhere-for-moregontrailroadfut" +
	"tsurugashimarburgfvgfyis-a-libertarianfylkesbiblackfridayfyresda" +
	"lhannanmokuizumodenakatombetsulikescandynathomebuiltranoyhannova" +
	"reservebbshimotsukehanyuzenhapmirumarnardalhappounzenhareidsberg" +
	"enharstadharvestcelebrationhasamarahasaminami-alpssells-for-ustk" +
	"arasuyamazoehasudahasvikokonoehatogayahoooshikamaishimodatenris-" +
	"a-nurseminehatoyamazakitahiroshimarriottransportrapaniimimatakas" +
	"ugais-a-painteractivegaskimitsubatamicadaqueshimotsumahatsukaich" +
	"iharahattfjelldalhayashimamotobunkyonanaoshimabariakehazuminobus" +
	"ells-itravelchannelhembygdsforbundhemneshinichinanhemsedalheroku" +
	"ssldheroyhgtvarggatravelersinsurancehigashichichibusheyhigashihi" +
	"roshimanehigashiizumozakitakatakaokamikoaniikappulawyhigashikaga" +
	"wahigashikagurasoedahigashikawakitaaikitakyushuaiahigashikurumee" +
	"trdhigashimatsushimarugame-hostinghigashimatsuyamakitaakitadaito" +
	"igawahigashimurayamalatvuopmidoris-a-patsfanhigashinarusellsyour" +
	"homeftpaccesshinjournalismolanshinjukumanohigashinehigashiomihac" +
	"himanchesterhigashiosakasayamamotorcycleshinkamigotoyohashimotok" +
	"uyamahigashishirakawamatakarazukamiminershinshinotsurfastlyhigas" +
	"hisumiyoshikawaminamiaikitamidsundhigashitsunotteroyhigashiuraus" +
	"ukitamotosumidatlantichiryukyuragifuefukihabmerhigashiyamatokori" +
	"yamanakakogawahigashiyodogawahigashiyoshinogaris-a-personaltrain" +
	"erhiraizumisatohmarumorimachidahirakatashinagawahiranairtrafficb" +
	"cghirarahiratsukagawahirayaitakasagooglecodespotrentino-a-adigeh" +
	"istorichouseshinshirohitachiomiyaginowaniihamatamakawajimarcheap" +
	"artmentshintokushimahitachiotagoparocherkasyzrankoshigayaltaikis" +
	"-a-photographerokuapparshintomikasaharahitoyoshimifunehitradingh" +
	"jartdalhjelmelandholeckobierzyceholidayhomeipartis-a-playerhomel" +
	"inuxn--1lqs71dhomessinashikitanakagusukumodernhomeunixn--1qqw23a" +
	"hondahonefosshinyoshitomiokanmakiwakunigamihamadahongorgehonjyoi" +
	"chiropractichitachinakagawatchesasayamahornindalhorsembokukitash" +
	"iobarahortendofinternetrentino-aadigehoteleshiojirishirifujiedah" +
	"otmailhoyangerhoylandetroitskolobrzegyptianquanconagawakeisenbah" +
	"nhurdalhurumajis-a-republicancerresearchaeologicaliforniahyogori" +
	"s-a-rockstarachowicehyugawarajfkomakiyosemitejgorajlchloejlljmpa" +
	"rtnershiraokanonjis-a-studentaljnjeonnamerikawauejoyoitakasakitc" +
	"henjpmorganichocolatelekommunikationishiwakis-a-conservativegars" +
	"heis-a-cpadoval-daostavalleyjpnchofunatorientexpressexyzgradyndn" +
	"s-workshoppdalukowhalingroks-thisayamanashichinohedmarketsasebok" +
	"nowsitallyngenissandvikcoromantovalle-aostatoiluroyjprshiratakah" +
	"agis-a-teacherkassymantechnologyjurkredstonekristiansandefjordkr" +
	"istiansundkrodsheradkrokstadelvaldaostathellewismillerkryminamio" +
	"guniversitykumatorinokumejimateramoldelmenhorstalbanshisuifuette" +
	"rtdasnetzwindmillkumenanyokaichibahccavuotnagareyamaintenancekun" +
	"isakis-an-actresshirahamatonbetsurgeonshalloffamelhuslivinghisto" +
	"rykunitachiaraisaijoshkar-olayangroupartykunitomigusukumamotoyam" +
	"asudakunneppupasadenaklodzkodairakunstsammlungkunstunddesignkuok" +
	"groupassagenshitaramakureitrentino-sudtirolkurgankurobellevuelos" +
	"angelesjaguarchitecturebungoonomichinomiyakembuchikujobservercel" +
	"liernemurorangemologicallfinanzkurogimilitarykuroisoftwaremarker" +
	"ryhotelshizukuishimofusaikis-an-anarchistoricalsocietyumenkuroma" +
	"tsunais-an-artistjohnkurotakikawasakis-an-engineeringerikekursko" +
	"mmunalforbundkushirogawakustanais-an-entertainerkusunndalkutchan" +
	"elkutnokuzbassnillfjordkuzumakis-bykvafjordkvalsundkvamlidlugole" +
	"kagaminord-aurdalvdalipayufuchukotkafjordkvanangenkvinesdalkvinn" +
	"heradkviteseidskogkvitsoykwpspjelkavikommunekyotobetsupersportre" +
	"ntino-sued-tirolkyowariasahikawamissilexusgardenmisugitokigawami" +
	"takeharamitourismolenskomorotsukamisunagawamitoyoakemiuramiyazur" +
	"ewebsiteshikagamiishikarikaturindalmiyotamanomjondalenmlbarclays" +
	"3-us-west-2monmouthaebaruminamiminowamonticellombardiamondshouji" +
	"s-into-animegurovigorlicemontrealestatebankomvuxn--2m4a15emonza-" +
	"brianzaporizhzhekinannestadmonza-e-della-brianzaporizhzhiamonzab" +
	"rianzapposts-and-telecommunicationshowamonzaebrianzaramonzaedell" +
	"abrianzamordoviajessheiminamisanrikubetsupplieshizuokanoyakagemo" +
	"riyamatsusakahogithubusercontentrentino-suedtirolmoriyoshiokamit" +
	"suemormoneymoroyamatsushigemortgagemoscowindowshriramsterdamberk" +
	"eleymoseushistorymosjoenmoskenesienaplesigdalmossimbirskongsberg" +
	"mosvikongsvingermoviemovistargardmtpccwioslombardyndns-at-homede" +
	"potaruis-into-carshirakoenigmtrainingmuenstermugivestbytomakomai" +
	"baramuikamogawamukochikushinonsenergymulhouseoullensvangmulticho" +
	"icemunakatanemuncieszynmuosattemupassenger-associationmurmanskon" +
	"injamisonymurotorcraftrentinoa-adigemusashimurayamatsuuramusashi" +
	"noharamuseetrentinoaadigemuseumverenigingmutsuzawamutuellezajsko" +
	"nskowolapyatigorskomatsushimashikokuchuomyphotoshibaikaliszczytn" +
	"ordkappgmytis-a-bookkeeperminamitanephilatelyphilipsyphoenixn--3" +
	"0rr7yphotographysiopiagetmyipaviancapitalpictetrentinoaltoadigep" +
	"icturesirdalpiemontepilotslupskonsulatrobelgorodeopinkonyvelolku" +
	"szpartshishikuis-a-techietis-a-socialistmeincheonpippupiszpittsb" +
	"urghofauskedsmokorsetagayasells-for-lesschulepiwatepizzapkooris-" +
	"a-therapistoiaplanetariuminamiuonumatsumotofukeplantationplantsn" +
	"oasaintlouis-a-bruinsfansnzplatforminamiyamashirokawanabellunord" +
	"re-landplaystationplazaplchonanbuildingrondarplomzansimagichosei" +
	"kakegawawhoswhokksundyroyrvikingrongaplumbingoplusterpmnpodzonep" +
	"ohlpokerpokrovskopervikomforbambleborkarpaczeladz-2polkowicepolt" +
	"avalle-d-aostavangerpomorzeszowitdkoryolasitepordenonepornporsan" +
	"gerporsangugeporsgrunnanpoznanprdpreservationpresidioprimeiwamat" +
	"sumaebashikshacknetrentinos-tirolprincipeprivneprochowiceproduct" +
	"ionsokanraprofermobilyprojectrentinostirolpromombetsupplypropert" +
	"yprotectionpruszkowithgoogleapisa-hockeynutrentinosud-tirolprzew" +
	"orskogptzpvtrentinosudtirolpzqldqponqslgbtrentinosued-tirolsrlsr" +
	"varoystoragestordalstorenburgstorfjordstpetersburgstudiostudyndn" +
	"s-blogdnsolarssonstuff-4-salestuttgartrentoshimasurgutsiracusait" +
	"amatsukuris-into-cartoonshiranukannamiharusurnadalsurreysusakis-" +
	"into-gameshiraois-a-soxfansusonosuzakanumazurysuzukanzakiwiensuz" +
	"ukis-leetrentino-alto-adigesvalbardudinkamakurazakinkobayashikao" +
	"irmincommbankomonosveiosvelvikosaigawasvizzeraswedenswidnicarbon" +
	"ia-iglesias-carboniaiglesiascarboniaswiebodzindianapolis-a-blogg" +
	"erswinoujscienceandhistoryswisshikis-lostfoldsxn--32vp30hagakhan" +
	"amigawatuis-not-certifiedunetflixiltulaquilarvikoseis-an-account" +
	"antshioyameldaltunesologneturystykarasjoksnesolundtuscanytushuma" +
	"nitiesolutionsokndaltuvalle-daostavernversicherungvestfoldvestne" +
	"somnarashinovestre-slidreamhostersoovestre-totennishiawakuravest" +
	"vagoyvevelstadvibo-valentiavibovalentiavideovillaskvolloabathsbc" +
	"ngvinnicargojomediavinnytsiavipsinaappharmacymruovatrentinoalto-" +
	"adigevirginiavirtualvirtuelvistaprinternationalfirearmsopotrenti" +
	"nosuedtirolviterboltrevisohuissier-justicevladikavkazanvladimirv" +
	"ladivostokaizukaratevlogvoldavolgogradvolkenkunderseaportroandin" +
	"osaurepbodyndns-at-workinggroupharmaciensimple-urlvolkswagentsor" +
	"-odalvologdanskoshunantokamachippubetsubetsugaruvolyngdalvoronez" +
	"hytomyrvossevangenvotevotingvotottoris-savedvrnwroclawloclawekos" +
	"tromahabororoskolelwtchoyodobashibuyachiyodawtferrarawuozuwwwrit" +
	"esthisblogspotrogstadwzmiuwajimaxn--3pxu8kosugexn--42c2d9axn--45" +
	"brj9christmasakimobetsuwanouchikuseihichisobetsuitaitogakushimot" +
	"oganewhampshirecreationissedalutskaufenisshinguernseyxn--45q11ch" +
	"romedicaltanissettaiwanairforceoxn--4gbriminingxn--4it168dxn--4i" +
	"t797kotohiradomainsureisenxn--4pvxsor-varangerxn--54b7fta0cchtra" +
	"eumtgeradeatnurembergrossetouchijiwadell-ogliastrakhanawaxn--55q" +
	"w42gxn--55qx5dxn--5js045dxn--5rtp49chungbukautokeinoxn--5rtq34ko" +
	"touraxn--5tzm5gxn--6btw5axn--6frz82gxn--6orx2rxn--6qq986b3xlxn--" +
	"7t0a264chungnamdalseidfjordxn--80adxhksorfoldxn--80ao21axn--80as" +
	"ehdbargainstituteledatabaseballooningjerdrumemorialimitedownload" +
	"rangedalimoliserniaustraliaisondre-landebudejjuedischesapeakebay" +
	"erndigitalillehammerfest-mon-blogueurovisionasushiobaragrinetban" +
	"kz-1kappleangaviikadenaamesjevuemielnoboribetsucks3-ap-northeast" +
	"-1xn--80aswgxn--80audnedalnxn--8ltr62kouhokutamakizunokunimilano" +
	"xn--8pvr4uxn--8y0a063axn--90a3academykolaivanovosibirskiervaapst" +
	"eiermarkhangelskinderoyerimo-i-ranadexchangeiseiroumuenchendofth" +
	"einternetcimdbarreauctionaturbruksgymnaturhistorischesakuraibiga" +
	"waustrheimatunduhrennesoyokoze164xn--90aishobaraxn--90azhagebost" +
	"adxn--9dbhblg6diethnologyxn--9dbq2axn--9et52uxn--9krt00axn--andy" +
	"-iraxn--aroport-byanagawaxn--asky-iraxn--aurskog-hland-jnbarrel-" +
	"of-knowledgeorgiauthordalandroidiscountysvardonnaharimamurogawag" +
	"roks-theaternidds3-ap-southeast-1xn--avery-yuasakatakazakis-slic" +
	"komaganexn--b-5gaxn--b4w605ferdxn--bck1b9a5dre4churchaseljejuego" +
	"shikiminokamoenaircraftmpamperedchefarmsteadxn--bdddj-mrabdxn--b" +
	"earalvhki-y4axn--berlevg-jxaxn--bhcavuotna-s4axn--bhccavuotna-k7" +
	"axn--bidr-5nachikatsuuraxn--bievt-0qaxn--bjarky-fyanaizuxn--bjdd" +
	"ar-ptambovdonskoshimizumakiyosumitakaginozawaonsenxn--blt-elabor" +
	"xn--bmlo-graingerxn--bod-2naroyxn--brnny-wuaccident-investigatio" +
	"njukudoyamaceratabuseat-band-campaniamallamadridvagsoygardenebak" +
	"keshibechambagricaaarborteaches-yogasawaracingxn--brnnysund-m8ac" +
	"cident-preventionlineat-urlxn--brum-voagatromsaitokorozawaxn--bt" +
	"sfjord-9zaxn--c1avgxn--c2br7gxn--c3s14misakis-foundationxn--cck2" +
	"b3barrell-of-knowledgets-itarumizusawautomotivelandiscoveryokami" +
	"kawanehonbetsuruokaluganskarmoyomitanobihirosakikamijimakunecn-n" +
	"orth-1xn--cg4bkis-uberleetrentino-altoadigexn--ciqpnxn--clchc0ea" +
	"0b2g2a9gcdn77-securecipesaro-urbino-pesarourbinopesaromalvikouno" +
	"sumypetshisognexn--comunicaes-v6a2oxn--correios-e-telecomunicaes" +
	"-ghc29axn--czr694bashkiriautoscanadagestangeologyonabarudmurtiam" +
	"usementargibestadevenes3-ap-southeast-2xn--czrs0tromsojavald-aos" +
	"tarostwodzislawiwatsukiyonowtvbarefootballangenoamishirasatobish" +
	"imaizurubtsovskjervoyageometre-experts-comptablesakuragawaustinn" +
	"aspers3-external-1xn--czru2dxn--czrw28basilicataniaveroykenviron" +
	"mentalconservationaturalhistorymuseumcentereportarnobrzegjemnes3" +
	"-external-2xn--d1acj3batochigiftsakyotanabeneventochiokinoshimal" +
	"opolskanlandrivefsncfagebizenakaniikawatanaguravocatanzarowebhop" +
	"agespeedmobilizerobirasnesoddenmarketplace-burggfamilyokosukariy" +
	"akumodumemerck-uralsk12xn--d1alferreroticanonoichikawamisatodayx" +
	"n--d1atrusteexn--d5qv7z876chuvashiaxn--davvenjrga-y4axn--djrs72d" +
	"6uyxn--djty4kouyamasoyxn--dnna-grajeworldxn--drbak-wuaxn--dyry-i" +
	"raxn--eckvdtc9dxn--efvn9sorreisahayakawakamiichikaiseiyokoshibah" +
	"ikariwanumataketomisatokyotangoxn--efvy88haibarakitahatakanezawa" +
	"xn--ehqz56nxn--elqq16hakatanotogawaxn--estv75gxn--eveni-0qa01gax" +
	"n--f6qx53axn--fct429kouzushimassa-carrara-massacarraramassabuske" +
	"rudineustarhubarclaycards3-us-west-1xn--fhbeiarnxn--finny-yuaxn-" +
	"-fiq228c5hsortlandxn--fiq64batsfjordrobaknoluoktainaibetsubameri" +
	"canartanddesignieznogatagajobojibmdunloppacificarriereviewskrako" +
	"weddingjerstadotsurugimetlifeinsurancehimejiinetatamotorsalangen" +
	"atuurwetenschappenaumburgjesdalindaskoyabenorddalindesnesalatata" +
	"rstanaustdalinkaruizawavoues3-fips-us-gov-west-1xn--fiqs8sorumin" +
	"anoxn--fiqz9southcarolinazawaxn--fjord-lraxn--fjq720axn--fl-ziax" +
	"n--flor-jraxn--flw351exn--fpcrj9c3dxn--frde-grandrapidsouthwestf" +
	"alenxn--frna-woarais-very-badaddjamalborkdalxn--frya-hraxn--fzc2" +
	"c9e2circlegnicahcesuolocalhistoryazannefrankfurtoyokawaxn--fzys8" +
	"d69uvgmailxn--g2xx48circusculturedumbrellajollanbibaidarq-axn--g" +
	"ckr3f0fetsundxn--gecrj9citicateringebuildersvpalmspringsakerxn--" +
	"ggaviika-8ya47hakodatemasekmshimosuwalkis-a-linux-useranishiarit" +
	"abashijonawatextilevangerxn--gildeskl-g0axn--givuotna-8yandexhib" +
	"itionxn--gjvik-wuaxn--gls-elacaixaxn--gmq050is-very-evillagexn--" +
	"gmqw5axn--h-2failxn--h1aeghakonexn--h2brj9civilaviationiyodogawa" +
	"xn--hbmer-xqaxn--hcesuolo-7ya35bauhaustevollinzaiitatebayashiiba" +
	"hcavuotnagarakkestadupontariobninskarumaifareastcoastaldefencemb" +
	"roideryonagoyaxastronomyokohamamatsudaegubs3-eu-central-1xn--her" +
	"y-iraxn--hgebostad-g3axn--hmmrfeasta-s4acoachampionshiphopenair-" +
	"surveillancebetsukubabia-goracleaningatlantachikawakayamagadance" +
	"chirealtorlandxn--hnefoss-q1axn--hobl-iraxn--holtlen-hxaxn--hpmi" +
	"r-xqaxn--hxt814exn--hyanger-q1axn--hylandet-54axn--i1b6b1a6a2exn" +
	"--imr513nxn--indery-fyaotsurgeryxn--io0a7is-very-goodyearthadsel" +
	"fipirangaxn--j1aefgulenxn--j1amhakubanxn--j6w193gxn--jlq61u9w7bb" +
	"cartierhcloudcontrolappalanakhodkanagawaxn--jlster-byaroslavlaan" +
	"derenxn--jrpeland-54axn--jvr189misasaguris-gonexn--k7yn95exn--ka" +
	"rmy-yuaxn--kbrq7oxn--kcrx77d1x4axn--kfjord-iuaxn--klbu-woaxn--kl" +
	"t787dxn--kltp7dxn--kltx9axn--klty5xn--3bst00minnesotaketakatoris" +
	"-certifieducatorahimeshimageandsoundandvisionxn--koluokta-7ya57h" +
	"akuis-a-llamarylhursteinkjerusalembetsukuis-a-musicianxn--kprw13" +
	"dxn--kpry57dxn--kpu716figuerestaurantoyotaris-a-doctorayxn--kput" +
	"3is-very-nicexn--krager-gyasakaiminatoursowaxn--kranghke-b0axn--" +
	"krdsherad-m8axn--krehamn-dxaxn--krjohka-hwab49jetztrentino-stiro" +
	"lxn--ksnes-uuaxn--kvfjord-nxaxn--kvitsy-fyasugis-very-sweetrenti" +
	"no-s-tirollagriculturennebudapest-a-la-maisondriodejaneirocheste" +
	"rxn--kvnangen-k0axn--l-1fairwindspreadbettingxn--l1accentureklam" +
	"borghinikkoebenhavnxn--laheadju-7yasuokaratsuginamikatagamihobby" +
	"-sitevaksdalxn--langevg-jxaxn--lcvr32dxn--ldingen-q1axn--leagavi" +
	"ika-52bbvacationsnasabaerobaticketsalondonetskasaokamisatohnosho" +
	"oceanographicsaltdalipetskashibatakashimasfjordenaval-d-aosta-va" +
	"lleyonagunikolaeventsalvadordalibabajddarchaeologyeongnamegawakk" +
	"anaikawababydgoszczecinemailivornoceanographiquemergencyberlevag" +
	"angaviikarugaulardalorenskogjovikashiharaxn--lesund-huaxn--lgbba" +
	"t1ad8jevnakerxn--lgrd-poacivilisationrwifarsundxn--lhppi-xqaxn--" +
	"linds-pratoyakokamishihoronobeokaminoyamatsuris-with-thebandoomd" +
	"nsaliascolipicenord-odalxn--lns-qlavagiskexn--loabt-0qaxn--lrdal" +
	"-sraxn--lrenskog-54axn--lt-liacivilizationxn--lten-granexn--lury" +
	"-iraxn--mely-iraxn--merker-kuaxn--mgb2ddespydebergxn--mgb9awbfil" +
	"ateliaxn--mgba3a3ejtrvchoshibukawaxn--mgba3a4f16axn--mgba3a4fran" +
	"amizuholdingsmileksvikozagawaxn--mgba7c0bbn0axn--mgbaam7a8hakusa" +
	"ndoyxn--mgbab2bdxn--mgbai9a5eva00beppubolognagasukesennumalselve" +
	"ndrelloteneiiyamanobedzin-addrammenuernberglassassinationalherit" +
	"agematsubarakawachinaganoharaogashimadachicagoboatsalzburgliwice" +
	"mrxn--mgbai9azgqp6jewelryxn--mgbayh7gpaduaxn--mgbb9fbpobanazawax" +
	"n--mgbbh1a71exn--mgbc0a9azcgxn--mgberp4a5d4a87gxn--mgberp4a5d4ar" +
	"xn--mgbpl2fhvalerxn--mgbqly7c0a67fbcivilwarmanagementoyonakagyok" +
	"utomobentleyxn--mgbqly7cvafranziskanerimarinextdirectoryxn--mgbt" +
	"3dhdxn--mgbtf8flatangerxn--mgbtx2bernrtateshinanomachintaijindus" +
	"triesteambulancepilepsykkylvenetogliattipschoenbrunnavigationavu" +
	"otnakayamatsuzakinfinitiresamegawaxn--mgbx4cd0abogadocscbgxn--mi" +
	"x082filminamifuranoxn--mix891finalxn--mjndalen-64axn--mk0axindia" +
	"nmarketingxn--mk1bu44claimsaskatchewanggouvicenzaxn--mkru45isleo" +
	"fmandalxn--mlatvuopmi-s4axn--mli-tlavangenxn--mlselv-iuaxn--more" +
	"ke-juaxn--mori-qsakegawaxn--mosjen-eyatominamiawajikissmartertha" +
	"nyoutubeeldengeluidxn--mot-tlazioxn--mre-og-romsdal-qqbeskidyn-o" +
	"-saurlandesamnangerxn--msy-ula0haldenxn--mtta-vrjjat-k7aflakstad" +
	"aokagakibichuoxn--muost-0qaxn--mxtq1misawaxn--ngbc5azdxn--ngbe9e" +
	"0axn--nit225kozakis-an-actorxn--nmesjevuemie-tcbalatinabearalvah" +
	"kikonaioirasebastopologyeonggiehtavuoatnagaivuotnagaokakyotambad" +
	"ajozorahkkeravjudygarlandxn--nnx388axn--nodessakuhokkaidontexist" +
	"eingeekpnxn--nqv7fs00emaxn--nry-yla5gxn--ntso0iqx3axn--ntsq17gxn" +
	"--nttery-byaeserveftphiladelphiaareadmyblogsitexn--nvuotna-hwaxn" +
	"--nyqy26axn--o1achattanooganorfolkebiblegallocuscountryestateofd" +
	"elawarezzoologyxn--o3cw4halsagamiharaxn--od0algxn--od0aq3betaina" +
	"boxfordealerdalottepsongdalenviknakanojohanamakinoharaxn--ogbpf8" +
	"flekkefjordxn--oppegrd-ixaxn--ostery-fyatsukareliancexn--osyro-w" +
	"uaxn--p1acfdxn--p1aiwchitosetoeiheijis-a-chefarmerseinewspaperxn" +
	"--pbt977clickazimierz-dolnyxn--pgbs0dhammarfeastafricamagicherno" +
	"vtsydneyxn--porsgu-sta26financexn--pssu33lxn--pssy2uxn--q9jyb4cl" +
	"inicoffeedbackazoxn--qcka1pmclintonoshoesassaris-a-cubicle-slave" +
	"llinowruzhgorodoyxn--qqqt11misconfusedxn--qxamurskjakdnepropetro" +
	"vskiptveterinairealtychyllestadultrysilkosakaerodromegallupinbar" +
	"celonagasakikuchikumagayagawalbrzycharternopilawalesundnpalacebi" +
	"northwesternmutualimanowarudaurskog-holandroverhalla-speziaetnag" +
	"ahamaroyekaterinburgdyniaeroportalaheadjudaicabbottarantomaritim" +
	"ekeeping12000xn--rady-iraxn--rdal-poaxn--rde-ulaxn--rdy-0nabarix" +
	"n--rennesy-v1axn--rhkkervju-01afineartschwarzgwangjuifminamiisel" +
	"ectoyotomiyazakis-a-financialadvisor-aurdalxn--rholt-mragoworse-" +
	"thandsoniizaxn--rhqv96gxn--rht27zxn--rht3dxn--rht61exn--risa-5na" +
	"rusawaxn--risr-iraxn--rland-uuaxn--rlingen-mxaxn--rmskog-byatsus" +
	"hiroxn--rny31hamurakamigoriginankokubunjis-a-nascarfanxn--rovu88" +
	"bhartiffanycartoonarteducationalchikugokasejnyoriikashiwaraxn--r" +
	"ros-granvindafjordxn--rskog-uuaxn--rst-0narutokonamegatakatsukix" +
	"n--rsta-francaiseharaxn--ryken-vuaxn--ryrvik-byawaraxn--s-1faith" +
	"eguardianxn--s9brj9clothingroundhandlingroznyxn--sandnessjen-ogb" +
	"izhevskppspiegelxn--sandy-yuaxn--seral-lraxn--ses554gxn--sgne-gr" +
	"atangenxn--skierv-utazasmatartcenterprisesakievenassisibenikihok" +
	"umakogenglandxn--skjervy-v1axn--skjk-soaxn--sknit-yqaxn--sknland" +
	"-fxaxn--slat-5narviikananporoxn--slt-elabourxn--smla-hraxn--smna" +
	"-gratis-a-bulls-fanxn--snase-nraxn--sndre-land-0cbremangerxn--sn" +
	"es-poaxn--snsa-roaxn--sr-aurdal-l8axn--sr-fron-q1axn--sr-odal-q1" +
	"axn--sr-varanger-ggbielawallonieruchomoscienceandindustrynavyatk" +
	"anazawaxn--srfold-byawatahamaxn--srreisa-q1axn--srum-grazxn--stf" +
	"old-9xaxn--stjrdal-s1axn--stjrdalshalsen-sqbiellaakesvuemielecce" +
	"verbankashiwazakiyokawaraxn--stre-toten-zcbieszczadygeyachimatai" +
	"peigersundurbanpachigasakicks-assedicasadelamonedaxn--t60b56axn-" +
	"-tckweatherchannelxn--tjme-hraxn--tn0agrigentomologyeongbukrasno" +
	"darxn--tnsberg-q1axn--tor131oxn--trany-yuaxn--trgstad-r1axn--trn" +
	"a-woaxn--troms-zuaxn--tysvr-vraxn--uc0atverranzanxn--uc0ay4axn--" +
	"uist22hangglidingxn--uisz3gxn--unjrga-rtaobaomoriguchiharamcoalx" +
	"n--unup4yxn--uuwu58axn--vads-jraxn--vard-jraxn--vegrshei-c0axn--" +
	"vermgensberater-ctbievattorneyagawakuyabukijoburglobalashovhachi" +
	"jorpelandurhamburglobodoes-itateyamaxn--vermgensberatung-pwbifuk" +
	"agawalterxn--vestvgy-ixa6oxn--vg-yiabruzzoologicalabamagasakishi" +
	"mabaragusartsaritsynxn--vgan-qoaxn--vgsy-qoa0jewishartrentino-su" +
	"d-tirolxn--vgu402cloudcontrolledekakudamatsuenoharaxn--vhquversa" +
	"illesomaxn--vler-qoaxn--vre-eiker-k8axn--vrggt-xqadxn--vry-yla5g" +
	"xn--vuq861bihorologyukuhashimoichinosekigaharaxn--w4r85el8fhu5dn" +
	"raxn--wcvs22dxn--wgbh1cloudfrontdoorxn--wgbl6axn--xhq521bikedati" +
	"nglogowegroweibolzanordreisa-geekasukabeerxn--xkc2al3hye2axn--xk" +
	"c2dl3a5ee0hangoutsystemscloudapparmaxn--y9a3aquariumishimatsunox" +
	"n--yer-znarvikrasnoyarskomitamamuraxn--yfro4i67oxn--ygarden-p1ax" +
	"n--ygbi2ammxn--3ds443gxn--ystre-slidre-ujbilbaogakidstvedestrand" +
	"vrdnsamsungloppenzaokinawashirosatobamagazinedre-eikerxn--zbx025" +
	"dxn--zf0ao64axn--zf0avxn--3e0b707exn--zfr164billustrationayorodd" +
	"axperiaxxxn--3oq18vl8pn36axz"

// nodes is the list of nodes. Each node is represented as a uint32, which
// encodes the node's children, wildcard bit and node type (as an index into
// the children array), ICANN bit and text.
//
// In the //-comment after each node's data, the nodes indexes of the children
// are formatted as (n0x1234-n0x1256), with * denoting the wildcard bit. The
// nodeType is printed as + for normal, ! for exception, and o for parent-only
// nodes that have children but don't match a domain label in their own right.
// An I denotes an ICANN domain.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 9 bits] children index
//	[ 1 bits] ICANN bit
//	[15 bits] text index
//	[ 6 bits] text length
var nodes = [...]uint32{
	0x00301443, // n0x0000 c0x0000 (---------------)  + I aaa
	0x002293c4, // n0x0001 c0x0000 (---------------)  + I aarp
	0x0036eb43, // n0x0002 c0x0000 (---------------)  + I abb
	0x0036eb46, // n0x0003 c0x0000 (---------------)  + I abbott
	0x0030cb04, // n0x0004 c0x0000 (---------------)  + I able
	0x00355b87, // n0x0005 c0x0000 (---------------)  + I abogado
	0x01a01e82, // n0x0006 c0x0006 (n0x0539-n0x053f)  + I ac
	0x002f2787, // n0x0007 c0x0000 (---------------)  + I academy
	0x0033dcc9, // n0x0008 c0x0000 (---------------)  + I accenture
	0x002d7e4a, // n0x0009 c0x0000 (---------------)  + I accountant
	0x002d7e4b, // n0x000a c0x0000 (---------------)  + I accountants
	0x00221483, // n0x000b c0x0000 (---------------)  + I aco
	0x0027d3c6, // n0x000c c0x0000 (---------------)  + I active
	0x00226f45, // n0x000d c0x0000 (---------------)  + I actor
	0x01e10a02, // n0x000e c0x0007 (n0x053f-n0x0540)  + I ad
	0x00262ac3, // n0x000f c0x0000 (---------------)  + I ads
	0x0036b745, // n0x0010 c0x0000 (---------------)  + I adult
	0x02204342, // n0x0011 c0x0008 (n0x0540-n0x0548)  + I ae
	0x003285c3, // n0x0012 c0x0000 (---------------)  + I aeg
	0x026751c4, // n0x0013 c0x0009 (n0x0548-n0x05a1)  + I aero
	0x0036de85, // n0x0014 c0x0000 (---------------)  + I aetna
	0x02a0c702, // n0x0015 c0x000a (n0x05a1-n0x05a6)  + I af
	0x0023a2c3, // n0x0016 c0x0000 (---------------)  + I afl
	0x00367c06, // n0x0017 c0x0000 (---------------)  + I africa
	0x00367c0b, // n0x0018 c0x0000 (---------------)  + I africamagic
	0x02e015c2, // n0x0019 c0x000b (n0x05a6-n0x05ab)  + I ag
	0x002d6e47, // n0x001a c0x0000 (---------------)  + I agakhan
	0x00229d46, // n0x001b c0x0000 (---------------)  + I agency
	0x032002c2, // n0x001c c0x000c (n0x05ab-n0x05af)  + I ai
	0x0024ef43, // n0x001d c0x0000 (---------------)  + I aig
	0x002e75c8, // n0x001e c0x0000 (---------------)  + I airforce
	0x00273406, // n0x001f c0x0000 (---------------)  + I airtel
	0x0036acc4, // n0x0020 c0x0000 (---------------)  + I akdn
	0x03600882, // n0x0021 c0x000d (n0x05af-n0x05b6)  + I al
	0x00342747, // n0x0022 c0x0000 (---------------)  + I alibaba
	0x002ab4c6, // n0x0023 c0x0000 (---------------)  + I alipay
	0x002a6589, // n0x0024 c0x0000 (---------------)  + I allfinanz
	0x0029c184, // n0x0025 c0x0000 (---------------)  + I ally
	0x00215bc6, // n0x0026 c0x0000 (---------------)  + I alsace
	0x03a04942, // n0x0027 c0x000e (n0x05b6-n0x05b7)  + I am
	0x0027d885, // n0x0028 c0x0000 (---------------)  + I amica
	0x002b6cc9, // n0x0029 c0x0000 (---------------)  + I amsterdam
	0x03e01242, // n0x002a c0x000f (n0x05b7-n0x05bb)  + I an
	0x0022f449, // n0x002b c0x0000 (---------------)  + I analytics
	0x002f8647, // n0x002c c0x0000 (---------------)  + I android
	0x00295a46, // n0x002d c0x0000 (---------------)  + I anquan
	0x0420fd82, // n0x002e c0x0010 (n0x05bb-n0x05c1)  + I ao
	0x0028df8a, // n0x002f c0x0000 (---------------)  + I apartments
	0x00212a03, // n0x0030 c0x0000 (---------------)  + I app
	0x002f0145, // n0x0031 c0x0000 (---------------)  + I apple
	0x00273fc2, // n0x0032 c0x0000 (---------------)  + I aq
	0x00273fc9, // n0x0033 c0x0000 (---------------)  + I aquarelle
	0x04600602, // n0x0034 c0x0011 (n0x05c1-n0x05ca)  + I ar
	0x00387dc6, // n0x0035 c0x0000 (---------------)  + I aramco
	0x0025dd45, // n0x0036 c0x0000 (---------------)  + I archi
	0x00333fc4, // n0x0037 c0x0000 (---------------)  + I army
	0x04e29404, // n0x0038 c0x0013 (n0x05cb-n0x05d1)  + I arpa
	0x00359e04, // n0x0039 c0x0000 (---------------)  + I arte
	0x05200182, // n0x003a c0x0014 (n0x05d1-n0x05d2)  + I as
	0x00209144, // n0x003b c0x0000 (---------------)  + I asia
	0x002729ca, // n0x003c c0x0000 (---------------)  + I associates
	0x05601642, // n0x003d c0x0015 (n0x05d2-n0x05d9)  + I at
	0x00389588, // n0x003e c0x0000 (---------------)  + I attorney
	0x05e05ac2, // n0x003f c0x0017 (n0x05da-n0x05ec)  + I au
	0x002f4487, // n0x0040 c0x0000 (---------------)  + I auction
	0x00222244, // n0x0041 c0x0000 (---------------)  + I audi
	0x00251707, // n0x0042 c0x0000 (---------------)  + I audible
	0x00222245, // n0x0043 c0x0000 (---------------)  + I audio
	0x002f8406, // n0x0044 c0x0000 (---------------)  + I author
	0x002eaac4, // n0x0045 c0x0000 (---------------)  + I auto
	0x00309645, // n0x0046 c0x0000 (---------------)  + I autos
	0x002c0747, // n0x0047 c0x0000 (---------------)  + I avianca
	0x06e02502, // n0x0048 c0x001b (n0x05fa-n0x05fb)  + I aw
	0x00272583, // n0x0049 c0x0000 (---------------)  + I aws
	0x00215282, // n0x004a c0x0000 (---------------)  + I ax
	0x0032b343, // n0x004b c0x0000 (---------------)  + I axa
	0x07208cc2, // n0x004c c0x001c (n0x05fb-n0x0607)  + I az
	0x0026c905, // n0x004d c0x0000 (---------------)  + I azure
	0x07605a82, // n0x004e c0x001d (n0x0607-n0x0612)  + I ba
	0x00343204, // n0x004f c0x0000 (---------------)  + I baby
	0x0026a085, // n0x0050 c0x0000 (---------------)  + I baidu
	0x00255704, // n0x0051 c0x0000 (---------------)  + I band
	0x00235dc4, // n0x0052 c0x0000 (---------------)  + I bank
	0x0020c103, // n0x0053 c0x0000 (---------------)  + I bar
	0x0036bf49, // n0x0054 c0x0000 (---------------)  + I barcelona
	0x0031934b, // n0x0055 c0x0000 (---------------)  + I barclaycard
	0x002afe08, // n0x0056 c0x0000 (---------------)  + I barclays
	0x0030b788, // n0x0057 c0x0000 (---------------)  + I barefoot
	0x002ed0c8, // n0x0058 c0x0000 (---------------)  + I bargains
	0x003297c7, // n0x0059 c0x0000 (---------------)  + I bauhaus
	0x002eef46, // n0x005a c0x0000 (---------------)  + I bayern
	0x07a791c2, // n0x005b c0x001e (n0x0612-n0x061c)  + I bb
	0x00331f83, // n0x005c c0x0000 (---------------)  + I bbc
	0x00340184, // n0x005d c0x0000 (---------------)  + I bbva
	0x0028bfc3, // n0x005e c0x0000 (---------------)  + I bcg
	0x002dbf83, // n0x005f c0x0000 (---------------)  + I bcn
	0x016fbc02, // n0x0060 c0x0005 (---------------)* o I bd
	0x07e04702, // n0x0061 c0x001f (n0x061c-n0x061e)  + I be
	0x00243505, // n0x0062 c0x0000 (---------------)  + I beats
	0x00391984, // n0x0063 c0x0000 (---------------)  + I beer
	0x00352147, // n0x0064 c0x0000 (---------------)  + I bentley
	0x00251d46, // n0x0065 c0x0000 (---------------)  + I berlin
	0x0030a2c4, // n0x0066 c0x0000 (---------------)  + I best
	0x00227703, // n0x0067 c0x0000 (---------------)  + I bet
	0x08349f02, // n0x0068 c0x0020 (n0x061e-n0x061f)  + I bf
	0x08755e02, // n0x0069 c0x0021 (n0x061f-n0x0644)  + I bg
	0x08af6202, // n0x006a c0x0022 (n0x0644-n0x0649)  + I bh
	0x00375006, // n0x006b c0x0000 (---------------)  + I bharti
	0x08e00002, // n0x006c c0x0023 (n0x0649-n0x064e)  + I bi
	0x003628c5, // n0x006d c0x0000 (---------------)  + I bible
	0x002fd143, // n0x006e c0x0000 (---------------)  + I bid
	0x00390e04, // n0x006f c0x0000 (---------------)  + I bike
	0x002c7a44, // n0x0070 c0x0000 (---------------)  + I bing
	0x002c7a45, // n0x0071 c0x0000 (---------------)  + I bingo
	0x00200003, // n0x0072 c0x0000 (---------------)  + I bio
	0x09310603, // n0x0073 c0x0024 (n0x064e-n0x0655)  + I biz
	0x09602642, // n0x0074 c0x0025 (n0x0655-n0x0659)  + I bj
	0x00277b85, // n0x0075 c0x0000 (---------------)  + I black
	0x00277b8b, // n0x0076 c0x0000 (---------------)  + I blackfriday
	0x002d0084, // n0x0077 c0x0000 (---------------)  + I blog
	0x00205849, // n0x0078 c0x0000 (---------------)  + I bloomberg
	0x00207184, // n0x0079 c0x0000 (---------------)  + I blue
	0x09a09242, // n0x007a c0x0026 (n0x0659-n0x065e)  + I bm
	0x00209243, // n0x007b c0x0000 (---------------)  + I bms
	0x0020a103, // n0x007c c0x0000 (---------------)  + I bmw
	0x0160a282, // n0x007d c0x0005 (---------------)* o I bn
	0x00243903, // n0x007e c0x0000 (---------------)  + I bnl
	0x0020a28a, // n0x007f c0x0000 (---------------)  + I bnpparibas
	0x09e0a702, // n0x0080 c0x0027 (n0x065e-n0x0667)  + I bo
	0x0034eb85, // n0x0081 c0x0000 (---------------)  + I boats
	0x0020aac3, // n0x0082 c0x0000 (---------------)  + I bom
	0x0020b104, // n0x0083 c0x0000 (---------------)  + I bond
	0x0020c2c3, // n0x0084 c0x0000 (---------------)  + I boo
	0x0020c2c5, // n0x0085 c0x0000 (---------------)  + I boots
	0x0020cb05, // n0x0086 c0x0000 (---------------)  + I bosch
	0x0020d286, // n0x0087 c0x0000 (---------------)  + I bostik
	0x0020e2c3, // n0x0088 c0x0000 (---------------)  + I bot
	0x00211048, // n0x0089 c0x0000 (---------------)  + I boutique
	0x0a212e82, // n0x008a c0x0028 (n0x0667-n0x06ad)  + I br
	0x00212e88, // n0x008b c0x0000 (---------------)  + I bradesco
	0x0021a14b, // n0x008c c0x0000 (---------------)  + I bridgestone
	0x002172c8, // n0x008d c0x0000 (---------------)  + I broadway
	0x00218046, // n0x008e c0x0000 (---------------)  + I broker
	0x00219347, // n0x008f c0x0000 (---------------)  + I brother
	0x0021be88, // n0x0090 c0x0000 (---------------)  + I brussels
	0x0aa35102, // n0x0091 c0x002a (n0x06ae-n0x06b3)  + I bs
	0x0ae16fc2, // n0x0092 c0x002b (n0x06b3-n0x06b8)  + I bt
	0x0033c648, // n0x0093 c0x0000 (---------------)  + I budapest
	0x002c67c5, // n0x0094 c0x0000 (---------------)  + I build
	0x00324908, // n0x0095 c0x0000 (---------------)  + I builders
	0x0025f008, // n0x0096 c0x0000 (---------------)  + I business
	0x0021d903, // n0x0097 c0x0000 (---------------)  + I buy
	0x0021e484, // n0x0098 c0x0000 (---------------)  + I buzz
	0x003401c2, // n0x0099 c0x0000 (---------------)  + I bv
	0x0b21f782, // n0x009a c0x002c (n0x06b8-n0x06ba)  + I bw
	0x0b616b42, // n0x009b c0x002d (n0x06ba-n0x06be)  + I by
	0x0be203c2, // n0x009c c0x002f (n0x06bf-n0x06c5)  + I bz
	0x002203c3, // n0x009d c0x0000 (---------------)  + I bzh
	0x0c2055c2, // n0x009e c0x0030 (n0x06c5-n0x06d6)  + I ca
	0x0036eb03, // n0x009f c0x0000 (---------------)  + I cab
	0x0026ab84, // n0x00a0 c0x0000 (---------------)  + I cafe
	0x0020e443, // n0x00a1 c0x0000 (---------------)  + I cal
	0x002a6544, // n0x00a2 c0x0000 (---------------)  + I call
	0x0022b406, // n0x00a3 c0x0000 (---------------)  + I camera
	0x0022c604, // n0x00a4 c0x0000 (---------------)  + I camp
	0x0029668e, // n0x00a5 c0x0000 (---------------)  + I cancerresearch
	0x00312a05, // n0x00a6 c0x0000 (---------------)  + I canon
	0x0021aac8, // n0x00a7 c0x0000 (---------------)  + I capetown
	0x002c0887, // n0x00a8 c0x0000 (---------------)  + I capital
	0x00205f83, // n0x00a9 c0x0000 (---------------)  + I car
	0x002291c7, // n0x00aa c0x0000 (---------------)  + I caravan
	0x00319505, // n0x00ab c0x0000 (---------------)  + I cards
	0x00205f84, // n0x00ac c0x0000 (---------------)  + I care
	0x00205f86, // n0x00ad c0x0000 (---------------)  + I career
	0x00205f87, // n0x00ae c0x0000 (---------------)  + I careers
	0x002b9384, // n0x00af c0x0000 (---------------)  + I cars
	0x00332007, // n0x00b0 c0x0000 (---------------)  + I cartier
	0x00383904, // n0x00b1 c0x0000 (---------------)  + I casa
	0x00261b04, // n0x00b2 c0x0000 (---------------)  + I cash
	0x002112c6, // n0x00b3 c0x0000 (---------------)  + I casino
	0x0020d0c3, // n0x00b4 c0x0000 (---------------)  + I cat
	0x003246c8, // n0x00b5 c0x0000 (---------------)  + I catering
	0x00235d83, // n0x00b6 c0x0000 (---------------)  + I cba
	0x002438c3, // n0x00b7 c0x0000 (---------------)  + I cbn
	0x0037dc04, // n0x00b8 c0x0000 (---------------)  + I cbre
	0x0c61aa82, // n0x00b9 c0x0031 (n0x06d6-n0x06da)  + I cc
	0x0ca2a082, // n0x00ba c0x0032 (n0x06da-n0x06db)  + I cd
	0x00215cc3, // n0x00bb c0x0000 (---------------)  + I ceb
	0x00233a06, // n0x00bc c0x0000 (---------------)  + I center
	0x002e7743, // n0x00bd c0x0000 (---------------)  + I ceo
	0x0021d7c4, // n0x00be c0x0000 (---------------)  + I cern
	0x0cf104c2, // n0x00bf c0x0033 (n0x06db-n0x06dc)  + I cf
	0x003104c3, // n0x00c0 c0x0000 (---------------)  + I cfa
	0x00366243, // n0x00c1 c0x0000 (---------------)  + I cfd
	0x0020ea02, // n0x00c2 c0x0000 (---------------)  + I cg
	0x0d204a02, // n0x00c3 c0x0034 (n0x06dc-n0x06dd)  + I ch
	0x002a9f06, // n0x00c4 c0x0000 (---------------)  + I chanel
	0x00227d87, // n0x00c5 c0x0000 (---------------)  + I channel
	0x002facc5, // n0x00c6 c0x0000 (---------------)  + I chase
	0x0023a704, // n0x00c7 c0x0000 (---------------)  + I chat
	0x0028dec5, // n0x00c8 c0x0000 (---------------)  + I cheap
	0x00353cc7, // n0x00c9 c0x0000 (---------------)  + I chintai
	0x00297d05, // n0x00ca c0x0000 (---------------)  + I chloe
	0x002e5109, // n0x00cb c0x0000 (---------------)  + I christmas
	0x002e6f86, // n0x00cc c0x0000 (---------------)  + I chrome
	0x002fabc6, // n0x00cd c0x0000 (---------------)  + I church
	0x0d6155c2, // n0x00ce c0x0035 (n0x06dd-n0x06ec)  + I ci
	0x0025f788, // n0x00cf c0x0000 (---------------)  + I cipriani
	0x00322106, // n0x00d0 c0x0000 (---------------)  + I circle
	0x00237905, // n0x00d1 c0x0000 (---------------)  + I cisco
	0x003245c5, // n0x00d2 c0x0000 (---------------)  + I citic
	0x002735c4, // n0x00d3 c0x0000 (---------------)  + I city
	0x002735c8, // n0x00d4 c0x0000 (---------------)  + I cityeats
	0x0da01782, // n0x00d5 c0x0036 (n0x06ec-n0x06ed)* o I ck
	0x0de0af42, // n0x00d6 c0x0037 (n0x06ed-n0x06f2)  + I cl
	0x00357546, // n0x00d7 c0x0000 (---------------)  + I claims
	0x0032d748, // n0x00d8 c0x0000 (---------------)  + I cleaning
	0x00367205, // n0x00d9 c0x0000 (---------------)  + I click
	0x00368f86, // n0x00da c0x0000 (---------------)  + I clinic
	0x003784c8, // n0x00db c0x0000 (---------------)  + I clothing
	0x00332205, // n0x00dc c0x0000 (---------------)  + I cloud
	0x002752c4, // n0x00dd c0x0000 (---------------)  + I club
	0x002752c7, // n0x00de c0x0000 (---------------)  + I clubmed
	0x0e249082, // n0x00df c0x0038 (n0x06f2-n0x06f6)  + I cm
	0x0e6211c2, // n0x00e0 c0x0039 (n0x06f6-n0x0723)  + I cn
	0x0fe00742, // n0x00e1 c0x003f (n0x0728-n0x0735)  + I co
	0x0032ca05, // n0x00e2 c0x0000 (---------------)  + I coach
	0x0028ca05, // n0x00e3 c0x0000 (---------------)  + I codes
	0x003690c6, // n0x00e4 c0x0000 (---------------)  + I coffee
	0x0021e787, // n0x00e5 c0x0000 (---------------)  + I college
	0x002214c7, // n0x00e6 c0x0000 (---------------)  + I cologne
	0x10622ac3, // n0x00e7 c0x0041 (n0x0736-n0x07ff)  + I com
	0x002d4148, // n0x00e8 c0x0000 (---------------)  + I commbank
	0x00222ac9, // n0x00e9 c0x0000 (---------------)  + I community
	0x002232c7, // n0x00ea c0x0000 (---------------)  + I company
	0x002236c8, // n0x00eb c0x0000 (---------------)  + I computer
	0x00223ec6, // n0x00ec c0x0000 (---------------)  + I comsec
	0x00224306, // n0x00ed c0x0000 (---------------)  + I condos
	0x00224c0c, // n0x00ee c0x0000 (---------------)  + I construction
	0x00225a8a, // n0x00ef c0x0000 (---------------)  + I consulting
	0x00225f47, // n0x00f0 c0x0000 (---------------)  + I contact
	0x00226e0b, // n0x00f1 c0x0000 (---------------)  + I contractors
	0x00227bc7, // n0x00f2 c0x0000 (---------------)  + I cooking
	0x00227bce, // n0x00f3 c0x0000 (---------------)  + I cookingchannel
	0x00228384, // n0x00f4 c0x0000 (---------------)  + I cool
	0x00228d44, // n0x00f5 c0x0000 (---------------)  + I coop
	0x0022b2c7, // n0x00f6 c0x0000 (---------------)  + I corsica
	0x00362c07, // n0x00f7 c0x0000 (---------------)  + I country
	0x0022d906, // n0x00f8 c0x0000 (---------------)  + I coupon
	0x0022d907, // n0x00f9 c0x0000 (---------------)  + I coupons
	0x0022dc87, // n0x00fa c0x0000 (---------------)  + I courses
	0x11a0c502, // n0x00fb c0x0046 (n0x081d-n0x0824)  + I cr
	0x00230646, // n0x00fc c0x0000 (---------------)  + I credit
	0x0023064a, // n0x00fd c0x0000 (---------------)  + I creditcard
	0x002308cb, // n0x00fe c0x0000 (---------------)  + I creditunion
	0x002319c7, // n0x00ff c0x0000 (---------------)  + I cricket
	0x00232885, // n0x0100 c0x0000 (---------------)  + I crown
	0x002329c3, // n0x0101 c0x0000 (---------------)  + I crs
	0x00233147, // n0x0102 c0x0000 (---------------)  + I cruises
	0x00355d43, // n0x0103 c0x0000 (---------------)  + I csc
	0x11e24002, // n0x0104 c0x0047 (n0x0824-n0x082a)  + I cu
	0x002333ca, // n0x0105 c0x0000 (---------------)  + I cuisinella
	0x1233f802, // n0x0106 c0x0048 (n0x082a-n0x082b)  + I cv
	0x126b8942, // n0x0107 c0x0049 (n0x082b-n0x082f)  + I cw
	0x12a35882, // n0x0108 c0x004a (n0x082f-n0x0831)  + I cx
	0x12e29e42, // n0x0109 c0x004b (n0x0831-n0x083e)  o I cy
	0x002dcac5, // n0x010a c0x0000 (---------------)  + I cymru
	0x00235b84, // n0x010b c0x0000 (---------------)  + I cyou
	0x13614442, // n0x010c c0x004d (n0x083f-n0x0840)  + I cz
	0x0021bc05, // n0x010d c0x0000 (---------------)  + I dabur
	0x00264503, // n0x010e c0x0000 (---------------)  + I dad
	0x0032dec5, // n0x010f c0x0000 (---------------)  + I dance
	0x00209004, // n0x0110 c0x0000 (---------------)  + I date
	0x00390f06, // n0x0111 c0x0000 (---------------)  + I dating
	0x00207286, // n0x0112 c0x0000 (---------------)  + I datsun
	0x00277d83, // n0x0113 c0x0000 (---------------)  + I day
	0x00251304, // n0x0114 c0x0000 (---------------)  + I dclk
	0x002f9383, // n0x0115 c0x0000 (---------------)  + I dds
	0x13a006c2, // n0x0116 c0x004e (n0x0840-n0x0848)  + I de
	0x002196c4, // n0x0117 c0x0000 (---------------)  + I deal
	0x00364186, // n0x0118 c0x0000 (---------------)  + I dealer
	0x002196c5, // n0x0119 c0x0000 (---------------)  + I deals
	0x002528c6, // n0x011a c0x0000 (---------------)  + I degree
	0x00268948, // n0x011b c0x0000 (---------------)  + I delivery
	0x002297c4, // n0x011c c0x0000 (---------------)  + I dell
	0x0024f885, // n0x011d c0x0000 (---------------)  + I delta
	0x0022e548, // n0x011e c0x0000 (---------------)  + I democrat
	0x00298646, // n0x011f c0x0000 (---------------)  + I dental
	0x00234ec7, // n0x0120 c0x0000 (---------------)  + I dentist
	0x00232f44, // n0x0121 c0x0000 (---------------)  + I desi
	0x00232f46, // n0x0122 c0x0000 (---------------)  + I design
	0x0030a403, // n0x0123 c0x0000 (---------------)  + I dev
	0x002b0cc8, // n0x0124 c0x0000 (---------------)  + I diamonds
	0x002f6384, // n0x0125 c0x0000 (---------------)  + I diet
	0x002ef0c7, // n0x0126 c0x0000 (---------------)  + I digital
	0x00352bc6, // n0x0127 c0x0000 (---------------)  + I direct
	0x00352bc9, // n0x0128 c0x0000 (---------------)  + I directory
	0x002f87c8, // n0x0129 c0x0000 (---------------)  + I discount
	0x0020c7c2, // n0x012a c0x0000 (---------------)  + I dj
	0x13e71742, // n0x012b c0x004f (n0x0848-n0x0849)  + I dk
	0x142618c2, // n0x012c c0x0050 (n0x0849-n0x084e)  + I dm
	0x0036cd83, // n0x012d c0x0000 (---------------)  + I dnp
	0x14604002, // n0x012e c0x0051 (n0x084e-n0x0858)  + I do
	0x00355cc4, // n0x012f c0x0000 (---------------)  + I docs
	0x00204003, // n0x0130 c0x0000 (---------------)  + I dog
	0x0024f044, // n0x0131 c0x0000 (---------------)  + I doha
	0x002e8307, // n0x0132 c0x0000 (---------------)  + I domains
	0x0023ba06, // n0x0133 c0x0000 (---------------)  + I doosan
	0x0031c343, // n0x0134 c0x0000 (---------------)  + I dot
	0x002ede08, // n0x0135 c0x0000 (---------------)  + I download
	0x003102c5, // n0x0136 c0x0000 (---------------)  + I drive
	0x00394cc4, // n0x0137 c0x0000 (---------------)  + I dstv
	0x002482c3, // n0x0138 c0x0000 (---------------)  + I dtv
	0x0026a005, // n0x0139 c0x0000 (---------------)  + I dubai
	0x0031b886, // n0x013a c0x0000 (---------------)  + I dunlop
	0x0032a4c6, // n0x013b c0x0000 (---------------)  + I dupont
	0x00383246, // n0x013c c0x0000 (---------------)  + I durban
	0x00300bc4, // n0x013d c0x0000 (---------------)  + I dvag
	0x14aa3602, // n0x013e c0x0052 (n0x0858-n0x0860)  + I dz
	0x00330d85, // n0x013f c0x0000 (---------------)  + I earth
	0x00242e03, // n0x0140 c0x0000 (---------------)  + I eat
	0x14e00702, // n0x0141 c0x0053 (n0x0860-n0x086c)  + I ec
	0x0038d785, // n0x0142 c0x0000 (---------------)  + I edeka
	0x002d75c3, // n0x0143 c0x0000 (---------------)  + I edu
	0x00375549, // n0x0144 c0x0000 (---------------)  + I education
	0x15206042, // n0x0145 c0x0054 (n0x086c-n0x0876)  + I ee
	0x15a0df82, // n0x0146 c0x0056 (n0x0877-n0x0880)  + I eg
	0x003435c5, // n0x0147 c0x0000 (---------------)  + I email
	0x00312206, // n0x0148 c0x0000 (---------------)  + I emerck
	0x002ba7c6, // n0x0149 c0x0000 (---------------)  + I energy
	0x002a8a88, // n0x014a c0x0000 (---------------)  + I engineer
	0x002a8a8b, // n0x014b c0x0000 (---------------)  + I engineering
	0x0037a7cb, // n0x014c c0x0000 (---------------)  + I enterprises
	0x00364485, // n0x014d c0x0000 (---------------)  + I epson
	0x0021f909, // n0x014e c0x0000 (---------------)  + I equipment
	0x01600ec2, // n0x014f c0x0005 (---------------)* o I er
	0x00259904, // n0x0150 c0x0000 (---------------)  + I erni
	0x162010c2, // n0x0151 c0x0058 (n0x0881-n0x0886)  + I es
	0x00275b43, // n0x0152 c0x0000 (---------------)  + I esq
	0x002b1846, // n0x0153 c0x0000 (---------------)  + I estate
	0x16a0bbc2, // n0x0154 c0x005a (n0x0887-n0x088f)  + I et
	0x0021d5c2, // n0x0155 c0x0000 (---------------)  + I eu
	0x002ef88a, // n0x0156 c0x0000 (---------------)  + I eurovision
	0x002b71c3, // n0x0157 c0x0000 (---------------)  + I eus
	0x003423c6, // n0x0158 c0x0000 (---------------)  + I events
	0x00381fc8, // n0x0159 c0x0000 (---------------)  + I everbank
	0x002f3908, // n0x015a c0x0000 (---------------)  + I exchange
	0x0030c7c6, // n0x015b c0x0000 (---------------)  + I expert
	0x00203e87, // n0x015c c0x0000 (---------------)  + I exposed
	0x0029ab47, // n0x015d c0x0000 (---------------)  + I express
	0x0021008a, // n0x015e c0x0000 (---------------)  + I extraspace
	0x00310504, // n0x015f c0x0000 (---------------)  + I fage
	0x00328344, // n0x0160 c0x0000 (---------------)  + I fail
	0x0033d609, // n0x0161 c0x0000 (---------------)  + I fairwinds
	0x00377ec5, // n0x0162 c0x0000 (---------------)  + I faith
	0x00311c06, // n0x0163 c0x0000 (---------------)  + I family
	0x0020f1c3, // n0x0164 c0x0000 (---------------)  + I fan
	0x002c5544, // n0x0165 c0x0000 (---------------)  + I fans
	0x0021f804, // n0x0166 c0x0000 (---------------)  + I farm
	0x0025d247, // n0x0167 c0x0000 (---------------)  + I fashion
	0x00287d44, // n0x0168 c0x0000 (---------------)  + I fast
	0x00369188, // n0x0169 c0x0000 (---------------)  + I feedback
	0x003127c7, // n0x016a c0x0000 (---------------)  + I ferrero
	0x16e099c2, // n0x016b c0x005b (n0x088f-n0x0892)  + I fi
	0x00356104, // n0x016c c0x0000 (---------------)  + I film
	0x00356745, // n0x016d c0x0000 (---------------)  + I final
	0x00368607, // n0x016e c0x0000 (---------------)  + I finance
	0x00371509, // n0x016f c0x0000 (---------------)  + I financial
	0x00236744, // n0x0170 c0x0000 (---------------)  + I fire
	0x00237d49, // n0x0171 c0x0000 (---------------)  + I firestone
	0x00238548, // n0x0172 c0x0000 (---------------)  + I firmdale
	0x00238904, // n0x0173 c0x0000 (---------------)  + I fish
	0x00238907, // n0x0174 c0x0000 (---------------)  + I fishing
	0x00238f03, // n0x0175 c0x0000 (---------------)  + I fit
	0x00239087, // n0x0176 c0x0000 (---------------)  + I fitness
	0x016241c2, // n0x0177 c0x0005 (---------------)* o I fj
	0x01697782, // n0x0178 c0x0005 (---------------)* o I fk
	0x0023a306, // n0x0179 c0x0000 (---------------)  + I flickr
	0x0023b147, // n0x017a c0x0000 (---------------)  + I flights
	0x0023c607, // n0x017b c0x0000 (---------------)  + I florist
	0x0023ef07, // n0x017c c0x0000 (---------------)  + I flowers
	0x0023f508, // n0x017d c0x0000 (---------------)  + I flsmidth
	0x0023ffc3, // n0x017e c0x0000 (---------------)  + I fly
	0x00358002, // n0x017f c0x0000 (---------------)  + I fm
	0x00200382, // n0x0180 c0x0000 (---------------)  + I fo
	0x00241943, // n0x0181 c0x0000 (---------------)  + I foo
	0x0024194b, // n0x0182 c0x0000 (---------------)  + I foodnetwork
	0x0030b888, // n0x0183 c0x0000 (---------------)  + I football
	0x003640c4, // n0x0184 c0x0000 (---------------)  + I ford
	0x00242f85, // n0x0185 c0x0000 (---------------)  + I forex
	0x00244a47, // n0x0186 c0x0000 (---------------)  + I forsale
	0x00246b45, // n0x0187 c0x0000 (---------------)  + I forum
	0x00303b8a, // n0x0188 c0x0000 (---------------)  + I foundation
	0x17200d42, // n0x0189 c0x005c (n0x0892-n0x08aa)  + I fr
	0x0024c6c3, // n0x018a c0x0000 (---------------)  + I frl
	0x0024c787, // n0x018b c0x0000 (---------------)  + I frogans
	0x003906c9, // n0x018c c0x0000 (---------------)  + I frontdoor
	0x00200d48, // n0x018d c0x0000 (---------------)  + I frontier
	0x0026fc04, // n0x018e c0x0000 (---------------)  + I fund
	0x00272f09, // n0x018f c0x0000 (---------------)  + I furniture
	0x002764c6, // n0x0190 c0x0000 (---------------)  + I futbol
	0x00277503, // n0x0191 c0x0000 (---------------)  + I fyi
	0x00201602, // n0x0192 c0x0000 (---------------)  + I ga
	0x00215b83, // n0x0193 c0x0000 (---------------)  + I gal
	0x00226607, // n0x0194 c0x0000 (---------------)  + I gallery
	0x00362a05, // n0x0195 c0x0000 (---------------)  + I gallo
	0x0036bd46, // n0x0196 c0x0000 (---------------)  + I gallup
	0x00212084, // n0x0197 c0x0000 (---------------)  + I game
	0x002d2145, // n0x0198 c0x0000 (---------------)  + I games
	0x0020e506, // n0x0199 c0x0000 (---------------)  + I garden
	0x00205a42, // n0x019a c0x0000 (---------------)  + I gb
	0x00378f84, // n0x019b c0x0000 (---------------)  + I gbiz
	0x0021b342, // n0x019c c0x0000 (---------------)  + I gd
	0x002d0143, // n0x019d c0x0000 (---------------)  + I gdn
	0x176012c2, // n0x019e c0x005d (n0x08aa-n0x08b1)  + I ge
	0x00237543, // n0x019f c0x0000 (---------------)  + I gea
	0x0020db04, // n0x01a0 c0x0000 (---------------)  + I gent
	0x0020db07, // n0x01a1 c0x0000 (---------------)  + I genting
	0x00248e82, // n0x01a2 c0x0000 (---------------)  + I gf
	0x17a00402, // n0x01a3 c0x005e (n0x08b1-n0x08b4)  + I gg
	0x00268b44, // n0x01a4 c0x0000 (---------------)  + I ggee
	0x17e36e42, // n0x01a5 c0x005f (n0x08b4-n0x08b9)  + I gh
	0x18200442, // n0x01a6 c0x0060 (n0x08b9-n0x08bf)  + I gi
	0x0030f704, // n0x01a7 c0x0000 (---------------)  + I gift
	0x0030f705, // n0x01a8 c0x0000 (---------------)  + I gifts
	0x002b9bc5, // n0x01a9 c0x0000 (---------------)  + I gives
	0x00213586, // n0x01aa c0x0000 (---------------)  + I giving
	0x18629902, // n0x01ab c0x0061 (n0x08bf-n0x08c4)  + I gl
	0x0034da85, // n0x01ac c0x0000 (---------------)  + I glass
	0x00274303, // n0x01ad c0x0000 (---------------)  + I gle
	0x00389c06, // n0x01ae c0x0000 (---------------)  + I global
	0x0038a445, // n0x01af c0x0000 (---------------)  + I globo
	0x002047c2, // n0x01b0 c0x0000 (---------------)  + I gm
	0x00323145, // n0x01b1 c0x0000 (---------------)  + I gmail
	0x00208443, // n0x01b2 c0x0000 (---------------)  + I gmo
	0x0020a643, // n0x01b3 c0x0000 (---------------)  + I gmx
	0x18a050c2, // n0x01b4 c0x0062 (n0x08c4-n0x08ca)  + I gn
	0x00238a84, // n0x01b5 c0x0000 (---------------)  + I gold
	0x00238a89, // n0x01b6 c0x0000 (---------------)  + I goldpoint
	0x0025d184, // n0x01b7 c0x0000 (---------------)  + I golf
	0x0028c883, // n0x01b8 c0x0000 (---------------)  + I goo
	0x00330c48, // n0x01b9 c0x0000 (---------------)  + I goodyear
	0x0028c884, // n0x01ba c0x0000 (---------------)  + I goog
	0x0028c886, // n0x01bb c0x0000 (---------------)  + I google
	0x0028e783, // n0x01bc c0x0000 (---------------)  + I gop
	0x0020bec3, // n0x01bd c0x0000 (---------------)  + I got
	0x0020bec4, // n0x01be c0x0000 (---------------)  + I gotv
	0x0021e283, // n0x01bf c0x0000 (---------------)  + I gov
	0x18ece142, // n0x01c0 c0x0063 (n0x08ca-n0x08d0)  + I gp
	0x0034f382, // n0x01c1 c0x0000 (---------------)  + I gq
	0x1920dc82, // n0x01c2 c0x0064 (n0x08d0-n0x08d6)  + I gr
	0x002ff248, // n0x01c3 c0x0000 (---------------)  + I grainger
	0x00341188, // n0x01c4 c0x0000 (---------------)  + I graphics
	0x0037d046, // n0x01c5 c0x0000 (---------------)  + I gratis
	0x0025b105, // n0x01c6 c0x0000 (---------------)  + I green
	0x0021dd45, // n0x01c7 c0x0000 (---------------)  + I gripe
	0x002646c5, // n0x01c8 c0x0000 (---------------)  + I group
	0x0026cd02, // n0x01c9 c0x0000 (---------------)  + I gs
	0x19651202, // n0x01ca c0x0065 (n0x08d6-n0x08dd)  + I gt
	0x01629702, // n0x01cb c0x0005 (---------------)* o I gu
	0x0025f6c5, // n0x01cc c0x0000 (---------------)  + I gucci
	0x002ca244, // n0x01cd c0x0000 (---------------)  + I guge
	0x00229705, // n0x01ce c0x0000 (---------------)  + I guide
	0x0022d647, // n0x01cf c0x0000 (---------------)  + I guitars
	0x0025bc44, // n0x01d0 c0x0000 (---------------)  + I guru
	0x00204b82, // n0x01d1 c0x0000 (---------------)  + I gw
	0x19a25a02, // n0x01d2 c0x0066 (n0x08dd-n0x08e0)  + I gy
	0x0038a2c7, // n0x01d3 c0x0000 (---------------)  + I hamburg
	0x00392287, // n0x01d4 c0x0000 (---------------)  + I hangout
	0x00329884, // n0x01d5 c0x0000 (---------------)  + I haus
	0x00235cc8, // n0x01d6 c0x0000 (---------------)  + I hdfcbank
	0x00205e06, // n0x01d7 c0x0000 (---------------)  + I health
	0x00205e0a, // n0x01d8 c0x0000 (---------------)  + I healthcare
	0x00205204, // n0x01d9 c0x0000 (---------------)  + I help
	0x00209408, // n0x01da c0x0000 (---------------)  + I helsinki
	0x0023f784, // n0x01db c0x0000 (---------------)  + I here
	0x00219446, // n0x01dc c0x0000 (---------------)  + I hermes
	0x00280244, // n0x01dd c0x0000 (---------------)  + I hgtv
	0x0032cd06, // n0x01de c0x0000 (---------------)  + I hiphop
	0x0028d547, // n0x01df c0x0000 (---------------)  + I hitachi
	0x0025f603, // n0x01e0 c0x0000 (---------------)  + I hiv
	0x19e2ea02, // n0x01e1 c0x0067 (n0x08e0-n0x08f8)  + I hk
	0x0025ab03, // n0x01e2 c0x0000 (---------------)  + I hkt
	0x00206182, // n0x01e3 c0x0000 (---------------)  + I hm
	0x1a217542, // n0x01e4 c0x0068 (n0x08f8-n0x08fe)  + I hn
	0x002cd886, // n0x01e5 c0x0000 (---------------)  + I hockey
	0x0034b148, // n0x01e6 c0x0000 (---------------)  + I holdings
	0x00290807, // n0x01e7 c0x0000 (---------------)  + I holiday
	0x002b8e89, // n0x01e8 c0x0000 (---------------)  + I homedepot
	0x00291385, // n0x01e9 c0x0000 (---------------)  + I homes
	0x00292005, // n0x01ea c0x0000 (---------------)  + I honda
	0x00293c05, // n0x01eb c0x0000 (---------------)  + I horse
	0x00202fc4, // n0x01ec c0x0000 (---------------)  + I host
	0x002836c7, // n0x01ed c0x0000 (---------------)  + I hosting
	0x00294947, // n0x01ee c0x0000 (---------------)  + I hoteles
	0x00294fc7, // n0x01ef c0x0000 (---------------)  + I hotmail
	0x0021da05, // n0x01f0 c0x0000 (---------------)  + I house
	0x00297383, // n0x01f1 c0x0000 (---------------)  + I how
	0x1a625842, // n0x01f2 c0x0069 (n0x08fe-n0x0903)  + I hr
	0x002dbf04, // n0x01f3 c0x0000 (---------------)  + I hsbc
	0x1aa36e82, // n0x01f4 c0x006a (n0x0903-n0x0914)  + I ht
	0x00249003, // n0x01f5 c0x0000 (---------------)  + I htc
	0x1ae17d42, // n0x01f6 c0x006b (n0x0914-n0x0934)  + I hu
	0x0031b7c3, // n0x01f7 c0x0000 (---------------)  + I ibm
	0x0028bf44, // n0x01f8 c0x0000 (---------------)  + I icbc
	0x00200b43, // n0x01f9 c0x0000 (---------------)  + I ice
	0x0033c383, // n0x01fa c0x0000 (---------------)  + I icu
	0x1b206202, // n0x01fb c0x006c (n0x0934-n0x093f)  + I id
	0x1ba00e82, // n0x01fc c0x006e (n0x0940-n0x0942)  + I ie
	0x00370d03, // n0x01fd c0x0000 (---------------)  + I ifm
	0x0031cac5, // n0x01fe c0x0000 (---------------)  + I iinet
	0x1be036c2, // n0x01ff c0x006f (n0x0942-n0x0943)* o I il
	0x1c603582, // n0x0200 c0x0071 (n0x0944-n0x094b)  + I im
	0x002f4284, // n0x0201 c0x0000 (---------------)  + I imdb
	0x00203584, // n0x0202 c0x0000 (---------------)  + I immo
	0x0020358a, // n0x0203 c0x0000 (---------------)  + I immobilien
	0x1ce00242, // n0x0204 c0x0073 (n0x094d-n0x095a)  + I in
	0x00353eca, // n0x0205 c0x0000 (---------------)  + I industries
	0x00355408, // n0x0206 c0x0000 (---------------)  + I infiniti
	0x1d200304, // n0x0207 c0x0074 (n0x095a-n0x0964)  + I info
	0x0020dc03, // n0x0208 c0x0000 (---------------)  + I ing
	0x00209503, // n0x0209 c0x0000 (---------------)  + I ink
	0x002ed209, // n0x020a c0x0000 (---------------)  + I institute
	0x002806c9, // n0x020b c0x0000 (---------------)  + I insurance
	0x002e8406, // n0x020c c0x0000 (---------------)  + I insure
	0x1d638c03, // n0x020d c0x0075 (n0x0964-n0x0965)  + I int
	0x002dd88d, // n0x020e c0x0000 (---------------)  + I international
	0x002087cb, // n0x020f c0x0000 (---------------)  + I investments
	0x1da00042, // n0x0210 c0x0076 (n0x0965-n0x0968)  + I io
	0x00331048, // n0x0211 c0x0000 (---------------)  + I ipiranga
	0x1de11142, // n0x0212 c0x0077 (n0x0968-n0x096e)  + I iq
	0x1e200542, // n0x0213 c0x0078 (n0x096e-n0x0977)  + I ir
	0x00294c05, // n0x0214 c0x0000 (---------------)  + I irish
	0x1e602b42, // n0x0215 c0x0079 (n0x0977-n0x097f)  + I is
	0x00370f07, // n0x0216 c0x0000 (---------------)  + I iselect
	0x00202b43, // n0x0217 c0x0000 (---------------)  + I ist
	0x00210c48, // n0x0218 c0x0000 (---------------)  + I istanbul
	0x1ea06e82, // n0x0219 c0x007a (n0x097f-n0x0af0)  + I it
	0x00206e84, // n0x021a c0x0000 (---------------)  + I itau
	0x003664c3, // n0x021b c0x0000 (---------------)  + I iwc
	0x002a51c6, // n0x021c c0x0000 (---------------)  + I jaguar
	0x0030ad84, // n0x021d c0x0000 (---------------)  + I java
	0x00243883, // n0x021e c0x0000 (---------------)  + I jcb
	0x0025b3c3, // n0x021f c0x0000 (---------------)  + I jcp
	0x1ee01f82, // n0x0220 c0x007b (n0x0af0-n0x0af3)  + I je
	0x0033ab85, // n0x0221 c0x0000 (---------------)  + I jetzt
	0x0034f487, // n0x0222 c0x0000 (---------------)  + I jewelry
	0x00266583, // n0x0223 c0x0000 (---------------)  + I jio
	0x00297c83, // n0x0224 c0x0000 (---------------)  + I jlc
	0x00297e43, // n0x0225 c0x0000 (---------------)  + I jll
	0x01697f02, // n0x0226 c0x0005 (---------------)* o I jm
	0x00297f03, // n0x0227 c0x0000 (---------------)  + I jmp
	0x002987c3, // n0x0228 c0x0000 (---------------)  + I jnj
	0x1f202982, // n0x0229 c0x007c (n0x0af3-n0x0afb)  + I jo
	0x002a5d04, // n0x022a c0x0000 (---------------)  + I jobs
	0x00389ac6, // n0x022b c0x0000 (---------------)  + I joburg
	0x00203903, // n0x022c c0x0000 (---------------)  + I jot
	0x00298c43, // n0x022d c0x0000 (---------------)  + I joy
	0x1f6990c2, // n0x022e c0x007d (n0x0afb-n0x0b6a)  + I jp
	0x002990c8, // n0x022f c0x0000 (---------------)  + I jpmorgan
	0x0029ccc4, // n0x0230 c0x0000 (---------------)  + I jprs
	0x002faec6, // n0x0231 c0x0000 (---------------)  + I juegos
	0x002e6846, // n0x0232 c0x0000 (---------------)  + I kaufen
	0x00233fc4, // n0x0233 c0x0000 (---------------)  + I kddi
	0x2d201002, // n0x0234 c0x00b4 (n0x11fe-n0x11ff)* o I ke
	0x002a6f4b, // n0x0235 c0x0000 (---------------)  + I kerryhotels
	0x0021268e, // n0x0236 c0x0000 (---------------)  + I kerrylogistics
	0x0021810f, // n0x0237 c0x0000 (---------------)  + I kerryproperties
	0x00235e83, // n0x0238 c0x0000 (---------------)  + I kfh
	0x2daa3fc2, // n0x0239 c0x00b6 (n0x1200-n0x1206)  + I kg
	0x016176c2, // n0x023a c0x0005 (---------------)* o I kh
	0x2de01b02, // n0x023b c0x00b7 (n0x1206-n0x120d)  + I ki
	0x0027d603, // n0x023c c0x0000 (---------------)  + I kim
	0x002f33c6, // n0x023d c0x0000 (---------------)  + I kinder
	0x00227886, // n0x023e c0x0000 (---------------)  + I kindle
	0x00298f07, // n0x023f c0x0000 (---------------)  + I kitchen
	0x002d2dc4, // n0x0240 c0x0000 (---------------)  + I kiwi
	0x2e268d82, // n0x0241 c0x00b8 (n0x120d-n0x121e)  + I km
	0x2e656942, // n0x0242 c0x00b9 (n0x121e-n0x1222)  + I kn
	0x0021f385, // n0x0243 c0x0000 (---------------)  + I koeln
	0x002be447, // n0x0244 c0x0000 (---------------)  + I komatsu
	0x2ea08382, // n0x0245 c0x00ba (n0x1222-n0x1228)  + I kp
	0x00208384, // n0x0246 c0x0000 (---------------)  + I kpmg
	0x00360183, // n0x0247 c0x0000 (---------------)  + I kpn
	0x2ee034c2, // n0x0248 c0x00bb (n0x1228-n0x1246)  + I kr
	0x0033a003, // n0x0249 c0x0000 (---------------)  + I krd
	0x0029d8c4, // n0x024a c0x0000 (---------------)  + I kred
	0x002a3f09, // n0x024b c0x0000 (---------------)  + I kuokgroup
	0x016ac642, // n0x024c c0x0005 (---------------)* o I kw
	0x2f229082, // n0x024d c0x00bc (n0x1246-n0x124b)  + I ky
	0x002568c6, // n0x024e c0x0000 (---------------)  + I kyknet
	0x002acb05, // n0x024f c0x0000 (---------------)  + I kyoto
	0x2f6f0002, // n0x0250 c0x00bd (n0x124b-n0x1251)  + I kz
	0x2fa01e42, // n0x0251 c0x00be (n0x1251-n0x125a)  + I la
	0x003276c7, // n0x0252 c0x0000 (---------------)  + I lacaixa
	0x0033df4b, // n0x0253 c0x0000 (---------------)  + I lamborghini
	0x002335c9, // n0x0254 c0x0000 (---------------)  + I lancaster
	0x002364c4, // n0x0255 c0x0000 (---------------)  + I land
	0x0036d989, // n0x0256 c0x0000 (---------------)  + I landrover
	0x002679c7, // n0x0257 c0x0000 (---------------)  + I lasalle
	0x00222143, // n0x0258 c0x0000 (---------------)  + I lat
	0x002c18c7, // n0x0259 c0x0000 (---------------)  + I latrobe
	0x00253883, // n0x025a c0x0000 (---------------)  + I law
	0x00270406, // n0x025b c0x0000 (---------------)  + I lawyer
	0x2fe0a542, // n0x025c c0x00bf (n0x125a-n0x125f)  + I lb
	0x302339c2, // n0x025d c0x00c0 (n0x125f-n0x1265)  + I lc
	0x0021fbc3, // n0x025e c0x0000 (---------------)  + I lds
	0x00267b05, // n0x025f c0x0000 (---------------)  + I lease
	0x0025f307, // n0x0260 c0x0000 (---------------)  + I leclerc
	0x00362985, // n0x0261 c0x0000 (---------------)  + I legal
	0x002ad945, // n0x0262 c0x0000 (---------------)  + I lexus
	0x002ce984, // n0x0263 c0x0000 (---------------)  + I lgbt
	0x306008c2, // n0x0264 c0x00c1 (n0x1265-n0x1266)  + I li
	0x002ee607, // n0x0265 c0x0000 (---------------)  + I liaison
	0x002aadc4, // n0x0266 c0x0000 (---------------)  + I lidl
	0x00247844, // n0x0267 c0x0000 (---------------)  + I life
	0x0031c64d, // n0x0268 c0x0000 (---------------)  + I lifeinsurance
	0x00247849, // n0x0269 c0x0000 (---------------)  + I lifestyle
	0x00236dc8, // n0x026a c0x0000 (---------------)  + I lighting
	0x00261684, // n0x026b c0x0000 (---------------)  + I like
	0x002edc87, // n0x026c c0x0000 (---------------)  + I limited
	0x002ee1c4, // n0x026d c0x0000 (---------------)  + I limo
	0x00251e07, // n0x026e c0x0000 (---------------)  + I lincoln
	0x0031dc05, // n0x026f c0x0000 (---------------)  + I linde
	0x0031e2c4, // n0x0270 c0x0000 (---------------)  + I link
	0x002bfc05, // n0x0271 c0x0000 (---------------)  + I lipsy
	0x0024b384, // n0x0272 c0x0000 (---------------)  + I live
	0x002d7785, // n0x0273 c0x0000 (---------------)  + I lixil
	0x30a08342, // n0x0274 c0x00c2 (n0x1266-n0x1275)  + I lk
	0x0020ab84, // n0x0275 c0x0000 (---------------)  + I loan
	0x0020ab85, // n0x0276 c0x0000 (---------------)  + I loans
	0x0020af86, // n0x0277 c0x0000 (---------------)  + I locker
	0x00362ac5, // n0x0278 c0x0000 (---------------)  + I locus
	0x002c1ec3, // n0x0279 c0x0000 (---------------)  + I lol
	0x00340906, // n0x027a c0x0000 (---------------)  + I london
	0x00364385, // n0x027b c0x0000 (---------------)  + I lotte
	0x00206505, // n0x027c c0x0000 (---------------)  + I lotto
	0x002123c4, // n0x027d c0x0000 (---------------)  + I love
	0x30e76e02, // n0x027e c0x00c3 (n0x1275-n0x127a)  + I lr
	0x31202d42, // n0x027f c0x00c4 (n0x127a-n0x127c)  + I ls
	0x31605ec2, // n0x0280 c0x00c5 (n0x127c-n0x127e)  + I lt
	0x003413c3, // n0x0281 c0x0000 (---------------)  + I ltd
	0x003413c4, // n0x0282 c0x0000 (---------------)  + I ltda
	0x31a071c2, // n0x0283 c0x00c6 (n0x127e-n0x127f)  + I lu
	0x0036be05, // n0x0284 c0x0000 (---------------)  + I lupin
	0x00222d84, // n0x0285 c0x0000 (---------------)  + I luxe
	0x00225dc6, // n0x0286 c0x0000 (---------------)  + I luxury
	0x31e27f02, // n0x0287 c0x00c7 (n0x127f-n0x1288)  + I lv
	0x32228b42, // n0x0288 c0x00c8 (n0x1288-n0x1291)  + I ly
	0x32604302, // n0x0289 c0x00c9 (n0x1291-n0x1297)  + I ma
	0x00300a86, // n0x028a c0x0000 (---------------)  + I madrid
	0x0032a984, // n0x028b c0x0000 (---------------)  + I maif
	0x0033c9c6, // n0x028c c0x0000 (---------------)  + I maison
	0x0026a746, // n0x028d c0x0000 (---------------)  + I makeup
	0x00206903, // n0x028e c0x0000 (---------------)  + I man
	0x00351aca, // n0x028f c0x0000 (---------------)  + I management
	0x0022a685, // n0x0290 c0x0000 (---------------)  + I mango
	0x0029bcc6, // n0x0291 c0x0000 (---------------)  + I market
	0x00357049, // n0x0292 c0x0000 (---------------)  + I marketing
	0x0029bcc7, // n0x0293 c0x0000 (---------------)  + I markets
	0x0027c808, // n0x0294 c0x0000 (---------------)  + I marriott
	0x00271143, // n0x0295 c0x0000 (---------------)  + I mba
	0x32a3a6c2, // n0x0296 c0x00ca (n0x1297-n0x1299)  + I mc
	0x32e38602, // n0x0297 c0x00cb (n0x1299-n0x129a)  + I md
	0x33208942, // n0x0298 c0x00cc (n0x129a-n0x12a2)  + I me
	0x002dc385, // n0x0299 c0x0000 (---------------)  + I media
	0x00282f44, // n0x029a c0x0000 (---------------)  + I meet
	0x0020fe89, // n0x029b c0x0000 (---------------)  + I melbourne
	0x003121c4, // n0x029c c0x0000 (---------------)  + I meme
	0x002edac8, // n0x029d c0x0000 (---------------)  + I memorial
	0x00208943, // n0x029e c0x0000 (---------------)  + I men
	0x0034d804, // n0x029f c0x0000 (---------------)  + I menu
	0x0023a883, // n0x02a0 c0x0000 (---------------)  + I meo
	0x0031c587, // n0x02a1 c0x0000 (---------------)  + I metlife
	0x33608402, // n0x02a2 c0x00cd (n0x12a2-n0x12aa)  + I mg
	0x00249282, // n0x02a3 c0x0000 (---------------)  + I mh
	0x002322c5, // n0x02a4 c0x0000 (---------------)  + I miami
	0x00257ec9, // n0x02a5 c0x0000 (---------------)  + I microsoft
	0x0023fa03, // n0x02a6 c0x0000 (---------------)  + I mil
	0x0026b344, // n0x02a7 c0x0000 (---------------)  + I mini
	0x00246f03, // n0x02a8 c0x0000 (---------------)  + I mit
	0x33b56d82, // n0x02a9 c0x00ce (n0x12aa-n0x12b2)  + I mk
	0x33e0ab42, // n0x02aa c0x00cf (n0x12b2-n0x12b9)  + I ml
	0x002afd83, // n0x02ab c0x0000 (---------------)  + I mlb
	0x00358b83, // n0x02ac c0x0000 (---------------)  + I mls
	0x016035c2, // n0x02ad c0x0005 (---------------)* o I mm
	0x003679c3, // n0x02ae c0x0000 (---------------)  + I mma
	0x34217082, // n0x02af c0x00d0 (n0x12b9-n0x12bd)  + I mn
	0x00217084, // n0x02b0 c0x0000 (---------------)  + I mnet
	0x34603602, // n0x02b1 c0x00d1 (n0x12bd-n0x12c2)  + I mo
	0x00203604, // n0x02b2 c0x0000 (---------------)  + I mobi
	0x002cc406, // n0x02b3 c0x0000 (---------------)  + I mobily
	0x00208484, // n0x02b4 c0x0000 (---------------)  + I moda
	0x002fb2c3, // n0x02b5 c0x0000 (---------------)  + I moe
	0x0038f703, // n0x02b6 c0x0000 (---------------)  + I moi
	0x0021cfc3, // n0x02b7 c0x0000 (---------------)  + I mom
	0x00230c46, // n0x02b8 c0x0000 (---------------)  + I monash
	0x002b6185, // n0x02b9 c0x0000 (---------------)  + I money
	0x00261909, // n0x02ba c0x0000 (---------------)  + I montblanc
	0x002b60c6, // n0x02bb c0x0000 (---------------)  + I mormon
	0x002b66c8, // n0x02bc c0x0000 (---------------)  + I mortgage
	0x002b68c6, // n0x02bd c0x0000 (---------------)  + I moscow
	0x0025cb84, // n0x02be c0x0000 (---------------)  + I moto
	0x0028678b, // n0x02bf c0x0000 (---------------)  + I motorcycles
	0x002b8403, // n0x02c0 c0x0000 (---------------)  + I mov
	0x002b8405, // n0x02c1 c0x0000 (---------------)  + I movie
	0x002b8548, // n0x02c2 c0x0000 (---------------)  + I movistar
	0x00214902, // n0x02c3 c0x0000 (---------------)  + I mp
	0x003279c2, // n0x02c4 c0x0000 (---------------)  + I mq
	0x34adcb42, // n0x02c5 c0x00d2 (n0x12c2-n0x12c4)  + I mr
	0x34e09282, // n0x02c6 c0x00d3 (n0x12c4-n0x12c9)  + I ms
	0x35259642, // n0x02c7 c0x00d4 (n0x12c9-n0x12cd)  + I mt
	0x00259643, // n0x02c8 c0x0000 (---------------)  + I mtn
	0x002b8844, // n0x02c9 c0x0000 (---------------)  + I mtpc
	0x002b9703, // n0x02ca c0x0000 (---------------)  + I mtr
	0x35a000c2, // n0x02cb c0x00d6 (n0x12ce-n0x12d5)  + I mu
	0x002bae0b, // n0x02cc c0x0000 (---------------)  + I multichoice
	0x35ebd646, // n0x02cd c0x00d7 (n0x12d5-n0x14f9)  + I museum
	0x0036d306, // n0x02ce c0x0000 (---------------)  + I mutual
	0x002bdc88, // n0x02cf c0x0000 (---------------)  + I mutuelle
	0x3624ffc2, // n0x02d0 c0x00d8 (n0x14f9-n0x1507)  + I mv
	0x3660a142, // n0x02d1 c0x00d9 (n0x1507-n0x1512)  + I mw
	0x36a0a682, // n0x02d2 c0x00da (n0x1512-n0x1518)  + I mx
	0x36e20282, // n0x02d3 c0x00db (n0x1518-n0x1520)  + I my
	0x372c6c02, // n0x02d4 c0x00dc (n0x1520-n0x1521)* o I mz
	0x002c6c0b, // n0x02d5 c0x0000 (---------------)  + I mzansimagic
	0x37600282, // n0x02d6 c0x00dd (n0x1521-n0x1532)  + I na
	0x002f3845, // n0x02d7 c0x0000 (---------------)  + I nadex
	0x0032b206, // n0x02d8 c0x0000 (---------------)  + I nagoya
	0x37a98944, // n0x02d9 c0x00de (n0x1532-n0x1534)  + I name
	0x0030cfc7, // n0x02da c0x0000 (---------------)  + I naspers
	0x00240dc6, // n0x02db c0x0000 (---------------)  + I natura
	0x0037fe44, // n0x02dc c0x0000 (---------------)  + I navy
	0x3861c742, // n0x02dd c0x00e1 (n0x1536-n0x1537)  + I nc
	0x00201082, // n0x02de c0x0000 (---------------)  + I ne
	0x00305e83, // n0x02df c0x0000 (---------------)  + I nec
	0x38a170c3, // n0x02e0 c0x00e2 (n0x1537-n0x1568)  + I net
	0x002efe87, // n0x02e1 c0x0000 (---------------)  + I netbank
	0x002d7687, // n0x02e2 c0x0000 (---------------)  + I netflix
	0x00241a47, // n0x02e3 c0x0000 (---------------)  + I network
	0x00319107, // n0x02e4 c0x0000 (---------------)  + I neustar
	0x0021a383, // n0x02e5 c0x0000 (---------------)  + I new
	0x00366d44, // n0x02e6 c0x0000 (---------------)  + I news
	0x00210044, // n0x02e7 c0x0000 (---------------)  + I next
	0x00352aca, // n0x02e8 c0x0000 (---------------)  + I nextdirect
	0x00255985, // n0x02e9 c0x0000 (---------------)  + I nexus
	0x39e00342, // n0x02ea c0x00e7 (n0x1570-n0x157a)  + I nf
	0x3a201282, // n0x02eb c0x00e8 (n0x157a-n0x1583)  + I ng
	0x00202303, // n0x02ec c0x0000 (---------------)  + I ngo
	0x0025aac3, // n0x02ed c0x0000 (---------------)  + I nhk
	0x01603d42, // n0x02ee c0x0005 (---------------)* o I ni
	0x00369044, // n0x02ef c0x0000 (---------------)  + I nico
	0x00204c45, // n0x02f0 c0x0000 (---------------)  + I nikon
	0x002bbfc5, // n0x02f1 c0x0000 (---------------)  + I ninja
	0x0029c346, // n0x02f2 c0x0000 (---------------)  + I nissan
	0x3aa36482, // n0x02f3 c0x00ea (n0x1584-n0x1587)  + I nl
	0x3ae00c02, // n0x02f4 c0x00eb (n0x1587-n0x185d)  + I no
	0x00201b85, // n0x02f5 c0x0000 (---------------)  + I nokia
	0x0036d012, // n0x02f6 c0x0000 (---------------)  + I northwesternmutual
	0x00204546, // n0x02f7 c0x0000 (---------------)  + I norton
	0x0021c343, // n0x02f8 c0x0000 (---------------)  + I now
	0x0036a0c6, // n0x02f9 c0x0000 (---------------)  + I nowruz
	0x0030b645, // n0x02fa c0x0000 (---------------)  + I nowtv
	0x0160a2c2, // n0x02fb c0x0005 (---------------)* o I np
	0x43209e82, // n0x02fc c0x010c (n0x1885-n0x188c)  + I nr
	0x002cc1c3, // n0x02fd c0x0000 (---------------)  + I nra
	0x00345903, // n0x02fe c0x0000 (---------------)  + I nrw
	0x00361083, // n0x02ff c0x0000 (---------------)  + I ntt
	0x43605bc2, // n0x0300 c0x010d (n0x188c-n0x188f)  + I nu
	0x00223403, // n0x0301 c0x0000 (---------------)  + I nyc
	0x43a078c2, // n0x0302 c0x010e (n0x188f-n0x189f)  + I nz
	0x00203643, // n0x0303 c0x0000 (---------------)  + I obi
	0x002a5d48, // n0x0304 c0x0000 (---------------)  + I observer
	0x00219c46, // n0x0305 c0x0000 (---------------)  + I office
	0x003954c7, // n0x0306 c0x0000 (---------------)  + I okinawa
	0x002a2686, // n0x0307 c0x0000 (---------------)  + I olayan
	0x002a268b, // n0x0308 c0x0000 (---------------)  + I olayangroup
	0x002dbd04, // n0x0309 c0x0000 (---------------)  + I ollo
	0x44200082, // n0x030a c0x0110 (n0x18a0-n0x18a9)  + I om
	0x0036bc85, // n0x030b c0x0000 (---------------)  + I omega
	0x0021a343, // n0x030c c0x0000 (---------------)  + I one
	0x00292c83, // n0x030d c0x0000 (---------------)  + I ong
	0x003023c3, // n0x030e c0x0000 (---------------)  + I onl
	0x003023c6, // n0x030f c0x0000 (---------------)  + I online
	0x0027b9c3, // n0x0310 c0x0000 (---------------)  + I ooo
	0x0032d686, // n0x0311 c0x0000 (---------------)  + I oracle
	0x002a6246, // n0x0312 c0x0000 (---------------)  + I orange
	0x4461dcc3, // n0x0313 c0x0111 (n0x18a9-n0x18e3)  + I org
	0x00299187, // n0x0314 c0x0000 (---------------)  + I organic
	0x0029a9cd, // n0x0315 c0x0000 (---------------)  + I orientexpress
	0x002864c5, // n0x0316 c0x0000 (---------------)  + I osaka
	0x00239506, // n0x0317 c0x0000 (---------------)  + I otsuka
	0x00206543, // n0x0318 c0x0000 (---------------)  + I ott
	0x00389e43, // n0x0319 c0x0000 (---------------)  + I ovh
	0x45e052c2, // n0x031a c0x0117 (n0x1920-n0x192b)  + I pa
	0x00310fc4, // n0x031b c0x0000 (---------------)  + I page
	0x002fb60c, // n0x031c c0x0000 (---------------)  + I pamperedchef
	0x0022c007, // n0x031d c0x0000 (---------------)  + I panerai
	0x0025b445, // n0x031e c0x0000 (---------------)  + I paris
	0x0028f504, // n0x031f c0x0000 (---------------)  + I pars
	0x00297f88, // n0x0320 c0x0000 (---------------)  + I partners
	0x002c2085, // n0x0321 c0x0000 (---------------)  + I parts
	0x002a2905, // n0x0322 c0x0000 (---------------)  + I party
	0x002a4109, // n0x0323 c0x0000 (---------------)  + I passagens
	0x002ab584, // n0x0324 c0x0000 (---------------)  + I payu
	0x002b88c4, // n0x0325 c0x0000 (---------------)  + I pccw
	0x46214942, // n0x0326 c0x0118 (n0x192b-n0x1933)  + I pe
	0x0021ab43, // n0x0327 c0x0000 (---------------)  + I pet
	0x46764f42, // n0x0328 c0x0119 (n0x1933-n0x1936)  + I pf
	0x016bf182, // n0x0329 c0x0005 (---------------)* o I pg
	0x46a8f0c2, // n0x032a c0x011a (n0x1936-n0x193e)  + I ph
	0x002dc948, // n0x032b c0x0000 (---------------)  + I pharmacy
	0x002bfb47, // n0x032c c0x0000 (---------------)  + I philips
	0x0028f0c5, // n0x032d c0x0000 (---------------)  + I photo
	0x002c014b, // n0x032e c0x0000 (---------------)  + I photography
	0x002bea86, // n0x032f c0x0000 (---------------)  + I photos
	0x002c0346, // n0x0330 c0x0000 (---------------)  + I physio
	0x002c04c6, // n0x0331 c0x0000 (---------------)  + I piaget
	0x0021ec04, // n0x0332 c0x0000 (---------------)  + I pics
	0x002c0a46, // n0x0333 c0x0000 (---------------)  + I pictet
	0x002c0fc8, // n0x0334 c0x0000 (---------------)  + I pictures
	0x0022c6c3, // n0x0335 c0x0000 (---------------)  + I pid
	0x00243743, // n0x0336 c0x0000 (---------------)  + I pin
	0x00243744, // n0x0337 c0x0000 (---------------)  + I ping
	0x002c1c84, // n0x0338 c0x0000 (---------------)  + I pink
	0x002c3cc5, // n0x0339 c0x0000 (---------------)  + I pizza
	0x46ec3e02, // n0x033a c0x011b (n0x193e-n0x194c)  + I pk
	0x47201e02, // n0x033b c0x011c (n0x194c-n0x19f1)  + I pl
	0x00201e05, // n0x033c c0x0000 (---------------)  + I place
	0x00290d44, // n0x033d c0x0000 (---------------)  + I play
	0x002c61cb, // n0x033e c0x0000 (---------------)  + I playstation
	0x002c7948, // n0x033f c0x0000 (---------------)  + I plumbing
	0x002c7b84, // n0x0340 c0x0000 (---------------)  + I plus
	0x002083c2, // n0x0341 c0x0000 (---------------)  + I pm
	0x47a3df82, // n0x0342 c0x011e (n0x1a20-n0x1a25)  + I pn
	0x0029a743, // n0x0343 c0x0000 (---------------)  + I pnc
	0x002c7fc4, // n0x0344 c0x0000 (---------------)  + I pohl
	0x002c80c5, // n0x0345 c0x0000 (---------------)  + I poker
	0x002c9d84, // n0x0346 c0x0000 (---------------)  + I porn
	0x002b31c4, // n0x0347 c0x0000 (---------------)  + I post
	0x47e18242, // n0x0348 c0x011f (n0x1a25-n0x1a32)  + I pr
	0x0025da85, // n0x0349 c0x0000 (---------------)  + I praxi
	0x0029abc5, // n0x034a c0x0000 (---------------)  + I press
	0x002cad45, // n0x034b c0x0000 (---------------)  + I prime
	0x48218243, // n0x034c c0x0120 (n0x1a32-n0x1a39)  + I pro
	0x002cbe44, // n0x034d c0x0000 (---------------)  + I prod
	0x002cbe4b, // n0x034e c0x0000 (---------------)  + I productions
	0x002cc284, // n0x034f c0x0000 (---------------)  + I prof
	0x002cca85, // n0x0350 c0x0000 (---------------)  + I promo
	0x0021824a, // n0x0351 c0x0000 (---------------)  + I properties
	0x002cce48, // n0x0352 c0x0000 (---------------)  + I property
	0x002cd04a, // n0x0353 c0x0000 (---------------)  + I protection
	0x4861dc02, // n0x0354 c0x0121 (n0x1a39-n0x1a40)  + I ps
	0x48a95982, // n0x0355 c0x0122 (n0x1a40-n0x1a49)  + I pt
	0x00296543, // n0x0356 c0x0000 (---------------)  + I pub
	0x48f8ae42, // n0x0357 c0x0123 (n0x1a49-n0x1a4f)  + I pw
	0x492be202, // n0x0358 c0x0124 (n0x1a4f-n0x1a56)  + I py
	0x496fd8c2, // n0x0359 c0x0125 (n0x1a56-n0x1a5f)  + I qa
	0x002ce804, // n0x035a c0x0000 (---------------)  + I qpon
	0x00211186, // n0x035b c0x0000 (---------------)  + I quebec
	0x00222685, // n0x035c c0x0000 (---------------)  + I quest
	0x00301a06, // n0x035d c0x0000 (---------------)  + I racing
	0x49a030c2, // n0x035e c0x0126 (n0x1a5f-n0x1a63)  + I re
	0x0033d884, // n0x035f c0x0000 (---------------)  + I read
	0x0032e0c7, // n0x0360 c0x0000 (---------------)  + I realtor
	0x0036b3c6, // n0x0361 c0x0000 (---------------)  + I realty
	0x00307487, // n0x0362 c0x0000 (---------------)  + I recipes
	0x00230683, // n0x0363 c0x0000 (---------------)  + I red
	0x0029d908, // n0x0364 c0x0000 (---------------)  + I redstone
	0x003237cb, // n0x0365 c0x0000 (---------------)  + I redumbrella
	0x002730c5, // n0x0366 c0x0000 (---------------)  + I rehab
	0x002e8505, // n0x0367 c0x0000 (---------------)  + I reise
	0x002e8506, // n0x0368 c0x0000 (---------------)  + I reisen
	0x002a45c4, // n0x0369 c0x0000 (---------------)  + I reit
	0x00365b48, // n0x036a c0x0000 (---------------)  + I reliance
	0x00210403, // n0x036b c0x0000 (---------------)  + I ren
	0x00210404, // n0x036c c0x0000 (---------------)  + I rent
	0x00210407, // n0x036d c0x0000 (---------------)  + I rentals
	0x002117c6, // n0x036e c0x0000 (---------------)  + I repair
	0x0030ea86, // n0x036f c0x0000 (---------------)  + I report
	0x002964ca, // n0x0370 c0x0000 (---------------)  + I republican
	0x00237dc4, // n0x0371 c0x0000 (---------------)  + I rest
	0x003386ca, // n0x0372 c0x0000 (---------------)  + I restaurant
	0x0031bd06, // n0x0373 c0x0000 (---------------)  + I review
	0x0031bd07, // n0x0374 c0x0000 (---------------)  + I reviews
	0x00243007, // n0x0375 c0x0000 (---------------)  + I rexroth
	0x002614c4, // n0x0376 c0x0000 (---------------)  + I rich
	0x002614c9, // n0x0377 c0x0000 (---------------)  + I richardli
	0x0024ea05, // n0x0378 c0x0000 (---------------)  + I ricoh
	0x00228f83, // n0x0379 c0x0000 (---------------)  + I ril
	0x0022ad03, // n0x037a c0x0000 (---------------)  + I rio
	0x0021dd83, // n0x037b c0x0000 (---------------)  + I rip
	0x49e00d82, // n0x037c c0x0127 (n0x1a63-n0x1a6f)  + I ro
	0x0028e886, // n0x037d c0x0000 (---------------)  + I rocher
	0x00297105, // n0x037e c0x0000 (---------------)  + I rocks
	0x002c1b45, // n0x037f c0x0000 (---------------)  + I rodeo
	0x0023a144, // n0x0380 c0x0000 (---------------)  + I room
	0x4a2060c2, // n0x0381 c0x0128 (n0x1a6f-n0x1a76)  + I rs
	0x00324a84, // n0x0382 c0x0000 (---------------)  + I rsvp
	0x4a6044c2, // n0x0383 c0x0129 (n0x1a76-n0x1afa)  + I ru
	0x0024f144, // n0x0384 c0x0000 (---------------)  + I ruhr
	0x002044c3, // n0x0385 c0x0000 (---------------)  + I run
	0x4ab0d882, // n0x0386 c0x012a (n0x1afa-n0x1b03)  + I rw
	0x0031d103, // n0x0387 c0x0000 (---------------)  + I rwe
	0x00289606, // n0x0388 c0x0000 (---------------)  + I ryukyu
	0x4ae01a02, // n0x0389 c0x012b (n0x1b03-n0x1b0b)  + I sa
	0x00272608, // n0x038a c0x0000 (---------------)  + I saarland
	0x00234784, // n0x038b c0x0000 (---------------)  + I safe
	0x00234786, // n0x038c c0x0000 (---------------)  + I safety
	0x002f4d46, // n0x038d c0x0000 (---------------)  + I sakura
	0x00244b04, // n0x038e c0x0000 (---------------)  + I sale
	0x00340885, // n0x038f c0x0000 (---------------)  + I salon
	0x00395107, // n0x0390 c0x0000 (---------------)  + I samsung
	0x0029c407, // n0x0391 c0x0000 (---------------)  + I sandvik
	0x0029c40f, // n0x0392 c0x0000 (---------------)  + I sandvikcoromant
	0x002098c6, // n0x0393 c0x0000 (---------------)  + I sanofi
	0x00210583, // n0x0394 c0x0000 (---------------)  + I sap
	0x00210584, // n0x0395 c0x0000 (---------------)  + I sapo
	0x0021d684, // n0x0396 c0x0000 (---------------)  + I sarl
	0x002275c3, // n0x0397 c0x0000 (---------------)  + I sas
	0x00219584, // n0x0398 c0x0000 (---------------)  + I save
	0x002332c4, // n0x0399 c0x0000 (---------------)  + I saxo
	0x4b2046c2, // n0x039a c0x012c (n0x1b0b-n0x1b10)  + I sb
	0x00277ac3, // n0x039b c0x0000 (---------------)  + I sbi
	0x002350c3, // n0x039c c0x0000 (---------------)  + I sbs
	0x4b600982, // n0x039d c0x012d (n0x1b10-n0x1b15)  + I sc
	0x00229183, // n0x039e c0x0000 (---------------)  + I sca
	0x00355d83, // n0x039f c0x0000 (---------------)  + I scb
	0x00206107, // n0x03a0 c0x0000 (---------------)  + I schmidt
	0x0023514c, // n0x03a1 c0x0000 (---------------)  + I scholarships
	0x00235406, // n0x03a2 c0x0000 (---------------)  + I school
	0x002c39c6, // n0x03a3 c0x0000 (---------------)  + I schule
	0x00370987, // n0x03a4 c0x0000 (---------------)  + I schwarz
	0x00223b07, // n0x03a5 c0x0000 (---------------)  + I science
	0x00212fc4, // n0x03a6 c0x0000 (---------------)  + I scor
	0x00237984, // n0x03a7 c0x0000 (---------------)  + I scot
	0x4ba4f842, // n0x03a8 c0x012e (n0x1b15-n0x1b1d)  + I sd
	0x4be02e82, // n0x03a9 c0x012f (n0x1b1d-n0x1b46)  + I se
	0x003004c4, // n0x03aa c0x0000 (---------------)  + I seat
	0x00223f88, // n0x03ab c0x0000 (---------------)  + I security
	0x00267bc4, // n0x03ac c0x0000 (---------------)  + I seek
	0x002ba785, // n0x03ad c0x0000 (---------------)  + I sener
	0x00243bc8, // n0x03ae c0x0000 (---------------)  + I services
	0x002476c3, // n0x03af c0x0000 (---------------)  + I sew
	0x0029acc3, // n0x03b0 c0x0000 (---------------)  + I sex
	0x0029acc4, // n0x03b1 c0x0000 (---------------)  + I sexy
	0x4c262dc2, // n0x03b2 c0x0130 (n0x1b46-n0x1b4d)  + I sg
	0x4c6001c2, // n0x03b3 c0x0131 (n0x1b4d-n0x1b53)  + I sh
	0x00255e05, // n0x03b4 c0x0000 (---------------)  + I sharp
	0x00256344, // n0x03b5 c0x0000 (---------------)  + I shaw
	0x00208c04, // n0x03b6 c0x0000 (---------------)  + I shia
	0x002cb1c7, // n0x03b7 c0x0000 (---------------)  + I shiksha
	0x00369905, // n0x03b8 c0x0000 (---------------)  + I shoes
	0x002b0e86, // n0x03b9 c0x0000 (---------------)  + I shouji
	0x002b3884, // n0x03ba c0x0000 (---------------)  + I show
	0x002b6b87, // n0x03bb c0x0000 (---------------)  + I shriram
	0x4ca09182, // n0x03bc c0x0132 (n0x1b53-n0x1b54)  + I si
	0x0036b904, // n0x03bd c0x0000 (---------------)  + I silk
	0x002914c4, // n0x03be c0x0000 (---------------)  + I sina
	0x00274247, // n0x03bf c0x0000 (---------------)  + I singles
	0x00242b84, // n0x03c0 c0x0000 (---------------)  + I site
	0x0022e942, // n0x03c1 c0x0000 (---------------)  + I sj
	0x4ce07b42, // n0x03c2 c0x0133 (n0x1b54-n0x1b55)  + I sk
	0x00207b43, // n0x03c3 c0x0000 (---------------)  + I ski
	0x002f3384, // n0x03c4 c0x0000 (---------------)  + I skin
	0x00229043, // n0x03c5 c0x0000 (---------------)  + I sky
	0x00229045, // n0x03c6 c0x0000 (---------------)  + I skype
	0x4d212582, // n0x03c7 c0x0134 (n0x1b55-n0x1b5a)  + I sl
	0x0023f582, // n0x03c8 c0x0000 (---------------)  + I sm
	0x0034b305, // n0x03c9 c0x0000 (---------------)  + I smile
	0x4d610b02, // n0x03ca c0x0135 (n0x1b5a-n0x1b62)  + I sn
	0x00310444, // n0x03cb c0x0000 (---------------)  + I sncf
	0x4da01102, // n0x03cc c0x0136 (n0x1b62-n0x1b65)  + I so
	0x00240a06, // n0x03cd c0x0000 (---------------)  + I soccer
	0x002c27c6, // n0x03ce c0x0000 (---------------)  + I social
	0x00258008, // n0x03cf c0x0000 (---------------)  + I softbank
	0x002a6c88, // n0x03d0 c0x0000 (---------------)  + I software
	0x002de604, // n0x03d1 c0x0000 (---------------)  + I sohu
	0x002d0205, // n0x03d2 c0x0000 (---------------)  + I solar
	0x002d9149, // n0x03d3 c0x0000 (---------------)  + I solutions
	0x00364504, // n0x03d4 c0x0000 (---------------)  + I song
	0x002bc184, // n0x03d5 c0x0000 (---------------)  + I sony
	0x00207fc3, // n0x03d6 c0x0000 (---------------)  + I soy
	0x002101c5, // n0x03d7 c0x0000 (---------------)  + I space
	0x00379247, // n0x03d8 c0x0000 (---------------)  + I spiegel
	0x00236a04, // n0x03d9 c0x0000 (---------------)  + I spot
	0x0033d80d, // n0x03da c0x0000 (---------------)  + I spreadbetting
	0x002ceec2, // n0x03db c0x0000 (---------------)  + I sr
	0x002ceec3, // n0x03dc c0x0000 (---------------)  + I srl
	0x4de023c2, // n0x03dd c0x0137 (n0x1b65-n0x1b71)  + I st
	0x0035bf05, // n0x03de c0x0000 (---------------)  + I stada
	0x00232444, // n0x03df c0x0000 (---------------)  + I star
	0x003191c7, // n0x03e0 c0x0000 (---------------)  + I starhub
	0x002b1889, // n0x03e1 c0x0000 (---------------)  + I statebank
	0x0029ca07, // n0x03e2 c0x0000 (---------------)  + I statoil
	0x00264603, // n0x03e3 c0x0000 (---------------)  + I stc
	0x00264608, // n0x03e4 c0x0000 (---------------)  + I stcgroup
	0x00259f09, // n0x03e5 c0x0000 (---------------)  + I stockholm
	0x002cf147, // n0x03e6 c0x0000 (---------------)  + I storage
	0x002cf4c5, // n0x03e7 c0x0000 (---------------)  + I store
	0x002cfc86, // n0x03e8 c0x0000 (---------------)  + I studio
	0x002cfe05, // n0x03e9 c0x0000 (---------------)  + I study
	0x00247945, // n0x03ea c0x0000 (---------------)  + I style
	0x4e203a42, // n0x03eb c0x0138 (n0x1b71-n0x1b91)  + I su
	0x002f0b45, // n0x03ec c0x0000 (---------------)  + I sucks
	0x002acd0a, // n0x03ed c0x0000 (---------------)  + I supersport
	0x002b49c8, // n0x03ee c0x0000 (---------------)  + I supplies
	0x002cccc6, // n0x03ef c0x0000 (---------------)  + I supply
	0x00243e87, // n0x03f0 c0x0000 (---------------)  + I support
	0x00287c84, // n0x03f1 c0x0000 (---------------)  + I surf
	0x00330647, // n0x03f2 c0x0000 (---------------)  + I surgery
	0x002d2f46, // n0x03f3 c0x0000 (---------------)  + I suzuki
	0x4e61d0c2, // n0x03f4 c0x0139 (n0x1b91-n0x1b96)  + I sv
	0x0020ac86, // n0x03f5 c0x0000 (---------------)  + I swatch
	0x002d6685, // n0x03f6 c0x0000 (---------------)  + I swiss
	0x4ead6b42, // n0x03f7 c0x013a (n0x1b96-n0x1b97)  + I sx
	0x4ee84ec2, // n0x03f8 c0x013b (n0x1b97-n0x1b9d)  + I sy
	0x00368086, // n0x03f9 c0x0000 (---------------)  + I sydney
	0x0029d448, // n0x03fa c0x0000 (---------------)  + I symantec
	0x00392447, // n0x03fb c0x0000 (---------------)  + I systems
	0x4f207582, // n0x03fc c0x013c (n0x1b9d-n0x1ba0)  + I sz
	0x0020c083, // n0x03fd c0x0000 (---------------)  + I tab
	0x00382f46, // n0x03fe c0x0000 (---------------)  + I taipei
	0x00216944, // n0x03ff c0x0000 (---------------)  + I talk
	0x003879c6, // n0x0400 c0x0000 (---------------)  + I taobao
	0x0031cbca, // n0x0401 c0x0000 (---------------)  + I tatamotors
	0x0031df05, // n0x0402 c0x0000 (---------------)  + I tatar
	0x0020f886, // n0x0403 c0x0000 (---------------)  + I tattoo
	0x00217c43, // n0x0404 c0x0000 (---------------)  + I tax
	0x00217c44, // n0x0405 c0x0000 (---------------)  + I taxi
	0x0020ad42, // n0x0406 c0x0000 (---------------)  + I tc
	0x002f4203, // n0x0407 c0x0000 (---------------)  + I tci
	0x4f600682, // n0x0408 c0x013d (n0x1ba0-n0x1ba1)  + I td
	0x002c9803, // n0x0409 c0x0000 (---------------)  + I tdk
	0x00354144, // n0x040a c0x0000 (---------------)  + I team
	0x0029d584, // n0x040b c0x0000 (---------------)  + I tech
	0x0029d58a, // n0x040c c0x0000 (---------------)  + I technology
	0x0022ba83, // n0x040d c0x0000 (---------------)  + I tel
	0x002734c8, // n0x040e c0x0000 (---------------)  + I telecity
	0x00250a0a, // n0x040f c0x0000 (---------------)  + I telefonica
	0x00325507, // n0x0410 c0x0000 (---------------)  + I temasek
	0x002dab46, // n0x0411 c0x0000 (---------------)  + I tennis
	0x0033f0c4, // n0x0412 c0x0000 (---------------)  + I teva
	0x0027e202, // n0x0413 c0x0000 (---------------)  + I tf
	0x0021e342, // n0x0414 c0x0000 (---------------)  + I tg
	0x4fa01d82, // n0x0415 c0x013e (n0x1ba1-n0x1ba8)  + I th
	0x00235c83, // n0x0416 c0x0000 (---------------)  + I thd
	0x002f9147, // n0x0417 c0x0000 (---------------)  + I theater
	0x00242d87, // n0x0418 c0x0000 (---------------)  + I theatre
	0x00377f8b, // n0x0419 c0x0000 (---------------)  + I theguardian
	0x00340707, // n0x041a c0x0000 (---------------)  + I tickets
	0x0021bb06, // n0x041b c0x0000 (---------------)  + I tienda
	0x00375107, // n0x041c c0x0000 (---------------)  + I tiffany
	0x00354984, // n0x041d c0x0000 (---------------)  + I tips
	0x00355585, // n0x041e c0x0000 (---------------)  + I tires
	0x002a4985, // n0x041f c0x0000 (---------------)  + I tirol
	0x4fe02bc2, // n0x0420 c0x013f (n0x1ba8-n0x1bb7)  + I tj
	0x0023a7c2, // n0x0421 c0x0000 (---------------)  + I tk
	0x5020fc42, // n0x0422 c0x0140 (n0x1bb7-n0x1bb8)  + I tl
	0x50608902, // n0x0423 c0x0141 (n0x1bb8-n0x1bc0)  + I tm
	0x0026a9c5, // n0x0424 c0x0000 (---------------)  + I tmall
	0x50a1d1c2, // n0x0425 c0x0142 (n0x1bc0-n0x1bd4)  + I tn
	0x50e01682, // n0x0426 c0x0143 (n0x1bd4-n0x1bda)  + I to
	0x00312e85, // n0x0427 c0x0000 (---------------)  + I today
	0x00316545, // n0x0428 c0x0000 (---------------)  + I tokyo
	0x0020f945, // n0x0429 c0x0000 (---------------)  + I tools
	0x002469c3, // n0x042a c0x0000 (---------------)  + I top
	0x00338cc5, // n0x042b c0x0000 (---------------)  + I toray
	0x002beb47, // n0x042c c0x0000 (---------------)  + I toshiba
	0x00339905, // n0x042d c0x0000 (---------------)  + I tours
	0x0021abc4, // n0x042e c0x0000 (---------------)  + I town
	0x00338906, // n0x042f c0x0000 (---------------)  + I toyota
	0x00247b04, // n0x0430 c0x0000 (---------------)  + I toys
	0x00285142, // n0x0431 c0x0000 (---------------)  + I tp
	0x51202402, // n0x0432 c0x0144 (n0x1bda-n0x1bef)  + I tr
	0x00229a45, // n0x0433 c0x0000 (---------------)  + I trade
	0x0028fe07, // n0x0434 c0x0000 (---------------)  + I trading
	0x002b9748, // n0x0435 c0x0000 (---------------)  + I training
	0x0027f186, // n0x0436 c0x0000 (---------------)  + I travel
	0x0027f18d, // n0x0437 c0x0000 (---------------)  + I travelchannel
	0x00280489, // n0x0438 c0x0000 (---------------)  + I travelers
	0x00280492, // n0x0439 c0x0000 (---------------)  + I travelersinsurance
	0x00313185, // n0x043a c0x0000 (---------------)  + I trust
	0x0034a4c3, // n0x043b c0x0000 (---------------)  + I trv
	0x51e06582, // n0x043c c0x0147 (n0x1bf1-n0x1c02)  + I tt
	0x0035a104, // n0x043d c0x0000 (---------------)  + I tube
	0x002d71c3, // n0x043e c0x0000 (---------------)  + I tui
	0x002d83c5, // n0x043f c0x0000 (---------------)  + I tunes
	0x002d8e45, // n0x0440 c0x0000 (---------------)  + I tushu
	0x5220bf42, // n0x0441 c0x0148 (n0x1c02-n0x1c06)  + I tv
	0x0020bf43, // n0x0442 c0x0000 (---------------)  + I tvs
	0x52641ac2, // n0x0443 c0x0149 (n0x1c06-n0x1c14)  + I tw
	0x52a17142, // n0x0444 c0x014a (n0x1c14-n0x1c20)  + I tz
	0x52e17d82, // n0x0445 c0x014b (n0x1c20-n0x1c6e)  + I ua
	0x0032ba03, // n0x0446 c0x0000 (---------------)  + I ubs
	0x53205082, // n0x0447 c0x014c (n0x1c6e-n0x1c77)  + I ug
	0x5360cf02, // n0x0448 c0x014d (n0x1c77-n0x1c82)  + I uk
	0x0029f04a, // n0x0449 c0x0000 (---------------)  + I university
	0x00203a83, // n0x044a c0x0000 (---------------)  + I uno
	0x00245543, // n0x044b c0x0000 (---------------)  + I uol
	0x002c16c3, // n0x044c c0x0000 (---------------)  + I ups
	0x54209f42, // n0x044d c0x0150 (n0x1c84-n0x1cc3)  + I us
	0x62606842, // n0x044e c0x0189 (n0x1d66-n0x1d6c)  + I uy
	0x62e018c2, // n0x044f c0x018b (n0x1d6d-n0x1d71)  + I uz
	0x002013c2, // n0x0450 c0x0000 (---------------)  + I va
	0x00340209, // n0x0451 c0x0000 (---------------)  + I vacations
	0x002aba84, // n0x0452 c0x0000 (---------------)  + I vana
	0x6334a542, // n0x0453 c0x018c (n0x1d71-n0x1d77)  + I vc
	0x636014c2, // n0x0454 c0x018d (n0x1d77-n0x1d88)  + I ve
	0x0027d4c5, // n0x0455 c0x0000 (---------------)  + I vegas
	0x00227248, // n0x0456 c0x0000 (---------------)  + I ventures
	0x002d998c, // n0x0457 c0x0000 (---------------)  + I versicherung
	0x0022b9c3, // n0x0458 c0x0000 (---------------)  + I vet
	0x0024ad42, // n0x0459 c0x0000 (---------------)  + I vg
	0x63a13602, // n0x045a c0x018e (n0x1d88-n0x1d8d)  + I vi
	0x002b4346, // n0x045b c0x0000 (---------------)  + I viajes
	0x002db9c5, // n0x045c c0x0000 (---------------)  + I video
	0x002b1403, // n0x045d c0x0000 (---------------)  + I vig
	0x002c7686, // n0x045e c0x0000 (---------------)  + I viking
	0x002dbb06, // n0x045f c0x0000 (---------------)  + I villas
	0x00213603, // n0x0460 c0x0000 (---------------)  + I vin
	0x002dc703, // n0x0461 c0x0000 (---------------)  + I vip
	0x002dd146, // n0x0462 c0x0000 (---------------)  + I virgin
	0x00248b46, // n0x0463 c0x0000 (---------------)  + I vision
	0x002b85c5, // n0x0464 c0x0000 (---------------)  + I vista
	0x002dd6ca, // n0x0465 c0x0000 (---------------)  + I vistaprint
	0x0022cf04, // n0x0466 c0x0000 (---------------)  + I viva
	0x00332eca, // n0x0467 c0x0000 (---------------)  + I vlaanderen
	0x63e08102, // n0x0468 c0x018f (n0x1d8d-n0x1d9a)  + I vn
	0x002716c5, // n0x0469 c0x0000 (---------------)  + I vodka
	0x002e0c8a, // n0x046a c0x0000 (---------------)  + I volkswagen
	0x002e2484, // n0x046b c0x0000 (---------------)  + I vote
	0x002e2586, // n0x046c c0x0000 (---------------)  + I voting
	0x002e2704, // n0x046d c0x0000 (---------------)  + I voto
	0x0030c486, // n0x046e c0x0000 (---------------)  + I voyage
	0x6421d102, // n0x046f c0x0190 (n0x1d9a-n0x1d9e)  + I vu
	0x002a4e86, // n0x0470 c0x0000 (---------------)  + I vuelos
	0x0036cbc5, // n0x0471 c0x0000 (---------------)  + I wales
	0x0038b0c6, // n0x0472 c0x0000 (---------------)  + I walter
	0x003578c4, // n0x0473 c0x0000 (---------------)  + I wang
	0x003578c7, // n0x0474 c0x0000 (---------------)  + I wanggou
	0x00351a06, // n0x0475 c0x0000 (---------------)  + I warman
	0x0020acc5, // n0x0476 c0x0000 (---------------)  + I watch
	0x00293647, // n0x0477 c0x0000 (---------------)  + I watches
	0x00384107, // n0x0478 c0x0000 (---------------)  + I weather
	0x0038410e, // n0x0479 c0x0000 (---------------)  + I weatherchannel
	0x00219fc6, // n0x047a c0x0000 (---------------)  + I webcam
	0x00251cc5, // n0x047b c0x0000 (---------------)  + I weber
	0x002af047, // n0x047c c0x0000 (---------------)  + I website
	0x002d4bc3, // n0x047d c0x0000 (---------------)  + I wed
	0x0031c007, // n0x047e c0x0000 (---------------)  + I wedding
	0x003912c5, // n0x047f c0x0000 (---------------)  + I weibo
	0x0020a184, // n0x0480 c0x0000 (---------------)  + I weir
	0x0021f7c2, // n0x0481 c0x0000 (---------------)  + I wf
	0x002c7207, // n0x0482 c0x0000 (---------------)  + I whoswho
	0x002d2e44, // n0x0483 c0x0000 (---------------)  + I wien
	0x0025a484, // n0x0484 c0x0000 (---------------)  + I wiki
	0x0024910b, // n0x0485 c0x0000 (---------------)  + I williamhill
	0x00213c83, // n0x0486 c0x0000 (---------------)  + I win
	0x002b6a07, // n0x0487 c0x0000 (---------------)  + I windows
	0x00213c84, // n0x0488 c0x0000 (---------------)  + I wine
	0x00231fc3, // n0x0489 c0x0000 (---------------)  + I wme
	0x00241b04, // n0x048a c0x0000 (---------------)  + I work
	0x0029b085, // n0x048b c0x0000 (---------------)  + I works
	0x00314905, // n0x048c c0x0000 (---------------)  + I world
	0x6460ba82, // n0x048d c0x0191 (n0x1d9e-n0x1da5)  + I ws
	0x002e34c3, // n0x048e c0x0000 (---------------)  + I wtc
	0x002e3b03, // n0x048f c0x0000 (---------------)  + I wtf
	0x0020a6c4, // n0x0490 c0x0000 (---------------)  + I xbox
	0x0020a785, // n0x0491 c0x0000 (---------------)  + I xerox
	0x00217cc6, // n0x0492 c0x0000 (---------------)  + I xihuan
	0x00356e83, // n0x0493 c0x0000 (---------------)  + I xin
	0x002358cb, // n0x0494 c0x0000 (---------------)  + I xn--11b4c3d
	0x0023d74b, // n0x0495 c0x0000 (---------------)  + I xn--1ck2e1b
	0x00291d4b, // n0x0496 c0x0000 (---------------)  + I xn--1qqw23a
	0x002bfeca, // n0x0497 c0x0000 (---------------)  + I xn--30rr7y
	0x0033588b, // n0x0498 c0x0000 (---------------)  + I xn--3bst00m
	0x003942cb, // n0x0499 c0x0000 (---------------)  + I xn--3ds443g
	0x0039658c, // n0x049a c0x0000 (---------------)  + I xn--3e0b707e
	0x00397251, // n0x049b c0x0000 (---------------)  + I xn--3oq18vl8pn36a
	0x002e480a, // n0x049c c0x0000 (---------------)  + I xn--3pxu8k
	0x002e4bcb, // n0x049d c0x0000 (---------------)  + I xn--42c2d9a
	0x002e4e8b, // n0x049e c0x0000 (---------------)  + I xn--45brj9c
	0x002e6d4a, // n0x049f c0x0000 (---------------)  + I xn--45q11c
	0x002e780a, // n0x04a0 c0x0000 (---------------)  + I xn--4gbrim
	0x002e8b8e, // n0x04a1 c0x0000 (---------------)  + I xn--54b7fta0cc
	0x002e9e4b, // n0x04a2 c0x0000 (---------------)  + I xn--55qw42g
	0x002ea10a, // n0x04a3 c0x0000 (---------------)  + I xn--55qx5d
	0x002eb14a, // n0x04a4 c0x0000 (---------------)  + I xn--5tzm5g
	0x002eb64b, // n0x04a5 c0x0000 (---------------)  + I xn--6frz82g
	0x002ebb8e, // n0x04a6 c0x0000 (---------------)  + I xn--6qq986b3xl
	0x002ec6cc, // n0x04a7 c0x0000 (---------------)  + I xn--80adxhks
	0x002ecb4b, // n0x04a8 c0x0000 (---------------)  + I xn--80ao21a
	0x002ece0c, // n0x04a9 c0x0000 (---------------)  + I xn--80asehdb
	0x002f108a, // n0x04aa c0x0000 (---------------)  + I xn--80aswg
	0x002f228c, // n0x04ab c0x0000 (---------------)  + I xn--8y0a063a
	0x64af258a, // n0x04ac c0x0192 (n0x1da5-n0x1dab)  + I xn--90a3ac
	0x002f5849, // n0x04ad c0x0000 (---------------)  + I xn--90ais
	0x002f664a, // n0x04ae c0x0000 (---------------)  + I xn--9dbq2a
	0x002f68ca, // n0x04af c0x0000 (---------------)  + I xn--9et52u
	0x002f6b4b, // n0x04b0 c0x0000 (---------------)  + I xn--9krt00a
	0x002fa44e, // n0x04b1 c0x0000 (---------------)  + I xn--b4w605ferd
	0x002fa7d1, // n0x04b2 c0x0000 (---------------)  + I xn--bck1b9a5dre4c
	0x00303289, // n0x04b3 c0x0000 (---------------)  + I xn--c1avg
	0x003034ca, // n0x04b4 c0x0000 (---------------)  + I xn--c2br7g
	0x00303e0b, // n0x04b5 c0x0000 (---------------)  + I xn--cck2b3b
	0x0030618a, // n0x04b6 c0x0000 (---------------)  + I xn--cg4bki
	0x00306d16, // n0x04b7 c0x0000 (---------------)  + I xn--clchc0ea0b2g2a9gcd
	0x003091cb, // n0x04b8 c0x0000 (---------------)  + I xn--czr694b
	0x0030a9ca, // n0x04b9 c0x0000 (---------------)  + I xn--czrs0t
	0x0030d48a, // n0x04ba c0x0000 (---------------)  + I xn--czru2d
	0x0030f2cb, // n0x04bb c0x0000 (---------------)  + I xn--d1acj3b
	0x003125c9, // n0x04bc c0x0000 (---------------)  + I xn--d1alf
	0x0031508d, // n0x04bd c0x0000 (---------------)  + I xn--eckvdtc9d
	0x003167cb, // n0x04be c0x0000 (---------------)  + I xn--efvy88h
	0x003178cb, // n0x04bf c0x0000 (---------------)  + I xn--estv75g
	0x0031828b, // n0x04c0 c0x0000 (---------------)  + I xn--fct429k
	0x00319909, // n0x04c1 c0x0000 (---------------)  + I xn--fhbei
	0x00319f4e, // n0x04c2 c0x0000 (---------------)  + I xn--fiq228c5hs
	0x0031a48a, // n0x04c3 c0x0000 (---------------)  + I xn--fiq64b
	0x0031ec0a, // n0x04c4 c0x0000 (---------------)  + I xn--fiqs8s
	0x0031f0ca, // n0x04c5 c0x0000 (---------------)  + I xn--fiqz9s
	0x0031fa8b, // n0x04c6 c0x0000 (---------------)  + I xn--fjq720a
	0x003202cb, // n0x04c7 c0x0000 (---------------)  + I xn--flw351e
	0x0032058d, // n0x04c8 c0x0000 (---------------)  + I xn--fpcrj9c3d
	0x00321e0d, // n0x04c9 c0x0000 (---------------)  + I xn--fzc2c9e2c
	0x00322dd0, // n0x04ca c0x0000 (---------------)  + I xn--fzys8d69uvgm
	0x0032328b, // n0x04cb c0x0000 (---------------)  + I xn--g2xx48c
	0x00323ecc, // n0x04cc c0x0000 (---------------)  + I xn--gckr3f0f
	0x0032434b, // n0x04cd c0x0000 (---------------)  + I xn--gecrj9c
	0x0032880b, // n0x04ce c0x0000 (---------------)  + I xn--h2brj9c
	0x0032f14b, // n0x04cf c0x0000 (---------------)  + I xn--hxt814e
	0x0032fbcf, // n0x04d0 c0x0000 (---------------)  + I xn--i1b6b1a6a2e
	0x0032ff8b, // n0x04d1 c0x0000 (---------------)  + I xn--imr513n
	0x0033080a, // n0x04d2 c0x0000 (---------------)  + I xn--io0a7i
	0x00331249, // n0x04d3 c0x0000 (---------------)  + I xn--j1aef
	0x003315c9, // n0x04d4 c0x0000 (---------------)  + I xn--j1amh
	0x0033198b, // n0x04d5 c0x0000 (---------------)  + I xn--j6w193g
	0x00331c4e, // n0x04d6 c0x0000 (---------------)  + I xn--jlq61u9w7b
	0x0033354b, // n0x04d7 c0x0000 (---------------)  + I xn--jvr189m
	0x0033444f, // n0x04d8 c0x0000 (---------------)  + I xn--kcrx77d1x4a
	0x00337d8b, // n0x04d9 c0x0000 (---------------)  + I xn--kprw13d
	0x0033804b, // n0x04da c0x0000 (---------------)  + I xn--kpry57d
	0x0033830b, // n0x04db c0x0000 (---------------)  + I xn--kpu716f
	0x00338e0a, // n0x04dc c0x0000 (---------------)  + I xn--kput3i
	0x0033db49, // n0x04dd c0x0000 (---------------)  + I xn--l1acc
	0x00344dcf, // n0x04de c0x0000 (---------------)  + I xn--lgbbat1ad8j
	0x0034978c, // n0x04df c0x0000 (---------------)  + I xn--mgb2ddes
	0x00349c8c, // n0x04e0 c0x0000 (---------------)  + I xn--mgb9awbf
	0x0034a18e, // n0x04e1 c0x0000 (---------------)  + I xn--mgba3a3ejt
	0x0034a88f, // n0x04e2 c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0034ac4e, // n0x04e3 c0x0000 (---------------)  + I xn--mgba3a4fra
	0x0034b750, // n0x04e4 c0x0000 (---------------)  + I xn--mgba7c0bbn0a
	0x0034bb4e, // n0x04e5 c0x0000 (---------------)  + I xn--mgbaam7a8h
	0x0034c10c, // n0x04e6 c0x0000 (---------------)  + I xn--mgbab2bd
	0x0034c412, // n0x04e7 c0x0000 (---------------)  + I xn--mgbai9a5eva00b
	0x0034f091, // n0x04e8 c0x0000 (---------------)  + I xn--mgbai9azgqp6j
	0x0034f64e, // n0x04e9 c0x0000 (---------------)  + I xn--mgbayh7gpa
	0x0034fa8e, // n0x04ea c0x0000 (---------------)  + I xn--mgbb9fbpob
	0x0034ffce, // n0x04eb c0x0000 (---------------)  + I xn--mgbbh1a71e
	0x0035034f, // n0x04ec c0x0000 (---------------)  + I xn--mgbc0a9azcg
	0x00350713, // n0x04ed c0x0000 (---------------)  + I xn--mgberp4a5d4a87g
	0x00350bd1, // n0x04ee c0x0000 (---------------)  + I xn--mgberp4a5d4ar
	0x0035100c, // n0x04ef c0x0000 (---------------)  + I xn--mgbpl2fh
	0x00351453, // n0x04f0 c0x0000 (---------------)  + I xn--mgbqly7c0a67fbc
	0x00352310, // n0x04f1 c0x0000 (---------------)  + I xn--mgbqly7cvafr
	0x00352e0c, // n0x04f2 c0x0000 (---------------)  + I xn--mgbt3dhd
	0x0035310c, // n0x04f3 c0x0000 (---------------)  + I xn--mgbtf8fl
	0x003535cb, // n0x04f4 c0x0000 (---------------)  + I xn--mgbtx2b
	0x0035588e, // n0x04f5 c0x0000 (---------------)  + I xn--mgbx4cd0ab
	0x00355e8b, // n0x04f6 c0x0000 (---------------)  + I xn--mix082f
	0x003564cb, // n0x04f7 c0x0000 (---------------)  + I xn--mix891f
	0x0035728c, // n0x04f8 c0x0000 (---------------)  + I xn--mk1bu44c
	0x0035c6ca, // n0x04f9 c0x0000 (---------------)  + I xn--mxtq1m
	0x0035ca8c, // n0x04fa c0x0000 (---------------)  + I xn--ngbc5azd
	0x0035cd8c, // n0x04fb c0x0000 (---------------)  + I xn--ngbe9e0a
	0x0035f64b, // n0x04fc c0x0000 (---------------)  + I xn--nnx388a
	0x0035f908, // n0x04fd c0x0000 (---------------)  + I xn--node
	0x00360249, // n0x04fe c0x0000 (---------------)  + I xn--nqv7f
	0x0036024f, // n0x04ff c0x0000 (---------------)  + I xn--nqv7fs00ema
	0x00361f8b, // n0x0500 c0x0000 (---------------)  + I xn--nyqy26a
	0x003633ca, // n0x0501 c0x0000 (---------------)  + I xn--o3cw4h
	0x00364d8c, // n0x0502 c0x0000 (---------------)  + I xn--ogbpf8fl
	0x00366089, // n0x0503 c0x0000 (---------------)  + I xn--p1acf
	0x00366308, // n0x0504 c0x0000 (---------------)  + I xn--p1ai
	0x00366f8b, // n0x0505 c0x0000 (---------------)  + I xn--pbt977c
	0x003676cb, // n0x0506 c0x0000 (---------------)  + I xn--pgbs0dh
	0x00368a8a, // n0x0507 c0x0000 (---------------)  + I xn--pssy2u
	0x00368d0b, // n0x0508 c0x0000 (---------------)  + I xn--q9jyb4c
	0x0036944c, // n0x0509 c0x0000 (---------------)  + I xn--qcka1pmc
	0x0036a988, // n0x050a c0x0000 (---------------)  + I xn--qxam
	0x0037230b, // n0x050b c0x0000 (---------------)  + I xn--rhqv96g
	0x00374d8b, // n0x050c c0x0000 (---------------)  + I xn--rovu88b
	0x0037824b, // n0x050d c0x0000 (---------------)  + I xn--s9brj9c
	0x00379a8b, // n0x050e c0x0000 (---------------)  + I xn--ses554g
	0x00383c8b, // n0x050f c0x0000 (---------------)  + I xn--t60b56a
	0x00383f49, // n0x0510 c0x0000 (---------------)  + I xn--tckwe
	0x00387fca, // n0x0511 c0x0000 (---------------)  + I xn--unup4y
	0x00388f17, // n0x0512 c0x0000 (---------------)  + I xn--vermgensberater-ctb
	0x0038a918, // n0x0513 c0x0000 (---------------)  + I xn--vermgensberatung-pwb
	0x0038dcc9, // n0x0514 c0x0000 (---------------)  + I xn--vhquv
	0x0038f00b, // n0x0515 c0x0000 (---------------)  + I xn--vuq861b
	0x0038fb94, // n0x0516 c0x0000 (---------------)  + I xn--w4r85el8fhu5dnra
	0x0039034a, // n0x0517 c0x0000 (---------------)  + I xn--wgbh1c
	0x0039090a, // n0x0518 c0x0000 (---------------)  + I xn--wgbl6a
	0x00390b8b, // n0x0519 c0x0000 (---------------)  + I xn--xhq521b
	0x00391a90, // n0x051a c0x0000 (---------------)  + I xn--xkc2al3hye2a
	0x00391e91, // n0x051b c0x0000 (---------------)  + I xn--xkc2dl3a5ee0h
	0x0039290a, // n0x051c c0x0000 (---------------)  + I xn--y9a3aq
	0x003938cd, // n0x051d c0x0000 (---------------)  + I xn--yfro4i67o
	0x00393fcd, // n0x051e c0x0000 (---------------)  + I xn--ygbi2ammx
	0x0039688b, // n0x051f c0x0000 (---------------)  + I xn--zfr164b
	0x00397046, // n0x0520 c0x0000 (---------------)  + I xperia
	0x003971c3, // n0x0521 c0x0000 (---------------)  + I xxx
	0x0029ad43, // n0x0522 c0x0000 (---------------)  + I xyz
	0x00269586, // n0x0523 c0x0000 (---------------)  + I yachts
	0x0027b905, // n0x0524 c0x0000 (---------------)  + I yahoo
	0x002151c7, // n0x0525 c0x0000 (---------------)  + I yamaxun
	0x00326dc6, // n0x0526 c0x0000 (---------------)  + I yandex
	0x01614d82, // n0x0527 c0x0005 (---------------)* o I ye
	0x002e3609, // n0x0528 c0x0000 (---------------)  + I yodobashi
	0x00301804, // n0x0529 c0x0000 (---------------)  + I yoga
	0x0032b5c8, // n0x052a c0x0000 (---------------)  + I yokohama
	0x00235bc3, // n0x052b c0x0000 (---------------)  + I you
	0x0035a047, // n0x052c c0x0000 (---------------)  + I youtube
	0x0022f542, // n0x052d c0x0000 (---------------)  + I yt
	0x00201943, // n0x052e c0x0000 (---------------)  + I yun
	0x64e043c2, // n0x052f c0x0193 (n0x1dab-n0x1dbc)  o I za
	0x002b3106, // n0x0530 c0x0000 (---------------)  + I zappos
	0x002b3c84, // n0x0531 c0x0000 (---------------)  + I zara
	0x00311384, // n0x0532 c0x0000 (---------------)  + I zero
	0x0023b443, // n0x0533 c0x0000 (---------------)  + I zip
	0x0023b445, // n0x0534 c0x0000 (---------------)  + I zippo
	0x016e4582, // n0x0535 c0x0005 (---------------)* o I zm
	0x002c7ec4, // n0x0536 c0x0000 (---------------)  + I zone
	0x00261407, // n0x0537 c0x0000 (---------------)  + I zuerich
	0x016a0202, // n0x0538 c0x0005 (---------------)* o I zw
	0x00222ac3, // n0x0539 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x053a c0x0000 (---------------)  + I edu
	0x0021e283, // n0x053b c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x053c c0x0000 (---------------)  + I mil
	0x002170c3, // n0x053d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x053e c0x0000 (---------------)  + I org
	0x00207cc3, // n0x053f c0x0000 (---------------)  + I nom
	0x00201e82, // n0x0540 c0x0000 (---------------)  + I ac
	0x000e4188, // n0x0541 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x0542 c0x0000 (---------------)  + I co
	0x0021e283, // n0x0543 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x0544 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x0545 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0546 c0x0000 (---------------)  + I org
	0x00206103, // n0x0547 c0x0000 (---------------)  + I sch
	0x002ffad6, // n0x0548 c0x0000 (---------------)  + I accident-investigation
	0x00301f93, // n0x0549 c0x0000 (---------------)  + I accident-prevention
	0x00340589, // n0x054a c0x0000 (---------------)  + I aerobatic
	0x002751c8, // n0x054b c0x0000 (---------------)  + I aeroclub
	0x0036bb09, // n0x054c c0x0000 (---------------)  + I aerodrome
	0x002e0e06, // n0x054d c0x0000 (---------------)  + I agents
	0x0032cf10, // n0x054e c0x0000 (---------------)  + I air-surveillance
	0x00211893, // n0x054f c0x0000 (---------------)  + I air-traffic-control
	0x002fb3c8, // n0x0550 c0x0000 (---------------)  + I aircraft
	0x00262307, // n0x0551 c0x0000 (---------------)  + I airline
	0x00266e47, // n0x0552 c0x0000 (---------------)  + I airport
	0x0028bd4a, // n0x0553 c0x0000 (---------------)  + I airtraffic
	0x003541c9, // n0x0554 c0x0000 (---------------)  + I ambulance
	0x00309f89, // n0x0555 c0x0000 (---------------)  + I amusement
	0x002bbacb, // n0x0556 c0x0000 (---------------)  + I association
	0x002f8406, // n0x0557 c0x0000 (---------------)  + I author
	0x002ed6ca, // n0x0558 c0x0000 (---------------)  + I ballooning
	0x00218046, // n0x0559 c0x0000 (---------------)  + I broker
	0x00301403, // n0x055a c0x0000 (---------------)  + I caa
	0x002dc1c5, // n0x055b c0x0000 (---------------)  + I cargo
	0x003246c8, // n0x055c c0x0000 (---------------)  + I catering
	0x00240acd, // n0x055d c0x0000 (---------------)  + I certification
	0x0032cacc, // n0x055e c0x0000 (---------------)  + I championship
	0x0036c887, // n0x055f c0x0000 (---------------)  + I charter
	0x00328a8d, // n0x0560 c0x0000 (---------------)  + I civilaviation
	0x002752c4, // n0x0561 c0x0000 (---------------)  + I club
	0x0022498a, // n0x0562 c0x0000 (---------------)  + I conference
	0x002255ca, // n0x0563 c0x0000 (---------------)  + I consultant
	0x00225a8a, // n0x0564 c0x0000 (---------------)  + I consulting
	0x00211b87, // n0x0565 c0x0000 (---------------)  + I control
	0x0022cd47, // n0x0566 c0x0000 (---------------)  + I council
	0x00231004, // n0x0567 c0x0000 (---------------)  + I crew
	0x00232f46, // n0x0568 c0x0000 (---------------)  + I design
	0x002727c4, // n0x0569 c0x0000 (---------------)  + I dgca
	0x00336208, // n0x056a c0x0000 (---------------)  + I educator
	0x00343bc9, // n0x056b c0x0000 (---------------)  + I emergency
	0x002a8a86, // n0x056c c0x0000 (---------------)  + I engine
	0x002a8a88, // n0x056d c0x0000 (---------------)  + I engineer
	0x00233a4d, // n0x056e c0x0000 (---------------)  + I entertainment
	0x0021f909, // n0x056f c0x0000 (---------------)  + I equipment
	0x002f3908, // n0x0570 c0x0000 (---------------)  + I exchange
	0x0029ab47, // n0x0571 c0x0000 (---------------)  + I express
	0x0026ac0a, // n0x0572 c0x0000 (---------------)  + I federation
	0x0023b146, // n0x0573 c0x0000 (---------------)  + I flight
	0x00248ec7, // n0x0574 c0x0000 (---------------)  + I freight
	0x0024d004, // n0x0575 c0x0000 (---------------)  + I fuel
	0x00256007, // n0x0576 c0x0000 (---------------)  + I gliding
	0x00259a0a, // n0x0577 c0x0000 (---------------)  + I government
	0x0037868e, // n0x0578 c0x0000 (---------------)  + I groundhandling
	0x002646c5, // n0x0579 c0x0000 (---------------)  + I group
	0x0038718b, // n0x057a c0x0000 (---------------)  + I hanggliding
	0x00278ac9, // n0x057b c0x0000 (---------------)  + I homebuilt
	0x002806c9, // n0x057c c0x0000 (---------------)  + I insurance
	0x00202987, // n0x057d c0x0000 (---------------)  + I journal
	0x0020298a, // n0x057e c0x0000 (---------------)  + I journalist
	0x00274187, // n0x057f c0x0000 (---------------)  + I leasing
	0x002127c9, // n0x0580 c0x0000 (---------------)  + I logistics
	0x00395948, // n0x0581 c0x0000 (---------------)  + I magazine
	0x002a0c8b, // n0x0582 c0x0000 (---------------)  + I maintenance
	0x003117cb, // n0x0583 c0x0000 (---------------)  + I marketplace
	0x002dc385, // n0x0584 c0x0000 (---------------)  + I media
	0x00236c8a, // n0x0585 c0x0000 (---------------)  + I microlight
	0x002371c9, // n0x0586 c0x0000 (---------------)  + I modelling
	0x00354cca, // n0x0587 c0x0000 (---------------)  + I navigation
	0x0022948b, // n0x0588 c0x0000 (---------------)  + I parachuting
	0x00255f0b, // n0x0589 c0x0000 (---------------)  + I paragliding
	0x002bb855, // n0x058a c0x0000 (---------------)  + I passenger-association
	0x002c1505, // n0x058b c0x0000 (---------------)  + I pilot
	0x0029abc5, // n0x058c c0x0000 (---------------)  + I press
	0x002cbe4a, // n0x058d c0x0000 (---------------)  + I production
	0x002e634a, // n0x058e c0x0000 (---------------)  + I recreation
	0x002e0107, // n0x058f c0x0000 (---------------)  + I repbody
	0x00215503, // n0x0590 c0x0000 (---------------)  + I res
	0x00296808, // n0x0591 c0x0000 (---------------)  + I research
	0x002bc30a, // n0x0592 c0x0000 (---------------)  + I rotorcraft
	0x00234786, // n0x0593 c0x0000 (---------------)  + I safety
	0x0023f089, // n0x0594 c0x0000 (---------------)  + I scientist
	0x00243bc8, // n0x0595 c0x0000 (---------------)  + I services
	0x002b3884, // n0x0596 c0x0000 (---------------)  + I show
	0x00253c09, // n0x0597 c0x0000 (---------------)  + I skydiving
	0x002a6c88, // n0x0598 c0x0000 (---------------)  + I software
	0x00298587, // n0x0599 c0x0000 (---------------)  + I student
	0x00217c44, // n0x059a c0x0000 (---------------)  + I taxi
	0x00229a46, // n0x059b c0x0000 (---------------)  + I trader
	0x0028fe07, // n0x059c c0x0000 (---------------)  + I trading
	0x0028aec7, // n0x059d c0x0000 (---------------)  + I trainer
	0x00230a45, // n0x059e c0x0000 (---------------)  + I union
	0x002e04cc, // n0x059f c0x0000 (---------------)  + I workinggroup
	0x0029b085, // n0x05a0 c0x0000 (---------------)  + I works
	0x00222ac3, // n0x05a1 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x05a2 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x05a3 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x05a4 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x05a5 c0x0000 (---------------)  + I org
	0x00200742, // n0x05a6 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x05a7 c0x0000 (---------------)  + I com
	0x002170c3, // n0x05a8 c0x0000 (---------------)  + I net
	0x00207cc3, // n0x05a9 c0x0000 (---------------)  + I nom
	0x0021dcc3, // n0x05aa c0x0000 (---------------)  + I org
	0x00222ac3, // n0x05ab c0x0000 (---------------)  + I com
	0x002170c3, // n0x05ac c0x0000 (---------------)  + I net
	0x00219c43, // n0x05ad c0x0000 (---------------)  + I off
	0x0021dcc3, // n0x05ae c0x0000 (---------------)  + I org
	0x000e4188, // n0x05af c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x05b0 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x05b1 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x05b2 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x05b3 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x05b4 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x05b5 c0x0000 (---------------)  + I org
	0x000e4188, // n0x05b6 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x05b7 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x05b8 c0x0000 (---------------)  + I edu
	0x002170c3, // n0x05b9 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x05ba c0x0000 (---------------)  + I org
	0x00200742, // n0x05bb c0x0000 (---------------)  + I co
	0x00203fc2, // n0x05bc c0x0000 (---------------)  + I ed
	0x00225cc2, // n0x05bd c0x0000 (---------------)  + I gv
	0x00206e82, // n0x05be c0x0000 (---------------)  + I it
	0x002003c2, // n0x05bf c0x0000 (---------------)  + I og
	0x00268e82, // n0x05c0 c0x0000 (---------------)  + I pb
	0x04a22ac3, // n0x05c1 c0x0012 (n0x05ca-n0x05cb)  + I com
	0x002d75c3, // n0x05c2 c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x05c3 c0x0000 (---------------)  + I gob
	0x0021e283, // n0x05c4 c0x0000 (---------------)  + I gov
	0x00238c03, // n0x05c5 c0x0000 (---------------)  + I int
	0x0023fa03, // n0x05c6 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x05c7 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x05c8 c0x0000 (---------------)  + I org
	0x00227303, // n0x05c9 c0x0000 (---------------)  + I tur
	0x000e4188, // n0x05ca c0x0000 (---------------)  +   blogspot
	0x002f5744, // n0x05cb c0x0000 (---------------)  + I e164
	0x0034d5c7, // n0x05cc c0x0000 (---------------)  + I in-addr
	0x00213a43, // n0x05cd c0x0000 (---------------)  + I ip6
	0x00234684, // n0x05ce c0x0000 (---------------)  + I iris
	0x00202803, // n0x05cf c0x0000 (---------------)  + I uri
	0x00202a03, // n0x05d0 c0x0000 (---------------)  + I urn
	0x0021e283, // n0x05d1 c0x0000 (---------------)  + I gov
	0x00201e82, // n0x05d2 c0x0000 (---------------)  + I ac
	0x00110603, // n0x05d3 c0x0000 (---------------)  +   biz
	0x05a00742, // n0x05d4 c0x0016 (n0x05d9-n0x05da)  + I co
	0x00225cc2, // n0x05d5 c0x0000 (---------------)  + I gv
	0x00000304, // n0x05d6 c0x0000 (---------------)  +   info
	0x00200c42, // n0x05d7 c0x0000 (---------------)  + I or
	0x000cba44, // n0x05d8 c0x0000 (---------------)  +   priv
	0x000e4188, // n0x05d9 c0x0000 (---------------)  +   blogspot
	0x00226043, // n0x05da c0x0000 (---------------)  + I act
	0x002a00c3, // n0x05db c0x0000 (---------------)  + I asn
	0x06222ac3, // n0x05dc c0x0018 (n0x05ec-n0x05ed)  + I com
	0x00224984, // n0x05dd c0x0000 (---------------)  + I conf
	0x066d75c3, // n0x05de c0x0019 (n0x05ed-n0x05f5)  + I edu
	0x06a1e283, // n0x05df c0x001a (n0x05f5-n0x05fa)  + I gov
	0x00206202, // n0x05e0 c0x0000 (---------------)  + I id
	0x00200304, // n0x05e1 c0x0000 (---------------)  + I info
	0x002170c3, // n0x05e2 c0x0000 (---------------)  + I net
	0x0020ac43, // n0x05e3 c0x0000 (---------------)  + I nsw
	0x00200e02, // n0x05e4 c0x0000 (---------------)  + I nt
	0x0021dcc3, // n0x05e5 c0x0000 (---------------)  + I org
	0x00212bc2, // n0x05e6 c0x0000 (---------------)  + I oz
	0x002ce743, // n0x05e7 c0x0000 (---------------)  + I qld
	0x00201a02, // n0x05e8 c0x0000 (---------------)  + I sa
	0x00200143, // n0x05e9 c0x0000 (---------------)  + I tas
	0x00243c83, // n0x05ea c0x0000 (---------------)  + I vic
	0x00202542, // n0x05eb c0x0000 (---------------)  + I wa
	0x000e4188, // n0x05ec c0x0000 (---------------)  +   blogspot
	0x00226043, // n0x05ed c0x0000 (---------------)  + I act
	0x0020ac43, // n0x05ee c0x0000 (---------------)  + I nsw
	0x00200e02, // n0x05ef c0x0000 (---------------)  + I nt
	0x002ce743, // n0x05f0 c0x0000 (---------------)  + I qld
	0x00201a02, // n0x05f1 c0x0000 (---------------)  + I sa
	0x00200143, // n0x05f2 c0x0000 (---------------)  + I tas
	0x00243c83, // n0x05f3 c0x0000 (---------------)  + I vic
	0x00202542, // n0x05f4 c0x0000 (---------------)  + I wa
	0x002ce743, // n0x05f5 c0x0000 (---------------)  + I qld
	0x00201a02, // n0x05f6 c0x0000 (---------------)  + I sa
	0x00200143, // n0x05f7 c0x0000 (---------------)  + I tas
	0x00243c83, // n0x05f8 c0x0000 (---------------)  + I vic
	0x00202542, // n0x05f9 c0x0000 (---------------)  + I wa
	0x00222ac3, // n0x05fa c0x0000 (---------------)  + I com
	0x00310603, // n0x05fb c0x0000 (---------------)  + I biz
	0x00222ac3, // n0x05fc c0x0000 (---------------)  + I com
	0x002d75c3, // n0x05fd c0x0000 (---------------)  + I edu
	0x0021e283, // n0x05fe c0x0000 (---------------)  + I gov
	0x00200304, // n0x05ff c0x0000 (---------------)  + I info
	0x00238c03, // n0x0600 c0x0000 (---------------)  + I int
	0x0023fa03, // n0x0601 c0x0000 (---------------)  + I mil
	0x00298944, // n0x0602 c0x0000 (---------------)  + I name
	0x002170c3, // n0x0603 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0604 c0x0000 (---------------)  + I org
	0x00207742, // n0x0605 c0x0000 (---------------)  + I pp
	0x00218243, // n0x0606 c0x0000 (---------------)  + I pro
	0x000e4188, // n0x0607 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x0608 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x0609 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x060a c0x0000 (---------------)  + I edu
	0x0021e283, // n0x060b c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x060c c0x0000 (---------------)  + I mil
	0x002170c3, // n0x060d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x060e c0x0000 (---------------)  + I org
	0x002060c2, // n0x060f c0x0000 (---------------)  + I rs
	0x00262644, // n0x0610 c0x0000 (---------------)  + I unbi
	0x00201984, // n0x0611 c0x0000 (---------------)  + I unsa
	0x00310603, // n0x0612 c0x0000 (---------------)  + I biz
	0x00200742, // n0x0613 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x0614 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x0615 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x0616 c0x0000 (---------------)  + I gov
	0x00200304, // n0x0617 c0x0000 (---------------)  + I info
	0x002170c3, // n0x0618 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0619 c0x0000 (---------------)  + I org
	0x002cf4c5, // n0x061a c0x0000 (---------------)  + I store
	0x0020bf42, // n0x061b c0x0000 (---------------)  + I tv
	0x00201e82, // n0x061c c0x0000 (---------------)  + I ac
	0x000e4188, // n0x061d c0x0000 (---------------)  +   blogspot
	0x0021e283, // n0x061e c0x0000 (---------------)  + I gov
	0x00225381, // n0x061f c0x0000 (---------------)  + I 0
	0x00223681, // n0x0620 c0x0000 (---------------)  + I 1
	0x0023d901, // n0x0621 c0x0000 (---------------)  + I 2
	0x00235b01, // n0x0622 c0x0000 (---------------)  + I 3
	0x00235a81, // n0x0623 c0x0000 (---------------)  + I 4
	0x002b1e01, // n0x0624 c0x0000 (---------------)  + I 5
	0x00213ac1, // n0x0625 c0x0000 (---------------)  + I 6
	0x00225481, // n0x0626 c0x0000 (---------------)  + I 7
	0x002e4a01, // n0x0627 c0x0000 (---------------)  + I 8
	0x002e4e01, // n0x0628 c0x0000 (---------------)  + I 9
	0x00200181, // n0x0629 c0x0000 (---------------)  + I a
	0x00200001, // n0x062a c0x0000 (---------------)  + I b
	0x000e4188, // n0x062b c0x0000 (---------------)  +   blogspot
	0x00200741, // n0x062c c0x0000 (---------------)  + I c
	0x002005c1, // n0x062d c0x0000 (---------------)  + I d
	0x00200701, // n0x062e c0x0000 (---------------)  + I e
	0x00200381, // n0x062f c0x0000 (---------------)  + I f
	0x00200401, // n0x0630 c0x0000 (---------------)  + I g
	0x00200201, // n0x0631 c0x0000 (---------------)  + I h
	0x00200041, // n0x0632 c0x0000 (---------------)  + I i
	0x00201f81, // n0x0633 c0x0000 (---------------)  + I j
	0x00201001, // n0x0634 c0x0000 (---------------)  + I k
	0x002008c1, // n0x0635 c0x0000 (---------------)  + I l
	0x002000c1, // n0x0636 c0x0000 (---------------)  + I m
	0x00200281, // n0x0637 c0x0000 (---------------)  + I n
	0x00200081, // n0x0638 c0x0000 (---------------)  + I o
	0x00200b01, // n0x0639 c0x0000 (---------------)  + I p
	0x00211181, // n0x063a c0x0000 (---------------)  + I q
	0x00200581, // n0x063b c0x0000 (---------------)  + I r
	0x002001c1, // n0x063c c0x0000 (---------------)  + I s
	0x00200141, // n0x063d c0x0000 (---------------)  + I t
	0x00200101, // n0x063e c0x0000 (---------------)  + I u
	0x002013c1, // n0x063f c0x0000 (---------------)  + I v
	0x00202541, // n0x0640 c0x0000 (---------------)  + I w
	0x00203ec1, // n0x0641 c0x0000 (---------------)  + I x
	0x00200801, // n0x0642 c0x0000 (---------------)  + I y
	0x00201901, // n0x0643 c0x0000 (---------------)  + I z
	0x00222ac3, // n0x0644 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x0645 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x0646 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x0647 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0648 c0x0000 (---------------)  + I org
	0x00200742, // n0x0649 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x064a c0x0000 (---------------)  + I com
	0x002d75c3, // n0x064b c0x0000 (---------------)  + I edu
	0x00200c42, // n0x064c c0x0000 (---------------)  + I or
	0x0021dcc3, // n0x064d c0x0000 (---------------)  + I org
	0x00009ac6, // n0x064e c0x0000 (---------------)  +   dyndns
	0x00041d4a, // n0x064f c0x0000 (---------------)  +   for-better
	0x00076a48, // n0x0650 c0x0000 (---------------)  +   for-more
	0x00042348, // n0x0651 c0x0000 (---------------)  +   for-some
	0x00042c87, // n0x0652 c0x0000 (---------------)  +   for-the
	0x00130f46, // n0x0653 c0x0000 (---------------)  +   selfip
	0x00110e86, // n0x0654 c0x0000 (---------------)  +   webhop
	0x002729c4, // n0x0655 c0x0000 (---------------)  + I asso
	0x002f4347, // n0x0656 c0x0000 (---------------)  + I barreau
	0x000e4188, // n0x0657 c0x0000 (---------------)  +   blogspot
	0x003579c4, // n0x0658 c0x0000 (---------------)  + I gouv
	0x00222ac3, // n0x0659 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x065a c0x0000 (---------------)  + I edu
	0x0021e283, // n0x065b c0x0000 (---------------)  + I gov
	0x002170c3, // n0x065c c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x065d c0x0000 (---------------)  + I org
	0x00222ac3, // n0x065e c0x0000 (---------------)  + I com
	0x002d75c3, // n0x065f c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x0660 c0x0000 (---------------)  + I gob
	0x0021e283, // n0x0661 c0x0000 (---------------)  + I gov
	0x00238c03, // n0x0662 c0x0000 (---------------)  + I int
	0x0023fa03, // n0x0663 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x0664 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0665 c0x0000 (---------------)  + I org
	0x0020bf42, // n0x0666 c0x0000 (---------------)  + I tv
	0x002b2643, // n0x0667 c0x0000 (---------------)  + I adm
	0x002db303, // n0x0668 c0x0000 (---------------)  + I adv
	0x00256e43, // n0x0669 c0x0000 (---------------)  + I agr
	0x00204942, // n0x066a c0x0000 (---------------)  + I am
	0x00323d83, // n0x066b c0x0000 (---------------)  + I arq
	0x00200603, // n0x066c c0x0000 (---------------)  + I art
	0x00201643, // n0x066d c0x0000 (---------------)  + I ato
	0x00200001, // n0x066e c0x0000 (---------------)  + I b
	0x00200003, // n0x066f c0x0000 (---------------)  + I bio
	0x002d0084, // n0x0670 c0x0000 (---------------)  + I blog
	0x0031b803, // n0x0671 c0x0000 (---------------)  + I bmd
	0x002f4243, // n0x0672 c0x0000 (---------------)  + I cim
	0x002dbfc3, // n0x0673 c0x0000 (---------------)  + I cng
	0x002211c3, // n0x0674 c0x0000 (---------------)  + I cnt
	0x0a622ac3, // n0x0675 c0x0029 (n0x06ad-n0x06ae)  + I com
	0x00228d44, // n0x0676 c0x0000 (---------------)  + I coop
	0x00305ec3, // n0x0677 c0x0000 (---------------)  + I ecn
	0x00200703, // n0x0678 c0x0000 (---------------)  + I eco
	0x002d75c3, // n0x0679 c0x0000 (---------------)  + I edu
	0x00226343, // n0x067a c0x0000 (---------------)  + I emp
	0x002674c3, // n0x067b c0x0000 (---------------)  + I eng
	0x0028cac3, // n0x067c c0x0000 (---------------)  + I esp
	0x002f41c3, // n0x067d c0x0000 (---------------)  + I etc
	0x0021bac3, // n0x067e c0x0000 (---------------)  + I eti
	0x0021f803, // n0x067f c0x0000 (---------------)  + I far
	0x0023bdc4, // n0x0680 c0x0000 (---------------)  + I flog
	0x00358002, // n0x0681 c0x0000 (---------------)  + I fm
	0x002416c3, // n0x0682 c0x0000 (---------------)  + I fnd
	0x00247a83, // n0x0683 c0x0000 (---------------)  + I fot
	0x002645c3, // n0x0684 c0x0000 (---------------)  + I fst
	0x0036f1c3, // n0x0685 c0x0000 (---------------)  + I g12
	0x00311b83, // n0x0686 c0x0000 (---------------)  + I ggf
	0x0021e283, // n0x0687 c0x0000 (---------------)  + I gov
	0x002b7c43, // n0x0688 c0x0000 (---------------)  + I imb
	0x00215703, // n0x0689 c0x0000 (---------------)  + I ind
	0x00200303, // n0x068a c0x0000 (---------------)  + I inf
	0x00202c03, // n0x068b c0x0000 (---------------)  + I jor
	0x002de8c3, // n0x068c c0x0000 (---------------)  + I jus
	0x0021e843, // n0x068d c0x0000 (---------------)  + I leg
	0x002e3403, // n0x068e c0x0000 (---------------)  + I lel
	0x0020f583, // n0x068f c0x0000 (---------------)  + I mat
	0x0020b403, // n0x0690 c0x0000 (---------------)  + I med
	0x0023fa03, // n0x0691 c0x0000 (---------------)  + I mil
	0x00214902, // n0x0692 c0x0000 (---------------)  + I mp
	0x002bc903, // n0x0693 c0x0000 (---------------)  + I mus
	0x002170c3, // n0x0694 c0x0000 (---------------)  + I net
	0x01607cc3, // n0x0695 c0x0005 (---------------)* o I nom
	0x0023fdc3, // n0x0696 c0x0000 (---------------)  + I not
	0x00211c03, // n0x0697 c0x0000 (---------------)  + I ntr
	0x0024f003, // n0x0698 c0x0000 (---------------)  + I odo
	0x0021dcc3, // n0x0699 c0x0000 (---------------)  + I org
	0x002bf143, // n0x069a c0x0000 (---------------)  + I ppg
	0x00218243, // n0x069b c0x0000 (---------------)  + I pro
	0x002353c3, // n0x069c c0x0000 (---------------)  + I psc
	0x002dc783, // n0x069d c0x0000 (---------------)  + I psi
	0x002ce903, // n0x069e c0x0000 (---------------)  + I qsl
	0x00250685, // n0x069f c0x0000 (---------------)  + I radio
	0x002e6343, // n0x06a0 c0x0000 (---------------)  + I rec
	0x002ce943, // n0x06a1 c0x0000 (---------------)  + I slg
	0x002cef83, // n0x06a2 c0x0000 (---------------)  + I srv
	0x00217c44, // n0x06a3 c0x0000 (---------------)  + I taxi
	0x00362ec3, // n0x06a4 c0x0000 (---------------)  + I teo
	0x002fb583, // n0x06a5 c0x0000 (---------------)  + I tmp
	0x00283003, // n0x06a6 c0x0000 (---------------)  + I trd
	0x00227303, // n0x06a7 c0x0000 (---------------)  + I tur
	0x0020bf42, // n0x06a8 c0x0000 (---------------)  + I tv
	0x0022b9c3, // n0x06a9 c0x0000 (---------------)  + I vet
	0x002df504, // n0x06aa c0x0000 (---------------)  + I vlog
	0x0025a484, // n0x06ab c0x0000 (---------------)  + I wiki
	0x0024dc43, // n0x06ac c0x0000 (---------------)  + I zlg
	0x000e4188, // n0x06ad c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x06ae c0x0000 (---------------)  + I com
	0x002d75c3, // n0x06af c0x0000 (---------------)  + I edu
	0x0021e283, // n0x06b0 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x06b1 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x06b2 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x06b3 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x06b4 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x06b5 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x06b6 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x06b7 c0x0000 (---------------)  + I org
	0x00200742, // n0x06b8 c0x0000 (---------------)  + I co
	0x0021dcc3, // n0x06b9 c0x0000 (---------------)  + I org
	0x0ba22ac3, // n0x06ba c0x002e (n0x06be-n0x06bf)  + I com
	0x0021e283, // n0x06bb c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x06bc c0x0000 (---------------)  + I mil
	0x00209982, // n0x06bd c0x0000 (---------------)  + I of
	0x000e4188, // n0x06be c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x06bf c0x0000 (---------------)  + I com
	0x002d75c3, // n0x06c0 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x06c1 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x06c2 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x06c3 c0x0000 (---------------)  + I org
	0x000043c2, // n0x06c4 c0x0000 (---------------)  +   za
	0x002004c2, // n0x06c5 c0x0000 (---------------)  + I ab
	0x0021a042, // n0x06c6 c0x0000 (---------------)  + I bc
	0x000e4188, // n0x06c7 c0x0000 (---------------)  +   blogspot
	0x00000742, // n0x06c8 c0x0000 (---------------)  +   co
	0x00227d42, // n0x06c9 c0x0000 (---------------)  + I gc
	0x00205942, // n0x06ca c0x0000 (---------------)  + I mb
	0x00210d42, // n0x06cb c0x0000 (---------------)  + I nb
	0x00200342, // n0x06cc c0x0000 (---------------)  + I nf
	0x00236482, // n0x06cd c0x0000 (---------------)  + I nl
	0x002019c2, // n0x06ce c0x0000 (---------------)  + I ns
	0x00200e02, // n0x06cf c0x0000 (---------------)  + I nt
	0x00205bc2, // n0x06d0 c0x0000 (---------------)  + I nu
	0x00200dc2, // n0x06d1 c0x0000 (---------------)  + I on
	0x00214942, // n0x06d2 c0x0000 (---------------)  + I pe
	0x00369542, // n0x06d3 c0x0000 (---------------)  + I qc
	0x00207b42, // n0x06d4 c0x0000 (---------------)  + I sk
	0x002202c2, // n0x06d5 c0x0000 (---------------)  + I yk
	0x00085109, // n0x06d6 c0x0000 (---------------)  +   ftpaccess
	0x0001208b, // n0x06d7 c0x0000 (---------------)  +   game-server
	0x000bea08, // n0x06d8 c0x0000 (---------------)  +   myphotos
	0x00043609, // n0x06d9 c0x0000 (---------------)  +   scrapping
	0x0021e283, // n0x06da c0x0000 (---------------)  + I gov
	0x000e4188, // n0x06db c0x0000 (---------------)  +   blogspot
	0x000e4188, // n0x06dc c0x0000 (---------------)  +   blogspot
	0x00201e82, // n0x06dd c0x0000 (---------------)  + I ac
	0x002729c4, // n0x06de c0x0000 (---------------)  + I asso
	0x00200742, // n0x06df c0x0000 (---------------)  + I co
	0x00222ac3, // n0x06e0 c0x0000 (---------------)  + I com
	0x00203fc2, // n0x06e1 c0x0000 (---------------)  + I ed
	0x002d75c3, // n0x06e2 c0x0000 (---------------)  + I edu
	0x00202342, // n0x06e3 c0x0000 (---------------)  + I go
	0x003579c4, // n0x06e4 c0x0000 (---------------)  + I gouv
	0x00238c03, // n0x06e5 c0x0000 (---------------)  + I int
	0x00238602, // n0x06e6 c0x0000 (---------------)  + I md
	0x002170c3, // n0x06e7 c0x0000 (---------------)  + I net
	0x00200c42, // n0x06e8 c0x0000 (---------------)  + I or
	0x0021dcc3, // n0x06e9 c0x0000 (---------------)  + I org
	0x0029abc6, // n0x06ea c0x0000 (---------------)  + I presse
	0x002f710f, // n0x06eb c0x0000 (---------------)  + I xn--aroport-bya
	0x006e3e83, // n0x06ec c0x0001 (---------------)  ! I www
	0x000e4188, // n0x06ed c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x06ee c0x0000 (---------------)  + I co
	0x0034eb03, // n0x06ef c0x0000 (---------------)  + I gob
	0x0021e283, // n0x06f0 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x06f1 c0x0000 (---------------)  + I mil
	0x00200742, // n0x06f2 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x06f3 c0x0000 (---------------)  + I com
	0x0021e283, // n0x06f4 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x06f5 c0x0000 (---------------)  + I net
	0x00201e82, // n0x06f6 c0x0000 (---------------)  + I ac
	0x002076c2, // n0x06f7 c0x0000 (---------------)  + I ah
	0x0ea72409, // n0x06f8 c0x003a (n0x0723-n0x0724)  o I amazonaws
	0x00202642, // n0x06f9 c0x0000 (---------------)  + I bj
	0x0f222ac3, // n0x06fa c0x003c (n0x0725-n0x0726)  + I com
	0x0022e082, // n0x06fb c0x0000 (---------------)  + I cq
	0x002d75c3, // n0x06fc c0x0000 (---------------)  + I edu
	0x002241c2, // n0x06fd c0x0000 (---------------)  + I fj
	0x0021b342, // n0x06fe c0x0000 (---------------)  + I gd
	0x0021e283, // n0x06ff c0x0000 (---------------)  + I gov
	0x0026cd02, // n0x0700 c0x0000 (---------------)  + I gs
	0x0023d702, // n0x0701 c0x0000 (---------------)  + I gx
	0x00243802, // n0x0702 c0x0000 (---------------)  + I gz
	0x00202dc2, // n0x0703 c0x0000 (---------------)  + I ha
	0x002f6242, // n0x0704 c0x0000 (---------------)  + I hb
	0x00205202, // n0x0705 c0x0000 (---------------)  + I he
	0x00200202, // n0x0706 c0x0000 (---------------)  + I hi
	0x0022ea02, // n0x0707 c0x0000 (---------------)  + I hk
	0x0020cc02, // n0x0708 c0x0000 (---------------)  + I hl
	0x00217542, // n0x0709 c0x0000 (---------------)  + I hn
	0x00297c82, // n0x070a c0x0000 (---------------)  + I jl
	0x002bdf02, // n0x070b c0x0000 (---------------)  + I js
	0x002fc642, // n0x070c c0x0000 (---------------)  + I jx
	0x0021f442, // n0x070d c0x0000 (---------------)  + I ln
	0x0023fa03, // n0x070e c0x0000 (---------------)  + I mil
	0x00203602, // n0x070f c0x0000 (---------------)  + I mo
	0x002170c3, // n0x0710 c0x0000 (---------------)  + I net
	0x00233c42, // n0x0711 c0x0000 (---------------)  + I nm
	0x0026d802, // n0x0712 c0x0000 (---------------)  + I nx
	0x0021dcc3, // n0x0713 c0x0000 (---------------)  + I org
	0x0022e0c2, // n0x0714 c0x0000 (---------------)  + I qh
	0x00200982, // n0x0715 c0x0000 (---------------)  + I sc
	0x0024f842, // n0x0716 c0x0000 (---------------)  + I sd
	0x002001c2, // n0x0717 c0x0000 (---------------)  + I sh
	0x00210b02, // n0x0718 c0x0000 (---------------)  + I sn
	0x002d6b42, // n0x0719 c0x0000 (---------------)  + I sx
	0x00202bc2, // n0x071a c0x0000 (---------------)  + I tj
	0x00241ac2, // n0x071b c0x0000 (---------------)  + I tw
	0x0020a882, // n0x071c c0x0000 (---------------)  + I xj
	0x002ea10a, // n0x071d c0x0000 (---------------)  + I xn--55qx5d
	0x0033080a, // n0x071e c0x0000 (---------------)  + I xn--io0a7i
	0x0036394a, // n0x071f c0x0000 (---------------)  + I xn--od0alg
	0x00397682, // n0x0720 c0x0000 (---------------)  + I xz
	0x00200802, // n0x0721 c0x0000 (---------------)  + I yn
	0x00243842, // n0x0722 c0x0000 (---------------)  + I zj
	0x0ec23487, // n0x0723 c0x003b (n0x0724-n0x0725)  +   compute
	0x00105f0a, // n0x0724 c0x0000 (---------------)  +   cn-north-1
	0x0f672409, // n0x0725 c0x003d (n0x0726-n0x0727)  o I amazonaws
	0x0fb05f0a, // n0x0726 c0x003e (n0x0727-n0x0728)  o I cn-north-1
	0x000413c2, // n0x0727 c0x0000 (---------------)  +   s3
	0x00246584, // n0x0728 c0x0000 (---------------)  + I arts
	0x10222ac3, // n0x0729 c0x0040 (n0x0735-n0x0736)  + I com
	0x002d75c3, // n0x072a c0x0000 (---------------)  + I edu
	0x00238544, // n0x072b c0x0000 (---------------)  + I firm
	0x0021e283, // n0x072c c0x0000 (---------------)  + I gov
	0x00200304, // n0x072d c0x0000 (---------------)  + I info
	0x00238c03, // n0x072e c0x0000 (---------------)  + I int
	0x0023fa03, // n0x072f c0x0000 (---------------)  + I mil
	0x002170c3, // n0x0730 c0x0000 (---------------)  + I net
	0x00207cc3, // n0x0731 c0x0000 (---------------)  + I nom
	0x0021dcc3, // n0x0732 c0x0000 (---------------)  + I org
	0x002e6343, // n0x0733 c0x0000 (---------------)  + I rec
	0x00219fc3, // n0x0734 c0x0000 (---------------)  + I web
	0x000e4188, // n0x0735 c0x0000 (---------------)  +   blogspot
	0x000f00c5, // n0x0736 c0x0000 (---------------)  +   1kapp
	0x000f2202, // n0x0737 c0x0000 (---------------)  +   4u
	0x00167c06, // n0x0738 c0x0000 (---------------)  +   africa
	0x10a72409, // n0x0739 c0x0042 (n0x07ff-n0x0811)  o I amazonaws
	0x00036947, // n0x073a c0x0000 (---------------)  +   appspot
	0x00000602, // n0x073b c0x0000 (---------------)  +   ar
	0x00163e4a, // n0x073c c0x0000 (---------------)  +   betainabox
	0x000d0087, // n0x073d c0x0000 (---------------)  +   blogdns
	0x000e4188, // n0x073e c0x0000 (---------------)  +   blogspot
	0x00012e82, // n0x073f c0x0000 (---------------)  +   br
	0x0012df87, // n0x0740 c0x0000 (---------------)  +   cechire
	0x0013220f, // n0x0741 c0x0000 (---------------)  +   cloudcontrolapp
	0x0018d44f, // n0x0742 c0x0000 (---------------)  +   cloudcontrolled
	0x000211c2, // n0x0743 c0x0000 (---------------)  +   cn
	0x00000742, // n0x0744 c0x0000 (---------------)  +   co
	0x0008ca08, // n0x0745 c0x0000 (---------------)  +   codespot
	0x000006c2, // n0x0746 c0x0000 (---------------)  +   de
	0x00146fc8, // n0x0747 c0x0000 (---------------)  +   dnsalias
	0x0006a247, // n0x0748 c0x0000 (---------------)  +   dnsdojo
	0x00010a4b, // n0x0749 c0x0000 (---------------)  +   doesntexist
	0x0015fdc9, // n0x074a c0x0000 (---------------)  +   dontexist
	0x00146ec7, // n0x074b c0x0000 (---------------)  +   doomdns
	0x000da58c, // n0x074c c0x0000 (---------------)  +   dreamhosters
	0x0015aeca, // n0x074d c0x0000 (---------------)  +   dyn-o-saur
	0x000007c8, // n0x074e c0x0000 (---------------)  +   dynalias
	0x000b8c0e, // n0x074f c0x0000 (---------------)  +   dyndns-at-home
	0x000e024e, // n0x0750 c0x0000 (---------------)  +   dyndns-at-work
	0x000cfecb, // n0x0751 c0x0000 (---------------)  +   dyndns-blog
	0x00009acb, // n0x0752 c0x0000 (---------------)  +   dyndns-free
	0x0000b1cb, // n0x0753 c0x0000 (---------------)  +   dyndns-home
	0x00013889, // n0x0754 c0x0000 (---------------)  +   dyndns-ip
	0x00018d4b, // n0x0755 c0x0000 (---------------)  +   dyndns-mail
	0x00019a8d, // n0x0756 c0x0000 (---------------)  +   dyndns-office
	0x0001ea4b, // n0x0757 c0x0000 (---------------)  +   dyndns-pics
	0x0001fd0d, // n0x0758 c0x0000 (---------------)  +   dyndns-remote
	0x00020d4d, // n0x0759 c0x0000 (---------------)  +   dyndns-server
	0x00051b0a, // n0x075a c0x0000 (---------------)  +   dyndns-web
	0x0005a2cb, // n0x075b c0x0000 (---------------)  +   dyndns-wiki
	0x0009aecb, // n0x075c c0x0000 (---------------)  +   dyndns-work
	0x00016650, // n0x075d c0x0000 (---------------)  +   elasticbeanstalk
	0x0013c78f, // n0x075e c0x0000 (---------------)  +   est-a-la-maison
	0x0002270f, // n0x075f c0x0000 (---------------)  +   est-a-la-masion
	0x000144cd, // n0x0760 c0x0000 (---------------)  +   est-le-patron
	0x000ef550, // n0x0761 c0x0000 (---------------)  +   est-mon-blogueur
	0x0001d5c2, // n0x0762 c0x0000 (---------------)  +   eu
	0x0003674b, // n0x0763 c0x0000 (---------------)  +   firebaseapp
	0x0003ffc8, // n0x0764 c0x0000 (---------------)  +   flynnhub
	0x0004d407, // n0x0765 c0x0000 (---------------)  +   from-ak
	0x0004d747, // n0x0766 c0x0000 (---------------)  +   from-al
	0x0004d907, // n0x0767 c0x0000 (---------------)  +   from-ar
	0x0004dd07, // n0x0768 c0x0000 (---------------)  +   from-ca
	0x0004f607, // n0x0769 c0x0000 (---------------)  +   from-ct
	0x00050247, // n0x076a c0x0000 (---------------)  +   from-dc
	0x00052787, // n0x076b c0x0000 (---------------)  +   from-de
	0x00052a47, // n0x076c c0x0000 (---------------)  +   from-fl
	0x00054187, // n0x076d c0x0000 (---------------)  +   from-ga
	0x00054487, // n0x076e c0x0000 (---------------)  +   from-hi
	0x00054ec7, // n0x076f c0x0000 (---------------)  +   from-ia
	0x00055087, // n0x0770 c0x0000 (---------------)  +   from-id
	0x00055247, // n0x0771 c0x0000 (---------------)  +   from-il
	0x00055407, // n0x0772 c0x0000 (---------------)  +   from-in
	0x000561c7, // n0x0773 c0x0000 (---------------)  +   from-ks
	0x00056787, // n0x0774 c0x0000 (---------------)  +   from-ky
	0x00057247, // n0x0775 c0x0000 (---------------)  +   from-ma
	0x00057647, // n0x0776 c0x0000 (---------------)  +   from-md
	0x00057d87, // n0x0777 c0x0000 (---------------)  +   from-mi
	0x00058887, // n0x0778 c0x0000 (---------------)  +   from-mn
	0x00058a47, // n0x0779 c0x0000 (---------------)  +   from-mo
	0x00059007, // n0x077a c0x0000 (---------------)  +   from-ms
	0x00059507, // n0x077b c0x0000 (---------------)  +   from-mt
	0x00059707, // n0x077c c0x0000 (---------------)  +   from-nc
	0x0005a607, // n0x077d c0x0000 (---------------)  +   from-nd
	0x0005a7c7, // n0x077e c0x0000 (---------------)  +   from-ne
	0x0005a987, // n0x077f c0x0000 (---------------)  +   from-nh
	0x0005b247, // n0x0780 c0x0000 (---------------)  +   from-nj
	0x0005b747, // n0x0781 c0x0000 (---------------)  +   from-nm
	0x0005c247, // n0x0782 c0x0000 (---------------)  +   from-nv
	0x0005c847, // n0x0783 c0x0000 (---------------)  +   from-oh
	0x0005cf07, // n0x0784 c0x0000 (---------------)  +   from-ok
	0x0005d407, // n0x0785 c0x0000 (---------------)  +   from-or
	0x0005d5c7, // n0x0786 c0x0000 (---------------)  +   from-pa
	0x0005d947, // n0x0787 c0x0000 (---------------)  +   from-pr
	0x0005e307, // n0x0788 c0x0000 (---------------)  +   from-ri
	0x0005e687, // n0x0789 c0x0000 (---------------)  +   from-sc
	0x0005ea87, // n0x078a c0x0000 (---------------)  +   from-sd
	0x000604c7, // n0x078b c0x0000 (---------------)  +   from-tn
	0x00060687, // n0x078c c0x0000 (---------------)  +   from-tx
	0x00061207, // n0x078d c0x0000 (---------------)  +   from-ut
	0x00062947, // n0x078e c0x0000 (---------------)  +   from-va
	0x00062f87, // n0x078f c0x0000 (---------------)  +   from-vt
	0x00063287, // n0x0790 c0x0000 (---------------)  +   from-wa
	0x00063447, // n0x0791 c0x0000 (---------------)  +   from-wi
	0x000637c7, // n0x0792 c0x0000 (---------------)  +   from-wv
	0x00063a07, // n0x0793 c0x0000 (---------------)  +   from-wy
	0x00005a42, // n0x0794 c0x0000 (---------------)  +   gb
	0x000c0587, // n0x0795 c0x0000 (---------------)  +   getmyip
	0x000b53d1, // n0x0796 c0x0000 (---------------)  +   githubusercontent
	0x000cd58a, // n0x0797 c0x0000 (---------------)  +   googleapis
	0x0008c88a, // n0x0798 c0x0000 (---------------)  +   googlecode
	0x00043a86, // n0x0799 c0x0000 (---------------)  +   gotdns
	0x0000dc82, // n0x079a c0x0000 (---------------)  +   gr
	0x0008f309, // n0x079b c0x0000 (---------------)  +   herokuapp
	0x0007fe89, // n0x079c c0x0000 (---------------)  +   herokussl
	0x0002ea02, // n0x079d c0x0000 (---------------)  +   hk
	0x0013eeca, // n0x079e c0x0000 (---------------)  +   hobby-site
	0x00090ec9, // n0x079f c0x0000 (---------------)  +   homelinux
	0x00091b88, // n0x07a0 c0x0000 (---------------)  +   homeunix
	0x00017d42, // n0x07a1 c0x0000 (---------------)  +   hu
	0x001008c9, // n0x07a2 c0x0000 (---------------)  +   iamallama
	0x0005db8e, // n0x07a3 c0x0000 (---------------)  +   is-a-anarchist
	0x000d5d8c, // n0x07a4 c0x0000 (---------------)  +   is-a-blogger
	0x000bf2cf, // n0x07a5 c0x0000 (---------------)  +   is-a-bookkeeper
	0x0017d14e, // n0x07a6 c0x0000 (---------------)  +   is-a-bulls-fan
	0x0000cf8c, // n0x07a7 c0x0000 (---------------)  +   is-a-caterer
	0x00166909, // n0x07a8 c0x0000 (---------------)  +   is-a-chef
	0x00099ad1, // n0x07a9 c0x0000 (---------------)  +   is-a-conservative
	0x0009a088, // n0x07aa c0x0000 (---------------)  +   is-a-cpa
	0x00169b92, // n0x07ab c0x0000 (---------------)  +   is-a-cubicle-slave
	0x0002e40d, // n0x07ac c0x0000 (---------------)  +   is-a-democrat
	0x00032e0d, // n0x07ad c0x0000 (---------------)  +   is-a-designer
	0x00138acb, // n0x07ae c0x0000 (---------------)  +   is-a-doctor
	0x001713d5, // n0x07af c0x0000 (---------------)  +   is-a-financialadvisor
	0x00052e49, // n0x07b0 c0x0000 (---------------)  +   is-a-geek
	0x0005afca, // n0x07b1 c0x0000 (---------------)  +   is-a-green
	0x0005bb09, // n0x07b2 c0x0000 (---------------)  +   is-a-guru
	0x00060e10, // n0x07b3 c0x0000 (---------------)  +   is-a-hard-worker
	0x00065f4b, // n0x07b4 c0x0000 (---------------)  +   is-a-hunter
	0x0006f74f, // n0x07b5 c0x0000 (---------------)  +   is-a-landscaper
	0x000702cb, // n0x07b6 c0x0000 (---------------)  +   is-a-lawyer
	0x00073b0c, // n0x07b7 c0x0000 (---------------)  +   is-a-liberal
	0x00077590, // n0x07b8 c0x0000 (---------------)  +   is-a-libertarian
	0x001370ca, // n0x07b9 c0x0000 (---------------)  +   is-a-llama
	0x00137a4d, // n0x07ba c0x0000 (---------------)  +   is-a-musician
	0x00174a0e, // n0x07bb c0x0000 (---------------)  +   is-a-nascarfan
	0x0007bf4a, // n0x07bc c0x0000 (---------------)  +   is-a-nurse
	0x0007d0cc, // n0x07bd c0x0000 (---------------)  +   is-a-painter
	0x0008ab94, // n0x07be c0x0000 (---------------)  +   is-a-personaltrainer
	0x0008ef91, // n0x07bf c0x0000 (---------------)  +   is-a-photographer
	0x00090c0b, // n0x07c0 c0x0000 (---------------)  +   is-a-player
	0x0009638f, // n0x07c1 c0x0000 (---------------)  +   is-a-republican
	0x00096fcd, // n0x07c2 c0x0000 (---------------)  +   is-a-rockstar
	0x000c268e, // n0x07c3 c0x0000 (---------------)  +   is-a-socialist
	0x0009844c, // n0x07c4 c0x0000 (---------------)  +   is-a-student
	0x0009d08c, // n0x07c5 c0x0000 (---------------)  +   is-a-teacher
	0x000c238b, // n0x07c6 c0x0000 (---------------)  +   is-a-techie
	0x000c3f4e, // n0x07c7 c0x0000 (---------------)  +   is-a-therapist
	0x000d7cd0, // n0x07c8 c0x0000 (---------------)  +   is-an-accountant
	0x0015d44b, // n0x07c9 c0x0000 (---------------)  +   is-an-actor
	0x000a110d, // n0x07ca c0x0000 (---------------)  +   is-an-actress
	0x000a768f, // n0x07cb c0x0000 (---------------)  +   is-an-anarchist
	0x000a814c, // n0x07cc c0x0000 (---------------)  +   is-an-artist
	0x000a890e, // n0x07cd c0x0000 (---------------)  +   is-an-engineer
	0x000a97d1, // n0x07ce c0x0000 (---------------)  +   is-an-entertainer
	0x00135f8c, // n0x07cf c0x0000 (---------------)  +   is-certified
	0x00133a07, // n0x07d0 c0x0000 (---------------)  +   is-gone
	0x000b0fcd, // n0x07d1 c0x0000 (---------------)  +   is-into-anime
	0x000b918c, // n0x07d2 c0x0000 (---------------)  +   is-into-cars
	0x000d1250, // n0x07d3 c0x0000 (---------------)  +   is-into-cartoons
	0x000d1f4d, // n0x07d4 c0x0000 (---------------)  +   is-into-games
	0x000d3087, // n0x07d5 c0x0000 (---------------)  +   is-leet
	0x000d7250, // n0x07d6 c0x0000 (---------------)  +   is-not-certified
	0x000f9e48, // n0x07d7 c0x0000 (---------------)  +   is-slick
	0x001063cb, // n0x07d8 c0x0000 (---------------)  +   is-uberleet
	0x00146b4f, // n0x07d9 c0x0000 (---------------)  +   is-with-theband
	0x00191648, // n0x07da c0x0000 (---------------)  +   isa-geek
	0x000cd78d, // n0x07db c0x0000 (---------------)  +   isa-hockeynut
	0x00159d10, // n0x07dc c0x0000 (---------------)  +   issmarterthanyou
	0x0009a703, // n0x07dd c0x0000 (---------------)  +   jpn
	0x000034c2, // n0x07de c0x0000 (---------------)  +   kr
	0x00061689, // n0x07df c0x0000 (---------------)  +   likes-pie
	0x0007878a, // n0x07e0 c0x0000 (---------------)  +   likescandy
	0x00032003, // n0x07e1 c0x0000 (---------------)  +   mex
	0x001024c8, // n0x07e2 c0x0000 (---------------)  +   neat-url
	0x00002f07, // n0x07e3 c0x0000 (---------------)  +   nfshost
	0x00000c02, // n0x07e4 c0x0000 (---------------)  +   no
	0x0005080a, // n0x07e5 c0x0000 (---------------)  +   operaunite
	0x0019238f, // n0x07e6 c0x0000 (---------------)  +   outsystemscloud
	0x00110fd2, // n0x07e7 c0x0000 (---------------)  +   pagespeedmobilizer
	0x00169542, // n0x07e8 c0x0000 (---------------)  +   qc
	0x00132187, // n0x07e9 c0x0000 (---------------)  +   rhcloud
	0x00000d82, // n0x07ea c0x0000 (---------------)  +   ro
	0x000044c2, // n0x07eb c0x0000 (---------------)  +   ru
	0x00001a02, // n0x07ec c0x0000 (---------------)  +   sa
	0x0002f650, // n0x07ed c0x0000 (---------------)  +   saves-the-whales
	0x00002e82, // n0x07ee c0x0000 (---------------)  +   se
	0x00130f46, // n0x07ef c0x0000 (---------------)  +   selfip
	0x000c368e, // n0x07f0 c0x0000 (---------------)  +   sells-for-less
	0x0007ac8b, // n0x07f1 c0x0000 (---------------)  +   sells-for-u
	0x00079088, // n0x07f2 c0x0000 (---------------)  +   servebbs
	0x000e0a0a, // n0x07f3 c0x0000 (---------------)  +   simple-url
	0x000dc7c7, // n0x07f4 c0x0000 (---------------)  +   sinaapp
	0x000101cd, // n0x07f5 c0x0000 (---------------)  +   space-to-rent
	0x0010160c, // n0x07f6 c0x0000 (---------------)  +   teaches-yoga
	0x0000cf02, // n0x07f7 c0x0000 (---------------)  +   uk
	0x00009f42, // n0x07f8 c0x0000 (---------------)  +   us
	0x00006842, // n0x07f9 c0x0000 (---------------)  +   uy
	0x000dc70a, // n0x07fa c0x0000 (---------------)  +   vipsinaapp
	0x000cd48a, // n0x07fb c0x0000 (---------------)  +   withgoogle
	0x000e3f0e, // n0x07fc c0x0000 (---------------)  +   writesthisblog
	0x000c9948, // n0x07fd c0x0000 (---------------)  +   yolasite
	0x000043c2, // n0x07fe c0x0000 (---------------)  +   za
	0x10c23487, // n0x07ff c0x0043 (n0x0811-n0x081a)  +   compute
	0x11023489, // n0x0800 c0x0044 (n0x081a-n0x081c)  +   compute-1
	0x0000a503, // n0x0801 c0x0000 (---------------)  +   elb
	0x1172bb4c, // n0x0802 c0x0045 (n0x081c-n0x081d)  o I eu-central-1
	0x000413c2, // n0x0803 c0x0000 (---------------)  +   s3
	0x000f0c51, // n0x0804 c0x0000 (---------------)  +   s3-ap-northeast-1
	0x000f9411, // n0x0805 c0x0000 (---------------)  +   s3-ap-southeast-1
	0x0010a591, // n0x0806 c0x0000 (---------------)  +   s3-ap-southeast-2
	0x0012ba8f, // n0x0807 c0x0000 (---------------)  +   s3-eu-central-1
	0x00072c0c, // n0x0808 c0x0000 (---------------)  +   s3-eu-west-1
	0x0010d14d, // n0x0809 c0x0000 (---------------)  +   s3-external-1
	0x0010ef8d, // n0x080a c0x0000 (---------------)  +   s3-external-2
	0x0011e6d5, // n0x080b c0x0000 (---------------)  +   s3-fips-us-gov-west-1
	0x000413cc, // n0x080c c0x0000 (---------------)  +   s3-sa-east-1
	0x000696d0, // n0x080d c0x0000 (---------------)  +   s3-us-gov-west-1
	0x0011960c, // n0x080e c0x0000 (---------------)  +   s3-us-west-1
	0x000affcc, // n0x080f c0x0000 (---------------)  +   s3-us-west-2
	0x0002b6c9, // n0x0810 c0x0000 (---------------)  +   us-east-1
	0x000f0d0e, // n0x0811 c0x0000 (---------------)  +   ap-northeast-1
	0x000f94ce, // n0x0812 c0x0000 (---------------)  +   ap-southeast-1
	0x0010a64e, // n0x0813 c0x0000 (---------------)  +   ap-southeast-2
	0x0012bb4c, // n0x0814 c0x0000 (---------------)  +   eu-central-1
	0x00072cc9, // n0x0815 c0x0000 (---------------)  +   eu-west-1
	0x00041489, // n0x0816 c0x0000 (---------------)  +   sa-east-1
	0x0006978d, // n0x0817 c0x0000 (---------------)  +   us-gov-west-1
	0x001196c9, // n0x0818 c0x0000 (---------------)  +   us-west-1
	0x000b0089, // n0x0819 c0x0000 (---------------)  +   us-west-2
	0x000f0043, // n0x081a c0x0000 (---------------)  +   z-1
	0x000c8c03, // n0x081b c0x0000 (---------------)  +   z-2
	0x000413c2, // n0x081c c0x0000 (---------------)  +   s3
	0x00201e82, // n0x081d c0x0000 (---------------)  + I ac
	0x00200742, // n0x081e c0x0000 (---------------)  + I co
	0x00203fc2, // n0x081f c0x0000 (---------------)  + I ed
	0x002099c2, // n0x0820 c0x0000 (---------------)  + I fi
	0x00202342, // n0x0821 c0x0000 (---------------)  + I go
	0x00200c42, // n0x0822 c0x0000 (---------------)  + I or
	0x00201a02, // n0x0823 c0x0000 (---------------)  + I sa
	0x00222ac3, // n0x0824 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x0825 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x0826 c0x0000 (---------------)  + I gov
	0x00200303, // n0x0827 c0x0000 (---------------)  + I inf
	0x002170c3, // n0x0828 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0829 c0x0000 (---------------)  + I org
	0x000e4188, // n0x082a c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x082b c0x0000 (---------------)  + I com
	0x002d75c3, // n0x082c c0x0000 (---------------)  + I edu
	0x002170c3, // n0x082d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x082e c0x0000 (---------------)  + I org
	0x00078a43, // n0x082f c0x0000 (---------------)  +   ath
	0x0021e283, // n0x0830 c0x0000 (---------------)  + I gov
	0x00201e82, // n0x0831 c0x0000 (---------------)  + I ac
	0x00310603, // n0x0832 c0x0000 (---------------)  + I biz
	0x13222ac3, // n0x0833 c0x004c (n0x083e-n0x083f)  + I com
	0x00267c47, // n0x0834 c0x0000 (---------------)  + I ekloges
	0x0021e283, // n0x0835 c0x0000 (---------------)  + I gov
	0x003413c3, // n0x0836 c0x0000 (---------------)  + I ltd
	0x00298944, // n0x0837 c0x0000 (---------------)  + I name
	0x002170c3, // n0x0838 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0839 c0x0000 (---------------)  + I org
	0x002647ca, // n0x083a c0x0000 (---------------)  + I parliament
	0x0029abc5, // n0x083b c0x0000 (---------------)  + I press
	0x00218243, // n0x083c c0x0000 (---------------)  + I pro
	0x00208902, // n0x083d c0x0000 (---------------)  + I tm
	0x000e4188, // n0x083e c0x0000 (---------------)  +   blogspot
	0x000e4188, // n0x083f c0x0000 (---------------)  +   blogspot
	0x000e4188, // n0x0840 c0x0000 (---------------)  +   blogspot
	0x00022ac3, // n0x0841 c0x0000 (---------------)  +   com
	0x0009fe8f, // n0x0842 c0x0000 (---------------)  +   fuettertdasnetz
	0x0015ff4a, // n0x0843 c0x0000 (---------------)  +   isteingeek
	0x000c2947, // n0x0844 c0x0000 (---------------)  +   istmein
	0x00016f4a, // n0x0845 c0x0000 (---------------)  +   lebtimnetz
	0x0006cb8a, // n0x0846 c0x0000 (---------------)  +   leitungsen
	0x000e8f4d, // n0x0847 c0x0000 (---------------)  +   traeumtgerade
	0x000e4188, // n0x0848 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x0849 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x084a c0x0000 (---------------)  + I edu
	0x0021e283, // n0x084b c0x0000 (---------------)  + I gov
	0x002170c3, // n0x084c c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x084d c0x0000 (---------------)  + I org
	0x00200603, // n0x084e c0x0000 (---------------)  + I art
	0x00222ac3, // n0x084f c0x0000 (---------------)  + I com
	0x002d75c3, // n0x0850 c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x0851 c0x0000 (---------------)  + I gob
	0x0021e283, // n0x0852 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x0853 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x0854 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0855 c0x0000 (---------------)  + I org
	0x00280043, // n0x0856 c0x0000 (---------------)  + I sld
	0x00219fc3, // n0x0857 c0x0000 (---------------)  + I web
	0x00200603, // n0x0858 c0x0000 (---------------)  + I art
	0x002729c4, // n0x0859 c0x0000 (---------------)  + I asso
	0x00222ac3, // n0x085a c0x0000 (---------------)  + I com
	0x002d75c3, // n0x085b c0x0000 (---------------)  + I edu
	0x0021e283, // n0x085c c0x0000 (---------------)  + I gov
	0x002170c3, // n0x085d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x085e c0x0000 (---------------)  + I org
	0x00218943, // n0x085f c0x0000 (---------------)  + I pol
	0x00222ac3, // n0x0860 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x0861 c0x0000 (---------------)  + I edu
	0x00236403, // n0x0862 c0x0000 (---------------)  + I fin
	0x0034eb03, // n0x0863 c0x0000 (---------------)  + I gob
	0x0021e283, // n0x0864 c0x0000 (---------------)  + I gov
	0x00200304, // n0x0865 c0x0000 (---------------)  + I info
	0x00312503, // n0x0866 c0x0000 (---------------)  + I k12
	0x0020b403, // n0x0867 c0x0000 (---------------)  + I med
	0x0023fa03, // n0x0868 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x0869 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x086a c0x0000 (---------------)  + I org
	0x00218243, // n0x086b c0x0000 (---------------)  + I pro
	0x00382f83, // n0x086c c0x0000 (---------------)  + I aip
	0x15622ac3, // n0x086d c0x0055 (n0x0876-n0x0877)  + I com
	0x002d75c3, // n0x086e c0x0000 (---------------)  + I edu
	0x002099c3, // n0x086f c0x0000 (---------------)  + I fie
	0x0021e283, // n0x0870 c0x0000 (---------------)  + I gov
	0x00273c43, // n0x0871 c0x0000 (---------------)  + I lib
	0x0020b403, // n0x0872 c0x0000 (---------------)  + I med
	0x0021dcc3, // n0x0873 c0x0000 (---------------)  + I org
	0x0025f803, // n0x0874 c0x0000 (---------------)  + I pri
	0x00375bc4, // n0x0875 c0x0000 (---------------)  + I riik
	0x000e4188, // n0x0876 c0x0000 (---------------)  +   blogspot
	0x15e22ac3, // n0x0877 c0x0057 (n0x0880-n0x0881)  + I com
	0x002d75c3, // n0x0878 c0x0000 (---------------)  + I edu
	0x00291c43, // n0x0879 c0x0000 (---------------)  + I eun
	0x0021e283, // n0x087a c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x087b c0x0000 (---------------)  + I mil
	0x00298944, // n0x087c c0x0000 (---------------)  + I name
	0x002170c3, // n0x087d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x087e c0x0000 (---------------)  + I org
	0x00215583, // n0x087f c0x0000 (---------------)  + I sci
	0x000e4188, // n0x0880 c0x0000 (---------------)  +   blogspot
	0x16622ac3, // n0x0881 c0x0059 (n0x0886-n0x0887)  + I com
	0x002d75c3, // n0x0882 c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x0883 c0x0000 (---------------)  + I gob
	0x00207cc3, // n0x0884 c0x0000 (---------------)  + I nom
	0x0021dcc3, // n0x0885 c0x0000 (---------------)  + I org
	0x000e4188, // n0x0886 c0x0000 (---------------)  +   blogspot
	0x00310603, // n0x0887 c0x0000 (---------------)  + I biz
	0x00222ac3, // n0x0888 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x0889 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x088a c0x0000 (---------------)  + I gov
	0x00200304, // n0x088b c0x0000 (---------------)  + I info
	0x00298944, // n0x088c c0x0000 (---------------)  + I name
	0x002170c3, // n0x088d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x088e c0x0000 (---------------)  + I org
	0x002f85c5, // n0x088f c0x0000 (---------------)  + I aland
	0x000e4188, // n0x0890 c0x0000 (---------------)  +   blogspot
	0x00006743, // n0x0891 c0x0000 (---------------)  +   iki
	0x0036e608, // n0x0892 c0x0000 (---------------)  + I aeroport
	0x00383787, // n0x0893 c0x0000 (---------------)  + I assedic
	0x002729c4, // n0x0894 c0x0000 (---------------)  + I asso
	0x00310b86, // n0x0895 c0x0000 (---------------)  + I avocat
	0x0031e586, // n0x0896 c0x0000 (---------------)  + I avoues
	0x000e4188, // n0x0897 c0x0000 (---------------)  +   blogspot
	0x0025f743, // n0x0898 c0x0000 (---------------)  + I cci
	0x003011c9, // n0x0899 c0x0000 (---------------)  + I chambagri
	0x00234bd5, // n0x089a c0x0000 (---------------)  + I chirurgiens-dentistes
	0x00222ac3, // n0x089b c0x0000 (---------------)  + I com
	0x0030c7d2, // n0x089c c0x0000 (---------------)  + I experts-comptables
	0x0030c58f, // n0x089d c0x0000 (---------------)  + I geometre-expert
	0x003579c4, // n0x089e c0x0000 (---------------)  + I gouv
	0x0020dc85, // n0x089f c0x0000 (---------------)  + I greta
	0x002de690, // n0x08a0 c0x0000 (---------------)  + I huissier-justice
	0x002753c7, // n0x08a1 c0x0000 (---------------)  + I medecin
	0x00207cc3, // n0x08a2 c0x0000 (---------------)  + I nom
	0x00265c08, // n0x08a3 c0x0000 (---------------)  + I notaires
	0x002e078a, // n0x08a4 c0x0000 (---------------)  + I pharmacien
	0x0021a444, // n0x08a5 c0x0000 (---------------)  + I port
	0x002ca783, // n0x08a6 c0x0000 (---------------)  + I prd
	0x0029abc6, // n0x08a7 c0x0000 (---------------)  + I presse
	0x00208902, // n0x08a8 c0x0000 (---------------)  + I tm
	0x0036b18b, // n0x08a9 c0x0000 (---------------)  + I veterinaire
	0x00222ac3, // n0x08aa c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08ab c0x0000 (---------------)  + I edu
	0x0021e283, // n0x08ac c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x08ad c0x0000 (---------------)  + I mil
	0x002170c3, // n0x08ae c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x08af c0x0000 (---------------)  + I org
	0x002ce243, // n0x08b0 c0x0000 (---------------)  + I pvt
	0x00200742, // n0x08b1 c0x0000 (---------------)  + I co
	0x002170c3, // n0x08b2 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x08b3 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x08b4 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08b5 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x08b6 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x08b7 c0x0000 (---------------)  + I mil
	0x0021dcc3, // n0x08b8 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x08b9 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08ba c0x0000 (---------------)  + I edu
	0x0021e283, // n0x08bb c0x0000 (---------------)  + I gov
	0x003413c3, // n0x08bc c0x0000 (---------------)  + I ltd
	0x00208483, // n0x08bd c0x0000 (---------------)  + I mod
	0x0021dcc3, // n0x08be c0x0000 (---------------)  + I org
	0x00200742, // n0x08bf c0x0000 (---------------)  + I co
	0x00222ac3, // n0x08c0 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08c1 c0x0000 (---------------)  + I edu
	0x002170c3, // n0x08c2 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x08c3 c0x0000 (---------------)  + I org
	0x00201e82, // n0x08c4 c0x0000 (---------------)  + I ac
	0x00222ac3, // n0x08c5 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08c6 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x08c7 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x08c8 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x08c9 c0x0000 (---------------)  + I org
	0x002729c4, // n0x08ca c0x0000 (---------------)  + I asso
	0x00222ac3, // n0x08cb c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08cc c0x0000 (---------------)  + I edu
	0x00203604, // n0x08cd c0x0000 (---------------)  + I mobi
	0x002170c3, // n0x08ce c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x08cf c0x0000 (---------------)  + I org
	0x000e4188, // n0x08d0 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x08d1 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08d2 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x08d3 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x08d4 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x08d5 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x08d6 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08d7 c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x08d8 c0x0000 (---------------)  + I gob
	0x00215703, // n0x08d9 c0x0000 (---------------)  + I ind
	0x0023fa03, // n0x08da c0x0000 (---------------)  + I mil
	0x002170c3, // n0x08db c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x08dc c0x0000 (---------------)  + I org
	0x00200742, // n0x08dd c0x0000 (---------------)  + I co
	0x00222ac3, // n0x08de c0x0000 (---------------)  + I com
	0x002170c3, // n0x08df c0x0000 (---------------)  + I net
	0x000e4188, // n0x08e0 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x08e1 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08e2 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x08e3 c0x0000 (---------------)  + I gov
	0x00300b83, // n0x08e4 c0x0000 (---------------)  + I idv
	0x00051e43, // n0x08e5 c0x0000 (---------------)  +   inc
	0x001413c3, // n0x08e6 c0x0000 (---------------)  +   ltd
	0x002170c3, // n0x08e7 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x08e8 c0x0000 (---------------)  + I org
	0x002ea10a, // n0x08e9 c0x0000 (---------------)  + I xn--55qx5d
	0x00306ac9, // n0x08ea c0x0000 (---------------)  + I xn--ciqpn
	0x0032788b, // n0x08eb c0x0000 (---------------)  + I xn--gmq050i
	0x00327f0a, // n0x08ec c0x0000 (---------------)  + I xn--gmqw5a
	0x0033080a, // n0x08ed c0x0000 (---------------)  + I xn--io0a7i
	0x0033f6cb, // n0x08ee c0x0000 (---------------)  + I xn--lcvr32d
	0x00356c8a, // n0x08ef c0x0000 (---------------)  + I xn--mk0axi
	0x0035c6ca, // n0x08f0 c0x0000 (---------------)  + I xn--mxtq1m
	0x0036394a, // n0x08f1 c0x0000 (---------------)  + I xn--od0alg
	0x00363bcb, // n0x08f2 c0x0000 (---------------)  + I xn--od0aq3b
	0x00384789, // n0x08f3 c0x0000 (---------------)  + I xn--tn0ag
	0x003867ca, // n0x08f4 c0x0000 (---------------)  + I xn--uc0atv
	0x00386c4b, // n0x08f5 c0x0000 (---------------)  + I xn--uc0ay4a
	0x0039008b, // n0x08f6 c0x0000 (---------------)  + I xn--wcvs22d
	0x0039634a, // n0x08f7 c0x0000 (---------------)  + I xn--zf0avx
	0x00222ac3, // n0x08f8 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x08f9 c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x08fa c0x0000 (---------------)  + I gob
	0x0023fa03, // n0x08fb c0x0000 (---------------)  + I mil
	0x002170c3, // n0x08fc c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x08fd c0x0000 (---------------)  + I org
	0x000e4188, // n0x08fe c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x08ff c0x0000 (---------------)  + I com
	0x0024d404, // n0x0900 c0x0000 (---------------)  + I from
	0x00209782, // n0x0901 c0x0000 (---------------)  + I iz
	0x00298944, // n0x0902 c0x0000 (---------------)  + I name
	0x0036b745, // n0x0903 c0x0000 (---------------)  + I adult
	0x00200603, // n0x0904 c0x0000 (---------------)  + I art
	0x002729c4, // n0x0905 c0x0000 (---------------)  + I asso
	0x00222ac3, // n0x0906 c0x0000 (---------------)  + I com
	0x00228d44, // n0x0907 c0x0000 (---------------)  + I coop
	0x002d75c3, // n0x0908 c0x0000 (---------------)  + I edu
	0x00238544, // n0x0909 c0x0000 (---------------)  + I firm
	0x003579c4, // n0x090a c0x0000 (---------------)  + I gouv
	0x00200304, // n0x090b c0x0000 (---------------)  + I info
	0x0020b403, // n0x090c c0x0000 (---------------)  + I med
	0x002170c3, // n0x090d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x090e c0x0000 (---------------)  + I org
	0x0028acc5, // n0x090f c0x0000 (---------------)  + I perso
	0x00218943, // n0x0910 c0x0000 (---------------)  + I pol
	0x00218243, // n0x0911 c0x0000 (---------------)  + I pro
	0x00241283, // n0x0912 c0x0000 (---------------)  + I rel
	0x0029b184, // n0x0913 c0x0000 (---------------)  + I shop
	0x0036f244, // n0x0914 c0x0000 (---------------)  + I 2000
	0x00256e45, // n0x0915 c0x0000 (---------------)  + I agrar
	0x000e4188, // n0x0916 c0x0000 (---------------)  +   blogspot
	0x002de404, // n0x0917 c0x0000 (---------------)  + I bolt
	0x002112c6, // n0x0918 c0x0000 (---------------)  + I casino
	0x002735c4, // n0x0919 c0x0000 (---------------)  + I city
	0x00200742, // n0x091a c0x0000 (---------------)  + I co
	0x003128c7, // n0x091b c0x0000 (---------------)  + I erotica
	0x0023a507, // n0x091c c0x0000 (---------------)  + I erotika
	0x00356104, // n0x091d c0x0000 (---------------)  + I film
	0x00246b45, // n0x091e c0x0000 (---------------)  + I forum
	0x002d2145, // n0x091f c0x0000 (---------------)  + I games
	0x00294945, // n0x0920 c0x0000 (---------------)  + I hotel
	0x00200304, // n0x0921 c0x0000 (---------------)  + I info
	0x0032d888, // n0x0922 c0x0000 (---------------)  + I ingatlan
	0x00207486, // n0x0923 c0x0000 (---------------)  + I jogasz
	0x002c1d48, // n0x0924 c0x0000 (---------------)  + I konyvelo
	0x0023b745, // n0x0925 c0x0000 (---------------)  + I lakas
	0x002dc385, // n0x0926 c0x0000 (---------------)  + I media
	0x00366d44, // n0x0927 c0x0000 (---------------)  + I news
	0x0021dcc3, // n0x0928 c0x0000 (---------------)  + I org
	0x002cba44, // n0x0929 c0x0000 (---------------)  + I priv
	0x0033de86, // n0x092a c0x0000 (---------------)  + I reklam
	0x0029acc3, // n0x092b c0x0000 (---------------)  + I sex
	0x0029b184, // n0x092c c0x0000 (---------------)  + I shop
	0x0027cac5, // n0x092d c0x0000 (---------------)  + I sport
	0x00278704, // n0x092e c0x0000 (---------------)  + I suli
	0x0020bac4, // n0x092f c0x0000 (---------------)  + I szex
	0x00208902, // n0x0930 c0x0000 (---------------)  + I tm
	0x0024f786, // n0x0931 c0x0000 (---------------)  + I tozsde
	0x0037a486, // n0x0932 c0x0000 (---------------)  + I utazas
	0x002db9c5, // n0x0933 c0x0000 (---------------)  + I video
	0x00201e82, // n0x0934 c0x0000 (---------------)  + I ac
	0x00310603, // n0x0935 c0x0000 (---------------)  + I biz
	0x1b600742, // n0x0936 c0x006d (n0x093f-n0x0940)  + I co
	0x00227544, // n0x0937 c0x0000 (---------------)  + I desa
	0x00202342, // n0x0938 c0x0000 (---------------)  + I go
	0x0023fa03, // n0x0939 c0x0000 (---------------)  + I mil
	0x00220282, // n0x093a c0x0000 (---------------)  + I my
	0x002170c3, // n0x093b c0x0000 (---------------)  + I net
	0x00200c42, // n0x093c c0x0000 (---------------)  + I or
	0x00206103, // n0x093d c0x0000 (---------------)  + I sch
	0x00219fc3, // n0x093e c0x0000 (---------------)  + I web
	0x000e4188, // n0x093f c0x0000 (---------------)  +   blogspot
	0x000e4188, // n0x0940 c0x0000 (---------------)  +   blogspot
	0x0021e283, // n0x0941 c0x0000 (---------------)  + I gov
	0x1c200742, // n0x0942 c0x0070 (n0x0943-n0x0944)  o I co
	0x000e4188, // n0x0943 c0x0000 (---------------)  +   blogspot
	0x00201e82, // n0x0944 c0x0000 (---------------)  + I ac
	0x1ca00742, // n0x0945 c0x0072 (n0x094b-n0x094d)  + I co
	0x00222ac3, // n0x0946 c0x0000 (---------------)  + I com
	0x002170c3, // n0x0947 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0948 c0x0000 (---------------)  + I org
	0x00206582, // n0x0949 c0x0000 (---------------)  + I tt
	0x0020bf42, // n0x094a c0x0000 (---------------)  + I tv
	0x003413c3, // n0x094b c0x0000 (---------------)  + I ltd
	0x002c65c3, // n0x094c c0x0000 (---------------)  + I plc
	0x00201e82, // n0x094d c0x0000 (---------------)  + I ac
	0x000e4188, // n0x094e c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x094f c0x0000 (---------------)  + I co
	0x002d75c3, // n0x0950 c0x0000 (---------------)  + I edu
	0x00238544, // n0x0951 c0x0000 (---------------)  + I firm
	0x002012c3, // n0x0952 c0x0000 (---------------)  + I gen
	0x0021e283, // n0x0953 c0x0000 (---------------)  + I gov
	0x00215703, // n0x0954 c0x0000 (---------------)  + I ind
	0x0023fa03, // n0x0955 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x0956 c0x0000 (---------------)  + I net
	0x0020e3c3, // n0x0957 c0x0000 (---------------)  + I nic
	0x0021dcc3, // n0x0958 c0x0000 (---------------)  + I org
	0x00215503, // n0x0959 c0x0000 (---------------)  + I res
	0x000f7e53, // n0x095a c0x0000 (---------------)  +   barrel-of-knowledge
	0x00104094, // n0x095b c0x0000 (---------------)  +   barrell-of-knowledge
	0x00009ac6, // n0x095c c0x0000 (---------------)  +   dyndns
	0x00042187, // n0x095d c0x0000 (---------------)  +   for-our
	0x000f8fc9, // n0x095e c0x0000 (---------------)  +   groks-the
	0x0009b5ca, // n0x095f c0x0000 (---------------)  +   groks-this
	0x0007690d, // n0x0960 c0x0000 (---------------)  +   here-for-more
	0x0009bfca, // n0x0961 c0x0000 (---------------)  +   knowsitall
	0x00130f46, // n0x0962 c0x0000 (---------------)  +   selfip
	0x00110e86, // n0x0963 c0x0000 (---------------)  +   webhop
	0x0021d5c2, // n0x0964 c0x0000 (---------------)  + I eu
	0x00222ac3, // n0x0965 c0x0000 (---------------)  + I com
	0x000b53c6, // n0x0966 c0x0000 (---------------)  +   github
	0x000f9303, // n0x0967 c0x0000 (---------------)  +   nid
	0x00222ac3, // n0x0968 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x0969 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x096a c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x096b c0x0000 (---------------)  + I mil
	0x002170c3, // n0x096c c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x096d c0x0000 (---------------)  + I org
	0x00201e82, // n0x096e c0x0000 (---------------)  + I ac
	0x00200742, // n0x096f c0x0000 (---------------)  + I co
	0x0021e283, // n0x0970 c0x0000 (---------------)  + I gov
	0x00206202, // n0x0971 c0x0000 (---------------)  + I id
	0x002170c3, // n0x0972 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0973 c0x0000 (---------------)  + I org
	0x00206103, // n0x0974 c0x0000 (---------------)  + I sch
	0x0034a88f, // n0x0975 c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0034ac4e, // n0x0976 c0x0000 (---------------)  + I xn--mgba3a4fra
	0x000e4188, // n0x0977 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x0978 c0x0000 (---------------)  + I com
	0x000356c7, // n0x0979 c0x0000 (---------------)  +   cupcake
	0x002d75c3, // n0x097a c0x0000 (---------------)  + I edu
	0x0021e283, // n0x097b c0x0000 (---------------)  + I gov
	0x00238c03, // n0x097c c0x0000 (---------------)  + I int
	0x002170c3, // n0x097d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x097e c0x0000 (---------------)  + I org
	0x00214a43, // n0x097f c0x0000 (---------------)  + I abr
	0x0038b8c7, // n0x0980 c0x0000 (---------------)  + I abruzzo
	0x002015c2, // n0x0981 c0x0000 (---------------)  + I ag
	0x00384949, // n0x0982 c0x0000 (---------------)  + I agrigento
	0x00200882, // n0x0983 c0x0000 (---------------)  + I al
	0x0022f94b, // n0x0984 c0x0000 (---------------)  + I alessandria
	0x002d344a, // n0x0985 c0x0000 (---------------)  + I alto-adige
	0x002c0d89, // n0x0986 c0x0000 (---------------)  + I altoadige
	0x00201242, // n0x0987 c0x0000 (---------------)  + I an
	0x00295b46, // n0x0988 c0x0000 (---------------)  + I ancona
	0x00264b95, // n0x0989 c0x0000 (---------------)  + I andria-barletta-trani
	0x0022fa95, // n0x098a c0x0000 (---------------)  + I andria-trani-barletta
	0x0026bc93, // n0x098b c0x0000 (---------------)  + I andriabarlettatrani
	0x00230013, // n0x098c c0x0000 (---------------)  + I andriatranibarletta
	0x0020fd82, // n0x098d c0x0000 (---------------)  + I ao
	0x00218745, // n0x098e c0x0000 (---------------)  + I aosta
	0x00341e0c, // n0x098f c0x0000 (---------------)  + I aosta-valley
	0x0029a44b, // n0x0990 c0x0000 (---------------)  + I aostavalley
	0x00258685, // n0x0991 c0x0000 (---------------)  + I aoste
	0x002105c2, // n0x0992 c0x0000 (---------------)  + I ap
	0x00273fc2, // n0x0993 c0x0000 (---------------)  + I aq
	0x002d7986, // n0x0994 c0x0000 (---------------)  + I aquila
	0x00200602, // n0x0995 c0x0000 (---------------)  + I ar
	0x00363106, // n0x0996 c0x0000 (---------------)  + I arezzo
	0x0020094d, // n0x0997 c0x0000 (---------------)  + I ascoli-piceno
	0x0034714c, // n0x0998 c0x0000 (---------------)  + I ascolipiceno
	0x002166c4, // n0x0999 c0x0000 (---------------)  + I asti
	0x00201642, // n0x099a c0x0000 (---------------)  + I at
	0x00201482, // n0x099b c0x0000 (---------------)  + I av
	0x00369f48, // n0x099c c0x0000 (---------------)  + I avellino
	0x00205a82, // n0x099d c0x0000 (---------------)  + I ba
	0x00240186, // n0x099e c0x0000 (---------------)  + I balsan
	0x0027eb84, // n0x099f c0x0000 (---------------)  + I bari
	0x00264d55, // n0x09a0 c0x0000 (---------------)  + I barletta-trani-andria
	0x0026be13, // n0x09a1 c0x0000 (---------------)  + I barlettatraniandria
	0x0020a443, // n0x09a2 c0x0000 (---------------)  + I bas
	0x0030d98a, // n0x09a3 c0x0000 (---------------)  + I basilicata
	0x002c5dc7, // n0x09a4 c0x0000 (---------------)  + I belluno
	0x0030fa49, // n0x09a5 c0x0000 (---------------)  + I benevento
	0x0023dc87, // n0x09a6 c0x0000 (---------------)  + I bergamo
	0x00355e02, // n0x09a7 c0x0000 (---------------)  + I bg
	0x00200002, // n0x09a8 c0x0000 (---------------)  + I bi
	0x00381ac6, // n0x09a9 c0x0000 (---------------)  + I biella
	0x00205842, // n0x09aa c0x0000 (---------------)  + I bl
	0x000e4188, // n0x09ab c0x0000 (---------------)  +   blogspot
	0x0020a282, // n0x09ac c0x0000 (---------------)  + I bn
	0x0020a702, // n0x09ad c0x0000 (---------------)  + I bo
	0x0034c987, // n0x09ae c0x0000 (---------------)  + I bologna
	0x00391387, // n0x09af c0x0000 (---------------)  + I bolzano
	0x00212b85, // n0x09b0 c0x0000 (---------------)  + I bozen
	0x00212e82, // n0x09b1 c0x0000 (---------------)  + I br
	0x002154c7, // n0x09b2 c0x0000 (---------------)  + I brescia
	0x00215688, // n0x09b3 c0x0000 (---------------)  + I brindisi
	0x00235102, // n0x09b4 c0x0000 (---------------)  + I bs
	0x00216fc2, // n0x09b5 c0x0000 (---------------)  + I bt
	0x002203c2, // n0x09b6 c0x0000 (---------------)  + I bz
	0x002055c2, // n0x09b7 c0x0000 (---------------)  + I ca
	0x00250c08, // n0x09b8 c0x0000 (---------------)  + I cagliari
	0x0020e443, // n0x09b9 c0x0000 (---------------)  + I cal
	0x00238348, // n0x09ba c0x0000 (---------------)  + I calabria
	0x002e718d, // n0x09bb c0x0000 (---------------)  + I caltanissetta
	0x0021a083, // n0x09bc c0x0000 (---------------)  + I cam
	0x00300748, // n0x09bd c0x0000 (---------------)  + I campania
	0x0022c60f, // n0x09be c0x0000 (---------------)  + I campidano-medio
	0x0022c9ce, // n0x09bf c0x0000 (---------------)  + I campidanomedio
	0x0027284a, // n0x09c0 c0x0000 (---------------)  + I campobasso
	0x002d4e91, // n0x09c1 c0x0000 (---------------)  + I carbonia-iglesias
	0x002d5310, // n0x09c2 c0x0000 (---------------)  + I carboniaiglesias
	0x0031888d, // n0x09c3 c0x0000 (---------------)  + I carrara-massa
	0x00318bcc, // n0x09c4 c0x0000 (---------------)  + I carraramassa
	0x002055c7, // n0x09c5 c0x0000 (---------------)  + I caserta
	0x0030db07, // n0x09c6 c0x0000 (---------------)  + I catania
	0x00310c49, // n0x09c7 c0x0000 (---------------)  + I catanzaro
	0x002167c2, // n0x09c8 c0x0000 (---------------)  + I cb
	0x00200b82, // n0x09c9 c0x0000 (---------------)  + I ce
	0x0024434c, // n0x09ca c0x0000 (---------------)  + I cesena-forli
	0x0024464b, // n0x09cb c0x0000 (---------------)  + I cesenaforli
	0x00204a02, // n0x09cc c0x0000 (---------------)  + I ch
	0x002c2546, // n0x09cd c0x0000 (---------------)  + I chieti
	0x002155c2, // n0x09ce c0x0000 (---------------)  + I ci
	0x0020af42, // n0x09cf c0x0000 (---------------)  + I cl
	0x002211c2, // n0x09d0 c0x0000 (---------------)  + I cn
	0x00200742, // n0x09d1 c0x0000 (---------------)  + I co
	0x002230c4, // n0x09d2 c0x0000 (---------------)  + I como
	0x0022bdc7, // n0x09d3 c0x0000 (---------------)  + I cosenza
	0x0020c502, // n0x09d4 c0x0000 (---------------)  + I cr
	0x00230b87, // n0x09d5 c0x0000 (---------------)  + I cremona
	0x00231e07, // n0x09d6 c0x0000 (---------------)  + I crotone
	0x0020f142, // n0x09d7 c0x0000 (---------------)  + I cs
	0x00223d82, // n0x09d8 c0x0000 (---------------)  + I ct
	0x00235585, // n0x09d9 c0x0000 (---------------)  + I cuneo
	0x00214442, // n0x09da c0x0000 (---------------)  + I cz
	0x002e990e, // n0x09db c0x0000 (---------------)  + I dell-ogliastra
	0x002297cd, // n0x09dc c0x0000 (---------------)  + I dellogliastra
	0x002d75c3, // n0x09dd c0x0000 (---------------)  + I edu
	0x0023f9ce, // n0x09de c0x0000 (---------------)  + I emilia-romagna
	0x00261dcd, // n0x09df c0x0000 (---------------)  + I emiliaromagna
	0x0034efc3, // n0x09e0 c0x0000 (---------------)  + I emr
	0x00200bc2, // n0x09e1 c0x0000 (---------------)  + I en
	0x00201504, // n0x09e2 c0x0000 (---------------)  + I enna
	0x00235d42, // n0x09e3 c0x0000 (---------------)  + I fc
	0x0020c742, // n0x09e4 c0x0000 (---------------)  + I fe
	0x002cc345, // n0x09e5 c0x0000 (---------------)  + I fermo
	0x002e3b87, // n0x09e6 c0x0000 (---------------)  + I ferrara
	0x00331442, // n0x09e7 c0x0000 (---------------)  + I fg
	0x002099c2, // n0x09e8 c0x0000 (---------------)  + I fi
	0x00237b87, // n0x09e9 c0x0000 (---------------)  + I firenze
	0x0023c248, // n0x09ea c0x0000 (---------------)  + I florence
	0x00358002, // n0x09eb c0x0000 (---------------)  + I fm
	0x00200386, // n0x09ec c0x0000 (---------------)  + I foggia
	0x002441cc, // n0x09ed c0x0000 (---------------)  + I forli-cesena
	0x0024450b, // n0x09ee c0x0000 (---------------)  + I forlicesena
	0x00200d42, // n0x09ef c0x0000 (---------------)  + I fr
	0x002495cf, // n0x09f0 c0x0000 (---------------)  + I friuli-v-giulia
	0x00249990, // n0x09f1 c0x0000 (---------------)  + I friuli-ve-giulia
	0x00249d8f, // n0x09f2 c0x0000 (---------------)  + I friuli-vegiulia
	0x0024a155, // n0x09f3 c0x0000 (---------------)  + I friuli-venezia-giulia
	0x0024a694, // n0x09f4 c0x0000 (---------------)  + I friuli-veneziagiulia
	0x0024ab8e, // n0x09f5 c0x0000 (---------------)  + I friuli-vgiulia
	0x0024af0e, // n0x09f6 c0x0000 (---------------)  + I friuliv-giulia
	0x0024b28f, // n0x09f7 c0x0000 (---------------)  + I friulive-giulia
	0x0024b64e, // n0x09f8 c0x0000 (---------------)  + I friulivegiulia
	0x0024b9d4, // n0x09f9 c0x0000 (---------------)  + I friulivenezia-giulia
	0x0024bed3, // n0x09fa c0x0000 (---------------)  + I friuliveneziagiulia
	0x0024c38d, // n0x09fb c0x0000 (---------------)  + I friulivgiulia
	0x00263bc9, // n0x09fc c0x0000 (---------------)  + I frosinone
	0x00277443, // n0x09fd c0x0000 (---------------)  + I fvg
	0x002012c2, // n0x09fe c0x0000 (---------------)  + I ge
	0x0030bb05, // n0x09ff c0x0000 (---------------)  + I genoa
	0x002012c6, // n0x0a00 c0x0000 (---------------)  + I genova
	0x00202342, // n0x0a01 c0x0000 (---------------)  + I go
	0x002473c7, // n0x0a02 c0x0000 (---------------)  + I gorizia
	0x0021e283, // n0x0a03 c0x0000 (---------------)  + I gov
	0x0020dc82, // n0x0a04 c0x0000 (---------------)  + I gr
	0x002e9508, // n0x0a05 c0x0000 (---------------)  + I grosseto
	0x002d50d1, // n0x0a06 c0x0000 (---------------)  + I iglesias-carbonia
	0x002d5510, // n0x0a07 c0x0000 (---------------)  + I iglesiascarbonia
	0x00203582, // n0x0a08 c0x0000 (---------------)  + I im
	0x002148c7, // n0x0a09 c0x0000 (---------------)  + I imperia
	0x00202b42, // n0x0a0a c0x0000 (---------------)  + I is
	0x002ee307, // n0x0a0b c0x0000 (---------------)  + I isernia
	0x002034c2, // n0x0a0c c0x0000 (---------------)  + I kr
	0x0036dc89, // n0x0a0d c0x0000 (---------------)  + I la-spezia
	0x002d7947, // n0x0a0e c0x0000 (---------------)  + I laquila
	0x00257b88, // n0x0a0f c0x0000 (---------------)  + I laspezia
	0x0035dc46, // n0x0a10 c0x0000 (---------------)  + I latina
	0x002c64c3, // n0x0a11 c0x0000 (---------------)  + I laz
	0x0035a705, // n0x0a12 c0x0000 (---------------)  + I lazio
	0x002339c2, // n0x0a13 c0x0000 (---------------)  + I lc
	0x00203c42, // n0x0a14 c0x0000 (---------------)  + I le
	0x00381ec5, // n0x0a15 c0x0000 (---------------)  + I lecce
	0x0021e6c5, // n0x0a16 c0x0000 (---------------)  + I lecco
	0x002008c2, // n0x0a17 c0x0000 (---------------)  + I li
	0x0021a583, // n0x0a18 c0x0000 (---------------)  + I lig
	0x00244887, // n0x0a19 c0x0000 (---------------)  + I liguria
	0x003436c7, // n0x0a1a c0x0000 (---------------)  + I livorno
	0x00205882, // n0x0a1b c0x0000 (---------------)  + I lo
	0x002455c4, // n0x0a1c c0x0000 (---------------)  + I lodi
	0x00260a43, // n0x0a1d c0x0000 (---------------)  + I lom
	0x002b0b49, // n0x0a1e c0x0000 (---------------)  + I lombardia
	0x002b8a88, // n0x0a1f c0x0000 (---------------)  + I lombardy
	0x00205ec2, // n0x0a20 c0x0000 (---------------)  + I lt
	0x002071c2, // n0x0a21 c0x0000 (---------------)  + I lu
	0x00219187, // n0x0a22 c0x0000 (---------------)  + I lucania
	0x0021aa05, // n0x0a23 c0x0000 (---------------)  + I lucca
	0x00300248, // n0x0a24 c0x0000 (---------------)  + I macerata
	0x0029c6c7, // n0x0a25 c0x0000 (---------------)  + I mantova
	0x00216503, // n0x0a26 c0x0000 (---------------)  + I mar
	0x0028de06, // n0x0a27 c0x0000 (---------------)  + I marche
	0x0031870d, // n0x0a28 c0x0000 (---------------)  + I massa-carrara
	0x00318a8c, // n0x0a29 c0x0000 (---------------)  + I massacarrara
	0x0029f6c6, // n0x0a2a c0x0000 (---------------)  + I matera
	0x00205942, // n0x0a2b c0x0000 (---------------)  + I mb
	0x0023a6c2, // n0x0a2c c0x0000 (---------------)  + I mc
	0x00208942, // n0x0a2d c0x0000 (---------------)  + I me
	0x0022c48f, // n0x0a2e c0x0000 (---------------)  + I medio-campidano
	0x0022c88e, // n0x0a2f c0x0000 (---------------)  + I mediocampidano
	0x00291407, // n0x0a30 c0x0000 (---------------)  + I messina
	0x00204802, // n0x0a31 c0x0000 (---------------)  + I mi
	0x002f1e85, // n0x0a32 c0x0000 (---------------)  + I milan
	0x002f1e86, // n0x0a33 c0x0000 (---------------)  + I milano
	0x00217082, // n0x0a34 c0x0000 (---------------)  + I mn
	0x00203602, // n0x0a35 c0x0000 (---------------)  + I mo
	0x00278386, // n0x0a36 c0x0000 (---------------)  + I modena
	0x00285643, // n0x0a37 c0x0000 (---------------)  + I mol
	0x002ee246, // n0x0a38 c0x0000 (---------------)  + I molise
	0x002b1e85, // n0x0a39 c0x0000 (---------------)  + I monza
	0x002b1e8d, // n0x0a3a c0x0000 (---------------)  + I monza-brianza
	0x002b26d5, // n0x0a3b c0x0000 (---------------)  + I monza-e-della-brianza
	0x002b2e8c, // n0x0a3c c0x0000 (---------------)  + I monzabrianza
	0x002b39cd, // n0x0a3d c0x0000 (---------------)  + I monzaebrianza
	0x002b3d92, // n0x0a3e c0x0000 (---------------)  + I monzaedellabrianza
	0x00209282, // n0x0a3f c0x0000 (---------------)  + I ms
	0x00259642, // n0x0a40 c0x0000 (---------------)  + I mt
	0x00200282, // n0x0a41 c0x0000 (---------------)  + I na
	0x002b7886, // n0x0a42 c0x0000 (---------------)  + I naples
	0x002d5c46, // n0x0a43 c0x0000 (---------------)  + I napoli
	0x00200c02, // n0x0a44 c0x0000 (---------------)  + I no
	0x00201346, // n0x0a45 c0x0000 (---------------)  + I novara
	0x00205bc2, // n0x0a46 c0x0000 (---------------)  + I nu
	0x00205bc5, // n0x0a47 c0x0000 (---------------)  + I nuoro
	0x002003c2, // n0x0a48 c0x0000 (---------------)  + I og
	0x002298c9, // n0x0a49 c0x0000 (---------------)  + I ogliastra
	0x0022840c, // n0x0a4a c0x0000 (---------------)  + I olbia-tempio
	0x0022874b, // n0x0a4b c0x0000 (---------------)  + I olbiatempio
	0x00200c42, // n0x0a4c c0x0000 (---------------)  + I or
	0x0023c688, // n0x0a4d c0x0000 (---------------)  + I oristano
	0x002031c2, // n0x0a4e c0x0000 (---------------)  + I ot
	0x002052c2, // n0x0a4f c0x0000 (---------------)  + I pa
	0x0029a206, // n0x0a50 c0x0000 (---------------)  + I padova
	0x0034f945, // n0x0a51 c0x0000 (---------------)  + I padua
	0x0021ce87, // n0x0a52 c0x0000 (---------------)  + I palermo
	0x003927c5, // n0x0a53 c0x0000 (---------------)  + I parma
	0x002c0705, // n0x0a54 c0x0000 (---------------)  + I pavia
	0x00203e02, // n0x0a55 c0x0000 (---------------)  + I pc
	0x0029b282, // n0x0a56 c0x0000 (---------------)  + I pd
	0x00214942, // n0x0a57 c0x0000 (---------------)  + I pe
	0x0026fa47, // n0x0a58 c0x0000 (---------------)  + I perugia
	0x0030758d, // n0x0a59 c0x0000 (---------------)  + I pesaro-urbino
	0x0030790c, // n0x0a5a c0x0000 (---------------)  + I pesarourbino
	0x00229107, // n0x0a5b c0x0000 (---------------)  + I pescara
	0x002bf182, // n0x0a5c c0x0000 (---------------)  + I pg
	0x00200b02, // n0x0a5d c0x0000 (---------------)  + I pi
	0x00207788, // n0x0a5e c0x0000 (---------------)  + I piacenza
	0x00261808, // n0x0a5f c0x0000 (---------------)  + I piedmont
	0x002c1308, // n0x0a60 c0x0000 (---------------)  + I piemonte
	0x002cd744, // n0x0a61 c0x0000 (---------------)  + I pisa
	0x002c41c7, // n0x0a62 c0x0000 (---------------)  + I pistoia
	0x002c7d43, // n0x0a63 c0x0000 (---------------)  + I pmn
	0x0023df82, // n0x0a64 c0x0000 (---------------)  + I pn
	0x00203f02, // n0x0a65 c0x0000 (---------------)  + I po
	0x002c9b49, // n0x0a66 c0x0000 (---------------)  + I pordenone
	0x00236a47, // n0x0a67 c0x0000 (---------------)  + I potenza
	0x00218242, // n0x0a68 c0x0000 (---------------)  + I pr
	0x00346185, // n0x0a69 c0x0000 (---------------)  + I prato
	0x00295982, // n0x0a6a c0x0000 (---------------)  + I pt
	0x00223542, // n0x0a6b c0x0000 (---------------)  + I pu
	0x0025cd83, // n0x0a6c c0x0000 (---------------)  + I pug
	0x0025cd86, // n0x0a6d c0x0000 (---------------)  + I puglia
	0x002ce242, // n0x0a6e c0x0000 (---------------)  + I pv
	0x002ce6c2, // n0x0a6f c0x0000 (---------------)  + I pz
	0x00201442, // n0x0a70 c0x0000 (---------------)  + I ra
	0x0038c106, // n0x0a71 c0x0000 (---------------)  + I ragusa
	0x00201447, // n0x0a72 c0x0000 (---------------)  + I ravenna
	0x00227b82, // n0x0a73 c0x0000 (---------------)  + I rc
	0x002030c2, // n0x0a74 c0x0000 (---------------)  + I re
	0x0023818f, // n0x0a75 c0x0000 (---------------)  + I reggio-calabria
	0x0023f80d, // n0x0a76 c0x0000 (---------------)  + I reggio-emilia
	0x0025df8e, // n0x0a77 c0x0000 (---------------)  + I reggiocalabria
	0x00261c4c, // n0x0a78 c0x0000 (---------------)  + I reggioemilia
	0x00204782, // n0x0a79 c0x0000 (---------------)  + I rg
	0x00202842, // n0x0a7a c0x0000 (---------------)  + I ri
	0x0021ba45, // n0x0a7b c0x0000 (---------------)  + I rieti
	0x002e79c6, // n0x0a7c c0x0000 (---------------)  + I rimini
	0x002194c2, // n0x0a7d c0x0000 (---------------)  + I rm
	0x00202182, // n0x0a7e c0x0000 (---------------)  + I rn
	0x00200d82, // n0x0a7f c0x0000 (---------------)  + I ro
	0x0023fb84, // n0x0a80 c0x0000 (---------------)  + I roma
	0x002e7004, // n0x0a81 c0x0000 (---------------)  + I rome
	0x002b1386, // n0x0a82 c0x0000 (---------------)  + I rovigo
	0x00201a02, // n0x0a83 c0x0000 (---------------)  + I sa
	0x002671c7, // n0x0a84 c0x0000 (---------------)  + I salerno
	0x00218483, // n0x0a85 c0x0000 (---------------)  + I sar
	0x0021c048, // n0x0a86 c0x0000 (---------------)  + I sardegna
	0x0021ca08, // n0x0a87 c0x0000 (---------------)  + I sardinia
	0x00369a07, // n0x0a88 c0x0000 (---------------)  + I sassari
	0x00232a46, // n0x0a89 c0x0000 (---------------)  + I savona
	0x00209182, // n0x0a8a c0x0000 (---------------)  + I si
	0x00215803, // n0x0a8b c0x0000 (---------------)  + I sic
	0x00215807, // n0x0a8c c0x0000 (---------------)  + I sicilia
	0x0026b646, // n0x0a8d c0x0000 (---------------)  + I sicily
	0x002b77c5, // n0x0a8e c0x0000 (---------------)  + I siena
	0x002d0d88, // n0x0a8f c0x0000 (---------------)  + I siracusa
	0x00201102, // n0x0a90 c0x0000 (---------------)  + I so
	0x0033ca87, // n0x0a91 c0x0000 (---------------)  + I sondrio
	0x002101c2, // n0x0a92 c0x0000 (---------------)  + I sp
	0x002ceec2, // n0x0a93 c0x0000 (---------------)  + I sr
	0x00211f02, // n0x0a94 c0x0000 (---------------)  + I ss
	0x002b5a09, // n0x0a95 c0x0000 (---------------)  + I suedtirol
	0x0021d0c2, // n0x0a96 c0x0000 (---------------)  + I sv
	0x00200142, // n0x0a97 c0x0000 (---------------)  + I ta
	0x00229383, // n0x0a98 c0x0000 (---------------)  + I taa
	0x0036ec87, // n0x0a99 c0x0000 (---------------)  + I taranto
	0x00203202, // n0x0a9a c0x0000 (---------------)  + I te
	0x0022858c, // n0x0a9b c0x0000 (---------------)  + I tempio-olbia
	0x0022888b, // n0x0a9c c0x0000 (---------------)  + I tempioolbia
	0x0029f746, // n0x0a9d c0x0000 (---------------)  + I teramo
	0x002f9245, // n0x0a9e c0x0000 (---------------)  + I terni
	0x0021d1c2, // n0x0a9f c0x0000 (---------------)  + I tn
	0x00201682, // n0x0aa0 c0x0000 (---------------)  + I to
	0x0029f3c6, // n0x0aa1 c0x0000 (---------------)  + I torino
	0x002520c3, // n0x0aa2 c0x0000 (---------------)  + I tos
	0x003096c7, // n0x0aa3 c0x0000 (---------------)  + I toscana
	0x00285142, // n0x0aa4 c0x0000 (---------------)  + I tp
	0x00202402, // n0x0aa5 c0x0000 (---------------)  + I tr
	0x00264a15, // n0x0aa6 c0x0000 (---------------)  + I trani-andria-barletta
	0x0022fc55, // n0x0aa7 c0x0000 (---------------)  + I trani-barletta-andria
	0x0026bb53, // n0x0aa8 c0x0000 (---------------)  + I traniandriabarletta
	0x00230193, // n0x0aa9 c0x0000 (---------------)  + I tranibarlettaandria
	0x0027cbc7, // n0x0aaa c0x0000 (---------------)  + I trapani
	0x0028cbc8, // n0x0aab c0x0000 (---------------)  + I trentino
	0x0028cbd0, // n0x0aac c0x0000 (---------------)  + I trentino-a-adige
	0x0029458f, // n0x0aad c0x0000 (---------------)  + I trentino-aadige
	0x002d3213, // n0x0aae c0x0000 (---------------)  + I trentino-alto-adige
	0x00306652, // n0x0aaf c0x0000 (---------------)  + I trentino-altoadige
	0x0033be90, // n0x0ab0 c0x0000 (---------------)  + I trentino-s-tirol
	0x0033ac8f, // n0x0ab1 c0x0000 (---------------)  + I trentino-stirol
	0x0038cd52, // n0x0ab2 c0x0000 (---------------)  + I trentino-sud-tirol
	0x002a4691, // n0x0ab3 c0x0000 (---------------)  + I trentino-sudtirol
	0x002acf53, // n0x0ab4 c0x0000 (---------------)  + I trentino-sued-tirol
	0x002b57d2, // n0x0ab5 c0x0000 (---------------)  + I trentino-suedtirol
	0x002bc54f, // n0x0ab6 c0x0000 (---------------)  + I trentinoa-adige
	0x002bd2ce, // n0x0ab7 c0x0000 (---------------)  + I trentinoaadige
	0x002dccd2, // n0x0ab8 c0x0000 (---------------)  + I trentinoalto-adige
	0x002c0b91, // n0x0ab9 c0x0000 (---------------)  + I trentinoaltoadige
	0x002cb48f, // n0x0aba c0x0000 (---------------)  + I trentinos-tirol
	0x002cc70e, // n0x0abb c0x0000 (---------------)  + I trentinostirol
	0x002cda91, // n0x0abc c0x0000 (---------------)  + I trentinosud-tirol
	0x002ce2d0, // n0x0abd c0x0000 (---------------)  + I trentinosudtirol
	0x002cea52, // n0x0abe c0x0000 (---------------)  + I trentinosued-tirol
	0x002dde91, // n0x0abf c0x0000 (---------------)  + I trentinosuedtirol
	0x002d0946, // n0x0ac0 c0x0000 (---------------)  + I trento
	0x002de4c7, // n0x0ac1 c0x0000 (---------------)  + I treviso
	0x00354007, // n0x0ac2 c0x0000 (---------------)  + I trieste
	0x00203a02, // n0x0ac3 c0x0000 (---------------)  + I ts
	0x002af6c5, // n0x0ac4 c0x0000 (---------------)  + I turin
	0x002d8c87, // n0x0ac5 c0x0000 (---------------)  + I tuscany
	0x0020bf42, // n0x0ac6 c0x0000 (---------------)  + I tv
	0x002070c2, // n0x0ac7 c0x0000 (---------------)  + I ud
	0x00319045, // n0x0ac8 c0x0000 (---------------)  + I udine
	0x00215fc3, // n0x0ac9 c0x0000 (---------------)  + I umb
	0x002570c6, // n0x0aca c0x0000 (---------------)  + I umbria
	0x0030774d, // n0x0acb c0x0000 (---------------)  + I urbino-pesaro
	0x00307a8c, // n0x0acc c0x0000 (---------------)  + I urbinopesaro
	0x002013c2, // n0x0acd c0x0000 (---------------)  + I va
	0x00341c8b, // n0x0ace c0x0000 (---------------)  + I val-d-aosta
	0x0029a30a, // n0x0acf c0x0000 (---------------)  + I val-daosta
	0x0030ae0a, // n0x0ad0 c0x0000 (---------------)  + I vald-aosta
	0x0029e789, // n0x0ad1 c0x0000 (---------------)  + I valdaosta
	0x0029c80b, // n0x0ad2 c0x0000 (---------------)  + I valle-aosta
	0x002c904d, // n0x0ad3 c0x0000 (---------------)  + I valle-d-aosta
	0x002d958c, // n0x0ad4 c0x0000 (---------------)  + I valle-daosta
	0x0021860a, // n0x0ad5 c0x0000 (---------------)  + I valleaosta
	0x00244e8c, // n0x0ad6 c0x0000 (---------------)  + I valled-aosta
	0x0024cc8b, // n0x0ad7 c0x0000 (---------------)  + I valledaosta
	0x002584cc, // n0x0ad8 c0x0000 (---------------)  + I vallee-aoste
	0x0025be8b, // n0x0ad9 c0x0000 (---------------)  + I valleeaoste
	0x00263943, // n0x0ada c0x0000 (---------------)  + I vao
	0x00278f86, // n0x0adb c0x0000 (---------------)  + I varese
	0x0030b742, // n0x0adc c0x0000 (---------------)  + I vb
	0x0034a542, // n0x0add c0x0000 (---------------)  + I vc
	0x00211603, // n0x0ade c0x0000 (---------------)  + I vda
	0x002014c2, // n0x0adf c0x0000 (---------------)  + I ve
	0x002014c3, // n0x0ae0 c0x0000 (---------------)  + I ven
	0x003546c6, // n0x0ae1 c0x0000 (---------------)  + I veneto
	0x0024a307, // n0x0ae2 c0x0000 (---------------)  + I venezia
	0x0025c506, // n0x0ae3 c0x0000 (---------------)  + I venice
	0x00220fc8, // n0x0ae4 c0x0000 (---------------)  + I verbania
	0x002a5e88, // n0x0ae5 c0x0000 (---------------)  + I vercelli
	0x00248346, // n0x0ae6 c0x0000 (---------------)  + I verona
	0x00213602, // n0x0ae7 c0x0000 (---------------)  + I vi
	0x002db38d, // n0x0ae8 c0x0000 (---------------)  + I vibo-valentia
	0x002db6cc, // n0x0ae9 c0x0000 (---------------)  + I vibovalentia
	0x00357a87, // n0x0aea c0x0000 (---------------)  + I vicenza
	0x002de2c7, // n0x0aeb c0x0000 (---------------)  + I viterbo
	0x00211782, // n0x0aec c0x0000 (---------------)  + I vr
	0x0020bf82, // n0x0aed c0x0000 (---------------)  + I vs
	0x0021e302, // n0x0aee c0x0000 (---------------)  + I vt
	0x0024ebc2, // n0x0aef c0x0000 (---------------)  + I vv
	0x00200742, // n0x0af0 c0x0000 (---------------)  + I co
	0x002170c3, // n0x0af1 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0af2 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x0af3 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x0af4 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x0af5 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x0af6 c0x0000 (---------------)  + I mil
	0x00298944, // n0x0af7 c0x0000 (---------------)  + I name
	0x002170c3, // n0x0af8 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x0af9 c0x0000 (---------------)  + I org
	0x00206103, // n0x0afa c0x0000 (---------------)  + I sch
	0x00201e82, // n0x0afb c0x0000 (---------------)  + I ac
	0x00210a02, // n0x0afc c0x0000 (---------------)  + I ad
	0x1fa34b45, // n0x0afd c0x007e (n0x0b6a-n0x0b9e)  + I aichi
	0x1fe06e05, // n0x0afe c0x007f (n0x0b9e-n0x0bba)  + I akita
	0x20387ac6, // n0x0aff c0x0080 (n0x0bba-n0x0bd0)  + I aomori
	0x000e4188, // n0x0b00 c0x0000 (---------------)  +   blogspot
	0x206a0745, // n0x0b01 c0x0081 (n0x0bd0-n0x0c0a)  + I chiba
	0x00200742, // n0x0b02 c0x0000 (---------------)  + I co
	0x00203fc2, // n0x0b03 c0x0000 (---------------)  + I ed
	0x20b1c945, // n0x0b04 c0x0082 (n0x0c0a-n0x0c20)  + I ehime
	0x20e6b7c5, // n0x0b05 c0x0083 (n0x0c20-n0x0c2f)  + I fukui
	0x2126c587, // n0x0b06 c0x0084 (n0x0c2f-n0x0c6e)  + I fukuoka
	0x2166d5c9, // n0x0b07 c0x0085 (n0x0c6e-n0x0ca1)  + I fukushima
	0x21a89804, // n0x0b08 c0x0086 (n0x0ca1-n0x0cc7)  + I gifu
	0x00202342, // n0x0b09 c0x0000 (---------------)  + I go
	0x0020dc82, // n0x0b0a c0x0000 (---------------)  + I gr
	0x21e36f85, // n0x0b0b c0x0087 (n0x0cc7-n0x0ceb)  + I gunma
	0x2227c649, // n0x0b0c c0x0088 (n0x0ceb-n0x0d04)  + I hiroshima
	0x2275fc48, // n0x0b0d c0x0089 (n0x0d04-n0x0d92)  + I hokkaido
	0x22a96e45, // n0x0b0e c0x008a (n0x0d92-n0x0dc0)  + I hyogo
	0x22f16ac7, // n0x0b0f c0x008b (n0x0dc0-n0x0df3)  + I ibaraki
	0x23214e48, // n0x0b10 c0x008c (n0x0df3-n0x0e06)  + I ishikawa
	0x236c3b85, // n0x0b11 c0x008d (n0x0e06-n0x0e28)  + I iwate
	0x23a81f06, // n0x0b12 c0x008e (n0x0e28-n0x0e37)  + I kagawa
	0x23e71789, // n0x0b13 c0x008f (n0x0e37-n0x0e4b)  + I kagoshima
	0x24332808, // n0x0b14 c0x0090 (n0x0e4b-n0x0e69)  + I kanagawa
	0x246a8748, // n0x0b15 c0x0091 (n0x0e69-n0x0e6a)* o I kawasaki
	0x24a8294a, // n0x0b16 c0x0092 (n0x0e6a-n0x0e6b)* o I kitakyushu
	0x24e43484, // n0x0b17 c0x0093 (n0x0e6b-n0x0e6c)* o I kobe
	0x252ba445, // n0x0b18 c0x0094 (n0x0e6c-n0x0e8b)  + I kochi
	0x256a2d48, // n0x0b19 c0x0095 (n0x0e8b-n0x0ea5)  + I kumamoto
	0x25aacb05, // n0x0b1a c0x0096 (n0x0ea5-n0x0ec4)  + I kyoto
	0x0020e4c2, // n0x0b1b c0x0000 (---------------)  + I lg
	0x25e28143, // n0x0b1c c0x0097 (n0x0ec4-n0x0ee2)  + I mie
	0x2628d746, // n0x0b1d c0x0098 (n0x0ee2-n0x0f03)  + I miyagi
	0x26771208, // n0x0b1e c0x0099 (n0x0f03-n0x0f1e)  + I miyazaki
	0x26b4e4c6, // n0x0b1f c0x009a (n0x0f1e-n0x0f69)  + I nagano
	0x26f6c108, // n0x0b20 c0x009b (n0x0f69-n0x0f7f)  + I nagasaki
	0x2732b206, // n0x0b21 c0x009c (n0x0f7f-n0x0f80)* o I nagoya
	0x276da0c4, // n0x0b22 c0x009d (n0x0f80-n0x0fa6)  + I nara
	0x00201082, // n0x0b23 c0x0000 (---------------)  + I ne
	0x27a5f907, // n0x0b24 c0x009e (n0x0fa6-n0x0fc8)  + I niigata
	0x27e98d04, // n0x0b25 c0x009f (n0x0fc8-n0x0fdb)  + I oita
	0x28266607, // n0x0b26 c0x00a0 (n0x0fdb-n0x0ff5)  + I okayama
	0x287954c7, // n0x0b27 c0x00a1 (n0x0ff5-n0x101f)  + I okinawa
	0x00200c42, // n0x0b28 c0x0000 (---------------)  + I or
	0x28a864c5, // n0x0b29 c0x00a2 (n0x101f-n0x1051)  + I osaka
	0x28e75104, // n0x0b2a c0x00a3 (n0x1051-n0x106b)  + I saga
	0x292d0f07, // n0x0b2b c0x00a4 (n0x106b-n0x10b0)  + I saitama
	0x296129c7, // n0x0b2c c0x00a5 (n0x10b0-n0x10b1)* o I sapporo
	0x29a6f286, // n0x0b2d c0x00a6 (n0x10b1-n0x10b2)* o I sendai
	0x29e525c5, // n0x0b2e c0x00a7 (n0x10b2-n0x10c9)  + I shiga
	0x2a281087, // n0x0b2f c0x00a8 (n0x10c9-n0x10e0)  + I shimane
	0x2a6b4b88, // n0x0b30 c0x00a9 (n0x10e0-n0x1104)  + I shizuoka
	0x2ab0f5c7, // n0x0b31 c0x00aa (n0x1104-n0x1123)  + I tochigi
	0x2ae8e2c9, // n0x0b32 c0x00ab (n0x1123-n0x1134)  + I tokushima
	0x2b316545, // n0x0b33 c0x00ac (n0x1134-n0x116d)  + I tokyo
	0x2b6e2787, // n0x0b34 c0x00ad (n0x116d-n0x117a)  + I tottori
	0x2ba7c346, // n0x0b35 c0x00ae (n0x117a-n0x1192)  + I toyama
	0x2bf2dc48, // n0x0b36 c0x00af (n0x1192-n0x11af)  + I wakayama
	0x0022528d, // n0x0b37 c0x0000 (---------------)  + I xn--0trq7p7nn
	0x00260809, // n0x0b38 c0x0000 (---------------)  + I xn--1ctwo
	0x0026d84b, // n0x0b39 c0x0000 (---------------)  + I xn--1lqs03n
	0x002910cb, // n0x0b3a c0x0000 (---------------)  + I xn--1lqs71d
	0x002b1bcb, // n0x0b3b c0x0000 (---------------)  + I xn--2m4a15e
	0x002d6b8b, // n0x0b3c c0x0000 (---------------)  + I xn--32vp30h
	0x002e7bcb, // n0x0b3d c0x0000 (---------------)  + I xn--4it168d
	0x002e7e8b, // n0x0b3e c0x0000 (---------------)  + I xn--4it797k
	0x002e8689, // n0x0b3f c0x0000 (---------------)  + I xn--4pvxs
	0x002ea38b, // n0x0b40 c0x0000 (---------------)  + I xn--5js045d
	0x002ea64b, // n0x0b41 c0x0000 (---------------)  + I xn--5rtp49c
	0x002ead0b, // n0x0b42 c0x0000 (---------------)  + I xn--5rtq34k
	0x002eb3ca, // n0x0b43 c0x0000 (---------------)  + I xn--6btw5a
	0x002eb90a, // n0x0b44 c0x0000 (---------------)  + I xn--6orx2r
	0x002ebf0c, // n0x0b45 c0x0000 (---------------)  + I xn--7t0a264c
	0x002f16cb, // n0x0b46 c0x0000 (---------------)  + I xn--8ltr62k
	0x002f200a, // n0x0b47 c0x0000 (---------------)  + I xn--8pvr4u
	0x0030374a, // n0x0b48 c0x0000 (---------------)  + I xn--c3s14m
	0x0031334e, // n0x0b49 c0x0000 (---------------)  + I xn--d5qv7z876c
	0x00313d4e, // n0x0b4a c0x0000 (---------------)  + I xn--djrs72d6uy
	0x003140ca, // n0x0b4b c0x0000 (---------------)  + I xn--djty4k
	0x003153ca, // n0x0b4c c0x0000 (---------------)  + I xn--efvn9s
	0x0031700b, // n0x0b4d c0x0000 (---------------)  + I xn--ehqz56n
	0x003172cb, // n0x0b4e c0x0000 (---------------)  + I xn--elqq16h
	0x00317fcb, // n0x0b4f c0x0000 (---------------)  + I xn--f6qx53a
	0x00333bcb, // n0x0b50 c0x0000 (---------------)  + I xn--k7yn95e
	0x003341ca, // n0x0b51 c0x0000 (---------------)  + I xn--kbrq7o
	0x00334e8b, // n0x0b52 c0x0000 (---------------)  + I xn--klt787d
	0x0033514a, // n0x0b53 c0x0000 (---------------)  + I xn--kltp7d
	0x003353ca, // n0x0b54 c0x0000 (---------------)  + I xn--kltx9a
	0x0033564a, // n0x0b55 c0x0000 (---------------)  + I xn--klty5x
	0x00357c4b, // n0x0b56 c0x0000 (---------------)  + I xn--mkru45i
	0x0035d08b, // n0x0b57 c0x0000 (---------------)  + I xn--nit225k
	0x0036094e, // n0x0b58 c0x0000 (---------------)  + I xn--ntso0iqx3a
	0x00360ccb, // n0x0b59 c0x0000 (---------------)  + I xn--ntsq17g
	0x003687cb, // n0x0b5a c0x0000 (---------------)  + I xn--pssu33l
	0x0036a44b, // n0x0b5b c0x0000 (---------------)  + I xn--qqqt11m
	0x003725ca, // n0x0b5c c0x0000 (---------------)  + I xn--rht27z
	0x00372849, // n0x0b5d c0x0000 (---------------)  + I xn--rht3d
	0x00372a8a, // n0x0b5e c0x0000 (---------------)  + I xn--rht61e
	0x0037410a, // n0x0b5f c0x0000 (---------------)  + I xn--rny31h
	0x0038548b, // n0x0b60 c0x0000 (---------------)  + I xn--tor131o
	0x00386f0b, // n0x0b61 c0x0000 (---------------)  + I xn--uist22h
	0x0038744a, // n0x0b62 c0x0000 (---------------)  + I xn--uisz3g
	0x0038824b, // n0x0b63 c0x0000 (---------------)  + I xn--uuwu58a
	0x0038d1cb, // n0x0b64 c0x0000 (---------------)  + I xn--vgu402c
	0x00395d8b, // n0x0b65 c0x0000 (---------------)  + I xn--zbx025d
	0x2c26dc08, // n0x0b66 c0x00b0 (n0x11af-n0x11d1)  + I yamagata
	0x2c676089, // n0x0b67 c0x00b1 (n0x11d1-n0x11e1)  + I yamaguchi
	0x2ca9b889, // n0x0b68 c0x00b2 (n0x11e1-n0x11fd)  + I yamanashi
	0x2cf2b5c8, // n0x0b69 c0x00b3 (n0x11fd-n0x11fe)* o I yokohama
	0x002a2345, // n0x0b6a c0x0000 (---------------)  + I aisai
	0x002068c3, // n0x0b6b c0x0000 (---------------)  + I ama
	0x00203884, // n0x0b6c c0x0000 (---------------)  + I anjo
	0x0034cb85, // n0x0b6d c0x0000 (---------------)  + I asuke
	0x00289546, // n0x0b6e c0x0000 (---------------)  + I chiryu
	0x002932c5, // n0x0b6f c0x0000 (---------------)  + I chita
	0x00274d84, // n0x0b70 c0x0000 (---------------)  + I fuso
	0x002472c8, // n0x0b71 c0x0000 (---------------)  + I gamagori
	0x00242045, // n0x0b72 c0x0000 (---------------)  + I handa
	0x0027ed44, // n0x0b73 c0x0000 (---------------)  + I hazu
	0x002b2387, // n0x0b74 c0x0000 (---------------)  + I hekinan
	0x00288d0a, // n0x0b75 c0x0000 (---------------)  + I higashiura
	0x002a580a, // n0x0b76 c0x0000 (---------------)  + I ichinomiya
	0x0031f587, // n0x0b77 c0x0000 (---------------)  + I inazawa
	0x002067c7, // n0x0b78 c0x0000 (---------------)  + I inuyama
	0x002d6707, // n0x0b79 c0x0000 (---------------)  + I isshiki
	0x00248887, // n0x0b7a c0x0000 (---------------)  + I iwakura
	0x00203cc5, // n0x0b7b c0x0000 (---------------)  + I kanie
	0x00311ec6, // n0x0b7c c0x0000 (---------------)  + I kariya
	0x0027cf47, // n0x0b7d c0x0000 (---------------)  + I kasugai
	0x0025a504, // n0x0b7e c0x0000 (---------------)  + I kira
	0x002fe646, // n0x0b7f c0x0000 (---------------)  + I kiyosu
	0x002977c6, // n0x0b80 c0x0000 (---------------)  + I komaki
	0x00204cc5, // n0x0b81 c0x0000 (---------------)  + I konan
	0x0024c9c4, // n0x0b82 c0x0000 (---------------)  + I kota
	0x00292a46, // n0x0b83 c0x0000 (---------------)  + I mihama
	0x00288107, // n0x0b84 c0x0000 (---------------)  + I miyoshi
	0x002209c6, // n0x0b85 c0x0000 (---------------)  + I nishio
	0x002e6987, // n0x0b86 c0x0000 (---------------)  + I nisshin
	0x0027e743, // n0x0b87 c0x0000 (---------------)  + I obu
	0x0023be46, // n0x0b88 c0x0000 (---------------)  + I oguchi
	0x0024f085, // n0x0b89 c0x0000 (---------------)  + I oharu
	0x0026c687, // n0x0b8a c0x0000 (---------------)  + I okazaki
	0x002ad48a, // n0x0b8b c0x0000 (---------------)  + I owariasahi
	0x002e9604, // n0x0b8c c0x0000 (---------------)  + I seto
	0x00213308, // n0x0b8d c0x0000 (---------------)  + I shikatsu
	0x0028d309, // n0x0b8e c0x0000 (---------------)  + I shinshiro
	0x002a4307, // n0x0b8f c0x0000 (---------------)  + I shitara
	0x0026a586, // n0x0b90 c0x0000 (---------------)  + I tahara
	0x00248648, // n0x0b91 c0x0000 (---------------)  + I takahama
	0x0030be89, // n0x0b92 c0x0000 (---------------)  + I tobishima
	0x00366704, // n0x0b93 c0x0000 (---------------)  + I toei
	0x0025d104, // n0x0b94 c0x0000 (---------------)  + I togo
	0x002df1c5, // n0x0b95 c0x0000 (---------------)  + I tokai
	0x00376b08, // n0x0b96 c0x0000 (---------------)  + I tokoname
	0x002aeb47, // n0x0b97 c0x0000 (---------------)  + I toyoake
	0x00286c89, // n0x0b98 c0x0000 (---------------)  + I toyohashi
	0x00322bc8, // n0x0b99 c0x0000 (---------------)  + I toyokawa
	0x00221246, // n0x0b9a c0x0000 (---------------)  + I toyone
	0x00338906, // n0x0b9b c0x0000 (---------------)  + I toyota
	0x00283308, // n0x0b9c c0x0000 (---------------)  + I tsushima
	0x00359906, // n0x0b9d c0x0000 (---------------)  + I yatomi
	0x00206e05, // n0x0b9e c0x0000 (---------------)  + I akita
	0x0026f346, // n0x0b9f c0x0000 (---------------)  + I daisen
	0x00266b48, // n0x0ba0 c0x0000 (---------------)  + I fujisato
	0x002dc286, // n0x0ba1 c0x0000 (---------------)  + I gojome
	0x0024608b, // n0x0ba2 c0x0000 (---------------)  + I hachirogata
	0x00279ac6, // n0x0ba3 c0x0000 (---------------)  + I happou
	0x00284b0d, // n0x0ba4 c0x0000 (---------------)  + I higashinaruse
	0x002028c5, // n0x0ba5 c0x0000 (---------------)  + I honjo
	0x00292e46, // n0x0ba6 c0x0000 (---------------)  + I honjyo
	0x00214f05, // n0x0ba7 c0x0000 (---------------)  + I ikawa
	0x00281889, // n0x0ba8 c0x0000 (---------------)  + I kamikoani
	0x0022ea47, // n0x0ba9 c0x0000 (---------------)  + I kamioka
	0x0033ecc8, // n0x0baa c0x0000 (---------------)  + I katagami
	0x0022bc46, // n0x0bab c0x0000 (---------------)  + I kazuno
	0x00283c89, // n0x0bac c0x0000 (---------------)  + I kitaakita
	0x0036b9c6, // n0x0bad c0x0000 (---------------)  + I kosaka
	0x002ad405, // n0x0bae c0x0000 (---------------)  + I kyowa
	0x0028b246, // n0x0baf c0x0000 (---------------)  + I misato
	0x002bf786, // n0x0bb0 c0x0000 (---------------)  + I mitane
	0x002b5c49, // n0x0bb1 c0x0000 (---------------)  + I moriyoshi
	0x00226806, // n0x0bb2 c0x0000 (---------------)  + I nikaho
	0x0023a007, // n0x0bb3 c0x0000 (---------------)  + I noshiro
	0x0027bd85, // n0x0bb4 c0x0000 (---------------)  + I odate
	0x00204043, // n0x0bb5 c0x0000 (---------------)  + I oga
	0x00246205, // n0x0bb6 c0x0000 (---------------)  + I ogata
	0x00293cc7, // n0x0bb7 c0x0000 (---------------)  + I semboku
	0x0023ed06, // n0x0bb8 c0x0000 (---------------)  + I yokote
	0x002027c9, // n0x0bb9 c0x0000 (---------------)  + I yurihonjo
	0x00387ac6, // n0x0bba c0x0000 (---------------)  + I aomori
	0x0026f586, // n0x0bbb c0x0000 (---------------)  + I gonohe
	0x0022e109, // n0x0bbc c0x0000 (---------------)  + I hachinohe
	0x0026ed49, // n0x0bbd c0x0000 (---------------)  + I hashikami
	0x0028bc07, // n0x0bbe c0x0000 (---------------)  + I hiranai
	0x00305a08, // n0x0bbf c0x0000 (---------------)  + I hirosaki
	0x00273909, // n0x0bc0 c0x0000 (---------------)  + I itayanagi
	0x0026ce88, // n0x0bc1 c0x0000 (---------------)  + I kuroishi
	0x0035c906, // n0x0bc2 c0x0000 (---------------)  + I misawa
	0x002bda45, // n0x0bc3 c0x0000 (---------------)  + I mutsu
	0x0021638a, // n0x0bc4 c0x0000 (---------------)  + I nakadomari
	0x0026f606, // n0x0bc5 c0x0000 (---------------)  + I noheji
	0x0035e1c6, // n0x0bc6 c0x0000 (---------------)  + I oirase
	0x0028d905, // n0x0bc7 c0x0000 (---------------)  + I owani
	0x00205c88, // n0x0bc8 c0x0000 (---------------)  + I rokunohe
	0x002092c7, // n0x0bc9 c0x0000 (---------------)  + I sannohe
	0x0029ba0a, // n0x0bca c0x0000 (---------------)  + I shichinohe
	0x00238986, // n0x0bcb c0x0000 (---------------)  + I shingo
	0x0024cec5, // n0x0bcc c0x0000 (---------------)  + I takko
	0x0023e846, // n0x0bcd c0x0000 (---------------)  + I towada
	0x002e1a47, // n0x0bce c0x0000 (---------------)  + I tsugaru
	0x0026a447, // n0x0bcf c0x0000 (---------------)  + I tsuruta
	0x002041c5, // n0x0bd0 c0x0000 (---------------)  + I abiko
	0x002ad5c5, // n0x0bd1 c0x0000 (---------------)  + I asahi
	0x002c6646, // n0x0bd2 c0x0000 (---------------)  + I chonan
	0x002c6e86, // n0x0bd3 c0x0000 (---------------)  + I chosei
	0x0034a586, // n0x0bd4 c0x0000 (---------------)  + I choshi
	0x002be904, // n0x0bd5 c0x0000 (---------------)  + I chuo
	0x0026e2c9, // n0x0bd6 c0x0000 (---------------)  + I funabashi
	0x00276f46, // n0x0bd7 c0x0000 (---------------)  + I futtsu
	0x002d6f4a, // n0x0bd8 c0x0000 (---------------)  + I hanamigawa
	0x0027df48, // n0x0bd9 c0x0000 (---------------)  + I ichihara
	0x00312b88, // n0x0bda c0x0000 (---------------)  + I ichikawa
	0x002a580a, // n0x0bdb c0x0000 (---------------)  + I ichinomiya
	0x00329b05, // n0x0bdc c0x0000 (---------------)  + I inzai
	0x00288045, // n0x0bdd c0x0000 (---------------)  + I isumi
	0x00269408, // n0x0bde c0x0000 (---------------)  + I kamagaya
	0x002ba1c8, // n0x0bdf c0x0000 (---------------)  + I kamogawa
	0x00375c87, // n0x0be0 c0x0000 (---------------)  + I kashiwa
	0x00335e46, // n0x0be1 c0x0000 (---------------)  + I katori
	0x002fd408, // n0x0be2 c0x0000 (---------------)  + I katsuura
	0x0027d607, // n0x0be3 c0x0000 (---------------)  + I kimitsu
	0x0026c7c8, // n0x0be4 c0x0000 (---------------)  + I kisarazu
	0x0035d306, // n0x0be5 c0x0000 (---------------)  + I kozaki
	0x0026ff48, // n0x0be6 c0x0000 (---------------)  + I kujukuri
	0x0027e846, // n0x0be7 c0x0000 (---------------)  + I kyonan
	0x0023b8c7, // n0x0be8 c0x0000 (---------------)  + I matsudo
	0x002846c6, // n0x0be9 c0x0000 (---------------)  + I midori
	0x00292a46, // n0x0bea c0x0000 (---------------)  + I mihama
	0x00213fca, // n0x0beb c0x0000 (---------------)  + I minamiboso
	0x00223146, // n0x0bec c0x0000 (---------------)  + I mobara
	0x002bda49, // n0x0bed c0x0000 (---------------)  + I mutsuzawa
	0x0032a1c6, // n0x0bee c0x0000 (---------------)  + I nagara
	0x002a0a8a, // n0x0bef c0x0000 (---------------)  + I nagareyama
	0x002da0c9, // n0x0bf0 c0x0000 (---------------)  + I narashino
	0x0025ac46, // n0x0bf1 c0x0000 (---------------)  + I narita
	0x00384f84, // n0x0bf2 c0x0000 (---------------)  + I noda
	0x0030bbcd, // n0x0bf3 c0x0000 (---------------)  + I oamishirasato
	0x00276307, // n0x0bf4 c0x0000 (---------------)  + I omigawa
	0x002fffc6, // n0x0bf5 c0x0000 (---------------)  + I onjuku
	0x002a8605, // n0x0bf6 c0x0000 (---------------)  + I otaki
	0x0036ba45, // n0x0bf7 c0x0000 (---------------)  + I sakae
	0x002f4d46, // n0x0bf8 c0x0000 (---------------)  + I sakura
	0x002a73c9, // n0x0bf9 c0x0000 (---------------)  + I shimofusa
	0x002b9447, // n0x0bfa c0x0000 (---------------)  + I shirako
	0x00268406, // n0x0bfb c0x0000 (---------------)  + I shiroi
	0x0029fd06, // n0x0bfc c0x0000 (---------------)  + I shisui
	0x00274e09, // n0x0bfd c0x0000 (---------------)  + I sodegaura
	0x0022a904, // n0x0bfe c0x0000 (---------------)  + I sosa
	0x0021f304, // n0x0bff c0x0000 (---------------)  + I tako
	0x0038a708, // n0x0c00 c0x0000 (---------------)  + I tateyama
	0x002e5fc6, // n0x0c01 c0x0000 (---------------)  + I togane
	0x00340e08, // n0x0c02 c0x0000 (---------------)  + I tohnosho
	0x003163c8, // n0x0c03 c0x0000 (---------------)  + I tomisato
	0x00206f47, // n0x0c04 c0x0000 (---------------)  + I urayasu
	0x00382d89, // n0x0c05 c0x0000 (---------------)  + I yachimata
	0x002e38c7, // n0x0c06 c0x0000 (---------------)  + I yachiyo
	0x002a060a, // n0x0c07 c0x0000 (---------------)  + I yokaichiba
	0x00315d8f, // n0x0c08 c0x0000 (---------------)  + I yokoshibahikari
	0x002394ca, // n0x0c09 c0x0000 (---------------)  + I yotsukaido
	0x0021b845, // n0x0c0a c0x0000 (---------------)  + I ainan
	0x00266d85, // n0x0c0b c0x0000 (---------------)  + I honai
	0x0020f345, // n0x0c0c c0x0000 (---------------)  + I ikata
	0x0027eac7, // n0x0c0d c0x0000 (---------------)  + I imabari
	0x00253503, // n0x0c0e c0x0000 (---------------)  + I iyo
	0x00305c08, // n0x0c0f c0x0000 (---------------)  + I kamijima
	0x0037aec6, // n0x0c10 c0x0000 (---------------)  + I kihoku
	0x0037afc9, // n0x0c11 c0x0000 (---------------)  + I kumakogen
	0x002e5286, // n0x0c12 c0x0000 (---------------)  + I masaki
	0x00392e07, // n0x0c13 c0x0000 (---------------)  + I matsuno
	0x00283a49, // n0x0c14 c0x0000 (---------------)  + I matsuyama
	0x0033ebc8, // n0x0c15 c0x0000 (---------------)  + I namikata
	0x0028d9c7, // n0x0c16 c0x0000 (---------------)  + I niihama
	0x002e3dc3, // n0x0c17 c0x0000 (---------------)  + I ozu
	0x002a23c5, // n0x0c18 c0x0000 (---------------)  + I saijo
	0x00315cc5, // n0x0c19 c0x0000 (---------------)  + I seiyo
	0x002be74b, // n0x0c1a c0x0000 (---------------)  + I shikokuchuo
	0x002acbc4, // n0x0c1b c0x0000 (---------------)  + I tobe
	0x002d1504, // n0x0c1c c0x0000 (---------------)  + I toon
	0x00265706, // n0x0c1d c0x0000 (---------------)  + I uchiko
	0x002e4647, // n0x0c1e c0x0000 (---------------)  + I uwajima
	0x003804ca, // n0x0c1f c0x0000 (---------------)  + I yawatahama
	0x002281c7, // n0x0c20 c0x0000 (---------------)  + I echizen
	0x00366787, // n0x0c21 c0x0000 (---------------)  + I eiheiji
	0x0026b7c5, // n0x0c22 c0x0000 (---------------)  + I fukui
	0x00390e45, // n0x0c23 c0x0000 (---------------)  + I ikeda
	0x00260149, // n0x0c24 c0x0000 (---------------)  + I katsuyama
	0x00292a46, // n0x0c25 c0x0000 (---------------)  + I mihama
	0x0022804d, // n0x0c26 c0x0000 (---------------)  + I minamiechizen
	0x00395885, // n0x0c27 c0x0000 (---------------)  + I obama
	0x00285a43, // n0x0c28 c0x0000 (---------------)  + I ohi
	0x00207e83, // n0x0c29 c0x0000 (---------------)  + I ono
	0x003404c5, // n0x0c2a c0x0000 (---------------)  + I sabae
	0x003396c5, // n0x0c2b c0x0000 (---------------)  + I sakai
	0x00248648, // n0x0c2c c0x0000 (---------------)  + I takahama
	0x00277007, // n0x0c2d c0x0000 (---------------)  + I tsuruga
	0x0021f086, // n0x0c2e c0x0000 (---------------)  + I wakasa
	0x00289c86, // n0x0c2f c0x0000 (---------------)  + I ashiya
	0x0021de85, // n0x0c30 c0x0000 (---------------)  + I buzen
	0x00375807, // n0x0c31 c0x0000 (---------------)  + I chikugo
	0x00206a47, // n0x0c32 c0x0000 (---------------)  + I chikuho
	0x002a5bc7, // n0x0c33 c0x0000 (---------------)  + I chikujo
	0x002ba4ca, // n0x0c34 c0x0000 (---------------)  + I chikushino
	0x0023bf08, // n0x0c35 c0x0000 (---------------)  + I chikuzen
	0x002be904, // n0x0c36 c0x0000 (---------------)  + I chuo
	0x0024ed47, // n0x0c37 c0x0000 (---------------)  + I dazaifu
	0x0026ae87, // n0x0c38 c0x0000 (---------------)  + I fukuchi
	0x00317546, // n0x0c39 c0x0000 (---------------)  + I hakata
	0x002545c7, // n0x0c3a c0x0000 (---------------)  + I higashi
	0x002c5b48, // n0x0c3b c0x0000 (---------------)  + I hirokawa
	0x0029b788, // n0x0c3c c0x0000 (---------------)  + I hisayama
	0x00246d86, // n0x0c3d c0x0000 (---------------)  + I iizuka
	0x0023abc8, // n0x0c3e c0x0000 (---------------)  + I inatsuki
	0x00226884, // n0x0c3f c0x0000 (---------------)  + I kaho
	0x0027cf46, // n0x0c40 c0x0000 (---------------)  + I kasuga
	0x0020d3c6, // n0x0c41 c0x0000 (---------------)  + I kasuya
	0x003824c6, // n0x0c42 c0x0000 (---------------)  + I kawara
	0x00295dc6, // n0x0c43 c0x0000 (---------------)  + I keisen
	0x00232c84, // n0x0c44 c0x0000 (---------------)  + I koga
	0x00248946, // n0x0c45 c0x0000 (---------------)  + I kurate
	0x002a67c6, // n0x0c46 c0x0000 (---------------)  + I kurogi
	0x00282e46, // n0x0c47 c0x0000 (---------------)  + I kurume
	0x00213fc6, // n0x0c48 c0x0000 (---------------)  + I minami
	0x00207d46, // n0x0c49 c0x0000 (---------------)  + I miyako
	0x00272346, // n0x0c4a c0x0000 (---------------)  + I miyama
	0x0021ef88, // n0x0c4b c0x0000 (---------------)  + I miyawaka
	0x002fe4c8, // n0x0c4c c0x0000 (---------------)  + I mizumaki
	0x002bb0c8, // n0x0c4d c0x0000 (---------------)  + I munakata
	0x002934c8, // n0x0c4e c0x0000 (---------------)  + I nakagawa
	0x00269386, // n0x0c4f c0x0000 (---------------)  + I nakama
	0x00208b85, // n0x0c50 c0x0000 (---------------)  + I nishi
	0x0031b486, // n0x0c51 c0x0000 (---------------)  + I nogata
	0x00296ec5, // n0x0c52 c0x0000 (---------------)  + I ogori
	0x0035c047, // n0x0c53 c0x0000 (---------------)  + I okagaki
	0x0022ecc5, // n0x0c54 c0x0000 (---------------)  + I okawa
	0x00201bc3, // n0x0c55 c0x0000 (---------------)  + I oki
	0x00200085, // n0x0c56 c0x0000 (---------------)  + I omuta
	0x002c7844, // n0x0c57 c0x0000 (---------------)  + I onga
	0x00207e85, // n0x0c58 c0x0000 (---------------)  + I onojo
	0x0020fdc3, // n0x0c59 c0x0000 (---------------)  + I oto
	0x002d47c7, // n0x0c5a c0x0000 (---------------)  + I saigawa
	0x00333848, // n0x0c5b c0x0000 (---------------)  + I sasaguri
	0x002e6a46, // n0x0c5c c0x0000 (---------------)  + I shingu
	0x0029230d, // n0x0c5d c0x0000 (---------------)  + I shinyoshitomi
	0x00266d46, // n0x0c5e c0x0000 (---------------)  + I shonai
	0x002823c5, // n0x0c5f c0x0000 (---------------)  + I soeda
	0x002ad183, // n0x0c60 c0x0000 (---------------)  + I sue
	0x002a2189, // n0x0c61 c0x0000 (---------------)  + I tachiarai
	0x0020e146, // n0x0c62 c0x0000 (---------------)  + I tagawa
	0x002344c6, // n0x0c63 c0x0000 (---------------)  + I takata
	0x00253644, // n0x0c64 c0x0000 (---------------)  + I toho
	0x00239447, // n0x0c65 c0x0000 (---------------)  + I toyotsu
	0x00227786, // n0x0c66 c0x0000 (---------------)  + I tsuiki
	0x00289985, // n0x0c67 c0x0000 (---------------)  + I ukiha
	0x00209803, // n0x0c68 c0x0000 (---------------)  + I umi
	0x00211e04, // n0x0c69 c0x0000 (---------------)  + I usui
	0x0026b046, // n0x0c6a c0x0000 (---------------)  + I yamada
	0x002d81c4, // n0x0c6b c0x0000 (---------------)  + I yame
	0x002f7448, // n0x0c6c c0x0000 (---------------)  + I yanagawa
	0x0038f4c9, // n0x0c6d c0x0000 (---------------)  + I yukuhashi
	0x0022ef49, // n0x0c6e c0x0000 (---------------)  + I aizubange
	0x0028b14a, // n0x0c6f c0x0000 (---------------)  + I aizumisato
	0x0023124d, // n0x0c70 c0x0000 (---------------)  + I aizuwakamatsu
	0x00240607, // n0x0c71 c0x0000 (---------------)  + I asakawa
	0x00255706, // n0x0c72 c0x0000 (---------------)  + I bandai
	0x00209004, // n0x0c73 c0x0000 (---------------)  + I date
	0x0026d5c9, // n0x0c74 c0x0000 (---------------)  + I fukushima
	0x00274788, // n0x0c75 c0x0000 (---------------)  + I furudono
	0x00275f06, // n0x0c76 c0x0000 (---------------)  + I futaba
	0x002e9cc6, // n0x0c77 c0x0000 (---------------)  + I hanawa
	0x002545c7, // n0x0c78 c0x0000 (---------------)  + I higashi
	0x0029cdc6, // n0x0c79 c0x0000 (---------------)  + I hirata
	0x0021af86, // n0x0c7a c0x0000 (---------------)  + I hirono
	0x00329c06, // n0x0c7b c0x0000 (---------------)  + I iitate
	0x0039554a, // n0x0c7c c0x0000 (---------------)  + I inawashiro
	0x00214e48, // n0x0c7d c0x0000 (---------------)  + I ishikawa
	0x002999c5, // n0x0c7e c0x0000 (---------------)  + I iwaki
	0x00254a09, // n0x0c7f c0x0000 (---------------)  + I izumizaki
	0x002af2ca, // n0x0c80 c0x0000 (---------------)  + I kagamiishi
	0x002150c8, // n0x0c81 c0x0000 (---------------)  + I kaneyama
	0x00287448, // n0x0c82 c0x0000 (---------------)  + I kawamata
	0x002815c8, // n0x0c83 c0x0000 (---------------)  + I kitakata
	0x00293e8c, // n0x0c84 c0x0000 (---------------)  + I kitashiobara
	0x002c3e45, // n0x0c85 c0x0000 (---------------)  + I koori
	0x00289f08, // n0x0c86 c0x0000 (---------------)  + I koriyama
	0x002f1d86, // n0x0c87 c0x0000 (---------------)  + I kunimi
	0x002d1906, // n0x0c88 c0x0000 (---------------)  + I miharu
	0x00392cc7, // n0x0c89 c0x0000 (---------------)  + I mishima
	0x002280c5, // n0x0c8a c0x0000 (---------------)  + I namie
	0x0026f4c5, // n0x0c8b c0x0000 (---------------)  + I nango
	0x0022ee09, // n0x0c8c c0x0000 (---------------)  + I nishiaizu
	0x0020bd87, // n0x0c8d c0x0000 (---------------)  + I nishigo
	0x0037af85, // n0x0c8e c0x0000 (---------------)  + I okuma
	0x0021e147, // n0x0c8f c0x0000 (---------------)  + I omotego
	0x00207e83, // n0x0c90 c0x0000 (---------------)  + I ono
	0x002af985, // n0x0c91 c0x0000 (---------------)  + I otama
	0x00355688, // n0x0c92 c0x0000 (---------------)  + I samegawa
	0x0026e047, // n0x0c93 c0x0000 (---------------)  + I shimogo
	0x00287309, // n0x0c94 c0x0000 (---------------)  + I shirakawa
	0x002b3885, // n0x0c95 c0x0000 (---------------)  + I showa
	0x0038e104, // n0x0c96 c0x0000 (---------------)  + I soma
	0x0028c348, // n0x0c97 c0x0000 (---------------)  + I sukagawa
	0x0025fa47, // n0x0c98 c0x0000 (---------------)  + I taishin
	0x0028db88, // n0x0c99 c0x0000 (---------------)  + I tamakawa
	0x003109c8, // n0x0c9a c0x0000 (---------------)  + I tanagura
	0x0034d1c5, // n0x0c9b c0x0000 (---------------)  + I tenei
	0x00389946, // n0x0c9c c0x0000 (---------------)  + I yabuki
	0x0022afc6, // n0x0c9d c0x0000 (---------------)  + I yamato
	0x00346949, // n0x0c9e c0x0000 (---------------)  + I yamatsuri
	0x002fdc47, // n0x0c9f c0x0000 (---------------)  + I yanaizu
	0x00297546, // n0x0ca0 c0x0000 (---------------)  + I yugawa
	0x00383347, // n0x0ca1 c0x0000 (---------------)  + I anpachi
	0x00244403, // n0x0ca2 c0x0000 (---------------)  + I ena
	0x00289804, // n0x0ca3 c0x0000 (---------------)  + I gifu
	0x003746c5, // n0x0ca4 c0x0000 (---------------)  + I ginan
	0x0024efc4, // n0x0ca5 c0x0000 (---------------)  + I godo
	0x00232644, // n0x0ca6 c0x0000 (---------------)  + I gujo
	0x0023ca07, // n0x0ca7 c0x0000 (---------------)  + I hashima
	0x002e5907, // n0x0ca8 c0x0000 (---------------)  + I hichiso
	0x002685c4, // n0x0ca9 c0x0000 (---------------)  + I hida
	0x00287150, // n0x0caa c0x0000 (---------------)  + I higashishirakawa
	0x002f4ec7, // n0x0cab c0x0000 (---------------)  + I ibigawa
	0x00390e45, // n0x0cac c0x0000 (---------------)  + I ikeda
	0x00271acc, // n0x0cad c0x0000 (---------------)  + I kakamigahara
	0x00203cc4, // n0x0cae c0x0000 (---------------)  + I kani
	0x0028f7c8, // n0x0caf c0x0000 (---------------)  + I kasahara
	0x0023b7c9, // n0x0cb0 c0x0000 (---------------)  + I kasamatsu
	0x00298ac6, // n0x0cb1 c0x0000 (---------------)  + I kawaue
	0x0022aa08, // n0x0cb2 c0x0000 (---------------)  + I kitagata
	0x0022ec04, // n0x0cb3 c0x0000 (---------------)  + I mino
	0x002fb148, // n0x0cb4 c0x0000 (---------------)  + I minokamo
	0x002adf86, // n0x0cb5 c0x0000 (---------------)  + I mitake
	0x00252288, // n0x0cb6 c0x0000 (---------------)  + I mizunami
	0x00289146, // n0x0cb7 c0x0000 (---------------)  + I motosu
	0x0021d20b, // n0x0cb8 c0x0000 (---------------)  + I nakatsugawa
	0x00394b85, // n0x0cb9 c0x0000 (---------------)  + I ogaki
	0x002b5248, // n0x0cba c0x0000 (---------------)  + I sakahogi
	0x0020d984, // n0x0cbb c0x0000 (---------------)  + I seki
	0x0038f90a, // n0x0cbc c0x0000 (---------------)  + I sekigahara
	0x00287309, // n0x0cbd c0x0000 (---------------)  + I shirakawa
	0x0024f946, // n0x0cbe c0x0000 (---------------)  + I tajimi
	0x0020f408, // n0x0cbf c0x0000 (---------------)  + I takayama
	0x002b9085, // n0x0cc0 c0x0000 (---------------)  + I tarui
	0x002add84, // n0x0cc1 c0x0000 (---------------)  + I toki
	0x0028f6c6, // n0x0cc2 c0x0000 (---------------)  + I tomika
	0x002e55c8, // n0x0cc3 c0x0000 (---------------)  + I wanouchi
	0x0026dc08, // n0x0cc4 c0x0000 (---------------)  + I yamagata
	0x00330546, // n0x0cc5 c0x0000 (---------------)  + I yaotsu
	0x00396e84, // n0x0cc6 c0x0000 (---------------)  + I yoro
	0x00216306, // n0x0cc7 c0x0000 (---------------)  + I annaka
	0x002e3947, // n0x0cc8 c0x0000 (---------------)  + I chiyoda
	0x00266507, // n0x0cc9 c0x0000 (---------------)  + I fujioka
	0x002545cf, // n0x0cca c0x0000 (---------------)  + I higashiagatsuma
	0x0037a987, // n0x0ccb c0x0000 (---------------)  + I isesaki
	0x0025ad07, // n0x0ccc c0x0000 (---------------)  + I itakura
	0x002d17c5, // n0x0ccd c0x0000 (---------------)  + I kanna
	0x002cc145, // n0x0cce c0x0000 (---------------)  + I kanra
	0x0028b8c9, // n0x0ccf c0x0000 (---------------)  + I katashina
	0x00343106, // n0x0cd0 c0x0000 (---------------)  + I kawaba
	0x00258d45, // n0x0cd1 c0x0000 (---------------)  + I kiryu
	0x0026f047, // n0x0cd2 c0x0000 (---------------)  + I kusatsu
	0x002cb088, // n0x0cd3 c0x0000 (---------------)  + I maebashi
	0x002cae05, // n0x0cd4 c0x0000 (---------------)  + I meiwa
	0x002846c6, // n0x0cd5 c0x0000 (---------------)  + I midori
	0x00204808, // n0x0cd6 c0x0000 (---------------)  + I minakami
	0x0034e4ca, // n0x0cd7 c0x0000 (---------------)  + I naganohara
	0x00364808, // n0x0cd8 c0x0000 (---------------)  + I nakanojo
	0x00278107, // n0x0cd9 c0x0000 (---------------)  + I nanmoku
	0x003161c6, // n0x0cda c0x0000 (---------------)  + I numata
	0x002549c6, // n0x0cdb c0x0000 (---------------)  + I oizumi
	0x0020ca43, // n0x0cdc c0x0000 (---------------)  + I ora
	0x00203943, // n0x0cdd c0x0000 (---------------)  + I ota
	0x0034a649, // n0x0cde c0x0000 (---------------)  + I shibukawa
	0x00273789, // n0x0cdf c0x0000 (---------------)  + I shimonita
	0x0028e1c6, // n0x0ce0 c0x0000 (---------------)  + I shinto
	0x002b3885, // n0x0ce1 c0x0000 (---------------)  + I showa
	0x00298d88, // n0x0ce2 c0x0000 (---------------)  + I takasaki
	0x0020f408, // n0x0ce3 c0x0000 (---------------)  + I takayama
	0x003936c8, // n0x0ce4 c0x0000 (---------------)  + I tamamura
	0x00329c8b, // n0x0ce5 c0x0000 (---------------)  + I tatebayashi
	0x00292547, // n0x0ce6 c0x0000 (---------------)  + I tomioka
	0x0030b489, // n0x0ce7 c0x0000 (---------------)  + I tsukiyono
	0x00254848, // n0x0ce8 c0x0000 (---------------)  + I tsumagoi
	0x0038dac4, // n0x0ce9 c0x0000 (---------------)  + I ueno
	0x002b5d48, // n0x0cea c0x0000 (---------------)  + I yoshioka
	0x0027a909, // n0x0ceb c0x0000 (---------------)  + I asaminami
	0x002557c5, // n0x0cec c0x0000 (---------------)  + I daiwa
	0x0020dd07, // n0x0ced c0x0000 (---------------)  + I etajima
	0x002ab685, // n0x0cee c0x0000 (---------------)  + I fuchu
	0x0026db08, // n0x0cef c0x0000 (---------------)  + I fukuyama
	0x0027dd8b, // n0x0cf0 c0x0000 (---------------)  + I hatsukaichi
	0x00280dd0, // n0x0cf1 c0x0000 (---------------)  + I higashihiroshima
	0x00292c45, // n0x0cf2 c0x0000 (---------------)  + I hongo
	0x0020d8cc, // n0x0cf3 c0x0000 (---------------)  + I jinsekikogen
	0x0021f245, // n0x0cf4 c0x0000 (---------------)  + I kaita
	0x0026b843, // n0x0cf5 c0x0000 (---------------)  + I kui
	0x00285906, // n0x0cf6 c0x0000 (---------------)  + I kumano
	0x002a4544, // n0x0cf7 c0x0000 (---------------)  + I kure
	0x003637c6, // n0x0cf8 c0x0000 (---------------)  + I mihara
	0x00288107, // n0x0cf9 c0x0000 (---------------)  + I miyoshi
	0x00204884, // n0x0cfa c0x0000 (---------------)  + I naka
	0x002a5708, // n0x0cfb c0x0000 (---------------)  + I onomichi
	0x00305acd, // n0x0cfc c0x0000 (---------------)  + I osakikamijima
	0x00335c85, // n0x0cfd c0x0000 (---------------)  + I otake
	0x00201a04, // n0x0cfe c0x0000 (---------------)  + I saka
	0x0021b584, // n0x0cff c0x0000 (---------------)  + I sera
	0x00325cc9, // n0x0d00 c0x0000 (---------------)  + I seranishi
	0x0027f9c8, // n0x0d01 c0x0000 (---------------)  + I shinichi
	0x002f5a47, // n0x0d02 c0x0000 (---------------)  + I shobara
	0x002ae008, // n0x0d03 c0x0000 (---------------)  + I takehara
	0x0026e388, // n0x0d04 c0x0000 (---------------)  + I abashiri
	0x00268705, // n0x0d05 c0x0000 (---------------)  + I abira
	0x0031acc7, // n0x0d06 c0x0000 (---------------)  + I aibetsu
	0x00268687, // n0x0d07 c0x0000 (---------------)  + I akabira
	0x00300f87, // n0x0d08 c0x0000 (---------------)  + I akkeshi
	0x002ad5c9, // n0x0d09 c0x0000 (---------------)  + I asahikawa
	0x00227609, // n0x0d0a c0x0000 (---------------)  + I ashibetsu
	0x00230d06, // n0x0d0b c0x0000 (---------------)  + I ashoro
	0x00318dc6, // n0x0d0c c0x0000 (---------------)  + I assabu
	0x00254806, // n0x0d0d c0x0000 (---------------)  + I atsuma
	0x00323c05, // n0x0d0e c0x0000 (---------------)  + I bibai
	0x002626c4, // n0x0d0f c0x0000 (---------------)  + I biei
	0x0038aec6, // n0x0d10 c0x0000 (---------------)  + I bifuka
	0x0038f286, // n0x0d11 c0x0000 (---------------)  + I bihoro
	0x00268748, // n0x0d12 c0x0000 (---------------)  + I biratori
	0x002e170b, // n0x0d13 c0x0000 (---------------)  + I chippubetsu
	0x00366547, // n0x0d14 c0x0000 (---------------)  + I chitose
	0x00209004, // n0x0d15 c0x0000 (---------------)  + I date
	0x0032d2c6, // n0x0d16 c0x0000 (---------------)  + I ebetsu
	0x00337807, // n0x0d17 c0x0000 (---------------)  + I embetsu
	0x00271f45, // n0x0d18 c0x0000 (---------------)  + I eniwa
	0x002f35c5, // n0x0d19 c0x0000 (---------------)  + I erimo
	0x00202244, // n0x0d1a c0x0000 (---------------)  + I esan
	0x00227586, // n0x0d1b c0x0000 (---------------)  + I esashi
	0x0038af48, // n0x0d1c c0x0000 (---------------)  + I fukagawa
	0x0026d5c9, // n0x0d1d c0x0000 (---------------)  + I fukushima
	0x00239f06, // n0x0d1e c0x0000 (---------------)  + I furano
	0x00273e08, // n0x0d1f c0x0000 (---------------)  + I furubira
	0x002e3146, // n0x0d20 c0x0000 (---------------)  + I haboro
	0x00325388, // n0x0d21 c0x0000 (---------------)  + I hakodate
	0x002a154c, // n0x0d22 c0x0000 (---------------)  + I hamatonbetsu
	0x002685c6, // n0x0d23 c0x0000 (---------------)  + I hidaka
	0x0028208d, // n0x0d24 c0x0000 (---------------)  + I higashikagura
	0x0028250b, // n0x0d25 c0x0000 (---------------)  + I higashikawa
	0x0023a0c5, // n0x0d26 c0x0000 (---------------)  + I hiroo
	0x00206b87, // n0x0d27 c0x0000 (---------------)  + I hokuryu
	0x00226906, // n0x0d28 c0x0000 (---------------)  + I hokuto
	0x00305188, // n0x0d29 c0x0000 (---------------)  + I honbetsu
	0x00230d89, // n0x0d2a c0x0000 (---------------)  + I horokanai
	0x00346588, // n0x0d2b c0x0000 (---------------)  + I horonobe
	0x00390e45, // n0x0d2c c0x0000 (---------------)  + I ikeda
	0x0020de07, // n0x0d2d c0x0000 (---------------)  + I imakane
	0x002af448, // n0x0d2e c0x0000 (---------------)  + I ishikari
	0x0023e509, // n0x0d2f c0x0000 (---------------)  + I iwamizawa
	0x002e74c6, // n0x0d30 c0x0000 (---------------)  + I iwanai
	0x00239e0a, // n0x0d31 c0x0000 (---------------)  + I kamifurano
	0x00304f08, // n0x0d32 c0x0000 (---------------)  + I kamikawa
	0x003463cb, // n0x0d33 c0x0000 (---------------)  + I kamishihoro
	0x002ae7cc, // n0x0d34 c0x0000 (---------------)  + I kamisunagawa
	0x002fb248, // n0x0d35 c0x0000 (---------------)  + I kamoenai
	0x00269e06, // n0x0d36 c0x0000 (---------------)  + I kayabe
	0x002a5a88, // n0x0d37 c0x0000 (---------------)  + I kembuchi
	0x0035e007, // n0x0d38 c0x0000 (---------------)  + I kikonai
	0x002e5389, // n0x0d39 c0x0000 (---------------)  + I kimobetsu
	0x0027c54d, // n0x0d3a c0x0000 (---------------)  + I kitahiroshima
	0x002885c6, // n0x0d3b c0x0000 (---------------)  + I kitami
	0x002534c8, // n0x0d3c c0x0000 (---------------)  + I kiyosato
	0x002fe389, // n0x0d3d c0x0000 (---------------)  + I koshimizu
	0x002a3148, // n0x0d3e c0x0000 (---------------)  + I kunneppu
	0x00270048, // n0x0d3f c0x0000 (---------------)  + I kuriyama
	0x002a7e8c, // n0x0d40 c0x0000 (---------------)  + I kuromatsunai
	0x002a9347, // n0x0d41 c0x0000 (---------------)  + I kushiro
	0x002a9e47, // n0x0d42 c0x0000 (---------------)  + I kutchan
	0x002ad405, // n0x0d43 c0x0000 (---------------)  + I kyowa
	0x00260307, // n0x0d44 c0x0000 (---------------)  + I mashike
	0x002caf48, // n0x0d45 c0x0000 (---------------)  + I matsumae
	0x0028f746, // n0x0d46 c0x0000 (---------------)  + I mikasa
	0x003561cc, // n0x0d47 c0x0000 (---------------)  + I minamifurano
	0x002ccb48, // n0x0d48 c0x0000 (---------------)  + I mombetsu
	0x002b7108, // n0x0d49 c0x0000 (---------------)  + I moseushi
	0x0024e806, // n0x0d4a c0x0000 (---------------)  + I mukawa
	0x002a6187, // n0x0d4b c0x0000 (---------------)  + I muroran
	0x00230f04, // n0x0d4c c0x0000 (---------------)  + I naie
	0x002934c8, // n0x0d4d c0x0000 (---------------)  + I nakagawa
	0x0026208c, // n0x0d4e c0x0000 (---------------)  + I nakasatsunai
	0x0027848c, // n0x0d4f c0x0000 (---------------)  + I nakatombetsu
	0x0021b8c5, // n0x0d50 c0x0000 (---------------)  + I nanae
	0x0037c587, // n0x0d51 c0x0000 (---------------)  + I nanporo
	0x00396e06, // n0x0d52 c0x0000 (---------------)  + I nayoro
	0x002a6106, // n0x0d53 c0x0000 (---------------)  + I nemuro
	0x00281a48, // n0x0d54 c0x0000 (---------------)  + I niikappu
	0x0037ae44, // n0x0d55 c0x0000 (---------------)  + I niki
	0x002209cb, // n0x0d56 c0x0000 (---------------)  + I nishiokoppe
	0x002f090b, // n0x0d57 c0x0000 (---------------)  + I noboribetsu
	0x003161c6, // n0x0d58 c0x0000 (---------------)  + I numata
	0x00305947, // n0x0d59 c0x0000 (---------------)  + I obihiro
	0x00311445, // n0x0d5a c0x0000 (---------------)  + I obira
	0x0025d045, // n0x0d5b c0x0000 (---------------)  + I oketo
	0x00220b06, // n0x0d5c c0x0000 (---------------)  + I okoppe
	0x002b9045, // n0x0d5d c0x0000 (---------------)  + I otaru
	0x002acb85, // n0x0d5e c0x0000 (---------------)  + I otobe
	0x002c4a07, // n0x0d5f c0x0000 (---------------)  + I otofuke
	0x0025cbc9, // n0x0d60 c0x0000 (---------------)  + I otoineppu
	0x002f3c44, // n0x0d61 c0x0000 (---------------)  + I oumu
	0x0035f085, // n0x0d62 c0x0000 (---------------)  + I ozora
	0x002c2c45, // n0x0d63 c0x0000 (---------------)  + I pippu
	0x0028eb48, // n0x0d64 c0x0000 (---------------)  + I rankoshi
	0x002a5545, // n0x0d65 c0x0000 (---------------)  + I rebun
	0x002b4809, // n0x0d66 c0x0000 (---------------)  + I rikubetsu
	0x00294c47, // n0x0d67 c0x0000 (---------------)  + I rishiri
	0x00294c4b, // n0x0d68 c0x0000 (---------------)  + I rishirifuji
	0x00307c86, // n0x0d69 c0x0000 (---------------)  + I saroma
	0x0021ecc9, // n0x0d6a c0x0000 (---------------)  + I sarufutsu
	0x0024c908, // n0x0d6b c0x0000 (---------------)  + I shakotan
	0x00252d45, // n0x0d6c c0x0000 (---------------)  + I shari
	0x00301088, // n0x0d6d c0x0000 (---------------)  + I shibecha
	0x00227648, // n0x0d6e c0x0000 (---------------)  + I shibetsu
	0x00251507, // n0x0d6f c0x0000 (---------------)  + I shikabe
	0x002d3e87, // n0x0d70 c0x0000 (---------------)  + I shikaoi
	0x0023ca89, // n0x0d71 c0x0000 (---------------)  + I shimamaki
	0x002521c7, // n0x0d72 c0x0000 (---------------)  + I shimizu
	0x00266909, // n0x0d73 c0x0000 (---------------)  + I shimokawa
	0x00287a0c, // n0x0d74 c0x0000 (---------------)  + I shinshinotsu
	0x0028e1c8, // n0x0d75 c0x0000 (---------------)  + I shintoku
	0x002d1609, // n0x0d76 c0x0000 (---------------)  + I shiranuka
	0x002d2247, // n0x0d77 c0x0000 (---------------)  + I shiraoi
	0x0026e449, // n0x0d78 c0x0000 (---------------)  + I shiriuchi
	0x002e5a47, // n0x0d79 c0x0000 (---------------)  + I sobetsu
	0x002ae8c8, // n0x0d7a c0x0000 (---------------)  + I sunagawa
	0x0028ee85, // n0x0d7b c0x0000 (---------------)  + I taiki
	0x0027cec6, // n0x0d7c c0x0000 (---------------)  + I takasu
	0x002a8648, // n0x0d7d c0x0000 (---------------)  + I takikawa
	0x00245108, // n0x0d7e c0x0000 (---------------)  + I takinoue
	0x002af189, // n0x0d7f c0x0000 (---------------)  + I teshikaga
	0x002acbc7, // n0x0d80 c0x0000 (---------------)  + I tobetsu
	0x0028b345, // n0x0d81 c0x0000 (---------------)  + I tohma
	0x002b9dc9, // n0x0d82 c0x0000 (---------------)  + I tomakomai
	0x0036edc6, // n0x0d83 c0x0000 (---------------)  + I tomari
	0x0027c344, // n0x0d84 c0x0000 (---------------)  + I toya
	0x00346246, // n0x0d85 c0x0000 (---------------)  + I toyako
	0x00371088, // n0x0d86 c0x0000 (---------------)  + I toyotomi
	0x00244007, // n0x0d87 c0x0000 (---------------)  + I toyoura
	0x002e1908, // n0x0d88 c0x0000 (---------------)  + I tsubetsu
	0x0023ac89, // n0x0d89 c0x0000 (---------------)  + I tsukigata
	0x0024e587, // n0x0d8a c0x0000 (---------------)  + I urakawa
	0x00288ec6, // n0x0d8b c0x0000 (---------------)  + I urausu
	0x00206c44, // n0x0d8c c0x0000 (---------------)  + I uryu
	0x00200109, // n0x0d8d c0x0000 (---------------)  + I utashinai
	0x00342f08, // n0x0d8e c0x0000 (---------------)  + I wakkanai
	0x0024e6c7, // n0x0d8f c0x0000 (---------------)  + I wassamu
	0x00311fc6, // n0x0d90 c0x0000 (---------------)  + I yakumo
	0x00292f46, // n0x0d91 c0x0000 (---------------)  + I yoichi
	0x0035e144, // n0x0d92 c0x0000 (---------------)  + I aioi
	0x00341846, // n0x0d93 c0x0000 (---------------)  + I akashi
	0x00207e03, // n0x0d94 c0x0000 (---------------)  + I ako
	0x0038bd09, // n0x0d95 c0x0000 (---------------)  + I amagasaki
	0x00394b46, // n0x0d96 c0x0000 (---------------)  + I aogaki
	0x0028c7c5, // n0x0d97 c0x0000 (---------------)  + I asago
	0x00289c86, // n0x0d98 c0x0000 (---------------)  + I ashiya
	0x0028dcc5, // n0x0d99 c0x0000 (---------------)  + I awaji
	0x0026d348, // n0x0d9a c0x0000 (---------------)  + I fukusaki
	0x002faf87, // n0x0d9b c0x0000 (---------------)  + I goshiki
	0x002f8c46, // n0x0d9c c0x0000 (---------------)  + I harima
	0x0031c986, // n0x0d9d c0x0000 (---------------)  + I himeji
	0x00312b88, // n0x0d9e c0x0000 (---------------)  + I ichikawa
	0x0028ba47, // n0x0d9f c0x0000 (---------------)  + I inagawa
	0x00288605, // n0x0da0 c0x0000 (---------------)  + I itami
	0x0028a188, // n0x0da1 c0x0000 (---------------)  + I kakogawa
	0x003744c8, // n0x0da2 c0x0000 (---------------)  + I kamigori
	0x00304f08, // n0x0da3 c0x0000 (---------------)  + I kamikawa
	0x0021f105, // n0x0da4 c0x0000 (---------------)  + I kasai
	0x0027cf46, // n0x0da5 c0x0000 (---------------)  + I kasuga
	0x0022ed09, // n0x0da6 c0x0000 (---------------)  + I kawanishi
	0x0022ae44, // n0x0da7 c0x0000 (---------------)  + I miki
	0x00359a0b, // n0x0da8 c0x0000 (---------------)  + I minamiawaji
	0x0021ac8b, // n0x0da9 c0x0000 (---------------)  + I nishinomiya
	0x002998c9, // n0x0daa c0x0000 (---------------)  + I nishiwaki
	0x00207e83, // n0x0dab c0x0000 (---------------)  + I ono
	0x002453c5, // n0x0dac c0x0000 (---------------)  + I sanda
	0x00208a46, // n0x0dad c0x0000 (---------------)  + I sannan
	0x002937c8, // n0x0dae c0x0000 (---------------)  + I sasayama
	0x002349c4, // n0x0daf c0x0000 (---------------)  + I sayo
	0x002e6a46, // n0x0db0 c0x0000 (---------------)  + I shingu
	0x002ba609, // n0x0db1 c0x0000 (---------------)  + I shinonsen
	0x003081c5, // n0x0db2 c0x0000 (---------------)  + I shiso
	0x002c4946, // n0x0db3 c0x0000 (---------------)  + I sumoto
	0x0025fa46, // n0x0db4 c0x0000 (---------------)  + I taishi
	0x00209604, // n0x0db5 c0x0000 (---------------)  + I taka
	0x002875ca, // n0x0db6 c0x0000 (---------------)  + I takarazuka
	0x0028c708, // n0x0db7 c0x0000 (---------------)  + I takasago
	0x00245106, // n0x0db8 c0x0000 (---------------)  + I takino
	0x0035ee85, // n0x0db9 c0x0000 (---------------)  + I tamba
	0x00203987, // n0x0dba c0x0000 (---------------)  + I tatsuno
	0x0022e707, // n0x0dbb c0x0000 (---------------)  + I toyooka
	0x00389944, // n0x0dbc c0x0000 (---------------)  + I yabu
	0x0021aec7, // n0x0dbd c0x0000 (---------------)  + I yashiro
	0x002a0604, // n0x0dbe c0x0000 (---------------)  + I yoka
	0x00322c46, // n0x0dbf c0x0000 (---------------)  + I yokawa
	0x00204943, // n0x0dc0 c0x0000 (---------------)  + I ami
	0x002ad5c5, // n0x0dc1 c0x0000 (---------------)  + I asahi
	0x00346e05, // n0x0dc2 c0x0000 (---------------)  + I bando
	0x002e5708, // n0x0dc3 c0x0000 (---------------)  + I chikusei
	0x0024ef05, // n0x0dc4 c0x0000 (---------------)  + I daigo
	0x00268309, // n0x0dc5 c0x0000 (---------------)  + I fujishiro
	0x0028d547, // n0x0dc6 c0x0000 (---------------)  + I hitachi
	0x0029330b, // n0x0dc7 c0x0000 (---------------)  + I hitachinaka
	0x0028d54c, // n0x0dc8 c0x0000 (---------------)  + I hitachiomiya
	0x0028e50a, // n0x0dc9 c0x0000 (---------------)  + I hitachiota
	0x00316ac7, // n0x0dca c0x0000 (---------------)  + I ibaraki
	0x00200243, // n0x0dcb c0x0000 (---------------)  + I ina
	0x00291508, // n0x0dcc c0x0000 (---------------)  + I inashiki
	0x0021f2c5, // n0x0dcd c0x0000 (---------------)  + I itako
	0x002cae85, // n0x0dce c0x0000 (---------------)  + I iwama
	0x00207f44, // n0x0dcf c0x0000 (---------------)  + I joso
	0x002ae7c6, // n0x0dd0 c0x0000 (---------------)  + I kamisu
	0x0023b7c6, // n0x0dd1 c0x0000 (---------------)  + I kasama
	0x00341887, // n0x0dd2 c0x0000 (---------------)  + I kashima
	0x0020b60b, // n0x0dd3 c0x0000 (---------------)  + I kasumigaura
	0x00232c84, // n0x0dd4 c0x0000 (---------------)  + I koga
	0x0033ee44, // n0x0dd5 c0x0000 (---------------)  + I miho
	0x00246f04, // n0x0dd6 c0x0000 (---------------)  + I mito
	0x002b4f86, // n0x0dd7 c0x0000 (---------------)  + I moriya
	0x00204884, // n0x0dd8 c0x0000 (---------------)  + I naka
	0x00376c08, // n0x0dd9 c0x0000 (---------------)  + I namegata
	0x00321385, // n0x0dda c0x0000 (---------------)  + I oarai
	0x00204045, // n0x0ddb c0x0000 (---------------)  + I ogawa
	0x00393607, // n0x0ddc c0x0000 (---------------)  + I omitama
	0x00206c89, // n0x0ddd c0x0000 (---------------)  + I ryugasaki
	0x003396c5, // n0x0dde c0x0000 (---------------)  + I sakai
	0x0030cc0a, // n0x0ddf c0x0000 (---------------)  + I sakuragawa
	0x0027bc89, // n0x0de0 c0x0000 (---------------)  + I shimodate
	0x0027db0a, // n0x0de1 c0x0000 (---------------)  + I shimotsuma
	0x00395689, // n0x0de2 c0x0000 (---------------)  + I shirosato
	0x00339a04, // n0x0de3 c0x0000 (---------------)  + I sowa
	0x0029fdc5, // n0x0de4 c0x0000 (---------------)  + I suifu
	0x0029cec8, // n0x0de5 c0x0000 (---------------)  + I takahagi
	0x002d0fcb, // n0x0de6 c0x0000 (---------------)  + I tamatsukuri
	0x002df1c5, // n0x0de7 c0x0000 (---------------)  + I tokai
	0x00352046, // n0x0de8 c0x0000 (---------------)  + I tomobe
	0x0021a304, // n0x0de9 c0x0000 (---------------)  + I tone
	0x00268846, // n0x0dea c0x0000 (---------------)  + I toride
	0x0024e409, // n0x0deb c0x0000 (---------------)  + I tsuchiura
	0x0032d387, // n0x0dec c0x0000 (---------------)  + I tsukuba
	0x00387c88, // n0x0ded c0x0000 (---------------)  + I uchihara
	0x002315c6, // n0x0dee c0x0000 (---------------)  + I ushiku
	0x002e38c7, // n0x0def c0x0000 (---------------)  + I yachiyo
	0x0026dc08, // n0x0df0 c0x0000 (---------------)  + I yamagata
	0x00377b86, // n0x0df1 c0x0000 (---------------)  + I yawara
	0x00260d44, // n0x0df2 c0x0000 (---------------)  + I yuki
	0x0034af87, // n0x0df3 c0x0000 (---------------)  + I anamizu
	0x00336fc5, // n0x0df4 c0x0000 (---------------)  + I hakui
	0x0034be87, // n0x0df5 c0x0000 (---------------)  + I hakusan
	0x00281f04, // n0x0df6 c0x0000 (---------------)  + I kaga
	0x00226886, // n0x0df7 c0x0000 (---------------)  + I kahoku
	0x0037ffc8, // n0x0df8 c0x0000 (---------------)  + I kanazawa
	0x002826c8, // n0x0df9 c0x0000 (---------------)  + I kawakita
	0x002be447, // n0x0dfa c0x0000 (---------------)  + I komatsu
	0x0023fcc8, // n0x0dfb c0x0000 (---------------)  + I nakanoto
	0x0027e905, // n0x0dfc c0x0000 (---------------)  + I nanao
	0x00207cc4, // n0x0dfd c0x0000 (---------------)  + I nomi
	0x00312a88, // n0x0dfe c0x0000 (---------------)  + I nonoichi
	0x0023fdc4, // n0x0dff c0x0000 (---------------)  + I noto
	0x0020f2c5, // n0x0e00 c0x0000 (---------------)  + I shika
	0x002d2b84, // n0x0e01 c0x0000 (---------------)  + I suzu
	0x0027d707, // n0x0e02 c0x0000 (---------------)  + I tsubata
	0x0031c3c7, // n0x0e03 c0x0000 (---------------)  + I tsurugi
	0x0026e588, // n0x0e04 c0x0000 (---------------)  + I uchinada
	0x0028dd06, // n0x0e05 c0x0000 (---------------)  + I wajima
	0x0024ee85, // n0x0e06 c0x0000 (---------------)  + I fudai
	0x00268108, // n0x0e07 c0x0000 (---------------)  + I fujisawa
	0x00364a08, // n0x0e08 c0x0000 (---------------)  + I hanamaki
	0x0028b089, // n0x0e09 c0x0000 (---------------)  + I hiraizumi
	0x0021af86, // n0x0e0a c0x0000 (---------------)  + I hirono
	0x0029ba88, // n0x0e0b c0x0000 (---------------)  + I ichinohe
	0x0038f78a, // n0x0e0c c0x0000 (---------------)  + I ichinoseki
	0x00271fc8, // n0x0e0d c0x0000 (---------------)  + I iwaizumi
	0x002c3b85, // n0x0e0e c0x0000 (---------------)  + I iwate
	0x0031b686, // n0x0e0f c0x0000 (---------------)  + I joboji
	0x0027bb48, // n0x0e10 c0x0000 (---------------)  + I kamaishi
	0x0020deca, // n0x0e11 c0x0000 (---------------)  + I kanegasaki
	0x0032a887, // n0x0e12 c0x0000 (---------------)  + I karumai
	0x00273345, // n0x0e13 c0x0000 (---------------)  + I kawai
	0x00209588, // n0x0e14 c0x0000 (---------------)  + I kitakami
	0x00224704, // n0x0e15 c0x0000 (---------------)  + I kuji
	0x00205d06, // n0x0e16 c0x0000 (---------------)  + I kunohe
	0x002aa5c8, // n0x0e17 c0x0000 (---------------)  + I kuzumaki
	0x00207d46, // n0x0e18 c0x0000 (---------------)  + I miyako
	0x00304788, // n0x0e19 c0x0000 (---------------)  + I mizusawa
	0x0022ac87, // n0x0e1a c0x0000 (---------------)  + I morioka
	0x00205106, // n0x0e1b c0x0000 (---------------)  + I ninohe
	0x00384f84, // n0x0e1c c0x0000 (---------------)  + I noda
	0x0029a847, // n0x0e1d c0x0000 (---------------)  + I ofunato
	0x002e13c4, // n0x0e1e c0x0000 (---------------)  + I oshu
	0x0024e3c7, // n0x0e1f c0x0000 (---------------)  + I otsuchi
	0x0023430d, // n0x0e20 c0x0000 (---------------)  + I rikuzentakata
	0x0026d185, // n0x0e21 c0x0000 (---------------)  + I shiwa
	0x002a71cb, // n0x0e22 c0x0000 (---------------)  + I shizukuishi
	0x002fe746, // n0x0e23 c0x0000 (---------------)  + I sumita
	0x0023c788, // n0x0e24 c0x0000 (---------------)  + I tanohata
	0x00369804, // n0x0e25 c0x0000 (---------------)  + I tono
	0x00264306, // n0x0e26 c0x0000 (---------------)  + I yahaba
	0x0026b046, // n0x0e27 c0x0000 (---------------)  + I yamada
	0x0036c587, // n0x0e28 c0x0000 (---------------)  + I ayagawa
	0x00281d4d, // n0x0e29 c0x0000 (---------------)  + I higashikagawa
	0x002982c7, // n0x0e2a c0x0000 (---------------)  + I kanonji
	0x002e8108, // n0x0e2b c0x0000 (---------------)  + I kotohira
	0x00257385, // n0x0e2c c0x0000 (---------------)  + I manno
	0x00283488, // n0x0e2d c0x0000 (---------------)  + I marugame
	0x002aeac6, // n0x0e2e c0x0000 (---------------)  + I mitoyo
	0x0027e988, // n0x0e2f c0x0000 (---------------)  + I naoshima
	0x0020ce46, // n0x0e30 c0x0000 (---------------)  + I sanuki
	0x0031c2c7, // n0x0e31 c0x0000 (---------------)  + I tadotsu
	0x0026e909, // n0x0e32 c0x0000 (---------------)  + I takamatsu
	0x00369807, // n0x0e33 c0x0000 (---------------)  + I tonosho
	0x002761c8, // n0x0e34 c0x0000 (---------------)  + I uchinomi
	0x00261345, // n0x0e35 c0x0000 (---------------)  + I utazu
	0x00212c08, // n0x0e36 c0x0000 (---------------)  + I zentsuji
	0x00305dc5, // n0x0e37 c0x0000 (---------------)  + I akune
	0x00236bc5, // n0x0e38 c0x0000 (---------------)  + I amami
	0x0030fcc5, // n0x0e39 c0x0000 (---------------)  + I hioki
	0x00209883, // n0x0e3a c0x0000 (---------------)  + I isa
	0x0026f3c4, // n0x0e3b c0x0000 (---------------)  + I isen
	0x00209785, // n0x0e3c c0x0000 (---------------)  + I izumi
	0x00271789, // n0x0e3d c0x0000 (---------------)  + I kagoshima
	0x002b4d06, // n0x0e3e c0x0000 (---------------)  + I kanoya
	0x002c5c48, // n0x0e3f c0x0000 (---------------)  + I kawanabe
	0x002d3c45, // n0x0e40 c0x0000 (---------------)  + I kinko
	0x00314307, // n0x0e41 c0x0000 (---------------)  + I kouyama
	0x002d3a4a, // n0x0e42 c0x0000 (---------------)  + I makurazaki
	0x002c4889, // n0x0e43 c0x0000 (---------------)  + I matsumoto
	0x002bf68a, // n0x0e44 c0x0000 (---------------)  + I minamitane
	0x002bb148, // n0x0e45 c0x0000 (---------------)  + I nakatane
	0x0021df8c, // n0x0e46 c0x0000 (---------------)  + I nishinoomote
	0x0026f0cd, // n0x0e47 c0x0000 (---------------)  + I satsumasendai
	0x002da843, // n0x0e48 c0x0000 (---------------)  + I soo
	0x00304688, // n0x0e49 c0x0000 (---------------)  + I tarumizu
	0x00211dc5, // n0x0e4a c0x0000 (---------------)  + I yusui
	0x00343086, // n0x0e4b c0x0000 (---------------)  + I aikawa
	0x0033ea46, // n0x0e4c c0x0000 (---------------)  + I atsugi
	0x002c35c5, // n0x0e4d c0x0000 (---------------)  + I ayase
	0x00383449, // n0x0e4e c0x0000 (---------------)  + I chigasaki
	0x00240845, // n0x0e4f c0x0000 (---------------)  + I ebina
	0x00268108, // n0x0e50 c0x0000 (---------------)  + I fujisawa
	0x00265b06, // n0x0e51 c0x0000 (---------------)  + I hadano
	0x00328686, // n0x0e52 c0x0000 (---------------)  + I hakone
	0x0028c209, // n0x0e53 c0x0000 (---------------)  + I hiratsuka
	0x00377387, // n0x0e54 c0x0000 (---------------)  + I isehara
	0x00315c06, // n0x0e55 c0x0000 (---------------)  + I kaisei
	0x002d39c8, // n0x0e56 c0x0000 (---------------)  + I kamakura
	0x003823c8, // n0x0e57 c0x0000 (---------------)  + I kiyokawa
	0x0032b7c7, // n0x0e58 c0x0000 (---------------)  + I matsuda
	0x0025240e, // n0x0e59 c0x0000 (---------------)  + I minamiashigara
	0x002aed05, // n0x0e5a c0x0000 (---------------)  + I miura
	0x0023e405, // n0x0e5b c0x0000 (---------------)  + I nakai
	0x00207c48, // n0x0e5c c0x0000 (---------------)  + I ninomiya
	0x00202487, // n0x0e5d c0x0000 (---------------)  + I odawara
	0x00238bc2, // n0x0e5e c0x0000 (---------------)  + I oi
	0x002a6c04, // n0x0e5f c0x0000 (---------------)  + I oiso
	0x003636ca, // n0x0e60 c0x0000 (---------------)  + I sagamihara
	0x0024e788, // n0x0e61 c0x0000 (---------------)  + I samukawa
	0x00337906, // n0x0e62 c0x0000 (---------------)  + I tsukui
	0x00283b88, // n0x0e63 c0x0000 (---------------)  + I yamakita
	0x0022afc6, // n0x0e64 c0x0000 (---------------)  + I yamato
	0x00311d48, // n0x0e65 c0x0000 (---------------)  + I yokosuka
	0x00297548, // n0x0e66 c0x0000 (---------------)  + I yugawara
	0x00236b84, // n0x0e67 c0x0000 (---------------)  + I zama
	0x003185c5, // n0x0e68 c0x0000 (---------------)  + I zushi
	0x006735c4, // n0x0e69 c0x0001 (---------------)  ! I city
	0x006735c4, // n0x0e6a c0x0001 (---------------)  ! I city
	0x006735c4, // n0x0e6b c0x0001 (---------------)  ! I city
	0x00201ac3, // n0x0e6c c0x0000 (---------------)  + I aki
	0x002f3a86, // n0x0e6d c0x0000 (---------------)  + I geisei
	0x002685c6, // n0x0e6e c0x0000 (---------------)  + I hidaka
	0x0028888c, // n0x0e6f c0x0000 (---------------)  + I higashitsuno
	0x00201b43, // n0x0e70 c0x0000 (---------------)  + I ino
	0x002ab006, // n0x0e71 c0x0000 (---------------)  + I kagami
	0x00204904, // n0x0e72 c0x0000 (---------------)  + I kami
	0x0020e0c8, // n0x0e73 c0x0000 (---------------)  + I kitagawa
	0x002ba445, // n0x0e74 c0x0000 (---------------)  + I kochi
	0x003637c6, // n0x0e75 c0x0000 (---------------)  + I mihara
	0x002a2e48, // n0x0e76 c0x0000 (---------------)  + I motoyama
	0x002bc286, // n0x0e77 c0x0000 (---------------)  + I muroto
	0x002f8bc6, // n0x0e78 c0x0000 (---------------)  + I nahari
	0x00248448, // n0x0e79 c0x0000 (---------------)  + I nakamura
	0x00374747, // n0x0e7a c0x0000 (---------------)  + I nankoku
	0x00251f89, // n0x0e7b c0x0000 (---------------)  + I nishitosa
	0x00328d8a, // n0x0e7c c0x0000 (---------------)  + I niyodogawa
	0x00240384, // n0x0e7d c0x0000 (---------------)  + I ochi
	0x0022ecc5, // n0x0e7e c0x0000 (---------------)  + I okawa
	0x00286c45, // n0x0e7f c0x0000 (---------------)  + I otoyo
	0x0022a786, // n0x0e80 c0x0000 (---------------)  + I otsuki
	0x00240646, // n0x0e81 c0x0000 (---------------)  + I sakawa
	0x00291906, // n0x0e82 c0x0000 (---------------)  + I sukumo
	0x002d1e06, // n0x0e83 c0x0000 (---------------)  + I susaki
	0x002520c4, // n0x0e84 c0x0000 (---------------)  + I tosa
	0x002520cb, // n0x0e85 c0x0000 (---------------)  + I tosashimizu
	0x00221244, // n0x0e86 c0x0000 (---------------)  + I toyo
	0x00203a05, // n0x0e87 c0x0000 (---------------)  + I tsuno
	0x00296285, // n0x0e88 c0x0000 (---------------)  + I umaji
	0x00207006, // n0x0e89 c0x0000 (---------------)  + I yasuda
	0x00209f08, // n0x0e8a c0x0000 (---------------)  + I yusuhara
	0x0026ef87, // n0x0e8b c0x0000 (---------------)  + I amakusa
	0x0034e684, // n0x0e8c c0x0000 (---------------)  + I arao
	0x00209dc3, // n0x0e8d c0x0000 (---------------)  + I aso
	0x002e3545, // n0x0e8e c0x0000 (---------------)  + I choyo
	0x00351f07, // n0x0e8f c0x0000 (---------------)  + I gyokuto
	0x0028f9c9, // n0x0e90 c0x0000 (---------------)  + I hitoyoshi
	0x0026ee8b, // n0x0e91 c0x0000 (---------------)  + I kamiamakusa
	0x00341887, // n0x0e92 c0x0000 (---------------)  + I kashima
	0x0036c287, // n0x0e93 c0x0000 (---------------)  + I kikuchi
	0x002d4744, // n0x0e94 c0x0000 (---------------)  + I kosa
	0x002a2d48, // n0x0e95 c0x0000 (---------------)  + I kumamoto
	0x00253387, // n0x0e96 c0x0000 (---------------)  + I mashiki
	0x0028fc06, // n0x0e97 c0x0000 (---------------)  + I mifune
	0x00260ac8, // n0x0e98 c0x0000 (---------------)  + I minamata
	0x0029ee4b, // n0x0e99 c0x0000 (---------------)  + I minamioguni
	0x0034cac6, // n0x0e9a c0x0000 (---------------)  + I nagasu
	0x0020e649, // n0x0e9b c0x0000 (---------------)  + I nishihara
	0x0029efc5, // n0x0e9c c0x0000 (---------------)  + I oguni
	0x002e3dc3, // n0x0e9d c0x0000 (---------------)  + I ozu
	0x002c4946, // n0x0e9e c0x0000 (---------------)  + I sumoto
	0x0022ab88, // n0x0e9f c0x0000 (---------------)  + I takamori
	0x0020cf03, // n0x0ea0 c0x0000 (---------------)  + I uki
	0x002269c3, // n0x0ea1 c0x0000 (---------------)  + I uto
	0x0026dc06, // n0x0ea2 c0x0000 (---------------)  + I yamaga
	0x0022afc6, // n0x0ea3 c0x0000 (---------------)  + I yamato
	0x00373e8a, // n0x0ea4 c0x0000 (---------------)  + I yatsushiro
	0x00269e45, // n0x0ea5 c0x0000 (---------------)  + I ayabe
	0x0026ae8b, // n0x0ea6 c0x0000 (---------------)  + I fukuchiyama
	0x00289bcb, // n0x0ea7 c0x0000 (---------------)  + I higashiyama
	0x00229783, // n0x0ea8 c0x0000 (---------------)  + I ide
	0x00213cc3, // n0x0ea9 c0x0000 (---------------)  + I ine
	0x00298c44, // n0x0eaa c0x0000 (---------------)  + I joyo
	0x0023a807, // n0x0eab c0x0000 (---------------)  + I kameoka
	0x0022ac04, // n0x0eac c0x0000 (---------------)  + I kamo
	0x00206e44, // n0x0ead c0x0000 (---------------)  + I kita
	0x002f1c04, // n0x0eae c0x0000 (---------------)  + I kizu
	0x002722c8, // n0x0eaf c0x0000 (---------------)  + I kumiyama
	0x0035edc8, // n0x0eb0 c0x0000 (---------------)  + I kyotamba
	0x0030f889, // n0x0eb1 c0x0000 (---------------)  + I kyotanabe
	0x003165c8, // n0x0eb2 c0x0000 (---------------)  + I kyotango
	0x0030c047, // n0x0eb3 c0x0000 (---------------)  + I maizuru
	0x00213fc6, // n0x0eb4 c0x0000 (---------------)  + I minami
	0x002c588f, // n0x0eb5 c0x0000 (---------------)  + I minamiyamashiro
	0x002aee46, // n0x0eb6 c0x0000 (---------------)  + I miyazu
	0x002ba3c4, // n0x0eb7 c0x0000 (---------------)  + I muko
	0x0035ec0a, // n0x0eb8 c0x0000 (---------------)  + I nagaokakyo
	0x00351e07, // n0x0eb9 c0x0000 (---------------)  + I nakagyo
	0x00204d46, // n0x0eba c0x0000 (---------------)  + I nantan
	0x0027c389, // n0x0ebb c0x0000 (---------------)  + I oyamazaki
	0x0030f805, // n0x0ebc c0x0000 (---------------)  + I sakyo
	0x002c6f45, // n0x0ebd c0x0000 (---------------)  + I seika
	0x0030f946, // n0x0ebe c0x0000 (---------------)  + I tanabe
	0x00212d43, // n0x0ebf c0x0000 (---------------)  + I uji
	0x00224749, // n0x0ec0 c0x0000 (---------------)  + I ujitawara
	0x00214fc6, // n0x0ec1 c0x0000 (---------------)  + I wazuka
	0x0023aa49, // n0x0ec2 c0x0000 (---------------)  + I yamashina
	0x003804c6, // n0x0ec3 c0x0000 (---------------)  + I yawata
	0x002ad5c5, // n0x0ec4 c0x0000 (---------------)  + I asahi
	0x0035dd05, // n0x0ec5 c0x0000 (---------------)  + I inabe
	0x00233203, // n0x0ec6 c0x0000 (---------------)  + I ise
	0x0023a948, // n0x0ec7 c0x0000 (---------------)  + I kameyama
	0x002406c7, // n0x0ec8 c0x0000 (---------------)  + I kawagoe
	0x0037aec4, // n0x0ec9 c0x0000 (---------------)  + I kiho
	0x0022a888, // n0x0eca c0x0000 (---------------)  + I kisosaki
	0x002927c4, // n0x0ecb c0x0000 (---------------)  + I kiwa
	0x002d4306, // n0x0ecc c0x0000 (---------------)  + I komono
	0x00285906, // n0x0ecd c0x0000 (---------------)  + I kumano
	0x0022f386, // n0x0ece c0x0000 (---------------)  + I kuwana
	0x002b5109, // n0x0ecf c0x0000 (---------------)  + I matsusaka
	0x002cae05, // n0x0ed0 c0x0000 (---------------)  + I meiwa
	0x00292a46, // n0x0ed1 c0x0000 (---------------)  + I mihama
	0x00370d89, // n0x0ed2 c0x0000 (---------------)  + I minamiise
	0x002adc06, // n0x0ed3 c0x0000 (---------------)  + I misugi
	0x00272346, // n0x0ed4 c0x0000 (---------------)  + I miyama
	0x0036fe46, // n0x0ed5 c0x0000 (---------------)  + I nabari
	0x0021f645, // n0x0ed6 c0x0000 (---------------)  + I shima
	0x002d2b86, // n0x0ed7 c0x0000 (---------------)  + I suzuka
	0x0031c2c4, // n0x0ed8 c0x0000 (---------------)  + I tado
	0x0028ee85, // n0x0ed9 c0x0000 (---------------)  + I taiki
	0x00245104, // n0x0eda c0x0000 (---------------)  + I taki
	0x002f1b06, // n0x0edb c0x0000 (---------------)  + I tamaki
	0x00395844, // n0x0edc c0x0000 (---------------)  + I toba
	0x00203a03, // n0x0edd c0x0000 (---------------)  + I tsu
	0x00274845, // n0x0ede c0x0000 (---------------)  + I udono
	0x00227348, // n0x0edf c0x0000 (---------------)  + I ureshino
	0x00253ec7, // n0x0ee0 c0x0000 (---------------)  + I watarai
	0x00234a49, // n0x0ee1 c0x0000 (---------------)  + I yokkaichi
	0x00274a88, // n0x0ee2 c0x0000 (---------------)  + I furukawa
	0x002830d1, // n0x0ee3 c0x0000 (---------------)  + I higashimatsushima
	0x0025faca, // n0x0ee4 c0x0000 (---------------)  + I ishinomaki
	0x00316107, // n0x0ee5 c0x0000 (---------------)  + I iwanuma
	0x0038d846, // n0x0ee6 c0x0000 (---------------)  + I kakuda
	0x00204904, // n0x0ee7 c0x0000 (---------------)  + I kami
	0x002a8748, // n0x0ee8 c0x0000 (---------------)  + I kawasaki
	0x0034cc49, // n0x0ee9 c0x0000 (---------------)  + I kesennuma
	0x0028b408, // n0x0eea c0x0000 (---------------)  + I marumori
	0x0028328a, // n0x0eeb c0x0000 (---------------)  + I matsushima
	0x002b45cd, // n0x0eec c0x0000 (---------------)  + I minamisanriku
	0x0028b246, // n0x0eed c0x0000 (---------------)  + I misato
	0x00248546, // n0x0eee c0x0000 (---------------)  + I murata
	0x0029a906, // n0x0eef c0x0000 (---------------)  + I natori
	0x00204047, // n0x0ef0 c0x0000 (---------------)  + I ogawara
	0x002e81c5, // n0x0ef1 c0x0000 (---------------)  + I ohira
	0x00295c07, // n0x0ef2 c0x0000 (---------------)  + I onagawa
	0x0022a945, // n0x0ef3 c0x0000 (---------------)  + I osaki
	0x00294d84, // n0x0ef4 c0x0000 (---------------)  + I rifu
	0x0027c146, // n0x0ef5 c0x0000 (---------------)  + I semine
	0x003416c7, // n0x0ef6 c0x0000 (---------------)  + I shibata
	0x0022444d, // n0x0ef7 c0x0000 (---------------)  + I shichikashuku
	0x0027ba87, // n0x0ef8 c0x0000 (---------------)  + I shikama
	0x002471c8, // n0x0ef9 c0x0000 (---------------)  + I shiogama
	0x00268409, // n0x0efa c0x0000 (---------------)  + I shiroishi
	0x0031b586, // n0x0efb c0x0000 (---------------)  + I tagajo
	0x002e7445, // n0x0efc c0x0000 (---------------)  + I taiwa
	0x0020fe04, // n0x0efd c0x0000 (---------------)  + I tome
	0x00371186, // n0x0efe c0x0000 (---------------)  + I tomiya
	0x00389846, // n0x0eff c0x0000 (---------------)  + I wakuya
	0x0024e906, // n0x0f00 c0x0000 (---------------)  + I watari
	0x00286688, // n0x0f01 c0x0000 (---------------)  + I yamamoto
	0x00395443, // n0x0f02 c0x0000 (---------------)  + I zao
	0x00206fc3, // n0x0f03 c0x0000 (---------------)  + I aya
	0x0036cf45, // n0x0f04 c0x0000 (---------------)  + I ebino
	0x00375946, // n0x0f05 c0x0000 (---------------)  + I gokase
	0x00297505, // n0x0f06 c0x0000 (---------------)  + I hyuga
	0x002317c8, // n0x0f07 c0x0000 (---------------)  + I kadogawa
	0x002882ca, // n0x0f08 c0x0000 (---------------)  + I kawaminami
	0x00389a44, // n0x0f09 c0x0000 (---------------)  + I kijo
	0x0020e0c8, // n0x0f0a c0x0000 (---------------)  + I kitagawa
	0x002815c8, // n0x0f0b c0x0000 (---------------)  + I kitakata
	0x00206e47, // n0x0f0c c0x0000 (---------------)  + I kitaura
	0x002d3d09, // n0x0f0d c0x0000 (---------------)  + I kobayashi
	0x002a2a48, // n0x0f0e c0x0000 (---------------)  + I kunitomi
	0x0026d647, // n0x0f0f c0x0000 (---------------)  + I kushima
	0x0027cdc6, // n0x0f10 c0x0000 (---------------)  + I mimata
	0x00207d4a, // n0x0f11 c0x0000 (---------------)  + I miyakonojo
	0x00371208, // n0x0f12 c0x0000 (---------------)  + I miyazaki
	0x002ae609, // n0x0f13 c0x0000 (---------------)  + I morotsuka
	0x0027fa88, // n0x0f14 c0x0000 (---------------)  + I nichinan
	0x00217e09, // n0x0f15 c0x0000 (---------------)  + I nishimera
	0x00346687, // n0x0f16 c0x0000 (---------------)  + I nobeoka
	0x00302b45, // n0x0f17 c0x0000 (---------------)  + I saito
	0x00329e86, // n0x0f18 c0x0000 (---------------)  + I shiiba
	0x0028f5c8, // n0x0f19 c0x0000 (---------------)  + I shintomi
	0x0023ae48, // n0x0f1a c0x0000 (---------------)  + I takaharu
	0x002462c8, // n0x0f1b c0x0000 (---------------)  + I takanabe
	0x002f9c88, // n0x0f1c c0x0000 (---------------)  + I takazaki
	0x00203a05, // n0x0f1d c0x0000 (---------------)  + I tsuno
	0x0022e144, // n0x0f1e c0x0000 (---------------)  + I achi
	0x0034e008, // n0x0f1f c0x0000 (---------------)  + I agematsu
	0x00204e44, // n0x0f20 c0x0000 (---------------)  + I anan
	0x00395484, // n0x0f21 c0x0000 (---------------)  + I aoki
	0x002ad5c5, // n0x0f22 c0x0000 (---------------)  + I asahi
	0x0027ed87, // n0x0f23 c0x0000 (---------------)  + I azumino
	0x00206a49, // n0x0f24 c0x0000 (---------------)  + I chikuhoku
	0x0036c387, // n0x0f25 c0x0000 (---------------)  + I chikuma
	0x0022e185, // n0x0f26 c0x0000 (---------------)  + I chino
	0x00265906, // n0x0f27 c0x0000 (---------------)  + I fujimi
	0x003317c6, // n0x0f28 c0x0000 (---------------)  + I hakuba
	0x0020a004, // n0x0f29 c0x0000 (---------------)  + I hara
	0x0028c546, // n0x0f2a c0x0000 (---------------)  + I hiraya
	0x0024ecc4, // n0x0f2b c0x0000 (---------------)  + I iida
	0x00256486, // n0x0f2c c0x0000 (---------------)  + I iijima
	0x0034d2c6, // n0x0f2d c0x0000 (---------------)  + I iiyama
	0x0020ec86, // n0x0f2e c0x0000 (---------------)  + I iizuna
	0x00390e45, // n0x0f2f c0x0000 (---------------)  + I ikeda
	0x00231687, // n0x0f30 c0x0000 (---------------)  + I ikusaka
	0x00200243, // n0x0f31 c0x0000 (---------------)  + I ina
	0x0031e389, // n0x0f32 c0x0000 (---------------)  + I karuizawa
	0x00315908, // n0x0f33 c0x0000 (---------------)  + I kawakami
	0x0022a884, // n0x0f34 c0x0000 (---------------)  + I kiso
	0x0026d4cd, // n0x0f35 c0x0000 (---------------)  + I kisofukushima
	0x002827c8, // n0x0f36 c0x0000 (---------------)  + I kitaaiki
	0x002fa008, // n0x0f37 c0x0000 (---------------)  + I komagane
	0x002ae586, // n0x0f38 c0x0000 (---------------)  + I komoro
	0x0026ea09, // n0x0f39 c0x0000 (---------------)  + I matsukawa
	0x002c4889, // n0x0f3a c0x0000 (---------------)  + I matsumoto
	0x0024e105, // n0x0f3b c0x0000 (---------------)  + I miasa
	0x002883ca, // n0x0f3c c0x0000 (---------------)  + I minamiaiki
	0x0025b8ca, // n0x0f3d c0x0000 (---------------)  + I minamimaki
	0x002b064c, // n0x0f3e c0x0000 (---------------)  + I minamiminowa
	0x002b07c6, // n0x0f3f c0x0000 (---------------)  + I minowa
	0x00266386, // n0x0f40 c0x0000 (---------------)  + I miyada
	0x002af8c6, // n0x0f41 c0x0000 (---------------)  + I miyota
	0x00258b89, // n0x0f42 c0x0000 (---------------)  + I mochizuki
	0x0034e4c6, // n0x0f43 c0x0000 (---------------)  + I nagano
	0x0028ba86, // n0x0f44 c0x0000 (---------------)  + I nagawa
	0x00240906, // n0x0f45 c0x0000 (---------------)  + I nagiso
	0x002934c8, // n0x0f46 c0x0000 (---------------)  + I nakagawa
	0x0023fcc6, // n0x0f47 c0x0000 (---------------)  + I nakano
	0x002fe9cb, // n0x0f48 c0x0000 (---------------)  + I nozawaonsen
	0x0027ef05, // n0x0f49 c0x0000 (---------------)  + I obuse
	0x00204045, // n0x0f4a c0x0000 (---------------)  + I ogawa
	0x00266605, // n0x0f4b c0x0000 (---------------)  + I okaya
	0x00353c06, // n0x0f4c c0x0000 (---------------)  + I omachi
	0x00207d03, // n0x0f4d c0x0000 (---------------)  + I omi
	0x0022f306, // n0x0f4e c0x0000 (---------------)  + I ookuwa
	0x0027ba07, // n0x0f4f c0x0000 (---------------)  + I ooshika
	0x002a8605, // n0x0f50 c0x0000 (---------------)  + I otaki
	0x003389c5, // n0x0f51 c0x0000 (---------------)  + I otari
	0x0036ba45, // n0x0f52 c0x0000 (---------------)  + I sakae
	0x00201a06, // n0x0f53 c0x0000 (---------------)  + I sakaki
	0x0024e1c4, // n0x0f54 c0x0000 (---------------)  + I saku
	0x0035fb46, // n0x0f55 c0x0000 (---------------)  + I sakuho
	0x00325709, // n0x0f56 c0x0000 (---------------)  + I shimosuwa
	0x00353a8c, // n0x0f57 c0x0000 (---------------)  + I shinanomachi
	0x00294ac8, // n0x0f58 c0x0000 (---------------)  + I shiojiri
	0x002e5544, // n0x0f59 c0x0000 (---------------)  + I suwa
	0x002d2806, // n0x0f5a c0x0000 (---------------)  + I suzaka
	0x002fe846, // n0x0f5b c0x0000 (---------------)  + I takagi
	0x0022ab88, // n0x0f5c c0x0000 (---------------)  + I takamori
	0x0020f408, // n0x0f5d c0x0000 (---------------)  + I takayama
	0x00353989, // n0x0f5e c0x0000 (---------------)  + I tateshina
	0x00203987, // n0x0f5f c0x0000 (---------------)  + I tatsuno
	0x002e5d09, // n0x0f60 c0x0000 (---------------)  + I togakushi
	0x0025e506, // n0x0f61 c0x0000 (---------------)  + I togura
	0x002204c4, // n0x0f62 c0x0000 (---------------)  + I tomi
	0x00207204, // n0x0f63 c0x0000 (---------------)  + I ueda
	0x0023e8c4, // n0x0f64 c0x0000 (---------------)  + I wada
	0x0026dc08, // n0x0f65 c0x0000 (---------------)  + I yamagata
	0x0020688a, // n0x0f66 c0x0000 (---------------)  + I yamanouchi
	0x00339646, // n0x0f67 c0x0000 (---------------)  + I yasaka
	0x0033e847, // n0x0f68 c0x0000 (---------------)  + I yasuoka
	0x002e9747, // n0x0f69 c0x0000 (---------------)  + I chijiwa
	0x0021edc5, // n0x0f6a c0x0000 (---------------)  + I futsu
	0x00286c04, // n0x0f6b c0x0000 (---------------)  + I goto
	0x0027a8c6, // n0x0f6c c0x0000 (---------------)  + I hasami
	0x002e8206, // n0x0f6d c0x0000 (---------------)  + I hirado
	0x00206743, // n0x0f6e c0x0000 (---------------)  + I iki
	0x00315747, // n0x0f6f c0x0000 (---------------)  + I isahaya
	0x003108c8, // n0x0f70 c0x0000 (---------------)  + I kawatana
	0x0024e24a, // n0x0f71 c0x0000 (---------------)  + I kuchinotsu
	0x002bcc48, // n0x0f72 c0x0000 (---------------)  + I matsuura
	0x0036c108, // n0x0f73 c0x0000 (---------------)  + I nagasaki
	0x00395885, // n0x0f74 c0x0000 (---------------)  + I obama
	0x0023a1c5, // n0x0f75 c0x0000 (---------------)  + I omura
	0x00366645, // n0x0f76 c0x0000 (---------------)  + I oseto
	0x0021f186, // n0x0f77 c0x0000 (---------------)  + I saikai
	0x0029be46, // n0x0f78 c0x0000 (---------------)  + I sasebo
	0x002e5845, // n0x0f79 c0x0000 (---------------)  + I seihi
	0x0038bf49, // n0x0f7a c0x0000 (---------------)  + I shimabara
	0x00286a0c, // n0x0f7b c0x0000 (---------------)  + I shinkamigoto
	0x00226a07, // n0x0f7c c0x0000 (---------------)  + I togitsu
	0x00283308, // n0x0f7d c0x0000 (---------------)  + I tsushima
	0x00279c05, // n0x0f7e c0x0000 (---------------)  + I unzen
	0x006735c4, // n0x0f7f c0x0001 (---------------)  ! I city
	0x00346e44, // n0x0f80 c0x0000 (---------------)  + I ando
	0x0026e184, // n0x0f81 c0x0000 (---------------)  + I gose
	0x0022e2c6, // n0x0f82 c0x0000 (---------------)  + I heguri
	0x0028a74e, // n0x0f83 c0x0000 (---------------)  + I higashiyoshino
	0x00344187, // n0x0f84 c0x0000 (---------------)  + I ikaruga
	0x00204245, // n0x0f85 c0x0000 (---------------)  + I ikoma
	0x0022adcc, // n0x0f86 c0x0000 (---------------)  + I kamikitayama
	0x00292687, // n0x0f87 c0x0000 (---------------)  + I kanmaki
	0x00341647, // n0x0f88 c0x0000 (---------------)  + I kashiba
	0x00344809, // n0x0f89 c0x0000 (---------------)  + I kashihara
	0x002133c9, // n0x0f8a c0x0000 (---------------)  + I katsuragi
	0x00273345, // n0x0f8b c0x0000 (---------------)  + I kawai
	0x00315908, // n0x0f8c c0x0000 (---------------)  + I kawakami
	0x0022ed09, // n0x0f8d c0x0000 (---------------)  + I kawanishi
	0x002c9885, // n0x0f8e c0x0000 (---------------)  + I koryo
	0x002a8548, // n0x0f8f c0x0000 (---------------)  + I kurotaki
	0x002b5f46, // n0x0f90 c0x0000 (---------------)  + I mitsue
	0x002a5986, // n0x0f91 c0x0000 (---------------)  + I miyake
	0x002da0c4, // n0x0f92 c0x0000 (---------------)  + I nara
	0x00257448, // n0x0f93 c0x0000 (---------------)  + I nosegawa
	0x002432c3, // n0x0f94 c0x0000 (---------------)  + I oji
	0x00392684, // n0x0f95 c0x0000 (---------------)  + I ouda
	0x002e35c5, // n0x0f96 c0x0000 (---------------)  + I oyodo
	0x002f4d47, // n0x0f97 c0x0000 (---------------)  + I sakurai
	0x00202285, // n0x0f98 c0x0000 (---------------)  + I sango
	0x0038f649, // n0x0f99 c0x0000 (---------------)  + I shimoichi
	0x00267dcd, // n0x0f9a c0x0000 (---------------)  + I shimokitayama
	0x00285306, // n0x0f9b c0x0000 (---------------)  + I shinjo
	0x00220944, // n0x0f9c c0x0000 (---------------)  + I soni
	0x00335dc8, // n0x0f9d c0x0000 (---------------)  + I takatori
	0x0025ca0a, // n0x0f9e c0x0000 (---------------)  + I tawaramoto
	0x00203207, // n0x0f9f c0x0000 (---------------)  + I tenkawa
	0x0027be45, // n0x0fa0 c0x0000 (---------------)  + I tenri
	0x002070c3, // n0x0fa1 c0x0000 (---------------)  + I uda
	0x00289d8e, // n0x0fa2 c0x0000 (---------------)  + I yamatokoriyama
	0x0022afcc, // n0x0fa3 c0x0000 (---------------)  + I yamatotakada
	0x0027b147, // n0x0fa4 c0x0000 (---------------)  + I yamazoe
	0x0028a907, // n0x0fa5 c0x0000 (---------------)  + I yoshino
	0x002015c3, // n0x0fa6 c0x0000 (---------------)  + I aga
	0x0034e505, // n0x0fa7 c0x0000 (---------------)  + I agano
	0x0026e185, // n0x0fa8 c0x0000 (---------------)  + I gosen
	0x00283f48, // n0x0fa9 c0x0000 (---------------)  + I itoigawa
	0x00281409, // n0x0faa c0x0000 (---------------)  + I izumozaki
	0x0026a386, // n0x0fab c0x0000 (---------------)  + I joetsu
	0x0022ac04, // n0x0fac c0x0000 (---------------)  + I kamo
	0x00316046, // n0x0fad c0x0000 (---------------)  + I kariwa
	0x0038218b, // n0x0fae c0x0000 (---------------)  + I kashiwazaki
	0x002c460c, // n0x0faf c0x0000 (---------------)  + I minamiuonuma
	0x0026c3c7, // n0x0fb0 c0x0000 (---------------)  + I mitsuke
	0x002ba105, // n0x0fb1 c0x0000 (---------------)  + I muika
	0x003743c8, // n0x0fb2 c0x0000 (---------------)  + I murakami
	0x0032b585, // n0x0fb3 c0x0000 (---------------)  + I myoko
	0x0035ec07, // n0x0fb4 c0x0000 (---------------)  + I nagaoka
	0x0025f907, // n0x0fb5 c0x0000 (---------------)  + I niigata
	0x002432c5, // n0x0fb6 c0x0000 (---------------)  + I ojiya
	0x00207d03, // n0x0fb7 c0x0000 (---------------)  + I omi
	0x002109c4, // n0x0fb8 c0x0000 (---------------)  + I sado
	0x00203845, // n0x0fb9 c0x0000 (---------------)  + I sanjo
	0x002f3b45, // n0x0fba c0x0000 (---------------)  + I seiro
	0x002f3b46, // n0x0fbb c0x0000 (---------------)  + I seirou
	0x00274588, // n0x0fbc c0x0000 (---------------)  + I sekikawa
	0x003416c7, // n0x0fbd c0x0000 (---------------)  + I shibata
	0x0033ed46, // n0x0fbe c0x0000 (---------------)  + I tagami
	0x0031abc6, // n0x0fbf c0x0000 (---------------)  + I tainai
	0x0030fc06, // n0x0fc0 c0x0000 (---------------)  + I tochio
	0x002e1589, // n0x0fc1 c0x0000 (---------------)  + I tokamachi
	0x0031adc7, // n0x0fc2 c0x0000 (---------------)  + I tsubame
	0x00207306, // n0x0fc3 c0x0000 (---------------)  + I tsunan
	0x002c4786, // n0x0fc4 c0x0000 (---------------)  + I uonuma
	0x00243386, // n0x0fc5 c0x0000 (---------------)  + I yahiko
	0x00298cc5, // n0x0fc6 c0x0000 (---------------)  + I yoita
	0x00216b86, // n0x0fc7 c0x0000 (---------------)  + I yuzawa
	0x0034c845, // n0x0fc8 c0x0000 (---------------)  + I beppu
	0x002a55c8, // n0x0fc9 c0x0000 (---------------)  + I bungoono
	0x0024facb, // n0x0fca c0x0000 (---------------)  + I bungotakada
	0x0027a6c6, // n0x0fcb c0x0000 (---------------)  + I hasama
	0x002e9784, // n0x0fcc c0x0000 (---------------)  + I hiji
	0x00336449, // n0x0fcd c0x0000 (---------------)  + I himeshima
	0x0028d544, // n0x0fce c0x0000 (---------------)  + I hita
	0x002b5ec8, // n0x0fcf c0x0000 (---------------)  + I kamitsue
	0x0027b5c7, // n0x0fd0 c0x0000 (---------------)  + I kokonoe
	0x0026ff44, // n0x0fd1 c0x0000 (---------------)  + I kuju
	0x002a0f48, // n0x0fd2 c0x0000 (---------------)  + I kunisaki
	0x002a9c04, // n0x0fd3 c0x0000 (---------------)  + I kusu
	0x00298d04, // n0x0fd4 c0x0000 (---------------)  + I oita
	0x002a7585, // n0x0fd5 c0x0000 (---------------)  + I saiki
	0x00335cc6, // n0x0fd6 c0x0000 (---------------)  + I taketa
	0x00272207, // n0x0fd7 c0x0000 (---------------)  + I tsukumi
	0x00222503, // n0x0fd8 c0x0000 (---------------)  + I usa
	0x00288f85, // n0x0fd9 c0x0000 (---------------)  + I usuki
	0x002ab604, // n0x0fda c0x0000 (---------------)  + I yufu
	0x0023e446, // n0x0fdb c0x0000 (---------------)  + I akaiwa
	0x0024e188, // n0x0fdc c0x0000 (---------------)  + I asakuchi
	0x00310605, // n0x0fdd c0x0000 (---------------)  + I bizen
	0x0027e449, // n0x0fde c0x0000 (---------------)  + I hayashima
	0x002b9fc5, // n0x0fdf c0x0000 (---------------)  + I ibara
	0x002ab008, // n0x0fe0 c0x0000 (---------------)  + I kagamino
	0x00340b47, // n0x0fe1 c0x0000 (---------------)  + I kasaoka
	0x0035c188, // n0x0fe2 c0x0000 (---------------)  + I kibichuo
	0x002a0447, // n0x0fe3 c0x0000 (---------------)  + I kumenan
	0x0025adc9, // n0x0fe4 c0x0000 (---------------)  + I kurashiki
	0x002487c6, // n0x0fe5 c0x0000 (---------------)  + I maniwa
	0x00303986, // n0x0fe6 c0x0000 (---------------)  + I misaki
	0x00240904, // n0x0fe7 c0x0000 (---------------)  + I nagi
	0x0027cd05, // n0x0fe8 c0x0000 (---------------)  + I niimi
	0x002dac0c, // n0x0fe9 c0x0000 (---------------)  + I nishiawakura
	0x00266607, // n0x0fea c0x0000 (---------------)  + I okayama
	0x00266c47, // n0x0feb c0x0000 (---------------)  + I satosho
	0x002e9608, // n0x0fec c0x0000 (---------------)  + I setouchi
	0x00285306, // n0x0fed c0x0000 (---------------)  + I shinjo
	0x00340f44, // n0x0fee c0x0000 (---------------)  + I shoo
	0x0030ad04, // n0x0fef c0x0000 (---------------)  + I soja
	0x0023c909, // n0x0ff0 c0x0000 (---------------)  + I takahashi
	0x002af9c6, // n0x0ff1 c0x0000 (---------------)  + I tamano
	0x002601c7, // n0x0ff2 c0x0000 (---------------)  + I tsuyama
	0x00295d44, // n0x0ff3 c0x0000 (---------------)  + I wake
	0x002b4e06, // n0x0ff4 c0x0000 (---------------)  + I yakage
	0x00342185, // n0x0ff5 c0x0000 (---------------)  + I aguni
	0x0028d847, // n0x0ff6 c0x0000 (---------------)  + I ginowan
	0x002fe946, // n0x0ff7 c0x0000 (---------------)  + I ginoza
	0x00239cc9, // n0x0ff8 c0x0000 (---------------)  + I gushikami
	0x002b0487, // n0x0ff9 c0x0000 (---------------)  + I haebaru
	0x002545c7, // n0x0ffa c0x0000 (---------------)  + I higashi
	0x0028c086, // n0x0ffb c0x0000 (---------------)  + I hirara
	0x00231145, // n0x0ffc c0x0000 (---------------)  + I iheya
	0x0026cf88, // n0x0ffd c0x0000 (---------------)  + I ishigaki
	0x00214e48, // n0x0ffe c0x0000 (---------------)  + I ishikawa
	0x0022a5c6, // n0x0fff c0x0000 (---------------)  + I itoman
	0x00310645, // n0x1000 c0x0000 (---------------)  + I izena
	0x002f0446, // n0x1001 c0x0000 (---------------)  + I kadena
	0x00201b03, // n0x1002 c0x0000 (---------------)  + I kin
	0x00283dc9, // n0x1003 c0x0000 (---------------)  + I kitadaito
	0x0029168e, // n0x1004 c0x0000 (---------------)  + I kitanakagusuku
	0x0029f548, // n0x1005 c0x0000 (---------------)  + I kumejima
	0x002928c8, // n0x1006 c0x0000 (---------------)  + I kunigami
	0x0022a3cb, // n0x1007 c0x0000 (---------------)  + I minamidaito
	0x0027e686, // n0x1008 c0x0000 (---------------)  + I motobu
	0x002402c4, // n0x1009 c0x0000 (---------------)  + I nago
	0x0026ecc4, // n0x100a c0x0000 (---------------)  + I naha
	0x0029178a, // n0x100b c0x0000 (---------------)  + I nakagusuku
	0x0020d7c7, // n0x100c c0x0000 (---------------)  + I nakijin
	0x002073c5, // n0x100d c0x0000 (---------------)  + I nanjo
	0x0020e649, // n0x100e c0x0000 (---------------)  + I nishihara
	0x002a6885, // n0x100f c0x0000 (---------------)  + I ogimi
	0x003954c7, // n0x1010 c0x0000 (---------------)  + I okinawa
	0x002988c4, // n0x1011 c0x0000 (---------------)  + I onna
	0x00265dc7, // n0x1012 c0x0000 (---------------)  + I shimoji
	0x003162c8, // n0x1013 c0x0000 (---------------)  + I taketomi
	0x002a43c6, // n0x1014 c0x0000 (---------------)  + I tarama
	0x002065c9, // n0x1015 c0x0000 (---------------)  + I tokashiki
	0x002a2b4a, // n0x1016 c0x0000 (---------------)  + I tomigusuku
	0x0020d746, // n0x1017 c0x0000 (---------------)  + I tonaki
	0x00282306, // n0x1018 c0x0000 (---------------)  + I urasoe
	0x00296205, // n0x1019 c0x0000 (---------------)  + I uruma
	0x00361285, // n0x101a c0x0000 (---------------)  + I yaese
	0x00305787, // n0x101b c0x0000 (---------------)  + I yomitan
	0x00309c08, // n0x101c c0x0000 (---------------)  + I yonabaru
	0x003420c8, // n0x101d c0x0000 (---------------)  + I yonaguni
	0x00236b86, // n0x101e c0x0000 (---------------)  + I zamami
	0x0031d9c5, // n0x101f c0x0000 (---------------)  + I abeno
	0x002403ce, // n0x1020 c0x0000 (---------------)  + I chihayaakasaka
	0x002be904, // n0x1021 c0x0000 (---------------)  + I chuo
	0x0022a545, // n0x1022 c0x0000 (---------------)  + I daito
	0x00265289, // n0x1023 c0x0000 (---------------)  + I fujiidera
	0x00273148, // n0x1024 c0x0000 (---------------)  + I habikino
	0x00278046, // n0x1025 c0x0000 (---------------)  + I hannan
	0x0028630c, // n0x1026 c0x0000 (---------------)  + I higashiosaka
	0x00287ed0, // n0x1027 c0x0000 (---------------)  + I higashisumiyoshi
	0x0028a38f, // n0x1028 c0x0000 (---------------)  + I higashiyodogawa
	0x0028b7c8, // n0x1029 c0x0000 (---------------)  + I hirakata
	0x00316ac7, // n0x102a c0x0000 (---------------)  + I ibaraki
	0x00390e45, // n0x102b c0x0000 (---------------)  + I ikeda
	0x00209785, // n0x102c c0x0000 (---------------)  + I izumi
	0x00272089, // n0x102d c0x0000 (---------------)  + I izumiotsu
	0x00209789, // n0x102e c0x0000 (---------------)  + I izumisano
	0x00216406, // n0x102f c0x0000 (---------------)  + I kadoma
	0x002df247, // n0x1030 c0x0000 (---------------)  + I kaizuka
	0x0037c505, // n0x1031 c0x0000 (---------------)  + I kanan
	0x00375c89, // n0x1032 c0x0000 (---------------)  + I kashiwara
	0x003175c6, // n0x1033 c0x0000 (---------------)  + I katano
	0x0034e30d, // n0x1034 c0x0000 (---------------)  + I kawachinagano
	0x0026d109, // n0x1035 c0x0000 (---------------)  + I kishiwada
	0x00206e44, // n0x1036 c0x0000 (---------------)  + I kita
	0x0029f2c8, // n0x1037 c0x0000 (---------------)  + I kumatori
	0x0034e0c9, // n0x1038 c0x0000 (---------------)  + I matsubara
	0x00339806, // n0x1039 c0x0000 (---------------)  + I minato
	0x00265a05, // n0x103a c0x0000 (---------------)  + I minoh
	0x00303986, // n0x103b c0x0000 (---------------)  + I misaki
	0x00387b49, // n0x103c c0x0000 (---------------)  + I moriguchi
	0x003896c8, // n0x103d c0x0000 (---------------)  + I neyagawa
	0x00208b85, // n0x103e c0x0000 (---------------)  + I nishi
	0x00257444, // n0x103f c0x0000 (---------------)  + I nose
	0x002864cb, // n0x1040 c0x0000 (---------------)  + I osakasayama
	0x003396c5, // n0x1041 c0x0000 (---------------)  + I sakai
	0x00286606, // n0x1042 c0x0000 (---------------)  + I sayama
	0x0026f406, // n0x1043 c0x0000 (---------------)  + I sennan
	0x00243d86, // n0x1044 c0x0000 (---------------)  + I settsu
	0x003260cb, // n0x1045 c0x0000 (---------------)  + I shijonawate
	0x0027e549, // n0x1046 c0x0000 (---------------)  + I shimamoto
	0x002e5b85, // n0x1047 c0x0000 (---------------)  + I suita
	0x0035bf47, // n0x1048 c0x0000 (---------------)  + I tadaoka
	0x0025fa46, // n0x1049 c0x0000 (---------------)  + I taishi
	0x002345c6, // n0x104a c0x0000 (---------------)  + I tajiri
	0x0026df08, // n0x104b c0x0000 (---------------)  + I takaishi
	0x00376d89, // n0x104c c0x0000 (---------------)  + I takatsuki
	0x00246f8c, // n0x104d c0x0000 (---------------)  + I tondabayashi
	0x00351d08, // n0x104e c0x0000 (---------------)  + I toyonaka
	0x002260c6, // n0x104f c0x0000 (---------------)  + I toyono
	0x00330543, // n0x1050 c0x0000 (---------------)  + I yao
	0x0027ebc6, // n0x1051 c0x0000 (---------------)  + I ariake
	0x0025ac85, // n0x1052 c0x0000 (---------------)  + I arita
	0x0026b1c8, // n0x1053 c0x0000 (---------------)  + I fukudomi
	0x0021b746, // n0x1054 c0x0000 (---------------)  + I genkai
	0x0028da88, // n0x1055 c0x0000 (---------------)  + I hamatama
	0x00228245, // n0x1056 c0x0000 (---------------)  + I hizen
	0x00352985, // n0x1057 c0x0000 (---------------)  + I imari
	0x002877c8, // n0x1058 c0x0000 (---------------)  + I kamimine
	0x002d2c87, // n0x1059 c0x0000 (---------------)  + I kanzaki
	0x0033e987, // n0x105a c0x0000 (---------------)  + I karatsu
	0x00341887, // n0x105b c0x0000 (---------------)  + I kashima
	0x0022aa08, // n0x105c c0x0000 (---------------)  + I kitagata
	0x00316c08, // n0x105d c0x0000 (---------------)  + I kitahata
	0x00253286, // n0x105e c0x0000 (---------------)  + I kiyama
	0x002f1947, // n0x105f c0x0000 (---------------)  + I kouhoku
	0x002896c7, // n0x1060 c0x0000 (---------------)  + I kyuragi
	0x00325dca, // n0x1061 c0x0000 (---------------)  + I nishiarita
	0x00212803, // n0x1062 c0x0000 (---------------)  + I ogi
	0x00353c06, // n0x1063 c0x0000 (---------------)  + I omachi
	0x002069c5, // n0x1064 c0x0000 (---------------)  + I ouchi
	0x00275104, // n0x1065 c0x0000 (---------------)  + I saga
	0x00268409, // n0x1066 c0x0000 (---------------)  + I shiroishi
	0x0025ad44, // n0x1067 c0x0000 (---------------)  + I taku
	0x00253f44, // n0x1068 c0x0000 (---------------)  + I tara
	0x002891c4, // n0x1069 c0x0000 (---------------)  + I tosu
	0x0028a90b, // n0x106a c0x0000 (---------------)  + I yoshinogari
	0x0034e247, // n0x106b c0x0000 (---------------)  + I arakawa
	0x00240605, // n0x106c c0x0000 (---------------)  + I asaka
	0x00280ac8, // n0x106d c0x0000 (---------------)  + I chichibu
	0x00265906, // n0x106e c0x0000 (---------------)  + I fujimi
	0x00265908, // n0x106f c0x0000 (---------------)  + I fujimino
	0x00269d86, // n0x1070 c0x0000 (---------------)  + I fukaya
	0x00278e45, // n0x1071 c0x0000 (---------------)  + I hanno
	0x002794c5, // n0x1072 c0x0000 (---------------)  + I hanyu
	0x0027b306, // n0x1073 c0x0000 (---------------)  + I hasuda
	0x0027b788, // n0x1074 c0x0000 (---------------)  + I hatogaya
	0x0027c2c8, // n0x1075 c0x0000 (---------------)  + I hatoyama
	0x002685c6, // n0x1076 c0x0000 (---------------)  + I hidaka
	0x0028090f, // n0x1077 c0x0000 (---------------)  + I higashichichibu
	0x00283890, // n0x1078 c0x0000 (---------------)  + I higashimatsuyama
	0x002028c5, // n0x1079 c0x0000 (---------------)  + I honjo
	0x00200243, // n0x107a c0x0000 (---------------)  + I ina
	0x002797c5, // n0x107b c0x0000 (---------------)  + I iruma
	0x0030b3c8, // n0x107c c0x0000 (---------------)  + I iwatsuki
	0x00209689, // n0x107d c0x0000 (---------------)  + I kamiizumi
	0x00304f08, // n0x107e c0x0000 (---------------)  + I kamikawa
	0x00340c88, // n0x107f c0x0000 (---------------)  + I kamisato
	0x00391808, // n0x1080 c0x0000 (---------------)  + I kasukabe
	0x002406c7, // n0x1081 c0x0000 (---------------)  + I kawagoe
	0x002655c9, // n0x1082 c0x0000 (---------------)  + I kawaguchi
	0x0028dc88, // n0x1083 c0x0000 (---------------)  + I kawajima
	0x00369344, // n0x1084 c0x0000 (---------------)  + I kazo
	0x00289048, // n0x1085 c0x0000 (---------------)  + I kitamoto
	0x0028ec09, // n0x1086 c0x0000 (---------------)  + I koshigaya
	0x00307ec7, // n0x1087 c0x0000 (---------------)  + I kounosu
	0x00293e04, // n0x1088 c0x0000 (---------------)  + I kuki
	0x0036c448, // n0x1089 c0x0000 (---------------)  + I kumagaya
	0x0023144a, // n0x108a c0x0000 (---------------)  + I matsubushi
	0x0031ef46, // n0x108b c0x0000 (---------------)  + I minano
	0x0028b246, // n0x108c c0x0000 (---------------)  + I misato
	0x0021ae49, // n0x108d c0x0000 (---------------)  + I miyashiro
	0x00288107, // n0x108e c0x0000 (---------------)  + I miyoshi
	0x002b62c8, // n0x108f c0x0000 (---------------)  + I moroyama
	0x00201588, // n0x1090 c0x0000 (---------------)  + I nagatoro
	0x00342d88, // n0x1091 c0x0000 (---------------)  + I namegawa
	0x003721c5, // n0x1092 c0x0000 (---------------)  + I niiza
	0x00362605, // n0x1093 c0x0000 (---------------)  + I ogano
	0x00204045, // n0x1094 c0x0000 (---------------)  + I ogawa
	0x0026e145, // n0x1095 c0x0000 (---------------)  + I ogose
	0x00259347, // n0x1096 c0x0000 (---------------)  + I okegawa
	0x00207d05, // n0x1097 c0x0000 (---------------)  + I omiya
	0x002a8605, // n0x1098 c0x0000 (---------------)  + I otaki
	0x00386ac6, // n0x1099 c0x0000 (---------------)  + I ranzan
	0x00304e47, // n0x109a c0x0000 (---------------)  + I ryokami
	0x002d0f07, // n0x109b c0x0000 (---------------)  + I saitama
	0x00231746, // n0x109c c0x0000 (---------------)  + I sakado
	0x002bb685, // n0x109d c0x0000 (---------------)  + I satte
	0x00286606, // n0x109e c0x0000 (---------------)  + I sayama
	0x002066c5, // n0x109f c0x0000 (---------------)  + I shiki
	0x00298148, // n0x10a0 c0x0000 (---------------)  + I shiraoka
	0x002cc0c4, // n0x10a1 c0x0000 (---------------)  + I soka
	0x002adc86, // n0x10a2 c0x0000 (---------------)  + I sugito
	0x00312e84, // n0x10a3 c0x0000 (---------------)  + I toda
	0x002add88, // n0x10a4 c0x0000 (---------------)  + I tokigawa
	0x00302c0a, // n0x10a5 c0x0000 (---------------)  + I tokorozawa
	0x0027700c, // n0x10a6 c0x0000 (---------------)  + I tsurugashima
	0x0020b805, // n0x10a7 c0x0000 (---------------)  + I urawa
	0x00204106, // n0x10a8 c0x0000 (---------------)  + I warabi
	0x00247146, // n0x10a9 c0x0000 (---------------)  + I yashio
	0x002f5606, // n0x10aa c0x0000 (---------------)  + I yokoze
	0x00226144, // n0x10ab c0x0000 (---------------)  + I yono
	0x00375b45, // n0x10ac c0x0000 (---------------)  + I yorii
	0x00269bc7, // n0x10ad c0x0000 (---------------)  + I yoshida
	0x00288189, // n0x10ae c0x0000 (---------------)  + I yoshikawa
	0x0028fac7, // n0x10af c0x0000 (---------------)  + I yoshimi
	0x006735c4, // n0x10b0 c0x0001 (---------------)  ! I city
	0x006735c4, // n0x10b1 c0x0001 (---------------)  ! I city
	0x002f59c5, // n0x10b2 c0x0000 (---------------)  + I aisho
	0x0023dd44, // n0x10b3 c0x0000 (---------------)  + I gamo
	0x00285cca, // n0x10b4 c0x0000 (---------------)  + I higashiomi
	0x00265786, // n0x10b5 c0x0000 (---------------)  + I hikone
	0x00346344, // n0x10b6 c0x0000 (---------------)  + I koka
	0x00204cc5, // n0x10b7 c0x0000 (---------------)  + I konan
	0x002d7bc5, // n0x10b8 c0x0000 (---------------)  + I kosei
	0x002e8104, // n0x10b9 c0x0000 (---------------)  + I koto
	0x0026f047, // n0x10ba c0x0000 (---------------)  + I kusatsu
	0x002b9f47, // n0x10bb c0x0000 (---------------)  + I maibara
	0x002b4f88, // n0x10bc c0x0000 (---------------)  + I moriyama
	0x0036df48, // n0x10bd c0x0000 (---------------)  + I nagahama
	0x00208b89, // n0x10be c0x0000 (---------------)  + I nishiazai
	0x003176c8, // n0x10bf c0x0000 (---------------)  + I notogawa
	0x00285e8b, // n0x10c0 c0x0000 (---------------)  + I omihachiman
	0x0022a784, // n0x10c1 c0x0000 (---------------)  + I otsu
	0x0025e445, // n0x10c2 c0x0000 (---------------)  + I ritto
	0x00258dc5, // n0x10c3 c0x0000 (---------------)  + I ryuoh
	0x00341809, // n0x10c4 c0x0000 (---------------)  + I takashima
	0x00376d89, // n0x10c5 c0x0000 (---------------)  + I takatsuki
	0x00336348, // n0x10c6 c0x0000 (---------------)  + I torahime
	0x00233d48, // n0x10c7 c0x0000 (---------------)  + I toyosato
	0x00207004, // n0x10c8 c0x0000 (---------------)  + I yasu
	0x002fe885, // n0x10c9 c0x0000 (---------------)  + I akagi
	0x002068c3, // n0x10ca c0x0000 (---------------)  + I ama
	0x0022a745, // n0x10cb c0x0000 (---------------)  + I gotsu
	0x00292ac6, // n0x10cc c0x0000 (---------------)  + I hamada
	0x0028124c, // n0x10cd c0x0000 (---------------)  + I higashiizumo
	0x00214ec6, // n0x10ce c0x0000 (---------------)  + I hikawa
	0x002fb046, // n0x10cf c0x0000 (---------------)  + I hikimi
	0x002782c5, // n0x10d0 c0x0000 (---------------)  + I izumo
	0x00201a88, // n0x10d1 c0x0000 (---------------)  + I kakinoki
	0x002a2fc6, // n0x10d2 c0x0000 (---------------)  + I masuda
	0x0038d9c6, // n0x10d3 c0x0000 (---------------)  + I matsue
	0x0028b246, // n0x10d4 c0x0000 (---------------)  + I misato
	0x0021f48c, // n0x10d5 c0x0000 (---------------)  + I nishinoshima
	0x0024eac4, // n0x10d6 c0x0000 (---------------)  + I ohda
	0x0030fd4a, // n0x10d7 c0x0000 (---------------)  + I okinoshima
	0x00278208, // n0x10d8 c0x0000 (---------------)  + I okuizumo
	0x00281087, // n0x10d9 c0x0000 (---------------)  + I shimane
	0x00260c46, // n0x10da c0x0000 (---------------)  + I tamayu
	0x002e5507, // n0x10db c0x0000 (---------------)  + I tsuwano
	0x002ca4c5, // n0x10dc c0x0000 (---------------)  + I unnan
	0x00311fc6, // n0x10dd c0x0000 (---------------)  + I yakumo
	0x0033ba46, // n0x10de c0x0000 (---------------)  + I yasugi
	0x00365987, // n0x10df c0x0000 (---------------)  + I yatsuka
	0x00253f84, // n0x10e0 c0x0000 (---------------)  + I arai
	0x0027d805, // n0x10e1 c0x0000 (---------------)  + I atami
	0x00265284, // n0x10e2 c0x0000 (---------------)  + I fuji
	0x00294e07, // n0x10e3 c0x0000 (---------------)  + I fujieda
	0x002654c8, // n0x10e4 c0x0000 (---------------)  + I fujikawa
	0x0026620a, // n0x10e5 c0x0000 (---------------)  + I fujinomiya
	0x0026ce07, // n0x10e6 c0x0000 (---------------)  + I fukuroi
	0x00271047, // n0x10e7 c0x0000 (---------------)  + I gotemba
	0x00316a47, // n0x10e8 c0x0000 (---------------)  + I haibara
	0x0032b6c9, // n0x10e9 c0x0000 (---------------)  + I hamamatsu
	0x0028124a, // n0x10ea c0x0000 (---------------)  + I higashiizu
	0x00220483, // n0x10eb c0x0000 (---------------)  + I ito
	0x00253e85, // n0x10ec c0x0000 (---------------)  + I iwata
	0x00209783, // n0x10ed c0x0000 (---------------)  + I izu
	0x002f1c49, // n0x10ee c0x0000 (---------------)  + I izunokuni
	0x002c7008, // n0x10ef c0x0000 (---------------)  + I kakegawa
	0x002d17c7, // n0x10f0 c0x0000 (---------------)  + I kannami
	0x00305009, // n0x10f1 c0x0000 (---------------)  + I kawanehon
	0x00214f46, // n0x10f2 c0x0000 (---------------)  + I kawazu
	0x0025fcc8, // n0x10f3 c0x0000 (---------------)  + I kikugawa
	0x002d4745, // n0x10f4 c0x0000 (---------------)  + I kosai
	0x00364b0a, // n0x10f5 c0x0000 (---------------)  + I makinohara
	0x00355209, // n0x10f6 c0x0000 (---------------)  + I matsuzaki
	0x00246c49, // n0x10f7 c0x0000 (---------------)  + I minamiizu
	0x00392cc7, // n0x10f8 c0x0000 (---------------)  + I mishima
	0x0028b509, // n0x10f9 c0x0000 (---------------)  + I morimachi
	0x0020eb88, // n0x10fa c0x0000 (---------------)  + I nishiizu
	0x002d2986, // n0x10fb c0x0000 (---------------)  + I numazu
	0x002042c8, // n0x10fc c0x0000 (---------------)  + I omaezaki
	0x0034e807, // n0x10fd c0x0000 (---------------)  + I shimada
	0x002521c7, // n0x10fe c0x0000 (---------------)  + I shimizu
	0x0027bc87, // n0x10ff c0x0000 (---------------)  + I shimoda
	0x002b4b88, // n0x1100 c0x0000 (---------------)  + I shizuoka
	0x002d2686, // n0x1101 c0x0000 (---------------)  + I susono
	0x00231205, // n0x1102 c0x0000 (---------------)  + I yaizu
	0x00269bc7, // n0x1103 c0x0000 (---------------)  + I yoshida
	0x00281e08, // n0x1104 c0x0000 (---------------)  + I ashikaga
	0x0030f544, // n0x1105 c0x0000 (---------------)  + I bato
	0x002d6e04, // n0x1106 c0x0000 (---------------)  + I haga
	0x00315b07, // n0x1107 c0x0000 (---------------)  + I ichikai
	0x00255847, // n0x1108 c0x0000 (---------------)  + I iwafune
	0x0022eb8a, // n0x1109 c0x0000 (---------------)  + I kaminokawa
	0x002d2906, // n0x110a c0x0000 (---------------)  + I kanuma
	0x0027afca, // n0x110b c0x0000 (---------------)  + I karasuyama
	0x002a6b47, // n0x110c c0x0000 (---------------)  + I kuroiso
	0x002be6c7, // n0x110d c0x0000 (---------------)  + I mashiko
	0x0024fa44, // n0x110e c0x0000 (---------------)  + I mibu
	0x002669c4, // n0x110f c0x0000 (---------------)  + I moka
	0x0021ff46, // n0x1110 c0x0000 (---------------)  + I motegi
	0x002efac4, // n0x1111 c0x0000 (---------------)  + I nasu
	0x002efacc, // n0x1112 c0x0000 (---------------)  + I nasushiobara
	0x0033e185, // n0x1113 c0x0000 (---------------)  + I nikko
	0x0020f249, // n0x1114 c0x0000 (---------------)  + I nishikata
	0x00267304, // n0x1115 c0x0000 (---------------)  + I nogi
	0x002e81c5, // n0x1116 c0x0000 (---------------)  + I ohira
	0x0025c988, // n0x1117 c0x0000 (---------------)  + I ohtawara
	0x0027c385, // n0x1118 c0x0000 (---------------)  + I oyama
	0x002f4d46, // n0x1119 c0x0000 (---------------)  + I sakura
	0x002098c4, // n0x111a c0x0000 (---------------)  + I sano
	0x0027924a, // n0x111b c0x0000 (---------------)  + I shimotsuke
	0x002d80c6, // n0x111c c0x0000 (---------------)  + I shioya
	0x00316d8a, // n0x111d c0x0000 (---------------)  + I takanezawa
	0x0030f5c7, // n0x111e c0x0000 (---------------)  + I tochigi
	0x0021d305, // n0x111f c0x0000 (---------------)  + I tsuga
	0x00212d45, // n0x1120 c0x0000 (---------------)  + I ujiie
	0x0021ee0a, // n0x1121 c0x0000 (---------------)  + I utsunomiya
	0x0028c645, // n0x1122 c0x0000 (---------------)  + I yaita
	0x00272046, // n0x1123 c0x0000 (---------------)  + I aizumi
	0x00204e44, // n0x1124 c0x0000 (---------------)  + I anan
	0x002a0706, // n0x1125 c0x0000 (---------------)  + I ichiba
	0x00305845, // n0x1126 c0x0000 (---------------)  + I itano
	0x0021b806, // n0x1127 c0x0000 (---------------)  + I kainan
	0x002be44c, // n0x1128 c0x0000 (---------------)  + I komatsushima
	0x002b644a, // n0x1129 c0x0000 (---------------)  + I matsushige
	0x0025b9c4, // n0x112a c0x0000 (---------------)  + I mima
	0x00213fc6, // n0x112b c0x0000 (---------------)  + I minami
	0x00288107, // n0x112c c0x0000 (---------------)  + I miyoshi
	0x002b9b44, // n0x112d c0x0000 (---------------)  + I mugi
	0x002934c8, // n0x112e c0x0000 (---------------)  + I nakagawa
	0x00376a06, // n0x112f c0x0000 (---------------)  + I naruto
	0x00240249, // n0x1130 c0x0000 (---------------)  + I sanagochi
	0x002c2189, // n0x1131 c0x0000 (---------------)  + I shishikui
	0x0028e2c9, // n0x1132 c0x0000 (---------------)  + I tokushima
	0x00359bc6, // n0x1133 c0x0000 (---------------)  + I wajiki
	0x0034e906, // n0x1134 c0x0000 (---------------)  + I adachi
	0x00204407, // n0x1135 c0x0000 (---------------)  + I akiruno
	0x0038be88, // n0x1136 c0x0000 (---------------)  + I akishima
	0x0034e709, // n0x1137 c0x0000 (---------------)  + I aogashima
	0x0034e247, // n0x1138 c0x0000 (---------------)  + I arakawa
	0x0027e786, // n0x1139 c0x0000 (---------------)  + I bunkyo
	0x002e3947, // n0x113a c0x0000 (---------------)  + I chiyoda
	0x0029a7c5, // n0x113b c0x0000 (---------------)  + I chofu
	0x002be904, // n0x113c c0x0000 (---------------)  + I chuo
	0x00203fc7, // n0x113d c0x0000 (---------------)  + I edogawa
	0x002ab685, // n0x113e c0x0000 (---------------)  + I fuchu
	0x00275045, // n0x113f c0x0000 (---------------)  + I fussa
	0x00389ec7, // n0x1140 c0x0000 (---------------)  + I hachijo
	0x00243188, // n0x1141 c0x0000 (---------------)  + I hachioji
	0x00374346, // n0x1142 c0x0000 (---------------)  + I hamura
	0x00282c8d, // n0x1143 c0x0000 (---------------)  + I higashikurume
	0x0028414f, // n0x1144 c0x0000 (---------------)  + I higashimurayama
	0x00289bcd, // n0x1145 c0x0000 (---------------)  + I higashiyamato
	0x0021ad44, // n0x1146 c0x0000 (---------------)  + I hino
	0x00227446, // n0x1147 c0x0000 (---------------)  + I hinode
	0x002bcf88, // n0x1148 c0x0000 (---------------)  + I hinohara
	0x002408c5, // n0x1149 c0x0000 (---------------)  + I inagi
	0x00325f88, // n0x114a c0x0000 (---------------)  + I itabashi
	0x002513ca, // n0x114b c0x0000 (---------------)  + I katsushika
	0x00206e44, // n0x114c c0x0000 (---------------)  + I kita
	0x002978c6, // n0x114d c0x0000 (---------------)  + I kiyose
	0x002a3687, // n0x114e c0x0000 (---------------)  + I kodaira
	0x00232c87, // n0x114f c0x0000 (---------------)  + I koganei
	0x00374809, // n0x1150 c0x0000 (---------------)  + I kokubunji
	0x00204285, // n0x1151 c0x0000 (---------------)  + I komae
	0x002e8104, // n0x1152 c0x0000 (---------------)  + I koto
	0x0031850a, // n0x1153 c0x0000 (---------------)  + I kouzushima
	0x002a2089, // n0x1154 c0x0000 (---------------)  + I kunitachi
	0x0028b607, // n0x1155 c0x0000 (---------------)  + I machida
	0x002b1286, // n0x1156 c0x0000 (---------------)  + I meguro
	0x00339806, // n0x1157 c0x0000 (---------------)  + I minato
	0x002fe7c6, // n0x1158 c0x0000 (---------------)  + I mitaka
	0x0034b046, // n0x1159 c0x0000 (---------------)  + I mizuho
	0x002bc90f, // n0x115a c0x0000 (---------------)  + I musashimurayama
	0x002bce49, // n0x115b c0x0000 (---------------)  + I musashino
	0x0023fcc6, // n0x115c c0x0000 (---------------)  + I nakano
	0x003528c6, // n0x115d c0x0000 (---------------)  + I nerima
	0x00301849, // n0x115e c0x0000 (---------------)  + I ogasawara
	0x002f1a47, // n0x115f c0x0000 (---------------)  + I okutama
	0x0020b3c3, // n0x1160 c0x0000 (---------------)  + I ome
	0x0021f606, // n0x1161 c0x0000 (---------------)  + I oshima
	0x00203943, // n0x1162 c0x0000 (---------------)  + I ota
	0x002c3488, // n0x1163 c0x0000 (---------------)  + I setagaya
	0x002e3787, // n0x1164 c0x0000 (---------------)  + I shibuya
	0x0028b9c9, // n0x1165 c0x0000 (---------------)  + I shinagawa
	0x00285788, // n0x1166 c0x0000 (---------------)  + I shinjuku
	0x0033eac8, // n0x1167 c0x0000 (---------------)  + I suginami
	0x00289246, // n0x1168 c0x0000 (---------------)  + I sumida
	0x0032da89, // n0x1169 c0x0000 (---------------)  + I tachikawa
	0x002e5c45, // n0x116a c0x0000 (---------------)  + I taito
	0x00260c44, // n0x116b c0x0000 (---------------)  + I tama
	0x002d0a47, // n0x116c c0x0000 (---------------)  + I toshima
	0x00258c05, // n0x116d c0x0000 (---------------)  + I chizu
	0x0021ad44, // n0x116e c0x0000 (---------------)  + I hino
	0x00274b88, // n0x116f c0x0000 (---------------)  + I kawahara
	0x0020da84, // n0x1170 c0x0000 (---------------)  + I koge
	0x002eaf87, // n0x1171 c0x0000 (---------------)  + I kotoura
	0x003337c6, // n0x1172 c0x0000 (---------------)  + I misasa
	0x002c6705, // n0x1173 c0x0000 (---------------)  + I nanbu
	0x0027fa88, // n0x1174 c0x0000 (---------------)  + I nichinan
	0x003396cb, // n0x1175 c0x0000 (---------------)  + I sakaiminato
	0x002e2787, // n0x1176 c0x0000 (---------------)  + I tottori
	0x0021f086, // n0x1177 c0x0000 (---------------)  + I wakasa
	0x002aeec4, // n0x1178 c0x0000 (---------------)  + I yazu
	0x0032b186, // n0x1179 c0x0000 (---------------)  + I yonago
	0x002ad5c5, // n0x117a c0x0000 (---------------)  + I asahi
	0x002ab685, // n0x117b c0x0000 (---------------)  + I fuchu
	0x0026c2c9, // n0x117c c0x0000 (---------------)  + I fukumitsu
	0x0026ec49, // n0x117d c0x0000 (---------------)  + I funahashi
	0x00252204, // n0x117e c0x0000 (---------------)  + I himi
	0x00252245, // n0x117f c0x0000 (---------------)  + I imizu
	0x00214005, // n0x1180 c0x0000 (---------------)  + I inami
	0x00364986, // n0x1181 c0x0000 (---------------)  + I johana
	0x00315a08, // n0x1182 c0x0000 (---------------)  + I kamiichi
	0x002a4c46, // n0x1183 c0x0000 (---------------)  + I kurobe
	0x0031070b, // n0x1184 c0x0000 (---------------)  + I nakaniikawa
	0x0029894a, // n0x1185 c0x0000 (---------------)  + I namerikawa
	0x002e14c5, // n0x1186 c0x0000 (---------------)  + I nanto
	0x00279546, // n0x1187 c0x0000 (---------------)  + I nyuzen
	0x0031d945, // n0x1188 c0x0000 (---------------)  + I oyabe
	0x00205705, // n0x1189 c0x0000 (---------------)  + I taira
	0x00281747, // n0x118a c0x0000 (---------------)  + I takaoka
	0x0038a708, // n0x118b c0x0000 (---------------)  + I tateyama
	0x0027b804, // n0x118c c0x0000 (---------------)  + I toga
	0x0024e006, // n0x118d c0x0000 (---------------)  + I tonami
	0x0027c346, // n0x118e c0x0000 (---------------)  + I toyama
	0x0020ed47, // n0x118f c0x0000 (---------------)  + I unazuki
	0x002e3d84, // n0x1190 c0x0000 (---------------)  + I uozu
	0x0026b046, // n0x1191 c0x0000 (---------------)  + I yamada
	0x00250d45, // n0x1192 c0x0000 (---------------)  + I arida
	0x00250d49, // n0x1193 c0x0000 (---------------)  + I aridagawa
	0x0034eb04, // n0x1194 c0x0000 (---------------)  + I gobo
	0x00286d89, // n0x1195 c0x0000 (---------------)  + I hashimoto
	0x002685c6, // n0x1196 c0x0000 (---------------)  + I hidaka
	0x002a9408, // n0x1197 c0x0000 (---------------)  + I hirogawa
	0x00214005, // n0x1198 c0x0000 (---------------)  + I inami
	0x002e9845, // n0x1199 c0x0000 (---------------)  + I iwade
	0x0021b806, // n0x119a c0x0000 (---------------)  + I kainan
	0x00246e89, // n0x119b c0x0000 (---------------)  + I kamitonda
	0x002133c9, // n0x119c c0x0000 (---------------)  + I katsuragi
	0x002fb0c6, // n0x119d c0x0000 (---------------)  + I kimino
	0x00273248, // n0x119e c0x0000 (---------------)  + I kinokawa
	0x0022aec8, // n0x119f c0x0000 (---------------)  + I kitayama
	0x0031d904, // n0x11a0 c0x0000 (---------------)  + I koya
	0x0034b544, // n0x11a1 c0x0000 (---------------)  + I koza
	0x0034b548, // n0x11a2 c0x0000 (---------------)  + I kozagawa
	0x003000c8, // n0x11a3 c0x0000 (---------------)  + I kudoyama
	0x002e5e09, // n0x11a4 c0x0000 (---------------)  + I kushimoto
	0x00292a46, // n0x11a5 c0x0000 (---------------)  + I mihama
	0x0028b246, // n0x11a6 c0x0000 (---------------)  + I misato
	0x002fd2cd, // n0x11a7 c0x0000 (---------------)  + I nachikatsuura
	0x002e6a46, // n0x11a8 c0x0000 (---------------)  + I shingu
	0x002a1409, // n0x11a9 c0x0000 (---------------)  + I shirahama
	0x00353dc5, // n0x11aa c0x0000 (---------------)  + I taiji
	0x0030f946, // n0x11ab c0x0000 (---------------)  + I tanabe
	0x0032dc48, // n0x11ac c0x0000 (---------------)  + I wakayama
	0x002f9ac5, // n0x11ad c0x0000 (---------------)  + I yuasa
	0x00289704, // n0x11ae c0x0000 (---------------)  + I yura
	0x002ad5c5, // n0x11af c0x0000 (---------------)  + I asahi
	0x0026e788, // n0x11b0 c0x0000 (---------------)  + I funagata
	0x00285a89, // n0x11b1 c0x0000 (---------------)  + I higashine
	0x00265344, // n0x11b2 c0x0000 (---------------)  + I iide
	0x00226886, // n0x11b3 c0x0000 (---------------)  + I kahoku
	0x003467ca, // n0x11b4 c0x0000 (---------------)  + I kaminoyama
	0x002150c8, // n0x11b5 c0x0000 (---------------)  + I kaneyama
	0x0022ed09, // n0x11b6 c0x0000 (---------------)  + I kawanishi
	0x002f8d4a, // n0x11b7 c0x0000 (---------------)  + I mamurogawa
	0x00304f86, // n0x11b8 c0x0000 (---------------)  + I mikawa
	0x00284308, // n0x11b9 c0x0000 (---------------)  + I murayama
	0x0035e9c5, // n0x11ba c0x0000 (---------------)  + I nagai
	0x00355088, // n0x11bb c0x0000 (---------------)  + I nakayama
	0x002a0545, // n0x11bc c0x0000 (---------------)  + I nanyo
	0x00214e09, // n0x11bd c0x0000 (---------------)  + I nishikawa
	0x0034fd89, // n0x11be c0x0000 (---------------)  + I obanazawa
	0x00210a82, // n0x11bf c0x0000 (---------------)  + I oe
	0x0029efc5, // n0x11c0 c0x0000 (---------------)  + I oguni
	0x00258e86, // n0x11c1 c0x0000 (---------------)  + I ohkura
	0x00268507, // n0x11c2 c0x0000 (---------------)  + I oishida
	0x00275105, // n0x11c3 c0x0000 (---------------)  + I sagae
	0x002f9b86, // n0x11c4 c0x0000 (---------------)  + I sakata
	0x00359408, // n0x11c5 c0x0000 (---------------)  + I sakegawa
	0x00285306, // n0x11c6 c0x0000 (---------------)  + I shinjo
	0x0029cd89, // n0x11c7 c0x0000 (---------------)  + I shirataka
	0x00266d46, // n0x11c8 c0x0000 (---------------)  + I shonai
	0x0026dd88, // n0x11c9 c0x0000 (---------------)  + I takahata
	0x00294245, // n0x11ca c0x0000 (---------------)  + I tendo
	0x00247ec6, // n0x11cb c0x0000 (---------------)  + I tozawa
	0x003052c8, // n0x11cc c0x0000 (---------------)  + I tsuruoka
	0x0026dc08, // n0x11cd c0x0000 (---------------)  + I yamagata
	0x0034d348, // n0x11ce c0x0000 (---------------)  + I yamanobe
	0x002212c8, // n0x11cf c0x0000 (---------------)  + I yonezawa
	0x00216b84, // n0x11d0 c0x0000 (---------------)  + I yuza
	0x0021bc43, // n0x11d1 c0x0000 (---------------)  + I abu
	0x0029cfc4, // n0x11d2 c0x0000 (---------------)  + I hagi
	0x002af4c6, // n0x11d3 c0x0000 (---------------)  + I hikari
	0x0029a804, // n0x11d4 c0x0000 (---------------)  + I hofu
	0x00292807, // n0x11d5 c0x0000 (---------------)  + I iwakuni
	0x0038d8c9, // n0x11d6 c0x0000 (---------------)  + I kudamatsu
	0x002ae205, // n0x11d7 c0x0000 (---------------)  + I mitou
	0x00201586, // n0x11d8 c0x0000 (---------------)  + I nagato
	0x0021f606, // n0x11d9 c0x0000 (---------------)  + I oshima
	0x002743cb, // n0x11da c0x0000 (---------------)  + I shimonoseki
	0x002e1406, // n0x11db c0x0000 (---------------)  + I shunan
	0x003003c6, // n0x11dc c0x0000 (---------------)  + I tabuse
	0x00286f48, // n0x11dd c0x0000 (---------------)  + I tokuyama
	0x00338906, // n0x11de c0x0000 (---------------)  + I toyota
	0x002b48c3, // n0x11df c0x0000 (---------------)  + I ube
	0x00213ec3, // n0x11e0 c0x0000 (---------------)  + I yuu
	0x002be904, // n0x11e1 c0x0000 (---------------)  + I chuo
	0x002243c5, // n0x11e2 c0x0000 (---------------)  + I doshi
	0x00289887, // n0x11e3 c0x0000 (---------------)  + I fuefuki
	0x002654c8, // n0x11e4 c0x0000 (---------------)  + I fujikawa
	0x002654cf, // n0x11e5 c0x0000 (---------------)  + I fujikawaguchiko
	0x00269acb, // n0x11e6 c0x0000 (---------------)  + I fujiyoshida
	0x00315808, // n0x11e7 c0x0000 (---------------)  + I hayakawa
	0x00226906, // n0x11e8 c0x0000 (---------------)  + I hokuto
	0x00312b8e, // n0x11e9 c0x0000 (---------------)  + I ichikawamisato
	0x0021b803, // n0x11ea c0x0000 (---------------)  + I kai
	0x0024cf84, // n0x11eb c0x0000 (---------------)  + I kofu
	0x002e1385, // n0x11ec c0x0000 (---------------)  + I koshu
	0x002e4a46, // n0x11ed c0x0000 (---------------)  + I kosuge
	0x0027a9cb, // n0x11ee c0x0000 (---------------)  + I minami-alps
	0x0027ee46, // n0x11ef c0x0000 (---------------)  + I minobu
	0x00204889, // n0x11f0 c0x0000 (---------------)  + I nakamichi
	0x002c6705, // n0x11f1 c0x0000 (---------------)  + I nanbu
	0x00372f88, // n0x11f2 c0x0000 (---------------)  + I narusawa
	0x00208608, // n0x11f3 c0x0000 (---------------)  + I nirasaki
	0x0021328c, // n0x11f4 c0x0000 (---------------)  + I nishikatsura
	0x0028a946, // n0x11f5 c0x0000 (---------------)  + I oshino
	0x0022a786, // n0x11f6 c0x0000 (---------------)  + I otsuki
	0x002b3885, // n0x11f7 c0x0000 (---------------)  + I showa
	0x00275f88, // n0x11f8 c0x0000 (---------------)  + I tabayama
	0x0026a445, // n0x11f9 c0x0000 (---------------)  + I tsuru
	0x0038dac8, // n0x11fa c0x0000 (---------------)  + I uenohara
	0x0028a00a, // n0x11fb c0x0000 (---------------)  + I yamanakako
	0x0029b889, // n0x11fc c0x0000 (---------------)  + I yamanashi
	0x006735c4, // n0x11fd c0x0001 (---------------)  ! I city
	0x2d600742, // n0x11fe c0x00b5 (n0x11ff-n0x1200)  o I co
	0x000e4188, // n0x11ff c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1200 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1201 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1202 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x1203 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1204 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1205 c0x0000 (---------------)  + I org
	0x00310603, // n0x1206 c0x0000 (---------------)  + I biz
	0x00222ac3, // n0x1207 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1208 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1209 c0x0000 (---------------)  + I gov
	0x00200304, // n0x120a c0x0000 (---------------)  + I info
	0x002170c3, // n0x120b c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x120c c0x0000 (---------------)  + I org
	0x002362c3, // n0x120d c0x0000 (---------------)  + I ass
	0x002729c4, // n0x120e c0x0000 (---------------)  + I asso
	0x00222ac3, // n0x120f c0x0000 (---------------)  + I com
	0x00228d44, // n0x1210 c0x0000 (---------------)  + I coop
	0x002d75c3, // n0x1211 c0x0000 (---------------)  + I edu
	0x003579c4, // n0x1212 c0x0000 (---------------)  + I gouv
	0x0021e283, // n0x1213 c0x0000 (---------------)  + I gov
	0x002753c7, // n0x1214 c0x0000 (---------------)  + I medecin
	0x0023fa03, // n0x1215 c0x0000 (---------------)  + I mil
	0x00207cc3, // n0x1216 c0x0000 (---------------)  + I nom
	0x00265c08, // n0x1217 c0x0000 (---------------)  + I notaires
	0x0021dcc3, // n0x1218 c0x0000 (---------------)  + I org
	0x002e078b, // n0x1219 c0x0000 (---------------)  + I pharmaciens
	0x002ca783, // n0x121a c0x0000 (---------------)  + I prd
	0x0029abc6, // n0x121b c0x0000 (---------------)  + I presse
	0x00208902, // n0x121c c0x0000 (---------------)  + I tm
	0x0036b18b, // n0x121d c0x0000 (---------------)  + I veterinaire
	0x002d75c3, // n0x121e c0x0000 (---------------)  + I edu
	0x0021e283, // n0x121f c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1220 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1221 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x1222 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1223 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1224 c0x0000 (---------------)  + I gov
	0x0021dcc3, // n0x1225 c0x0000 (---------------)  + I org
	0x002117c3, // n0x1226 c0x0000 (---------------)  + I rep
	0x00210103, // n0x1227 c0x0000 (---------------)  + I tra
	0x00201e82, // n0x1228 c0x0000 (---------------)  + I ac
	0x000e4188, // n0x1229 c0x0000 (---------------)  +   blogspot
	0x002224c5, // n0x122a c0x0000 (---------------)  + I busan
	0x002ea8c8, // n0x122b c0x0000 (---------------)  + I chungbuk
	0x002ec1c8, // n0x122c c0x0000 (---------------)  + I chungnam
	0x00200742, // n0x122d c0x0000 (---------------)  + I co
	0x0032b905, // n0x122e c0x0000 (---------------)  + I daegu
	0x0023e947, // n0x122f c0x0000 (---------------)  + I daejeon
	0x002010c2, // n0x1230 c0x0000 (---------------)  + I es
	0x00204ac7, // n0x1231 c0x0000 (---------------)  + I gangwon
	0x00202342, // n0x1232 c0x0000 (---------------)  + I go
	0x00370b47, // n0x1233 c0x0000 (---------------)  + I gwangju
	0x00384c89, // n0x1234 c0x0000 (---------------)  + I gyeongbuk
	0x0035e588, // n0x1235 c0x0000 (---------------)  + I gyeonggi
	0x00342c09, // n0x1236 c0x0000 (---------------)  + I gyeongnam
	0x00203802, // n0x1237 c0x0000 (---------------)  + I hs
	0x002c2a87, // n0x1238 c0x0000 (---------------)  + I incheon
	0x002fae44, // n0x1239 c0x0000 (---------------)  + I jeju
	0x0023ea07, // n0x123a c0x0000 (---------------)  + I jeonbuk
	0x00298847, // n0x123b c0x0000 (---------------)  + I jeonnam
	0x002a3fc2, // n0x123c c0x0000 (---------------)  + I kg
	0x0023fa03, // n0x123d c0x0000 (---------------)  + I mil
	0x00209282, // n0x123e c0x0000 (---------------)  + I ms
	0x00201082, // n0x123f c0x0000 (---------------)  + I ne
	0x00200c42, // n0x1240 c0x0000 (---------------)  + I or
	0x00214942, // n0x1241 c0x0000 (---------------)  + I pe
	0x002030c2, // n0x1242 c0x0000 (---------------)  + I re
	0x00200982, // n0x1243 c0x0000 (---------------)  + I sc
	0x002baac5, // n0x1244 c0x0000 (---------------)  + I seoul
	0x002376c5, // n0x1245 c0x0000 (---------------)  + I ulsan
	0x00222ac3, // n0x1246 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1247 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1248 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1249 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x124a c0x0000 (---------------)  + I org
	0x00222ac3, // n0x124b c0x0000 (---------------)  + I com
	0x002d75c3, // n0x124c c0x0000 (---------------)  + I edu
	0x0021e283, // n0x124d c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x124e c0x0000 (---------------)  + I mil
	0x002170c3, // n0x124f c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1250 c0x0000 (---------------)  + I org
	0x00000741, // n0x1251 c0x0000 (---------------)  +   c
	0x00222ac3, // n0x1252 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1253 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1254 c0x0000 (---------------)  + I gov
	0x00200304, // n0x1255 c0x0000 (---------------)  + I info
	0x00238c03, // n0x1256 c0x0000 (---------------)  + I int
	0x002170c3, // n0x1257 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1258 c0x0000 (---------------)  + I org
	0x00214943, // n0x1259 c0x0000 (---------------)  + I per
	0x00222ac3, // n0x125a c0x0000 (---------------)  + I com
	0x002d75c3, // n0x125b c0x0000 (---------------)  + I edu
	0x0021e283, // n0x125c c0x0000 (---------------)  + I gov
	0x002170c3, // n0x125d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x125e c0x0000 (---------------)  + I org
	0x00200742, // n0x125f c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1260 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1261 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1262 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1263 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1264 c0x0000 (---------------)  + I org
	0x000e4188, // n0x1265 c0x0000 (---------------)  +   blogspot
	0x00201e82, // n0x1266 c0x0000 (---------------)  + I ac
	0x002aa2c4, // n0x1267 c0x0000 (---------------)  + I assn
	0x00222ac3, // n0x1268 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1269 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x126a c0x0000 (---------------)  + I gov
	0x00221d03, // n0x126b c0x0000 (---------------)  + I grp
	0x00294945, // n0x126c c0x0000 (---------------)  + I hotel
	0x00238c03, // n0x126d c0x0000 (---------------)  + I int
	0x003413c3, // n0x126e c0x0000 (---------------)  + I ltd
	0x002170c3, // n0x126f c0x0000 (---------------)  + I net
	0x00202303, // n0x1270 c0x0000 (---------------)  + I ngo
	0x0021dcc3, // n0x1271 c0x0000 (---------------)  + I org
	0x00206103, // n0x1272 c0x0000 (---------------)  + I sch
	0x00240a03, // n0x1273 c0x0000 (---------------)  + I soc
	0x00219fc3, // n0x1274 c0x0000 (---------------)  + I web
	0x00222ac3, // n0x1275 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1276 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1277 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1278 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1279 c0x0000 (---------------)  + I org
	0x00200742, // n0x127a c0x0000 (---------------)  + I co
	0x0021dcc3, // n0x127b c0x0000 (---------------)  + I org
	0x000e4188, // n0x127c c0x0000 (---------------)  +   blogspot
	0x0021e283, // n0x127d c0x0000 (---------------)  + I gov
	0x000e4188, // n0x127e c0x0000 (---------------)  +   blogspot
	0x002a00c3, // n0x127f c0x0000 (---------------)  + I asn
	0x00222ac3, // n0x1280 c0x0000 (---------------)  + I com
	0x00224984, // n0x1281 c0x0000 (---------------)  + I conf
	0x002d75c3, // n0x1282 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1283 c0x0000 (---------------)  + I gov
	0x00206202, // n0x1284 c0x0000 (---------------)  + I id
	0x0023fa03, // n0x1285 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1286 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1287 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x1288 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1289 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x128a c0x0000 (---------------)  + I gov
	0x00206202, // n0x128b c0x0000 (---------------)  + I id
	0x0020b403, // n0x128c c0x0000 (---------------)  + I med
	0x002170c3, // n0x128d c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x128e c0x0000 (---------------)  + I org
	0x002c65c3, // n0x128f c0x0000 (---------------)  + I plc
	0x00206103, // n0x1290 c0x0000 (---------------)  + I sch
	0x00201e82, // n0x1291 c0x0000 (---------------)  + I ac
	0x00200742, // n0x1292 c0x0000 (---------------)  + I co
	0x0021e283, // n0x1293 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1294 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1295 c0x0000 (---------------)  + I org
	0x0029abc5, // n0x1296 c0x0000 (---------------)  + I press
	0x002729c4, // n0x1297 c0x0000 (---------------)  + I asso
	0x00208902, // n0x1298 c0x0000 (---------------)  + I tm
	0x000e4188, // n0x1299 c0x0000 (---------------)  +   blogspot
	0x00201e82, // n0x129a c0x0000 (---------------)  + I ac
	0x00200742, // n0x129b c0x0000 (---------------)  + I co
	0x002d75c3, // n0x129c c0x0000 (---------------)  + I edu
	0x0021e283, // n0x129d c0x0000 (---------------)  + I gov
	0x00226ac3, // n0x129e c0x0000 (---------------)  + I its
	0x002170c3, // n0x129f c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x12a0 c0x0000 (---------------)  + I org
	0x002cba44, // n0x12a1 c0x0000 (---------------)  + I priv
	0x00222ac3, // n0x12a2 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x12a3 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x12a4 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x12a5 c0x0000 (---------------)  + I mil
	0x00207cc3, // n0x12a6 c0x0000 (---------------)  + I nom
	0x0021dcc3, // n0x12a7 c0x0000 (---------------)  + I org
	0x002ca783, // n0x12a8 c0x0000 (---------------)  + I prd
	0x00208902, // n0x12a9 c0x0000 (---------------)  + I tm
	0x000e4188, // n0x12aa c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x12ab c0x0000 (---------------)  + I com
	0x002d75c3, // n0x12ac c0x0000 (---------------)  + I edu
	0x0021e283, // n0x12ad c0x0000 (---------------)  + I gov
	0x00200303, // n0x12ae c0x0000 (---------------)  + I inf
	0x00298944, // n0x12af c0x0000 (---------------)  + I name
	0x002170c3, // n0x12b0 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x12b1 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x12b2 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x12b3 c0x0000 (---------------)  + I edu
	0x003579c4, // n0x12b4 c0x0000 (---------------)  + I gouv
	0x0021e283, // n0x12b5 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x12b6 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x12b7 c0x0000 (---------------)  + I org
	0x0029abc6, // n0x12b8 c0x0000 (---------------)  + I presse
	0x002d75c3, // n0x12b9 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x12ba c0x0000 (---------------)  + I gov
	0x00023403, // n0x12bb c0x0000 (---------------)  +   nyc
	0x0021dcc3, // n0x12bc c0x0000 (---------------)  + I org
	0x00222ac3, // n0x12bd c0x0000 (---------------)  + I com
	0x002d75c3, // n0x12be c0x0000 (---------------)  + I edu
	0x0021e283, // n0x12bf c0x0000 (---------------)  + I gov
	0x002170c3, // n0x12c0 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x12c1 c0x0000 (---------------)  + I org
	0x000e4188, // n0x12c2 c0x0000 (---------------)  +   blogspot
	0x0021e283, // n0x12c3 c0x0000 (---------------)  + I gov
	0x00222ac3, // n0x12c4 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x12c5 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x12c6 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x12c7 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x12c8 c0x0000 (---------------)  + I org
	0x35622ac3, // n0x12c9 c0x00d5 (n0x12cd-n0x12ce)  + I com
	0x002d75c3, // n0x12ca c0x0000 (---------------)  + I edu
	0x002170c3, // n0x12cb c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x12cc c0x0000 (---------------)  + I org
	0x000e4188, // n0x12cd c0x0000 (---------------)  +   blogspot
	0x00201e82, // n0x12ce c0x0000 (---------------)  + I ac
	0x00200742, // n0x12cf c0x0000 (---------------)  + I co
	0x00222ac3, // n0x12d0 c0x0000 (---------------)  + I com
	0x0021e283, // n0x12d1 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x12d2 c0x0000 (---------------)  + I net
	0x00200c42, // n0x12d3 c0x0000 (---------------)  + I or
	0x0021dcc3, // n0x12d4 c0x0000 (---------------)  + I org
	0x002f2787, // n0x12d5 c0x0000 (---------------)  + I academy
	0x0033c2cb, // n0x12d6 c0x0000 (---------------)  + I agriculture
	0x00205743, // n0x12d7 c0x0000 (---------------)  + I air
	0x0022c148, // n0x12d8 c0x0000 (---------------)  + I airguard
	0x0038bc07, // n0x12d9 c0x0000 (---------------)  + I alabama
	0x00267646, // n0x12da c0x0000 (---------------)  + I alaska
	0x002b6e85, // n0x12db c0x0000 (---------------)  + I amber
	0x003541c9, // n0x12dc c0x0000 (---------------)  + I ambulance
	0x002757c8, // n0x12dd c0x0000 (---------------)  + I american
	0x002757c9, // n0x12de c0x0000 (---------------)  + I americana
	0x002757d0, // n0x12df c0x0000 (---------------)  + I americanantiques
	0x0031aecb, // n0x12e0 c0x0000 (---------------)  + I americanart
	0x002b6cc9, // n0x12e1 c0x0000 (---------------)  + I amsterdam
	0x00208f03, // n0x12e2 c0x0000 (---------------)  + I and
	0x003228c9, // n0x12e3 c0x0000 (---------------)  + I annefrank
	0x00225786, // n0x12e4 c0x0000 (---------------)  + I anthro
	0x0022578c, // n0x12e5 c0x0000 (---------------)  + I anthropology
	0x00222588, // n0x12e6 c0x0000 (---------------)  + I antiques
	0x00392b08, // n0x12e7 c0x0000 (---------------)  + I aquarium
	0x00256f09, // n0x12e8 c0x0000 (---------------)  + I arboretum
	0x0029690e, // n0x12e9 c0x0000 (---------------)  + I archaeological
	0x003429cb, // n0x12ea c0x0000 (---------------)  + I archaeology
	0x002a52cc, // n0x12eb c0x0000 (---------------)  + I architecture
	0x00200603, // n0x12ec c0x0000 (---------------)  + I art
	0x0031b0cc, // n0x12ed c0x0000 (---------------)  + I artanddesign
	0x0037a6c9, // n0x12ee c0x0000 (---------------)  + I artcenter
	0x00200607, // n0x12ef c0x0000 (---------------)  + I artdeco
	0x0037548c, // n0x12f0 c0x0000 (---------------)  + I arteducation
	0x0022654a, // n0x12f1 c0x0000 (---------------)  + I artgallery
	0x00246584, // n0x12f2 c0x0000 (---------------)  + I arts
	0x0024658d, // n0x12f3 c0x0000 (---------------)  + I artsandcrafts
	0x0037a588, // n0x12f4 c0x0000 (---------------)  + I asmatart
	0x0034db0d, // n0x12f5 c0x0000 (---------------)  + I assassination
	0x0037ac46, // n0x12f6 c0x0000 (---------------)  + I assisi
	0x002bbacb, // n0x12f7 c0x0000 (---------------)  + I association
	0x0032b3c9, // n0x12f8 c0x0000 (---------------)  + I astronomy
	0x0032d947, // n0x12f9 c0x0000 (---------------)  + I atlanta
	0x0030ce46, // n0x12fa c0x0000 (---------------)  + I austin
	0x002ee489, // n0x12fb c0x0000 (---------------)  + I australia
	0x0030494a, // n0x12fc c0x0000 (---------------)  + I automotive
	0x00328bc8, // n0x12fd c0x0000 (---------------)  + I aviation
	0x0025db04, // n0x12fe c0x0000 (---------------)  + I axis
	0x0035ef47, // n0x12ff c0x0000 (---------------)  + I badajoz
	0x00264407, // n0x1300 c0x0000 (---------------)  + I baghdad
	0x00295f44, // n0x1301 c0x0000 (---------------)  + I bahn
	0x0023d9c4, // n0x1302 c0x0000 (---------------)  + I bale
	0x002708c9, // n0x1303 c0x0000 (---------------)  + I baltimore
	0x0036bf49, // n0x1304 c0x0000 (---------------)  + I barcelona
	0x002ed5c8, // n0x1305 c0x0000 (---------------)  + I baseball
	0x0020a445, // n0x1306 c0x0000 (---------------)  + I basel
	0x002dbe45, // n0x1307 c0x0000 (---------------)  + I baths
	0x00205a86, // n0x1308 c0x0000 (---------------)  + I bauern
	0x00246449, // n0x1309 c0x0000 (---------------)  + I beauxarts
	0x0035a18d, // n0x130a c0x0000 (---------------)  + I beeldengeluid
	0x002a4d48, // n0x130b c0x0000 (---------------)  + I bellevue
	0x00205987, // n0x130c c0x0000 (---------------)  + I bergbau
	0x002b6f08, // n0x130d c0x0000 (---------------)  + I berkeley
	0x00251d46, // n0x130e c0x0000 (---------------)  + I berlin
	0x00353844, // n0x130f c0x0000 (---------------)  + I bern
	0x003628c5, // n0x1310 c0x0000 (---------------)  + I bible
	0x00394a46, // n0x1311 c0x0000 (---------------)  + I bilbao
	0x00396b04, // n0x1312 c0x0000 (---------------)  + I bill
	0x00200507, // n0x1313 c0x0000 (---------------)  + I birdart
	0x00201cca, // n0x1314 c0x0000 (---------------)  + I birthplace
	0x0020bcc4, // n0x1315 c0x0000 (---------------)  + I bonn
	0x0020d686, // n0x1316 c0x0000 (---------------)  + I boston
	0x0020e2c9, // n0x1317 c0x0000 (---------------)  + I botanical
	0x0020e2cf, // n0x1318 c0x0000 (---------------)  + I botanicalgarden
	0x0020e88d, // n0x1319 c0x0000 (---------------)  + I botanicgarden
	0x002107c6, // n0x131a c0x0000 (---------------)  + I botany
	0x00213b10, // n0x131b c0x0000 (---------------)  + I brandywinevalley
	0x00214a86, // n0x131c c0x0000 (---------------)  + I brasil
	0x002159c7, // n0x131d c0x0000 (---------------)  + I bristol
	0x00215d47, // n0x131e c0x0000 (---------------)  + I british
	0x00215d4f, // n0x131f c0x0000 (---------------)  + I britishcolumbia
	0x00216d09, // n0x1320 c0x0000 (---------------)  + I broadcast
	0x0021b106, // n0x1321 c0x0000 (---------------)  + I brunel
	0x0021be87, // n0x1322 c0x0000 (---------------)  + I brussel
	0x0021be88, // n0x1323 c0x0000 (---------------)  + I brussels
	0x0021c809, // n0x1324 c0x0000 (---------------)  + I bruxelles
	0x002c67c8, // n0x1325 c0x0000 (---------------)  + I building
	0x002c2fc7, // n0x1326 c0x0000 (---------------)  + I burghof
	0x002224c3, // n0x1327 c0x0000 (---------------)  + I bus
	0x00280c46, // n0x1328 c0x0000 (---------------)  + I bushey
	0x0027d948, // n0x1329 c0x0000 (---------------)  + I cadaques
	0x00296bca, // n0x132a c0x0000 (---------------)  + I california
	0x0021a089, // n0x132b c0x0000 (---------------)  + I cambridge
	0x00208ec3, // n0x132c c0x0000 (---------------)  + I can
	0x00309786, // n0x132d c0x0000 (---------------)  + I canada
	0x0024de4a, // n0x132e c0x0000 (---------------)  + I capebreton
	0x0031bb87, // n0x132f c0x0000 (---------------)  + I carrier
	0x003752ca, // n0x1330 c0x0000 (---------------)  + I cartoonart
	0x0038390e, // n0x1331 c0x0000 (---------------)  + I casadelamoneda
	0x00216e46, // n0x1332 c0x0000 (---------------)  + I castle
	0x0021c487, // n0x1333 c0x0000 (---------------)  + I castres
	0x0020f006, // n0x1334 c0x0000 (---------------)  + I celtic
	0x00233a06, // n0x1335 c0x0000 (---------------)  + I center
	0x0036240b, // n0x1336 c0x0000 (---------------)  + I chattanooga
	0x002503ca, // n0x1337 c0x0000 (---------------)  + I cheltenham
	0x002eeccd, // n0x1338 c0x0000 (---------------)  + I chesapeakebay
	0x0034e9c7, // n0x1339 c0x0000 (---------------)  + I chicago
	0x00262bc8, // n0x133a c0x0000 (---------------)  + I children
	0x00262bc9, // n0x133b c0x0000 (---------------)  + I childrens
	0x00262bcf, // n0x133c c0x0000 (---------------)  + I childrensgarden
	0x0029300c, // n0x133d c0x0000 (---------------)  + I chiropractic
	0x00299309, // n0x133e c0x0000 (---------------)  + I chocolate
	0x0022d30e, // n0x133f c0x0000 (---------------)  + I christiansburg
	0x002754ca, // n0x1340 c0x0000 (---------------)  + I cincinnati
	0x00343506, // n0x1341 c0x0000 (---------------)  + I cinema
	0x00323506, // n0x1342 c0x0000 (---------------)  + I circus
	0x0034564c, // n0x1343 c0x0000 (---------------)  + I civilisation
	0x0034878c, // n0x1344 c0x0000 (---------------)  + I civilization
	0x003518c8, // n0x1345 c0x0000 (---------------)  + I civilwar
	0x00369707, // n0x1346 c0x0000 (---------------)  + I clinton
	0x0020af45, // n0x1347 c0x0000 (---------------)  + I clock
	0x00387ec4, // n0x1348 c0x0000 (---------------)  + I coal
	0x0032ac0e, // n0x1349 c0x0000 (---------------)  + I coastaldefence
	0x00200744, // n0x134a c0x0000 (---------------)  + I cody
	0x00232107, // n0x134b c0x0000 (---------------)  + I coldwar
	0x0024f38a, // n0x134c c0x0000 (---------------)  + I collection
	0x00221854, // n0x134d c0x0000 (---------------)  + I colonialwilliamsburg
	0x00221f0f, // n0x134e c0x0000 (---------------)  + I coloradoplateau
	0x00215f08, // n0x134f c0x0000 (---------------)  + I columbia
	0x00222388, // n0x1350 c0x0000 (---------------)  + I columbus
	0x002b354d, // n0x1351 c0x0000 (---------------)  + I communication
	0x002b354e, // n0x1352 c0x0000 (---------------)  + I communications
	0x00222ac9, // n0x1353 c0x0000 (---------------)  + I community
	0x002236c8, // n0x1354 c0x0000 (---------------)  + I computer
	0x002236cf, // n0x1355 c0x0000 (---------------)  + I computerhistory
	0x0022624c, // n0x1356 c0x0000 (---------------)  + I contemporary
	0x0022624f, // n0x1357 c0x0000 (---------------)  + I contemporaryart
	0x00227187, // n0x1358 c0x0000 (---------------)  + I convent
	0x00229bca, // n0x1359 c0x0000 (---------------)  + I copenhagen
	0x0021300b, // n0x135a c0x0000 (---------------)  + I corporation
	0x0022b908, // n0x135b c0x0000 (---------------)  + I corvette
	0x0022c347, // n0x135c c0x0000 (---------------)  + I costume
	0x00362c0d, // n0x135d c0x0000 (---------------)  + I countryestate
	0x002f8886, // n0x135e c0x0000 (---------------)  + I county
	0x00246746, // n0x135f c0x0000 (---------------)  + I crafts
	0x0022f189, // n0x1360 c0x0000 (---------------)  + I cranbrook
	0x002e63c8, // n0x1361 c0x0000 (---------------)  + I creation
	0x00233808, // n0x1362 c0x0000 (---------------)  + I cultural
	0x0023380e, // n0x1363 c0x0000 (---------------)  + I culturalcenter
	0x00323687, // n0x1364 c0x0000 (---------------)  + I culture
	0x00343d85, // n0x1365 c0x0000 (---------------)  + I cyber
	0x002dcac5, // n0x1366 c0x0000 (---------------)  + I cymru
	0x00270d04, // n0x1367 c0x0000 (---------------)  + I dali
	0x00267906, // n0x1368 c0x0000 (---------------)  + I dallas
	0x002ed4c8, // n0x1369 c0x0000 (---------------)  + I database
	0x0034d6c3, // n0x136a c0x0000 (---------------)  + I ddr
	0x00255ace, // n0x136b c0x0000 (---------------)  + I decorativearts
	0x00362fc8, // n0x136c c0x0000 (---------------)  + I delaware
	0x0029f90b, // n0x136d c0x0000 (---------------)  + I delmenhorst
	0x00311707, // n0x136e c0x0000 (---------------)  + I denmark
	0x002b8f85, // n0x136f c0x0000 (---------------)  + I depot
	0x00232f46, // n0x1370 c0x0000 (---------------)  + I design
	0x00295507, // n0x1371 c0x0000 (---------------)  + I detroit
	0x002dff48, // n0x1372 c0x0000 (---------------)  + I dinosaur
	0x00304c89, // n0x1373 c0x0000 (---------------)  + I discovery
	0x002250c5, // n0x1374 c0x0000 (---------------)  + I dolls
	0x00274888, // n0x1375 c0x0000 (---------------)  + I donostia
	0x0038a206, // n0x1376 c0x0000 (---------------)  + I durham
	0x00367b0a, // n0x1377 c0x0000 (---------------)  + I eastafrica
	0x0032ab09, // n0x1378 c0x0000 (---------------)  + I eastcoast
	0x00375549, // n0x1379 c0x0000 (---------------)  + I education
	0x0037554b, // n0x137a c0x0000 (---------------)  + I educational
	0x002958c8, // n0x137b c0x0000 (---------------)  + I egyptian
	0x00295e09, // n0x137c c0x0000 (---------------)  + I eisenbahn
	0x0020a506, // n0x137d c0x0000 (---------------)  + I elburg
	0x0034cf0a, // n0x137e c0x0000 (---------------)  + I elvendrell
	0x0032af4a, // n0x137f c0x0000 (---------------)  + I embroidery
	0x00229dcc, // n0x1380 c0x0000 (---------------)  + I encyclopedic
	0x0037b187, // n0x1381 c0x0000 (---------------)  + I england
	0x00384a8a, // n0x1382 c0x0000 (---------------)  + I entomology
	0x0030de4b, // n0x1383 c0x0000 (---------------)  + I environment
	0x0030de59, // n0x1384 c0x0000 (---------------)  + I environmentalconservation
	0x003543c8, // n0x1385 c0x0000 (---------------)  + I epilepsy
	0x0029ac45, // n0x1386 c0x0000 (---------------)  + I essex
	0x002b1846, // n0x1387 c0x0000 (---------------)  + I estate
	0x002f6409, // n0x1388 c0x0000 (---------------)  + I ethnology
	0x0020bb46, // n0x1389 c0x0000 (---------------)  + I exeter
	0x00326eca, // n0x138a c0x0000 (---------------)  + I exhibition
	0x00311c06, // n0x138b c0x0000 (---------------)  + I family
	0x0021f804, // n0x138c c0x0000 (---------------)  + I farm
	0x0021f80d, // n0x138d c0x0000 (---------------)  + I farmequipment
	0x00366b07, // n0x138e c0x0000 (---------------)  + I farmers
	0x002fb8c9, // n0x138f c0x0000 (---------------)  + I farmstead
	0x002099c5, // n0x1390 c0x0000 (---------------)  + I field
	0x00338588, // n0x1391 c0x0000 (---------------)  + I figueres
	0x00349f49, // n0x1392 c0x0000 (---------------)  + I filatelia
	0x00356104, // n0x1393 c0x0000 (---------------)  + I film
	0x003707c7, // n0x1394 c0x0000 (---------------)  + I fineart
	0x003707c8, // n0x1395 c0x0000 (---------------)  + I finearts
	0x00236407, // n0x1396 c0x0000 (---------------)  + I finland
	0x00252b88, // n0x1397 c0x0000 (---------------)  + I flanders
	0x0023c447, // n0x1398 c0x0000 (---------------)  + I florida
	0x002e7685, // n0x1399 c0x0000 (---------------)  + I force
	0x002457cc, // n0x139a c0x0000 (---------------)  + I fortmissoula
	0x00245e89, // n0x139b c0x0000 (---------------)  + I fortworth
	0x00303b8a, // n0x139c c0x0000 (---------------)  + I foundation
	0x00377209, // n0x139d c0x0000 (---------------)  + I francaise
	0x003229c9, // n0x139e c0x0000 (---------------)  + I frankfurt
	0x0035268c, // n0x139f c0x0000 (---------------)  + I franziskaner
	0x00209c8b, // n0x13a0 c0x0000 (---------------)  + I freemasonry
	0x00248cc8, // n0x13a1 c0x0000 (---------------)  + I freiburg
	0x002493c8, // n0x13a2 c0x0000 (---------------)  + I fribourg
	0x0024c784, // n0x13a3 c0x0000 (---------------)  + I frog
	0x0026fc08, // n0x13a4 c0x0000 (---------------)  + I fundacio
	0x00272f09, // n0x13a5 c0x0000 (---------------)  + I furniture
	0x00226607, // n0x13a6 c0x0000 (---------------)  + I gallery
	0x0020e506, // n0x13a7 c0x0000 (---------------)  + I garden
	0x0021a607, // n0x13a8 c0x0000 (---------------)  + I gateway
	0x00268b89, // n0x13a9 c0x0000 (---------------)  + I geelvinck
	0x002a634b, // n0x13aa c0x0000 (---------------)  + I gemological
	0x00309a87, // n0x13ab c0x0000 (---------------)  + I geology
	0x002f8287, // n0x13ac c0x0000 (---------------)  + I georgia
	0x00267387, // n0x13ad c0x0000 (---------------)  + I giessen
	0x0034da84, // n0x13ae c0x0000 (---------------)  + I glas
	0x0034da85, // n0x13af c0x0000 (---------------)  + I glass
	0x00292d05, // n0x13b0 c0x0000 (---------------)  + I gorge
	0x00320b0b, // n0x13b1 c0x0000 (---------------)  + I grandrapids
	0x00380d44, // n0x13b2 c0x0000 (---------------)  + I graz
	0x002e6b48, // n0x13b3 c0x0000 (---------------)  + I guernsey
	0x002a19ca, // n0x13b4 c0x0000 (---------------)  + I halloffame
	0x0038a2c7, // n0x13b5 c0x0000 (---------------)  + I hamburg
	0x00372047, // n0x13b6 c0x0000 (---------------)  + I handson
	0x0027a252, // n0x13b7 c0x0000 (---------------)  + I harvestcelebration
	0x00256386, // n0x13b8 c0x0000 (---------------)  + I hawaii
	0x00205e06, // n0x13b9 c0x0000 (---------------)  + I health
	0x002f518e, // n0x13ba c0x0000 (---------------)  + I heimatunduhren
	0x00257ac6, // n0x13bb c0x0000 (---------------)  + I hellas
	0x00209408, // n0x13bc c0x0000 (---------------)  + I helsinki
	0x0027f4cf, // n0x13bd c0x0000 (---------------)  + I hembygdsforbund
	0x0034dec8, // n0x13be c0x0000 (---------------)  + I heritage
	0x0025de08, // n0x13bf c0x0000 (---------------)  + I histoire
	0x002a794a, // n0x13c0 c0x0000 (---------------)  + I historical
	0x002a7951, // n0x13c1 c0x0000 (---------------)  + I historicalsociety
	0x0028cfce, // n0x13c2 c0x0000 (---------------)  + I historichouses
	0x0024268a, // n0x13c3 c0x0000 (---------------)  + I historisch
	0x0024268c, // n0x13c4 c0x0000 (---------------)  + I historisches
	0x002238c7, // n0x13c5 c0x0000 (---------------)  + I history
	0x002238d0, // n0x13c6 c0x0000 (---------------)  + I historyofscience
	0x0038f308, // n0x13c7 c0x0000 (---------------)  + I horology
	0x0021da05, // n0x13c8 c0x0000 (---------------)  + I house
	0x002d8f0a, // n0x13c9 c0x0000 (---------------)  + I humanities
	0x00396b4c, // n0x13ca c0x0000 (---------------)  + I illustration
	0x003365cd, // n0x13cb c0x0000 (---------------)  + I imageandsound
	0x002d5b06, // n0x13cc c0x0000 (---------------)  + I indian
	0x002d5b07, // n0x13cd c0x0000 (---------------)  + I indiana
	0x002d5b0c, // n0x13ce c0x0000 (---------------)  + I indianapolis
	0x00356ecc, // n0x13cf c0x0000 (---------------)  + I indianmarket
	0x00238c0c, // n0x13d0 c0x0000 (---------------)  + I intelligence
	0x0027d28b, // n0x13d1 c0x0000 (---------------)  + I interactive
	0x00273f44, // n0x13d2 c0x0000 (---------------)  + I iraq
	0x0021afc4, // n0x13d3 c0x0000 (---------------)  + I iron
	0x00357ec9, // n0x13d4 c0x0000 (---------------)  + I isleofman
	0x002bc087, // n0x13d5 c0x0000 (---------------)  + I jamison
	0x002207c9, // n0x13d6 c0x0000 (---------------)  + I jefferson
	0x00337649, // n0x13d7 c0x0000 (---------------)  + I jerusalem
	0x0034f487, // n0x13d8 c0x0000 (---------------)  + I jewelry
	0x0038cb46, // n0x13d9 c0x0000 (---------------)  + I jewish
	0x0038cb49, // n0x13da c0x0000 (---------------)  + I jewishart
	0x00297743, // n0x13db c0x0000 (---------------)  + I jfk
	0x0028540a, // n0x13dc c0x0000 (---------------)  + I journalism
	0x0036e9c7, // n0x13dd c0x0000 (---------------)  + I judaica
	0x0035f38b, // n0x13de c0x0000 (---------------)  + I judygarland
	0x002eeb4a, // n0x13df c0x0000 (---------------)  + I juedisches
	0x00370c84, // n0x13e0 c0x0000 (---------------)  + I juif
	0x002df386, // n0x13e1 c0x0000 (---------------)  + I karate
	0x002af549, // n0x13e2 c0x0000 (---------------)  + I karikatur
	0x00394c44, // n0x13e3 c0x0000 (---------------)  + I kids
	0x0033e24a, // n0x13e4 c0x0000 (---------------)  + I koebenhavn
	0x0021f385, // n0x13e5 c0x0000 (---------------)  + I koeln
	0x002a3845, // n0x13e6 c0x0000 (---------------)  + I kunst
	0x002a384d, // n0x13e7 c0x0000 (---------------)  + I kunstsammlung
	0x002a3b8e, // n0x13e8 c0x0000 (---------------)  + I kunstunddesign
	0x002feec5, // n0x13e9 c0x0000 (---------------)  + I labor
	0x0037c986, // n0x13ea c0x0000 (---------------)  + I labour
	0x00323a07, // n0x13eb c0x0000 (---------------)  + I lajolla
	0x00261a4a, // n0x13ec c0x0000 (---------------)  + I lancashire
	0x0035b146, // n0x13ed c0x0000 (---------------)  + I landes
	0x002856c4, // n0x13ee c0x0000 (---------------)  + I lans
	0x002d0287, // n0x13ef c0x0000 (---------------)  + I larsson
	0x0029eacb, // n0x13f0 c0x0000 (---------------)  + I lewismiller
	0x00251e07, // n0x13f1 c0x0000 (---------------)  + I lincoln
	0x00329ac4, // n0x13f2 c0x0000 (---------------)  + I linz
	0x002a1d46, // n0x13f3 c0x0000 (---------------)  + I living
	0x002a1d4d, // n0x13f4 c0x0000 (---------------)  + I livinghistory
	0x0032254c, // n0x13f5 c0x0000 (---------------)  + I localhistory
	0x00340906, // n0x13f6 c0x0000 (---------------)  + I london
	0x002a4f4a, // n0x13f7 c0x0000 (---------------)  + I losangeles
	0x002116c6, // n0x13f8 c0x0000 (---------------)  + I louvre
	0x00259d88, // n0x13f9 c0x0000 (---------------)  + I loyalist
	0x0021d747, // n0x13fa c0x0000 (---------------)  + I lucerne
	0x00222d8a, // n0x13fb c0x0000 (---------------)  + I luxembourg
	0x00226c86, // n0x13fc c0x0000 (---------------)  + I luzern
	0x0026b0c3, // n0x13fd c0x0000 (---------------)  + I mad
	0x00300a86, // n0x13fe c0x0000 (---------------)  + I madrid
	0x0026aa08, // n0x13ff c0x0000 (---------------)  + I mallorca
	0x0028608a, // n0x1400 c0x0000 (---------------)  + I manchester
	0x00266747, // n0x1401 c0x0000 (---------------)  + I mansion
	0x00266748, // n0x1402 c0x0000 (---------------)  + I mansions
	0x0026d784, // n0x1403 c0x0000 (---------------)  + I manx
	0x00277287, // n0x1404 c0x0000 (---------------)  + I marburg
	0x0036ee48, // n0x1405 c0x0000 (---------------)  + I maritime
	0x00237048, // n0x1406 c0x0000 (---------------)  + I maritimo
	0x00256588, // n0x1407 c0x0000 (---------------)  + I maryland
	0x003372ca, // n0x1408 c0x0000 (---------------)  + I marylhurst
	0x002dc385, // n0x1409 c0x0000 (---------------)  + I media
	0x002e7087, // n0x140a c0x0000 (---------------)  + I medical
	0x002424d3, // n0x140b c0x0000 (---------------)  + I medizinhistorisches
	0x00257946, // n0x140c c0x0000 (---------------)  + I meeres
	0x002edac8, // n0x140d c0x0000 (---------------)  + I memorial
	0x00219509, // n0x140e c0x0000 (---------------)  + I mesaverde
	0x00204988, // n0x140f c0x0000 (---------------)  + I michigan
	0x002892cb, // n0x1410 c0x0000 (---------------)  + I midatlantic
	0x002a6948, // n0x1411 c0x0000 (---------------)  + I military
	0x0029ec04, // n0x1412 c0x0000 (---------------)  + I mill
	0x002878c6, // n0x1413 c0x0000 (---------------)  + I miners
	0x002e7a46, // n0x1414 c0x0000 (---------------)  + I mining
	0x00335b09, // n0x1415 c0x0000 (---------------)  + I minnesota
	0x002ad807, // n0x1416 c0x0000 (---------------)  + I missile
	0x002458c8, // n0x1417 c0x0000 (---------------)  + I missoula
	0x00291a06, // n0x1418 c0x0000 (---------------)  + I modern
	0x0021cfc4, // n0x1419 c0x0000 (---------------)  + I moma
	0x002b6185, // n0x141a c0x0000 (---------------)  + I money
	0x002b02c8, // n0x141b c0x0000 (---------------)  + I monmouth
	0x002b094a, // n0x141c c0x0000 (---------------)  + I monticello
	0x002b1648, // n0x141d c0x0000 (---------------)  + I montreal
	0x002b68c6, // n0x141e c0x0000 (---------------)  + I moscow
	0x0028678a, // n0x141f c0x0000 (---------------)  + I motorcycle
	0x002f3cc8, // n0x1420 c0x0000 (---------------)  + I muenchen
	0x002b9948, // n0x1421 c0x0000 (---------------)  + I muenster
	0x002ba948, // n0x1422 c0x0000 (---------------)  + I mulhouse
	0x002bb346, // n0x1423 c0x0000 (---------------)  + I muncie
	0x002bd186, // n0x1424 c0x0000 (---------------)  + I museet
	0x0030e7cc, // n0x1425 c0x0000 (---------------)  + I museumcenter
	0x002bd650, // n0x1426 c0x0000 (---------------)  + I museumvereniging
	0x00337b85, // n0x1427 c0x0000 (---------------)  + I music
	0x002dd9c8, // n0x1428 c0x0000 (---------------)  + I national
	0x002dd9d0, // n0x1429 c0x0000 (---------------)  + I nationalfirearms
	0x0034dcd0, // n0x142a c0x0000 (---------------)  + I nationalheritage
	0x0027564e, // n0x142b c0x0000 (---------------)  + I nativeamerican
	0x0030e44e, // n0x142c c0x0000 (---------------)  + I naturalhistory
	0x0030e454, // n0x142d c0x0000 (---------------)  + I naturalhistorymuseum
	0x00240dcf, // n0x142e c0x0000 (---------------)  + I naturalsciences
	0x00241186, // n0x142f c0x0000 (---------------)  + I nature
	0x002f4951, // n0x1430 c0x0000 (---------------)  + I naturhistorisches
	0x0031cfd3, // n0x1431 c0x0000 (---------------)  + I natuurwetenschappen
	0x0031d448, // n0x1432 c0x0000 (---------------)  + I naumburg
	0x00341c05, // n0x1433 c0x0000 (---------------)  + I naval
	0x00262448, // n0x1434 c0x0000 (---------------)  + I nebraska
	0x0021d585, // n0x1435 c0x0000 (---------------)  + I neues
	0x002e60cc, // n0x1436 c0x0000 (---------------)  + I newhampshire
	0x00221609, // n0x1437 c0x0000 (---------------)  + I newjersey
	0x00231f49, // n0x1438 c0x0000 (---------------)  + I newmexico
	0x0021a387, // n0x1439 c0x0000 (---------------)  + I newport
	0x00366d49, // n0x143a c0x0000 (---------------)  + I newspaper
	0x00237f07, // n0x143b c0x0000 (---------------)  + I newyork
	0x00203d46, // n0x143c c0x0000 (---------------)  + I niepce
	0x003626c7, // n0x143d c0x0000 (---------------)  + I norfolk
	0x002f0dc5, // n0x143e c0x0000 (---------------)  + I north
	0x00345903, // n0x143f c0x0000 (---------------)  + I nrw
	0x0034d889, // n0x1440 c0x0000 (---------------)  + I nuernberg
	0x002e9309, // n0x1441 c0x0000 (---------------)  + I nuremberg
	0x00223403, // n0x1442 c0x0000 (---------------)  + I nyc
	0x002108c4, // n0x1443 c0x0000 (---------------)  + I nyny
	0x0034100d, // n0x1444 c0x0000 (---------------)  + I oceanographic
	0x0034384f, // n0x1445 c0x0000 (---------------)  + I oceanographique
	0x002e3085, // n0x1446 c0x0000 (---------------)  + I omaha
	0x003023c6, // n0x1447 c0x0000 (---------------)  + I online
	0x0032a587, // n0x1448 c0x0000 (---------------)  + I ontario
	0x0032ce07, // n0x1449 c0x0000 (---------------)  + I openair
	0x00276b86, // n0x144a c0x0000 (---------------)  + I oregon
	0x00276b8b, // n0x144b c0x0000 (---------------)  + I oregontrail
	0x0028e6c5, // n0x144c c0x0000 (---------------)  + I otago
	0x00364046, // n0x144d c0x0000 (---------------)  + I oxford
	0x0031ba07, // n0x144e c0x0000 (---------------)  + I pacific
	0x0025d709, // n0x144f c0x0000 (---------------)  + I paderborn
	0x0036ce06, // n0x1450 c0x0000 (---------------)  + I palace
	0x002052c5, // n0x1451 c0x0000 (---------------)  + I paleo
	0x00324b4b, // n0x1452 c0x0000 (---------------)  + I palmsprings
	0x00221d86, // n0x1453 c0x0000 (---------------)  + I panama
	0x0025b445, // n0x1454 c0x0000 (---------------)  + I paris
	0x002a3348, // n0x1455 c0x0000 (---------------)  + I pasadena
	0x002dc948, // n0x1456 c0x0000 (---------------)  + I pharmacy
	0x0036150c, // n0x1457 c0x0000 (---------------)  + I philadelphia
	0x00361510, // n0x1458 c0x0000 (---------------)  + I philadelphiaarea
	0x002bf909, // n0x1459 c0x0000 (---------------)  + I philately
	0x002bfd47, // n0x145a c0x0000 (---------------)  + I phoenix
	0x002c014b, // n0x145b c0x0000 (---------------)  + I photography
	0x002c1506, // n0x145c c0x0000 (---------------)  + I pilots
	0x002c2e8a, // n0x145d c0x0000 (---------------)  + I pittsburgh
	0x002c438b, // n0x145e c0x0000 (---------------)  + I planetarium
	0x002c4bca, // n0x145f c0x0000 (---------------)  + I plantation
	0x002c4e46, // n0x1460 c0x0000 (---------------)  + I plants
	0x002c6485, // n0x1461 c0x0000 (---------------)  + I plaza
	0x0036e706, // n0x1462 c0x0000 (---------------)  + I portal
	0x00266f08, // n0x1463 c0x0000 (---------------)  + I portland
	0x0021a44a, // n0x1464 c0x0000 (---------------)  + I portlligat
	0x002b31dc, // n0x1465 c0x0000 (---------------)  + I posts-and-telecommunications
	0x002ca84c, // n0x1466 c0x0000 (---------------)  + I preservation
	0x002cab48, // n0x1467 c0x0000 (---------------)  + I presidio
	0x0029abc5, // n0x1468 c0x0000 (---------------)  + I press
	0x002cc587, // n0x1469 c0x0000 (---------------)  + I project
	0x00296546, // n0x146a c0x0000 (---------------)  + I public
	0x0034c905, // n0x146b c0x0000 (---------------)  + I pubol
	0x00211186, // n0x146c c0x0000 (---------------)  + I quebec
	0x00276d48, // n0x146d c0x0000 (---------------)  + I railroad
	0x00253fc7, // n0x146e c0x0000 (---------------)  + I railway
	0x00296808, // n0x146f c0x0000 (---------------)  + I research
	0x0021c58a, // n0x1470 c0x0000 (---------------)  + I resistance
	0x0033cb8c, // n0x1471 c0x0000 (---------------)  + I riodejaneiro
	0x0033ce09, // n0x1472 c0x0000 (---------------)  + I rochester
	0x00201707, // n0x1473 c0x0000 (---------------)  + I rockart
	0x0023fb84, // n0x1474 c0x0000 (---------------)  + I roma
	0x0023afc6, // n0x1475 c0x0000 (---------------)  + I russia
	0x002c508a, // n0x1476 c0x0000 (---------------)  + I saintlouis
	0x00337745, // n0x1477 c0x0000 (---------------)  + I salem
	0x0034250c, // n0x1478 c0x0000 (---------------)  + I salvadordali
	0x0034ec88, // n0x1479 c0x0000 (---------------)  + I salzburg
	0x00270ec8, // n0x147a c0x0000 (---------------)  + I sandiego
	0x0023774c, // n0x147b c0x0000 (---------------)  + I sanfrancisco
	0x0020bfcc, // n0x147c c0x0000 (---------------)  + I santabarbara
	0x0020c3c9, // n0x147d c0x0000 (---------------)  + I santacruz
	0x0020c607, // n0x147e c0x0000 (---------------)  + I santafe
	0x0035768c, // n0x147f c0x0000 (---------------)  + I saskatchewan
	0x002251c4, // n0x1480 c0x0000 (---------------)  + I satx
	0x0022de0a, // n0x1481 c0x0000 (---------------)  + I savannahga
	0x0020cb8c, // n0x1482 c0x0000 (---------------)  + I schlesisches
	0x00354a4b, // n0x1483 c0x0000 (---------------)  + I schoenbrunn
	0x0025e7cb, // n0x1484 c0x0000 (---------------)  + I schokoladen
	0x00235406, // n0x1485 c0x0000 (---------------)  + I school
	0x0023b2c7, // n0x1486 c0x0000 (---------------)  + I schweiz
	0x00223b07, // n0x1487 c0x0000 (---------------)  + I science
	0x00223b0f, // n0x1488 c0x0000 (---------------)  + I science-fiction
	0x002d6251, // n0x1489 c0x0000 (---------------)  + I scienceandhistory
	0x0037f9d2, // n0x148a c0x0000 (---------------)  + I scienceandindustry
	0x0023ce0d, // n0x148b c0x0000 (---------------)  + I sciencecenter
	0x0023ce0e, // n0x148c c0x0000 (---------------)  + I sciencecenters
	0x0023d14e, // n0x148d c0x0000 (---------------)  + I sciencehistory
	0x00240f88, // n0x148e c0x0000 (---------------)  + I sciences
	0x00240f92, // n0x148f c0x0000 (---------------)  + I sciencesnaturelles
	0x00237988, // n0x1490 c0x0000 (---------------)  + I scotland
	0x002dfc87, // n0x1491 c0x0000 (---------------)  + I seaport
	0x0023920a, // n0x1492 c0x0000 (---------------)  + I settlement
	0x0020fb88, // n0x1493 c0x0000 (---------------)  + I settlers
	0x00257a85, // n0x1494 c0x0000 (---------------)  + I shell
	0x0025918a, // n0x1495 c0x0000 (---------------)  + I sherbrooke
	0x0037ad47, // n0x1496 c0x0000 (---------------)  + I sibenik
	0x0036b904, // n0x1497 c0x0000 (---------------)  + I silk
	0x00207b43, // n0x1498 c0x0000 (---------------)  + I ski
	0x002e3345, // n0x1499 c0x0000 (---------------)  + I skole
	0x002a7bc7, // n0x149a c0x0000 (---------------)  + I society
	0x002d84c7, // n0x149b c0x0000 (---------------)  + I sologne
	0x003367ce, // n0x149c c0x0000 (---------------)  + I soundandvision
	0x0031f30d, // n0x149d c0x0000 (---------------)  + I southcarolina
	0x00320d89, // n0x149e c0x0000 (---------------)  + I southwest
	0x002101c5, // n0x149f c0x0000 (---------------)  + I space
	0x00349a43, // n0x14a0 c0x0000 (---------------)  + I spy
	0x00275b86, // n0x14a1 c0x0000 (---------------)  + I square
	0x00248205, // n0x14a2 c0x0000 (---------------)  + I stadt
	0x0029fb48, // n0x14a3 c0x0000 (---------------)  + I stalbans
	0x00232449, // n0x14a4 c0x0000 (---------------)  + I starnberg
	0x002b1885, // n0x14a5 c0x0000 (---------------)  + I state
	0x00362e0f, // n0x14a6 c0x0000 (---------------)  + I stateofdelaware
	0x002c62c7, // n0x14a7 c0x0000 (---------------)  + I station
	0x00354105, // n0x14a8 c0x0000 (---------------)  + I steam
	0x002f2f8a, // n0x14a9 c0x0000 (---------------)  + I steiermark
	0x002a83c6, // n0x14aa c0x0000 (---------------)  + I stjohn
	0x00259f09, // n0x14ab c0x0000 (---------------)  + I stockholm
	0x002cf98c, // n0x14ac c0x0000 (---------------)  + I stpetersburg
	0x002d0749, // n0x14ad c0x0000 (---------------)  + I stuttgart
	0x00211e46, // n0x14ae c0x0000 (---------------)  + I suisse
	0x002a17cc, // n0x14af c0x0000 (---------------)  + I surgeonshall
	0x002d1c86, // n0x14b0 c0x0000 (---------------)  + I surrey
	0x002d4988, // n0x14b1 c0x0000 (---------------)  + I svizzera
	0x002d4b86, // n0x14b2 c0x0000 (---------------)  + I sweden
	0x00368086, // n0x14b3 c0x0000 (---------------)  + I sydney
	0x0024ca44, // n0x14b4 c0x0000 (---------------)  + I tank
	0x00249043, // n0x14b5 c0x0000 (---------------)  + I tcm
	0x0029d58a, // n0x14b6 c0x0000 (---------------)  + I technology
	0x002994d1, // n0x14b7 c0x0000 (---------------)  + I telekommunikation
	0x00248a4a, // n0x14b8 c0x0000 (---------------)  + I television
	0x00209085, // n0x14b9 c0x0000 (---------------)  + I texas
	0x00326307, // n0x14ba c0x0000 (---------------)  + I textile
	0x002f9147, // n0x14bb c0x0000 (---------------)  + I theater
	0x0036ef44, // n0x14bc c0x0000 (---------------)  + I time
	0x0036ef4b, // n0x14bd c0x0000 (---------------)  + I timekeeping
	0x0035e408, // n0x14be c0x0000 (---------------)  + I topology
	0x0029f3c6, // n0x14bf c0x0000 (---------------)  + I torino
	0x002e9685, // n0x14c0 c0x0000 (---------------)  + I touch
	0x0021abc4, // n0x14c1 c0x0000 (---------------)  + I town
	0x0027c9c9, // n0x14c2 c0x0000 (---------------)  + I transport
	0x00242e84, // n0x14c3 c0x0000 (---------------)  + I tree
	0x00211c47, // n0x14c4 c0x0000 (---------------)  + I trolley
	0x00313185, // n0x14c5 c0x0000 (---------------)  + I trust
	0x00313187, // n0x14c6 c0x0000 (---------------)  + I trustee
	0x002f53c5, // n0x14c7 c0x0000 (---------------)  + I uhren
	0x00213f43, // n0x14c8 c0x0000 (---------------)  + I ulm
	0x002dfb48, // n0x14c9 c0x0000 (---------------)  + I undersea
	0x0029f04a, // n0x14ca c0x0000 (---------------)  + I university
	0x00222503, // n0x14cb c0x0000 (---------------)  + I usa
	0x0022250a, // n0x14cc c0x0000 (---------------)  + I usantiques
	0x0038c1c6, // n0x14cd c0x0000 (---------------)  + I usarts
	0x00362b8f, // n0x14ce c0x0000 (---------------)  + I uscountryestate
	0x00323609, // n0x14cf c0x0000 (---------------)  + I usculture
	0x00255a50, // n0x14d0 c0x0000 (---------------)  + I usdecorativearts
	0x002ada08, // n0x14d1 c0x0000 (---------------)  + I usgarden
	0x002b7209, // n0x14d2 c0x0000 (---------------)  + I ushistory
	0x00282ac7, // n0x14d3 c0x0000 (---------------)  + I ushuaia
	0x002a1ccf, // n0x14d4 c0x0000 (---------------)  + I uslivinghistory
	0x0026a544, // n0x14d5 c0x0000 (---------------)  + I utah
	0x00357a44, // n0x14d6 c0x0000 (---------------)  + I uvic
	0x00213d86, // n0x14d7 c0x0000 (---------------)  + I valley
	0x002292c6, // n0x14d8 c0x0000 (---------------)  + I vantaa
	0x0038deca, // n0x14d9 c0x0000 (---------------)  + I versailles
	0x002c7686, // n0x14da c0x0000 (---------------)  + I viking
	0x00327d47, // n0x14db c0x0000 (---------------)  + I village
	0x002dd148, // n0x14dc c0x0000 (---------------)  + I virginia
	0x002dd347, // n0x14dd c0x0000 (---------------)  + I virtual
	0x002dd507, // n0x14de c0x0000 (---------------)  + I virtuel
	0x00332eca, // n0x14df c0x0000 (---------------)  + I vlaanderen
	0x002df98b, // n0x14e0 c0x0000 (---------------)  + I volkenkunde
	0x0036cbc5, // n0x14e1 c0x0000 (---------------)  + I wales
	0x0037f608, // n0x14e2 c0x0000 (---------------)  + I wallonie
	0x00202543, // n0x14e3 c0x0000 (---------------)  + I war
	0x0025108c, // n0x14e4 c0x0000 (---------------)  + I washingtondc
	0x0020accf, // n0x14e5 c0x0000 (---------------)  + I watch-and-clock
	0x0025fe4d, // n0x14e6 c0x0000 (---------------)  + I watchandclock
	0x0036d147, // n0x14e7 c0x0000 (---------------)  + I western
	0x00320ec9, // n0x14e8 c0x0000 (---------------)  + I westfalen
	0x0029b447, // n0x14e9 c0x0000 (---------------)  + I whaling
	0x00247748, // n0x14ea c0x0000 (---------------)  + I wildlife
	0x00221a4c, // n0x14eb c0x0000 (---------------)  + I williamsburg
	0x002a0248, // n0x14ec c0x0000 (---------------)  + I windmill
	0x0029b088, // n0x14ed c0x0000 (---------------)  + I workshop
	0x002f608e, // n0x14ee c0x0000 (---------------)  + I xn--9dbhblg6di
	0x003083d4, // n0x14ef c0x0000 (---------------)  + I xn--comunicaes-v6a2o
	0x003088e4, // n0x14f0 c0x0000 (---------------)  + I xn--correios-e-telecomunicaes-ghc29a
	0x0032844a, // n0x14f1 c0x0000 (---------------)  + I xn--h1aegh
	0x0034760b, // n0x14f2 c0x0000 (---------------)  + I xn--lns-qla
	0x00237fc4, // n0x14f3 c0x0000 (---------------)  + I york
	0x00237fc9, // n0x14f4 c0x0000 (---------------)  + I yorkshire
	0x00297948, // n0x14f5 c0x0000 (---------------)  + I yosemite
	0x00235bc5, // n0x14f6 c0x0000 (---------------)  + I youth
	0x0038ba0a, // n0x14f7 c0x0000 (---------------)  + I zoological
	0x00363207, // n0x14f8 c0x0000 (---------------)  + I zoology
	0x002751c4, // n0x14f9 c0x0000 (---------------)  + I aero
	0x00310603, // n0x14fa c0x0000 (---------------)  + I biz
	0x00222ac3, // n0x14fb c0x0000 (---------------)  + I com
	0x00228d44, // n0x14fc c0x0000 (---------------)  + I coop
	0x002d75c3, // n0x14fd c0x0000 (---------------)  + I edu
	0x0021e283, // n0x14fe c0x0000 (---------------)  + I gov
	0x00200304, // n0x14ff c0x0000 (---------------)  + I info
	0x00238c03, // n0x1500 c0x0000 (---------------)  + I int
	0x0023fa03, // n0x1501 c0x0000 (---------------)  + I mil
	0x002bd646, // n0x1502 c0x0000 (---------------)  + I museum
	0x00298944, // n0x1503 c0x0000 (---------------)  + I name
	0x002170c3, // n0x1504 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1505 c0x0000 (---------------)  + I org
	0x00218243, // n0x1506 c0x0000 (---------------)  + I pro
	0x00201e82, // n0x1507 c0x0000 (---------------)  + I ac
	0x00310603, // n0x1508 c0x0000 (---------------)  + I biz
	0x00200742, // n0x1509 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x150a c0x0000 (---------------)  + I com
	0x00228d44, // n0x150b c0x0000 (---------------)  + I coop
	0x002d75c3, // n0x150c c0x0000 (---------------)  + I edu
	0x0021e283, // n0x150d c0x0000 (---------------)  + I gov
	0x00238c03, // n0x150e c0x0000 (---------------)  + I int
	0x002bd646, // n0x150f c0x0000 (---------------)  + I museum
	0x002170c3, // n0x1510 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1511 c0x0000 (---------------)  + I org
	0x000e4188, // n0x1512 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1513 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1514 c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x1515 c0x0000 (---------------)  + I gob
	0x002170c3, // n0x1516 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1517 c0x0000 (---------------)  + I org
	0x000e4188, // n0x1518 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1519 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x151a c0x0000 (---------------)  + I edu
	0x0021e283, // n0x151b c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x151c c0x0000 (---------------)  + I mil
	0x00298944, // n0x151d c0x0000 (---------------)  + I name
	0x002170c3, // n0x151e c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x151f c0x0000 (---------------)  + I org
	0x006ed3c8, // n0x1520 c0x0001 (---------------)  ! I teledata
	0x002055c2, // n0x1521 c0x0000 (---------------)  + I ca
	0x0021aa82, // n0x1522 c0x0000 (---------------)  + I cc
	0x00200742, // n0x1523 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1524 c0x0000 (---------------)  + I com
	0x0022fb02, // n0x1525 c0x0000 (---------------)  + I dr
	0x00200242, // n0x1526 c0x0000 (---------------)  + I in
	0x00200304, // n0x1527 c0x0000 (---------------)  + I info
	0x00203604, // n0x1528 c0x0000 (---------------)  + I mobi
	0x0020a682, // n0x1529 c0x0000 (---------------)  + I mx
	0x00298944, // n0x152a c0x0000 (---------------)  + I name
	0x00200c42, // n0x152b c0x0000 (---------------)  + I or
	0x0021dcc3, // n0x152c c0x0000 (---------------)  + I org
	0x00218243, // n0x152d c0x0000 (---------------)  + I pro
	0x00235406, // n0x152e c0x0000 (---------------)  + I school
	0x0020bf42, // n0x152f c0x0000 (---------------)  + I tv
	0x00209f42, // n0x1530 c0x0000 (---------------)  + I us
	0x0020ba82, // n0x1531 c0x0000 (---------------)  + I ws
	0x37e19443, // n0x1532 c0x00df (n0x1534-n0x1535)  o I her
	0x382238c3, // n0x1533 c0x00e0 (n0x1535-n0x1536)  o I his
	0x000439c6, // n0x1534 c0x0000 (---------------)  +   forgot
	0x000439c6, // n0x1535 c0x0000 (---------------)  +   forgot
	0x002729c4, // n0x1536 c0x0000 (---------------)  + I asso
	0x0010054c, // n0x1537 c0x0000 (---------------)  +   at-band-camp
	0x0006c90c, // n0x1538 c0x0000 (---------------)  +   azure-mobile
	0x000aef0d, // n0x1539 c0x0000 (---------------)  +   azurewebsites
	0x000d0087, // n0x153a c0x0000 (---------------)  +   blogdns
	0x00017a88, // n0x153b c0x0000 (---------------)  +   broke-it
	0x0001d90a, // n0x153c c0x0000 (---------------)  +   buyshouses
	0x38e2a085, // n0x153d c0x00e3 (n0x1568-n0x1569)  o I cdn77
	0x0002a089, // n0x153e c0x0000 (---------------)  +   cdn77-ssl
	0x00192608, // n0x153f c0x0000 (---------------)  +   cloudapp
	0x0019058a, // n0x1540 c0x0000 (---------------)  +   cloudfront
	0x00146fc8, // n0x1541 c0x0000 (---------------)  +   dnsalias
	0x0006a247, // n0x1542 c0x0000 (---------------)  +   dnsdojo
	0x0018a587, // n0x1543 c0x0000 (---------------)  +   does-it
	0x0015fdc9, // n0x1544 c0x0000 (---------------)  +   dontexist
	0x000007c8, // n0x1545 c0x0000 (---------------)  +   dynalias
	0x00078989, // n0x1546 c0x0000 (---------------)  +   dynathome
	0x0009428d, // n0x1547 c0x0000 (---------------)  +   endofinternet
	0x39287d46, // n0x1548 c0x00e4 (n0x1569-n0x156b)  o I fastly
	0x0004dac7, // n0x1549 c0x0000 (---------------)  +   from-az
	0x0004f247, // n0x154a c0x0000 (---------------)  +   from-co
	0x00056b87, // n0x154b c0x0000 (---------------)  +   from-la
	0x0005c687, // n0x154c c0x0000 (---------------)  +   from-ny
	0x00005a42, // n0x154d c0x0000 (---------------)  +   gb
	0x00104507, // n0x154e c0x0000 (---------------)  +   gets-it
	0x0005058c, // n0x154f c0x0000 (---------------)  +   ham-radio-op
	0x00085007, // n0x1550 c0x0000 (---------------)  +   homeftp
	0x000909c6, // n0x1551 c0x0000 (---------------)  +   homeip
	0x00090ec9, // n0x1552 c0x0000 (---------------)  +   homelinux
	0x00091b88, // n0x1553 c0x0000 (---------------)  +   homeunix
	0x00017d42, // n0x1554 c0x0000 (---------------)  +   hu
	0x00000242, // n0x1555 c0x0000 (---------------)  +   in
	0x0005554b, // n0x1556 c0x0000 (---------------)  +   in-the-band
	0x00166909, // n0x1557 c0x0000 (---------------)  +   is-a-chef
	0x00052e49, // n0x1558 c0x0000 (---------------)  +   is-a-geek
	0x00191648, // n0x1559 c0x0000 (---------------)  +   isa-geek
	0x000990c2, // n0x155a c0x0000 (---------------)  +   jp
	0x00183609, // n0x155b c0x0000 (---------------)  +   kicks-ass
	0x00019c4d, // n0x155c c0x0000 (---------------)  +   office-on-the
	0x000c7e07, // n0x155d c0x0000 (---------------)  +   podzone
	0x0004294d, // n0x155e c0x0000 (---------------)  +   scrapper-site
	0x00002e82, // n0x155f c0x0000 (---------------)  +   se
	0x00130f46, // n0x1560 c0x0000 (---------------)  +   selfip
	0x0007efc8, // n0x1561 c0x0000 (---------------)  +   sells-it
	0x00079088, // n0x1562 c0x0000 (---------------)  +   servebbs
	0x00161348, // n0x1563 c0x0000 (---------------)  +   serveftp
	0x0003f688, // n0x1564 c0x0000 (---------------)  +   thruhere
	0x0000cf02, // n0x1565 c0x0000 (---------------)  +   uk
	0x00110e86, // n0x1566 c0x0000 (---------------)  +   webhop
	0x000043c2, // n0x1567 c0x0000 (---------------)  +   za
	0x00000581, // n0x1568 c0x0000 (---------------)  +   r
	0x396cbe44, // n0x1569 c0x00e5 (n0x156b-n0x156d)  o I prod
	0x39a2a203, // n0x156a c0x00e6 (n0x156d-n0x1570)  o I ssl
	0x00000181, // n0x156b c0x0000 (---------------)  +   a
	0x00189c06, // n0x156c c0x0000 (---------------)  +   global
	0x00000181, // n0x156d c0x0000 (---------------)  +   a
	0x00000001, // n0x156e c0x0000 (---------------)  +   b
	0x00189c06, // n0x156f c0x0000 (---------------)  +   global
	0x00246584, // n0x1570 c0x0000 (---------------)  + I arts
	0x00222ac3, // n0x1571 c0x0000 (---------------)  + I com
	0x00238544, // n0x1572 c0x0000 (---------------)  + I firm
	0x00200304, // n0x1573 c0x0000 (---------------)  + I info
	0x002170c3, // n0x1574 c0x0000 (---------------)  + I net
	0x002193c5, // n0x1575 c0x0000 (---------------)  + I other
	0x00214943, // n0x1576 c0x0000 (---------------)  + I per
	0x002e6343, // n0x1577 c0x0000 (---------------)  + I rec
	0x002cf4c5, // n0x1578 c0x0000 (---------------)  + I store
	0x00219fc3, // n0x1579 c0x0000 (---------------)  + I web
	0x3a622ac3, // n0x157a c0x00e9 (n0x1583-n0x1584)  + I com
	0x002d75c3, // n0x157b c0x0000 (---------------)  + I edu
	0x0021e283, // n0x157c c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x157d c0x0000 (---------------)  + I mil
	0x00203604, // n0x157e c0x0000 (---------------)  + I mobi
	0x00298944, // n0x157f c0x0000 (---------------)  + I name
	0x002170c3, // n0x1580 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1581 c0x0000 (---------------)  + I org
	0x00206103, // n0x1582 c0x0000 (---------------)  + I sch
	0x000e4188, // n0x1583 c0x0000 (---------------)  +   blogspot
	0x000e4188, // n0x1584 c0x0000 (---------------)  +   blogspot
	0x003401c2, // n0x1585 c0x0000 (---------------)  + I bv
	0x00000742, // n0x1586 c0x0000 (---------------)  +   co
	0x3b21b502, // n0x1587 c0x00ec (n0x185d-n0x185e)  + I aa
	0x00301488, // n0x1588 c0x0000 (---------------)  + I aarborte
	0x0021b986, // n0x1589 c0x0000 (---------------)  + I aejrie
	0x002aa946, // n0x158a c0x0000 (---------------)  + I afjord
	0x0021b307, // n0x158b c0x0000 (---------------)  + I agdenes
	0x3b6076c2, // n0x158c c0x00ed (n0x185e-n0x185f)  + I ah
	0x3ba2b548, // n0x158d c0x00ee (n0x185f-n0x1860)  o I akershus
	0x0031a9ca, // n0x158e c0x0000 (---------------)  + I aknoluokta
	0x0024d548, // n0x158f c0x0000 (---------------)  + I akrehamn
	0x00200882, // n0x1590 c0x0000 (---------------)  + I al
	0x0036e809, // n0x1591 c0x0000 (---------------)  + I alaheadju
	0x0036cc07, // n0x1592 c0x0000 (---------------)  + I alesund
	0x0020e486, // n0x1593 c0x0000 (---------------)  + I algard
	0x00219749, // n0x1594 c0x0000 (---------------)  + I alstahaug
	0x0028ee04, // n0x1595 c0x0000 (---------------)  + I alta
	0x002ab3c6, // n0x1596 c0x0000 (---------------)  + I alvdal
	0x002aad44, // n0x1597 c0x0000 (---------------)  + I amli
	0x0025cb44, // n0x1598 c0x0000 (---------------)  + I amot
	0x00245409, // n0x1599 c0x0000 (---------------)  + I andasuolo
	0x002ee906, // n0x159a c0x0000 (---------------)  + I andebu
	0x0034bfc5, // n0x159b c0x0000 (---------------)  + I andoy
	0x00279985, // n0x159c c0x0000 (---------------)  + I ardal
	0x002a6dc7, // n0x159d c0x0000 (---------------)  + I aremark
	0x00275c47, // n0x159e c0x0000 (---------------)  + I arendal
	0x002798c4, // n0x159f c0x0000 (---------------)  + I arna
	0x0021b546, // n0x15a0 c0x0000 (---------------)  + I aseral
	0x00212605, // n0x15a1 c0x0000 (---------------)  + I asker
	0x0027d585, // n0x15a2 c0x0000 (---------------)  + I askim
	0x0031d885, // n0x15a3 c0x0000 (---------------)  + I askoy
	0x002dbc07, // n0x15a4 c0x0000 (---------------)  + I askvoll
	0x00311545, // n0x15a5 c0x0000 (---------------)  + I asnes
	0x002f1489, // n0x15a6 c0x0000 (---------------)  + I audnedaln
	0x00271305, // n0x15a7 c0x0000 (---------------)  + I aukra
	0x002e0084, // n0x15a8 c0x0000 (---------------)  + I aure
	0x0035b087, // n0x15a9 c0x0000 (---------------)  + I aurland
	0x0036d70e, // n0x15aa c0x0000 (---------------)  + I aurskog-holand
	0x003298c9, // n0x15ab c0x0000 (---------------)  + I austevoll
	0x002f5049, // n0x15ac c0x0000 (---------------)  + I austrheim
	0x0030dc86, // n0x15ad c0x0000 (---------------)  + I averoy
	0x00321688, // n0x15ae c0x0000 (---------------)  + I badaddja
	0x00329f8b, // n0x15af c0x0000 (---------------)  + I bahcavuotna
	0x002a080c, // n0x15b0 c0x0000 (---------------)  + I bahccavuotna
	0x00323c86, // n0x15b1 c0x0000 (---------------)  + I baidar
	0x00342887, // n0x15b2 c0x0000 (---------------)  + I bajddar
	0x0035dbc5, // n0x15b3 c0x0000 (---------------)  + I balat
	0x0023d9ca, // n0x15b4 c0x0000 (---------------)  + I balestrand
	0x0030b989, // n0x15b5 c0x0000 (---------------)  + I ballangen
	0x00268ec9, // n0x15b6 c0x0000 (---------------)  + I balsfjord
	0x002c8706, // n0x15b7 c0x0000 (---------------)  + I bamble
	0x002d37c5, // n0x15b8 c0x0000 (---------------)  + I bardu
	0x002b0545, // n0x15b9 c0x0000 (---------------)  + I barum
	0x0031a6c9, // n0x15ba c0x0000 (---------------)  + I batsfjord
	0x0035ddcb, // n0x15bb c0x0000 (---------------)  + I bearalvahki
	0x00269f06, // n0x15bc c0x0000 (---------------)  + I beardu
	0x00319a86, // n0x15bd c0x0000 (---------------)  + I beiarn
	0x00204704, // n0x15be c0x0000 (---------------)  + I berg
	0x00279f06, // n0x15bf c0x0000 (---------------)  + I bergen
	0x00343e08, // n0x15c0 c0x0000 (---------------)  + I berlevag
	0x00389486, // n0x15c1 c0x0000 (---------------)  + I bievat
	0x00219046, // n0x15c2 c0x0000 (---------------)  + I bindal
	0x00200f48, // n0x15c3 c0x0000 (---------------)  + I birkenes
	0x00202647, // n0x15c4 c0x0000 (---------------)  + I bjarkoy
	0x002033c9, // n0x15c5 c0x0000 (---------------)  + I bjerkreim
	0x00205005, // n0x15c6 c0x0000 (---------------)  + I bjugn
	0x000e4188, // n0x15c7 c0x0000 (---------------)  +   blogspot
	0x0038a504, // n0x15c8 c0x0000 (---------------)  + I bodo
	0x0029bf44, // n0x15c9 c0x0000 (---------------)  + I bokn
	0x0020aac5, // n0x15ca c0x0000 (---------------)  + I bomlo
	0x0037dc49, // n0x15cb c0x0000 (---------------)  + I bremanger
	0x00218ac7, // n0x15cc c0x0000 (---------------)  + I bronnoy
	0x00218acb, // n0x15cd c0x0000 (---------------)  + I bronnoysund
	0x0021a7ca, // n0x15ce c0x0000 (---------------)  + I brumunddal
	0x0021d4c5, // n0x15cf c0x0000 (---------------)  + I bryne
	0x3be0a582, // n0x15d0 c0x00ef (n0x1860-n0x1861)  + I bu
	0x002eea07, // n0x15d1 c0x0000 (---------------)  + I budejju
	0x3c318ec8, // n0x15d2 c0x00f0 (n0x1861-n0x1862)  o I buskerud
	0x00251987, // n0x15d3 c0x0000 (---------------)  + I bygland
	0x0025f245, // n0x15d4 c0x0000 (---------------)  + I bykle
	0x0032234a, // n0x15d5 c0x0000 (---------------)  + I cahcesuolo
	0x00000742, // n0x15d6 c0x0000 (---------------)  +   co
	0x0024fd0b, // n0x15d7 c0x0000 (---------------)  + I davvenjarga
	0x0024eb4a, // n0x15d8 c0x0000 (---------------)  + I davvesiida
	0x002e9206, // n0x15d9 c0x0000 (---------------)  + I deatnu
	0x002b8f83, // n0x15da c0x0000 (---------------)  + I dep
	0x0023404d, // n0x15db c0x0000 (---------------)  + I dielddanuorri
	0x0023e18c, // n0x15dc c0x0000 (---------------)  + I divtasvuodna
	0x002690cd, // n0x15dd c0x0000 (---------------)  + I divttasvuotna
	0x002f8b05, // n0x15de c0x0000 (---------------)  + I donna
	0x002396c5, // n0x15df c0x0000 (---------------)  + I dovre
	0x0034d707, // n0x15e0 c0x0000 (---------------)  + I drammen
	0x002edfc9, // n0x15e1 c0x0000 (---------------)  + I drangedal
	0x0031a8c6, // n0x15e2 c0x0000 (---------------)  + I drobak
	0x002c7505, // n0x15e3 c0x0000 (---------------)  + I dyroy
	0x0021e888, // n0x15e4 c0x0000 (---------------)  + I egersund
	0x00262743, // n0x15e5 c0x0000 (---------------)  + I eid
	0x002ec4c8, // n0x15e6 c0x0000 (---------------)  + I eidfjord
	0x00279e08, // n0x15e7 c0x0000 (---------------)  + I eidsberg
	0x002ac2c7, // n0x15e8 c0x0000 (---------------)  + I eidskog
	0x00262748, // n0x15e9 c0x0000 (---------------)  + I eidsvoll
	0x00383049, // n0x15ea c0x0000 (---------------)  + I eigersund
	0x00227ec7, // n0x15eb c0x0000 (---------------)  + I elverum
	0x00300e87, // n0x15ec c0x0000 (---------------)  + I enebakk
	0x002674c8, // n0x15ed c0x0000 (---------------)  + I engerdal
	0x002569c4, // n0x15ee c0x0000 (---------------)  + I etne
	0x002569c7, // n0x15ef c0x0000 (---------------)  + I etnedal
	0x0037ab48, // n0x15f0 c0x0000 (---------------)  + I evenassi
	0x0030a446, // n0x15f1 c0x0000 (---------------)  + I evenes
	0x00201f0f, // n0x15f2 c0x0000 (---------------)  + I evje-og-hornnes
	0x00345a07, // n0x15f3 c0x0000 (---------------)  + I farsund
	0x002c3146, // n0x15f4 c0x0000 (---------------)  + I fauske
	0x0020c745, // n0x15f5 c0x0000 (---------------)  + I fedje
	0x00234803, // n0x15f6 c0x0000 (---------------)  + I fet
	0x00324187, // n0x15f7 c0x0000 (---------------)  + I fetsund
	0x00235ec3, // n0x15f8 c0x0000 (---------------)  + I fhs
	0x002365c6, // n0x15f9 c0x0000 (---------------)  + I finnoy
	0x00238f06, // n0x15fa c0x0000 (---------------)  + I fitjar
	0x00239986, // n0x15fb c0x0000 (---------------)  + I fjaler
	0x0027e245, // n0x15fc c0x0000 (---------------)  + I fjell
	0x00252b83, // n0x15fd c0x0000 (---------------)  + I fla
	0x0035be08, // n0x15fe c0x0000 (---------------)  + I flakstad
	0x00353389, // n0x15ff c0x0000 (---------------)  + I flatanger
	0x0036500b, // n0x1600 c0x0000 (---------------)  + I flekkefjord
	0x00239b08, // n0x1601 c0x0000 (---------------)  + I flesberg
	0x0023c105, // n0x1602 c0x0000 (---------------)  + I flora
	0x0023d4c5, // n0x1603 c0x0000 (---------------)  + I floro
	0x3c758002, // n0x1604 c0x00f1 (n0x1862-n0x1863)  + I fm
	0x00362789, // n0x1605 c0x0000 (---------------)  + I folkebibl
	0x00241787, // n0x1606 c0x0000 (---------------)  + I folldal
	0x003640c5, // n0x1607 c0x0000 (---------------)  + I forde
	0x00245307, // n0x1608 c0x0000 (---------------)  + I forsand
	0x00247586, // n0x1609 c0x0000 (---------------)  + I fosnes
	0x0034af05, // n0x160a c0x0000 (---------------)  + I frana
	0x0024804b, // n0x160b c0x0000 (---------------)  + I fredrikstad
	0x00248cc4, // n0x160c c0x0000 (---------------)  + I frei
	0x0024d105, // n0x160d c0x0000 (---------------)  + I frogn
	0x0024d247, // n0x160e c0x0000 (---------------)  + I froland
	0x00263e06, // n0x160f c0x0000 (---------------)  + I frosta
	0x00264245, // n0x1610 c0x0000 (---------------)  + I froya
	0x0026fe07, // n0x1611 c0x0000 (---------------)  + I fuoisku
	0x00270587, // n0x1612 c0x0000 (---------------)  + I fuossko
	0x002a7504, // n0x1613 c0x0000 (---------------)  + I fusa
	0x0027798a, // n0x1614 c0x0000 (---------------)  + I fylkesbibl
	0x00277e48, // n0x1615 c0x0000 (---------------)  + I fyresdal
	0x0035ea49, // n0x1616 c0x0000 (---------------)  + I gaivuotna
	0x00215b85, // n0x1617 c0x0000 (---------------)  + I galsa
	0x0024ff46, // n0x1618 c0x0000 (---------------)  + I gamvik
	0x00343fca, // n0x1619 c0x0000 (---------------)  + I gangaviika
	0x003442c6, // n0x161a c0x0000 (---------------)  + I gaular
	0x002542c7, // n0x161b c0x0000 (---------------)  + I gausdal
	0x0035e70d, // n0x161c c0x0000 (---------------)  + I giehtavuoatna
	0x00220049, // n0x161d c0x0000 (---------------)  + I gildeskal
	0x00347945, // n0x161e c0x0000 (---------------)  + I giske
	0x0030ee07, // n0x161f c0x0000 (---------------)  + I gjemnes
	0x002ed908, // n0x1620 c0x0000 (---------------)  + I gjerdrum
	0x0031c188, // n0x1621 c0x0000 (---------------)  + I gjerstad
	0x0031d607, // n0x1622 c0x0000 (---------------)  + I gjesdal
	0x003446c6, // n0x1623 c0x0000 (---------------)  + I gjovik
	0x00395287, // n0x1624 c0x0000 (---------------)  + I gloppen
	0x00238a83, // n0x1625 c0x0000 (---------------)  + I gol
	0x00320b04, // n0x1626 c0x0000 (---------------)  + I gran
	0x00348cc5, // n0x1627 c0x0000 (---------------)  + I grane
	0x00376107, // n0x1628 c0x0000 (---------------)  + I granvin
	0x00379f89, // n0x1629 c0x0000 (---------------)  + I gratangen
	0x002136c8, // n0x162a c0x0000 (---------------)  + I grimstad
	0x002c77c5, // n0x162b c0x0000 (---------------)  + I grong
	0x00222fc4, // n0x162c c0x0000 (---------------)  + I grue
	0x00331485, // n0x162d c0x0000 (---------------)  + I gulen
	0x002373cd, // n0x162e c0x0000 (---------------)  + I guovdageaidnu
	0x00202dc2, // n0x162f c0x0000 (---------------)  + I ha
	0x00289a46, // n0x1630 c0x0000 (---------------)  + I habmer
	0x00330e86, // n0x1631 c0x0000 (---------------)  + I hadsel
	0x002f5e0a, // n0x1632 c0x0000 (---------------)  + I hagebostad
	0x0035b7c6, // n0x1633 c0x0000 (---------------)  + I halden
	0x00363605, // n0x1634 c0x0000 (---------------)  + I halsa
	0x0036e045, // n0x1635 c0x0000 (---------------)  + I hamar
	0x0036e047, // n0x1636 c0x0000 (---------------)  + I hamaroy
	0x0036794c, // n0x1637 c0x0000 (---------------)  + I hammarfeasta
	0x002ef38a, // n0x1638 c0x0000 (---------------)  + I hammerfest
	0x002796c6, // n0x1639 c0x0000 (---------------)  + I hapmir
	0x002ae105, // n0x163a c0x0000 (---------------)  + I haram
	0x00279d46, // n0x163b c0x0000 (---------------)  + I hareid
	0x0027a087, // n0x163c c0x0000 (---------------)  + I harstad
	0x0027b486, // n0x163d c0x0000 (---------------)  + I hasvik
	0x0027e14c, // n0x163e c0x0000 (---------------)  + I hattfjelldal
	0x00219889, // n0x163f c0x0000 (---------------)  + I haugesund
	0x3ca9bc07, // n0x1640 c0x00f2 (n0x1863-n0x1866)  o I hedmark
	0x0027f885, // n0x1641 c0x0000 (---------------)  + I hemne
	0x0027f886, // n0x1642 c0x0000 (---------------)  + I hemnes
	0x0027fc88, // n0x1643 c0x0000 (---------------)  + I hemsedal
	0x0022db45, // n0x1644 c0x0000 (---------------)  + I herad
	0x0028fd85, // n0x1645 c0x0000 (---------------)  + I hitra
	0x0028ffc8, // n0x1646 c0x0000 (---------------)  + I hjartdal
	0x002901ca, // n0x1647 c0x0000 (---------------)  + I hjelmeland
	0x3ce0cc02, // n0x1648 c0x00f3 (n0x1866-n0x1867)  + I hl
	0x3d206182, // n0x1649 c0x00f4 (n0x1867-n0x1868)  + I hm
	0x002536c5, // n0x164a c0x0000 (---------------)  + I hobol
	0x0029a803, // n0x164b c0x0000 (---------------)  + I hof
	0x002c7348, // n0x164c c0x0000 (---------------)  + I hokksund
	0x002351c3, // n0x164d c0x0000 (---------------)  + I hol
	0x00290444, // n0x164e c0x0000 (---------------)  + I hole
	0x0025a04b, // n0x164f c0x0000 (---------------)  + I holmestrand
	0x00271dc8, // n0x1650 c0x0000 (---------------)  + I holtalen
	0x00292148, // n0x1651 c0x0000 (---------------)  + I honefoss
	0x3d6f84c9, // n0x1652 c0x00f5 (n0x1868-n0x1869)  o I hordaland
	0x002939c9, // n0x1653 c0x0000 (---------------)  + I hornindal
	0x00294186, // n0x1654 c0x0000 (---------------)  + I horten
	0x00295188, // n0x1655 c0x0000 (---------------)  + I hoyanger
	0x00295389, // n0x1656 c0x0000 (---------------)  + I hoylandet
	0x00296046, // n0x1657 c0x0000 (---------------)  + I hurdal
	0x002961c5, // n0x1658 c0x0000 (---------------)  + I hurum
	0x003512c6, // n0x1659 c0x0000 (---------------)  + I hvaler
	0x0036b589, // n0x165a c0x0000 (---------------)  + I hyllestad
	0x0030a287, // n0x165b c0x0000 (---------------)  + I ibestad
	0x00247d86, // n0x165c c0x0000 (---------------)  + I idrett
	0x002f3407, // n0x165d c0x0000 (---------------)  + I inderoy
	0x00304b07, // n0x165e c0x0000 (---------------)  + I iveland
	0x0025f644, // n0x165f c0x0000 (---------------)  + I ivgu
	0x3da14c09, // n0x1660 c0x00f6 (n0x1869-n0x186a)  + I jan-mayen
	0x002b4408, // n0x1661 c0x0000 (---------------)  + I jessheim
	0x00345148, // n0x1662 c0x0000 (---------------)  + I jevnaker
	0x002326c7, // n0x1663 c0x0000 (---------------)  + I jolster
	0x002afb86, // n0x1664 c0x0000 (---------------)  + I jondal
	0x0038a009, // n0x1665 c0x0000 (---------------)  + I jorpeland
	0x002ab887, // n0x1666 c0x0000 (---------------)  + I kafjord
	0x0022e84a, // n0x1667 c0x0000 (---------------)  + I karasjohka
	0x002d8848, // n0x1668 c0x0000 (---------------)  + I karasjok
	0x0023eb87, // n0x1669 c0x0000 (---------------)  + I karlsoy
	0x00305646, // n0x166a c0x0000 (---------------)  + I karmoy
	0x002eaa8a, // n0x166b c0x0000 (---------------)  + I kautokeino
	0x0023cc48, // n0x166c c0x0000 (---------------)  + I kirkenes
	0x0025ef45, // n0x166d c0x0000 (---------------)  + I klabu
	0x0021cd85, // n0x166e c0x0000 (---------------)  + I klepp
	0x002ac947, // n0x166f c0x0000 (---------------)  + I kommune
	0x002b7dc9, // n0x1670 c0x0000 (---------------)  + I kongsberg
	0x002b814b, // n0x1671 c0x0000 (---------------)  + I kongsvinger
	0x002c83c8, // n0x1672 c0x0000 (---------------)  + I kopervik
	0x00271389, // n0x1673 c0x0000 (---------------)  + I kraanghke
	0x0023a407, // n0x1674 c0x0000 (---------------)  + I kragero
	0x0029db0c, // n0x1675 c0x0000 (---------------)  + I kristiansand
	0x0029df8c, // n0x1676 c0x0000 (---------------)  + I kristiansund
	0x0029e28a, // n0x1677 c0x0000 (---------------)  + I krodsherad
	0x0029e50c, // n0x1678 c0x0000 (---------------)  + I krokstadelva
	0x002aa8c8, // n0x1679 c0x0000 (---------------)  + I kvafjord
	0x002aaac8, // n0x167a c0x0000 (---------------)  + I kvalsund
	0x002aacc4, // n0x167b c0x0000 (---------------)  + I kvam
	0x002aba49, // n0x167c c0x0000 (---------------)  + I kvanangen
	0x002abc89, // n0x167d c0x0000 (---------------)  + I kvinesdal
	0x002abeca, // n0x167e c0x0000 (---------------)  + I kvinnherad
	0x002ac149, // n0x167f c0x0000 (---------------)  + I kviteseid
	0x002ac487, // n0x1680 c0x0000 (---------------)  + I kvitsoy
	0x00381bcc, // n0x1681 c0x0000 (---------------)  + I laakesvuemie
	0x00207686, // n0x1682 c0x0000 (---------------)  + I lahppi
	0x00256cc8, // n0x1683 c0x0000 (---------------)  + I langevag
	0x00344386, // n0x1684 c0x0000 (---------------)  + I lardal
	0x002d7a86, // n0x1685 c0x0000 (---------------)  + I larvik
	0x00347847, // n0x1686 c0x0000 (---------------)  + I lavagis
	0x00358888, // n0x1687 c0x0000 (---------------)  + I lavangen
	0x002f020b, // n0x1688 c0x0000 (---------------)  + I leangaviika
	0x00251847, // n0x1689 c0x0000 (---------------)  + I lebesby
	0x00227989, // n0x168a c0x0000 (---------------)  + I leikanger
	0x002386c9, // n0x168b c0x0000 (---------------)  + I leirfjord
	0x00244b87, // n0x168c c0x0000 (---------------)  + I leirvik
	0x00203c44, // n0x168d c0x0000 (---------------)  + I leka
	0x0034b3c7, // n0x168e c0x0000 (---------------)  + I leksvik
	0x00364686, // n0x168f c0x0000 (---------------)  + I lenvik
	0x00364246, // n0x1690 c0x0000 (---------------)  + I lerdal
	0x002a5105, // n0x1691 c0x0000 (---------------)  + I lesja
	0x00326448, // n0x1692 c0x0000 (---------------)  + I levanger
	0x002a6004, // n0x1693 c0x0000 (---------------)  + I lier
	0x002a6006, // n0x1694 c0x0000 (---------------)  + I lierne
	0x002ef24b, // n0x1695 c0x0000 (---------------)  + I lillehammer
	0x00270d89, // n0x1696 c0x0000 (---------------)  + I lillesand
	0x0031d786, // n0x1697 c0x0000 (---------------)  + I lindas
	0x0031dc09, // n0x1698 c0x0000 (---------------)  + I lindesnes
	0x002dbd86, // n0x1699 c0x0000 (---------------)  + I loabat
	0x002455c8, // n0x169a c0x0000 (---------------)  + I lodingen
	0x00260a43, // n0x169b c0x0000 (---------------)  + I lom
	0x0031b945, // n0x169c c0x0000 (---------------)  + I loppa
	0x003444c9, // n0x169d c0x0000 (---------------)  + I lorenskog
	0x0034d145, // n0x169e c0x0000 (---------------)  + I loten
	0x002d8b84, // n0x169f c0x0000 (---------------)  + I lund
	0x00263646, // n0x16a0 c0x0000 (---------------)  + I lunner
	0x0029cb85, // n0x16a1 c0x0000 (---------------)  + I luroy
	0x002c7bc6, // n0x16a2 c0x0000 (---------------)  + I luster
	0x002e1c87, // n0x16a3 c0x0000 (---------------)  + I lyngdal
	0x0029c206, // n0x16a4 c0x0000 (---------------)  + I lyngen
	0x0028448b, // n0x16a5 c0x0000 (---------------)  + I malatvuopmi
	0x0034ce07, // n0x16a6 c0x0000 (---------------)  + I malselv
	0x00307d86, // n0x16a7 c0x0000 (---------------)  + I malvik
	0x00358046, // n0x16a8 c0x0000 (---------------)  + I mandal
	0x002a6e86, // n0x16a9 c0x0000 (---------------)  + I marker
	0x00279889, // n0x16aa c0x0000 (---------------)  + I marnardal
	0x003419ca, // n0x16ab c0x0000 (---------------)  + I masfjorden
	0x00314445, // n0x16ac c0x0000 (---------------)  + I masoy
	0x0020f58d, // n0x16ad c0x0000 (---------------)  + I matta-varjjat
	0x002902c6, // n0x16ae c0x0000 (---------------)  + I meland
	0x002d8246, // n0x16af c0x0000 (---------------)  + I meldal
	0x002a1bc6, // n0x16b0 c0x0000 (---------------)  + I melhus
	0x00259d05, // n0x16b1 c0x0000 (---------------)  + I meloy
	0x0022b487, // n0x16b2 c0x0000 (---------------)  + I meraker
	0x002886c7, // n0x16b3 c0x0000 (---------------)  + I midsund
	0x002061ce, // n0x16b4 c0x0000 (---------------)  + I midtre-gauldal
	0x0023fa03, // n0x16b5 c0x0000 (---------------)  + I mil
	0x002afb49, // n0x16b6 c0x0000 (---------------)  + I mjondalen
	0x002f3689, // n0x16b7 c0x0000 (---------------)  + I mo-i-rana
	0x0023ddc7, // n0x16b8 c0x0000 (---------------)  + I moareke
	0x00208487, // n0x16b9 c0x0000 (---------------)  + I modalen
	0x003120c5, // n0x16ba c0x0000 (---------------)  + I modum
	0x0029f845, // n0x16bb c0x0000 (---------------)  + I molde
	0x3de70a0f, // n0x16bc c0x00f7 (n0x186a-n0x186c)  o I more-og-romsdal
	0x002b7447, // n0x16bd c0x0000 (---------------)  + I mosjoen
	0x002b7608, // n0x16be c0x0000 (---------------)  + I moskenes
	0x002b7b44, // n0x16bf c0x0000 (---------------)  + I moss
	0x002b8006, // n0x16c0 c0x0000 (---------------)  + I mosvik
	0x3e2dcb42, // n0x16c1 c0x00f8 (n0x186c-n0x186d)  + I mr
	0x002bb5c6, // n0x16c2 c0x0000 (---------------)  + I muosat
	0x002bd646, // n0x16c3 c0x0000 (---------------)  + I museum
	0x002f054e, // n0x16c4 c0x0000 (---------------)  + I naamesjevuemie
	0x002ec30a, // n0x16c5 c0x0000 (---------------)  + I namdalseid
	0x0021c1c6, // n0x16c6 c0x0000 (---------------)  + I namsos
	0x00232b4a, // n0x16c7 c0x0000 (---------------)  + I namsskogan
	0x002b2489, // n0x16c8 c0x0000 (---------------)  + I nannestad
	0x002ff685, // n0x16c9 c0x0000 (---------------)  + I naroy
	0x0037c388, // n0x16ca c0x0000 (---------------)  + I narviika
	0x00393206, // n0x16cb c0x0000 (---------------)  + I narvik
	0x0031e108, // n0x16cc c0x0000 (---------------)  + I naustdal
	0x00354f08, // n0x16cd c0x0000 (---------------)  + I navuotna
	0x00395acb, // n0x16ce c0x0000 (---------------)  + I nedre-eiker
	0x0021b405, // n0x16cf c0x0000 (---------------)  + I nesna
	0x003115c8, // n0x16d0 c0x0000 (---------------)  + I nesodden
	0x0020108c, // n0x16d1 c0x0000 (---------------)  + I nesoddtangen
	0x0025f107, // n0x16d2 c0x0000 (---------------)  + I nesseby
	0x00239146, // n0x16d3 c0x0000 (---------------)  + I nesset
	0x002e6588, // n0x16d4 c0x0000 (---------------)  + I nissedal
	0x002677c8, // n0x16d5 c0x0000 (---------------)  + I nittedal
	0x3e636482, // n0x16d6 c0x00f9 (n0x186d-n0x186e)  + I nl
	0x002ab18b, // n0x16d7 c0x0000 (---------------)  + I nord-aurdal
	0x00200c09, // n0x16d8 c0x0000 (---------------)  + I nord-fron
	0x003473c9, // n0x16d9 c0x0000 (---------------)  + I nord-odal
	0x0031da87, // n0x16da c0x0000 (---------------)  + I norddal
	0x002befc8, // n0x16db c0x0000 (---------------)  + I nordkapp
	0x3ea3dfc8, // n0x16dc c0x00fa (n0x186e-n0x1872)  o I nordland
	0x002c5f0b, // n0x16dd c0x0000 (---------------)  + I nordre-land
	0x003914c9, // n0x16de c0x0000 (---------------)  + I nordreisa
	0x002113cd, // n0x16df c0x0000 (---------------)  + I nore-og-uvdal
	0x0023fdc8, // n0x16e0 c0x0000 (---------------)  + I notodden
	0x00288b08, // n0x16e1 c0x0000 (---------------)  + I notteroy
	0x3ee00e02, // n0x16e2 c0x00fb (n0x1872-n0x1873)  + I nt
	0x00396f44, // n0x16e3 c0x0000 (---------------)  + I odda
	0x3f209982, // n0x16e4 c0x00fc (n0x1873-n0x1874)  + I of
	0x002d89c6, // n0x16e5 c0x0000 (---------------)  + I oksnes
	0x3f600a02, // n0x16e6 c0x00fd (n0x1874-n0x1875)  + I ol
	0x0021d00a, // n0x16e7 c0x0000 (---------------)  + I omasvuotna
	0x0029b206, // n0x16e8 c0x0000 (---------------)  + I oppdal
	0x00220b88, // n0x16e9 c0x0000 (---------------)  + I oppegard
	0x00241b48, // n0x16ea c0x0000 (---------------)  + I orkanger
	0x00321986, // n0x16eb c0x0000 (---------------)  + I orkdal
	0x0032e206, // n0x16ec c0x0000 (---------------)  + I orland
	0x002ce006, // n0x16ed c0x0000 (---------------)  + I orskog
	0x0029fac5, // n0x16ee c0x0000 (---------------)  + I orsta
	0x0022be04, // n0x16ef c0x0000 (---------------)  + I osen
	0x3fab8a04, // n0x16f0 c0x00fe (n0x1875-n0x1876)  + I oslo
	0x00207f86, // n0x16f1 c0x0000 (---------------)  + I osoyro
	0x002586c7, // n0x16f2 c0x0000 (---------------)  + I osteroy
	0x3fed6987, // n0x16f3 c0x00ff (n0x1876-n0x1877)  o I ostfold
	0x0020300b, // n0x16f4 c0x0000 (---------------)  + I ostre-toten
	0x0036dac9, // n0x16f5 c0x0000 (---------------)  + I overhalla
	0x0023970a, // n0x16f6 c0x0000 (---------------)  + I ovre-eiker
	0x002f3544, // n0x16f7 c0x0000 (---------------)  + I oyer
	0x00300d08, // n0x16f8 c0x0000 (---------------)  + I oygarden
	0x00247b4d, // n0x16f9 c0x0000 (---------------)  + I oystre-slidre
	0x002c9e89, // n0x16fa c0x0000 (---------------)  + I porsanger
	0x002ca0c8, // n0x16fb c0x0000 (---------------)  + I porsangu
	0x002ca349, // n0x16fc c0x0000 (---------------)  + I porsgrunn
	0x002cba44, // n0x16fd c0x0000 (---------------)  + I priv
	0x00212ec4, // n0x16fe c0x0000 (---------------)  + I rade
	0x00254d85, // n0x16ff c0x0000 (---------------)  + I radoy
	0x0035f14b, // n0x1700 c0x0000 (---------------)  + I rahkkeravju
	0x00271d46, // n0x1701 c0x0000 (---------------)  + I raholt
	0x002a2305, // n0x1702 c0x0000 (---------------)  + I raisa
	0x0032a2c9, // n0x1703 c0x0000 (---------------)  + I rakkestad
	0x0021b608, // n0x1704 c0x0000 (---------------)  + I ralingen
	0x0025abc4, // n0x1705 c0x0000 (---------------)  + I rana
	0x0023db49, // n0x1706 c0x0000 (---------------)  + I randaberg
	0x0026a685, // n0x1707 c0x0000 (---------------)  + I rauma
	0x00275c88, // n0x1708 c0x0000 (---------------)  + I rendalen
	0x0033c507, // n0x1709 c0x0000 (---------------)  + I rennebu
	0x002f5448, // n0x170a c0x0000 (---------------)  + I rennesoy
	0x002af746, // n0x170b c0x0000 (---------------)  + I rindal
	0x003247c7, // n0x170c c0x0000 (---------------)  + I ringebu
	0x002a8c49, // n0x170d c0x0000 (---------------)  + I ringerike
	0x00324cc9, // n0x170e c0x0000 (---------------)  + I ringsaker
	0x0025b4c5, // n0x170f c0x0000 (---------------)  + I risor
	0x002346c5, // n0x1710 c0x0000 (---------------)  + I rissa
	0x4021d702, // n0x1711 c0x0100 (n0x1877-n0x1878)  + I rl
	0x002dfe44, // n0x1712 c0x0000 (---------------)  + I roan
	0x0036a305, // n0x1713 c0x0000 (---------------)  + I rodoy
	0x0033c1c6, // n0x1714 c0x0000 (---------------)  + I rollag
	0x00302a85, // n0x1715 c0x0000 (---------------)  + I romsa
	0x0023d587, // n0x1716 c0x0000 (---------------)  + I romskog
	0x002e3245, // n0x1717 c0x0000 (---------------)  + I roros
	0x00263e44, // n0x1718 c0x0000 (---------------)  + I rost
	0x0030dd46, // n0x1719 c0x0000 (---------------)  + I royken
	0x002c7587, // n0x171a c0x0000 (---------------)  + I royrvik
	0x002dcb86, // n0x171b c0x0000 (---------------)  + I ruovat
	0x00268ac5, // n0x171c c0x0000 (---------------)  + I rygge
	0x0031ce08, // n0x171d c0x0000 (---------------)  + I salangen
	0x0031de05, // n0x171e c0x0000 (---------------)  + I salat
	0x00341347, // n0x171f c0x0000 (---------------)  + I saltdal
	0x0035b289, // n0x1720 c0x0000 (---------------)  + I samnanger
	0x0029dd0a, // n0x1721 c0x0000 (---------------)  + I sandefjord
	0x0023bac7, // n0x1722 c0x0000 (---------------)  + I sandnes
	0x0023bacc, // n0x1723 c0x0000 (---------------)  + I sandnessjoen
	0x0034bf86, // n0x1724 c0x0000 (---------------)  + I sandoy
	0x0021db49, // n0x1725 c0x0000 (---------------)  + I sarpsborg
	0x0022d7c5, // n0x1726 c0x0000 (---------------)  + I sauda
	0x0022da88, // n0x1727 c0x0000 (---------------)  + I sauherad
	0x0020a4c3, // n0x1728 c0x0000 (---------------)  + I sel
	0x0020a4c5, // n0x1729 c0x0000 (---------------)  + I selbu
	0x002fad85, // n0x172a c0x0000 (---------------)  + I selje
	0x00245cc7, // n0x172b c0x0000 (---------------)  + I seljord
	0x4060f182, // n0x172c c0x0101 (n0x1878-n0x1879)  + I sf
	0x0023b647, // n0x172d c0x0000 (---------------)  + I siellak
	0x002b79c6, // n0x172e c0x0000 (---------------)  + I sigdal
	0x00214b46, // n0x172f c0x0000 (---------------)  + I siljan
	0x002c1186, // n0x1730 c0x0000 (---------------)  + I sirdal
	0x00267706, // n0x1731 c0x0000 (---------------)  + I skanit
	0x00310108, // n0x1732 c0x0000 (---------------)  + I skanland
	0x00262585, // n0x1733 c0x0000 (---------------)  + I skaun
	0x002c3207, // n0x1734 c0x0000 (---------------)  + I skedsmo
	0x002c320d, // n0x1735 c0x0000 (---------------)  + I skedsmokorset
	0x00207b43, // n0x1736 c0x0000 (---------------)  + I ski
	0x00207b45, // n0x1737 c0x0000 (---------------)  + I skien
	0x002f2d47, // n0x1738 c0x0000 (---------------)  + I skierva
	0x0036b048, // n0x1739 c0x0000 (---------------)  + I skiptvet
	0x0036ac05, // n0x173a c0x0000 (---------------)  + I skjak
	0x0030c348, // n0x173b c0x0000 (---------------)  + I skjervoy
	0x002206c6, // n0x173c c0x0000 (---------------)  + I skodje
	0x0022a247, // n0x173d c0x0000 (---------------)  + I slattum
	0x00285605, // n0x173e c0x0000 (---------------)  + I smola
	0x0021b486, // n0x173f c0x0000 (---------------)  + I snaase
	0x00340405, // n0x1740 c0x0000 (---------------)  + I snasa
	0x002aa34a, // n0x1741 c0x0000 (---------------)  + I snillfjord
	0x002c4f86, // n0x1742 c0x0000 (---------------)  + I snoasa
	0x002141c7, // n0x1743 c0x0000 (---------------)  + I sogndal
	0x00308285, // n0x1744 c0x0000 (---------------)  + I sogne
	0x002d9347, // n0x1745 c0x0000 (---------------)  + I sokndal
	0x002d0204, // n0x1746 c0x0000 (---------------)  + I sola
	0x002d8b06, // n0x1747 c0x0000 (---------------)  + I solund
	0x002da005, // n0x1748 c0x0000 (---------------)  + I somna
	0x002ee70b, // n0x1749 c0x0000 (---------------)  + I sondre-land
	0x00364509, // n0x174a c0x0000 (---------------)  + I songdalen
	0x0037184a, // n0x174b c0x0000 (---------------)  + I sor-aurdal
	0x0025b548, // n0x174c c0x0000 (---------------)  + I sor-fron
	0x002e0f48, // n0x174d c0x0000 (---------------)  + I sor-odal
	0x002e888c, // n0x174e c0x0000 (---------------)  + I sor-varanger
	0x002ec987, // n0x174f c0x0000 (---------------)  + I sorfold
	0x00315608, // n0x1750 c0x0000 (---------------)  + I sorreisa
	0x0031a288, // n0x1751 c0x0000 (---------------)  + I sortland
	0x0031ee45, // n0x1752 c0x0000 (---------------)  + I sorum
	0x002ac70a, // n0x1753 c0x0000 (---------------)  + I spjelkavik
	0x00349a49, // n0x1754 c0x0000 (---------------)  + I spydeberg
	0x40a023c2, // n0x1755 c0x0102 (n0x1879-n0x187a)  + I st
	0x00309986, // n0x1756 c0x0000 (---------------)  + I stange
	0x0029ca04, // n0x1757 c0x0000 (---------------)  + I stat
	0x0029e909, // n0x1758 c0x0000 (---------------)  + I stathelle
	0x002c92c9, // n0x1759 c0x0000 (---------------)  + I stavanger
	0x002d97c7, // n0x175a c0x0000 (---------------)  + I stavern
	0x0025c087, // n0x175b c0x0000 (---------------)  + I steigen
	0x003374c9, // n0x175c c0x0000 (---------------)  + I steinkjer
	0x00202b88, // n0x175d c0x0000 (---------------)  + I stjordal
	0x00202b8f, // n0x175e c0x0000 (---------------)  + I stjordalshalsen
	0x00228bc6, // n0x175f c0x0000 (---------------)  + I stokke
	0x0023f24b, // n0x1760 c0x0000 (---------------)  + I stor-elvdal
	0x002cf305, // n0x1761 c0x0000 (---------------)  + I stord
	0x002cf307, // n0x1762 c0x0000 (---------------)  + I stordal
	0x002cf749, // n0x1763 c0x0000 (---------------)  + I storfjord
	0x0023dac6, // n0x1764 c0x0000 (---------------)  + I strand
	0x0023dac7, // n0x1765 c0x0000 (---------------)  + I stranda
	0x0037fd45, // n0x1766 c0x0000 (---------------)  + I stryn
	0x00224fc4, // n0x1767 c0x0000 (---------------)  + I sula
	0x00226b46, // n0x1768 c0x0000 (---------------)  + I suldal
	0x00218c84, // n0x1769 c0x0000 (---------------)  + I sund
	0x002a9c87, // n0x176a c0x0000 (---------------)  + I sunndal
	0x002d1a88, // n0x176b c0x0000 (---------------)  + I surnadal
	0x40ed36c8, // n0x176c c0x0103 (n0x187a-n0x187b)  + I svalbard
	0x002d4485, // n0x176d c0x0000 (---------------)  + I sveio
	0x002d45c7, // n0x176e c0x0000 (---------------)  + I svelvik
	0x00354549, // n0x176f c0x0000 (---------------)  + I sykkylven
	0x00204e04, // n0x1770 c0x0000 (---------------)  + I tana
	0x00204e08, // n0x1771 c0x0000 (---------------)  + I tananger
	0x4122ba88, // n0x1772 c0x0104 (n0x187b-n0x187d)  o I telemark
	0x0036ef44, // n0x1773 c0x0000 (---------------)  + I time
	0x00225c08, // n0x1774 c0x0000 (---------------)  + I tingvoll
	0x0030cf04, // n0x1775 c0x0000 (---------------)  + I tinn
	0x0021fb09, // n0x1776 c0x0000 (---------------)  + I tjeldsund
	0x00259c45, // n0x1777 c0x0000 (---------------)  + I tjome
	0x41608902, // n0x1778 c0x0105 (n0x187d-n0x187e)  + I tm
	0x00228c05, // n0x1779 c0x0000 (---------------)  + I tokke
	0x00215ac5, // n0x177a c0x0000 (---------------)  + I tolga
	0x00204608, // n0x177b c0x0000 (---------------)  + I tonsberg
	0x00226fc7, // n0x177c c0x0000 (---------------)  + I torsken
	0x41a02402, // n0x177d c0x0106 (n0x187e-n0x187f)  + I tr
	0x0025ab85, // n0x177e c0x0000 (---------------)  + I trana
	0x00263106, // n0x177f c0x0000 (---------------)  + I tranby
	0x00278cc6, // n0x1780 c0x0000 (---------------)  + I tranoy
	0x002dfe08, // n0x1781 c0x0000 (---------------)  + I troandin
	0x002e4348, // n0x1782 c0x0000 (---------------)  + I trogstad
	0x00302a46, // n0x1783 c0x0000 (---------------)  + I tromsa
	0x0030ac06, // n0x1784 c0x0000 (---------------)  + I tromso
	0x00214709, // n0x1785 c0x0000 (---------------)  + I trondheim
	0x0036b846, // n0x1786 c0x0000 (---------------)  + I trysil
	0x00394d4b, // n0x1787 c0x0000 (---------------)  + I tvedestrand
	0x00222c85, // n0x1788 c0x0000 (---------------)  + I tydal
	0x0020fac6, // n0x1789 c0x0000 (---------------)  + I tynset
	0x00224108, // n0x178a c0x0000 (---------------)  + I tysfjord
	0x00234886, // n0x178b c0x0000 (---------------)  + I tysnes
	0x002f8986, // n0x178c c0x0000 (---------------)  + I tysvar
	0x00210dca, // n0x178d c0x0000 (---------------)  + I ullensaker
	0x002bab8a, // n0x178e c0x0000 (---------------)  + I ullensvang
	0x0025bd05, // n0x178f c0x0000 (---------------)  + I ulvik
	0x00215307, // n0x1790 c0x0000 (---------------)  + I unjarga
	0x002d0d06, // n0x1791 c0x0000 (---------------)  + I utsira
	0x41e013c2, // n0x1792 c0x0107 (n0x187f-n0x1880)  + I va
	0x002f2e87, // n0x1793 c0x0000 (---------------)  + I vaapste
	0x00262a85, // n0x1794 c0x0000 (---------------)  + I vadso
	0x00343f44, // n0x1795 c0x0000 (---------------)  + I vaga
	0x00343f45, // n0x1796 c0x0000 (---------------)  + I vagan
	0x00300c06, // n0x1797 c0x0000 (---------------)  + I vagsoy
	0x0033f147, // n0x1798 c0x0000 (---------------)  + I vaksdal
	0x00213d85, // n0x1799 c0x0000 (---------------)  + I valle
	0x002bad04, // n0x179a c0x0000 (---------------)  + I vang
	0x0025c3c8, // n0x179b c0x0000 (---------------)  + I vanylven
	0x002f8a45, // n0x179c c0x0000 (---------------)  + I vardo
	0x00280307, // n0x179d c0x0000 (---------------)  + I varggat
	0x002cf005, // n0x179e c0x0000 (---------------)  + I varoy
	0x00310385, // n0x179f c0x0000 (---------------)  + I vefsn
	0x00212004, // n0x17a0 c0x0000 (---------------)  + I vega
	0x00299e89, // n0x17a1 c0x0000 (---------------)  + I vegarshei
	0x00212448, // n0x17a2 c0x0000 (---------------)  + I vennesla
	0x00212286, // n0x17a3 c0x0000 (---------------)  + I verdal
	0x00386a06, // n0x17a4 c0x0000 (---------------)  + I verran
	0x002b9c46, // n0x17a5 c0x0000 (---------------)  + I vestby
	0x422d9c88, // n0x17a6 c0x0108 (n0x1880-n0x1881)  o I vestfold
	0x002d9e87, // n0x17a7 c0x0000 (---------------)  + I vestnes
	0x002da30d, // n0x17a8 c0x0000 (---------------)  + I vestre-slidre
	0x002da90c, // n0x17a9 c0x0000 (---------------)  + I vestre-toten
	0x002daf09, // n0x17aa c0x0000 (---------------)  + I vestvagoy
	0x002db149, // n0x17ab c0x0000 (---------------)  + I vevelstad
	0x4273b4c2, // n0x17ac c0x0109 (n0x1881-n0x1882)  + I vf
	0x0038c903, // n0x17ad c0x0000 (---------------)  + I vgs
	0x00244c83, // n0x17ae c0x0000 (---------------)  + I vik
	0x00364745, // n0x17af c0x0000 (---------------)  + I vikna
	0x0037620a, // n0x17b0 c0x0000 (---------------)  + I vindafjord
	0x00302906, // n0x17b1 c0x0000 (---------------)  + I voagat
	0x002df605, // n0x17b2 c0x0000 (---------------)  + I volda
	0x002e21c4, // n0x17b3 c0x0000 (---------------)  + I voss
	0x002e21cb, // n0x17b4 c0x0000 (---------------)  + I vossevangen
	0x002f6e0c, // n0x17b5 c0x0000 (---------------)  + I xn--andy-ira
	0x002f764c, // n0x17b6 c0x0000 (---------------)  + I xn--asky-ira
	0x002f7955, // n0x17b7 c0x0000 (---------------)  + I xn--aurskog-hland-jnb
	0x002f984d, // n0x17b8 c0x0000 (---------------)  + I xn--avery-yua
	0x002fbb0f, // n0x17b9 c0x0000 (---------------)  + I xn--bdddj-mrabd
	0x002fbed2, // n0x17ba c0x0000 (---------------)  + I xn--bearalvhki-y4a
	0x002fc34f, // n0x17bb c0x0000 (---------------)  + I xn--berlevg-jxa
	0x002fc712, // n0x17bc c0x0000 (---------------)  + I xn--bhcavuotna-s4a
	0x002fcb93, // n0x17bd c0x0000 (---------------)  + I xn--bhccavuotna-k7a
	0x002fd04d, // n0x17be c0x0000 (---------------)  + I xn--bidr-5nac
	0x002fd60d, // n0x17bf c0x0000 (---------------)  + I xn--bievt-0qa
	0x002fd94e, // n0x17c0 c0x0000 (---------------)  + I xn--bjarky-fya
	0x002fde0e, // n0x17c1 c0x0000 (---------------)  + I xn--bjddar-pta
	0x002fec8c, // n0x17c2 c0x0000 (---------------)  + I xn--blt-elab
	0x002ff00c, // n0x17c3 c0x0000 (---------------)  + I xn--bmlo-gra
	0x002ff44b, // n0x17c4 c0x0000 (---------------)  + I xn--bod-2na
	0x002ff7ce, // n0x17c5 c0x0000 (---------------)  + I xn--brnny-wuac
	0x00301b92, // n0x17c6 c0x0000 (---------------)  + I xn--brnnysund-m8ac
	0x003026cc, // n0x17c7 c0x0000 (---------------)  + I xn--brum-voa
	0x00302e90, // n0x17c8 c0x0000 (---------------)  + I xn--btsfjord-9za
	0x003138d2, // n0x17c9 c0x0000 (---------------)  + I xn--davvenjrga-y4a
	0x0031458c, // n0x17ca c0x0000 (---------------)  + I xn--dnna-gra
	0x00314a4d, // n0x17cb c0x0000 (---------------)  + I xn--drbak-wua
	0x00314d8c, // n0x17cc c0x0000 (---------------)  + I xn--dyry-ira
	0x00317b91, // n0x17cd c0x0000 (---------------)  + I xn--eveni-0qa01ga
	0x00319c0d, // n0x17ce c0x0000 (---------------)  + I xn--finny-yua
	0x0031f74d, // n0x17cf c0x0000 (---------------)  + I xn--fjord-lra
	0x0031fd4a, // n0x17d0 c0x0000 (---------------)  + I xn--fl-zia
	0x0031ffcc, // n0x17d1 c0x0000 (---------------)  + I xn--flor-jra
	0x003208cc, // n0x17d2 c0x0000 (---------------)  + I xn--frde-gra
	0x0032110c, // n0x17d3 c0x0000 (---------------)  + I xn--frna-woa
	0x00321b0c, // n0x17d4 c0x0000 (---------------)  + I xn--frya-hra
	0x00324f13, // n0x17d5 c0x0000 (---------------)  + I xn--ggaviika-8ya47h
	0x00326650, // n0x17d6 c0x0000 (---------------)  + I xn--gildeskl-g0a
	0x00326a50, // n0x17d7 c0x0000 (---------------)  + I xn--givuotna-8ya
	0x0032714d, // n0x17d8 c0x0000 (---------------)  + I xn--gjvik-wua
	0x0032748c, // n0x17d9 c0x0000 (---------------)  + I xn--gls-elac
	0x00328189, // n0x17da c0x0000 (---------------)  + I xn--h-2fa
	0x0032900d, // n0x17db c0x0000 (---------------)  + I xn--hbmer-xqa
	0x00329353, // n0x17dc c0x0000 (---------------)  + I xn--hcesuolo-7ya35b
	0x0032c151, // n0x17dd c0x0000 (---------------)  + I xn--hgebostad-g3a
	0x0032c593, // n0x17de c0x0000 (---------------)  + I xn--hmmrfeasta-s4ac
	0x0032e38f, // n0x17df c0x0000 (---------------)  + I xn--hnefoss-q1a
	0x0032e74c, // n0x17e0 c0x0000 (---------------)  + I xn--hobl-ira
	0x0032ea4f, // n0x17e1 c0x0000 (---------------)  + I xn--holtlen-hxa
	0x0032ee0d, // n0x17e2 c0x0000 (---------------)  + I xn--hpmir-xqa
	0x0032f40f, // n0x17e3 c0x0000 (---------------)  + I xn--hyanger-q1a
	0x0032f7d0, // n0x17e4 c0x0000 (---------------)  + I xn--hylandet-54a
	0x0033024e, // n0x17e5 c0x0000 (---------------)  + I xn--indery-fya
	0x00332a0e, // n0x17e6 c0x0000 (---------------)  + I xn--jlster-bya
	0x00333150, // n0x17e7 c0x0000 (---------------)  + I xn--jrpeland-54a
	0x00333e8d, // n0x17e8 c0x0000 (---------------)  + I xn--karmy-yua
	0x0033480e, // n0x17e9 c0x0000 (---------------)  + I xn--kfjord-iua
	0x00334b8c, // n0x17ea c0x0000 (---------------)  + I xn--klbu-woa
	0x00336b53, // n0x17eb c0x0000 (---------------)  + I xn--koluokta-7ya57h
	0x0033934e, // n0x17ec c0x0000 (---------------)  + I xn--krager-gya
	0x00339b10, // n0x17ed c0x0000 (---------------)  + I xn--kranghke-b0a
	0x00339f11, // n0x17ee c0x0000 (---------------)  + I xn--krdsherad-m8a
	0x0033a34f, // n0x17ef c0x0000 (---------------)  + I xn--krehamn-dxa
	0x0033a713, // n0x17f0 c0x0000 (---------------)  + I xn--krjohka-hwab49j
	0x0033b04d, // n0x17f1 c0x0000 (---------------)  + I xn--ksnes-uua
	0x0033b38f, // n0x17f2 c0x0000 (---------------)  + I xn--kvfjord-nxa
	0x0033b74e, // n0x17f3 c0x0000 (---------------)  + I xn--kvitsy-fya
	0x0033d050, // n0x17f4 c0x0000 (---------------)  + I xn--kvnangen-k0a
	0x0033d449, // n0x17f5 c0x0000 (---------------)  + I xn--l-1fa
	0x0033e4d0, // n0x17f6 c0x0000 (---------------)  + I xn--laheadju-7ya
	0x0033f30f, // n0x17f7 c0x0000 (---------------)  + I xn--langevg-jxa
	0x0033f98f, // n0x17f8 c0x0000 (---------------)  + I xn--ldingen-q1a
	0x0033fd52, // n0x17f9 c0x0000 (---------------)  + I xn--leagaviika-52b
	0x00344a4e, // n0x17fa c0x0000 (---------------)  + I xn--lesund-hua
	0x0034534d, // n0x17fb c0x0000 (---------------)  + I xn--lgrd-poac
	0x00345bcd, // n0x17fc c0x0000 (---------------)  + I xn--lhppi-xqa
	0x00345f0d, // n0x17fd c0x0000 (---------------)  + I xn--linds-pra
	0x00347a8d, // n0x17fe c0x0000 (---------------)  + I xn--loabt-0qa
	0x00347dcd, // n0x17ff c0x0000 (---------------)  + I xn--lrdal-sra
	0x00348110, // n0x1800 c0x0000 (---------------)  + I xn--lrenskog-54a
	0x0034850b, // n0x1801 c0x0000 (---------------)  + I xn--lt-liac
	0x00348a8c, // n0x1802 c0x0000 (---------------)  + I xn--lten-gra
	0x00348e0c, // n0x1803 c0x0000 (---------------)  + I xn--lury-ira
	0x0034910c, // n0x1804 c0x0000 (---------------)  + I xn--mely-ira
	0x0034940e, // n0x1805 c0x0000 (---------------)  + I xn--merker-kua
	0x00356890, // n0x1806 c0x0000 (---------------)  + I xn--mjndalen-64a
	0x003581d2, // n0x1807 c0x0000 (---------------)  + I xn--mlatvuopmi-s4a
	0x0035864b, // n0x1808 c0x0000 (---------------)  + I xn--mli-tla
	0x00358a8e, // n0x1809 c0x0000 (---------------)  + I xn--mlselv-iua
	0x00358e0e, // n0x180a c0x0000 (---------------)  + I xn--moreke-jua
	0x0035960e, // n0x180b c0x0000 (---------------)  + I xn--mosjen-eya
	0x0035a4cb, // n0x180c c0x0000 (---------------)  + I xn--mot-tla
	0x42b5a856, // n0x180d c0x010a (n0x1882-n0x1884)  o I xn--mre-og-romsdal-qqb
	0x0035b4cd, // n0x180e c0x0000 (---------------)  + I xn--msy-ula0h
	0x0035b954, // n0x180f c0x0000 (---------------)  + I xn--mtta-vrjjat-k7af
	0x0035c38d, // n0x1810 c0x0000 (---------------)  + I xn--muost-0qa
	0x0035d715, // n0x1811 c0x0000 (---------------)  + I xn--nmesjevuemie-tcba
	0x0036060d, // n0x1812 c0x0000 (---------------)  + I xn--nry-yla5g
	0x00360f8f, // n0x1813 c0x0000 (---------------)  + I xn--nttery-byae
	0x00361bcf, // n0x1814 c0x0000 (---------------)  + I xn--nvuotna-hwa
	0x003652cf, // n0x1815 c0x0000 (---------------)  + I xn--oppegrd-ixa
	0x0036568e, // n0x1816 c0x0000 (---------------)  + I xn--ostery-fya
	0x00365d4d, // n0x1817 c0x0000 (---------------)  + I xn--osyro-wua
	0x00368211, // n0x1818 c0x0000 (---------------)  + I xn--porsgu-sta26f
	0x0036f34c, // n0x1819 c0x0000 (---------------)  + I xn--rady-ira
	0x0036f64c, // n0x181a c0x0000 (---------------)  + I xn--rdal-poa
	0x0036f94b, // n0x181b c0x0000 (---------------)  + I xn--rde-ula
	0x0036fc0c, // n0x181c c0x0000 (---------------)  + I xn--rdy-0nab
	0x0036ffcf, // n0x181d c0x0000 (---------------)  + I xn--rennesy-v1a
	0x00370392, // n0x181e c0x0000 (---------------)  + I xn--rhkkervju-01af
	0x00371acd, // n0x181f c0x0000 (---------------)  + I xn--rholt-mra
	0x00372d0c, // n0x1820 c0x0000 (---------------)  + I xn--risa-5na
	0x0037318c, // n0x1821 c0x0000 (---------------)  + I xn--risr-ira
	0x0037348d, // n0x1822 c0x0000 (---------------)  + I xn--rland-uua
	0x003737cf, // n0x1823 c0x0000 (---------------)  + I xn--rlingen-mxa
	0x00373b8e, // n0x1824 c0x0000 (---------------)  + I xn--rmskog-bya
	0x00375ecc, // n0x1825 c0x0000 (---------------)  + I xn--rros-gra
	0x0037648d, // n0x1826 c0x0000 (---------------)  + I xn--rskog-uua
	0x003767cb, // n0x1827 c0x0000 (---------------)  + I xn--rst-0na
	0x00376fcc, // n0x1828 c0x0000 (---------------)  + I xn--rsta-fra
	0x0037754d, // n0x1829 c0x0000 (---------------)  + I xn--ryken-vua
	0x0037788e, // n0x182a c0x0000 (---------------)  + I xn--ryrvik-bya
	0x00377d09, // n0x182b c0x0000 (---------------)  + I xn--s-1fa
	0x00378b53, // n0x182c c0x0000 (---------------)  + I xn--sandnessjen-ogb
	0x0037940d, // n0x182d c0x0000 (---------------)  + I xn--sandy-yua
	0x0037974d, // n0x182e c0x0000 (---------------)  + I xn--seral-lra
	0x00379d4c, // n0x182f c0x0000 (---------------)  + I xn--sgne-gra
	0x0037a1ce, // n0x1830 c0x0000 (---------------)  + I xn--skierv-uta
	0x0037b34f, // n0x1831 c0x0000 (---------------)  + I xn--skjervy-v1a
	0x0037b70c, // n0x1832 c0x0000 (---------------)  + I xn--skjk-soa
	0x0037ba0d, // n0x1833 c0x0000 (---------------)  + I xn--sknit-yqa
	0x0037bd4f, // n0x1834 c0x0000 (---------------)  + I xn--sknland-fxa
	0x0037c10c, // n0x1835 c0x0000 (---------------)  + I xn--slat-5na
	0x0037c74c, // n0x1836 c0x0000 (---------------)  + I xn--slt-elab
	0x0037cb0c, // n0x1837 c0x0000 (---------------)  + I xn--smla-hra
	0x0037ce0c, // n0x1838 c0x0000 (---------------)  + I xn--smna-gra
	0x0037d4cd, // n0x1839 c0x0000 (---------------)  + I xn--snase-nra
	0x0037d812, // n0x183a c0x0000 (---------------)  + I xn--sndre-land-0cb
	0x0037de8c, // n0x183b c0x0000 (---------------)  + I xn--snes-poa
	0x0037e18c, // n0x183c c0x0000 (---------------)  + I xn--snsa-roa
	0x0037e491, // n0x183d c0x0000 (---------------)  + I xn--sr-aurdal-l8a
	0x0037e8cf, // n0x183e c0x0000 (---------------)  + I xn--sr-fron-q1a
	0x0037ec8f, // n0x183f c0x0000 (---------------)  + I xn--sr-odal-q1a
	0x0037f053, // n0x1840 c0x0000 (---------------)  + I xn--sr-varanger-ggb
	0x003801ce, // n0x1841 c0x0000 (---------------)  + I xn--srfold-bya
	0x0038074f, // n0x1842 c0x0000 (---------------)  + I xn--srreisa-q1a
	0x00380b0c, // n0x1843 c0x0000 (---------------)  + I xn--srum-gra
	0x42f80e4e, // n0x1844 c0x010b (n0x1884-n0x1885)  o I xn--stfold-9xa
	0x003811cf, // n0x1845 c0x0000 (---------------)  + I xn--stjrdal-s1a
	0x00381596, // n0x1846 c0x0000 (---------------)  + I xn--stjrdalshalsen-sqb
	0x00382652, // n0x1847 c0x0000 (---------------)  + I xn--stre-toten-zcb
	0x0038448c, // n0x1848 c0x0000 (---------------)  + I xn--tjme-hra
	0x003850cf, // n0x1849 c0x0000 (---------------)  + I xn--tnsberg-q1a
	0x0038574d, // n0x184a c0x0000 (---------------)  + I xn--trany-yua
	0x00385a8f, // n0x184b c0x0000 (---------------)  + I xn--trgstad-r1a
	0x00385e4c, // n0x184c c0x0000 (---------------)  + I xn--trna-woa
	0x0038614d, // n0x184d c0x0000 (---------------)  + I xn--troms-zua
	0x0038648d, // n0x184e c0x0000 (---------------)  + I xn--tysvr-vra
	0x003876ce, // n0x184f c0x0000 (---------------)  + I xn--unjrga-rta
	0x0038850c, // n0x1850 c0x0000 (---------------)  + I xn--vads-jra
	0x0038880c, // n0x1851 c0x0000 (---------------)  + I xn--vard-jra
	0x00388b10, // n0x1852 c0x0000 (---------------)  + I xn--vegrshei-c0a
	0x0038b251, // n0x1853 c0x0000 (---------------)  + I xn--vestvgy-ixa6o
	0x0038b68b, // n0x1854 c0x0000 (---------------)  + I xn--vg-yiab
	0x0038c50c, // n0x1855 c0x0000 (---------------)  + I xn--vgan-qoa
	0x0038c80e, // n0x1856 c0x0000 (---------------)  + I xn--vgsy-qoa0j
	0x0038e511, // n0x1857 c0x0000 (---------------)  + I xn--vre-eiker-k8a
	0x0038e94e, // n0x1858 c0x0000 (---------------)  + I xn--vrggt-xqad
	0x0038eccd, // n0x1859 c0x0000 (---------------)  + I xn--vry-yla5g
	0x00392fcb, // n0x185a c0x0000 (---------------)  + I xn--yer-zna
	0x00393c0f, // n0x185b c0x0000 (---------------)  + I xn--ygarden-p1a
	0x00394594, // n0x185c c0x0000 (---------------)  + I xn--ystre-slidre-ujb
	0x0026cd02, // n0x185d c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x185e c0x0000 (---------------)  + I gs
	0x00201083, // n0x185f c0x0000 (---------------)  + I nes
	0x0026cd02, // n0x1860 c0x0000 (---------------)  + I gs
	0x00201083, // n0x1861 c0x0000 (---------------)  + I nes
	0x0026cd02, // n0x1862 c0x0000 (---------------)  + I gs
	0x00202382, // n0x1863 c0x0000 (---------------)  + I os
	0x00351305, // n0x1864 c0x0000 (---------------)  + I valer
	0x0038e20c, // n0x1865 c0x0000 (---------------)  + I xn--vler-qoa
	0x0026cd02, // n0x1866 c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x1867 c0x0000 (---------------)  + I gs
	0x00202382, // n0x1868 c0x0000 (---------------)  + I os
	0x0026cd02, // n0x1869 c0x0000 (---------------)  + I gs
	0x00280105, // n0x186a c0x0000 (---------------)  + I heroy
	0x0029dd05, // n0x186b c0x0000 (---------------)  + I sande
	0x0026cd02, // n0x186c c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x186d c0x0000 (---------------)  + I gs
	0x0020a702, // n0x186e c0x0000 (---------------)  + I bo
	0x00280105, // n0x186f c0x0000 (---------------)  + I heroy
	0x002fa209, // n0x1870 c0x0000 (---------------)  + I xn--b-5ga
	0x0032be4c, // n0x1871 c0x0000 (---------------)  + I xn--hery-ira
	0x0026cd02, // n0x1872 c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x1873 c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x1874 c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x1875 c0x0000 (---------------)  + I gs
	0x00351305, // n0x1876 c0x0000 (---------------)  + I valer
	0x0026cd02, // n0x1877 c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x1878 c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x1879 c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x187a c0x0000 (---------------)  + I gs
	0x0020a702, // n0x187b c0x0000 (---------------)  + I bo
	0x002fa209, // n0x187c c0x0000 (---------------)  + I xn--b-5ga
	0x0026cd02, // n0x187d c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x187e c0x0000 (---------------)  + I gs
	0x0026cd02, // n0x187f c0x0000 (---------------)  + I gs
	0x0029dd05, // n0x1880 c0x0000 (---------------)  + I sande
	0x0026cd02, // n0x1881 c0x0000 (---------------)  + I gs
	0x0029dd05, // n0x1882 c0x0000 (---------------)  + I sande
	0x0032be4c, // n0x1883 c0x0000 (---------------)  + I xn--hery-ira
	0x0038e20c, // n0x1884 c0x0000 (---------------)  + I xn--vler-qoa
	0x00310603, // n0x1885 c0x0000 (---------------)  + I biz
	0x00222ac3, // n0x1886 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1887 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1888 c0x0000 (---------------)  + I gov
	0x00200304, // n0x1889 c0x0000 (---------------)  + I info
	0x002170c3, // n0x188a c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x188b c0x0000 (---------------)  + I org
	0x00166bc8, // n0x188c c0x0000 (---------------)  +   merseine
	0x0007c1c4, // n0x188d c0x0000 (---------------)  +   mine
	0x000cb2c8, // n0x188e c0x0000 (---------------)  +   shacknet
	0x00201e82, // n0x188f c0x0000 (---------------)  + I ac
	0x43e00742, // n0x1890 c0x010f (n0x189f-n0x18a0)  + I co
	0x002319c3, // n0x1891 c0x0000 (---------------)  + I cri
	0x00252f84, // n0x1892 c0x0000 (---------------)  + I geek
	0x002012c3, // n0x1893 c0x0000 (---------------)  + I gen
	0x0021e284, // n0x1894 c0x0000 (---------------)  + I govt
	0x00205e06, // n0x1895 c0x0000 (---------------)  + I health
	0x002d2e03, // n0x1896 c0x0000 (---------------)  + I iwi
	0x002d2dc4, // n0x1897 c0x0000 (---------------)  + I kiwi
	0x002701c5, // n0x1898 c0x0000 (---------------)  + I maori
	0x0023fa03, // n0x1899 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x189a c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x189b c0x0000 (---------------)  + I org
	0x002647ca, // n0x189c c0x0000 (---------------)  + I parliament
	0x00235406, // n0x189d c0x0000 (---------------)  + I school
	0x0035918c, // n0x189e c0x0000 (---------------)  + I xn--mori-qsa
	0x000e4188, // n0x189f c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x18a0 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x18a1 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x18a2 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x18a3 c0x0000 (---------------)  + I gov
	0x0020b403, // n0x18a4 c0x0000 (---------------)  + I med
	0x002bd646, // n0x18a5 c0x0000 (---------------)  + I museum
	0x002170c3, // n0x18a6 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x18a7 c0x0000 (---------------)  + I org
	0x00218243, // n0x18a8 c0x0000 (---------------)  + I pro
	0x00004342, // n0x18a9 c0x0000 (---------------)  +   ae
	0x000d0087, // n0x18aa c0x0000 (---------------)  +   blogdns
	0x001619c8, // n0x18ab c0x0000 (---------------)  +   blogsite
	0x00076592, // n0x18ac c0x0000 (---------------)  +   boldlygoingnowhere
	0x44a2a085, // n0x18ad c0x0112 (n0x18e3-n0x18e5)  o I cdn77
	0x44f0720c, // n0x18ae c0x0113 (n0x18e5-n0x18e6)  o I cdn77-secure
	0x00146fc8, // n0x18af c0x0000 (---------------)  +   dnsalias
	0x0006a247, // n0x18b0 c0x0000 (---------------)  +   dnsdojo
	0x00010a4b, // n0x18b1 c0x0000 (---------------)  +   doesntexist
	0x0015fdc9, // n0x18b2 c0x0000 (---------------)  +   dontexist
	0x00146ec7, // n0x18b3 c0x0000 (---------------)  +   doomdns
	0x0006a147, // n0x18b4 c0x0000 (---------------)  +   duckdns
	0x00194fc6, // n0x18b5 c0x0000 (---------------)  +   dvrdns
	0x000007c8, // n0x18b6 c0x0000 (---------------)  +   dynalias
	0x45409ac6, // n0x18b7 c0x0115 (n0x18e7-n0x18e9)  +   dyndns
	0x0009428d, // n0x18b8 c0x0000 (---------------)  +   endofinternet
	0x000f3e50, // n0x18b9 c0x0000 (---------------)  +   endoftheinternet
	0x4581d5c2, // n0x18ba c0x0116 (n0x18e9-n0x1920)  +   eu
	0x00057807, // n0x18bb c0x0000 (---------------)  +   from-me
	0x00083589, // n0x18bc c0x0000 (---------------)  +   game-host
	0x00043a86, // n0x18bd c0x0000 (---------------)  +   gotdns
	0x0002ea02, // n0x18be c0x0000 (---------------)  +   hk
	0x0013eeca, // n0x18bf c0x0000 (---------------)  +   hobby-site
	0x0000b387, // n0x18c0 c0x0000 (---------------)  +   homedns
	0x00085007, // n0x18c1 c0x0000 (---------------)  +   homeftp
	0x00090ec9, // n0x18c2 c0x0000 (---------------)  +   homelinux
	0x00091b88, // n0x18c3 c0x0000 (---------------)  +   homeunix
	0x000c528e, // n0x18c4 c0x0000 (---------------)  +   is-a-bruinsfan
	0x00008d8e, // n0x18c5 c0x0000 (---------------)  +   is-a-candidate
	0x0000eecf, // n0x18c6 c0x0000 (---------------)  +   is-a-celticsfan
	0x00166909, // n0x18c7 c0x0000 (---------------)  +   is-a-chef
	0x00052e49, // n0x18c8 c0x0000 (---------------)  +   is-a-geek
	0x0006b8cb, // n0x18c9 c0x0000 (---------------)  +   is-a-knight
	0x001259cf, // n0x18ca c0x0000 (---------------)  +   is-a-linux-user
	0x0008480c, // n0x18cb c0x0000 (---------------)  +   is-a-patsfan
	0x000d23cb, // n0x18cc c0x0000 (---------------)  +   is-a-soxfan
	0x00103ac8, // n0x18cd c0x0000 (---------------)  +   is-found
	0x000d6887, // n0x18ce c0x0000 (---------------)  +   is-lost
	0x000e2908, // n0x18cf c0x0000 (---------------)  +   is-saved
	0x0012148b, // n0x18d0 c0x0000 (---------------)  +   is-very-bad
	0x00127b0c, // n0x18d1 c0x0000 (---------------)  +   is-very-evil
	0x00130a4c, // n0x18d2 c0x0000 (---------------)  +   is-very-good
	0x0013904c, // n0x18d3 c0x0000 (---------------)  +   is-very-nice
	0x0013bb8d, // n0x18d4 c0x0000 (---------------)  +   is-very-sweet
	0x00191648, // n0x18d5 c0x0000 (---------------)  +   isa-geek
	0x00183609, // n0x18d6 c0x0000 (---------------)  +   kicks-ass
	0x0016a6cb, // n0x18d7 c0x0000 (---------------)  +   misconfused
	0x000c7e07, // n0x18d8 c0x0000 (---------------)  +   podzone
	0x0016184a, // n0x18d9 c0x0000 (---------------)  +   readmyblog
	0x00130f46, // n0x18da c0x0000 (---------------)  +   selfip
	0x00084dcd, // n0x18db c0x0000 (---------------)  +   sellsyourhome
	0x00079088, // n0x18dc c0x0000 (---------------)  +   servebbs
	0x00161348, // n0x18dd c0x0000 (---------------)  +   serveftp
	0x00011f49, // n0x18de c0x0000 (---------------)  +   servegame
	0x000d044c, // n0x18df c0x0000 (---------------)  +   stuff-4-sale
	0x00009f42, // n0x18e0 c0x0000 (---------------)  +   us
	0x00110e86, // n0x18e1 c0x0000 (---------------)  +   webhop
	0x000043c2, // n0x18e2 c0x0000 (---------------)  +   za
	0x00000741, // n0x18e3 c0x0000 (---------------)  +   c
	0x000060c3, // n0x18e4 c0x0000 (---------------)  +   rsc
	0x45374606, // n0x18e5 c0x0114 (n0x18e6-n0x18e7)  o I origin
	0x0002a203, // n0x18e6 c0x0000 (---------------)  +   ssl
	0x00002342, // n0x18e7 c0x0000 (---------------)  +   go
	0x0000b384, // n0x18e8 c0x0000 (---------------)  +   home
	0x00000882, // n0x18e9 c0x0000 (---------------)  +   al
	0x000729c4, // n0x18ea c0x0000 (---------------)  +   asso
	0x00001642, // n0x18eb c0x0000 (---------------)  +   at
	0x00005ac2, // n0x18ec c0x0000 (---------------)  +   au
	0x00004702, // n0x18ed c0x0000 (---------------)  +   be
	0x00155e02, // n0x18ee c0x0000 (---------------)  +   bg
	0x000055c2, // n0x18ef c0x0000 (---------------)  +   ca
	0x0002a082, // n0x18f0 c0x0000 (---------------)  +   cd
	0x00004a02, // n0x18f1 c0x0000 (---------------)  +   ch
	0x000211c2, // n0x18f2 c0x0000 (---------------)  +   cn
	0x00029e42, // n0x18f3 c0x0000 (---------------)  +   cy
	0x00014442, // n0x18f4 c0x0000 (---------------)  +   cz
	0x000006c2, // n0x18f5 c0x0000 (---------------)  +   de
	0x00071742, // n0x18f6 c0x0000 (---------------)  +   dk
	0x000d75c3, // n0x18f7 c0x0000 (---------------)  +   edu
	0x00006042, // n0x18f8 c0x0000 (---------------)  +   ee
	0x000010c2, // n0x18f9 c0x0000 (---------------)  +   es
	0x000099c2, // n0x18fa c0x0000 (---------------)  +   fi
	0x00000d42, // n0x18fb c0x0000 (---------------)  +   fr
	0x0000dc82, // n0x18fc c0x0000 (---------------)  +   gr
	0x00025842, // n0x18fd c0x0000 (---------------)  +   hr
	0x00017d42, // n0x18fe c0x0000 (---------------)  +   hu
	0x00000e82, // n0x18ff c0x0000 (---------------)  +   ie
	0x000036c2, // n0x1900 c0x0000 (---------------)  +   il
	0x00000242, // n0x1901 c0x0000 (---------------)  +   in
	0x00038c03, // n0x1902 c0x0000 (---------------)  +   int
	0x00002b42, // n0x1903 c0x0000 (---------------)  +   is
	0x00006e82, // n0x1904 c0x0000 (---------------)  +   it
	0x000990c2, // n0x1905 c0x0000 (---------------)  +   jp
	0x000034c2, // n0x1906 c0x0000 (---------------)  +   kr
	0x00005ec2, // n0x1907 c0x0000 (---------------)  +   lt
	0x000071c2, // n0x1908 c0x0000 (---------------)  +   lu
	0x00027f02, // n0x1909 c0x0000 (---------------)  +   lv
	0x0003a6c2, // n0x190a c0x0000 (---------------)  +   mc
	0x00008942, // n0x190b c0x0000 (---------------)  +   me
	0x00156d82, // n0x190c c0x0000 (---------------)  +   mk
	0x00059642, // n0x190d c0x0000 (---------------)  +   mt
	0x00020282, // n0x190e c0x0000 (---------------)  +   my
	0x000170c3, // n0x190f c0x0000 (---------------)  +   net
	0x00001282, // n0x1910 c0x0000 (---------------)  +   ng
	0x00036482, // n0x1911 c0x0000 (---------------)  +   nl
	0x00000c02, // n0x1912 c0x0000 (---------------)  +   no
	0x000078c2, // n0x1913 c0x0000 (---------------)  +   nz
	0x0005b445, // n0x1914 c0x0000 (---------------)  +   paris
	0x00001e02, // n0x1915 c0x0000 (---------------)  +   pl
	0x00095982, // n0x1916 c0x0000 (---------------)  +   pt
	0x00123e03, // n0x1917 c0x0000 (---------------)  +   q-a
	0x00000d82, // n0x1918 c0x0000 (---------------)  +   ro
	0x000044c2, // n0x1919 c0x0000 (---------------)  +   ru
	0x00002e82, // n0x191a c0x0000 (---------------)  +   se
	0x00009182, // n0x191b c0x0000 (---------------)  +   si
	0x00007b42, // n0x191c c0x0000 (---------------)  +   sk
	0x00002402, // n0x191d c0x0000 (---------------)  +   tr
	0x0000cf02, // n0x191e c0x0000 (---------------)  +   uk
	0x00009f42, // n0x191f c0x0000 (---------------)  +   us
	0x0020c283, // n0x1920 c0x0000 (---------------)  + I abo
	0x00201e82, // n0x1921 c0x0000 (---------------)  + I ac
	0x00222ac3, // n0x1922 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1923 c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x1924 c0x0000 (---------------)  + I gob
	0x0020dc03, // n0x1925 c0x0000 (---------------)  + I ing
	0x0020b403, // n0x1926 c0x0000 (---------------)  + I med
	0x002170c3, // n0x1927 c0x0000 (---------------)  + I net
	0x00207cc3, // n0x1928 c0x0000 (---------------)  + I nom
	0x0021dcc3, // n0x1929 c0x0000 (---------------)  + I org
	0x00280043, // n0x192a c0x0000 (---------------)  + I sld
	0x000e4188, // n0x192b c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x192c c0x0000 (---------------)  + I com
	0x002d75c3, // n0x192d c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x192e c0x0000 (---------------)  + I gob
	0x0023fa03, // n0x192f c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1930 c0x0000 (---------------)  + I net
	0x00207cc3, // n0x1931 c0x0000 (---------------)  + I nom
	0x0021dcc3, // n0x1932 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x1933 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1934 c0x0000 (---------------)  + I edu
	0x0021dcc3, // n0x1935 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x1936 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1937 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1938 c0x0000 (---------------)  + I gov
	0x00200041, // n0x1939 c0x0000 (---------------)  + I i
	0x0023fa03, // n0x193a c0x0000 (---------------)  + I mil
	0x002170c3, // n0x193b c0x0000 (---------------)  + I net
	0x00202303, // n0x193c c0x0000 (---------------)  + I ngo
	0x0021dcc3, // n0x193d c0x0000 (---------------)  + I org
	0x00310603, // n0x193e c0x0000 (---------------)  + I biz
	0x00222ac3, // n0x193f c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1940 c0x0000 (---------------)  + I edu
	0x002a1b43, // n0x1941 c0x0000 (---------------)  + I fam
	0x0034eb03, // n0x1942 c0x0000 (---------------)  + I gob
	0x00375943, // n0x1943 c0x0000 (---------------)  + I gok
	0x0026f583, // n0x1944 c0x0000 (---------------)  + I gon
	0x0028e783, // n0x1945 c0x0000 (---------------)  + I gop
	0x00202343, // n0x1946 c0x0000 (---------------)  + I gos
	0x0021e283, // n0x1947 c0x0000 (---------------)  + I gov
	0x00200304, // n0x1948 c0x0000 (---------------)  + I info
	0x002170c3, // n0x1949 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x194a c0x0000 (---------------)  + I org
	0x00219fc3, // n0x194b c0x0000 (---------------)  + I web
	0x002f8f84, // n0x194c c0x0000 (---------------)  + I agro
	0x002375c3, // n0x194d c0x0000 (---------------)  + I aid
	0x00000603, // n0x194e c0x0000 (---------------)  +   art
	0x0026a983, // n0x194f c0x0000 (---------------)  + I atm
	0x0023e708, // n0x1950 c0x0000 (---------------)  + I augustow
	0x002eaac4, // n0x1951 c0x0000 (---------------)  + I auto
	0x0032d4ca, // n0x1952 c0x0000 (---------------)  + I babia-gora
	0x0034d4c6, // n0x1953 c0x0000 (---------------)  + I bedzin
	0x0035ad87, // n0x1954 c0x0000 (---------------)  + I beskidy
	0x0021604a, // n0x1955 c0x0000 (---------------)  + I bialowieza
	0x00228a89, // n0x1956 c0x0000 (---------------)  + I bialystok
	0x0037f4c7, // n0x1957 c0x0000 (---------------)  + I bielawa
	0x00382a8a, // n0x1958 c0x0000 (---------------)  + I bieszczady
	0x00310603, // n0x1959 c0x0000 (---------------)  + I biz
	0x0025374b, // n0x195a c0x0000 (---------------)  + I boleslawiec
	0x00343289, // n0x195b c0x0000 (---------------)  + I bydgoszcz
	0x002b9d45, // n0x195c c0x0000 (---------------)  + I bytom
	0x002bb407, // n0x195d c0x0000 (---------------)  + I cieszyn
	0x00000742, // n0x195e c0x0000 (---------------)  +   co
	0x00222ac3, // n0x195f c0x0000 (---------------)  + I com
	0x002c8a87, // n0x1960 c0x0000 (---------------)  + I czeladz
	0x00214445, // n0x1961 c0x0000 (---------------)  + I czest
	0x002aae49, // n0x1962 c0x0000 (---------------)  + I dlugoleka
	0x002d75c3, // n0x1963 c0x0000 (---------------)  + I edu
	0x0021b206, // n0x1964 c0x0000 (---------------)  + I elblag
	0x002aa003, // n0x1965 c0x0000 (---------------)  + I elk
	0x000b7a43, // n0x1966 c0x0000 (---------------)  +   gda
	0x000e1246, // n0x1967 c0x0000 (---------------)  +   gdansk
	0x0016e4c6, // n0x1968 c0x0000 (---------------)  +   gdynia
	0x0014ee47, // n0x1969 c0x0000 (---------------)  +   gliwice
	0x00391046, // n0x196a c0x0000 (---------------)  + I glogow
	0x002047c5, // n0x196b c0x0000 (---------------)  + I gmina
	0x0031b347, // n0x196c c0x0000 (---------------)  + I gniezno
	0x002b1487, // n0x196d c0x0000 (---------------)  + I gorlice
	0x4761e283, // n0x196e c0x011d (n0x19f1-n0x1a20)  + I gov
	0x003147c7, // n0x196f c0x0000 (---------------)  + I grajewo
	0x0034b2c3, // n0x1970 c0x0000 (---------------)  + I gsm
	0x0036cb05, // n0x1971 c0x0000 (---------------)  + I ilawa
	0x00200304, // n0x1972 c0x0000 (---------------)  + I info
	0x0020a8c8, // n0x1973 c0x0000 (---------------)  + I jaworzno
	0x0020c80c, // n0x1974 c0x0000 (---------------)  + I jelenia-gora
	0x00297b45, // n0x1975 c0x0000 (---------------)  + I jgora
	0x002bed46, // n0x1976 c0x0000 (---------------)  + I kalisz
	0x002c8947, // n0x1977 c0x0000 (---------------)  + I karpacz
	0x002017c7, // n0x1978 c0x0000 (---------------)  + I kartuzy
	0x00216a07, // n0x1979 c0x0000 (---------------)  + I kaszuby
	0x00217888, // n0x197a c0x0000 (---------------)  + I katowice
	0x0036730f, // n0x197b c0x0000 (---------------)  + I kazimierz-dolny
	0x0023df05, // n0x197c c0x0000 (---------------)  + I kepno
	0x00231ac7, // n0x197d c0x0000 (---------------)  + I ketrzyn
	0x002a3547, // n0x197e c0x0000 (---------------)  + I klodzko
	0x0029058a, // n0x197f c0x0000 (---------------)  + I kobierzyce
	0x00295709, // n0x1980 c0x0000 (---------------)  + I kolobrzeg
	0x002bbf45, // n0x1981 c0x0000 (---------------)  + I konin
	0x002bdf8a, // n0x1982 c0x0000 (---------------)  + I konskowola
	0x0011bec6, // n0x1983 c0x0000 (---------------)  +   krakow
	0x002aa085, // n0x1984 c0x0000 (---------------)  + I kutno
	0x002be184, // n0x1985 c0x0000 (---------------)  + I lapy
	0x002c8806, // n0x1986 c0x0000 (---------------)  + I lebork
	0x00322207, // n0x1987 c0x0000 (---------------)  + I legnica
	0x002bde07, // n0x1988 c0x0000 (---------------)  + I lezajsk
	0x0036d448, // n0x1989 c0x0000 (---------------)  + I limanowa
	0x002c6b85, // n0x198a c0x0000 (---------------)  + I lomza
	0x00214346, // n0x198b c0x0000 (---------------)  + I lowicz
	0x00218fc5, // n0x198c c0x0000 (---------------)  + I lubin
	0x0029b345, // n0x198d c0x0000 (---------------)  + I lukow
	0x00218f04, // n0x198e c0x0000 (---------------)  + I mail
	0x00321887, // n0x198f c0x0000 (---------------)  + I malbork
	0x0030ff4a, // n0x1990 c0x0000 (---------------)  + I malopolska
	0x0020b988, // n0x1991 c0x0000 (---------------)  + I mazowsze
	0x002d2a06, // n0x1992 c0x0000 (---------------)  + I mazury
	0x0000b403, // n0x1993 c0x0000 (---------------)  +   med
	0x002dc385, // n0x1994 c0x0000 (---------------)  + I media
	0x00232386, // n0x1995 c0x0000 (---------------)  + I miasta
	0x00381e06, // n0x1996 c0x0000 (---------------)  + I mielec
	0x002f0806, // n0x1997 c0x0000 (---------------)  + I mielno
	0x0023fa03, // n0x1998 c0x0000 (---------------)  + I mil
	0x00371d47, // n0x1999 c0x0000 (---------------)  + I mragowo
	0x002a34c5, // n0x199a c0x0000 (---------------)  + I naklo
	0x002170c3, // n0x199b c0x0000 (---------------)  + I net
	0x0037f74d, // n0x199c c0x0000 (---------------)  + I nieruchomosci
	0x00207cc3, // n0x199d c0x0000 (---------------)  + I nom
	0x0036d548, // n0x199e c0x0000 (---------------)  + I nowaruda
	0x00210944, // n0x199f c0x0000 (---------------)  + I nysa
	0x00264105, // n0x19a0 c0x0000 (---------------)  + I olawa
	0x00290486, // n0x19a1 c0x0000 (---------------)  + I olecko
	0x002c1f06, // n0x19a2 c0x0000 (---------------)  + I olkusz
	0x0020f9c7, // n0x19a3 c0x0000 (---------------)  + I olsztyn
	0x00228dc7, // n0x19a4 c0x0000 (---------------)  + I opoczno
	0x00246a05, // n0x19a5 c0x0000 (---------------)  + I opole
	0x0021dcc3, // n0x19a6 c0x0000 (---------------)  + I org
	0x00202387, // n0x19a7 c0x0000 (---------------)  + I ostroda
	0x00203b09, // n0x19a8 c0x0000 (---------------)  + I ostroleka
	0x002053c9, // n0x19a9 c0x0000 (---------------)  + I ostrowiec
	0x0020818a, // n0x19aa c0x0000 (---------------)  + I ostrowwlkp
	0x00203e02, // n0x19ab c0x0000 (---------------)  + I pc
	0x0036cac4, // n0x19ac c0x0000 (---------------)  + I pila
	0x002c2d84, // n0x19ad c0x0000 (---------------)  + I pisz
	0x00210607, // n0x19ae c0x0000 (---------------)  + I podhale
	0x0023b508, // n0x19af c0x0000 (---------------)  + I podlasie
	0x002c8cc9, // n0x19b0 c0x0000 (---------------)  + I polkowice
	0x00207a09, // n0x19b1 c0x0000 (---------------)  + I pomorskie
	0x002c9507, // n0x19b2 c0x0000 (---------------)  + I pomorze
	0x0026a886, // n0x19b3 c0x0000 (---------------)  + I powiat
	0x000ca606, // n0x19b4 c0x0000 (---------------)  +   poznan
	0x002cba44, // n0x19b5 c0x0000 (---------------)  + I priv
	0x002cbbca, // n0x19b6 c0x0000 (---------------)  + I prochowice
	0x002cd2c8, // n0x19b7 c0x0000 (---------------)  + I pruszkow
	0x002cdec9, // n0x19b8 c0x0000 (---------------)  + I przeworsk
	0x00281bc6, // n0x19b9 c0x0000 (---------------)  + I pulawy
	0x002e8285, // n0x19ba c0x0000 (---------------)  + I radom
	0x0020b848, // n0x19bb c0x0000 (---------------)  + I rawa-maz
	0x002b174a, // n0x19bc c0x0000 (---------------)  + I realestate
	0x00241283, // n0x19bd c0x0000 (---------------)  + I rel
	0x00226746, // n0x19be c0x0000 (---------------)  + I rybnik
	0x002c9607, // n0x19bf c0x0000 (---------------)  + I rzeszow
	0x0020b505, // n0x19c0 c0x0000 (---------------)  + I sanok
	0x00375a45, // n0x19c1 c0x0000 (---------------)  + I sejny
	0x0029acc3, // n0x19c2 c0x0000 (---------------)  + I sex
	0x0029b184, // n0x19c3 c0x0000 (---------------)  + I shop
	0x0021cd45, // n0x19c4 c0x0000 (---------------)  + I sklep
	0x00270687, // n0x19c5 c0x0000 (---------------)  + I skoczow
	0x00212585, // n0x19c6 c0x0000 (---------------)  + I slask
	0x002c1646, // n0x19c7 c0x0000 (---------------)  + I slupsk
	0x000ddd85, // n0x19c8 c0x0000 (---------------)  +   sopot
	0x0021c283, // n0x19c9 c0x0000 (---------------)  + I sos
	0x0021c289, // n0x19ca c0x0000 (---------------)  + I sosnowiec
	0x00263ecc, // n0x19cb c0x0000 (---------------)  + I stalowa-wola
	0x0029720c, // n0x19cc c0x0000 (---------------)  + I starachowice
	0x002b8648, // n0x19cd c0x0000 (---------------)  + I stargard
	0x00325847, // n0x19ce c0x0000 (---------------)  + I suwalki
	0x002d4d08, // n0x19cf c0x0000 (---------------)  + I swidnica
	0x002d590a, // n0x19d0 c0x0000 (---------------)  + I swiebodzin
	0x002d608b, // n0x19d1 c0x0000 (---------------)  + I swinoujscie
	0x003433c8, // n0x19d2 c0x0000 (---------------)  + I szczecin
	0x002bee48, // n0x19d3 c0x0000 (---------------)  + I szczytno
	0x00207586, // n0x19d4 c0x0000 (---------------)  + I szkola
	0x0030a185, // n0x19d5 c0x0000 (---------------)  + I targi
	0x0030ebca, // n0x19d6 c0x0000 (---------------)  + I tarnobrzeg
	0x0021e345, // n0x19d7 c0x0000 (---------------)  + I tgory
	0x00208902, // n0x19d8 c0x0000 (---------------)  + I tm
	0x002ae287, // n0x19d9 c0x0000 (---------------)  + I tourism
	0x0027f186, // n0x19da c0x0000 (---------------)  + I travel
	0x0033de05, // n0x19db c0x0000 (---------------)  + I turek
	0x002d8689, // n0x19dc c0x0000 (---------------)  + I turystyka
	0x0036b4c5, // n0x19dd c0x0000 (---------------)  + I tychy
	0x0027af05, // n0x19de c0x0000 (---------------)  + I ustka
	0x0036c6c9, // n0x19df c0x0000 (---------------)  + I walbrzych
	0x00232206, // n0x19e0 c0x0000 (---------------)  + I warmia
	0x00250f08, // n0x19e1 c0x0000 (---------------)  + I warszawa
	0x002c7183, // n0x19e2 c0x0000 (---------------)  + I waw
	0x00391186, // n0x19e3 c0x0000 (---------------)  + I wegrow
	0x00263586, // n0x19e4 c0x0000 (---------------)  + I wielun
	0x002e2d45, // n0x19e5 c0x0000 (---------------)  + I wlocl
	0x002e2d49, // n0x19e6 c0x0000 (---------------)  + I wloclawek
	0x0030b189, // n0x19e7 c0x0000 (---------------)  + I wodzislaw
	0x002609c7, // n0x19e8 c0x0000 (---------------)  + I wolomin
	0x000e2bc4, // n0x19e9 c0x0000 (---------------)  +   wroc
	0x002e2bc7, // n0x19ea c0x0000 (---------------)  + I wroclaw
	0x00207909, // n0x19eb c0x0000 (---------------)  + I zachpomor
	0x00216245, // n0x19ec c0x0000 (---------------)  + I zagan
	0x0002bf08, // n0x19ed c0x0000 (---------------)  +   zakopane
	0x00310d85, // n0x19ee c0x0000 (---------------)  + I zarow
	0x00217185, // n0x19ef c0x0000 (---------------)  + I zgora
	0x0021e549, // n0x19f0 c0x0000 (---------------)  + I zgorzelec
	0x002105c2, // n0x19f1 c0x0000 (---------------)  + I ap
	0x00253e04, // n0x19f2 c0x0000 (---------------)  + I griw
	0x00200b42, // n0x19f3 c0x0000 (---------------)  + I ic
	0x00202b42, // n0x19f4 c0x0000 (---------------)  + I is
	0x00268d85, // n0x19f5 c0x0000 (---------------)  + I kmpsp
	0x002c1788, // n0x19f6 c0x0000 (---------------)  + I konsulat
	0x00379185, // n0x19f7 c0x0000 (---------------)  + I kppsp
	0x002ac643, // n0x19f8 c0x0000 (---------------)  + I kwp
	0x002ac645, // n0x19f9 c0x0000 (---------------)  + I kwpsp
	0x002bb7c3, // n0x19fa c0x0000 (---------------)  + I mup
	0x0020a142, // n0x19fb c0x0000 (---------------)  + I mw
	0x002d3fc4, // n0x19fc c0x0000 (---------------)  + I oirm
	0x002f3c43, // n0x19fd c0x0000 (---------------)  + I oum
	0x002052c2, // n0x19fe c0x0000 (---------------)  + I pa
	0x0036be84, // n0x19ff c0x0000 (---------------)  + I pinb
	0x002c3b43, // n0x1a00 c0x0000 (---------------)  + I piw
	0x00203f02, // n0x1a01 c0x0000 (---------------)  + I po
	0x002369c3, // n0x1a02 c0x0000 (---------------)  + I psp
	0x0027ac04, // n0x1a03 c0x0000 (---------------)  + I psse
	0x002a32c3, // n0x1a04 c0x0000 (---------------)  + I pup
	0x00370ac4, // n0x1a05 c0x0000 (---------------)  + I rzgw
	0x00201a02, // n0x1a06 c0x0000 (---------------)  + I sa
	0x0025ebc3, // n0x1a07 c0x0000 (---------------)  + I sdn
	0x002206c3, // n0x1a08 c0x0000 (---------------)  + I sko
	0x00201102, // n0x1a09 c0x0000 (---------------)  + I so
	0x002ceec2, // n0x1a0a c0x0000 (---------------)  + I sr
	0x0030afc9, // n0x1a0b c0x0000 (---------------)  + I starostwo
	0x00205082, // n0x1a0c c0x0000 (---------------)  + I ug
	0x0031c4c4, // n0x1a0d c0x0000 (---------------)  + I ugim
	0x00209802, // n0x1a0e c0x0000 (---------------)  + I um
	0x0020b6c4, // n0x1a0f c0x0000 (---------------)  + I umig
	0x0026a844, // n0x1a10 c0x0000 (---------------)  + I upow
	0x00243ec4, // n0x1a11 c0x0000 (---------------)  + I uppo
	0x00209f42, // n0x1a12 c0x0000 (---------------)  + I us
	0x0022f3c2, // n0x1a13 c0x0000 (---------------)  + I uw
	0x0020c583, // n0x1a14 c0x0000 (---------------)  + I uzs
	0x00345983, // n0x1a15 c0x0000 (---------------)  + I wif
	0x002310c4, // n0x1a16 c0x0000 (---------------)  + I wiih
	0x00270804, // n0x1a17 c0x0000 (---------------)  + I winb
	0x002b8984, // n0x1a18 c0x0000 (---------------)  + I wios
	0x002c9784, // n0x1a19 c0x0000 (---------------)  + I witd
	0x0030b383, // n0x1a1a c0x0000 (---------------)  + I wiw
	0x002725c3, // n0x1a1b c0x0000 (---------------)  + I wsa
	0x0031be44, // n0x1a1c c0x0000 (---------------)  + I wskr
	0x002e3d44, // n0x1a1d c0x0000 (---------------)  + I wuoz
	0x002e4546, // n0x1a1e c0x0000 (---------------)  + I wzmiuw
	0x002c2042, // n0x1a1f c0x0000 (---------------)  + I zp
	0x00200742, // n0x1a20 c0x0000 (---------------)  + I co
	0x002d75c3, // n0x1a21 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1a22 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1a23 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1a24 c0x0000 (---------------)  + I org
	0x00201e82, // n0x1a25 c0x0000 (---------------)  + I ac
	0x00310603, // n0x1a26 c0x0000 (---------------)  + I biz
	0x00222ac3, // n0x1a27 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1a28 c0x0000 (---------------)  + I edu
	0x00208883, // n0x1a29 c0x0000 (---------------)  + I est
	0x0021e283, // n0x1a2a c0x0000 (---------------)  + I gov
	0x00200304, // n0x1a2b c0x0000 (---------------)  + I info
	0x0030b284, // n0x1a2c c0x0000 (---------------)  + I isla
	0x00298944, // n0x1a2d c0x0000 (---------------)  + I name
	0x002170c3, // n0x1a2e c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1a2f c0x0000 (---------------)  + I org
	0x00218243, // n0x1a30 c0x0000 (---------------)  + I pro
	0x002cc284, // n0x1a31 c0x0000 (---------------)  + I prof
	0x002f2783, // n0x1a32 c0x0000 (---------------)  + I aca
	0x0020c103, // n0x1a33 c0x0000 (---------------)  + I bar
	0x0025b403, // n0x1a34 c0x0000 (---------------)  + I cpa
	0x002674c3, // n0x1a35 c0x0000 (---------------)  + I eng
	0x0029d803, // n0x1a36 c0x0000 (---------------)  + I jur
	0x00253883, // n0x1a37 c0x0000 (---------------)  + I law
	0x0020b403, // n0x1a38 c0x0000 (---------------)  + I med
	0x00222ac3, // n0x1a39 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1a3a c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1a3b c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1a3c c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1a3d c0x0000 (---------------)  + I org
	0x002c6b43, // n0x1a3e c0x0000 (---------------)  + I plo
	0x00223f83, // n0x1a3f c0x0000 (---------------)  + I sec
	0x000e4188, // n0x1a40 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1a41 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1a42 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1a43 c0x0000 (---------------)  + I gov
	0x00238c03, // n0x1a44 c0x0000 (---------------)  + I int
	0x002170c3, // n0x1a45 c0x0000 (---------------)  + I net
	0x0022cb84, // n0x1a46 c0x0000 (---------------)  + I nome
	0x0021dcc3, // n0x1a47 c0x0000 (---------------)  + I org
	0x00296544, // n0x1a48 c0x0000 (---------------)  + I publ
	0x00251645, // n0x1a49 c0x0000 (---------------)  + I belau
	0x00200742, // n0x1a4a c0x0000 (---------------)  + I co
	0x00203fc2, // n0x1a4b c0x0000 (---------------)  + I ed
	0x00202342, // n0x1a4c c0x0000 (---------------)  + I go
	0x00201082, // n0x1a4d c0x0000 (---------------)  + I ne
	0x00200c42, // n0x1a4e c0x0000 (---------------)  + I or
	0x00222ac3, // n0x1a4f c0x0000 (---------------)  + I com
	0x00228d44, // n0x1a50 c0x0000 (---------------)  + I coop
	0x002d75c3, // n0x1a51 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1a52 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x1a53 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1a54 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1a55 c0x0000 (---------------)  + I org
	0x000e4188, // n0x1a56 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1a57 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1a58 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1a59 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x1a5a c0x0000 (---------------)  + I mil
	0x00298944, // n0x1a5b c0x0000 (---------------)  + I name
	0x002170c3, // n0x1a5c c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1a5d c0x0000 (---------------)  + I org
	0x00206103, // n0x1a5e c0x0000 (---------------)  + I sch
	0x002729c4, // n0x1a5f c0x0000 (---------------)  + I asso
	0x000e4188, // n0x1a60 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1a61 c0x0000 (---------------)  + I com
	0x00207cc3, // n0x1a62 c0x0000 (---------------)  + I nom
	0x00246584, // n0x1a63 c0x0000 (---------------)  + I arts
	0x000e4188, // n0x1a64 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1a65 c0x0000 (---------------)  + I com
	0x00238544, // n0x1a66 c0x0000 (---------------)  + I firm
	0x00200304, // n0x1a67 c0x0000 (---------------)  + I info
	0x00207cc3, // n0x1a68 c0x0000 (---------------)  + I nom
	0x00200e02, // n0x1a69 c0x0000 (---------------)  + I nt
	0x0021dcc3, // n0x1a6a c0x0000 (---------------)  + I org
	0x002e6343, // n0x1a6b c0x0000 (---------------)  + I rec
	0x002cf4c5, // n0x1a6c c0x0000 (---------------)  + I store
	0x00208902, // n0x1a6d c0x0000 (---------------)  + I tm
	0x002e3e83, // n0x1a6e c0x0000 (---------------)  + I www
	0x00201e82, // n0x1a6f c0x0000 (---------------)  + I ac
	0x000e4188, // n0x1a70 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x1a71 c0x0000 (---------------)  + I co
	0x002d75c3, // n0x1a72 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1a73 c0x0000 (---------------)  + I gov
	0x00200242, // n0x1a74 c0x0000 (---------------)  + I in
	0x0021dcc3, // n0x1a75 c0x0000 (---------------)  + I org
	0x00201e82, // n0x1a76 c0x0000 (---------------)  + I ac
	0x00382c47, // n0x1a77 c0x0000 (---------------)  + I adygeya
	0x0028ee05, // n0x1a78 c0x0000 (---------------)  + I altai
	0x00248504, // n0x1a79 c0x0000 (---------------)  + I amur
	0x0036ab06, // n0x1a7a c0x0000 (---------------)  + I amursk
	0x002f314b, // n0x1a7b c0x0000 (---------------)  + I arkhangelsk
	0x002e9b49, // n0x1a7c c0x0000 (---------------)  + I astrakhan
	0x002bec86, // n0x1a7d c0x0000 (---------------)  + I baikal
	0x00309449, // n0x1a7e c0x0000 (---------------)  + I bashkiria
	0x002c1a08, // n0x1a7f c0x0000 (---------------)  + I belgorod
	0x00200503, // n0x1a80 c0x0000 (---------------)  + I bir
	0x000e4188, // n0x1a81 c0x0000 (---------------)  +   blogspot
	0x0021cc07, // n0x1a82 c0x0000 (---------------)  + I bryansk
	0x0021bc88, // n0x1a83 c0x0000 (---------------)  + I buryatia
	0x00355dc3, // n0x1a84 c0x0000 (---------------)  + I cbg
	0x002503c4, // n0x1a85 c0x0000 (---------------)  + I chel
	0x002539cb, // n0x1a86 c0x0000 (---------------)  + I chelyabinsk
	0x002932c5, // n0x1a87 c0x0000 (---------------)  + I chita
	0x002ab708, // n0x1a88 c0x0000 (---------------)  + I chukotka
	0x00313689, // n0x1a89 c0x0000 (---------------)  + I chuvashia
	0x00249083, // n0x1a8a c0x0000 (---------------)  + I cmw
	0x00222ac3, // n0x1a8b c0x0000 (---------------)  + I com
	0x00309888, // n0x1a8c c0x0000 (---------------)  + I dagestan
	0x002d3887, // n0x1a8d c0x0000 (---------------)  + I dudinka
	0x00311a46, // n0x1a8e c0x0000 (---------------)  + I e-burg
	0x002d75c3, // n0x1a8f c0x0000 (---------------)  + I edu
	0x0032aa47, // n0x1a90 c0x0000 (---------------)  + I fareast
	0x0021e283, // n0x1a91 c0x0000 (---------------)  + I gov
	0x003789c6, // n0x1a92 c0x0000 (---------------)  + I grozny
	0x00238c03, // n0x1a93 c0x0000 (---------------)  + I int
	0x00220587, // n0x1a94 c0x0000 (---------------)  + I irkutsk
	0x002f2a47, // n0x1a95 c0x0000 (---------------)  + I ivanovo
	0x00379007, // n0x1a96 c0x0000 (---------------)  + I izhevsk
	0x00321805, // n0x1a97 c0x0000 (---------------)  + I jamal
	0x00202683, // n0x1a98 c0x0000 (---------------)  + I jar
	0x002a248b, // n0x1a99 c0x0000 (---------------)  + I joshkar-ola
	0x00312348, // n0x1a9a c0x0000 (---------------)  + I k-uralsk
	0x002201c8, // n0x1a9b c0x0000 (---------------)  + I kalmykia
	0x00305446, // n0x1a9c c0x0000 (---------------)  + I kaluga
	0x0023a649, // n0x1a9d c0x0000 (---------------)  + I kamchatka
	0x00365ac7, // n0x1a9e c0x0000 (---------------)  + I karelia
	0x002dec85, // n0x1a9f c0x0000 (---------------)  + I kazan
	0x0022d2c4, // n0x1aa0 c0x0000 (---------------)  + I kchr
	0x00271548, // n0x1aa1 c0x0000 (---------------)  + I kemerovo
	0x00235f8a, // n0x1aa2 c0x0000 (---------------)  + I khabarovsk
	0x002361c9, // n0x1aa3 c0x0000 (---------------)  + I khakassia
	0x0025be03, // n0x1aa4 c0x0000 (---------------)  + I khv
	0x00254bc5, // n0x1aa5 c0x0000 (---------------)  + I kirov
	0x00325683, // n0x1aa6 c0x0000 (---------------)  + I kms
	0x002b9586, // n0x1aa7 c0x0000 (---------------)  + I koenig
	0x003935c4, // n0x1aa8 c0x0000 (---------------)  + I komi
	0x002e2f48, // n0x1aa9 c0x0000 (---------------)  + I kostroma
	0x0039334b, // n0x1aaa c0x0000 (---------------)  + I krasnoyarsk
	0x00331845, // n0x1aab c0x0000 (---------------)  + I kuban
	0x002a4ac6, // n0x1aac c0x0000 (---------------)  + I kurgan
	0x002a8e85, // n0x1aad c0x0000 (---------------)  + I kursk
	0x002a9608, // n0x1aae c0x0000 (---------------)  + I kustanai
	0x002aa1c7, // n0x1aaf c0x0000 (---------------)  + I kuzbass
	0x003414c7, // n0x1ab0 c0x0000 (---------------)  + I lipetsk
	0x0032ddc7, // n0x1ab1 c0x0000 (---------------)  + I magadan
	0x00271948, // n0x1ab2 c0x0000 (---------------)  + I magnitka
	0x00216504, // n0x1ab3 c0x0000 (---------------)  + I mari
	0x00216507, // n0x1ab4 c0x0000 (---------------)  + I mari-el
	0x003529c6, // n0x1ab5 c0x0000 (---------------)  + I marine
	0x0023fa03, // n0x1ab6 c0x0000 (---------------)  + I mil
	0x002b4208, // n0x1ab7 c0x0000 (---------------)  + I mordovia
	0x00233f43, // n0x1ab8 c0x0000 (---------------)  + I msk
	0x002bbd88, // n0x1ab9 c0x0000 (---------------)  + I murmansk
	0x002bf205, // n0x1aba c0x0000 (---------------)  + I mytis
	0x00332688, // n0x1abb c0x0000 (---------------)  + I nakhodka
	0x00375747, // n0x1abc c0x0000 (---------------)  + I nalchik
	0x002170c3, // n0x1abd c0x0000 (---------------)  + I net
	0x002effc3, // n0x1abe c0x0000 (---------------)  + I nkz
	0x00278ec4, // n0x1abf c0x0000 (---------------)  + I nnov
	0x00228f07, // n0x1ac0 c0x0000 (---------------)  + I norilsk
	0x00201343, // n0x1ac1 c0x0000 (---------------)  + I nov
	0x002f2b0b, // n0x1ac2 c0x0000 (---------------)  + I novosibirsk
	0x00217803, // n0x1ac3 c0x0000 (---------------)  + I nsk
	0x00233f04, // n0x1ac4 c0x0000 (---------------)  + I omsk
	0x002cf548, // n0x1ac5 c0x0000 (---------------)  + I orenburg
	0x0021dcc3, // n0x1ac6 c0x0000 (---------------)  + I org
	0x002c98c5, // n0x1ac7 c0x0000 (---------------)  + I oryol
	0x002e3305, // n0x1ac8 c0x0000 (---------------)  + I oskol
	0x00332586, // n0x1ac9 c0x0000 (---------------)  + I palana
	0x00395385, // n0x1aca c0x0000 (---------------)  + I penza
	0x002bf5c4, // n0x1acb c0x0000 (---------------)  + I perm
	0x00207742, // n0x1acc c0x0000 (---------------)  + I pp
	0x002ce183, // n0x1acd c0x0000 (---------------)  + I ptz
	0x002be20a, // n0x1ace c0x0000 (---------------)  + I pyatigorsk
	0x002ef043, // n0x1acf c0x0000 (---------------)  + I rnd
	0x0030c189, // n0x1ad0 c0x0000 (---------------)  + I rubtsovsk
	0x003227c6, // n0x1ad1 c0x0000 (---------------)  + I ryazan
	0x00217648, // n0x1ad2 c0x0000 (---------------)  + I sakhalin
	0x0027a746, // n0x1ad3 c0x0000 (---------------)  + I samara
	0x00218487, // n0x1ad4 c0x0000 (---------------)  + I saratov
	0x002b7c08, // n0x1ad5 c0x0000 (---------------)  + I simbirsk
	0x002ae3c8, // n0x1ad6 c0x0000 (---------------)  + I smolensk
	0x002c5603, // n0x1ad7 c0x0000 (---------------)  + I snz
	0x00268e43, // n0x1ad8 c0x0000 (---------------)  + I spb
	0x002187c9, // n0x1ad9 c0x0000 (---------------)  + I stavropol
	0x002daf83, // n0x1ada c0x0000 (---------------)  + I stv
	0x002d0c06, // n0x1adb c0x0000 (---------------)  + I surgut
	0x0028ea86, // n0x1adc c0x0000 (---------------)  + I syzran
	0x002fe106, // n0x1add c0x0000 (---------------)  + I tambov
	0x0031df09, // n0x1ade c0x0000 (---------------)  + I tatarstan
	0x002e3fc4, // n0x1adf c0x0000 (---------------)  + I test
	0x0020fe03, // n0x1ae0 c0x0000 (---------------)  + I tom
	0x00233ec5, // n0x1ae1 c0x0000 (---------------)  + I tomsk
	0x0038c2c9, // n0x1ae2 c0x0000 (---------------)  + I tsaritsyn
	0x00220683, // n0x1ae3 c0x0000 (---------------)  + I tsk
	0x002d78c4, // n0x1ae4 c0x0000 (---------------)  + I tula
	0x002d9504, // n0x1ae5 c0x0000 (---------------)  + I tuva
	0x00248304, // n0x1ae6 c0x0000 (---------------)  + I tver
	0x002a7d06, // n0x1ae7 c0x0000 (---------------)  + I tyumen
	0x00309dc3, // n0x1ae8 c0x0000 (---------------)  + I udm
	0x00309dc8, // n0x1ae9 c0x0000 (---------------)  + I udmurtia
	0x00245a08, // n0x1aea c0x0000 (---------------)  + I ulan-ude
	0x002fe246, // n0x1aeb c0x0000 (---------------)  + I vdonsk
	0x002dea8b, // n0x1aec c0x0000 (---------------)  + I vladikavkaz
	0x002dedc8, // n0x1aed c0x0000 (---------------)  + I vladimir
	0x002defcb, // n0x1aee c0x0000 (---------------)  + I vladivostok
	0x002df749, // n0x1aef c0x0000 (---------------)  + I volgograd
	0x002e1147, // n0x1af0 c0x0000 (---------------)  + I vologda
	0x002e1e48, // n0x1af1 c0x0000 (---------------)  + I voronezh
	0x002e2b03, // n0x1af2 c0x0000 (---------------)  + I vrn
	0x0037fec6, // n0x1af3 c0x0000 (---------------)  + I vyatka
	0x0020d4c7, // n0x1af4 c0x0000 (---------------)  + I yakutia
	0x00284405, // n0x1af5 c0x0000 (---------------)  + I yamal
	0x00332d09, // n0x1af6 c0x0000 (---------------)  + I yaroslavl
	0x0036e1cd, // n0x1af7 c0x0000 (---------------)  + I yekaterinburg
	0x00217491, // n0x1af8 c0x0000 (---------------)  + I yuzhno-sakhalinsk
	0x0029adc5, // n0x1af9 c0x0000 (---------------)  + I zgrad
	0x00201e82, // n0x1afa c0x0000 (---------------)  + I ac
	0x00200742, // n0x1afb c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1afc c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1afd c0x0000 (---------------)  + I edu
	0x003579c4, // n0x1afe c0x0000 (---------------)  + I gouv
	0x0021e283, // n0x1aff c0x0000 (---------------)  + I gov
	0x00238c03, // n0x1b00 c0x0000 (---------------)  + I int
	0x0023fa03, // n0x1b01 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1b02 c0x0000 (---------------)  + I net
	0x00222ac3, // n0x1b03 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1b04 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1b05 c0x0000 (---------------)  + I gov
	0x0020b403, // n0x1b06 c0x0000 (---------------)  + I med
	0x002170c3, // n0x1b07 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b08 c0x0000 (---------------)  + I org
	0x00296543, // n0x1b09 c0x0000 (---------------)  + I pub
	0x00206103, // n0x1b0a c0x0000 (---------------)  + I sch
	0x00222ac3, // n0x1b0b c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1b0c c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1b0d c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1b0e c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b0f c0x0000 (---------------)  + I org
	0x00222ac3, // n0x1b10 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1b11 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1b12 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1b13 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b14 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x1b15 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1b16 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1b17 c0x0000 (---------------)  + I gov
	0x00200304, // n0x1b18 c0x0000 (---------------)  + I info
	0x0020b403, // n0x1b19 c0x0000 (---------------)  + I med
	0x002170c3, // n0x1b1a c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b1b c0x0000 (---------------)  + I org
	0x0020bf42, // n0x1b1c c0x0000 (---------------)  + I tv
	0x00200181, // n0x1b1d c0x0000 (---------------)  + I a
	0x00201e82, // n0x1b1e c0x0000 (---------------)  + I ac
	0x00200001, // n0x1b1f c0x0000 (---------------)  + I b
	0x002fbc02, // n0x1b20 c0x0000 (---------------)  + I bd
	0x000e4188, // n0x1b21 c0x0000 (---------------)  +   blogspot
	0x00213b05, // n0x1b22 c0x0000 (---------------)  + I brand
	0x00200741, // n0x1b23 c0x0000 (---------------)  + I c
	0x00022ac3, // n0x1b24 c0x0000 (---------------)  +   com
	0x002005c1, // n0x1b25 c0x0000 (---------------)  + I d
	0x00200701, // n0x1b26 c0x0000 (---------------)  + I e
	0x00200381, // n0x1b27 c0x0000 (---------------)  + I f
	0x00235ec2, // n0x1b28 c0x0000 (---------------)  + I fh
	0x00235ec4, // n0x1b29 c0x0000 (---------------)  + I fhsk
	0x00351283, // n0x1b2a c0x0000 (---------------)  + I fhv
	0x00200401, // n0x1b2b c0x0000 (---------------)  + I g
	0x00200201, // n0x1b2c c0x0000 (---------------)  + I h
	0x00200041, // n0x1b2d c0x0000 (---------------)  + I i
	0x00201001, // n0x1b2e c0x0000 (---------------)  + I k
	0x002c8587, // n0x1b2f c0x0000 (---------------)  + I komforb
	0x002a8f8f, // n0x1b30 c0x0000 (---------------)  + I kommunalforbund
	0x002b1a86, // n0x1b31 c0x0000 (---------------)  + I komvux
	0x002008c1, // n0x1b32 c0x0000 (---------------)  + I l
	0x00323b46, // n0x1b33 c0x0000 (---------------)  + I lanbib
	0x002000c1, // n0x1b34 c0x0000 (---------------)  + I m
	0x00200281, // n0x1b35 c0x0000 (---------------)  + I n
	0x002f460e, // n0x1b36 c0x0000 (---------------)  + I naturbruksgymn
	0x00200081, // n0x1b37 c0x0000 (---------------)  + I o
	0x0021dcc3, // n0x1b38 c0x0000 (---------------)  + I org
	0x00200b01, // n0x1b39 c0x0000 (---------------)  + I p
	0x00290b05, // n0x1b3a c0x0000 (---------------)  + I parti
	0x00207742, // n0x1b3b c0x0000 (---------------)  + I pp
	0x0029abc5, // n0x1b3c c0x0000 (---------------)  + I press
	0x00200581, // n0x1b3d c0x0000 (---------------)  + I r
	0x002001c1, // n0x1b3e c0x0000 (---------------)  + I s
	0x00200141, // n0x1b3f c0x0000 (---------------)  + I t
	0x00208902, // n0x1b40 c0x0000 (---------------)  + I tm
	0x00200101, // n0x1b41 c0x0000 (---------------)  + I u
	0x00202541, // n0x1b42 c0x0000 (---------------)  + I w
	0x00203ec1, // n0x1b43 c0x0000 (---------------)  + I x
	0x00200801, // n0x1b44 c0x0000 (---------------)  + I y
	0x00201901, // n0x1b45 c0x0000 (---------------)  + I z
	0x000e4188, // n0x1b46 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1b47 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1b48 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1b49 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1b4a c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b4b c0x0000 (---------------)  + I org
	0x00214943, // n0x1b4c c0x0000 (---------------)  + I per
	0x00222ac3, // n0x1b4d c0x0000 (---------------)  + I com
	0x0021e283, // n0x1b4e c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x1b4f c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1b50 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b51 c0x0000 (---------------)  + I org
	0x014c56c8, // n0x1b52 c0x0005 (---------------)* o   platform
	0x000e4188, // n0x1b53 c0x0000 (---------------)  +   blogspot
	0x000e4188, // n0x1b54 c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1b55 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1b56 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1b57 c0x0000 (---------------)  + I gov
	0x002170c3, // n0x1b58 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b59 c0x0000 (---------------)  + I org
	0x00200603, // n0x1b5a c0x0000 (---------------)  + I art
	0x000e4188, // n0x1b5b c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1b5c c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1b5d c0x0000 (---------------)  + I edu
	0x003579c4, // n0x1b5e c0x0000 (---------------)  + I gouv
	0x0021dcc3, // n0x1b5f c0x0000 (---------------)  + I org
	0x0028acc5, // n0x1b60 c0x0000 (---------------)  + I perso
	0x0029f044, // n0x1b61 c0x0000 (---------------)  + I univ
	0x00222ac3, // n0x1b62 c0x0000 (---------------)  + I com
	0x002170c3, // n0x1b63 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b64 c0x0000 (---------------)  + I org
	0x00200742, // n0x1b65 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1b66 c0x0000 (---------------)  + I com
	0x00224f09, // n0x1b67 c0x0000 (---------------)  + I consulado
	0x002d75c3, // n0x1b68 c0x0000 (---------------)  + I edu
	0x00271109, // n0x1b69 c0x0000 (---------------)  + I embaixada
	0x0021e283, // n0x1b6a c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x1b6b c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1b6c c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b6d c0x0000 (---------------)  + I org
	0x002cb848, // n0x1b6e c0x0000 (---------------)  + I principe
	0x0020fd47, // n0x1b6f c0x0000 (---------------)  + I saotome
	0x002cf4c5, // n0x1b70 c0x0000 (---------------)  + I store
	0x00382c47, // n0x1b71 c0x0000 (---------------)  + I adygeya
	0x002f314b, // n0x1b72 c0x0000 (---------------)  + I arkhangelsk
	0x00389cc8, // n0x1b73 c0x0000 (---------------)  + I balashov
	0x00309449, // n0x1b74 c0x0000 (---------------)  + I bashkiria
	0x0021cc07, // n0x1b75 c0x0000 (---------------)  + I bryansk
	0x00309888, // n0x1b76 c0x0000 (---------------)  + I dagestan
	0x003789c6, // n0x1b77 c0x0000 (---------------)  + I grozny
	0x002f2a47, // n0x1b78 c0x0000 (---------------)  + I ivanovo
	0x002201c8, // n0x1b79 c0x0000 (---------------)  + I kalmykia
	0x00305446, // n0x1b7a c0x0000 (---------------)  + I kaluga
	0x00365ac7, // n0x1b7b c0x0000 (---------------)  + I karelia
	0x002361c9, // n0x1b7c c0x0000 (---------------)  + I khakassia
	0x00384e89, // n0x1b7d c0x0000 (---------------)  + I krasnodar
	0x002a4ac6, // n0x1b7e c0x0000 (---------------)  + I kurgan
	0x00275dc5, // n0x1b7f c0x0000 (---------------)  + I lenug
	0x002b4208, // n0x1b80 c0x0000 (---------------)  + I mordovia
	0x00233f43, // n0x1b81 c0x0000 (---------------)  + I msk
	0x002bbd88, // n0x1b82 c0x0000 (---------------)  + I murmansk
	0x00375747, // n0x1b83 c0x0000 (---------------)  + I nalchik
	0x00201343, // n0x1b84 c0x0000 (---------------)  + I nov
	0x0032a707, // n0x1b85 c0x0000 (---------------)  + I obninsk
	0x00395385, // n0x1b86 c0x0000 (---------------)  + I penza
	0x002c8208, // n0x1b87 c0x0000 (---------------)  + I pokrovsk
	0x00262b45, // n0x1b88 c0x0000 (---------------)  + I sochi
	0x00268e43, // n0x1b89 c0x0000 (---------------)  + I spb
	0x003547c9, // n0x1b8a c0x0000 (---------------)  + I togliatti
	0x00295587, // n0x1b8b c0x0000 (---------------)  + I troitsk
	0x002d78c4, // n0x1b8c c0x0000 (---------------)  + I tula
	0x002d9504, // n0x1b8d c0x0000 (---------------)  + I tuva
	0x002dea8b, // n0x1b8e c0x0000 (---------------)  + I vladikavkaz
	0x002dedc8, // n0x1b8f c0x0000 (---------------)  + I vladimir
	0x002e1147, // n0x1b90 c0x0000 (---------------)  + I vologda
	0x00222ac3, // n0x1b91 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1b92 c0x0000 (---------------)  + I edu
	0x0034eb03, // n0x1b93 c0x0000 (---------------)  + I gob
	0x0021dcc3, // n0x1b94 c0x0000 (---------------)  + I org
	0x00230683, // n0x1b95 c0x0000 (---------------)  + I red
	0x0021e283, // n0x1b96 c0x0000 (---------------)  + I gov
	0x00222ac3, // n0x1b97 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1b98 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1b99 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x1b9a c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1b9b c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1b9c c0x0000 (---------------)  + I org
	0x00201e82, // n0x1b9d c0x0000 (---------------)  + I ac
	0x00200742, // n0x1b9e c0x0000 (---------------)  + I co
	0x0021dcc3, // n0x1b9f c0x0000 (---------------)  + I org
	0x000e4188, // n0x1ba0 c0x0000 (---------------)  +   blogspot
	0x00201e82, // n0x1ba1 c0x0000 (---------------)  + I ac
	0x00200742, // n0x1ba2 c0x0000 (---------------)  + I co
	0x00202342, // n0x1ba3 c0x0000 (---------------)  + I go
	0x00200242, // n0x1ba4 c0x0000 (---------------)  + I in
	0x00204802, // n0x1ba5 c0x0000 (---------------)  + I mi
	0x002170c3, // n0x1ba6 c0x0000 (---------------)  + I net
	0x00200c42, // n0x1ba7 c0x0000 (---------------)  + I or
	0x00201e82, // n0x1ba8 c0x0000 (---------------)  + I ac
	0x00310603, // n0x1ba9 c0x0000 (---------------)  + I biz
	0x00200742, // n0x1baa c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1bab c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1bac c0x0000 (---------------)  + I edu
	0x00202342, // n0x1bad c0x0000 (---------------)  + I go
	0x0021e283, // n0x1bae c0x0000 (---------------)  + I gov
	0x00238c03, // n0x1baf c0x0000 (---------------)  + I int
	0x0023fa03, // n0x1bb0 c0x0000 (---------------)  + I mil
	0x00298944, // n0x1bb1 c0x0000 (---------------)  + I name
	0x002170c3, // n0x1bb2 c0x0000 (---------------)  + I net
	0x0020e3c3, // n0x1bb3 c0x0000 (---------------)  + I nic
	0x0021dcc3, // n0x1bb4 c0x0000 (---------------)  + I org
	0x002e3fc4, // n0x1bb5 c0x0000 (---------------)  + I test
	0x00219fc3, // n0x1bb6 c0x0000 (---------------)  + I web
	0x0021e283, // n0x1bb7 c0x0000 (---------------)  + I gov
	0x00200742, // n0x1bb8 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1bb9 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1bba c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1bbb c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x1bbc c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1bbd c0x0000 (---------------)  + I net
	0x00207cc3, // n0x1bbe c0x0000 (---------------)  + I nom
	0x0021dcc3, // n0x1bbf c0x0000 (---------------)  + I org
	0x002efd87, // n0x1bc0 c0x0000 (---------------)  + I agrinet
	0x00222ac3, // n0x1bc1 c0x0000 (---------------)  + I com
	0x00245b87, // n0x1bc2 c0x0000 (---------------)  + I defense
	0x002d75c6, // n0x1bc3 c0x0000 (---------------)  + I edunet
	0x00210e83, // n0x1bc4 c0x0000 (---------------)  + I ens
	0x00236403, // n0x1bc5 c0x0000 (---------------)  + I fin
	0x0021e283, // n0x1bc6 c0x0000 (---------------)  + I gov
	0x00215703, // n0x1bc7 c0x0000 (---------------)  + I ind
	0x00200304, // n0x1bc8 c0x0000 (---------------)  + I info
	0x002c5104, // n0x1bc9 c0x0000 (---------------)  + I intl
	0x002d4086, // n0x1bca c0x0000 (---------------)  + I mincom
	0x0023ac03, // n0x1bcb c0x0000 (---------------)  + I nat
	0x002170c3, // n0x1bcc c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1bcd c0x0000 (---------------)  + I org
	0x0028acc5, // n0x1bce c0x0000 (---------------)  + I perso
	0x003538c4, // n0x1bcf c0x0000 (---------------)  + I rnrt
	0x002e6c03, // n0x1bd0 c0x0000 (---------------)  + I rns
	0x00205b83, // n0x1bd1 c0x0000 (---------------)  + I rnu
	0x002ae287, // n0x1bd2 c0x0000 (---------------)  + I tourism
	0x0033c485, // n0x1bd3 c0x0000 (---------------)  + I turen
	0x00222ac3, // n0x1bd4 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1bd5 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1bd6 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x1bd7 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1bd8 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1bd9 c0x0000 (---------------)  + I org
	0x00201482, // n0x1bda c0x0000 (---------------)  + I av
	0x002791c3, // n0x1bdb c0x0000 (---------------)  + I bbs
	0x00251643, // n0x1bdc c0x0000 (---------------)  + I bel
	0x00310603, // n0x1bdd c0x0000 (---------------)  + I biz
	0x51622ac3, // n0x1bde c0x0145 (n0x1bef-n0x1bf0)  + I com
	0x0022fb02, // n0x1bdf c0x0000 (---------------)  + I dr
	0x002d75c3, // n0x1be0 c0x0000 (---------------)  + I edu
	0x002012c3, // n0x1be1 c0x0000 (---------------)  + I gen
	0x0021e283, // n0x1be2 c0x0000 (---------------)  + I gov
	0x00200304, // n0x1be3 c0x0000 (---------------)  + I info
	0x00312503, // n0x1be4 c0x0000 (---------------)  + I k12
	0x0023df03, // n0x1be5 c0x0000 (---------------)  + I kep
	0x0023fa03, // n0x1be6 c0x0000 (---------------)  + I mil
	0x00298944, // n0x1be7 c0x0000 (---------------)  + I name
	0x51a1c742, // n0x1be8 c0x0146 (n0x1bf0-n0x1bf1)  + I nc
	0x002170c3, // n0x1be9 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1bea c0x0000 (---------------)  + I org
	0x00218943, // n0x1beb c0x0000 (---------------)  + I pol
	0x0022ba83, // n0x1bec c0x0000 (---------------)  + I tel
	0x0020bf42, // n0x1bed c0x0000 (---------------)  + I tv
	0x00219fc3, // n0x1bee c0x0000 (---------------)  + I web
	0x000e4188, // n0x1bef c0x0000 (---------------)  +   blogspot
	0x0021e283, // n0x1bf0 c0x0000 (---------------)  + I gov
	0x002751c4, // n0x1bf1 c0x0000 (---------------)  + I aero
	0x00310603, // n0x1bf2 c0x0000 (---------------)  + I biz
	0x00200742, // n0x1bf3 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1bf4 c0x0000 (---------------)  + I com
	0x00228d44, // n0x1bf5 c0x0000 (---------------)  + I coop
	0x002d75c3, // n0x1bf6 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1bf7 c0x0000 (---------------)  + I gov
	0x00200304, // n0x1bf8 c0x0000 (---------------)  + I info
	0x00238c03, // n0x1bf9 c0x0000 (---------------)  + I int
	0x002a5d04, // n0x1bfa c0x0000 (---------------)  + I jobs
	0x00203604, // n0x1bfb c0x0000 (---------------)  + I mobi
	0x002bd646, // n0x1bfc c0x0000 (---------------)  + I museum
	0x00298944, // n0x1bfd c0x0000 (---------------)  + I name
	0x002170c3, // n0x1bfe c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1bff c0x0000 (---------------)  + I org
	0x00218243, // n0x1c00 c0x0000 (---------------)  + I pro
	0x0027f186, // n0x1c01 c0x0000 (---------------)  + I travel
	0x00041e4b, // n0x1c02 c0x0000 (---------------)  +   better-than
	0x00009ac6, // n0x1c03 c0x0000 (---------------)  +   dyndns
	0x00019e0a, // n0x1c04 c0x0000 (---------------)  +   on-the-web
	0x00171e8a, // n0x1c05 c0x0000 (---------------)  +   worse-than
	0x000e4188, // n0x1c06 c0x0000 (---------------)  +   blogspot
	0x002752c4, // n0x1c07 c0x0000 (---------------)  + I club
	0x00222ac3, // n0x1c08 c0x0000 (---------------)  + I com
	0x003105c4, // n0x1c09 c0x0000 (---------------)  + I ebiz
	0x002d75c3, // n0x1c0a c0x0000 (---------------)  + I edu
	0x00212084, // n0x1c0b c0x0000 (---------------)  + I game
	0x0021e283, // n0x1c0c c0x0000 (---------------)  + I gov
	0x00300b83, // n0x1c0d c0x0000 (---------------)  + I idv
	0x0023fa03, // n0x1c0e c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1c0f c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1c10 c0x0000 (---------------)  + I org
	0x0030d70b, // n0x1c11 c0x0000 (---------------)  + I xn--czrw28b
	0x003867ca, // n0x1c12 c0x0000 (---------------)  + I xn--uc0atv
	0x0039604c, // n0x1c13 c0x0000 (---------------)  + I xn--zf0ao64a
	0x00201e82, // n0x1c14 c0x0000 (---------------)  + I ac
	0x00200742, // n0x1c15 c0x0000 (---------------)  + I co
	0x00202342, // n0x1c16 c0x0000 (---------------)  + I go
	0x00294945, // n0x1c17 c0x0000 (---------------)  + I hotel
	0x00200304, // n0x1c18 c0x0000 (---------------)  + I info
	0x00208942, // n0x1c19 c0x0000 (---------------)  + I me
	0x0023fa03, // n0x1c1a c0x0000 (---------------)  + I mil
	0x00203604, // n0x1c1b c0x0000 (---------------)  + I mobi
	0x00201082, // n0x1c1c c0x0000 (---------------)  + I ne
	0x00200c42, // n0x1c1d c0x0000 (---------------)  + I or
	0x00200982, // n0x1c1e c0x0000 (---------------)  + I sc
	0x0020bf42, // n0x1c1f c0x0000 (---------------)  + I tv
	0x0029d289, // n0x1c20 c0x0000 (---------------)  + I cherkassy
	0x0028e908, // n0x1c21 c0x0000 (---------------)  + I cherkasy
	0x00259889, // n0x1c22 c0x0000 (---------------)  + I chernigov
	0x0025f489, // n0x1c23 c0x0000 (---------------)  + I chernihiv
	0x0026b44a, // n0x1c24 c0x0000 (---------------)  + I chernivtsi
	0x00367e8a, // n0x1c25 c0x0000 (---------------)  + I chernovtsy
	0x00201782, // n0x1c26 c0x0000 (---------------)  + I ck
	0x002211c2, // n0x1c27 c0x0000 (---------------)  + I cn
	0x00200742, // n0x1c28 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1c29 c0x0000 (---------------)  + I com
	0x0020c502, // n0x1c2a c0x0000 (---------------)  + I cr
	0x00231c86, // n0x1c2b c0x0000 (---------------)  + I crimea
	0x0033f802, // n0x1c2c c0x0000 (---------------)  + I cv
	0x00209b82, // n0x1c2d c0x0000 (---------------)  + I dn
	0x0036ad4e, // n0x1c2e c0x0000 (---------------)  + I dnepropetrovsk
	0x0025ec0e, // n0x1c2f c0x0000 (---------------)  + I dnipropetrovsk
	0x0026b2c7, // n0x1c30 c0x0000 (---------------)  + I dominic
	0x003409c7, // n0x1c31 c0x0000 (---------------)  + I donetsk
	0x00238b42, // n0x1c32 c0x0000 (---------------)  + I dp
	0x002d75c3, // n0x1c33 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1c34 c0x0000 (---------------)  + I gov
	0x00239ec2, // n0x1c35 c0x0000 (---------------)  + I if
	0x00200242, // n0x1c36 c0x0000 (---------------)  + I in
	0x0022cf4f, // n0x1c37 c0x0000 (---------------)  + I ivano-frankivsk
	0x002176c2, // n0x1c38 c0x0000 (---------------)  + I kh
	0x00244d07, // n0x1c39 c0x0000 (---------------)  + I kharkiv
	0x0024cb07, // n0x1c3a c0x0000 (---------------)  + I kharkov
	0x00250087, // n0x1c3b c0x0000 (---------------)  + I kherson
	0x0025304c, // n0x1c3c c0x0000 (---------------)  + I khmelnitskiy
	0x002581cc, // n0x1c3d c0x0000 (---------------)  + I khmelnytskyi
	0x0037aac4, // n0x1c3e c0x0000 (---------------)  + I kiev
	0x00254bca, // n0x1c3f c0x0000 (---------------)  + I kirovograd
	0x00268d82, // n0x1c40 c0x0000 (---------------)  + I km
	0x002034c2, // n0x1c41 c0x0000 (---------------)  + I kr
	0x0029ed84, // n0x1c42 c0x0000 (---------------)  + I krym
	0x00238082, // n0x1c43 c0x0000 (---------------)  + I ks
	0x002aa8c2, // n0x1c44 c0x0000 (---------------)  + I kv
	0x00258404, // n0x1c45 c0x0000 (---------------)  + I kyiv
	0x0020e4c2, // n0x1c46 c0x0000 (---------------)  + I lg
	0x00205ec2, // n0x1c47 c0x0000 (---------------)  + I lt
	0x003054c7, // n0x1c48 c0x0000 (---------------)  + I lugansk
	0x002e6745, // n0x1c49 c0x0000 (---------------)  + I lutsk
	0x00227f02, // n0x1c4a c0x0000 (---------------)  + I lv
	0x0022cec4, // n0x1c4b c0x0000 (---------------)  + I lviv
	0x00356d82, // n0x1c4c c0x0000 (---------------)  + I mk
	0x002f28c8, // n0x1c4d c0x0000 (---------------)  + I mykolaiv
	0x002170c3, // n0x1c4e c0x0000 (---------------)  + I net
	0x00342248, // n0x1c4f c0x0000 (---------------)  + I nikolaev
	0x00200782, // n0x1c50 c0x0000 (---------------)  + I od
	0x00227505, // n0x1c51 c0x0000 (---------------)  + I odesa
	0x0035fa46, // n0x1c52 c0x0000 (---------------)  + I odessa
	0x0021dcc3, // n0x1c53 c0x0000 (---------------)  + I org
	0x00201e02, // n0x1c54 c0x0000 (---------------)  + I pl
	0x002c8f07, // n0x1c55 c0x0000 (---------------)  + I poltava
	0x00207742, // n0x1c56 c0x0000 (---------------)  + I pp
	0x002cba85, // n0x1c57 c0x0000 (---------------)  + I rivne
	0x00208085, // n0x1c58 c0x0000 (---------------)  + I rovno
	0x00211fc2, // n0x1c59 c0x0000 (---------------)  + I rv
	0x002046c2, // n0x1c5a c0x0000 (---------------)  + I sb
	0x0035e2ca, // n0x1c5b c0x0000 (---------------)  + I sebastopol
	0x0024688a, // n0x1c5c c0x0000 (---------------)  + I sevastopol
	0x0023f582, // n0x1c5d c0x0000 (---------------)  + I sm
	0x00308004, // n0x1c5e c0x0000 (---------------)  + I sumy
	0x00203202, // n0x1c5f c0x0000 (---------------)  + I te
	0x0036c988, // n0x1c60 c0x0000 (---------------)  + I ternopil
	0x002018c2, // n0x1c61 c0x0000 (---------------)  + I uz
	0x0036a1c8, // n0x1c62 c0x0000 (---------------)  + I uzhgorod
	0x002dc087, // n0x1c63 c0x0000 (---------------)  + I vinnica
	0x002dc4c9, // n0x1c64 c0x0000 (---------------)  + I vinnytsia
	0x00208102, // n0x1c65 c0x0000 (---------------)  + I vn
	0x002e1c05, // n0x1c66 c0x0000 (---------------)  + I volyn
	0x0028edc5, // n0x1c67 c0x0000 (---------------)  + I yalta
	0x002b214b, // n0x1c68 c0x0000 (---------------)  + I zaporizhzhe
	0x002b2b8c, // n0x1c69 c0x0000 (---------------)  + I zaporizhzhia
	0x00220408, // n0x1c6a c0x0000 (---------------)  + I zhitomir
	0x002e1fc8, // n0x1c6b c0x0000 (---------------)  + I zhytomyr
	0x002c2042, // n0x1c6c c0x0000 (---------------)  + I zp
	0x0020fa82, // n0x1c6d c0x0000 (---------------)  + I zt
	0x00201e82, // n0x1c6e c0x0000 (---------------)  + I ac
	0x000e4188, // n0x1c6f c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x1c70 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1c71 c0x0000 (---------------)  + I com
	0x00202342, // n0x1c72 c0x0000 (---------------)  + I go
	0x00201082, // n0x1c73 c0x0000 (---------------)  + I ne
	0x00200c42, // n0x1c74 c0x0000 (---------------)  + I or
	0x0021dcc3, // n0x1c75 c0x0000 (---------------)  + I org
	0x00200982, // n0x1c76 c0x0000 (---------------)  + I sc
	0x00201e82, // n0x1c77 c0x0000 (---------------)  + I ac
	0x53a00742, // n0x1c78 c0x014e (n0x1c82-n0x1c83)  + I co
	0x53e1e283, // n0x1c79 c0x014f (n0x1c83-n0x1c84)  + I gov
	0x003413c3, // n0x1c7a c0x0000 (---------------)  + I ltd
	0x00208942, // n0x1c7b c0x0000 (---------------)  + I me
	0x002170c3, // n0x1c7c c0x0000 (---------------)  + I net
	0x002037c3, // n0x1c7d c0x0000 (---------------)  + I nhs
	0x0021dcc3, // n0x1c7e c0x0000 (---------------)  + I org
	0x002c65c3, // n0x1c7f c0x0000 (---------------)  + I plc
	0x00218946, // n0x1c80 c0x0000 (---------------)  + I police
	0x01606103, // n0x1c81 c0x0005 (---------------)* o I sch
	0x000e4188, // n0x1c82 c0x0000 (---------------)  +   blogspot
	0x00043bc7, // n0x1c83 c0x0000 (---------------)  +   service
	0x54601a42, // n0x1c84 c0x0151 (n0x1cc3-n0x1cc6)  + I ak
	0x54a00882, // n0x1c85 c0x0152 (n0x1cc6-n0x1cc9)  + I al
	0x54e00602, // n0x1c86 c0x0153 (n0x1cc9-n0x1ccc)  + I ar
	0x55200182, // n0x1c87 c0x0154 (n0x1ccc-n0x1ccf)  + I as
	0x55608cc2, // n0x1c88 c0x0155 (n0x1ccf-n0x1cd2)  + I az
	0x55a055c2, // n0x1c89 c0x0156 (n0x1cd2-n0x1cd5)  + I ca
	0x55e00742, // n0x1c8a c0x0157 (n0x1cd5-n0x1cd8)  + I co
	0x56223d82, // n0x1c8b c0x0158 (n0x1cd8-n0x1cdb)  + I ct
	0x56616e02, // n0x1c8c c0x0159 (n0x1cdb-n0x1cde)  + I dc
	0x56a006c2, // n0x1c8d c0x015a (n0x1cde-n0x1ce1)  + I de
	0x0025ec03, // n0x1c8e c0x0000 (---------------)  + I dni
	0x0020c743, // n0x1c8f c0x0000 (---------------)  + I fed
	0x56e39b02, // n0x1c90 c0x015b (n0x1ce1-n0x1ce4)  + I fl
	0x57201602, // n0x1c91 c0x015c (n0x1ce4-n0x1ce7)  + I ga
	0x57629702, // n0x1c92 c0x015d (n0x1ce7-n0x1cea)  + I gu
	0x57a00202, // n0x1c93 c0x015e (n0x1cea-n0x1cec)  + I hi
	0x57e00482, // n0x1c94 c0x015f (n0x1cec-n0x1cef)  + I ia
	0x58206202, // n0x1c95 c0x0160 (n0x1cef-n0x1cf2)  + I id
	0x586036c2, // n0x1c96 c0x0161 (n0x1cf2-n0x1cf5)  + I il
	0x58a00242, // n0x1c97 c0x0162 (n0x1cf5-n0x1cf8)  + I in
	0x000aa785, // n0x1c98 c0x0000 (---------------)  +   is-by
	0x00209883, // n0x1c99 c0x0000 (---------------)  + I isa
	0x00394c44, // n0x1c9a c0x0000 (---------------)  + I kids
	0x58e38082, // n0x1c9b c0x0163 (n0x1cf8-n0x1cfb)  + I ks
	0x59229082, // n0x1c9c c0x0164 (n0x1cfb-n0x1cfe)  + I ky
	0x59601e42, // n0x1c9d c0x0165 (n0x1cfe-n0x1d01)  + I la
	0x0006700b, // n0x1c9e c0x0000 (---------------)  +   land-4-sale
	0x59a04302, // n0x1c9f c0x0166 (n0x1d01-n0x1d04)  + I ma
	0x5a238602, // n0x1ca0 c0x0168 (n0x1d07-n0x1d0a)  + I md
	0x5a608942, // n0x1ca1 c0x0169 (n0x1d0a-n0x1d0d)  + I me
	0x5aa04802, // n0x1ca2 c0x016a (n0x1d0d-n0x1d10)  + I mi
	0x5ae17082, // n0x1ca3 c0x016b (n0x1d10-n0x1d13)  + I mn
	0x5b203602, // n0x1ca4 c0x016c (n0x1d13-n0x1d16)  + I mo
	0x5b609282, // n0x1ca5 c0x016d (n0x1d16-n0x1d19)  + I ms
	0x5ba59642, // n0x1ca6 c0x016e (n0x1d19-n0x1d1c)  + I mt
	0x5be1c742, // n0x1ca7 c0x016f (n0x1d1c-n0x1d1f)  + I nc
	0x5c208f42, // n0x1ca8 c0x0170 (n0x1d1f-n0x1d21)  + I nd
	0x5c601082, // n0x1ca9 c0x0171 (n0x1d21-n0x1d24)  + I ne
	0x5ca037c2, // n0x1caa c0x0172 (n0x1d24-n0x1d27)  + I nh
	0x5ce02942, // n0x1cab c0x0173 (n0x1d27-n0x1d2a)  + I nj
	0x5d233c42, // n0x1cac c0x0174 (n0x1d2a-n0x1d2d)  + I nm
	0x002c55c3, // n0x1cad c0x0000 (---------------)  + I nsn
	0x5d608802, // n0x1cae c0x0175 (n0x1d2d-n0x1d30)  + I nv
	0x5da108c2, // n0x1caf c0x0176 (n0x1d30-n0x1d33)  + I ny
	0x5de051c2, // n0x1cb0 c0x0177 (n0x1d33-n0x1d36)  + I oh
	0x5e201bc2, // n0x1cb1 c0x0178 (n0x1d36-n0x1d39)  + I ok
	0x5e600c42, // n0x1cb2 c0x0179 (n0x1d39-n0x1d3c)  + I or
	0x5ea052c2, // n0x1cb3 c0x017a (n0x1d3c-n0x1d3f)  + I pa
	0x5ee18242, // n0x1cb4 c0x017b (n0x1d3f-n0x1d42)  + I pr
	0x5f202842, // n0x1cb5 c0x017c (n0x1d42-n0x1d45)  + I ri
	0x5f600982, // n0x1cb6 c0x017d (n0x1d45-n0x1d48)  + I sc
	0x5fa4f842, // n0x1cb7 c0x017e (n0x1d48-n0x1d4a)  + I sd
	0x000d044c, // n0x1cb8 c0x0000 (---------------)  +   stuff-4-sale
	0x5fe1d1c2, // n0x1cb9 c0x017f (n0x1d4a-n0x1d4d)  + I tn
	0x60225242, // n0x1cba c0x0180 (n0x1d4d-n0x1d50)  + I tx
	0x60600102, // n0x1cbb c0x0181 (n0x1d50-n0x1d53)  + I ut
	0x60a013c2, // n0x1cbc c0x0182 (n0x1d53-n0x1d56)  + I va
	0x60e13602, // n0x1cbd c0x0183 (n0x1d56-n0x1d59)  + I vi
	0x6121e302, // n0x1cbe c0x0184 (n0x1d59-n0x1d5c)  + I vt
	0x61602542, // n0x1cbf c0x0185 (n0x1d5c-n0x1d5f)  + I wa
	0x61a05502, // n0x1cc0 c0x0186 (n0x1d5f-n0x1d62)  + I wi
	0x61e63902, // n0x1cc1 c0x0187 (n0x1d62-n0x1d63)  + I wv
	0x62237f82, // n0x1cc2 c0x0188 (n0x1d63-n0x1d66)  + I wy
	0x0021aa82, // n0x1cc3 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cc4 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cc5 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cc6 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cc7 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cc8 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cc9 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cca c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1ccb c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1ccc c0x0000 (---------------)  + I cc
	0x00312503, // n0x1ccd c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cce c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1ccf c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cd0 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cd1 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cd2 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cd3 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cd4 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cd5 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cd6 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cd7 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cd8 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cd9 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cda c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cdb c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cdc c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cdd c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cde c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cdf c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1ce0 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1ce1 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1ce2 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1ce3 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1ce4 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1ce5 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1ce6 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1ce7 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1ce8 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1ce9 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cea c0x0000 (---------------)  + I cc
	0x00273c43, // n0x1ceb c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cec c0x0000 (---------------)  + I cc
	0x00312503, // n0x1ced c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cee c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cef c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cf0 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cf1 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cf2 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cf3 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cf4 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cf5 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cf6 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cf7 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cf8 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cf9 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cfa c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cfb c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cfc c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1cfd c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1cfe c0x0000 (---------------)  + I cc
	0x00312503, // n0x1cff c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d00 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d01 c0x0000 (---------------)  + I cc
	0x59f12503, // n0x1d02 c0x0167 (n0x1d04-n0x1d07)  + I k12
	0x00273c43, // n0x1d03 c0x0000 (---------------)  + I lib
	0x002e8ec4, // n0x1d04 c0x0000 (---------------)  + I chtr
	0x0028e806, // n0x1d05 c0x0000 (---------------)  + I paroch
	0x002ce243, // n0x1d06 c0x0000 (---------------)  + I pvt
	0x0021aa82, // n0x1d07 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d08 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d09 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d0a c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d0b c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d0c c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d0d c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d0e c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d0f c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d10 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d11 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d12 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d13 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d14 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d15 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d16 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d17 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d18 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d19 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d1a c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d1b c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d1c c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d1d c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d1e c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d1f c0x0000 (---------------)  + I cc
	0x00273c43, // n0x1d20 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d21 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d22 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d23 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d24 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d25 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d26 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d27 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d28 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d29 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d2a c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d2b c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d2c c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d2d c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d2e c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d2f c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d30 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d31 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d32 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d33 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d34 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d35 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d36 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d37 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d38 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d39 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d3a c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d3b c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d3c c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d3d c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d3e c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d3f c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d40 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d41 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d42 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d43 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d44 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d45 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d46 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d47 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d48 c0x0000 (---------------)  + I cc
	0x00273c43, // n0x1d49 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d4a c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d4b c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d4c c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d4d c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d4e c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d4f c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d50 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d51 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d52 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d53 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d54 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d55 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d56 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d57 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d58 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d59 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d5a c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d5b c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d5c c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d5d c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d5e c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d5f c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d60 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d61 c0x0000 (---------------)  + I lib
	0x0021aa82, // n0x1d62 c0x0000 (---------------)  + I cc
	0x0021aa82, // n0x1d63 c0x0000 (---------------)  + I cc
	0x00312503, // n0x1d64 c0x0000 (---------------)  + I k12
	0x00273c43, // n0x1d65 c0x0000 (---------------)  + I lib
	0x62a22ac3, // n0x1d66 c0x018a (n0x1d6c-n0x1d6d)  + I com
	0x002d75c3, // n0x1d67 c0x0000 (---------------)  + I edu
	0x0032b9c3, // n0x1d68 c0x0000 (---------------)  + I gub
	0x0023fa03, // n0x1d69 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1d6a c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1d6b c0x0000 (---------------)  + I org
	0x000e4188, // n0x1d6c c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x1d6d c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1d6e c0x0000 (---------------)  + I com
	0x002170c3, // n0x1d6f c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1d70 c0x0000 (---------------)  + I org
	0x00222ac3, // n0x1d71 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1d72 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1d73 c0x0000 (---------------)  + I gov
	0x0023fa03, // n0x1d74 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1d75 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1d76 c0x0000 (---------------)  + I org
	0x00246584, // n0x1d77 c0x0000 (---------------)  + I arts
	0x00200742, // n0x1d78 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1d79 c0x0000 (---------------)  + I com
	0x0023ee43, // n0x1d7a c0x0000 (---------------)  + I e12
	0x002d75c3, // n0x1d7b c0x0000 (---------------)  + I edu
	0x00238544, // n0x1d7c c0x0000 (---------------)  + I firm
	0x0034eb03, // n0x1d7d c0x0000 (---------------)  + I gob
	0x0021e283, // n0x1d7e c0x0000 (---------------)  + I gov
	0x00200304, // n0x1d7f c0x0000 (---------------)  + I info
	0x00238c03, // n0x1d80 c0x0000 (---------------)  + I int
	0x0023fa03, // n0x1d81 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1d82 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1d83 c0x0000 (---------------)  + I org
	0x002e6343, // n0x1d84 c0x0000 (---------------)  + I rec
	0x002cf4c5, // n0x1d85 c0x0000 (---------------)  + I store
	0x0029d583, // n0x1d86 c0x0000 (---------------)  + I tec
	0x00219fc3, // n0x1d87 c0x0000 (---------------)  + I web
	0x00200742, // n0x1d88 c0x0000 (---------------)  + I co
	0x00222ac3, // n0x1d89 c0x0000 (---------------)  + I com
	0x00312503, // n0x1d8a c0x0000 (---------------)  + I k12
	0x002170c3, // n0x1d8b c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1d8c c0x0000 (---------------)  + I org
	0x00201e82, // n0x1d8d c0x0000 (---------------)  + I ac
	0x00310603, // n0x1d8e c0x0000 (---------------)  + I biz
	0x000e4188, // n0x1d8f c0x0000 (---------------)  +   blogspot
	0x00222ac3, // n0x1d90 c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1d91 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1d92 c0x0000 (---------------)  + I gov
	0x00205e06, // n0x1d93 c0x0000 (---------------)  + I health
	0x00200304, // n0x1d94 c0x0000 (---------------)  + I info
	0x00238c03, // n0x1d95 c0x0000 (---------------)  + I int
	0x00298944, // n0x1d96 c0x0000 (---------------)  + I name
	0x002170c3, // n0x1d97 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1d98 c0x0000 (---------------)  + I org
	0x00218243, // n0x1d99 c0x0000 (---------------)  + I pro
	0x00222ac3, // n0x1d9a c0x0000 (---------------)  + I com
	0x002d75c3, // n0x1d9b c0x0000 (---------------)  + I edu
	0x002170c3, // n0x1d9c c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1d9d c0x0000 (---------------)  + I org
	0x00222ac3, // n0x1d9e c0x0000 (---------------)  + I com
	0x00009ac6, // n0x1d9f c0x0000 (---------------)  +   dyndns
	0x002d75c3, // n0x1da0 c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1da1 c0x0000 (---------------)  + I gov
	0x00108086, // n0x1da2 c0x0000 (---------------)  +   mypets
	0x002170c3, // n0x1da3 c0x0000 (---------------)  + I net
	0x0021dcc3, // n0x1da4 c0x0000 (---------------)  + I org
	0x002f1308, // n0x1da5 c0x0000 (---------------)  + I xn--80au
	0x002f5c09, // n0x1da6 c0x0000 (---------------)  + I xn--90azh
	0x00303289, // n0x1da7 c0x0000 (---------------)  + I xn--c1avg
	0x00312fc8, // n0x1da8 c0x0000 (---------------)  + I xn--d1at
	0x00362248, // n0x1da9 c0x0000 (---------------)  + I xn--o1ac
	0x00362249, // n0x1daa c0x0000 (---------------)  + I xn--o1ach
	0x00201e82, // n0x1dab c0x0000 (---------------)  + I ac
	0x00301306, // n0x1dac c0x0000 (---------------)  + I agrica
	0x00205e83, // n0x1dad c0x0000 (---------------)  + I alt
	0x65200742, // n0x1dae c0x0194 (n0x1dbc-n0x1dbd)  + I co
	0x002d75c3, // n0x1daf c0x0000 (---------------)  + I edu
	0x0021e283, // n0x1db0 c0x0000 (---------------)  + I gov
	0x002c6987, // n0x1db1 c0x0000 (---------------)  + I grondar
	0x00253883, // n0x1db2 c0x0000 (---------------)  + I law
	0x0023fa03, // n0x1db3 c0x0000 (---------------)  + I mil
	0x002170c3, // n0x1db4 c0x0000 (---------------)  + I net
	0x00202303, // n0x1db5 c0x0000 (---------------)  + I ngo
	0x00208b83, // n0x1db6 c0x0000 (---------------)  + I nis
	0x00207cc3, // n0x1db7 c0x0000 (---------------)  + I nom
	0x0021dcc3, // n0x1db8 c0x0000 (---------------)  + I org
	0x00235406, // n0x1db9 c0x0000 (---------------)  + I school
	0x00208902, // n0x1dba c0x0000 (---------------)  + I tm
	0x00219fc3, // n0x1dbb c0x0000 (---------------)  + I web
	0x000e4188, // n0x1dbc c0x0000 (---------------)  +   blogspot
}

// children is the list of nodes' children, the parent's wildcard bit and the
// parent's node type. If a node has no children then their children index
// will be in the range [0, 6), depending on the wildcard bit and node type.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 1 bits] wildcard bit
//	[ 2 bits] node type
//	[14 bits] high nodes index (exclusive) of children
//	[14 bits] low nodes index (inclusive) of children
var children = [...]uint32{
	0x00000000, // c0x0000 (---------------)  +
	0x10000000, // c0x0001 (---------------)  !
	0x20000000, // c0x0002 (---------------)  o
	0x40000000, // c0x0003 (---------------)* +
	0x50000000, // c0x0004 (---------------)* !
	0x60000000, // c0x0005 (---------------)* o
	0x014fc539, // c0x0006 (n0x0539-n0x053f)  +
	0x0150053f, // c0x0007 (n0x053f-n0x0540)  +
	0x01520540, // c0x0008 (n0x0540-n0x0548)  +
	0x01684548, // c0x0009 (n0x0548-n0x05a1)  +
	0x016985a1, // c0x000a (n0x05a1-n0x05a6)  +
	0x016ac5a6, // c0x000b (n0x05a6-n0x05ab)  +
	0x016bc5ab, // c0x000c (n0x05ab-n0x05af)  +
	0x016d85af, // c0x000d (n0x05af-n0x05b6)  +
	0x016dc5b6, // c0x000e (n0x05b6-n0x05b7)  +
	0x016ec5b7, // c0x000f (n0x05b7-n0x05bb)  +
	0x017045bb, // c0x0010 (n0x05bb-n0x05c1)  +
	0x017285c1, // c0x0011 (n0x05c1-n0x05ca)  +
	0x0172c5ca, // c0x0012 (n0x05ca-n0x05cb)  +
	0x017445cb, // c0x0013 (n0x05cb-n0x05d1)  +
	0x017485d1, // c0x0014 (n0x05d1-n0x05d2)  +
	0x017645d2, // c0x0015 (n0x05d2-n0x05d9)  +
	0x017685d9, // c0x0016 (n0x05d9-n0x05da)  +
	0x017b05da, // c0x0017 (n0x05da-n0x05ec)  +
	0x017b45ec, // c0x0018 (n0x05ec-n0x05ed)  +
	0x017d45ed, // c0x0019 (n0x05ed-n0x05f5)  +
	0x017e85f5, // c0x001a (n0x05f5-n0x05fa)  +
	0x017ec5fa, // c0x001b (n0x05fa-n0x05fb)  +
	0x0181c5fb, // c0x001c (n0x05fb-n0x0607)  +
	0x01848607, // c0x001d (n0x0607-n0x0612)  +
	0x01870612, // c0x001e (n0x0612-n0x061c)  +
	0x0187861c, // c0x001f (n0x061c-n0x061e)  +
	0x0187c61e, // c0x0020 (n0x061e-n0x061f)  +
	0x0191061f, // c0x0021 (n0x061f-n0x0644)  +
	0x01924644, // c0x0022 (n0x0644-n0x0649)  +
	0x01938649, // c0x0023 (n0x0649-n0x064e)  +
	0x0195464e, // c0x0024 (n0x064e-n0x0655)  +
	0x01964655, // c0x0025 (n0x0655-n0x0659)  +
	0x01978659, // c0x0026 (n0x0659-n0x065e)  +
	0x0199c65e, // c0x0027 (n0x065e-n0x0667)  +
	0x01ab4667, // c0x0028 (n0x0667-n0x06ad)  +
	0x01ab86ad, // c0x0029 (n0x06ad-n0x06ae)  +
	0x01acc6ae, // c0x002a (n0x06ae-n0x06b3)  +
	0x01ae06b3, // c0x002b (n0x06b3-n0x06b8)  +
	0x01ae86b8, // c0x002c (n0x06b8-n0x06ba)  +
	0x01af86ba, // c0x002d (n0x06ba-n0x06be)  +
	0x01afc6be, // c0x002e (n0x06be-n0x06bf)  +
	0x01b146bf, // c0x002f (n0x06bf-n0x06c5)  +
	0x01b586c5, // c0x0030 (n0x06c5-n0x06d6)  +
	0x01b686d6, // c0x0031 (n0x06d6-n0x06da)  +
	0x01b6c6da, // c0x0032 (n0x06da-n0x06db)  +
	0x01b706db, // c0x0033 (n0x06db-n0x06dc)  +
	0x01b746dc, // c0x0034 (n0x06dc-n0x06dd)  +
	0x01bb06dd, // c0x0035 (n0x06dd-n0x06ec)  +
	0x61bb46ec, // c0x0036 (n0x06ec-n0x06ed)* o
	0x01bc86ed, // c0x0037 (n0x06ed-n0x06f2)  +
	0x01bd86f2, // c0x0038 (n0x06f2-n0x06f6)  +
	0x01c8c6f6, // c0x0039 (n0x06f6-n0x0723)  +
	0x21c90723, // c0x003a (n0x0723-n0x0724)  o
	0x01c94724, // c0x003b (n0x0724-n0x0725)  +
	0x01c98725, // c0x003c (n0x0725-n0x0726)  +
	0x21c9c726, // c0x003d (n0x0726-n0x0727)  o
	0x21ca0727, // c0x003e (n0x0727-n0x0728)  o
	0x01cd4728, // c0x003f (n0x0728-n0x0735)  +
	0x01cd8735, // c0x0040 (n0x0735-n0x0736)  +
	0x01ffc736, // c0x0041 (n0x0736-n0x07ff)  +
	0x220447ff, // c0x0042 (n0x07ff-n0x0811)  o
	0x02068811, // c0x0043 (n0x0811-n0x081a)  +
	0x0207081a, // c0x0044 (n0x081a-n0x081c)  +
	0x2207481c, // c0x0045 (n0x081c-n0x081d)  o
	0x0209081d, // c0x0046 (n0x081d-n0x0824)  +
	0x020a8824, // c0x0047 (n0x0824-n0x082a)  +
	0x020ac82a, // c0x0048 (n0x082a-n0x082b)  +
	0x020bc82b, // c0x0049 (n0x082b-n0x082f)  +
	0x020c482f, // c0x004a (n0x082f-n0x0831)  +
	0x220f8831, // c0x004b (n0x0831-n0x083e)  o
	0x020fc83e, // c0x004c (n0x083e-n0x083f)  +
	0x0210083f, // c0x004d (n0x083f-n0x0840)  +
	0x02120840, // c0x004e (n0x0840-n0x0848)  +
	0x02124848, // c0x004f (n0x0848-n0x0849)  +
	0x02138849, // c0x0050 (n0x0849-n0x084e)  +
	0x0216084e, // c0x0051 (n0x084e-n0x0858)  +
	0x02180858, // c0x0052 (n0x0858-n0x0860)  +
	0x021b0860, // c0x0053 (n0x0860-n0x086c)  +
	0x021d886c, // c0x0054 (n0x086c-n0x0876)  +
	0x021dc876, // c0x0055 (n0x0876-n0x0877)  +
	0x02200877, // c0x0056 (n0x0877-n0x0880)  +
	0x02204880, // c0x0057 (n0x0880-n0x0881)  +
	0x02218881, // c0x0058 (n0x0881-n0x0886)  +
	0x0221c886, // c0x0059 (n0x0886-n0x0887)  +
	0x0223c887, // c0x005a (n0x0887-n0x088f)  +
	0x0224888f, // c0x005b (n0x088f-n0x0892)  +
	0x022a8892, // c0x005c (n0x0892-n0x08aa)  +
	0x022c48aa, // c0x005d (n0x08aa-n0x08b1)  +
	0x022d08b1, // c0x005e (n0x08b1-n0x08b4)  +
	0x022e48b4, // c0x005f (n0x08b4-n0x08b9)  +
	0x022fc8b9, // c0x0060 (n0x08b9-n0x08bf)  +
	0x023108bf, // c0x0061 (n0x08bf-n0x08c4)  +
	0x023288c4, // c0x0062 (n0x08c4-n0x08ca)  +
	0x023408ca, // c0x0063 (n0x08ca-n0x08d0)  +
	0x023588d0, // c0x0064 (n0x08d0-n0x08d6)  +
	0x023748d6, // c0x0065 (n0x08d6-n0x08dd)  +
	0x023808dd, // c0x0066 (n0x08dd-n0x08e0)  +
	0x023e08e0, // c0x0067 (n0x08e0-n0x08f8)  +
	0x023f88f8, // c0x0068 (n0x08f8-n0x08fe)  +
	0x0240c8fe, // c0x0069 (n0x08fe-n0x0903)  +
	0x02450903, // c0x006a (n0x0903-n0x0914)  +
	0x024d0914, // c0x006b (n0x0914-n0x0934)  +
	0x024fc934, // c0x006c (n0x0934-n0x093f)  +
	0x0250093f, // c0x006d (n0x093f-n0x0940)  +
	0x02508940, // c0x006e (n0x0940-n0x0942)  +
	0x6250c942, // c0x006f (n0x0942-n0x0943)* o
	0x22510943, // c0x0070 (n0x0943-n0x0944)  o
	0x0252c944, // c0x0071 (n0x0944-n0x094b)  +
	0x0253494b, // c0x0072 (n0x094b-n0x094d)  +
	0x0256894d, // c0x0073 (n0x094d-n0x095a)  +
	0x0259095a, // c0x0074 (n0x095a-n0x0964)  +
	0x02594964, // c0x0075 (n0x0964-n0x0965)  +
	0x025a0965, // c0x0076 (n0x0965-n0x0968)  +
	0x025b8968, // c0x0077 (n0x0968-n0x096e)  +
	0x025dc96e, // c0x0078 (n0x096e-n0x0977)  +
	0x025fc977, // c0x0079 (n0x0977-n0x097f)  +
	0x02bc097f, // c0x007a (n0x097f-n0x0af0)  +
	0x02bccaf0, // c0x007b (n0x0af0-n0x0af3)  +
	0x02becaf3, // c0x007c (n0x0af3-n0x0afb)  +
	0x02da8afb, // c0x007d (n0x0afb-n0x0b6a)  +
	0x02e78b6a, // c0x007e (n0x0b6a-n0x0b9e)  +
	0x02ee8b9e, // c0x007f (n0x0b9e-n0x0bba)  +
	0x02f40bba, // c0x0080 (n0x0bba-n0x0bd0)  +
	0x03028bd0, // c0x0081 (n0x0bd0-n0x0c0a)  +
	0x03080c0a, // c0x0082 (n0x0c0a-n0x0c20)  +
	0x030bcc20, // c0x0083 (n0x0c20-n0x0c2f)  +
	0x031b8c2f, // c0x0084 (n0x0c2f-n0x0c6e)  +
	0x03284c6e, // c0x0085 (n0x0c6e-n0x0ca1)  +
	0x0331cca1, // c0x0086 (n0x0ca1-n0x0cc7)  +
	0x033accc7, // c0x0087 (n0x0cc7-n0x0ceb)  +
	0x03410ceb, // c0x0088 (n0x0ceb-n0x0d04)  +
	0x03648d04, // c0x0089 (n0x0d04-n0x0d92)  +
	0x03700d92, // c0x008a (n0x0d92-n0x0dc0)  +
	0x037ccdc0, // c0x008b (n0x0dc0-n0x0df3)  +
	0x03818df3, // c0x008c (n0x0df3-n0x0e06)  +
	0x038a0e06, // c0x008d (n0x0e06-n0x0e28)  +
	0x038dce28, // c0x008e (n0x0e28-n0x0e37)  +
	0x0392ce37, // c0x008f (n0x0e37-n0x0e4b)  +
	0x039a4e4b, // c0x0090 (n0x0e4b-n0x0e69)  +
	0x639a8e69, // c0x0091 (n0x0e69-n0x0e6a)* o
	0x639ace6a, // c0x0092 (n0x0e6a-n0x0e6b)* o
	0x639b0e6b, // c0x0093 (n0x0e6b-n0x0e6c)* o
	0x03a2ce6c, // c0x0094 (n0x0e6c-n0x0e8b)  +
	0x03a94e8b, // c0x0095 (n0x0e8b-n0x0ea5)  +
	0x03b10ea5, // c0x0096 (n0x0ea5-n0x0ec4)  +
	0x03b88ec4, // c0x0097 (n0x0ec4-n0x0ee2)  +
	0x03c0cee2, // c0x0098 (n0x0ee2-n0x0f03)  +
	0x03c78f03, // c0x0099 (n0x0f03-n0x0f1e)  +
	0x03da4f1e, // c0x009a (n0x0f1e-n0x0f69)  +
	0x03dfcf69, // c0x009b (n0x0f69-n0x0f7f)  +
	0x63e00f7f, // c0x009c (n0x0f7f-n0x0f80)* o
	0x03e98f80, // c0x009d (n0x0f80-n0x0fa6)  +
	0x03f20fa6, // c0x009e (n0x0fa6-n0x0fc8)  +
	0x03f6cfc8, // c0x009f (n0x0fc8-n0x0fdb)  +
	0x03fd4fdb, // c0x00a0 (n0x0fdb-n0x0ff5)  +
	0x0407cff5, // c0x00a1 (n0x0ff5-n0x101f)  +
	0x0414501f, // c0x00a2 (n0x101f-n0x1051)  +
	0x041ad051, // c0x00a3 (n0x1051-n0x106b)  +
	0x042c106b, // c0x00a4 (n0x106b-n0x10b0)  +
	0x642c50b0, // c0x00a5 (n0x10b0-n0x10b1)* o
	0x642c90b1, // c0x00a6 (n0x10b1-n0x10b2)* o
	0x043250b2, // c0x00a7 (n0x10b2-n0x10c9)  +
	0x043810c9, // c0x00a8 (n0x10c9-n0x10e0)  +
	0x044110e0, // c0x00a9 (n0x10e0-n0x1104)  +
	0x0448d104, // c0x00aa (n0x1104-n0x1123)  +
	0x044d1123, // c0x00ab (n0x1123-n0x1134)  +
	0x045b5134, // c0x00ac (n0x1134-n0x116d)  +
	0x045e916d, // c0x00ad (n0x116d-n0x117a)  +
	0x0464917a, // c0x00ae (n0x117a-n0x1192)  +
	0x046bd192, // c0x00af (n0x1192-n0x11af)  +
	0x047451af, // c0x00b0 (n0x11af-n0x11d1)  +
	0x047851d1, // c0x00b1 (n0x11d1-n0x11e1)  +
	0x047f51e1, // c0x00b2 (n0x11e1-n0x11fd)  +
	0x647f91fd, // c0x00b3 (n0x11fd-n0x11fe)* o
	0x647fd1fe, // c0x00b4 (n0x11fe-n0x11ff)* o
	0x248011ff, // c0x00b5 (n0x11ff-n0x1200)  o
	0x04819200, // c0x00b6 (n0x1200-n0x1206)  +
	0x04835206, // c0x00b7 (n0x1206-n0x120d)  +
	0x0487920d, // c0x00b8 (n0x120d-n0x121e)  +
	0x0488921e, // c0x00b9 (n0x121e-n0x1222)  +
	0x048a1222, // c0x00ba (n0x1222-n0x1228)  +
	0x04919228, // c0x00bb (n0x1228-n0x1246)  +
	0x0492d246, // c0x00bc (n0x1246-n0x124b)  +
	0x0494524b, // c0x00bd (n0x124b-n0x1251)  +
	0x04969251, // c0x00be (n0x1251-n0x125a)  +
	0x0497d25a, // c0x00bf (n0x125a-n0x125f)  +
	0x0499525f, // c0x00c0 (n0x125f-n0x1265)  +
	0x04999265, // c0x00c1 (n0x1265-n0x1266)  +
	0x049d5266, // c0x00c2 (n0x1266-n0x1275)  +
	0x049e9275, // c0x00c3 (n0x1275-n0x127a)  +
	0x049f127a, // c0x00c4 (n0x127a-n0x127c)  +
	0x049f927c, // c0x00c5 (n0x127c-n0x127e)  +
	0x049fd27e, // c0x00c6 (n0x127e-n0x127f)  +
	0x04a2127f, // c0x00c7 (n0x127f-n0x1288)  +
	0x04a45288, // c0x00c8 (n0x1288-n0x1291)  +
	0x04a5d291, // c0x00c9 (n0x1291-n0x1297)  +
	0x04a65297, // c0x00ca (n0x1297-n0x1299)  +
	0x04a69299, // c0x00cb (n0x1299-n0x129a)  +
	0x04a8929a, // c0x00cc (n0x129a-n0x12a2)  +
	0x04aa92a2, // c0x00cd (n0x12a2-n0x12aa)  +
	0x04ac92aa, // c0x00ce (n0x12aa-n0x12b2)  +
	0x04ae52b2, // c0x00cf (n0x12b2-n0x12b9)  +
	0x04af52b9, // c0x00d0 (n0x12b9-n0x12bd)  +
	0x04b092bd, // c0x00d1 (n0x12bd-n0x12c2)  +
	0x04b112c2, // c0x00d2 (n0x12c2-n0x12c4)  +
	0x04b252c4, // c0x00d3 (n0x12c4-n0x12c9)  +
	0x04b352c9, // c0x00d4 (n0x12c9-n0x12cd)  +
	0x04b392cd, // c0x00d5 (n0x12cd-n0x12ce)  +
	0x04b552ce, // c0x00d6 (n0x12ce-n0x12d5)  +
	0x053e52d5, // c0x00d7 (n0x12d5-n0x14f9)  +
	0x0541d4f9, // c0x00d8 (n0x14f9-n0x1507)  +
	0x05449507, // c0x00d9 (n0x1507-n0x1512)  +
	0x05461512, // c0x00da (n0x1512-n0x1518)  +
	0x05481518, // c0x00db (n0x1518-n0x1520)  +
	0x65485520, // c0x00dc (n0x1520-n0x1521)* o
	0x054c9521, // c0x00dd (n0x1521-n0x1532)  +
	0x054d1532, // c0x00de (n0x1532-n0x1534)  +
	0x254d5534, // c0x00df (n0x1534-n0x1535)  o
	0x254d9535, // c0x00e0 (n0x1535-n0x1536)  o
	0x054dd536, // c0x00e1 (n0x1536-n0x1537)  +
	0x055a1537, // c0x00e2 (n0x1537-n0x1568)  +
	0x255a5568, // c0x00e3 (n0x1568-n0x1569)  o
	0x255ad569, // c0x00e4 (n0x1569-n0x156b)  o
	0x255b556b, // c0x00e5 (n0x156b-n0x156d)  o
	0x255c156d, // c0x00e6 (n0x156d-n0x1570)  o
	0x055e9570, // c0x00e7 (n0x1570-n0x157a)  +
	0x0560d57a, // c0x00e8 (n0x157a-n0x1583)  +
	0x05611583, // c0x00e9 (n0x1583-n0x1584)  +
	0x0561d584, // c0x00ea (n0x1584-n0x1587)  +
	0x06175587, // c0x00eb (n0x1587-n0x185d)  +
	0x0617985d, // c0x00ec (n0x185d-n0x185e)  +
	0x0617d85e, // c0x00ed (n0x185e-n0x185f)  +
	0x2618185f, // c0x00ee (n0x185f-n0x1860)  o
	0x06185860, // c0x00ef (n0x1860-n0x1861)  +
	0x26189861, // c0x00f0 (n0x1861-n0x1862)  o
	0x0618d862, // c0x00f1 (n0x1862-n0x1863)  +
	0x26199863, // c0x00f2 (n0x1863-n0x1866)  o
	0x0619d866, // c0x00f3 (n0x1866-n0x1867)  +
	0x061a1867, // c0x00f4 (n0x1867-n0x1868)  +
	0x261a5868, // c0x00f5 (n0x1868-n0x1869)  o
	0x061a9869, // c0x00f6 (n0x1869-n0x186a)  +
	0x261b186a, // c0x00f7 (n0x186a-n0x186c)  o
	0x061b586c, // c0x00f8 (n0x186c-n0x186d)  +
	0x061b986d, // c0x00f9 (n0x186d-n0x186e)  +
	0x261c986e, // c0x00fa (n0x186e-n0x1872)  o
	0x061cd872, // c0x00fb (n0x1872-n0x1873)  +
	0x061d1873, // c0x00fc (n0x1873-n0x1874)  +
	0x061d5874, // c0x00fd (n0x1874-n0x1875)  +
	0x061d9875, // c0x00fe (n0x1875-n0x1876)  +
	0x261dd876, // c0x00ff (n0x1876-n0x1877)  o
	0x061e1877, // c0x0100 (n0x1877-n0x1878)  +
	0x061e5878, // c0x0101 (n0x1878-n0x1879)  +
	0x061e9879, // c0x0102 (n0x1879-n0x187a)  +
	0x061ed87a, // c0x0103 (n0x187a-n0x187b)  +
	0x261f587b, // c0x0104 (n0x187b-n0x187d)  o
	0x061f987d, // c0x0105 (n0x187d-n0x187e)  +
	0x061fd87e, // c0x0106 (n0x187e-n0x187f)  +
	0x0620187f, // c0x0107 (n0x187f-n0x1880)  +
	0x26205880, // c0x0108 (n0x1880-n0x1881)  o
	0x06209881, // c0x0109 (n0x1881-n0x1882)  +
	0x26211882, // c0x010a (n0x1882-n0x1884)  o
	0x26215884, // c0x010b (n0x1884-n0x1885)  o
	0x06231885, // c0x010c (n0x1885-n0x188c)  +
	0x0623d88c, // c0x010d (n0x188c-n0x188f)  +
	0x0627d88f, // c0x010e (n0x188f-n0x189f)  +
	0x0628189f, // c0x010f (n0x189f-n0x18a0)  +
	0x062a58a0, // c0x0110 (n0x18a0-n0x18a9)  +
	0x0638d8a9, // c0x0111 (n0x18a9-n0x18e3)  +
	0x263958e3, // c0x0112 (n0x18e3-n0x18e5)  o
	0x263998e5, // c0x0113 (n0x18e5-n0x18e6)  o
	0x2639d8e6, // c0x0114 (n0x18e6-n0x18e7)  o
	0x063a58e7, // c0x0115 (n0x18e7-n0x18e9)  +
	0x064818e9, // c0x0116 (n0x18e9-n0x1920)  +
	0x064ad920, // c0x0117 (n0x1920-n0x192b)  +
	0x064cd92b, // c0x0118 (n0x192b-n0x1933)  +
	0x064d9933, // c0x0119 (n0x1933-n0x1936)  +
	0x064f9936, // c0x011a (n0x1936-n0x193e)  +
	0x0653193e, // c0x011b (n0x193e-n0x194c)  +
	0x067c594c, // c0x011c (n0x194c-n0x19f1)  +
	0x068819f1, // c0x011d (n0x19f1-n0x1a20)  +
	0x06895a20, // c0x011e (n0x1a20-n0x1a25)  +
	0x068c9a25, // c0x011f (n0x1a25-n0x1a32)  +
	0x068e5a32, // c0x0120 (n0x1a32-n0x1a39)  +
	0x06901a39, // c0x0121 (n0x1a39-n0x1a40)  +
	0x06925a40, // c0x0122 (n0x1a40-n0x1a49)  +
	0x0693da49, // c0x0123 (n0x1a49-n0x1a4f)  +
	0x06959a4f, // c0x0124 (n0x1a4f-n0x1a56)  +
	0x0697da56, // c0x0125 (n0x1a56-n0x1a5f)  +
	0x0698da5f, // c0x0126 (n0x1a5f-n0x1a63)  +
	0x069bda63, // c0x0127 (n0x1a63-n0x1a6f)  +
	0x069d9a6f, // c0x0128 (n0x1a6f-n0x1a76)  +
	0x06be9a76, // c0x0129 (n0x1a76-n0x1afa)  +
	0x06c0dafa, // c0x012a (n0x1afa-n0x1b03)  +
	0x06c2db03, // c0x012b (n0x1b03-n0x1b0b)  +
	0x06c41b0b, // c0x012c (n0x1b0b-n0x1b10)  +
	0x06c55b10, // c0x012d (n0x1b10-n0x1b15)  +
	0x06c75b15, // c0x012e (n0x1b15-n0x1b1d)  +
	0x06d19b1d, // c0x012f (n0x1b1d-n0x1b46)  +
	0x06d35b46, // c0x0130 (n0x1b46-n0x1b4d)  +
	0x06d4db4d, // c0x0131 (n0x1b4d-n0x1b53)  +
	0x06d51b53, // c0x0132 (n0x1b53-n0x1b54)  +
	0x06d55b54, // c0x0133 (n0x1b54-n0x1b55)  +
	0x06d69b55, // c0x0134 (n0x1b55-n0x1b5a)  +
	0x06d89b5a, // c0x0135 (n0x1b5a-n0x1b62)  +
	0x06d95b62, // c0x0136 (n0x1b62-n0x1b65)  +
	0x06dc5b65, // c0x0137 (n0x1b65-n0x1b71)  +
	0x06e45b71, // c0x0138 (n0x1b71-n0x1b91)  +
	0x06e59b91, // c0x0139 (n0x1b91-n0x1b96)  +
	0x06e5db96, // c0x013a (n0x1b96-n0x1b97)  +
	0x06e75b97, // c0x013b (n0x1b97-n0x1b9d)  +
	0x06e81b9d, // c0x013c (n0x1b9d-n0x1ba0)  +
	0x06e85ba0, // c0x013d (n0x1ba0-n0x1ba1)  +
	0x06ea1ba1, // c0x013e (n0x1ba1-n0x1ba8)  +
	0x06eddba8, // c0x013f (n0x1ba8-n0x1bb7)  +
	0x06ee1bb7, // c0x0140 (n0x1bb7-n0x1bb8)  +
	0x06f01bb8, // c0x0141 (n0x1bb8-n0x1bc0)  +
	0x06f51bc0, // c0x0142 (n0x1bc0-n0x1bd4)  +
	0x06f69bd4, // c0x0143 (n0x1bd4-n0x1bda)  +
	0x06fbdbda, // c0x0144 (n0x1bda-n0x1bef)  +
	0x06fc1bef, // c0x0145 (n0x1bef-n0x1bf0)  +
	0x06fc5bf0, // c0x0146 (n0x1bf0-n0x1bf1)  +
	0x07009bf1, // c0x0147 (n0x1bf1-n0x1c02)  +
	0x07019c02, // c0x0148 (n0x1c02-n0x1c06)  +
	0x07051c06, // c0x0149 (n0x1c06-n0x1c14)  +
	0x07081c14, // c0x014a (n0x1c14-n0x1c20)  +
	0x071b9c20, // c0x014b (n0x1c20-n0x1c6e)  +
	0x071ddc6e, // c0x014c (n0x1c6e-n0x1c77)  +
	0x07209c77, // c0x014d (n0x1c77-n0x1c82)  +
	0x0720dc82, // c0x014e (n0x1c82-n0x1c83)  +
	0x07211c83, // c0x014f (n0x1c83-n0x1c84)  +
	0x0730dc84, // c0x0150 (n0x1c84-n0x1cc3)  +
	0x07319cc3, // c0x0151 (n0x1cc3-n0x1cc6)  +
	0x07325cc6, // c0x0152 (n0x1cc6-n0x1cc9)  +
	0x07331cc9, // c0x0153 (n0x1cc9-n0x1ccc)  +
	0x0733dccc, // c0x0154 (n0x1ccc-n0x1ccf)  +
	0x07349ccf, // c0x0155 (n0x1ccf-n0x1cd2)  +
	0x07355cd2, // c0x0156 (n0x1cd2-n0x1cd5)  +
	0x07361cd5, // c0x0157 (n0x1cd5-n0x1cd8)  +
	0x0736dcd8, // c0x0158 (n0x1cd8-n0x1cdb)  +
	0x07379cdb, // c0x0159 (n0x1cdb-n0x1cde)  +
	0x07385cde, // c0x015a (n0x1cde-n0x1ce1)  +
	0x07391ce1, // c0x015b (n0x1ce1-n0x1ce4)  +
	0x0739dce4, // c0x015c (n0x1ce4-n0x1ce7)  +
	0x073a9ce7, // c0x015d (n0x1ce7-n0x1cea)  +
	0x073b1cea, // c0x015e (n0x1cea-n0x1cec)  +
	0x073bdcec, // c0x015f (n0x1cec-n0x1cef)  +
	0x073c9cef, // c0x0160 (n0x1cef-n0x1cf2)  +
	0x073d5cf2, // c0x0161 (n0x1cf2-n0x1cf5)  +
	0x073e1cf5, // c0x0162 (n0x1cf5-n0x1cf8)  +
	0x073edcf8, // c0x0163 (n0x1cf8-n0x1cfb)  +
	0x073f9cfb, // c0x0164 (n0x1cfb-n0x1cfe)  +
	0x07405cfe, // c0x0165 (n0x1cfe-n0x1d01)  +
	0x07411d01, // c0x0166 (n0x1d01-n0x1d04)  +
	0x0741dd04, // c0x0167 (n0x1d04-n0x1d07)  +
	0x07429d07, // c0x0168 (n0x1d07-n0x1d0a)  +
	0x07435d0a, // c0x0169 (n0x1d0a-n0x1d0d)  +
	0x07441d0d, // c0x016a (n0x1d0d-n0x1d10)  +
	0x0744dd10, // c0x016b (n0x1d10-n0x1d13)  +
	0x07459d13, // c0x016c (n0x1d13-n0x1d16)  +
	0x07465d16, // c0x016d (n0x1d16-n0x1d19)  +
	0x07471d19, // c0x016e (n0x1d19-n0x1d1c)  +
	0x0747dd1c, // c0x016f (n0x1d1c-n0x1d1f)  +
	0x07485d1f, // c0x0170 (n0x1d1f-n0x1d21)  +
	0x07491d21, // c0x0171 (n0x1d21-n0x1d24)  +
	0x0749dd24, // c0x0172 (n0x1d24-n0x1d27)  +
	0x074a9d27, // c0x0173 (n0x1d27-n0x1d2a)  +
	0x074b5d2a, // c0x0174 (n0x1d2a-n0x1d2d)  +
	0x074c1d2d, // c0x0175 (n0x1d2d-n0x1d30)  +
	0x074cdd30, // c0x0176 (n0x1d30-n0x1d33)  +
	0x074d9d33, // c0x0177 (n0x1d33-n0x1d36)  +
	0x074e5d36, // c0x0178 (n0x1d36-n0x1d39)  +
	0x074f1d39, // c0x0179 (n0x1d39-n0x1d3c)  +
	0x074fdd3c, // c0x017a (n0x1d3c-n0x1d3f)  +
	0x07509d3f, // c0x017b (n0x1d3f-n0x1d42)  +
	0x07515d42, // c0x017c (n0x1d42-n0x1d45)  +
	0x07521d45, // c0x017d (n0x1d45-n0x1d48)  +
	0x07529d48, // c0x017e (n0x1d48-n0x1d4a)  +
	0x07535d4a, // c0x017f (n0x1d4a-n0x1d4d)  +
	0x07541d4d, // c0x0180 (n0x1d4d-n0x1d50)  +
	0x0754dd50, // c0x0181 (n0x1d50-n0x1d53)  +
	0x07559d53, // c0x0182 (n0x1d53-n0x1d56)  +
	0x07565d56, // c0x0183 (n0x1d56-n0x1d59)  +
	0x07571d59, // c0x0184 (n0x1d59-n0x1d5c)  +
	0x0757dd5c, // c0x0185 (n0x1d5c-n0x1d5f)  +
	0x07589d5f, // c0x0186 (n0x1d5f-n0x1d62)  +
	0x0758dd62, // c0x0187 (n0x1d62-n0x1d63)  +
	0x07599d63, // c0x0188 (n0x1d63-n0x1d66)  +
	0x075b1d66, // c0x0189 (n0x1d66-n0x1d6c)  +
	0x075b5d6c, // c0x018a (n0x1d6c-n0x1d6d)  +
	0x075c5d6d, // c0x018b (n0x1d6d-n0x1d71)  +
	0x075ddd71, // c0x018c (n0x1d71-n0x1d77)  +
	0x07621d77, // c0x018d (n0x1d77-n0x1d88)  +
	0x07635d88, // c0x018e (n0x1d88-n0x1d8d)  +
	0x07669d8d, // c0x018f (n0x1d8d-n0x1d9a)  +
	0x07679d9a, // c0x0190 (n0x1d9a-n0x1d9e)  +
	0x07695d9e, // c0x0191 (n0x1d9e-n0x1da5)  +
	0x076adda5, // c0x0192 (n0x1da5-n0x1dab)  +
	0x276f1dab, // c0x0193 (n0x1dab-n0x1dbc)  o
	0x076f5dbc, // c0x0194 (n0x1dbc-n0x1dbd)  +
}

// max children 404 (capacity 511)
// max text offset 26074 (capacity 32767)
// max text length 36 (capacity 63)
// max hi 7613 (capacity 16383)
// max lo 7612 (capacity 16383)
