package servicebus

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AccessRights enumerates the values for access rights.
type AccessRights string

const (
	// Listen specifies the listen state for access rights.
	Listen AccessRights = "Listen"
	// Manage specifies the manage state for access rights.
	Manage AccessRights = "Manage"
	// Send specifies the send state for access rights.
	Send AccessRights = "Send"
)

// Kind enumerates the values for kind.
type Kind string

const (
	// EventHub specifies the event hub state for kind.
	EventHub Kind = "EventHub"
	// Messaging specifies the messaging state for kind.
	Messaging Kind = "Messaging"
)

// Name enumerates the values for name.
type Name string

const (
	// Basic specifies the basic state for name.
	Basic Name = "Basic"
	// Premium specifies the premium state for name.
	Premium Name = "Premium"
	// Standard specifies the standard state for name.
	Standard Name = "Standard"
)

// NamespaceType enumerates the values for namespace type.
type NamespaceType string

const (
	// NamespaceTypeEventHub specifies the namespace type event hub state for
	// namespace type.
	NamespaceTypeEventHub NamespaceType = "EventHub"
	// NamespaceTypeMessaging specifies the namespace type messaging state for
	// namespace type.
	NamespaceTypeMessaging NamespaceType = "Messaging"
	// NamespaceTypeNotificationHub specifies the namespace type notification
	// hub state for namespace type.
	NamespaceTypeNotificationHub NamespaceType = "NotificationHub"
)

// Policykey enumerates the values for policykey.
type Policykey string

const (
	// PrimaryKey specifies the primary key state for policykey.
	PrimaryKey Policykey = "PrimaryKey"
	// SecondayKey specifies the seconday key state for policykey.
	SecondayKey Policykey = "SecondayKey"
)

// Tier enumerates the values for tier.
type Tier string

const (
	// TierBasic specifies the tier basic state for tier.
	TierBasic Tier = "Basic"
	// TierPremium specifies the tier premium state for tier.
	TierPremium Tier = "Premium"
	// TierStandard specifies the tier standard state for tier.
	TierStandard Tier = "Standard"
)

// ARMSku is sku of the Namespace.
type ARMSku struct {
	Name     Name   `json:"Name,omitempty"`
	Tier     Tier   `json:"Tier,omitempty"`
	Capacity *int32 `json:"Capacity,omitempty"`
}

// CheckAvailabilityParameters is parameters supplied to the Check Name
// Availability for Namespace and ServiceBus.
type CheckAvailabilityParameters struct {
	Name         *string             `json:"name,omitempty"`
	Location     *string             `json:"location,omitempty"`
	Tags         *map[string]*string `json:"tags,omitempty"`
	IsAvailiable *bool               `json:"isAvailiable,omitempty"`
}

// CheckAvailabilityResource is description of a CheckAvailibility resource.
type CheckAvailabilityResource struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	IsAvailiable      *bool               `json:"isAvailiable,omitempty"`
}

// NamespaceCreateOrUpdateParameters is parameters supplied to the
// CreateOrUpdate Namespace operation.
type NamespaceCreateOrUpdateParameters struct {
	Location   *string              `json:"location,omitempty"`
	Tags       *map[string]*string  `json:"tags,omitempty"`
	Properties *NamespaceProperties `json:"properties,omitempty"`
}

// NamespaceListResult is the response of the List Namespace operation.
type NamespaceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]NamespaceResource `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// NamespaceListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client NamespaceListResult) NamespaceListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// NamespaceProperties is properties of the Namespace.
type NamespaceProperties struct {
	Name               *string       `json:"name,omitempty"`
	ProvisioningState  *string       `json:"provisioningState,omitempty"`
	Region             *string       `json:"region,omitempty"`
	Status             *string       `json:"status,omitempty"`
	CreatedAt          *date.Time    `json:"createdAt,omitempty"`
	ServiceBusEndpoint *string       `json:"serviceBusEndpoint,omitempty"`
	SubscriptionID     *string       `json:"subscriptionId,omitempty"`
	Critical           *bool         `json:"critical,omitempty"`
	NamespaceType      NamespaceType `json:"namespaceType,omitempty"`
}

// NamespaceResource is description of a Namespace resource.
type NamespaceResource struct {
	autorest.Response `json:"-"`
	ID                *string              `json:"id,omitempty"`
	Name              *string              `json:"name,omitempty"`
	Type              *string              `json:"type,omitempty"`
	Location          *string              `json:"location,omitempty"`
	Tags              *map[string]*string  `json:"tags,omitempty"`
	Kind              Kind                 `json:"kind,omitempty"`
	Sku               *ARMSku              `json:"sku,omitempty"`
	Properties        *NamespaceProperties `json:"properties,omitempty"`
}

// RegenerateKeysParameters is parameters supplied to the Regenerate Namespace
// Auth Rule.
type RegenerateKeysParameters struct {
	Policykey Policykey `json:"Policykey,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceListKeys is namespace/ServiceBus Connection String
type ResourceListKeys struct {
	autorest.Response         `json:"-"`
	PrimaryConnectionString   *string `json:"primaryConnectionString,omitempty"`
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	PrimaryKey                *string `json:"primaryKey,omitempty"`
	SecondaryKey              *string `json:"secondaryKey,omitempty"`
	KeyName                   *string `json:"keyName,omitempty"`
}

// SharedAccessAuthorizationRuleCreateOrUpdateParameters is parameters
// supplied to the CreateOrUpdate Namespace AuthorizationRules.
type SharedAccessAuthorizationRuleCreateOrUpdateParameters struct {
	Location   *string                                  `json:"location,omitempty"`
	Name       *string                                  `json:"name,omitempty"`
	Properties *SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
}

// SharedAccessAuthorizationRuleListResult is the response of the List
// Namespace operation.
type SharedAccessAuthorizationRuleListResult struct {
	autorest.Response `json:"-"`
	Value             *[]SharedAccessAuthorizationRuleResource `json:"value,omitempty"`
	NextLink          *string                                  `json:"nextLink,omitempty"`
}

// SharedAccessAuthorizationRuleListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SharedAccessAuthorizationRuleListResult) SharedAccessAuthorizationRuleListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SharedAccessAuthorizationRuleProperties is sharedAccessAuthorizationRule
// properties.
type SharedAccessAuthorizationRuleProperties struct {
	Rights *[]AccessRights `json:"rights,omitempty"`
}

// SharedAccessAuthorizationRuleResource is description of a Namespace
// AuthorizationRules.
type SharedAccessAuthorizationRuleResource struct {
	autorest.Response `json:"-"`
	ID                *string                                  `json:"id,omitempty"`
	Name              *string                                  `json:"name,omitempty"`
	Type              *string                                  `json:"type,omitempty"`
	Location          *string                                  `json:"location,omitempty"`
	Tags              *map[string]*string                      `json:"tags,omitempty"`
	Properties        *SharedAccessAuthorizationRuleProperties `json:"properties,omitempty"`
}
