/* equation.c generated by valac 0.18.1, the Vala compiler
 * generated from equation.vala, do not modify */

/*
 * Copyright (C) 2004-2008 Sami Pietila
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ERROR_CODE (error_code_get_type ())

#define TYPE_EQUATION (equation_get_type ())
#define EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EQUATION, Equation))
#define EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EQUATION, EquationClass))
#define IS_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EQUATION))
#define IS_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EQUATION))
#define EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EQUATION, EquationClass))

typedef struct _Equation Equation;
typedef struct _EquationClass EquationClass;
typedef struct _EquationPrivate EquationPrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;

#define TYPE_EQUATION_PARSER (equation_parser_get_type ())
#define EQUATION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EQUATION_PARSER, EquationParser))
#define EQUATION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EQUATION_PARSER, EquationParserClass))
#define IS_EQUATION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EQUATION_PARSER))
#define IS_EQUATION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EQUATION_PARSER))
#define EQUATION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EQUATION_PARSER, EquationParserClass))

typedef struct _EquationParser EquationParser;
typedef struct _EquationParserClass EquationParserClass;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
typedef struct _ParamSpecEquation ParamSpecEquation;
typedef struct _ParserPrivate ParserPrivate;
typedef struct _EquationParserPrivate EquationParserPrivate;
#define _equation_unref0(var) ((var == NULL) ? NULL : (var = (equation_unref (var), NULL)))

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Equation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EquationPrivate * priv;
	gint base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _EquationClass {
	GTypeClass parent_class;
	void (*finalize) (Equation *self);
	gboolean (*variable_is_defined) (Equation* self, const gchar* name);
	Number* (*get_variable) (Equation* self, const gchar* name);
	void (*set_variable) (Equation* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Equation* self, const gchar* name);
	Number* (*get_function) (Equation* self, const gchar* name, Number* x);
	Number* (*convert) (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _EquationPrivate {
	gchar* expression;
};

struct _ParamSpecEquation {
	GParamSpec parent_instance;
};

struct _Parser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ParserPrivate * priv;
	gint number_base;
	gint wordlen;
};

struct _ParserClass {
	GTypeClass parent_class;
	void (*finalize) (Parser *self);
	gboolean (*variable_is_defined) (Parser* self, const gchar* name);
	Number* (*get_variable) (Parser* self, const gchar* name);
	void (*set_variable) (Parser* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Parser* self, const gchar* name);
	Number* (*get_function) (Parser* self, const gchar* name, Number* x);
	Number* (*convert) (Parser* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _EquationParser {
	Parser parent_instance;
	EquationParserPrivate * priv;
};

struct _EquationParserClass {
	ParserClass parent_class;
};

struct _EquationParserPrivate {
	Equation* equation;
};


static gpointer equation_parent_class = NULL;
static gpointer equation_parser_parent_class = NULL;

gint sub_atoi (const gchar* data);
gint super_atoi (const gchar* data);
GType error_code_get_type (void) G_GNUC_CONST;
gchar* mp_error_code_to_string (ErrorCode error_code);
gpointer equation_ref (gpointer instance);
void equation_unref (gpointer instance);
GParamSpec* param_spec_equation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_equation (GValue* value, gpointer v_object);
void value_take_equation (GValue* value, gpointer v_object);
gpointer value_get_equation (const GValue* value);
GType equation_get_type (void) G_GNUC_CONST;
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
GType angle_unit_get_type (void) G_GNUC_CONST;
#define EQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EQUATION, EquationPrivate))
enum  {
	EQUATION_DUMMY_PROPERTY
};
Equation* equation_new (const gchar* expression);
Equation* equation_construct (GType object_type, const gchar* expression);
Number* equation_parse (Equation* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
EquationParser* equation_parser_new (Equation* equation, const gchar* expression);
EquationParser* equation_parser_construct (GType object_type, Equation* equation, const gchar* expression);
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_parser (GValue* value, gpointer v_object);
void value_take_parser (GValue* value, gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
GType equation_parser_get_type (void) G_GNUC_CONST;
void mp_clear_error (void);
Number* parser_parse (Parser* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
gchar* mp_get_error (void);
gboolean equation_variable_is_defined (Equation* self, const gchar* name);
static gboolean equation_real_variable_is_defined (Equation* self, const gchar* name);
Number* equation_get_variable (Equation* self, const gchar* name);
static Number* equation_real_get_variable (Equation* self, const gchar* name);
void equation_set_variable (Equation* self, const gchar* name, Number* x);
static void equation_real_set_variable (Equation* self, const gchar* name, Number* x);
gboolean equation_function_is_defined (Equation* self, const gchar* name);
static gboolean equation_real_function_is_defined (Equation* self, const gchar* name);
Number* equation_get_function (Equation* self, const gchar* name, Number* x);
static Number* equation_real_get_function (Equation* self, const gchar* name, Number* x);
Number* equation_convert (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
static Number* equation_real_convert (Equation* self, Number* x, const gchar* x_units, const gchar* z_units);
static void equation_finalize (Equation* obj);
#define EQUATION_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EQUATION_PARSER, EquationParserPrivate))
enum  {
	EQUATION_PARSER_DUMMY_PROPERTY
};
Parser* parser_new (const gchar* input, gint number_base, gint wordlen);
Parser* parser_construct (GType object_type, const gchar* input, gint number_base, gint wordlen);
static gboolean equation_parser_real_variable_is_defined (Parser* base, const gchar* name);
static Number* equation_parser_real_get_variable (Parser* base, const gchar* name);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
static void equation_parser_real_set_variable (Parser* base, const gchar* name, Number* x);
static gboolean equation_parser_real_function_is_defined (Parser* base, const gchar* name);
static Number* equation_parser_real_get_function (Parser* base, const gchar* name, Number* x);
Number* number_logarithm (Number* self, gint64 n);
Number* number_ln (Number* self);
Number* number_sqrt (Number* self);
Number* number_abs (Number* self);
Number* number_sgn (Number* self);
Number* number_arg (Number* self, AngleUnit unit);
Number* number_conjugate (Number* self);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_floor (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_sin (Number* self, AngleUnit unit);
Number* number_cos (Number* self, AngleUnit unit);
Number* number_tan (Number* self, AngleUnit unit);
Number* number_asin (Number* self, AngleUnit unit);
Number* number_acos (Number* self, AngleUnit unit);
Number* number_atan (Number* self, AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_cosh (Number* self);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_ones_complement (Number* self, gint wordlen);
Number* number_twos_complement (Number* self, gint wordlen);
static Number* equation_parser_real_convert (Parser* base, Number* x, const gchar* x_units, const gchar* z_units);
static void equation_parser_finalize (Parser* obj);


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gint sub_atoi (const gchar* data) {
	gint result = 0;
	static const gunichar digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	gint index;
	gunichar c = 0U;
	gint value;
	g_return_val_if_fail (data != NULL, 0);
	index = 0;
	value = 0;
	while (TRUE) {
		const gchar* _tmp0_;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_ = FALSE;
		gboolean is_subdigit;
		gboolean _tmp12_;
		_tmp0_ = data;
		_tmp2_ = string_get_next_char (_tmp0_, &index, &_tmp1_);
		c = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		is_subdigit = FALSE;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp4_;
					gint _tmp6_;
					gunichar _tmp7_;
					gint _tmp8_;
					gunichar _tmp9_;
					_tmp4_ = _tmp3_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp6_ = i;
					if (!(_tmp6_ < G_N_ELEMENTS (digits))) {
						break;
					}
					_tmp7_ = c;
					_tmp8_ = i;
					_tmp9_ = digits[_tmp8_];
					if (_tmp7_ == _tmp9_) {
						gint _tmp10_;
						gint _tmp11_;
						_tmp10_ = value;
						_tmp11_ = i;
						value = (_tmp10_ * 10) + _tmp11_;
						is_subdigit = TRUE;
						break;
					}
				}
			}
		}
		_tmp12_ = is_subdigit;
		if (!_tmp12_) {
			result = -1;
			return result;
		}
	}
	result = value;
	return result;
}


gint super_atoi (const gchar* data) {
	gint result = 0;
	static const gunichar digits[] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	gint index;
	gunichar c = 0U;
	const gchar* _tmp0_;
	gunichar _tmp1_ = 0U;
	gint sign;
	gunichar _tmp2_;
	gint value;
	gint _tmp16_;
	gint _tmp17_;
	g_return_val_if_fail (data != NULL, 0);
	index = 0;
	_tmp0_ = data;
	string_get_next_char (_tmp0_, &index, &_tmp1_);
	c = _tmp1_;
	sign = 1;
	_tmp2_ = c;
	if (_tmp2_ == 8315U) {
		sign = -1;
	} else {
		index = 0;
	}
	value = 0;
	while (TRUE) {
		const gchar* _tmp3_;
		gunichar _tmp4_ = 0U;
		gboolean _tmp5_ = FALSE;
		gboolean is_superdigit;
		gboolean _tmp15_;
		_tmp3_ = data;
		_tmp5_ = string_get_next_char (_tmp3_, &index, &_tmp4_);
		c = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		is_superdigit = FALSE;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					gboolean _tmp7_;
					gint _tmp9_;
					gunichar _tmp10_;
					gint _tmp11_;
					gunichar _tmp12_;
					_tmp7_ = _tmp6_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp9_ = i;
					if (!(_tmp9_ < G_N_ELEMENTS (digits))) {
						break;
					}
					_tmp10_ = c;
					_tmp11_ = i;
					_tmp12_ = digits[_tmp11_];
					if (_tmp10_ == _tmp12_) {
						gint _tmp13_;
						gint _tmp14_;
						_tmp13_ = value;
						_tmp14_ = i;
						value = (_tmp13_ * 10) + _tmp14_;
						is_superdigit = TRUE;
						break;
					}
				}
			}
		}
		_tmp15_ = is_superdigit;
		if (!_tmp15_) {
			result = 0;
			return result;
		}
	}
	_tmp16_ = sign;
	_tmp17_ = value;
	result = _tmp16_ * _tmp17_;
	return result;
}


gchar* mp_error_code_to_string (ErrorCode error_code) {
	gchar* result = NULL;
	ErrorCode _tmp0_;
	_tmp0_ = error_code;
	switch (_tmp0_) {
		case ERROR_CODE_NONE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ErrorCode.NONE");
			result = _tmp1_;
			return result;
		}
		case ERROR_CODE_INVALID:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("ErrorCode.INVALID");
			result = _tmp2_;
			return result;
		}
		case ERROR_CODE_OVERFLOW:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("ErrorCode.OVERFLOW");
			result = _tmp3_;
			return result;
		}
		case ERROR_CODE_UNKNOWN_VARIABLE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("ErrorCode.UNKNOWN_VARIABLE");
			result = _tmp4_;
			return result;
		}
		case ERROR_CODE_UNKNOWN_FUNCTION:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("ErrorCode.UNKNOWN_FUNCTION");
			result = _tmp5_;
			return result;
		}
		case ERROR_CODE_UNKNOWN_CONVERSION:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("ErrorCode.UNKNOWN_CONVERSION");
			result = _tmp6_;
			return result;
		}
		case ERROR_CODE_MP:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("ErrorCode.MP");
			result = _tmp7_;
			return result;
		}
		default:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("Unknown parser error");
			result = _tmp8_;
			return result;
		}
	}
}


GType error_code_get_type (void) {
	static volatile gsize error_code_type_id__volatile = 0;
	if (g_once_init_enter (&error_code_type_id__volatile)) {
		static const GEnumValue values[] = {{ERROR_CODE_NONE, "ERROR_CODE_NONE", "none"}, {ERROR_CODE_INVALID, "ERROR_CODE_INVALID", "invalid"}, {ERROR_CODE_OVERFLOW, "ERROR_CODE_OVERFLOW", "overflow"}, {ERROR_CODE_UNKNOWN_VARIABLE, "ERROR_CODE_UNKNOWN_VARIABLE", "unknown-variable"}, {ERROR_CODE_UNKNOWN_FUNCTION, "ERROR_CODE_UNKNOWN_FUNCTION", "unknown-function"}, {ERROR_CODE_UNKNOWN_CONVERSION, "ERROR_CODE_UNKNOWN_CONVERSION", "unknown-conversion"}, {ERROR_CODE_MP, "ERROR_CODE_MP", "mp"}, {0, NULL, NULL}};
		GType error_code_type_id;
		error_code_type_id = g_enum_register_static ("ErrorCode", values);
		g_once_init_leave (&error_code_type_id__volatile, error_code_type_id);
	}
	return error_code_type_id__volatile;
}


Equation* equation_construct (GType object_type, const gchar* expression) {
	Equation* self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (Equation*) g_type_create_instance (object_type);
	_tmp0_ = expression;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->expression);
	self->priv->expression = _tmp1_;
	return self;
}


Equation* equation_new (const gchar* expression) {
	return equation_construct (TYPE_EQUATION, expression);
}


Number* equation_parse (Equation* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end) {
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint _vala_error_start = 0U;
	guint _vala_error_end = 0U;
	Number* result = NULL;
	const gchar* _tmp0_;
	EquationParser* _tmp1_;
	EquationParser* parser;
	EquationParser* _tmp2_;
	guint _tmp3_ = 0U;
	ErrorCode _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	Number* _tmp8_ = NULL;
	Number* z;
	ErrorCode _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->expression;
	_tmp1_ = equation_parser_new (self, _tmp0_);
	parser = _tmp1_;
	mp_clear_error ();
	_tmp2_ = parser;
	_tmp8_ = parser_parse ((Parser*) _tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	_vala_representation_base = _tmp3_;
	_vala_error_code = _tmp4_;
	_g_free0 (_vala_error_token);
	_vala_error_token = _tmp5_;
	_vala_error_start = _tmp6_;
	_vala_error_end = _tmp7_;
	z = _tmp8_;
	_tmp9_ = _vala_error_code;
	if (_tmp9_ != ERROR_CODE_NONE) {
		result = NULL;
		_number_unref0 (z);
		_parser_unref0 (parser);
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	_tmp10_ = mp_get_error ();
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		_vala_error_code = ERROR_CODE_MP;
		result = NULL;
		_number_unref0 (z);
		_parser_unref0 (parser);
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	result = z;
	_parser_unref0 (parser);
	if (representation_base) {
		*representation_base = _vala_representation_base;
	}
	if (error_code) {
		*error_code = _vala_error_code;
	}
	if (error_token) {
		*error_token = _vala_error_token;
	} else {
		_g_free0 (_vala_error_token);
	}
	if (error_start) {
		*error_start = _vala_error_start;
	}
	if (error_end) {
		*error_end = _vala_error_end;
	}
	return result;
}


static gboolean equation_real_variable_is_defined (Equation* self, const gchar* name) {
	gboolean result = FALSE;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean equation_variable_is_defined (Equation* self, const gchar* name) {
	g_return_val_if_fail (self != NULL, FALSE);
	return EQUATION_GET_CLASS (self)->variable_is_defined (self, name);
}


static Number* equation_real_get_variable (Equation* self, const gchar* name) {
	Number* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	result = NULL;
	return result;
}


Number* equation_get_variable (Equation* self, const gchar* name) {
	g_return_val_if_fail (self != NULL, NULL);
	return EQUATION_GET_CLASS (self)->get_variable (self, name);
}


static void equation_real_set_variable (Equation* self, const gchar* name, Number* x) {
	g_return_if_fail (name != NULL);
	g_return_if_fail (x != NULL);
}


void equation_set_variable (Equation* self, const gchar* name, Number* x) {
	g_return_if_fail (self != NULL);
	EQUATION_GET_CLASS (self)->set_variable (self, name, x);
}


static gboolean equation_real_function_is_defined (Equation* self, const gchar* name) {
	gboolean result = FALSE;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean equation_function_is_defined (Equation* self, const gchar* name) {
	g_return_val_if_fail (self != NULL, FALSE);
	return EQUATION_GET_CLASS (self)->function_is_defined (self, name);
}


static Number* equation_real_get_function (Equation* self, const gchar* name, Number* x) {
	Number* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	result = NULL;
	return result;
}


Number* equation_get_function (Equation* self, const gchar* name, Number* x) {
	g_return_val_if_fail (self != NULL, NULL);
	return EQUATION_GET_CLASS (self)->get_function (self, name, x);
}


static Number* equation_real_convert (Equation* self, Number* x, const gchar* x_units, const gchar* z_units) {
	Number* result = NULL;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	result = NULL;
	return result;
}


Number* equation_convert (Equation* self, Number* x, const gchar* x_units, const gchar* z_units) {
	g_return_val_if_fail (self != NULL, NULL);
	return EQUATION_GET_CLASS (self)->convert (self, x, x_units, z_units);
}


static void value_equation_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_equation_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		equation_unref (value->data[0].v_pointer);
	}
}


static void value_equation_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = equation_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_equation_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_equation_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Equation* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = equation_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_equation_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Equation** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = equation_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_equation (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEquation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EQUATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_equation (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EQUATION), NULL);
	return value->data[0].v_pointer;
}


void value_set_equation (GValue* value, gpointer v_object) {
	Equation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EQUATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EQUATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		equation_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		equation_unref (old);
	}
}


void value_take_equation (GValue* value, gpointer v_object) {
	Equation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EQUATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EQUATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		equation_unref (old);
	}
}


static void equation_class_init (EquationClass * klass) {
	equation_parent_class = g_type_class_peek_parent (klass);
	EQUATION_CLASS (klass)->finalize = equation_finalize;
	g_type_class_add_private (klass, sizeof (EquationPrivate));
	EQUATION_CLASS (klass)->variable_is_defined = equation_real_variable_is_defined;
	EQUATION_CLASS (klass)->get_variable = equation_real_get_variable;
	EQUATION_CLASS (klass)->set_variable = equation_real_set_variable;
	EQUATION_CLASS (klass)->function_is_defined = equation_real_function_is_defined;
	EQUATION_CLASS (klass)->get_function = equation_real_get_function;
	EQUATION_CLASS (klass)->convert = equation_real_convert;
}


static void equation_instance_init (Equation * self) {
	self->priv = EQUATION_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void equation_finalize (Equation* obj) {
	Equation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EQUATION, Equation);
	_g_free0 (self->priv->expression);
}


GType equation_get_type (void) {
	static volatile gsize equation_type_id__volatile = 0;
	if (g_once_init_enter (&equation_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_equation_init, value_equation_free_value, value_equation_copy_value, value_equation_peek_pointer, "p", value_equation_collect_value, "p", value_equation_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Equation), 0, (GInstanceInitFunc) equation_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType equation_type_id;
		equation_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Equation", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&equation_type_id__volatile, equation_type_id);
	}
	return equation_type_id__volatile;
}


gpointer equation_ref (gpointer instance) {
	Equation* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void equation_unref (gpointer instance) {
	Equation* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EQUATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gpointer _equation_ref0 (gpointer self) {
	return self ? equation_ref (self) : NULL;
}


EquationParser* equation_parser_construct (GType object_type, Equation* equation, const gchar* expression) {
	EquationParser* self = NULL;
	const gchar* _tmp0_;
	Equation* _tmp1_;
	gint _tmp2_;
	Equation* _tmp3_;
	gint _tmp4_;
	Equation* _tmp5_;
	Equation* _tmp6_;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	_tmp0_ = expression;
	_tmp1_ = equation;
	_tmp2_ = _tmp1_->base;
	_tmp3_ = equation;
	_tmp4_ = _tmp3_->wordlen;
	self = (EquationParser*) parser_construct (object_type, _tmp0_, _tmp2_, _tmp4_);
	_tmp5_ = equation;
	_tmp6_ = _equation_ref0 (_tmp5_);
	_equation_unref0 (self->priv->equation);
	self->priv->equation = _tmp6_;
	return self;
}


EquationParser* equation_parser_new (Equation* equation, const gchar* expression) {
	return equation_parser_construct (TYPE_EQUATION_PARSER, equation, expression);
}


static gboolean equation_parser_real_variable_is_defined (Parser* base, const gchar* name) {
	EquationParser * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp6_;
	Equation* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	self = (EquationParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp2_ = name;
	if (g_strcmp0 (_tmp2_, "e") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = name;
		_tmp1_ = g_strcmp0 (_tmp3_, "i") == 0;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = name;
		_tmp0_ = g_strcmp0 (_tmp5_, "π") == 0;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = self->priv->equation;
	_tmp8_ = name;
	_tmp9_ = equation_variable_is_defined (_tmp7_, _tmp8_);
	result = _tmp9_;
	return result;
}


static Number* equation_parser_real_get_variable (Parser* base, const gchar* name) {
	EquationParser * self;
	Number* result = NULL;
	const gchar* _tmp0_;
	self = (EquationParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "e") == 0) {
		Number* _tmp1_;
		_tmp1_ = number_new_eulers ();
		result = _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = name;
		if (g_strcmp0 (_tmp2_, "i") == 0) {
			Number* _tmp3_;
			_tmp3_ = number_new_i ();
			result = _tmp3_;
			return result;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = name;
			if (g_strcmp0 (_tmp4_, "π") == 0) {
				Number* _tmp5_;
				_tmp5_ = number_new_pi ();
				result = _tmp5_;
				return result;
			} else {
				Equation* _tmp6_;
				const gchar* _tmp7_;
				Number* _tmp8_ = NULL;
				_tmp6_ = self->priv->equation;
				_tmp7_ = name;
				_tmp8_ = equation_get_variable (_tmp6_, _tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	}
}


static void equation_parser_real_set_variable (Parser* base, const gchar* name, Number* x) {
	EquationParser * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp6_;
	Equation* _tmp7_;
	const gchar* _tmp8_;
	Number* _tmp9_;
	self = (EquationParser*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (x != NULL);
	_tmp2_ = name;
	if (g_strcmp0 (_tmp2_, "e") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = name;
		_tmp1_ = g_strcmp0 (_tmp3_, "i") == 0;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = name;
		_tmp0_ = g_strcmp0 (_tmp5_, "π") == 0;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		return;
	}
	_tmp7_ = self->priv->equation;
	_tmp8_ = name;
	_tmp9_ = x;
	equation_set_variable (_tmp7_, _tmp8_, _tmp9_);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean equation_parser_real_function_is_defined (Parser* base, const gchar* name) {
	EquationParser * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* lower_name;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	const gchar* _tmp36_;
	gboolean _tmp45_;
	gboolean _tmp47_;
	gboolean _tmp49_;
	gboolean _tmp51_;
	gboolean _tmp53_;
	gboolean _tmp55_;
	gboolean _tmp57_;
	gboolean _tmp59_;
	gboolean _tmp61_;
	gboolean _tmp63_;
	gboolean _tmp65_;
	gboolean _tmp67_;
	gboolean _tmp69_;
	gboolean _tmp71_;
	gboolean _tmp73_;
	gboolean _tmp75_;
	gboolean _tmp77_;
	gboolean _tmp79_;
	gboolean _tmp81_;
	gboolean _tmp83_;
	gboolean _tmp85_;
	gboolean _tmp87_;
	gboolean _tmp89_;
	gboolean _tmp91_;
	gboolean _tmp93_;
	gboolean _tmp95_;
	gboolean _tmp97_;
	gboolean _tmp99_;
	gboolean _tmp101_;
	gboolean _tmp103_;
	gboolean _tmp105_;
	gboolean _tmp107_;
	gboolean _tmp109_;
	gboolean _tmp111_;
	Equation* _tmp112_;
	const gchar* _tmp113_;
	gboolean _tmp114_ = FALSE;
	self = (EquationParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	lower_name = _tmp1_;
	_tmp36_ = lower_name;
	if (g_strcmp0 (_tmp36_, "log") == 0) {
		_tmp35_ = TRUE;
	} else {
		gboolean _tmp37_ = FALSE;
		const gchar* _tmp38_;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp44_;
		_tmp38_ = lower_name;
		_tmp39_ = g_str_has_prefix (_tmp38_, "log");
		if (_tmp39_) {
			const gchar* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			gint _tmp43_ = 0;
			_tmp40_ = lower_name;
			_tmp41_ = string_substring (_tmp40_, (glong) 3, (glong) (-1));
			_tmp42_ = _tmp41_;
			_tmp43_ = sub_atoi (_tmp42_);
			_tmp37_ = _tmp43_ >= 0;
			_g_free0 (_tmp42_);
		} else {
			_tmp37_ = FALSE;
		}
		_tmp44_ = _tmp37_;
		_tmp35_ = _tmp44_;
	}
	_tmp45_ = _tmp35_;
	if (_tmp45_) {
		_tmp34_ = TRUE;
	} else {
		const gchar* _tmp46_;
		_tmp46_ = lower_name;
		_tmp34_ = g_strcmp0 (_tmp46_, "ln") == 0;
	}
	_tmp47_ = _tmp34_;
	if (_tmp47_) {
		_tmp33_ = TRUE;
	} else {
		const gchar* _tmp48_;
		_tmp48_ = lower_name;
		_tmp33_ = g_strcmp0 (_tmp48_, "sqrt") == 0;
	}
	_tmp49_ = _tmp33_;
	if (_tmp49_) {
		_tmp32_ = TRUE;
	} else {
		const gchar* _tmp50_;
		_tmp50_ = lower_name;
		_tmp32_ = g_strcmp0 (_tmp50_, "abs") == 0;
	}
	_tmp51_ = _tmp32_;
	if (_tmp51_) {
		_tmp31_ = TRUE;
	} else {
		const gchar* _tmp52_;
		_tmp52_ = lower_name;
		_tmp31_ = g_strcmp0 (_tmp52_, "sgn") == 0;
	}
	_tmp53_ = _tmp31_;
	if (_tmp53_) {
		_tmp30_ = TRUE;
	} else {
		const gchar* _tmp54_;
		_tmp54_ = lower_name;
		_tmp30_ = g_strcmp0 (_tmp54_, "arg") == 0;
	}
	_tmp55_ = _tmp30_;
	if (_tmp55_) {
		_tmp29_ = TRUE;
	} else {
		const gchar* _tmp56_;
		_tmp56_ = lower_name;
		_tmp29_ = g_strcmp0 (_tmp56_, "conj") == 0;
	}
	_tmp57_ = _tmp29_;
	if (_tmp57_) {
		_tmp28_ = TRUE;
	} else {
		const gchar* _tmp58_;
		_tmp58_ = lower_name;
		_tmp28_ = g_strcmp0 (_tmp58_, "int") == 0;
	}
	_tmp59_ = _tmp28_;
	if (_tmp59_) {
		_tmp27_ = TRUE;
	} else {
		const gchar* _tmp60_;
		_tmp60_ = lower_name;
		_tmp27_ = g_strcmp0 (_tmp60_, "frac") == 0;
	}
	_tmp61_ = _tmp27_;
	if (_tmp61_) {
		_tmp26_ = TRUE;
	} else {
		const gchar* _tmp62_;
		_tmp62_ = lower_name;
		_tmp26_ = g_strcmp0 (_tmp62_, "floor") == 0;
	}
	_tmp63_ = _tmp26_;
	if (_tmp63_) {
		_tmp25_ = TRUE;
	} else {
		const gchar* _tmp64_;
		_tmp64_ = lower_name;
		_tmp25_ = g_strcmp0 (_tmp64_, "ceil") == 0;
	}
	_tmp65_ = _tmp25_;
	if (_tmp65_) {
		_tmp24_ = TRUE;
	} else {
		const gchar* _tmp66_;
		_tmp66_ = lower_name;
		_tmp24_ = g_strcmp0 (_tmp66_, "round") == 0;
	}
	_tmp67_ = _tmp24_;
	if (_tmp67_) {
		_tmp23_ = TRUE;
	} else {
		const gchar* _tmp68_;
		_tmp68_ = lower_name;
		_tmp23_ = g_strcmp0 (_tmp68_, "re") == 0;
	}
	_tmp69_ = _tmp23_;
	if (_tmp69_) {
		_tmp22_ = TRUE;
	} else {
		const gchar* _tmp70_;
		_tmp70_ = lower_name;
		_tmp22_ = g_strcmp0 (_tmp70_, "im") == 0;
	}
	_tmp71_ = _tmp22_;
	if (_tmp71_) {
		_tmp21_ = TRUE;
	} else {
		const gchar* _tmp72_;
		_tmp72_ = lower_name;
		_tmp21_ = g_strcmp0 (_tmp72_, "sin") == 0;
	}
	_tmp73_ = _tmp21_;
	if (_tmp73_) {
		_tmp20_ = TRUE;
	} else {
		const gchar* _tmp74_;
		_tmp74_ = lower_name;
		_tmp20_ = g_strcmp0 (_tmp74_, "cos") == 0;
	}
	_tmp75_ = _tmp20_;
	if (_tmp75_) {
		_tmp19_ = TRUE;
	} else {
		const gchar* _tmp76_;
		_tmp76_ = lower_name;
		_tmp19_ = g_strcmp0 (_tmp76_, "tan") == 0;
	}
	_tmp77_ = _tmp19_;
	if (_tmp77_) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp78_;
		_tmp78_ = lower_name;
		_tmp18_ = g_strcmp0 (_tmp78_, "asin") == 0;
	}
	_tmp79_ = _tmp18_;
	if (_tmp79_) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp80_;
		_tmp80_ = lower_name;
		_tmp17_ = g_strcmp0 (_tmp80_, "acos") == 0;
	}
	_tmp81_ = _tmp17_;
	if (_tmp81_) {
		_tmp16_ = TRUE;
	} else {
		const gchar* _tmp82_;
		_tmp82_ = lower_name;
		_tmp16_ = g_strcmp0 (_tmp82_, "atan") == 0;
	}
	_tmp83_ = _tmp16_;
	if (_tmp83_) {
		_tmp15_ = TRUE;
	} else {
		const gchar* _tmp84_;
		_tmp84_ = lower_name;
		_tmp15_ = g_strcmp0 (_tmp84_, "sin⁻¹") == 0;
	}
	_tmp85_ = _tmp15_;
	if (_tmp85_) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp86_;
		_tmp86_ = lower_name;
		_tmp14_ = g_strcmp0 (_tmp86_, "cos⁻¹") == 0;
	}
	_tmp87_ = _tmp14_;
	if (_tmp87_) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp88_;
		_tmp88_ = lower_name;
		_tmp13_ = g_strcmp0 (_tmp88_, "tan⁻¹") == 0;
	}
	_tmp89_ = _tmp13_;
	if (_tmp89_) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp90_;
		_tmp90_ = lower_name;
		_tmp12_ = g_strcmp0 (_tmp90_, "sinh") == 0;
	}
	_tmp91_ = _tmp12_;
	if (_tmp91_) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp92_;
		_tmp92_ = lower_name;
		_tmp11_ = g_strcmp0 (_tmp92_, "cosh") == 0;
	}
	_tmp93_ = _tmp11_;
	if (_tmp93_) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp94_;
		_tmp94_ = lower_name;
		_tmp10_ = g_strcmp0 (_tmp94_, "tanh") == 0;
	}
	_tmp95_ = _tmp10_;
	if (_tmp95_) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp96_;
		_tmp96_ = lower_name;
		_tmp9_ = g_strcmp0 (_tmp96_, "sinh⁻¹") == 0;
	}
	_tmp97_ = _tmp9_;
	if (_tmp97_) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp98_;
		_tmp98_ = lower_name;
		_tmp8_ = g_strcmp0 (_tmp98_, "cosh⁻¹") == 0;
	}
	_tmp99_ = _tmp8_;
	if (_tmp99_) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp100_;
		_tmp100_ = lower_name;
		_tmp7_ = g_strcmp0 (_tmp100_, "tanh⁻¹") == 0;
	}
	_tmp101_ = _tmp7_;
	if (_tmp101_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp102_;
		_tmp102_ = lower_name;
		_tmp6_ = g_strcmp0 (_tmp102_, "asinh") == 0;
	}
	_tmp103_ = _tmp6_;
	if (_tmp103_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp104_;
		_tmp104_ = lower_name;
		_tmp5_ = g_strcmp0 (_tmp104_, "acosh") == 0;
	}
	_tmp105_ = _tmp5_;
	if (_tmp105_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp106_;
		_tmp106_ = lower_name;
		_tmp4_ = g_strcmp0 (_tmp106_, "atanh") == 0;
	}
	_tmp107_ = _tmp4_;
	if (_tmp107_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp108_;
		_tmp108_ = lower_name;
		_tmp3_ = g_strcmp0 (_tmp108_, "ones") == 0;
	}
	_tmp109_ = _tmp3_;
	if (_tmp109_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp110_;
		_tmp110_ = lower_name;
		_tmp2_ = g_strcmp0 (_tmp110_, "twos") == 0;
	}
	_tmp111_ = _tmp2_;
	if (_tmp111_) {
		result = TRUE;
		_g_free0 (lower_name);
		return result;
	}
	_tmp112_ = self->priv->equation;
	_tmp113_ = name;
	_tmp114_ = equation_function_is_defined (_tmp112_, _tmp113_);
	result = _tmp114_;
	_g_free0 (lower_name);
	return result;
}


static Number* equation_parser_real_get_function (Parser* base, const gchar* name, Number* x) {
	EquationParser * self;
	Number* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* lower_name;
	const gchar* _tmp2_;
	self = (EquationParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	lower_name = _tmp1_;
	_tmp2_ = lower_name;
	if (g_strcmp0 (_tmp2_, "log") == 0) {
		Number* _tmp3_;
		Number* _tmp4_ = NULL;
		_tmp3_ = x;
		_tmp4_ = number_logarithm (_tmp3_, (gint64) 10);
		result = _tmp4_;
		_g_free0 (lower_name);
		return result;
	} else {
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = lower_name;
		_tmp6_ = g_str_has_prefix (_tmp5_, "log");
		if (_tmp6_) {
			const gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gint _tmp10_ = 0;
			gint _tmp11_;
			gint number_base;
			gint _tmp12_;
			_tmp7_ = lower_name;
			_tmp8_ = string_substring (_tmp7_, (glong) 3, (glong) (-1));
			_tmp9_ = _tmp8_;
			_tmp10_ = sub_atoi (_tmp9_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			number_base = _tmp11_;
			_tmp12_ = number_base;
			if (_tmp12_ < 0) {
				result = NULL;
				_g_free0 (lower_name);
				return result;
			} else {
				Number* _tmp13_;
				gint _tmp14_;
				Number* _tmp15_ = NULL;
				_tmp13_ = x;
				_tmp14_ = number_base;
				_tmp15_ = number_logarithm (_tmp13_, (gint64) _tmp14_);
				result = _tmp15_;
				_g_free0 (lower_name);
				return result;
			}
		} else {
			const gchar* _tmp16_;
			_tmp16_ = lower_name;
			if (g_strcmp0 (_tmp16_, "ln") == 0) {
				Number* _tmp17_;
				Number* _tmp18_ = NULL;
				_tmp17_ = x;
				_tmp18_ = number_ln (_tmp17_);
				result = _tmp18_;
				_g_free0 (lower_name);
				return result;
			} else {
				const gchar* _tmp19_;
				_tmp19_ = lower_name;
				if (g_strcmp0 (_tmp19_, "sqrt") == 0) {
					Number* _tmp20_;
					Number* _tmp21_ = NULL;
					_tmp20_ = x;
					_tmp21_ = number_sqrt (_tmp20_);
					result = _tmp21_;
					_g_free0 (lower_name);
					return result;
				} else {
					const gchar* _tmp22_;
					_tmp22_ = lower_name;
					if (g_strcmp0 (_tmp22_, "abs") == 0) {
						Number* _tmp23_;
						Number* _tmp24_ = NULL;
						_tmp23_ = x;
						_tmp24_ = number_abs (_tmp23_);
						result = _tmp24_;
						_g_free0 (lower_name);
						return result;
					} else {
						const gchar* _tmp25_;
						_tmp25_ = lower_name;
						if (g_strcmp0 (_tmp25_, "sgn") == 0) {
							Number* _tmp26_;
							Number* _tmp27_ = NULL;
							_tmp26_ = x;
							_tmp27_ = number_sgn (_tmp26_);
							result = _tmp27_;
							_g_free0 (lower_name);
							return result;
						} else {
							const gchar* _tmp28_;
							_tmp28_ = lower_name;
							if (g_strcmp0 (_tmp28_, "arg") == 0) {
								Number* _tmp29_;
								Equation* _tmp30_;
								AngleUnit _tmp31_;
								Number* _tmp32_ = NULL;
								_tmp29_ = x;
								_tmp30_ = self->priv->equation;
								_tmp31_ = _tmp30_->angle_units;
								_tmp32_ = number_arg (_tmp29_, _tmp31_);
								result = _tmp32_;
								_g_free0 (lower_name);
								return result;
							} else {
								const gchar* _tmp33_;
								_tmp33_ = lower_name;
								if (g_strcmp0 (_tmp33_, "conj") == 0) {
									Number* _tmp34_;
									Number* _tmp35_ = NULL;
									_tmp34_ = x;
									_tmp35_ = number_conjugate (_tmp34_);
									result = _tmp35_;
									_g_free0 (lower_name);
									return result;
								} else {
									const gchar* _tmp36_;
									_tmp36_ = lower_name;
									if (g_strcmp0 (_tmp36_, "int") == 0) {
										Number* _tmp37_;
										Number* _tmp38_ = NULL;
										_tmp37_ = x;
										_tmp38_ = number_integer_component (_tmp37_);
										result = _tmp38_;
										_g_free0 (lower_name);
										return result;
									} else {
										const gchar* _tmp39_;
										_tmp39_ = lower_name;
										if (g_strcmp0 (_tmp39_, "frac") == 0) {
											Number* _tmp40_;
											Number* _tmp41_ = NULL;
											_tmp40_ = x;
											_tmp41_ = number_fractional_component (_tmp40_);
											result = _tmp41_;
											_g_free0 (lower_name);
											return result;
										} else {
											const gchar* _tmp42_;
											_tmp42_ = lower_name;
											if (g_strcmp0 (_tmp42_, "floor") == 0) {
												Number* _tmp43_;
												Number* _tmp44_ = NULL;
												_tmp43_ = x;
												_tmp44_ = number_floor (_tmp43_);
												result = _tmp44_;
												_g_free0 (lower_name);
												return result;
											} else {
												const gchar* _tmp45_;
												_tmp45_ = lower_name;
												if (g_strcmp0 (_tmp45_, "ceil") == 0) {
													Number* _tmp46_;
													Number* _tmp47_ = NULL;
													_tmp46_ = x;
													_tmp47_ = number_ceiling (_tmp46_);
													result = _tmp47_;
													_g_free0 (lower_name);
													return result;
												} else {
													const gchar* _tmp48_;
													_tmp48_ = lower_name;
													if (g_strcmp0 (_tmp48_, "round") == 0) {
														Number* _tmp49_;
														Number* _tmp50_ = NULL;
														_tmp49_ = x;
														_tmp50_ = number_round (_tmp49_);
														result = _tmp50_;
														_g_free0 (lower_name);
														return result;
													} else {
														const gchar* _tmp51_;
														_tmp51_ = lower_name;
														if (g_strcmp0 (_tmp51_, "re") == 0) {
															Number* _tmp52_;
															Number* _tmp53_ = NULL;
															_tmp52_ = x;
															_tmp53_ = number_real_component (_tmp52_);
															result = _tmp53_;
															_g_free0 (lower_name);
															return result;
														} else {
															const gchar* _tmp54_;
															_tmp54_ = lower_name;
															if (g_strcmp0 (_tmp54_, "im") == 0) {
																Number* _tmp55_;
																Number* _tmp56_ = NULL;
																_tmp55_ = x;
																_tmp56_ = number_imaginary_component (_tmp55_);
																result = _tmp56_;
																_g_free0 (lower_name);
																return result;
															} else {
																const gchar* _tmp57_;
																_tmp57_ = lower_name;
																if (g_strcmp0 (_tmp57_, "sin") == 0) {
																	Number* _tmp58_;
																	Equation* _tmp59_;
																	AngleUnit _tmp60_;
																	Number* _tmp61_ = NULL;
																	_tmp58_ = x;
																	_tmp59_ = self->priv->equation;
																	_tmp60_ = _tmp59_->angle_units;
																	_tmp61_ = number_sin (_tmp58_, _tmp60_);
																	result = _tmp61_;
																	_g_free0 (lower_name);
																	return result;
																} else {
																	const gchar* _tmp62_;
																	_tmp62_ = lower_name;
																	if (g_strcmp0 (_tmp62_, "cos") == 0) {
																		Number* _tmp63_;
																		Equation* _tmp64_;
																		AngleUnit _tmp65_;
																		Number* _tmp66_ = NULL;
																		_tmp63_ = x;
																		_tmp64_ = self->priv->equation;
																		_tmp65_ = _tmp64_->angle_units;
																		_tmp66_ = number_cos (_tmp63_, _tmp65_);
																		result = _tmp66_;
																		_g_free0 (lower_name);
																		return result;
																	} else {
																		const gchar* _tmp67_;
																		_tmp67_ = lower_name;
																		if (g_strcmp0 (_tmp67_, "tan") == 0) {
																			Number* _tmp68_;
																			Equation* _tmp69_;
																			AngleUnit _tmp70_;
																			Number* _tmp71_ = NULL;
																			_tmp68_ = x;
																			_tmp69_ = self->priv->equation;
																			_tmp70_ = _tmp69_->angle_units;
																			_tmp71_ = number_tan (_tmp68_, _tmp70_);
																			result = _tmp71_;
																			_g_free0 (lower_name);
																			return result;
																		} else {
																			gboolean _tmp72_ = FALSE;
																			const gchar* _tmp73_;
																			gboolean _tmp75_;
																			_tmp73_ = lower_name;
																			if (g_strcmp0 (_tmp73_, "sin⁻¹") == 0) {
																				_tmp72_ = TRUE;
																			} else {
																				const gchar* _tmp74_;
																				_tmp74_ = lower_name;
																				_tmp72_ = g_strcmp0 (_tmp74_, "asin") == 0;
																			}
																			_tmp75_ = _tmp72_;
																			if (_tmp75_) {
																				Number* _tmp76_;
																				Equation* _tmp77_;
																				AngleUnit _tmp78_;
																				Number* _tmp79_ = NULL;
																				_tmp76_ = x;
																				_tmp77_ = self->priv->equation;
																				_tmp78_ = _tmp77_->angle_units;
																				_tmp79_ = number_asin (_tmp76_, _tmp78_);
																				result = _tmp79_;
																				_g_free0 (lower_name);
																				return result;
																			} else {
																				gboolean _tmp80_ = FALSE;
																				const gchar* _tmp81_;
																				gboolean _tmp83_;
																				_tmp81_ = lower_name;
																				if (g_strcmp0 (_tmp81_, "cos⁻¹") == 0) {
																					_tmp80_ = TRUE;
																				} else {
																					const gchar* _tmp82_;
																					_tmp82_ = lower_name;
																					_tmp80_ = g_strcmp0 (_tmp82_, "acos") == 0;
																				}
																				_tmp83_ = _tmp80_;
																				if (_tmp83_) {
																					Number* _tmp84_;
																					Equation* _tmp85_;
																					AngleUnit _tmp86_;
																					Number* _tmp87_ = NULL;
																					_tmp84_ = x;
																					_tmp85_ = self->priv->equation;
																					_tmp86_ = _tmp85_->angle_units;
																					_tmp87_ = number_acos (_tmp84_, _tmp86_);
																					result = _tmp87_;
																					_g_free0 (lower_name);
																					return result;
																				} else {
																					gboolean _tmp88_ = FALSE;
																					const gchar* _tmp89_;
																					gboolean _tmp91_;
																					_tmp89_ = lower_name;
																					if (g_strcmp0 (_tmp89_, "tan⁻¹") == 0) {
																						_tmp88_ = TRUE;
																					} else {
																						const gchar* _tmp90_;
																						_tmp90_ = lower_name;
																						_tmp88_ = g_strcmp0 (_tmp90_, "atan") == 0;
																					}
																					_tmp91_ = _tmp88_;
																					if (_tmp91_) {
																						Number* _tmp92_;
																						Equation* _tmp93_;
																						AngleUnit _tmp94_;
																						Number* _tmp95_ = NULL;
																						_tmp92_ = x;
																						_tmp93_ = self->priv->equation;
																						_tmp94_ = _tmp93_->angle_units;
																						_tmp95_ = number_atan (_tmp92_, _tmp94_);
																						result = _tmp95_;
																						_g_free0 (lower_name);
																						return result;
																					} else {
																						const gchar* _tmp96_;
																						_tmp96_ = lower_name;
																						if (g_strcmp0 (_tmp96_, "sinh") == 0) {
																							Number* _tmp97_;
																							Number* _tmp98_ = NULL;
																							_tmp97_ = x;
																							_tmp98_ = number_sinh (_tmp97_);
																							result = _tmp98_;
																							_g_free0 (lower_name);
																							return result;
																						} else {
																							const gchar* _tmp99_;
																							_tmp99_ = lower_name;
																							if (g_strcmp0 (_tmp99_, "cosh") == 0) {
																								Number* _tmp100_;
																								Number* _tmp101_ = NULL;
																								_tmp100_ = x;
																								_tmp101_ = number_cosh (_tmp100_);
																								result = _tmp101_;
																								_g_free0 (lower_name);
																								return result;
																							} else {
																								const gchar* _tmp102_;
																								_tmp102_ = lower_name;
																								if (g_strcmp0 (_tmp102_, "tanh") == 0) {
																									Number* _tmp103_;
																									Number* _tmp104_ = NULL;
																									_tmp103_ = x;
																									_tmp104_ = number_tanh (_tmp103_);
																									result = _tmp104_;
																									_g_free0 (lower_name);
																									return result;
																								} else {
																									gboolean _tmp105_ = FALSE;
																									const gchar* _tmp106_;
																									gboolean _tmp108_;
																									_tmp106_ = lower_name;
																									if (g_strcmp0 (_tmp106_, "sinh⁻¹") == 0) {
																										_tmp105_ = TRUE;
																									} else {
																										const gchar* _tmp107_;
																										_tmp107_ = lower_name;
																										_tmp105_ = g_strcmp0 (_tmp107_, "asinh") == 0;
																									}
																									_tmp108_ = _tmp105_;
																									if (_tmp108_) {
																										Number* _tmp109_;
																										Number* _tmp110_ = NULL;
																										_tmp109_ = x;
																										_tmp110_ = number_asinh (_tmp109_);
																										result = _tmp110_;
																										_g_free0 (lower_name);
																										return result;
																									} else {
																										gboolean _tmp111_ = FALSE;
																										const gchar* _tmp112_;
																										gboolean _tmp114_;
																										_tmp112_ = lower_name;
																										if (g_strcmp0 (_tmp112_, "cosh⁻¹") == 0) {
																											_tmp111_ = TRUE;
																										} else {
																											const gchar* _tmp113_;
																											_tmp113_ = lower_name;
																											_tmp111_ = g_strcmp0 (_tmp113_, "acosh") == 0;
																										}
																										_tmp114_ = _tmp111_;
																										if (_tmp114_) {
																											Number* _tmp115_;
																											Number* _tmp116_ = NULL;
																											_tmp115_ = x;
																											_tmp116_ = number_acosh (_tmp115_);
																											result = _tmp116_;
																											_g_free0 (lower_name);
																											return result;
																										} else {
																											gboolean _tmp117_ = FALSE;
																											const gchar* _tmp118_;
																											gboolean _tmp120_;
																											_tmp118_ = lower_name;
																											if (g_strcmp0 (_tmp118_, "tanh⁻¹") == 0) {
																												_tmp117_ = TRUE;
																											} else {
																												const gchar* _tmp119_;
																												_tmp119_ = lower_name;
																												_tmp117_ = g_strcmp0 (_tmp119_, "atanh") == 0;
																											}
																											_tmp120_ = _tmp117_;
																											if (_tmp120_) {
																												Number* _tmp121_;
																												Number* _tmp122_ = NULL;
																												_tmp121_ = x;
																												_tmp122_ = number_atanh (_tmp121_);
																												result = _tmp122_;
																												_g_free0 (lower_name);
																												return result;
																											} else {
																												const gchar* _tmp123_;
																												_tmp123_ = lower_name;
																												if (g_strcmp0 (_tmp123_, "ones") == 0) {
																													Number* _tmp124_;
																													Equation* _tmp125_;
																													gint _tmp126_;
																													Number* _tmp127_ = NULL;
																													_tmp124_ = x;
																													_tmp125_ = self->priv->equation;
																													_tmp126_ = _tmp125_->wordlen;
																													_tmp127_ = number_ones_complement (_tmp124_, _tmp126_);
																													result = _tmp127_;
																													_g_free0 (lower_name);
																													return result;
																												} else {
																													const gchar* _tmp128_;
																													_tmp128_ = lower_name;
																													if (g_strcmp0 (_tmp128_, "twos") == 0) {
																														Number* _tmp129_;
																														Equation* _tmp130_;
																														gint _tmp131_;
																														Number* _tmp132_ = NULL;
																														_tmp129_ = x;
																														_tmp130_ = self->priv->equation;
																														_tmp131_ = _tmp130_->wordlen;
																														_tmp132_ = number_twos_complement (_tmp129_, _tmp131_);
																														result = _tmp132_;
																														_g_free0 (lower_name);
																														return result;
																													} else {
																														Equation* _tmp133_;
																														const gchar* _tmp134_;
																														Number* _tmp135_;
																														Number* _tmp136_ = NULL;
																														_tmp133_ = self->priv->equation;
																														_tmp134_ = name;
																														_tmp135_ = x;
																														_tmp136_ = equation_get_function (_tmp133_, _tmp134_, _tmp135_);
																														result = _tmp136_;
																														_g_free0 (lower_name);
																														return result;
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (lower_name);
}


static Number* equation_parser_real_convert (Parser* base, Number* x, const gchar* x_units, const gchar* z_units) {
	EquationParser * self;
	Number* result = NULL;
	Equation* _tmp0_;
	Number* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	Number* _tmp4_ = NULL;
	self = (EquationParser*) base;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = x;
	_tmp2_ = x_units;
	_tmp3_ = z_units;
	_tmp4_ = equation_convert (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static void equation_parser_class_init (EquationParserClass * klass) {
	equation_parser_parent_class = g_type_class_peek_parent (klass);
	PARSER_CLASS (klass)->finalize = equation_parser_finalize;
	g_type_class_add_private (klass, sizeof (EquationParserPrivate));
	PARSER_CLASS (klass)->variable_is_defined = equation_parser_real_variable_is_defined;
	PARSER_CLASS (klass)->get_variable = equation_parser_real_get_variable;
	PARSER_CLASS (klass)->set_variable = equation_parser_real_set_variable;
	PARSER_CLASS (klass)->function_is_defined = equation_parser_real_function_is_defined;
	PARSER_CLASS (klass)->get_function = equation_parser_real_get_function;
	PARSER_CLASS (klass)->convert = equation_parser_real_convert;
}


static void equation_parser_instance_init (EquationParser * self) {
	self->priv = EQUATION_PARSER_GET_PRIVATE (self);
}


static void equation_parser_finalize (Parser* obj) {
	EquationParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EQUATION_PARSER, EquationParser);
	_equation_unref0 (self->priv->equation);
	PARSER_CLASS (equation_parser_parent_class)->finalize (obj);
}


GType equation_parser_get_type (void) {
	static volatile gsize equation_parser_type_id__volatile = 0;
	if (g_once_init_enter (&equation_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EquationParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) equation_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EquationParser), 0, (GInstanceInitFunc) equation_parser_instance_init, NULL };
		GType equation_parser_type_id;
		equation_parser_type_id = g_type_register_static (TYPE_PARSER, "EquationParser", &g_define_type_info, 0);
		g_once_init_leave (&equation_parser_type_id__volatile, equation_parser_type_id);
	}
	return equation_parser_type_id__volatile;
}



