;; Scheduling description for z16.
;;   Copyright (C) 2022-2023 Free Software Foundation, Inc.
;;   Contributed by Robin Dapp (rdapp@linux.ibm.com)

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 3, or (at your option) any later
;; version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_attr "z16_unit_fpd" ""
(cond [(eq_attr "mnemonic"
"ddb,
ddbr,
deb,
debr,
dxbr,
sqdb,
sqdbr,
sqeb,
sqebr,
sqxbr,
vfddb,
vfdsb,
vfsqdb,
vfsqsb,
wfddb,
wfdsb,
wfdxb,
wfsqdb,
wfsqxb"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_unit_fxa" ""
(cond [(eq_attr "mnemonic"
"a,
afi,
ag,
agf,
agfi,
agfr,
agh,
aghi,
aghik,
agr,
agrk,
ah,
ahi,
ahik,
ahy,
al,
alc,
alcg,
alcgr,
alcr,
alfi,
alg,
algf,
algfi,
algfr,
alghsik,
algr,
algrk,
alhsik,
alr,
alrk,
aly,
ar,
ark,
ay,
bras,
brasl,
etnd,
exrl,
flogr,
ic,
icm,
icmh,
icmy,
icy,
iihf,
iilf,
ipm,
la,
larl,
lay,
lb,
lbr,
lcgr,
lcr,
lgb,
lgbr,
lgf,
lgfi,
lgfr,
lgfrl,
lgh,
lghi,
lghr,
lghrl,
lgr,
lh,
lhi,
lhr,
lhrl,
lhy,
llcr,
llgcr,
llgfr,
llghr,
llgtr,
llhr,
llihf,
llihh,
llihl,
llilf,
llilh,
llill,
lngr,
lnr,
loc,
locg,
locghi,
locgr,
lochi,
locr,
lpgr,
lpr,
lr,
lrv,
lrvg,
lrvgr,
lrvh,
lrvr,
lt,
ltg,
ltgf,
ltgfr,
ltgr,
ltr,
m,
mfy,
mg,
mgh,
mghi,
mgrk,
mh,
mhi,
mhy,
ml,
mlg,
mlgr,
mlr,
mr,
ms,
msc,
msfi,
msg,
msgc,
msgf,
msgfi,
msgfr,
msgr,
msgrkc,
msr,
msrkc,
msy,
n,
ncgrk,
ncrk,
ng,
ngr,
ngrk,
nihf,
nihh,
nihl,
nilf,
nilh,
nill,
nngrk,
nnrk,
nogrk,
nork,
nr,
nrk,
nxgrk,
nxrk,
ny,
o,
ocgrk,
ocrk,
og,
ogr,
ogrk,
oihf,
oihh,
oihl,
oilf,
oilh,
oill,
or,
ork,
oy,
pfpo,
popcnt,
risbg,
risbgn,
rll,
rllg,
s,
selgr,
selr,
sg,
sgf,
sgfr,
sgh,
sgr,
sgrk,
sh,
shy,
sl,
slb,
slbg,
slbgr,
slbr,
slfi,
slg,
slgf,
slgfi,
slgfr,
slgr,
slgrk,
sll,
sllg,
sllk,
slr,
slrk,
sly,
sr,
sra,
srag,
srak,
srk,
srl,
srlg,
srlk,
sy,
x,
xg,
xgr,
xgrk,
xihf,
xilf,
xr,
xrk,
xy"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_unit_fxb" ""
(cond [(eq_attr "mnemonic"
"agsi,
algsi,
alsi,
asi,
b,
bc,
bcr,
bi,
br,
brcl,
c,
cfi,
cg,
cgf,
cgfi,
cgfr,
cgfrl,
cgh,
cghi,
cghrl,
cghsi,
cgit,
cgr,
cgrl,
cgrt,
ch,
chi,
chrl,
chsi,
chy,
cit,
cl,
clfhsi,
clfi,
clfit,
clg,
clgf,
clgfi,
clgfr,
clgfrl,
clghrl,
clghsi,
clgit,
clgr,
clgrl,
clgrt,
clgt,
clhhsi,
clhrl,
cli,
cliy,
clm,
clmy,
clr,
clrl,
clrt,
clt,
cly,
cr,
crl,
crt,
cy,
j,
jg,
laa,
laag,
lan,
lang,
lao,
laog,
lat,
lax,
laxg,
lcdfr,
ldgr,
ldr,
lgat,
lgdr,
lndfr,
lpdfr,
lzdr,
lzer,
mvghi,
mvhhi,
mvhi,
mvi,
mviy,
ni,
niy,
nop,
nopr,
ntstg,
oi,
oiy,
ppa,
st,
stc,
stcy,
std,
stdy,
ste,
stey,
stg,
stgrl,
sth,
sthrl,
sthy,
stoc,
stocg,
strl,
strv,
strvg,
strvh,
sty,
tend,
tm,
tmh,
tmhh,
tmhl,
tml,
tmlh,
tmll,
tmy,
vlgvb,
vlgvf,
vlgvg,
vlgvh,
vlr,
vlvgb,
vlvgf,
vlvgg,
vlvgh,
vlvgp,
vst,
vstbr,
vstbrf,
vstbrg,
vstbrh,
vstbrq,
vstebrf,
vstebrg,
vstef,
vsteg,
vsterf,
vsterg,
vsterh,
vstl,
vstrl,
vstrlr,
xi,
xiy"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_unit_fxd" ""
(cond [(eq_attr "mnemonic"
"dlgr,
dlr,
dr,
dsgfr,
dsgr"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_unit_lsu" ""
(cond [(eq_attr "mnemonic"
"a,
adb,
aeb,
ag,
agf,
agh,
agsi,
ah,
ahy,
al,
alc,
alcg,
alg,
algf,
algsi,
alsi,
aly,
asi,
ay,
c,
cdb,
ceb,
cg,
cgf,
cgfrl,
cgh,
cghrl,
cghsi,
cgrl,
ch,
chrl,
chsi,
chy,
cl,
clc,
clfhsi,
clg,
clgf,
clgfrl,
clghrl,
clghsi,
clgrl,
clgt,
clhhsi,
clhrl,
cli,
cliy,
clm,
clmy,
clrl,
clt,
cly,
crl,
cy,
ddb,
deb,
ear,
ic,
icm,
icmh,
icmy,
icy,
kdb,
keb,
l,
laa,
laag,
lan,
lang,
lao,
laog,
lat,
lax,
laxg,
lb,
lcbb,
ld,
lde,
ldeb,
ldy,
le,
ley,
lg,
lgat,
lgb,
lgf,
lgfrl,
lgh,
lghrl,
lgrl,
lh,
lhrl,
lhy,
llc,
llgc,
llgf,
llgfrl,
llgh,
llghrl,
llgt,
llh,
llhrl,
loc,
locg,
lrl,
lrv,
lrvg,
lrvh,
lt,
ltg,
ltgf,
ly,
m,
madb,
maeb,
mdb,
meeb,
mfy,
mg,
mgh,
mh,
mhy,
ml,
mlg,
ms,
msc,
msdb,
mseb,
msg,
msgc,
msgf,
msy,
mvghi,
mvhhi,
mvhi,
mvi,
mviy,
n,
ng,
ni,
niy,
ntstg,
ny,
o,
og,
oi,
oiy,
oy,
s,
sar,
sdb,
seb,
sfpc,
sg,
sgf,
sgh,
sh,
shy,
sl,
slb,
slbg,
slg,
slgf,
sly,
sqdb,
sqeb,
st,
stc,
stcy,
std,
stdy,
ste,
stey,
stg,
stgrl,
sth,
sthrl,
sthy,
stoc,
stocg,
strl,
strv,
strvg,
strvh,
sty,
sy,
tabort,
tm,
tmy,
vl,
vlbb,
vlbr,
vlbrf,
vlbrg,
vlbrh,
vlbrq,
vlbrrepf,
vlbrrepg,
vlbrreph,
vleb,
vlebrf,
vlebrg,
vlebrh,
vlef,
vleg,
vleh,
vlerf,
vlerg,
vlerh,
vll,
vllebrzf,
vllebrzg,
vllebrzh,
vllezb,
vllezf,
vllezg,
vllezh,
vllezlf,
vlrepb,
vlrepf,
vlrepg,
vlreph,
vlrl,
vlrlr,
vst,
vstbr,
vstbrf,
vstbrg,
vstbrh,
vstbrq,
vstebrf,
vstebrg,
vstef,
vsteg,
vsterf,
vsterg,
vsterh,
vstl,
vstrl,
vstrlr,
x,
xg,
xi,
xiy,
xy"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_unit_vfu" ""
(cond [(eq_attr "mnemonic"
"adb,
adbr,
adtr,
aeb,
aebr,
axbr,
axtr,
cdb,
cdbr,
cdtr,
ceb,
cebr,
cpsdr,
cxbr,
cxtr,
ddtr,
dxtr,
fidbr,
fidbra,
fidtr,
fiebr,
fiebra,
fixbr,
fixbra,
fixtr,
kdb,
kdbr,
kdtr,
keb,
kebr,
kxbr,
kxtr,
lcdbr,
lcebr,
lcxbr,
ldeb,
ldebr,
ldetr,
le,
ledbr,
ledtr,
ler,
ley,
lndbr,
lnebr,
lnxbr,
lpdbr,
lpebr,
lpxbr,
ltdbr,
ltdtr,
ltebr,
ltxbr,
ltxtr,
lxdb,
lxdbr,
lxdtr,
lxeb,
lxebr,
madb,
madbr,
maeb,
maebr,
mdb,
mdbr,
mdtr,
meeb,
meebr,
msdb,
msdbr,
mseb,
msebr,
mxbr,
mxtr,
sdb,
sdbr,
sdtr,
seb,
sebr,
sxbr,
sxtr,
tcdb,
tceb,
tcxb,
tdcdt,
tdcet,
tdcxt,
vab,
vaccb,
vacccq,
vaccf,
vaccg,
vacch,
vaccq,
vacq,
vaf,
vag,
vah,
vaq,
vavgb,
vavgf,
vavgg,
vavgh,
vavglb,
vavglf,
vavglg,
vavglh,
vbperm,
vcdgb,
vcdlgb,
vcefb,
vcelfb,
vceqb,
vceqbs,
vceqf,
vceqfs,
vceqg,
vceqgs,
vceqh,
vceqhs,
vcfeb,
vcfn,
vcgdb,
vchb,
vchbs,
vchf,
vchfs,
vchg,
vchgs,
vchh,
vchhs,
vchlb,
vchlbs,
vchlf,
vchlfs,
vchlg,
vchlgs,
vchlh,
vchlhs,
vcksm,
vclfeb,
vclfnh,
vclfnl,
vclgdb,
vclzb,
vclzf,
vclzg,
vclzh,
vcnf,
vcrnf,
vctzb,
vctzf,
vctzg,
vctzh,
verimb,
verimf,
verimg,
verimh,
verllb,
verllf,
verllg,
verllh,
verllvb,
verllvf,
verllvg,
verllvh,
veslb,
veslf,
veslg,
veslh,
veslvb,
veslvf,
veslvg,
veslvh,
vesrab,
vesraf,
vesrag,
vesrah,
vesravb,
vesravf,
vesravg,
vesravh,
vesrlb,
vesrlf,
vesrlg,
vesrlh,
vesrlvb,
vesrlvf,
vesrlvg,
vesrlvh,
vfadb,
vfasb,
vfcedb,
vfcedbs,
vfcesb,
vfcesbs,
vfchdb,
vfchdbs,
vfchedb,
vfchedbs,
vfchesb,
vfchesbs,
vfchsb,
vfchsbs,
vfeeb,
vfeef,
vfeeh,
vfeezbs,
vfeezfs,
vfeezhs,
vfeneb,
vfenef,
vfeneh,
vfenezb,
vfenezf,
vfenezh,
vfidb,
vfisb,
vfkedb,
vfkesb,
vfkhdb,
vfkhedb,
vfkhesb,
vfkhsb,
vflcdb,
vflcsb,
vflndb,
vflnsb,
vflpdb,
vflpsb,
vfmadb,
vfmasb,
vfmaxdb,
vfmaxsb,
vfmdb,
vfmindb,
vfminsb,
vfmsb,
vfmsdb,
vfmssb,
vfnmadb,
vfnmasb,
vfnmsdb,
vfnmssb,
vfsdb,
vfssb,
vftcidb,
vftcisb,
vgbm,
vgfmab,
vgfmaf,
vgfmag,
vgfmah,
vgfmb,
vgfmf,
vgfmg,
vgfmh,
vgm,
vgmb,
vgmf,
vgmg,
vgmh,
vistrb,
vistrbs,
vistrf,
vistrfs,
vistrh,
vistrhs,
vlcb,
vlcf,
vlcg,
vlch,
vldeb,
vleb,
vlebrf,
vlebrg,
vlebrh,
vledb,
vlef,
vleg,
vleh,
vleib,
vleif,
vleig,
vleih,
vlpb,
vlpf,
vlpg,
vlph,
vmaeb,
vmaef,
vmaeh,
vmahb,
vmahf,
vmahh,
vmalb,
vmaleb,
vmalef,
vmaleh,
vmalf,
vmalhb,
vmalhf,
vmalhh,
vmalhw,
vmalob,
vmalof,
vmaloh,
vmaob,
vmaof,
vmaoh,
vmeb,
vmef,
vmeh,
vmhb,
vmhf,
vmhh,
vmlb,
vmleb,
vmlef,
vmleh,
vmlf,
vmlhb,
vmlhf,
vmlhh,
vmlhw,
vmlob,
vmlof,
vmloh,
vmnb,
vmnf,
vmng,
vmnh,
vmnlb,
vmnlf,
vmnlg,
vmnlh,
vmob,
vmof,
vmoh,
vmrhb,
vmrhf,
vmrhg,
vmrhh,
vmrlb,
vmrlf,
vmrlg,
vmrlh,
vmslg,
vmxb,
vmxf,
vmxg,
vmxh,
vmxlb,
vmxlf,
vmxlg,
vmxlh,
vn,
vnc,
vnn,
vno,
vnot,
vnx,
vo,
voc,
vone,
vpdi,
vperm,
vpkf,
vpkg,
vpkh,
vpklsf,
vpklsfs,
vpklsg,
vpklsgs,
vpklsh,
vpklshs,
vpksf,
vpksfs,
vpksg,
vpksgs,
vpksh,
vpkshs,
vpopct,
vpopctb,
vpopctf,
vpopctg,
vpopcth,
vrepb,
vrepf,
vrepg,
vreph,
vrepi,
vrepib,
vrepif,
vrepig,
vrepih,
vsb,
vsbcbiq,
vsbiq,
vscbib,
vscbif,
vscbig,
vscbih,
vscbiq,
vsegb,
vsegf,
vsegh,
vsel,
vsf,
vsg,
vsh,
vsl,
vslb,
vsld,
vsldb,
vsq,
vsra,
vsrab,
vsrd,
vsrl,
vsrlb,
vsumb,
vsumgf,
vsumgh,
vsumh,
vsumqf,
vsumqg,
vtm,
vuphb,
vuphf,
vuphh,
vuplb,
vuplf,
vuplhb,
vuplhf,
vuplhh,
vuplhw,
vupllb,
vupllf,
vupllh,
vx,
vzero,
wcdgb,
wcdlgb,
wcefb,
wcelfb,
wcfeb,
wcgdb,
wclfeb,
wclgdb,
wfadb,
wfasb,
wfaxb,
wfcdb,
wfcedb,
wfcesb,
wfcexb,
wfcexbs,
wfchdb,
wfchedb,
wfchesb,
wfchexb,
wfchexbs,
wfchsb,
wfchxb,
wfchxbs,
wfcsb,
wfcxb,
wfidb,
wfisb,
wfixb,
wfkdb,
wfkedb,
wfkesb,
wfkexb,
wfkhdb,
wfkhedb,
wfkhesb,
wfkhexb,
wfkhsb,
wfkhxb,
wfksb,
wfkxb,
wflcdb,
wflcsb,
wflcxb,
wflld,
wflndb,
wflnsb,
wflnxb,
wflpdb,
wflpsb,
wflpxb,
wflrx,
wfmadb,
wfmasb,
wfmaxb,
wfmaxxb,
wfmdb,
wfminxb,
wfmsb,
wfmsdb,
wfmssb,
wfmsxb,
wfmxb,
wfnmaxb,
wfnmsxb,
wfsdb,
wfssb,
wfsxb,
wftcixb,
wldeb,
wledb"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_cracked" ""
(cond [(eq_attr "mnemonic"
"bas,
basr,
cdfbr,
cdftr,
cdgbr,
cdgtr,
cdlfbr,
cdlftr,
cdlgbr,
cdlgtr,
cefbr,
cegbr,
celfbr,
celgbr,
cfdbr,
cfebr,
cfxbr,
cgdbr,
cgdtr,
cgebr,
cgxbr,
cgxtr,
chhsi,
clfdbr,
clfdtr,
clfebr,
clfxbr,
clfxtr,
clgdbr,
clgdtr,
clgebr,
clgxbr,
clgxtr,
cs,
csg,
csy,
d,
efpc,
ex,
lcgfr,
lngfr,
lpgfr,
lpq,
lxr,
lzxr,
rxsbg,
stpq,
vgef,
vgeg,
vscef,
vsceg,
vsteb,
vstebrh,
vsteh"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_expanded" ""
(cond [(eq_attr "mnemonic"
"cds,
cdsg,
cdsy,
cxfbr,
cxftr,
cxgbr,
cxgtr,
cxlfbr,
cxlftr,
cxlgbr,
cxlgtr,
dl,
dlg,
dsg,
dsgf,
lam,
lm,
lmg,
lmy,
sldl,
srda,
srdl,
stam,
stm,
stmg,
stmy,
tbegin,
tbeginc"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_groupalone" ""
(cond [(eq_attr "mnemonic"
"alc,
alcg,
alcgr,
alcr,
axbr,
axtr,
clc,
cxbr,
cxtr,
dlgr,
dlr,
dr,
dsgfr,
dsgr,
dxbr,
dxtr,
fixbr,
fixbra,
fixtr,
flogr,
kxbr,
kxtr,
lcxbr,
lnxbr,
lpxbr,
ltxbr,
ltxtr,
lxdb,
lxdbr,
lxdtr,
lxeb,
lxebr,
m,
madb,
maeb,
maebr,
mfy,
mg,
mgrk,
ml,
mlg,
mlgr,
mlr,
mr,
msdb,
mseb,
msebr,
mvc,
mxbr,
mxtr,
nc,
oc,
ppa,
sfpc,
slb,
slbg,
slbgr,
slbr,
sqxbr,
sxbr,
sxtr,
tabort,
tcxb,
tdcxt,
tend,
xc"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_endgroup" ""
(cond [(eq_attr "mnemonic"
"bras,
brasl,
exrl,
ipm"
)
 (const_int 1)] (const_int 0)))

(define_attr "z16_groupoftwo" ""
(cond [(eq_attr "mnemonic"
"vacccq,
vacq,
vfmadb,
vfmasb,
vfmsdb,
vfmssb,
vfnmadb,
vfnmasb,
vfnmsdb,
vfnmssb,
vgfmab,
vgfmaf,
vgfmag,
vgfmah,
vmaeb,
vmaef,
vmaeh,
vmahb,
vmahf,
vmahh,
vmalb,
vmaleb,
vmalef,
vmaleh,
vmalf,
vmalhb,
vmalhf,
vmalhh,
vmalhw,
vmalob,
vmalof,
vmaloh,
vmaob,
vmaof,
vmaoh,
vmslg,
vperm,
vsbcbiq,
vsbiq,
vsel,
wfmadb,
wfmasb,
wfmaxb,
wfmsdb,
wfmssb,
wfmsxb,
wfnmaxb,
wfnmsxb"
)
 (const_int 1)] (const_int 0)))

(define_insn_reservation "z16_0" 0
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"a,
afi,
ag,
agfi,
aghi,
aghik,
agr,
agrk,
ahi,
ahik,
al,
alfi,
alg,
algf,
algfi,
algfr,
alghsik,
algr,
algrk,
alhsik,
alr,
alrk,
aly,
ar,
ark,
ay,
b,
bc,
bcr,
bi,
br,
bras,
brasl,
brcl,
c,
cfi,
cg,
cgfi,
cghi,
cghsi,
cgit,
cgr,
cgrl,
cgrt,
chi,
chsi,
cit,
cl,
clfhsi,
clfi,
clfit,
clg,
clgf,
clgfi,
clgfr,
clgfrl,
clghrl,
clghsi,
clgit,
clgr,
clgrl,
clgrt,
clgt,
clhhsi,
clhrl,
cli,
cliy,
clr,
clrl,
clrt,
clt,
cly,
cr,
crl,
crt,
cy,
etnd,
exrl,
ic,
icm,
icmh,
icmy,
icy,
iihf,
iilf,
j,
jg,
la,
larl,
lat,
lay,
lb,
lbr,
lcdfr,
lcgr,
lcr,
ldgr,
ldr,
lgat,
lgb,
lgbr,
lgf,
lgfi,
lgfr,
lgfrl,
lgh,
lghi,
lghr,
lghrl,
lgr,
lh,
lhi,
lhr,
lhrl,
lhy,
llcr,
llgcr,
llgfr,
llghr,
llgtr,
llhr,
llihf,
llihh,
llihl,
llilf,
llilh,
llill,
lndfr,
lngr,
lnr,
lpdfr,
lpgr,
lpr,
lr,
lrv,
lrvg,
lrvgr,
lrvh,
lrvr,
lt,
ltg,
ltgf,
ltgfr,
ltgr,
ltr,
lzdr,
lzer,
n,
ncgrk,
ncrk,
ng,
ngr,
ngrk,
nihf,
nihh,
nihl,
nilf,
nilh,
nill,
nngrk,
nnrk,
nogrk,
nop,
nopr,
nork,
nr,
nrk,
nxgrk,
nxrk,
ny,
o,
ocgrk,
ocrk,
og,
ogr,
ogrk,
oihf,
oihh,
oihl,
oilf,
oilh,
oill,
or,
ork,
oy,
pfpo,
risbg,
risbgn,
rll,
rllg,
rnsbg,
rosbg,
s,
sg,
sgr,
sgrk,
sl,
sldl,
slfi,
slg,
slgf,
slgfi,
slgfr,
slgr,
slgrk,
sll,
sllg,
sllk,
slr,
slrk,
sly,
sr,
sra,
srag,
srak,
srda,
srdl,
srk,
srl,
srlg,
srlk,
sy,
tm,
tmh,
tmhh,
tmhl,
tml,
tmlh,
tmll,
tmy,
vlr,
vlvgb,
vlvgf,
vlvgg,
vlvgh,
x,
xg,
xgr,
xgrk,
xihf,
xilf,
xr,
xrk,
xy"
)) "nothing")

(define_insn_reservation "z16_1" 1
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"agf,
agfr,
agh,
agsi,
ah,
ahy,
algsi,
alsi,
asi,
cgf,
cgfr,
cgfrl,
cgh,
cghrl,
ch,
chrl,
chy,
clm,
clmy,
cpsdr,
laa,
laag,
lan,
lang,
lao,
laog,
lax,
laxg,
le,
ler,
ley,
loc,
locg,
locghi,
locgr,
lochi,
locr,
mvghi,
mvhhi,
mvhi,
mvi,
mviy,
ni,
niy,
ntstg,
oi,
oiy,
selgr,
selr,
sgf,
sgfr,
sgh,
sh,
shy,
st,
stc,
stcy,
stg,
stgrl,
sth,
sthrl,
sthy,
stoc,
stocg,
strl,
strv,
strvg,
strvh,
sty,
vab,
vaccb,
vacccq,
vaccf,
vaccg,
vacch,
vaccq,
vacq,
vaf,
vag,
vah,
vaq,
vavgb,
vavgf,
vavgg,
vavgh,
vavglb,
vavglf,
vavglg,
vavglh,
vbperm,
vceqb,
vceqf,
vceqg,
vceqh,
vcfn,
vchb,
vchf,
vchg,
vchh,
vchlb,
vchlf,
vchlg,
vchlh,
vclfnh,
vclfnl,
vclzb,
vclzf,
vclzg,
vclzh,
vcnf,
vcrnf,
vctzb,
vctzf,
vctzg,
vctzh,
verimb,
verimf,
verimg,
verimh,
verllb,
verllf,
verllg,
verllh,
verllvb,
verllvf,
verllvg,
verllvh,
veslb,
veslf,
veslg,
veslh,
veslvb,
veslvf,
veslvg,
veslvh,
vesrab,
vesraf,
vesrag,
vesrah,
vesravb,
vesravf,
vesravg,
vesravh,
vesrlb,
vesrlf,
vesrlg,
vesrlh,
vesrlvb,
vesrlvf,
vesrlvg,
vesrlvh,
vfcedb,
vfcesb,
vfchdb,
vfchedb,
vfchesb,
vfchsb,
vfkedb,
vfkesb,
vfkhdb,
vfkhedb,
vfkhesb,
vfkhsb,
vflcdb,
vflcsb,
vflndb,
vflnsb,
vflpdb,
vflpsb,
vfmaxdb,
vfmaxsb,
vfmindb,
vfminsb,
vgbm,
vgm,
vgmb,
vgmf,
vgmg,
vgmh,
vlcb,
vlcf,
vlcg,
vlch,
vleb,
vlebrf,
vlebrg,
vlebrh,
vlef,
vleg,
vleh,
vleib,
vleif,
vleig,
vleih,
vlpb,
vlpf,
vlpg,
vlph,
vmnb,
vmnf,
vmng,
vmnh,
vmnlb,
vmnlf,
vmnlg,
vmnlh,
vmrhb,
vmrhf,
vmrhg,
vmrhh,
vmrlb,
vmrlf,
vmrlg,
vmrlh,
vmxb,
vmxf,
vmxg,
vmxh,
vmxlb,
vmxlf,
vmxlg,
vmxlh,
vn,
vnc,
vnn,
vno,
vnot,
vnx,
vo,
voc,
vone,
vpdi,
vperm,
vpkf,
vpkg,
vpkh,
vpklsf,
vpklsg,
vpklsh,
vpksf,
vpksg,
vpksh,
vpopct,
vpopctb,
vpopctf,
vpopctg,
vpopcth,
vrepb,
vrepf,
vrepg,
vreph,
vrepi,
vrepib,
vrepif,
vrepig,
vrepih,
vsb,
vsbcbiq,
vsbiq,
vscbib,
vscbif,
vscbig,
vscbih,
vscbiq,
vsegb,
vsegf,
vsegh,
vsel,
vsf,
vsg,
vsh,
vsl,
vslb,
vsld,
vsldb,
vsq,
vsra,
vsrab,
vsrd,
vsrl,
vsrlb,
vuphb,
vuphf,
vuphh,
vuplb,
vuplf,
vuplhb,
vuplhf,
vuplhh,
vuplhw,
vupllb,
vupllf,
vupllh,
vx,
vzero,
wfcedb,
wfcesb,
wfcexb,
wfchdb,
wfchedb,
wfchesb,
wfchexb,
wfchsb,
wfchxb,
wfkedb,
wfkesb,
wfkexb,
wfkhdb,
wfkhedb,
wfkhesb,
wfkhexb,
wfkhsb,
wfkhxb,
wflcdb,
wflcsb,
wflcxb,
wflndb,
wflnsb,
wflnxb,
wflpdb,
wflpsb,
wflpxb,
wfmaxxb,
wfminxb,
xi,
xiy"
)) "nothing")

(define_insn_reservation "z16_2" 2
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"cdb,
cdbr,
ceb,
cebr,
ear,
ipm,
kdb,
kdbr,
keb,
kebr,
l,
lcbb,
lcdbr,
lcebr,
ld,
lde,
ldy,
lg,
lgdr,
lgrl,
llc,
llgc,
llgf,
llgfrl,
llgh,
llghrl,
llgt,
llh,
llhrl,
lm,
lmg,
lmy,
lndbr,
lnebr,
lpdbr,
lpebr,
lrl,
ltdbr,
ltebr,
ly,
popcnt,
sar,
tcdb,
tceb,
vceqbs,
vceqfs,
vceqgs,
vceqhs,
vchbs,
vchfs,
vchgs,
vchhs,
vchlbs,
vchlfs,
vchlgs,
vchlhs,
vfcedbs,
vfcesbs,
vfchdbs,
vfchedbs,
vfchesbs,
vfchsbs,
vfeeb,
vfeef,
vfeeh,
vfeneb,
vfenef,
vfeneh,
vfenezb,
vfenezf,
vfenezh,
vftcidb,
vftcisb,
vistrb,
vistrf,
vistrh,
vlbrrepf,
vlbrrepg,
vlbrreph,
vlgvb,
vlgvf,
vlgvg,
vlgvh,
vllebrzf,
vllebrzg,
vllebrzh,
vllezb,
vllezf,
vllezg,
vllezh,
vllezlf,
vlrepb,
vlrepf,
vlrepg,
vlreph,
vlrl,
vlvgp,
vpklsfs,
vpklsgs,
vpklshs,
vpksfs,
vpksgs,
vpkshs,
wfcdb,
wfcexbs,
wfchexbs,
wfchxbs,
wfcsb,
wfcxb,
wfkdb,
wfksb,
wfkxb,
wftcixb"
)) "nothing")

(define_insn_reservation "z16_3" 3
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"cds,
cdsy,
mgh,
mghi,
mh,
mhi,
mhy,
std,
stdy,
ste,
stey,
vcksm,
vfeezbs,
vfeezfs,
vfeezhs,
vgfmab,
vgfmaf,
vgfmag,
vgfmah,
vgfmb,
vgfmf,
vgfmg,
vgfmh,
vistrbs,
vistrfs,
vistrhs,
vl,
vlbb,
vlbr,
vlbrf,
vlbrg,
vlbrh,
vlbrq,
vlerf,
vlerg,
vlerh,
vll,
vlrlr,
vmaeb,
vmaef,
vmaeh,
vmahb,
vmahf,
vmahh,
vmalb,
vmaleb,
vmalef,
vmaleh,
vmalf,
vmalhb,
vmalhf,
vmalhh,
vmalhw,
vmalob,
vmalof,
vmaloh,
vmaob,
vmaof,
vmaoh,
vmeb,
vmef,
vmeh,
vmhb,
vmhf,
vmhh,
vmlb,
vmleb,
vmlef,
vmleh,
vmlf,
vmlhb,
vmlhf,
vmlhh,
vmlhw,
vmlob,
vmlof,
vmloh,
vmob,
vmof,
vmoh,
vsumb,
vsumgf,
vsumgh,
vsumh,
vsumqf,
vsumqg,
vtm"
)) "nothing")

(define_insn_reservation "z16_4" 4
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"bas,
basr,
chhsi,
clc,
ex,
lam,
lcgfr,
lngfr,
lpgfr,
lxr,
lzxr,
ms,
msfi,
msgf,
msgfi,
msgfr,
msr,
msy,
mvc,
nc,
oc,
ppa,
rxsbg,
tabort,
tbegin,
tbeginc,
tend,
vst,
vstbr,
vstbrf,
vstbrg,
vstbrh,
vstbrq,
vstebrf,
vstebrg,
vstef,
vsteg,
vsterf,
vsterg,
vsterh,
vstl,
vstrl,
vstrlr,
xc"
)) "nothing")

(define_insn_reservation "z16_5" 5
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"adb,
adbr,
aeb,
aebr,
alc,
alcg,
alcgr,
alcr,
cs,
csg,
csy,
fidbr,
fidbra,
fiebr,
fiebra,
ldeb,
ldebr,
ledbr,
madbr,
mdb,
mdbr,
meeb,
meebr,
msc,
msdbr,
msrkc,
sdb,
sdbr,
seb,
sebr,
slb,
slbg,
slbgr,
slbr,
stm,
stmg,
stmy,
vcdgb,
vcdlgb,
vcefb,
vcelfb,
vcfeb,
vcgdb,
vclfeb,
vclgdb,
vfadb,
vfasb,
vfidb,
vfisb,
vfmadb,
vfmasb,
vfmdb,
vfmsb,
vfmsdb,
vfmssb,
vfnmadb,
vfnmasb,
vfnmsdb,
vfnmssb,
vfsdb,
vfssb,
vldeb,
vledb,
vmslg,
wcdgb,
wcdlgb,
wcefb,
wcelfb,
wcfeb,
wcgdb,
wclfeb,
wclgdb,
wfadb,
wfasb,
wfidb,
wfisb,
wflld,
wfmadb,
wfmasb,
wfmdb,
wfmsb,
wfmsdb,
wfmssb,
wfsdb,
wfssb,
wldeb,
wledb"
)) "nothing")

(define_insn_reservation "z16_6" 6
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"msg,
msgr,
sfpc"
)) "nothing")

(define_insn_reservation "z16_7" 7
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"adtr,
cdtr,
fidtr,
kdtr,
ldetr,
ltdtr,
msgc,
msgrkc,
sdtr,
tdcdt,
tdcet,
vgef,
vgeg"
)) "nothing")

(define_insn_reservation "z16_8" 8
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"cdsg,
flogr,
lpq,
stpq,
vsteb,
vstebrh,
vsteh"
)) "nothing")

(define_insn_reservation "z16_9" 9
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"cdfbr,
cdgbr,
cdlfbr,
cdlgbr,
cefbr,
cegbr,
celfbr,
celgbr,
cxfbr,
cxgbr,
cxlfbr,
cxlgbr,
m,
madb,
maeb,
maebr,
mfy,
ml,
mlr,
mr,
msdb,
mseb,
msebr,
stam,
wfaxb,
wfixb,
wflrx,
wfsxb"
)) "nothing")

(define_insn_reservation "z16_10" 10
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"lxdb,
lxdbr,
lxeb,
lxebr,
vscef,
vsceg"
)) "nothing")

(define_insn_reservation "z16_11" 11
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"cfdbr,
cfebr,
cgdbr,
cgebr,
clfdbr,
clfebr,
clgdbr,
clgebr,
mg,
mgrk,
mlg,
mlgr"
)) "nothing")

(define_insn_reservation "z16_12" 12
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"cxbr,
cxftr,
cxlftr,
cxtr,
kxbr,
kxtr,
tcxb,
tdcxt"
)) "nothing")

(define_insn_reservation "z16_13" 13
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"axbr,
axtr,
fixbr,
fixbra,
fixtr,
lcxbr,
lnxbr,
lpxbr,
ltxbr,
ltxtr,
lxdtr,
sxbr,
sxtr"
)) "nothing")

(define_insn_reservation "z16_14" 14
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"cfxbr,
cgxbr,
clfxbr,
clgxbr,
ledtr"
)) "nothing")

(define_insn_reservation "z16_16" 16
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"cdftr,
cdlftr"
)) "nothing")

(define_insn_reservation "z16_20" 20
  (and (eq_attr "cpu" "z16")
(eq_attr "mnemonic"
"cdgtr,
cdlgtr,
cgdtr,
cgxtr,
clfdtr,
clfxtr,
clgdtr,
clgxtr,
cxgtr,
cxlgtr,
d,
ddb,
ddbr,
ddtr,
deb,
debr,
dl,
dlg,
dlgr,
dlr,
dr,
dsg,
dsgf,
dsgfr,
dsgr,
dxbr,
dxtr,
efpc,
mdtr,
mxbr,
mxtr,
sqdb,
sqdbr,
sqeb,
sqebr,
sqxbr,
vfddb,
vfdsb,
vfsqdb,
vfsqsb,
wfddb,
wfdsb,
wfdxb,
wfmaxb,
wfmsxb,
wfmxb,
wfnmaxb,
wfnmsxb,
wfsqdb,
wfsqxb"
)) "nothing")

